/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.PowerDesigner;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.PowerDesigner.PDColumnWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDKeyWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDModelWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDPackageWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDTableWrapper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PowerDesignerManager {
    private static Logger logger = LoggerFactory.getLogger(PowerDesignerManager.class);

    public static PDModelWrapper loadPowerDesignerDefinitions(String string) throws Exception {
        PDModelWrapper pDModelWrapper = new PDModelWrapper();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
        document.getDocumentElement().normalize();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        String string2 = "/Model/RootObject/Children/Model/Packages/Package";
        XPathExpression xPathExpression = xPath.compile(string2);
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        Document document2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document2.createElement("Model");
        document2.appendChild(element);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node iterator = document2.importNode(node, true);
            element.appendChild(iterator);
        }
        XStream xStream = new XStream(new StaxDriver());
        xStream.processAnnotations(PDModelWrapper.class);
        xStream.processAnnotations(PDPackageWrapper.class);
        xStream.processAnnotations(PDTableWrapper.class);
        xStream.processAnnotations(PDColumnWrapper.class);
        xStream.processAnnotations(PDKeyWrapper.class);
        xStream.addImplicitCollection(PDModelWrapper.class, "Packages");
        xStream.ignoreUnknownElements();
        xStream.unmarshal(new DomReader(document2), pDModelWrapper);
        for (PDPackageWrapper pDPackageWrapper : pDModelWrapper.Packages) {
            if (pDPackageWrapper.Tables == null) continue;
            for (PDTableWrapper pDTableWrapper : pDPackageWrapper.Tables) {
                PDKeyWrapper pDKeyWrapper;
                if (!Util.isBlank(pDTableWrapper.PhysicalOptions)) {
                    pDTableWrapper.PhysicalOptions = pDTableWrapper.PhysicalOptions.toUpperCase().replaceAll("TABLESPACE", "").trim();
                }
                if ((pDKeyWrapper = pDTableWrapper.getPrimaryKey()) == null) continue;
                if (!Util.isBlank(pDKeyWrapper.PhysicalOptions)) {
                    String[] stringArray = Util.getColumns(pDKeyWrapper.PhysicalOptions.trim(), ' ');
                    pDKeyWrapper.PhysicalOptions = stringArray[stringArray.length - 1];
                }
                if (pDKeyWrapper.Columns == null) continue;
                for (PDColumnWrapper pDColumnWrapper : pDKeyWrapper.Columns) {
                    if (Util.isBlank(pDColumnWrapper.Ref)) continue;
                    for (PDColumnWrapper pDColumnWrapper2 : pDTableWrapper.Columns) {
                        if (!pDColumnWrapper2.Id.equalsIgnoreCase(pDColumnWrapper.Ref)) continue;
                        pDColumnWrapper2.isPK = true;
                    }
                }
            }
        }
        int n = 0;
        for (PDPackageWrapper pDPackageWrapper : pDModelWrapper.Packages) {
            if (pDPackageWrapper.Tables == null) continue;
            n += pDPackageWrapper.Tables.size();
        }
        logger.info("Loaded " + n + " Data Model table definitions from Power Designer model file: " + string);
        return pDModelWrapper;
    }

    public static PDModelWrapper mergePowerDesignerDefinitions(PDModelWrapper pDModelWrapper, PDModelWrapper pDModelWrapper2) {
        PDModelWrapper pDModelWrapper3 = new PDModelWrapper();
        for (PDPackageWrapper pDPackageWrapper : pDModelWrapper.Packages) {
            pDModelWrapper3.Packages.add(pDPackageWrapper);
        }
        for (PDPackageWrapper pDPackageWrapper : pDModelWrapper2.Packages) {
            pDModelWrapper3.Packages.add(pDPackageWrapper);
        }
        return pDModelWrapper3;
    }
}

