/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.Parameter;
import au.com.aemo.Pdr.Database.Engine.EngineProcessing;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import au.com.aemo.izpack.install.ManagerConfig;
import au.com.aemo.izpack.install.automatedInstallDataManager;
import au.com.aemo.izpack.install.customMessages;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Messages;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseTargetValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(DatabaseTargetValidator.class.getName());

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ConfigManager configManager = ConfigManager.getInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EngineProcessing engineProcessing = new EngineProcessing();
        DatabaseSchemaConfig databaseSchemaConfig = configManager.getConfig();
        boolean bl = false;
        logger.log(Level.CONFIG, "DatabaseTargetValidator: Starting connection check");
        try {
            hashMap.put("DATABASE_USER", installData.getVariable("user_db_user"));
            hashMap.put("DATABASE_PASSWORD", installData.getVariable("user_db_password"));
            String string = installData.getVariable("user_db_tablespace_directory");
            if (!Util.isBlank(string)) {
                hashMap.put("TABLESPACE_DIR", string);
                object4 = string.contains("/") ? "/" : "\\";
                hashMap.put("PATH_SEP", (String)object4);
            }
            databaseSchemaConfig.SchemaDataModelTables = object4 = installData.getVariable("user_schema_data_model_tables");
            databaseSchemaConfig.SchemaManagementTables = object3 = installData.getVariable("user_schema_management_tables");
            configManager.setScriptParams(hashMap);
            object2 = new ManagerConfig();
            object = ((ManagerConfig)object2).provider;
            bl = engineProcessing.validateTarget(databaseSchemaConfig, (DbProviderInt)object, hashMap, configManager.getInstallPackOptions());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "DatabaseTargetValidator: " + exception.getMessage(), exception);
            exception.printStackTrace();
            object4 = automatedInstallDataManager.getInstance();
            object3 = new customMessages();
            ((TreeMap)object3).put(this.getErrorMessageId(), exception.getMessage());
            object2 = ((automatedInstallDataManager)object4).getData().getMessages();
            object2.add((Messages)object3);
        }
        logger.log(Level.CONFIG, "DatabaseTargetValidator: Completed connection check");
        boolean bl2 = true;
        logger.log(Level.CONFIG, "DatabaseTargetValidator: Starting parameters check");
        if (bl) {
            try {
                object4 = new ManagerConfig();
                object3 = ((ManagerConfig)object4).provider;
                object2 = engineProcessing.identifyParameters(databaseSchemaConfig, (DbProviderInt)object3, hashMap);
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Parameter parameter = (Parameter)object.next();
                        if (hashMap.get(parameter.Name) != null) continue;
                        if (parameter.HasDefault) {
                            logger.log(Level.INFO, "Using default value for parameter [" + parameter.Name + "]");
                            continue;
                        }
                        logger.log(Level.SEVERE, "Detected missing parameter [" + parameter.Name + "]");
                        bl2 = false;
                    }
                }
                if (!bl2) {
                    throw new Exception("Detected missing parameters, aborting database package operation");
                }
            }
            catch (Exception exception) {
                bl2 = false;
                logger.log(Level.SEVERE, "DatabaseTargetValidator: " + exception.getMessage(), exception);
                object3 = automatedInstallDataManager.getInstance();
                object2 = new customMessages();
                ((TreeMap)object2).put(this.getErrorMessageId(), exception.getMessage());
                object = ((automatedInstallDataManager)object3).getData().getMessages();
                object.add((Messages)object2);
            }
            logger.log(Level.CONFIG, "DatabaseTargetValidator: Completed parameters check");
        }
        return bl && bl2 ? DataValidator.Status.OK : DataValidator.Status.ERROR;
    }

    @Override
    public String getErrorMessageId() {
        return "DatabaseTargetValidator.Error.Id";
    }

    @Override
    public String getWarningMessageId() {
        return "DatabaseTargetValidator.Warning.Id";
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

