/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.panels;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.LayoutHelper;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoTextPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private JTextArea textArea;
    private String info;

    public XInfoTextPanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources) {
        super(panel, installerFrame, gUIInstallData, resources);
        Serializable serializable;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JLabel jLabel = LabelFactory.create(this.getString("InfoPanel.info"), (Icon)installerFrame.getIcons().get("edit"), 11);
        LayoutHelper.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        this.add(jLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        String string = gUIInstallData.getVariable("XInfoPanel.font");
        if (string != null && string.length() > 0) {
            serializable = Font.decode(string);
            this.textArea.setFont((Font)serializable);
        }
        serializable = new JScrollPane(this.textArea);
        LayoutHelper.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 1.0, 0.9);
        gridBagConstraints.anchor = 10;
        gridBagLayout.addLayoutComponent((Component)serializable, gridBagConstraints);
        this.add((Component)serializable);
    }

    private void loadInfo() {
        Panel panel = this.getMetadata();
        String string = panel.getConfigurationOptionValue("PanelTextSource");
        String string2 = panel.getConfigurationOptionValue("PanelFileSource");
        String string3 = panel.getConfigurationOptionValue("ReviewVariable");
        if (string != null) {
            this.info = this.installData.getVariables().replace(string);
        } else if (string2 != null) {
            this.info = this.installData.getVariables().replace(string2);
            try {
                Path path = Paths.get(this.info, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    byte[] byArray = Files.readAllBytes(path);
                    this.info = new String(byArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string3 != null) {
            this.installData.setVariable(string3, "true");
        }
    }

    @Override
    public void panelActivate() {
        this.loadInfo();
        this.textArea.setText(this.info);
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
    }

    @Override
    public boolean isValidated() {
        return true;
    }
}

