/*==============================================================*/
/* Data Model:     AEMO Electricity Data Model v5.6.0.1 mySQL   */
/* Created on:     2025/10/09 17:16:43                          */
/*==============================================================*/


/*==============================================================*/
/* Table: ADG_DETAIL                                            */
/*==============================================================*/
create table ADG_DETAIL
(
   ADG_ID               varchar(20) not null  comment 'Identifies the Aggregate Dispatch Group',
   EFFECTIVEDATE        datetime not null  comment 'Effective calendar date of record',
   VERSION_DATETIME     datetime not null  comment 'Date and time of the version of Dispatchable Unit details',
   ADG_TYPE             varchar(20)  comment 'Conformance Type for the Aggregate Dispatch Group. One of the following: CAP, MIXED, TARGET',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table ADG_DETAIL comment 'Table for tracking evolving Aggregate Dispatch Group attribu';

alter table ADG_DETAIL
   add primary key (ADG_ID, EFFECTIVEDATE, VERSION_DATETIME);

/*==============================================================*/
/* Table: AGGREGATE_DISPATCH_GROUP                              */
/*==============================================================*/
create table AGGREGATE_DISPATCH_GROUP
(
   ADG_ID               varchar(20) not null  comment 'Aggregate Dispatch Group ID',
   COMMENTS             varchar(100)  comment 'A participant provided comment',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table AGGREGATE_DISPATCH_GROUP comment 'Entity allowing for compliance monitoring over grouped DUIDs';

alter table AGGREGATE_DISPATCH_GROUP
   add primary key (ADG_ID);

/*==============================================================*/
/* Table: ANCILLARY_RECOVERY_SPLIT                              */
/*==============================================================*/
create table ANCILLARY_RECOVERY_SPLIT
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar settlement date record becomes effective.',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of the record for the given date.',
   SERVICE              varchar(10) not null  comment 'Ancillary service name (e.g. AGC, FCASCOMP)',
   PAYMENTTYPE          varchar(20) not null  comment 'A payment type associated with the service (can be ENABLING, AVAILABILITY, USAGE, or COMPENSATION).',
   CUSTOMER_PORTION     numeric(8,5)  comment 'The percentage value of the recovery funded by market customers.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ACE_PORTION          numeric(18,8)  comment 'The percentage value of the recovery funded using the ACE MWh Values. This field is only used for Settlement post IESS rule effective date.'
);

alter table ANCILLARY_RECOVERY_SPLIT comment 'ANCILLARY_RECOVERY_SPLIT holds the actual customer portion f';

alter table ANCILLARY_RECOVERY_SPLIT
   add primary key (EFFECTIVEDATE, VERSIONNO, SERVICE, PAYMENTTYPE);

/*==============================================================*/
/* Index: ANCILLARY_RECOVERY_SPLIT_LCX                          */
/*==============================================================*/
create index ANCILLARY_RECOVERY_SPLIT_LCX on ANCILLARY_RECOVERY_SPLIT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: APCCOMP                                               */
/*==============================================================*/
create table APCCOMP
(
   APCID                varchar(10) not null  comment 'APC event identifier.',
   REGIONID             varchar(10)  comment 'Region',
   STARTDATE            datetime  comment 'Settlement start date',
   STARTPERIOD          numeric(3,0)  comment 'Settlement start period (1-48)',
   ENDDATE              datetime  comment 'Settlement end date',
   ENDPERIOD            numeric(3,0)  comment 'Settlement end period (1-48)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table APCCOMP comment 'APCCOMP is to set out Administered Price Cap (APC) compensat';

alter table APCCOMP
   add primary key (APCID);

/*==============================================================*/
/* Index: APCCOMP_LCX                                           */
/*==============================================================*/
create index APCCOMP_LCX on APCCOMP
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: APCCOMPAMOUNT                                         */
/*==============================================================*/
create table APCCOMPAMOUNT
(
   APCID                varchar(10) not null  comment 'APC Identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   PERIODID             numeric(6,0) not null  comment 'Offset from start date and period in APCCOMP table.',
   AMOUNT               numeric(15,5)  comment 'Compensation audit.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table APCCOMPAMOUNT comment 'APCCOMPAMOUNT shows the Administered Price Cap (APC) compens';

alter table APCCOMPAMOUNT
   add primary key (APCID, PARTICIPANTID, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: APCCOMPAMOUNT_LCX                                     */
/*==============================================================*/
create index APCCOMPAMOUNT_LCX on APCCOMPAMOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: APCCOMPAMOUNTTRK                                      */
/*==============================================================*/
create table APCCOMPAMOUNTTRK
(
   APCID                varchar(10) not null  comment 'APC Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   AUTHORISEDBY         varchar(10)  comment 'Authorised by',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table APCCOMPAMOUNTTRK comment 'APCCOMPAMOUNTTRK sets out the relevant Administered Price Ca';

alter table APCCOMPAMOUNTTRK
   add primary key (APCID, VERSIONNO);

/*==============================================================*/
/* Index: APCCOMPAMOUNTTRK_LCX                                  */
/*==============================================================*/
create index APCCOMPAMOUNTTRK_LCX on APCCOMPAMOUNTTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: APEVENT                                               */
/*==============================================================*/
create table APEVENT
(
   APEVENTID            numeric(22,0) not null  comment 'Unique identifier for this administered pricing event',
   EFFECTIVEFROMINTERVAL datetime  comment 'Date Time of the first Dispatch Interval to which the administered event applies',
   EFFECTIVETOINTERVAL  datetime  comment 'Date Time of the final Dispatch Interval to which the administered event applies',
   REASON               varchar(2000)  comment 'Description of the driver for the Event',
   STARTAUTHORISEDBY    varchar(15)  comment 'Authorising staff for start of AP event',
   STARTAUTHORISEDDATE  datetime  comment 'Date-Time start authorised',
   ENDAUTHORISEDBY      varchar(15)  comment 'Authorising staff for end of AP event',
   ENDAUTHORISEDDATE    datetime  comment 'Date Time end authorised',
   LASTCHANGED          datetime  comment 'Date-Time the record was last modified'
);

alter table APEVENT comment 'APEVENT is the driving data defining the existence and timef';

alter table APEVENT
   add primary key (APEVENTID);

/*==============================================================*/
/* Index: APEVENT_LCX                                           */
/*==============================================================*/
create index APEVENT_LCX on APEVENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: APEVENTREGION                                         */
/*==============================================================*/
create table APEVENTREGION
(
   APEVENTID            numeric(22,0) not null  comment 'Unique identifier for this administered pricing event',
   REGIONID             varchar(10) not null  comment 'Date-Time of the first Dispatch Interval to which the administered event applies',
   LASTCHANGED          datetime  comment 'Date Time of the final Dispatch Interval to which the administered event applies',
   ENERGYAPFLAG         numeric(1,0)  comment 'flag indicating if the apevent covers an energy AP',
   RAISE6SECAPFLAG      numeric(1,0)  comment 'flag indicating if the apevent covers a raise6sec AP',
   RAISE60SECAPFLAG     numeric(1,0)  comment 'flag indicating if the apevent covers a raise60sec AP',
   RAISE5MINAPFLAG      numeric(1,0)  comment 'flag indicating if the apevent covers a raise5min AP',
   RAISEREGAPFLAG       numeric(1,0)  comment 'flag indicating if the apevent covers a raisereg AP',
   LOWER6SECAPFLAG      numeric(1,0)  comment 'flag indicating if the apevent covers a lower6sec AP',
   LOWER60SECAPFLAG     numeric(1,0)  comment 'flag indicating if the apevent covers a lower60sec AP
             flag indicating if the apevent covers a lower5min AP
             flag indicating if the apevent covers a lowerreg AP
             flag indicating if the apevent covers a lower60sec AP',
   LOWER5MINAPFLAG      numeric(1,0)  comment 'flag indicating if the apevent covers a lower5min AP',
   LOWERREGAPFLAG       numeric(1,0)  comment 'flag indicating if the apevent covers a lowerreg AP',
   RAISE1SECAPFLAG      numeric(3,0)  comment 'Flag indicating if the APEvent covers a Raise1Sec AP',
   LOWER1SECAPFLAG      numeric(3,0)  comment 'Flag indicating if the APEvent covers a Lower1Sec AP'
);

alter table APEVENTREGION comment 'APEVENTREGION is the Region detail for an administered prici';

alter table APEVENTREGION
   add primary key (APEVENTID, REGIONID);

/*==============================================================*/
/* Index: APEVENTREGION_LCX                                     */
/*==============================================================*/
create index APEVENTREGION_LCX on APEVENTREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AREA                                                  */
/*==============================================================*/
create table AREA
(
   AREAID               varchar(10) not null  comment 'Area identifier',
   EFFECTIVEDATE        datetime not null  comment 'Calendar date from when this record set is effective.',
   VERSIONNO            numeric(3,0) not null  comment 'Version number for the same effectivedate.',
   AREA_NAME            varchar(20)  comment 'Area name',
   AREA_DESCRIPTION     varchar(200)  comment 'Area description',
   LASTCHANGED          datetime  comment 'Last date and time record changed.'
);

alter table AREA comment 'Table containing static metadata for the Areas, which are su';

alter table AREA
   add primary key (AREAID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Table: AUCTION                                               */
/*==============================================================*/
create table AUCTION
(
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date',
   AUCTIONDATE          datetime  comment 'Auction date',
   NOTIFYDATE           datetime  comment '',
   STARTDATE            datetime  comment 'Open date for bidding',
   ENDDATE              datetime  comment 'Close date for bidding',
   DESCRIPTION          varchar(100)  comment 'Description of an auction',
   AUTHORISEDDATE       datetime  comment '',
   AUTHORISEDBY         varchar(30)  comment '',
   LASTCHANGED          datetime  comment ''
);

alter table AUCTION comment 'AUCTION holds auction details. AUCTION is new in March 2003 ';

alter table AUCTION
   add primary key (AUCTIONID);

/*==============================================================*/
/* Index: AUCTION_LCX                                           */
/*==============================================================*/
create index AUCTION_LCX on AUCTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_CALENDAR                                      */
/*==============================================================*/
create table AUCTION_CALENDAR
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   STARTDATE            datetime  comment 'First day of SRA Contract Quarter expressed as Date',
   ENDDATE              datetime  comment 'Last day of SRA Contract Quarter expressed as Date',
   NOTIFYDATE           datetime  comment 'Default notification date',
   PAYMENTDATE          datetime  comment 'Date for payment by Participant',
   RECONCILIATIONDATE   datetime  comment 'Date of reconciliation for the quarter',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PRELIMPURCHASESTMTDATE datetime  comment 'The date the Prelim Purchase Statement is generated',
   PRELIMPROCEEDSSTMTDATE datetime  comment 'The date the Prelim Proceeds Statement is generated',
   FINALPURCHASESTMTDATE datetime  comment 'The date the Final Purchase Statement is generated',
   FINALPROCEEDSSTMTDATE datetime  comment 'The date the Final Proceeds Statement is generated'
);

alter table AUCTION_CALENDAR comment 'AUCTION_CALENDAR holds the definitions of each auction quart';

alter table AUCTION_CALENDAR
   add primary key (CONTRACTYEAR, QUARTER);

/*==============================================================*/
/* Index: AUCTION_CALENDAR_LCX                                  */
/*==============================================================*/
create index AUCTION_CALENDAR_LCX on AUCTION_CALENDAR
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_IC_ALLOCATIONS                                */
/*==============================================================*/
create table AUCTION_IC_ALLOCATIONS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data takes precedence',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector Identifier',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   MAXIMUMUNITS         numeric(5,0)  comment 'Number of units on the interconnector',
   PROPORTION           numeric(8,5)  comment 'Percentage of the total residue for each Unit',
   AUCTIONFEE           numeric(17,5)  comment 'Daily auction fee',
   CHANGEDATE           datetime  comment 'Authorisation date',
   CHANGEDBY            varchar(15)  comment 'Name of person authorising this data set',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AUCTIONFEE_SALES     numeric(18,8)  comment 'Fees for Cancelled Units.'
);

alter table AUCTION_IC_ALLOCATIONS comment 'AUCTION_IC_ALLOCATIONS supports the Settlement Residue Aucti';

alter table AUCTION_IC_ALLOCATIONS
   add primary key (CONTRACTYEAR, QUARTER, VERSIONNO, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: AUCTION_IC_ALLOCATIONS_LCX                            */
/*==============================================================*/
create index AUCTION_IC_ALLOCATIONS_LCX on AUCTION_IC_ALLOCATIONS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_REVENUE_ESTIMATE                              */
/*==============================================================*/
create table AUCTION_REVENUE_ESTIMATE
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   VALUATIONID          varchar(15) not null  comment 'Identifier of the estimator',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data will take precedence',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   MONTHNO              numeric(1,0) not null  comment 'Month number within quarter (1..3)',
   STARTDATE            datetime  comment 'First day of month as date',
   ENDDATE              datetime  comment 'Last day of month as date',
   REVENUE              numeric(17,5)  comment 'Estimated Revenue',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table AUCTION_REVENUE_ESTIMATE comment 'AUCTION_REVENUE_ESTIMATE supports the Settlement Residue Auc';

alter table AUCTION_REVENUE_ESTIMATE
   add primary key (CONTRACTYEAR, QUARTER, VALUATIONID, VERSIONNO, INTERCONNECTORID, FROMREGIONID, MONTHNO);

/*==============================================================*/
/* Index: AUCTION_REVENUE_ESTIMATE_LCX                          */
/*==============================================================*/
create index AUCTION_REVENUE_ESTIMATE_LCX on AUCTION_REVENUE_ESTIMATE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_REVENUE_TRACK                                 */
/*==============================================================*/
create table AUCTION_REVENUE_TRACK
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   VALUATIONID          varchar(15) not null  comment 'Identifier of the estimator',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data takes precedence',
   EFFECTIVEDATE        datetime  comment 'Date from which the record change is applicable',
   STATUS               varchar(10)  comment 'Internal use',
   DOCUMENTREF          varchar(30)  comment 'Reference to methodology document',
   AUTHORISEDDATE       datetime  comment 'Date of authorisation for this record',
   AUTHORISEDBY         varchar(15)  comment 'Name of person authorising this record',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed'
);

alter table AUCTION_REVENUE_TRACK comment 'AUCTION_REVENUE_TRACK supports the Settlement Residue Auctio';

alter table AUCTION_REVENUE_TRACK
   add primary key (CONTRACTYEAR, QUARTER, VALUATIONID, VERSIONNO);

/*==============================================================*/
/* Index: AUCTIONREVTRK_NDX_LCHD                                */
/*==============================================================*/
create index AUCTIONREVTRK_NDX_LCHD on AUCTION_REVENUE_TRACK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_RP_ESTIMATE                                   */
/*==============================================================*/
create table AUCTION_RP_ESTIMATE
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   VALUATIONID          varchar(15) not null  comment 'Identifier of the estimator',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data takes precedence',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   RPESTIMATE           numeric(17,5)  comment 'Estimate of reserve price',
   LASTCHANGED          datetime  comment 'Last date and time record was changed'
);

alter table AUCTION_RP_ESTIMATE comment 'AUCTION_RP_ESTIMATE supports the Settlement Residue Auction,';

alter table AUCTION_RP_ESTIMATE
   add primary key (CONTRACTYEAR, QUARTER, VALUATIONID, VERSIONNO, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: AUCTION_RP_ESTIMATE_LCX                               */
/*==============================================================*/
create index AUCTION_RP_ESTIMATE_LCX on AUCTION_RP_ESTIMATE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AUCTION_TRANCHE                                       */
/*==============================================================*/
create table AUCTION_TRANCHE
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data will take precedence',
   TRANCHE              numeric(2,0) not null  comment 'Label identifying the arbitrary segmented share of the Interconnector flow',
   AUCTIONDATE          datetime  comment 'Default date of the auction',
   NOTIFYDATE           datetime  comment 'Default date participants notified of details',
   UNITALLOCATION       numeric(18,8)  comment 'Percentage of units allocated to the tranche',
   CHANGEDATE           datetime  comment 'Date of changing this record',
   CHANGEDBY            varchar(15)  comment 'Name of person who changed this record',
   LASTCHANGED          datetime  comment 'Date and time record was last changed'
);

alter table AUCTION_TRANCHE comment 'AUCTION_TRANCHE supports the Settlement Residue Auction, by ';

alter table AUCTION_TRANCHE
   add primary key (CONTRACTYEAR, QUARTER, VERSIONNO, TRANCHE);

/*==============================================================*/
/* Index: AUCTION_TRANCHE_LCX                                   */
/*==============================================================*/
create index AUCTION_TRANCHE_LCX on AUCTION_TRANCHE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: AVERAGEPRICE30                                        */
/*==============================================================*/
create table AVERAGEPRICE30
(
   PERIODDATE           datetime not null  comment '30-minute interval period, 1 to 48 from the start of the calendar day',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'The 30-minute interval period, 1 to 48',
   RRP                  numeric(15,5)  comment 'Regional reference price for this period',
   PRICE_CONFIDENCE     varchar(20)  comment 'Result of Manifestly Incorrect Inputs Price Status and OCD_Status - either "FIRM" or "NOT FIRM". Only FIRM if the Dispatch Interval is resolved for both MII and OCD',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table AVERAGEPRICE30 comment 'Reflects the 30-minute average price (the pre-5MS trading pr';

alter table AVERAGEPRICE30
   add primary key (PERIODDATE, REGIONID);

/*==============================================================*/
/* Table: BIDDAYOFFER                                           */
/*==============================================================*/
create table BIDDAYOFFER
(
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   SETTLEMENTDATE       datetime not null  comment 'Market date for applying the bid',
   OFFERDATE            datetime(3) not null  comment 'Time this bid was processed and loaded',
   DIRECTION            varchar(20) not null  comment 'The power flow direction to which this offer applies: GEN, LOAD or BIDIRECTIONAL',
   VERSIONNO            numeric(22,0)  comment 'Version No. for given offer date',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DAILYENERGYCONSTRAINT numeric(12,6)  comment 'Maximum energy available from Energy Constrained Plant. (Energy Bids Only)',
   REBIDEXPLANATION     varchar(500)  comment 'Explanation for all rebids and inflexibilities',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   MINIMUMLOAD          numeric(22,0)  comment 'Minimum MW load fast start plant',
   T1                   numeric(22,0)  comment 'Time to synchronise in minutes (Energy Bids Only)',
   T2                   numeric(22,0)  comment 'Time to minimum load in minutes (Energy Bids Only)',
   T3                   numeric(22,0)  comment 'Time at minimum load in minutes (Energy Bids Only)',
   T4                   numeric(22,0)  comment 'Time to shutdown in minutes (Energy Bids Only)',
   NORMALSTATUS         varchar(3)  comment 'not used; was ON/OFF for loads (Energy Bids Only)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_FACTOR            numeric(16,6)  comment 'Mandatory Restriction Offer Factor',
   ENTRYTYPE            varchar(20)  comment 'Daily if processed before BidCutOff of previous day, otherwise REBID',
   REBID_EVENT_TIME     varchar(20)  comment 'The time of the event(s) or other occurrence(s) cited/adduced as the reason for the rebid. Required for rebids, not required for fixed load or low ramp rates. Expected in the format: HH:MM:SS e.g. 20:11:00',
   REBID_AWARE_TIME     varchar(20)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. The time at which the participant became aware of the event(s) / occurrence(s) that prompted the rebid.Not validated by AEMO',
   REBID_DECISION_TIME  varchar(20)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. The time at which the participant made the decision to rebid. Not validated by AEMO',
   REBID_CATEGORY       varchar(1)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. A provided rebid category. Not validated by AEMO',
   REFERENCE_ID         varchar(100)  comment 'A participants unique Reference Id'
);

alter table BIDDAYOFFER comment 'BIDDAYOFFER shows the Energy and Ancillary Service bid data ';

alter table BIDDAYOFFER
   add primary key (SETTLEMENTDATE, BIDTYPE, DUID, OFFERDATE, DIRECTION);

/*==============================================================*/
/* Index: BIDDAYOFFER_LCHD_IDX                                  */
/*==============================================================*/
create index BIDDAYOFFER_LCHD_IDX on BIDDAYOFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BIDDAYOFFER_PART_IDX                                  */
/*==============================================================*/
create index BIDDAYOFFER_PART_IDX on BIDDAYOFFER
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BIDDAYOFFER_D                                         */
/*==============================================================*/
create table BIDDAYOFFER_D
(
   SETTLEMENTDATE       datetime not null  comment 'Market date for which the bid applied',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   DIRECTION            varchar(20) not null  comment 'The power flow direction to which this offer applies: GEN, LOAD or BIDIRECTIONAL',
   BIDSETTLEMENTDATE    datetime  comment 'Market date for which the bid was submitted.',
   OFFERDATE            datetime  comment 'Offer date and time',
   VERSIONNO            numeric(22,0)  comment 'Version No. for given offer date',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DAILYENERGYCONSTRAINT numeric(12,6)  comment 'Maximum energy available from Energy Constrained Plant. (Energy Bids Only)',
   REBIDEXPLANATION     varchar(500)  comment 'Explanation for all rebids and inflexibilities',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 7',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   MINIMUMLOAD          numeric(22,0)  comment 'Minimum MW load fast start plant',
   T1                   numeric(22,0)  comment 'Time to synchronise in minutes (Energy Bids Only)',
   T2                   numeric(22,0)  comment 'Time to minimum load in minutes (Energy Bids Only)',
   T3                   numeric(22,0)  comment 'Time at minimum load in minutes (Energy Bids Only)',
   T4                   numeric(22,0)  comment 'Time to shutdown in minutes (Energy Bids Only)',
   NORMALSTATUS         varchar(3)  comment 'ON/OFF for loads (Energy Bids Only)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_FACTOR            numeric(16,6)  comment 'Mandatory Restriction Scaling Factor',
   ENTRYTYPE            varchar(20)  comment 'Daily if processed before BidCutOff of previous day, otherwise REBID'
);

alter table BIDDAYOFFER_D comment 'BIDDAYOFFER_D shows the public summary of the energy and FCA';

alter table BIDDAYOFFER_D
   add primary key (SETTLEMENTDATE, BIDTYPE, DUID, DIRECTION);

/*==============================================================*/
/* Index: BIDDAYOFFER_D_LCHD_IDX                                */
/*==============================================================*/
create index BIDDAYOFFER_D_LCHD_IDX on BIDDAYOFFER_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BIDDAYOFFER_D_PART_IDX                                */
/*==============================================================*/
create index BIDDAYOFFER_D_PART_IDX on BIDDAYOFFER_D
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BIDDUIDDETAILS                                        */
/*==============================================================*/
create table BIDDUIDDETAILS
(
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date starting at 04:30 inclusive',
   VERSIONNO            numeric(3,0) not null  comment 'Record version number',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   MAXCAPACITY          numeric(22,0)  comment 'Maximum Capacity of this DUID for this BIDTYPE',
   MINENABLEMENTLEVEL   numeric(22,0)  comment 'Minimum Energy Output (MW) at which this ancillary service becomes available (AS Only)',
   MAXENABLEMENTLEVEL   numeric(22,0)  comment 'Maximum Energy Output (MW) at which this ancillary service can be supplied (AS Only)',
   MAXLOWERANGLE        numeric(3,0)  comment 'Maximum Angle at the lower end of the ancillary service profile (Degrees)',
   MAXUPPERANGLE        numeric(3,0)  comment 'Maximum Angle at the upper end of the ancillary service profile (Degrees)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BIDDUIDDETAILS comment 'BIDDUIDDETAILS and the associated tracking object BIDDUIDDET';

alter table BIDDUIDDETAILS
   add primary key (DUID, EFFECTIVEDATE, VERSIONNO, BIDTYPE);

/*==============================================================*/
/* Index: BIDDUIDDETAILS_LCHD_IDX                               */
/*==============================================================*/
create index BIDDUIDDETAILS_LCHD_IDX on BIDDUIDDETAILS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDDUIDDETAILSTRK                                     */
/*==============================================================*/
create table BIDDUIDDETAILSTRK
(
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date starting at 04:30 inclusive',
   VERSIONNO            numeric(3,0) not null  comment 'Record version number',
   AUTHORISEDDATE       datetime  comment 'Date of record authorisation. A NULL value indicates the record is not authorised.',
   AUTHORISEDBY         varchar(15)  comment 'User that authorised record. A NULL value indicates the record is not authorised.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BIDDUIDDETAILSTRK comment 'BIDDUIDDETAILSTRK shows the tracking for the associated obje';

alter table BIDDUIDDETAILSTRK
   add primary key (DUID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: BIDDUIDDETAILSTRK_LCHD_IDX                            */
/*==============================================================*/
create index BIDDUIDDETAILSTRK_LCHD_IDX on BIDDUIDDETAILSTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDOFFERFILETRK                                       */
/*==============================================================*/
create table BIDOFFERFILETRK
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   OFFERDATE            datetime(3) not null  comment 'Time this bid was processed and loaded',
   FILENAME             varchar(80) not null  comment 'Submitted file name',
   STATUS               varchar(10)  comment 'Load status [SUCCESSFUL/CORRUPT]',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AUTHORISEDBY         varchar(20)  comment 'Participant agent who created the Offer',
   AUTHORISEDDATE       datetime  comment 'When the Offer was processed - synonymous with LastChanged',
   TRANSACTION_ID       varchar(100)  comment 'A GUID used to identify the submission transaction in AEMOs systems',
   REFERENCE_ID         varchar(100)  comment 'A participant provided reference, which is required to be unique per submission (for a PARTICIPANTID)',
   SUBMISSION_TIMESTAMP datetime  comment 'The participant provided date/time for the submission',
   COMMENTS             varchar(1000)  comment 'A participant provided comment',
   SUBMISSION_METHOD    varchar(20)  comment 'Method by which this submission was made typically FTP, API, WEB'
);

alter table BIDOFFERFILETRK comment 'BIDOFFERFILETRK shows an audit trail of all files submitted ';

alter table BIDOFFERFILETRK
   add unique BIDOFFERFILETRK_FILE_UK (FILENAME);

alter table BIDOFFERFILETRK
   add primary key (PARTICIPANTID, OFFERDATE);

/*==============================================================*/
/* Index: BIDOFFERFILETRK_LCHD_IDX                              */
/*==============================================================*/
create index BIDOFFERFILETRK_LCHD_IDX on BIDOFFERFILETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDOFFERPERIOD                                        */
/*==============================================================*/
create table BIDOFFERPERIOD
(
   DUID                 varchar(20) not null  comment 'Dispatchable Unit ID',
   BIDTYPE              varchar(10) not null  comment 'The type of bid, one-of ENERGY, RAISE6SEC, RAISE60SEC, RAISE5MIN, RAISEREG, LOWER6SEC, LOWER60SEC, LOWER5MIN, LOWERREG',
   TRADINGDATE          datetime not null  comment 'The trading date this bid is for',
   OFFERDATETIME        datetime(3) not null  comment 'Time this bid was processed and loaded',
   DIRECTION            varchar(20) not null  comment 'The power flow direction to which this offer applies: GEN, LOAD or BIDIRECTIONAL',
   PERIODID             numeric(3,0) not null  comment 'Period ID 1 to 288',
   MAXAVAIL             numeric(8,3)  comment 'Maximum availability for this BidType in this period',
   FIXEDLOAD            numeric(8,3)  comment 'Fixed unit output MW (Energy bids only) A null value means no fixed load so the unit is dispatched according to bid and market',
   RAMPUPRATE           numeric(6,0)  comment 'MW/Min for raise (Energy bids only)',
   RAMPDOWNRATE         numeric(6,0)  comment 'MW/Min for lower (Energy bids only)',
   ENABLEMENTMIN        numeric(8,3)  comment 'Minimum Energy Output (MW) at which this ancillary service becomes available (AS Only)',
   ENABLEMENTMAX        numeric(8,3)  comment 'Maximum Energy Output (MW) at which this ancillary service can be supplied (AS Only)',
   LOWBREAKPOINT        numeric(8,3)  comment 'Minimum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   HIGHBREAKPOINT       numeric(8,3)  comment 'Maximum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   BANDAVAIL1           numeric(8,3)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(8,3)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(8,3)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(8,3)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(8,3)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(8,3)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(8,3)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(8,3)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(8,3)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(8,3)  comment 'Availability at price band 10',
   PASAAVAILABILITY     numeric(8,3)  comment 'Allows for future use for Energy bids, being the physical plant capability including any capability potentially available within 24 hours',
   ENERGYLIMIT          numeric(15,5)  comment 'The Energy limit applying at the end of this dispatch interval in MWh. For GEN this is a lower energy limit. For LOAD this is an upper energy limit',
   PERIODIDTO           numeric(3,0)  comment 'Period ID Ending',
   RECALL_PERIOD        numeric(8,3)  comment 'The advance notice(in hours) that a Scheduled Resource requires to achieve the PASA Availability MW for this trading interval'
);

alter table BIDOFFERPERIOD comment 'BIDOFFERPERIOD shows 5-minute period-based Energy and Ancill';

alter table BIDOFFERPERIOD
   add primary key (TRADINGDATE, BIDTYPE, DUID, OFFERDATETIME, DIRECTION, PERIODID);

/*==============================================================*/
/* Table: BIDPEROFFER                                           */
/*==============================================================*/
create table BIDPEROFFER
(
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   OFFERDATE            datetime not null  comment 'Offer date',
   PERIODID             numeric(22,0) not null  comment 'Period ID',
   VERSIONNO            numeric(22,0)  comment 'Version number of offer',
   MAXAVAIL             numeric(12,6)  comment 'Maximum availability for this BidType in this period',
   FIXEDLOAD            numeric(12,6)  comment 'Fixed unit output MW (Energy Bids Only)  A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   ROCUP                numeric(6,0)  comment 'MW/min for raise (Energy Bids Only)',
   ROCDOWN              numeric(6,0)  comment 'MW/Min for lower (Energy Bids Only)',
   ENABLEMENTMIN        numeric(6,0)  comment 'Minimum Energy Output (MW) at which this ancillary service becomes available (AS Only)',
   ENABLEMENTMAX        numeric(6,0)  comment 'Maximum Energy Output (MW) at which this ancillary service can be supplied (AS Only)',
   LOWBREAKPOINT        numeric(6,0)  comment 'Minimum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   HIGHBREAKPOINT       numeric(6,0)  comment 'Maximum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   BANDAVAIL1           numeric(22,0)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(22,0)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(22,0)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(22,0)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(22,0)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(22,0)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(22,0)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(22,0)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(22,0)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(22,0)  comment 'Availability at price band 10',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PASAAVAILABILITY     numeric(12,0)  comment 'Allows for future use for energy bids, being the physical plant capability including any capability potentially available within 24 hours',
   MR_CAPACITY          numeric(6,0)  comment 'Mandatory Restriction Offer amount'
);

alter table BIDPEROFFER comment 'BIDPEROFFER shows period-based Energy and Ancillary Service ';

alter table BIDPEROFFER
   add primary key (DUID, BIDTYPE, SETTLEMENTDATE, OFFERDATE, PERIODID);

/*==============================================================*/
/* Index: BIDPEROFFER_LCHD_IDX                                  */
/*==============================================================*/
create index BIDPEROFFER_LCHD_IDX on BIDPEROFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDPEROFFER_D                                         */
/*==============================================================*/
create table BIDPEROFFER_D
(
   SETTLEMENTDATE       datetime not null  comment 'Market date for which the bid applied',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   DIRECTION            varchar(20) not null  comment 'The power flow direction to which this offer applies: GEN, LOAD or BIDIRECTIONAL',
   INTERVAL_DATETIME    datetime not null  comment 'Date and Time of the dispatch interval to which the offer applied',
   BIDSETTLEMENTDATE    datetime  comment 'Market date for which the bid was submitted',
   OFFERDATE            datetime  comment 'Offer date and time',
   PERIODID             numeric(22,0)  comment 'The trading interval period identifier (1-288)',
   VERSIONNO            numeric(22,0)  comment 'Version number of offer',
   MAXAVAIL             numeric(12,6)  comment 'Maximum availability for this BidType in this period',
   FIXEDLOAD            numeric(12,6)  comment 'Fixed unit output MW (Energy Bids Only).  A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   ROCUP                numeric(6,0)  comment 'MW/min for raise (Energy Bids Only)',
   ROCDOWN              numeric(6,0)  comment 'MW/Min for lower (Energy Bids Only)',
   ENABLEMENTMIN        numeric(6,0)  comment 'Minimum Energy Output (MW) at which this ancillary service becomes available (AS Only)',
   ENABLEMENTMAX        numeric(6,0)  comment 'Maximum Energy Output (MW) at which this ancillary service can be supplied (AS Only)',
   LOWBREAKPOINT        numeric(6,0)  comment 'Minimum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   HIGHBREAKPOINT       numeric(6,0)  comment 'Maximum Energy Output (MW) at which the unit can provide the full availability (MAXAVAIL) for this ancillary service (AS Only)',
   BANDAVAIL1           numeric(22,0)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(22,0)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(22,0)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(22,0)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(22,0)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(22,0)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(22,0)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(22,0)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(22,0)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(22,0)  comment 'Availability at price band 10',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PASAAVAILABILITY     numeric(12,0)  comment 'Allows for future use for energy bids, being the physical plant capability including any capability potentially available within 24 hours',
   MR_CAPACITY          numeric(6,0)  comment 'Mandatory Restriction Offer amount',
   ENERGYLIMIT          numeric(15,5)  comment 'The Energy limit applying at the end of this dispatch interval in MWh. For GEN this is a lower energy limit. For LOAD this is an upper energy limit',
   RECALL_PERIOD        numeric(8,3)  comment 'The advance notice (in hours) that a Scheduled Resource requires to achieve the PASA Availability MW for this trading interval.'
);

alter table BIDPEROFFER_D comment 'BIDPEROFFER_D shows the public summary of the energy and FCA';

alter table BIDPEROFFER_D
   add primary key (SETTLEMENTDATE, BIDTYPE, DUID, DIRECTION, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: BIDPEROFFER_D_LCHD_IDX                                */
/*==============================================================*/
create index BIDPEROFFER_D_LCHD_IDX on BIDPEROFFER_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDTYPES                                              */
/*==============================================================*/
create table BIDTYPES
(
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date starting at 04:30 inclusive',
   VERSIONNO            numeric(3,0) not null  comment 'Record version number',
   DESCRIPTION          varchar(64)  comment 'Description of this Bid Type',
   NUMBEROFBANDS        numeric(3,0)  comment 'Number of active bands (1 to 10)',
   NUMDAYSAHEADPRICELOCKED numeric(2,0)  comment 'Number of days prior to the Market Day when prices are locked from 12:30pm',
   VALIDATIONRULE       varchar(10)  comment 'ENERGY or AS validation rules to apply.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SPDALIAS             varchar(10)  comment 'Alias for this BIDTYPE used in the SPD Solver'
);

alter table BIDTYPES comment 'BIDTYPES, together with the associated tracking data in BIDT';

alter table BIDTYPES
   add primary key (BIDTYPE, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: BIDTYPES_LCHD_IDX                                     */
/*==============================================================*/
create index BIDTYPES_LCHD_IDX on BIDTYPES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BIDTYPESTRK                                           */
/*==============================================================*/
create table BIDTYPESTRK
(
   EFFECTIVEDATE        datetime not null  comment 'Market date starting at 04:30 inclusive',
   VERSIONNO            numeric(3,0) not null  comment 'Record version number',
   AUTHORISEDDATE       datetime  comment 'Date of record authorisation. A NULL value indicates the record is not authorised.',
   AUTHORISEDBY         varchar(15)  comment 'User that authorised record. A NULL value indicates the record is not authorised.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BIDTYPESTRK comment 'BIDTYPESTRK, together with the associated data in BIDTYPES, ';

alter table BIDTYPESTRK
   add primary key (EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: BIDTYPESTRK_LCHD_IDX                                  */
/*==============================================================*/
create index BIDTYPESTRK_LCHD_IDX on BIDTYPESTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLADJUSTMENTS                                       */
/*==============================================================*/
create table BILLADJUSTMENTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment '',
   BILLRUNNO            numeric(3,0)  comment 'The sequential number of a billing run',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTTYPE      varchar(10)  comment 'Participant type Generator/Customer',
   ADJCONTRACTYEAR      numeric(4,0) not null  comment 'The contract year of the new revised billing run for this adjustment',
   ADJWEEKNO            numeric(3,0) not null  comment 'Week number of the new revised billing run for this adjustment',
   ADJBILLRUNNO         numeric(3,0) not null  comment 'Billing run number of the new revised billing run for this adjustment',
   PREVAMOUNT           numeric(16,6)  comment 'Prior account',
   ADJAMOUNT            numeric(16,6)  comment 'The total bill figure for the new revised billing run',
   LASTCHANGED          datetime  comment '',
   LRS                  numeric(15,5)  comment '',
   PRS                  numeric(15,5)  comment '',
   OFS                  numeric(15,5)  comment '',
   IRN                  numeric(15,5)  comment 'Interest rate applying to the new amount',
   IRP                  numeric(15,5)  comment 'Interest rate applying to the principal amount',
   INTERESTAMOUNT       numeric(15,5)  comment 'The total interest payable for this adjustment'
);

alter table BILLADJUSTMENTS
   add primary key (CONTRACTYEAR, WEEKNO, ADJCONTRACTYEAR, ADJWEEKNO, ADJBILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLADJUSTMENTS_NDX2                                  */
/*==============================================================*/
create index BILLADJUSTMENTS_NDX2 on BILLADJUSTMENTS
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: BILLADJUSTMENTS_LCX                                   */
/*==============================================================*/
create index BILLADJUSTMENTS_LCX on BILLADJUSTMENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGAPCCOMPENSATION                                */
/*==============================================================*/
create table BILLINGAPCCOMPENSATION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   APCCOMPENSATION      numeric(15,5)  comment 'APC Compensation',
   LASTCHANGED          datetime  comment 'Last changed date and time'
);

alter table BILLINGAPCCOMPENSATION comment 'BILLINGAPCCOMPENSATION shows Administered Price Cap (APC) co';

alter table BILLINGAPCCOMPENSATION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGAPCCOMPENSATION_LCX                            */
/*==============================================================*/
create index BILLINGAPCCOMPENSATION_LCX on BILLINGAPCCOMPENSATION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGAPCRECOVERY                                    */
/*==============================================================*/
create table BILLINGAPCRECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   APCRECOVERY          numeric(15,0)  comment 'APC Recovery amount for week',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGAPCRECOVERY comment 'BILLINGAPCRECOVERY shows the Administered Price Cap (APC) Re';

alter table BILLINGAPCRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGAPCRECOVERY_LCX                                */
/*==============================================================*/
create index BILLINGAPCRECOVERY_LCX on BILLINGAPCRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGASPAYMENTS                                     */
/*==============================================================*/
create table BILLINGASPAYMENTS
(
   REGIONID             varchar(10)  comment 'Region Identifier',
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Week No',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection point identifier',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 Sec Payments',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 Sec Payments',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 Sec Payments',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 Sec Payments',
   AGC                  numeric(15,5)  comment 'AGC Payments',
   FCASCOMP             numeric(15,5)  comment 'Frequency Control Compensation Payments',
   LOADSHED             numeric(15,5)  comment 'Load Shed Payments',
   RGUL                 numeric(15,5)  comment 'Rapid Generator unit Loading Payments',
   RGUU                 numeric(15,5)  comment 'Rapid Generator Unit Unloading Payments',
   REACTIVEPOWER        numeric(15,5)  comment 'Reactive Power Payments',
   SYSTEMRESTART        numeric(15,5)  comment 'System Restart Payments',
   LASTCHANGED          datetime  comment 'The latest date and time that a file was updated or inserted',
   LOWER5MIN            numeric(15,5)  comment 'Lower 5 Minute Payment',
   RAISE5MIN            numeric(15,5)  comment 'Raise 5 Minute Payment',
   LOWERREG             numeric(15,5)  comment 'Lower 5 Minute Regulation Payment',
   RAISEREG             numeric(15,5)  comment 'Raise 5 Minute Regulation Payment',
   AVAILABILITY_REACTIVE numeric(18,8)  comment 'The total availability payment',
   AVAILABILITY_REACTIVE_RBT numeric(18,8)  comment 'The total availability payment rebate',
   RAISE1SEC            numeric(18,8)  comment 'Payment amount for the very fast raise service',
   LOWER1SEC            numeric(18,8)  comment 'Payment amount for the very fast lower service'
);

alter table BILLINGASPAYMENTS comment 'BILLINGASPAYMENTS shows Ancillary Service payments for each ';

alter table BILLINGASPAYMENTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONNECTIONPOINTID);

/*==============================================================*/
/* Index: BILLINGASPAYMENTS_LCX                                 */
/*==============================================================*/
create index BILLINGASPAYMENTS_LCX on BILLINGASPAYMENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGASRECOVERY                                     */
/*==============================================================*/
create table BILLINGASRECOVERY
(
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Week No',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 Sec Recovery. NULL for Billing Week post the IESS rule effective date',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 Sec Recovery. NULL for Billing Week post the IESS rule effective date',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 Sec Recovery. NULL for Billing Week post the IESS rule effective date',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 Sec Recovery. NULL for Billing Week post the IESS rule effective date',
   AGC                  numeric(15,5)  comment 'AGC Recovery - Not used since circa 2000',
   FCASCOMP             numeric(15,5)  comment 'Frequency Control Compensation Recovery - Not used since circa 2000',
   LOADSHED             numeric(15,5)  comment 'Load Shed Recovery. Post-IESS the value in this column only represent the Testing Payment Recovery from Customers. 0 if no testing payment exists.',
   RGUL                 numeric(15,5)  comment 'Rapid Generator Unit Loading Recovery - Not used since December 2001',
   RGUU                 numeric(15,5)  comment 'Rapid Generator Unit Unloading Recovery - Not used since December 2001',
   REACTIVEPOWER        numeric(15,5)  comment 'Reactive Power Recovery. Post-IESS the value in this column only represent the Testing Payment Recovery from Customers. 0 if no testing payment exists.',
   SYSTEMRESTART        numeric(15,5)  comment 'System Restart Recovery. Post-IESS the value in this column only represent the Testing Payment Recovery from Customers. 0 if no testing payment exists',
   LASTCHANGED          datetime  comment 'The latest date and time a file was updated/inserted',
   RAISE6SEC_GEN        numeric(15,5)  comment 'Raise 6 Sec Recovery for Generator. NULL for Billing Week post the IESS rule effective date',
   LOWER6SEC_GEN        numeric(15,5)  comment 'Lower 6 Sec Recovery for Generator. NULL for Billing Week post the IESS rule effective date',
   RAISE60SEC_GEN       numeric(15,5)  comment 'Raise 60 Sec Recovery for Generator. NULL for Billing Week post the IESS rule effective date',
   LOWER60SEC_GEN       numeric(15,5)  comment 'Lower 60 Sec Recovery for Generator. NULL for Billing Week post the IESS rule effective date',
   AGC_GEN              numeric(15,5)  comment 'AGC Recovery for Generator',
   FCASCOMP_GEN         numeric(15,5)  comment 'Frequency Control Compensation Recovery for Generator',
   LOADSHED_GEN         numeric(15,5)  comment 'Load Shed Recovery for Generator. Post-IESS the value in this column only represent the Testing Payment Recovery from Generators. 0 if no testing payment exists.',
   RGUL_GEN             numeric(15,5)  comment 'Rapid Generator unit Loading Recovery for. Generator - Not used since December 2001',
   RGUU_GEN             numeric(15,5)  comment 'Rapid Generator Unit Unloading Recovery for Generator - Not used since December 2001',
   REACTIVEPOWER_GEN    numeric(15,5)  comment 'Reactive Power Recovery for Generator. Post-IESS the value in this column only represent the Testing Payment Recovery from Generators. 0 if no testing payment exists.',
   SYSTEMRESTART_GEN    numeric(15,5)  comment 'System Restart Recovery for Generator. Post-IESS the value in this column only represent the Testing Payment Recovery from Generators. 0 if no testing payment exists.',
   LOWER5MIN            numeric(15,5)  comment 'Recovery amount for the Lower 5 Minute service attributable to customer connection points. NULL for Billing Week post the IESS rule effective date',
   RAISE5MIN            numeric(15,5)  comment 'Recovery amount for the Raise 5 Minute service attributable to customer connection points. NULL for Billing Week post the IESS rule effective date',
   LOWERREG             numeric(18,8)  comment 'Post-IESS the amount in this column represent only the Lower Regulation FCAS MPF Recovery Amount from Customer and Generator Connection Point MPFs, no Residue Amounts are added to this column value. For Billing Weeks past FPP Rule Effective Date this column is not used. Always show 0.',
   RAISEREG             numeric(18,8)  comment 'Post-IESS the amount in this column represent only the Raise Regulation FCAS MPF Recovery Amount from Customer and Generator Connection Point MPFs, no Residue Amounts are added to this column value. For Billing Weeks past FPP Rule Effective Date this column is not used. Always show 0.',
   LOWER5MIN_GEN        numeric(16,6)  comment 'Recovery amount for the Lower 5 Minute service attributable to generator connection points. NULL for Billing Week post the IESS rule effective date',
   RAISE5MIN_GEN        numeric(16,6)  comment 'Recovery amount for the Raise 5 Minute service attributable to generator connection points. NULL for Billing Week post the IESS rule effective date',
   LOWERREG_GEN         numeric(16,6)  comment 'Recovery amount for the Lower Regulation service attributable to generator connection points. NULL for Billing Week post the IESS rule effective date',
   RAISEREG_GEN         numeric(16,6)  comment 'Recovery amount for the Raise Regulation service attributable to generator connection points. NULL for Billing Week post the IESS rule effective date. NULL for Billing Week post the IESS rule effective date.',
   AVAILABILITY_REACTIVE numeric(18,8)  comment 'The total availability payment recovery amount (customer).. NULL for Billing Week post the IESS rule effective date',
   AVAILABILITY_REACTIVE_RBT numeric(18,8)  comment 'The total availability payment rebate recovery amount (customer).. NULL for Billing Week post the IESS rule effective date',
   AVAILABILITY_REACTIVE_GEN numeric(18,8)  comment 'The total availability payment recovery amount (Generator).. NULL for Billing Week post the IESS rule effective date',
   AVAILABILITY_REACTIVE_RBT_GEN numeric(18,8)  comment 'The total availability payment rebate recovery amount (Generator).. NULL for Billing Week post the IESS rule effective date',
   RAISE1SEC            numeric(18,8)  comment 'Customer recovery amount for the very fast raise service. NULL for Billing Week post the IESS rule effective date',
   LOWER1SEC            numeric(18,8)  comment 'Customer recovery amount for the very fast lower service. NULL for Billing Week post the IESS rule effective date',
   RAISE1SEC_GEN        numeric(18,8)  comment 'Generator recovery amount for the very fast raise service. NULL for Billing Week post the IESS rule effective date',
   LOWER1SEC_GEN        numeric(18,8)  comment 'Generator recovery amount for the very fast lower service. NULL for Billing Week post the IESS rule effective date',
   LOWERREG_ACE         numeric(18,8)  comment 'The Lower Regulation FCAS Residue Recovery Amount using ACE MWh values. NULL for Billing Week prior to the IESS rule effective date',
   RAISEREG_ACE         numeric(18,8)  comment 'The Raise Regulation FCAS Residue Recovery Amount using ACE MWh values. NULL for Billing Week prior to the IESS rule effective date',
   RAISE1SEC_ACE        numeric(18,8)  comment 'The Raise1Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE1SEC_ASOE       numeric(18,8)  comment 'The Raise1Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER1SEC_ACE        numeric(18,8)  comment 'The Lower1Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER1SEC_ASOE       numeric(18,8)  comment 'The Lower1Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE6SEC_ACE        numeric(18,8)  comment 'The Raise6Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE6SEC_ASOE       numeric(18,8)  comment 'The Raise6Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER6SEC_ACE        numeric(18,8)  comment 'The Lower6Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER6SEC_ASOE       numeric(18,8)  comment 'The Lower6Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date value.',
   RAISE60SEC_ACE       numeric(18,8)  comment 'The Raise60Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE60SEC_ASOE      numeric(18,8)  comment 'The Raise60Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER60SEC_ACE       numeric(18,8)  comment 'The Lower60Sec FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER60SEC_ASOE      numeric(18,8)  comment 'The Lower60Sec FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE5MIN_ACE        numeric(18,8)  comment 'The Raise5Min FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   RAISE5MIN_ASOE       numeric(18,8)  comment 'The Raise5Min FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER5MIN_ACE        numeric(18,8)  comment 'The Lower5Min FCAS Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWER5MIN_ASOE       numeric(18,8)  comment 'The Lower5Min FCAS Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   REACTIVEPOWER_ACE    numeric(18,8)  comment 'The Reactive Power Ancillary Service Recovery Amount for for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   REACTIVEPOWER_ASOE   numeric(18,8)  comment 'The Reactive Power Ancillary Service Recovery Amount for for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOADSHED_ACE         numeric(18,8)  comment 'The Load Shed Ancillary Service Recovery Amount for for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOADSHED_ASOE        numeric(18,8)  comment 'The Load Shed Ancillary Service Recovery Amount for for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   SYSTEMRESTART_ACE    numeric(18,8)  comment 'The System Restart Ancillary Service Recovery Amount for for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   SYSTEMRESTART_ASOE   numeric(18,8)  comment 'The System Restart Ancillary Service Recovery Amount for for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date,',
   AVAILABILITY_REACTIVE_ACE numeric(18,8)  comment 'The Reactive Power Ancillary Service Availability Payment Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   AVAILABILITY_REACTIVE_ASOE numeric(18,8)  comment 'The Reactive Power Ancillary Service Availability Payment Recovery Amount for the Participant and Region from ASOE MWh Portion. For Pre-IESS Settlement dates this column will have NULL value. For Pre-IESS Settlement dates this column will have NULL value.',
   AVAILABILITY_REACTIVE_RBT_ACE numeric(18,8)  comment 'The Reactive Power Ancillary Service Availability Rebate Payment Recovery Amount for the Participant and Region from ACE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   AVAILABILITY_REACTIVE_RBT_ASOE numeric(18,8)  comment 'The Reactive Power Ancillary Service Availability Rebate Payment Recovery Amount for the Participant and Region from ASOE MWh Portion. NULL for Billing Week prior to the IESS rule effective date',
   LOWERREG_USED        numeric(18,8)  comment 'The FCAS Lower Reg Service Used Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_UNUSED      numeric(18,8)  comment 'The FCAS Lower Reg Service Unused Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_USED        numeric(18,8)  comment 'The FCAS Raise Reg Service Used Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_UNUSED      numeric(18,8)  comment 'The FCAS Raise Reg Service Unused Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_USED_ACE    numeric(18,8)  comment 'The FCAS Lower Reg Service Used ACE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_USED_ASOE   numeric(18,8)  comment 'The FCAS Lower Reg Service Used ASOE Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_USED_RESIDUAL numeric(18,8)  comment 'LOWERREG_USED_ACE + LOWERREG_USED_ASOE',
   RAISEREG_USED_ACE    numeric(18,8)  comment 'The FCAS Raise Reg Service Used ACE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_USED_ASOE   numeric(18,8)  comment 'The FCAS Raise Reg Service Used ASOE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_USED_RESIDUAL numeric(18,8)  comment 'RAISEREG_USED_ACE + RAISEREG_USED_ASOE',
   LOWERREG_UNUSED_ACE  numeric(18,8)  comment 'The FCAS Lower Reg Service Unused ACE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_UNUSED_ASOE numeric(18,8)  comment 'The FCAS Lower Reg Service Unused ASOE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   LOWERREG_UNUSED_RESIDUAL numeric(18,8)  comment 'LOWERREG_UNUSED_ACE + LOWERREG_UNUSED_ASOE',
   RAISEREG_UNUSED_ACE  numeric(18,8)  comment 'The FCAS Raise Reg Service Unused ACE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_UNUSED_ASOE numeric(18,8)  comment 'The FCAS Raise Reg Service Unused ASOE Residual Amount for the Billing Week. This column will be NULL for Billing Week Prior to FPP Rule Effective Date',
   RAISEREG_UNUSED_RESIDUAL numeric(18,8)  comment 'RAISEREG_UNUSED_ACE + RAISEREG_UNUSED_ASOE'
);

alter table BILLINGASRECOVERY comment 'BILLINGASRECOVERY shows participant charges for Ancillary Se';

alter table BILLINGASRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGASRECOVERY_LCX                                 */
/*==============================================================*/
create index BILLINGASRECOVERY_LCX on BILLINGASRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGCALENDAR                                       */
/*==============================================================*/
create table BILLINGCALENDAR
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   STARTDATE            datetime  comment 'Start Date of week',
   ENDDATE              datetime  comment 'End Date of week',
   PRELIMINARYSTATEMENTDATE datetime  comment 'Preliminary Statement Date',
   FINALSTATEMENTDATE   datetime  comment 'Final Statement Date',
   PAYMENTDATE          datetime  comment 'Payment Date',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REVISION1_STATEMENTDATE datetime  comment 'Revision 1 Statement Date for the billing week.',
   REVISION2_STATEMENTDATE datetime  comment 'Revision 2 Statement Date for the billing week.'
);

alter table BILLINGCALENDAR comment 'BILLINGCALENDAR sets out the billing calendar for the year, ';

alter table BILLINGCALENDAR
   add primary key (CONTRACTYEAR, WEEKNO);

/*==============================================================*/
/* Index: BILLINGCALENDAR_LCX                                   */
/*==============================================================*/
create index BILLINGCALENDAR_LCX on BILLINGCALENDAR
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGCPDATA                                         */
/*==============================================================*/
create table BILLINGCPDATA
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Unique connection point identifier',
   AGGREGATEENERGY      numeric(16,6)  comment 'Aggregate energy purchased/sold by customer, in MWh, plus UFEA. When GS commences, this includes the UFEA amount in the settlement runs.',
   PURCHASES            numeric(16,6)  comment 'The Purchase column has the dollar value of the Energy Purchased rather than Aggregate Energy Dollar',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MDA                  varchar(10) not null  comment 'relevant MDA for this connection point.',
   AFE                  numeric(18,8)  comment 'Adjusted Gross Energy for this Market Customer FRMP and TNI in the Billing run, excluding any UFEA component.',
   DME                  numeric(18,8)  comment 'Sum of ME- for all NMIs at this Market Customer FRMP and TNI in the Billing run.',
   UFEA                 numeric(18,8)  comment 'Share of UFE allocated to this FRMP and TNI in the Billing run.',
   AGE                  numeric(18,8)  comment 'Adjusted Gross Energy for this Market Customer FRMP and TNI in the trading interval. This will include the UFEA value once financial settlement of UFE commences with GS.',
   SOLDENERGY           numeric(18,8)  comment 'Energy sold at the connection point by the participant in this billing run',
   SALES                numeric(18,8)  comment 'The total cost of energy sold at the connection point by the participant in this billing run',
   PURCHASEDENERGY      numeric(18,8)  comment 'The energy consumed at the connection point by the participant in this billing run'
);

alter table BILLINGCPDATA comment 'BILLINGCPDATA shows energy quantity and $ value purchased pe';

alter table BILLINGCPDATA
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONNECTIONPOINTID, MDA);

/*==============================================================*/
/* Index: BILLINGCPDATA_NDX2                                    */
/*==============================================================*/
create index BILLINGCPDATA_NDX2 on BILLINGCPDATA
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: BILLINGCPDATA_LCX                                     */
/*==============================================================*/
create index BILLINGCPDATA_LCX on BILLINGCPDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGCPSUM                                          */
/*==============================================================*/
create table BILLINGCPSUM
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTTYPE      varchar(10) not null  comment 'Participant type Generator/Customer',
   PREVIOUSAMOUNT       numeric(16,6)  comment 'Previous amount billed',
   ADJUSTEDAMOUNT       numeric(16,6)  comment 'Adjusted amount billed',
   ADJUSTMENTWEEKNO     numeric(3,0)  comment 'Week no of adjustment',
   ADJUSTMENTRUNNO      numeric(3,0)  comment 'Run no of adjustment',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGCPSUM comment 'BILLINGCPSUM shows adjustments for a billing run by particip';

alter table BILLINGCPSUM
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, PARTICIPANTTYPE);

/*==============================================================*/
/* Index: BILLINGCPSUM_LCX                                      */
/*==============================================================*/
create index BILLINGCPSUM_LCX on BILLINGCPSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGCPSUM_NDX2                                     */
/*==============================================================*/
create index BILLINGCPSUM_NDX2 on BILLINGCPSUM
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BILLINGCUSTEXCESSGEN                                  */
/*==============================================================*/
create table BILLINGCUSTEXCESSGEN
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   PERIODID             numeric(3,0) not null  comment 'Half hourly trading period that excess generation is for',
   EXCESSGENPAYMENT     numeric(16,6)  comment 'Payment by Customer for Excess Generation',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10) not null  comment 'Region Identifier'
);

alter table BILLINGCUSTEXCESSGEN comment 'BILLINGCUSTEXCESSGEN shows excess generation payments for ea';

alter table BILLINGCUSTEXCESSGEN
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID, SETTLEMENTDATE, PERIODID);

/*==============================================================*/
/* Index: BILLINGCUSTEXCESSGEN_LCX                              */
/*==============================================================*/
create index BILLINGCUSTEXCESSGEN_LCX on BILLINGCUSTEXCESSGEN
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGDAYTRK                                         */
/*==============================================================*/
create table BILLINGDAYTRK
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date contained in the billing run.',
   RUNNO                numeric(3,0)  comment 'Settlement run number used for each settlement date in that billing run.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGDAYTRK comment 'BILLINGDAYTRK is key for matching settlement versions with b';

alter table BILLINGDAYTRK
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, SETTLEMENTDATE);

/*==============================================================*/
/* Index: BILLINGDAYTRK_LCX                                     */
/*==============================================================*/
create index BILLINGDAYTRK_LCX on BILLINGDAYTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGEXCESSGEN                                      */
/*==============================================================*/
create table BILLINGEXCESSGEN
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   SETTLEMENTDATE       datetime not null  comment 'Calendar settlement date record becomes effective',
   PERIODID             numeric(3,0) not null  comment 'Settlement interval within the settlement date (1-48) starting at 00:30',
   EXCESSENERGYCOST     numeric(15,5)  comment 'Cost of excess energy attributed to this customer',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10) not null  comment 'Region Identifier'
);

alter table BILLINGEXCESSGEN comment 'BILLINGEXCESSGEN shows the excess generation cost by period ';

alter table BILLINGEXCESSGEN
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID, SETTLEMENTDATE, PERIODID);

/*==============================================================*/
/* Index: BILLINGEXCESSGEN_LCX                                  */
/*==============================================================*/
create index BILLINGEXCESSGEN_LCX on BILLINGEXCESSGEN
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGEXCESSGEN_NDX2                                 */
/*==============================================================*/
create index BILLINGEXCESSGEN_NDX2 on BILLINGEXCESSGEN
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BILLINGFEES                                           */
/*==============================================================*/
create table BILLINGFEES
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETFEEID          varchar(10) not null  comment 'Market fee identifier',
   RATE                 numeric(15,5)  comment 'Market fee rate',
   ENERGY               numeric(16,6)  comment 'Energy, in MWh',
   VALUE                numeric(15,5)  comment 'Fee in $',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'The participant category pertaining to the market fee recovery. Corresponds to the PARTICIPANTCATEGORYID column of the SETMARKETFEES table.'
);

alter table BILLINGFEES comment 'BILLINGFEES presents pool fees applied to the statement, per';

alter table BILLINGFEES
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, MARKETFEEID, PARTICIPANTCATEGORYID);

/*==============================================================*/
/* Index: BILLINGFEES_LCX                                       */
/*==============================================================*/
create index BILLINGFEES_LCX on BILLINGFEES
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGFEES_NDX2                                      */
/*==============================================================*/
create index BILLINGFEES_NDX2 on BILLINGFEES
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BILLINGFINANCIALADJUSTMENTS                           */
/*==============================================================*/
create table BILLINGFINANCIALADJUSTMENTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTTYPE      varchar(10)  comment 'Not Used',
   ADJUSTMENTITEM       varchar(64) not null  comment 'Description of the adjustment being made',
   AMOUNT               numeric(15,5)  comment 'The amount of the manual adjustment line item',
   VALUE                numeric(15,5)  comment 'Not Used',
   LASTCHANGED          datetime  comment 'Last date and time the record changed.',
   FINANCIALCODE        numeric(10,0)  comment 'The GL financial code of the manual adjustment line item. Used internally by AEMO systems.',
   BAS_CLASS            varchar(30)  comment 'The BAS classification of the manual adjustment line item.'
);

alter table BILLINGFINANCIALADJUSTMENTS comment 'BILLINGFINANCIALADJUSTMENTS contains any manual adjustments ';

alter table BILLINGFINANCIALADJUSTMENTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, ADJUSTMENTITEM);

/*==============================================================*/
/* Index: BILLINGFINANCIALADJUSTMEN_LCX                         */
/*==============================================================*/
create index BILLINGFINANCIALADJUSTMEN_LCX on BILLINGFINANCIALADJUSTMENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGGENDATA                                        */
/*==============================================================*/
create table BILLINGGENDATA
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection point identifier',
   STATIONID            varchar(10)  comment 'not populated',
   DUID                 varchar(10)  comment 'not populated',
   AGGREGATEENERGY      numeric(16,6)  comment 'Aggregate energy sold, in MWh',
   SALES                numeric(16,6)  comment '$ income',
   PURCHASES            numeric(16,6)  comment '$ outgoing',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PURCHASEDENERGY      numeric(16,6)  comment 'Amount of energy purchased in MWh',
   MDA                  varchar(10)  comment 'Metering Data Agent supplying data'
);

alter table BILLINGGENDATA comment 'BILLINGGENDATA shows the total energy sold and purchased per';

alter table BILLINGGENDATA
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONNECTIONPOINTID);

/*==============================================================*/
/* Index: BILLINGGENDATA_LCX                                    */
/*==============================================================*/
create index BILLINGGENDATA_LCX on BILLINGGENDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGGENDATA_NDX2                                   */
/*==============================================================*/
create index BILLINGGENDATA_NDX2 on BILLINGGENDATA
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: BILLINGINTERRESIDUES                                  */
/*==============================================================*/
create table BILLINGINTERRESIDUES
(
   ALLOCATION           numeric(6,3)  comment 'May not be necessary',
   TOTALSURPLUS         numeric(15,5)  comment 'May not be necessary',
   INTERCONNECTORID     varchar(10) not null  comment 'Unique identifier for an interconnector which joins two regions.',
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   SURPLUSVALUE         numeric(15,6)  comment 'Amount NSP is paid for Inter-Regional Residues',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10) not null  comment 'Region ID'
);

alter table BILLINGINTERRESIDUES comment 'BILLINGINTERRESIDUES shows interregion residues payable to N';

alter table BILLINGINTERRESIDUES
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, INTERCONNECTORID, REGIONID);

/*==============================================================*/
/* Index: BILLINGINTERRESIDUES_LCX                              */
/*==============================================================*/
create index BILLINGINTERRESIDUES_LCX on BILLINGINTERRESIDUES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGINTERVENTION                                   */
/*==============================================================*/
create table BILLINGINTERVENTION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETINTERVENTION   numeric(15,5)  comment 'Intervention Amounts paid to Generator for Market Recovery for region',
   TOTALINTERVENTION    numeric(15,5)  comment 'Total Intervention Amounts paid to Generator',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGINTERVENTION comment 'BILLINGINTERVENTION shows billing intervention recovery deta';

alter table BILLINGINTERVENTION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGINTERVENTION_LCX                               */
/*==============================================================*/
create index BILLINGINTERVENTION_LCX on BILLINGINTERVENTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGINTERVENTIONREGION                             */
/*==============================================================*/
create table BILLINGINTERVENTIONREGION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REGIONID             varchar(10) not null  comment 'Region ID',
   REGIONINTERVENTION   numeric(15,5)  comment 'Recovery amount for that region',
   LASTCHANGED          datetime  comment 'Last changed date'
);

alter table BILLINGINTERVENTIONREGION comment 'BILLINGINTERVENTIONREGION shows recovery charges for region ';

alter table BILLINGINTERVENTIONREGION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGINTERVENTIONREGION_LCX                         */
/*==============================================================*/
create index BILLINGINTERVENTIONREGION_LCX on BILLINGINTERVENTIONREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGINTRARESIDUES                                  */
/*==============================================================*/
create table BILLINGINTRARESIDUES
(
   ALLOCATION           numeric(6,3)  comment 'TNSP allocation',
   TOTALSURPLUS         numeric(15,5)  comment 'Total $ residue amount for the region',
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   SURPLUSVALUE         numeric(15,6)  comment 'Amount TNSP is paid for Intra-Regional Residues',
   LASTCHANGED          datetime  comment 'Last changed date',
   REGIONID             varchar(10) not null  comment 'Region ID'
);

alter table BILLINGINTRARESIDUES comment 'BILLINGINTRARESIDUES shows intra-region settlement residue d';

alter table BILLINGINTRARESIDUES
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGINTRARESIDUES_LCX                              */
/*==============================================================*/
create index BILLINGINTRARESIDUES_LCX on BILLINGINTRARESIDUES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRAUCSURPLUS                                   */
/*==============================================================*/
create table BILLINGIRAUCSURPLUS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year (calendar year)',
   WEEKNO               numeric(2,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0)  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0)  comment 'Residue Contract Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALRESIDUES        numeric(15,5)  comment 'Total residues allocated to participant',
   ADJUSTMENT           numeric(15,5)  comment 'Adjustment allocated to participant',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified'
);

alter table BILLINGIRAUCSURPLUS comment 'BILLINGIRAUCSURPLUS supports the Settlements Residue Auction';

alter table BILLINGIRAUCSURPLUS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRAUCSURPLUS_IDX_LC                            */
/*==============================================================*/
create index BILLINGIRAUCSURPLUS_IDX_LC on BILLINGIRAUCSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRAUCSURPLUSSUM                                */
/*==============================================================*/
create table BILLINGIRAUCSURPLUSSUM
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contracted Year (calendar year)',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0) not null  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0) not null  comment 'Residue Contract Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   TOTALSURPLUS         numeric(15,5)  comment 'Total residue amount allocated to participant',
   AUCTIONFEES          numeric(15,5)  comment 'Total auction fees payable in this week (negative amount). If AUCTIONFEES + AUCTIONFEES_GST >= TOTALSURPLUS then ACTUALPAYMENT is zero',
   ACTUALPAYMENT        numeric(15,5)  comment 'Net payment to participant, including auction fees',
   AUCTIONFEES_GST      numeric(15,5)  comment 'The GST amount on the auction fees, always being zero.',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA.',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP.',
   NEGATIVE_RESIDUES    numeric(18,8)  comment 'Negative residues in the billing week for this participant in the SRA Year/Quarter'
);

alter table BILLINGIRAUCSURPLUSSUM comment 'BILLINGIRAUCSURPLUSSUM contains Auction fees and Settlements';

alter table BILLINGIRAUCSURPLUSSUM
   add primary key (CONTRACTYEAR, WEEKNO, RESIDUEYEAR, QUARTER, BILLRUNNO, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRAUCSURPSUM_LCX                               */
/*==============================================================*/
create index BILLINGIRAUCSURPSUM_LCX on BILLINGIRAUCSURPLUSSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRFM                                           */
/*==============================================================*/
create table BILLINGIRFM
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Settlement Year',
   WEEKNO               numeric(3,0) not null  comment 'Week number starting 1 Jan each year.',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique bill run',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   IRFMPAYMENT          numeric(15,5)  comment 'Industrial Relations Forced Majeure payment for the billing period.',
   LASTCHANGED          datetime  comment 'Last changed.'
);

alter table BILLINGIRFM comment 'BILLINGIRFM shows billing amounts associated with Industrial';

alter table BILLINGIRFM
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRFM_LCX                                       */
/*==============================================================*/
create index BILLINGIRFM_LCX on BILLINGIRFM
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRNSPSURPLUS                                   */
/*==============================================================*/
create table BILLINGIRNSPSURPLUS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(2,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0)  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0)  comment 'Residue Contract Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALRESIDUES        numeric(15,5)  comment 'Total residues allocated to participant',
   ADJUSTMENT           numeric(15,5)  comment 'Adjustment allocated to participant',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified'
);

alter table BILLINGIRNSPSURPLUS comment 'BILLINGIRNSPSURPLUS supports the Settlements Residue Auction';

alter table BILLINGIRNSPSURPLUS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRNSPSURPLUS_LCX                               */
/*==============================================================*/
create index BILLINGIRNSPSURPLUS_LCX on BILLINGIRNSPSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRNSPSURPLUSSUM                                */
/*==============================================================*/
create table BILLINGIRNSPSURPLUSSUM
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year (calendar year)',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0) not null  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0) not null  comment 'SRA Contracted Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   TOTALSURPLUS         numeric(15,5)  comment 'Total residue amount allocated to participant',
   AUCTIONFEES          numeric(15,5)  comment 'This field is 0.',
   AUCTIONFEES_GST      numeric(15,5)  comment 'The GST amount on the auction fees, always being zero.',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA.',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP.'
);

alter table BILLINGIRNSPSURPLUSSUM comment 'BILLINGIRNSPSURPLUSSUM contains derogated payments made to T';

alter table BILLINGIRNSPSURPLUSSUM
   add primary key (CONTRACTYEAR, WEEKNO, RESIDUEYEAR, QUARTER, BILLRUNNO, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRNSPSURPSUM_LCX                               */
/*==============================================================*/
create index BILLINGIRNSPSURPSUM_LCX on BILLINGIRNSPSURPLUSSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRPARTSURPLUS                                  */
/*==============================================================*/
create table BILLINGIRPARTSURPLUS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year (calendar year)',
   WEEKNO               numeric(2,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0)  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0)  comment 'Residue Contract Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALRESIDUES        numeric(15,5)  comment 'Total residues allocated to participant',
   ADJUSTMENT           numeric(15,5)  comment 'Adjustment allocated to participant',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   ACTUALPAYMENT        numeric(15,5)  comment 'Net actual payment to participant, including auction fees'
);

alter table BILLINGIRPARTSURPLUS comment 'BILLINGIRPARTSURPLUS supports the Settlements Residue Auctio';

alter table BILLINGIRPARTSURPLUS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRPARTSURPLUS_LCX                              */
/*==============================================================*/
create index BILLINGIRPARTSURPLUS_LCX on BILLINGIRPARTSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGIRPARTSURPLUSSUM                               */
/*==============================================================*/
create table BILLINGIRPARTSURPLUSSUM
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year (calendar year)',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   RESIDUEYEAR          numeric(4,0) not null  comment 'Year of the Residue Contract; may differ from the calendar year at week 1.',
   QUARTER              numeric(2,0) not null  comment 'Residue Contract Quarter',
   BILLRUNNO            numeric(3,0) not null  comment 'The sequential number of a billing run',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   TOTALSURPLUS         numeric(15,5)  comment 'Total residue amount allocated to participant',
   AUCTIONFEES          numeric(15,5)  comment 'Total auction fees payable in this week (negative amount). If AUCTIONFEES + AUCTIONFEES_GST >= TOTALSURPLUS then ACTUALPAYMENT is zero.',
   ACTUALPAYMENT        numeric(15,5)  comment 'Net payment to participant, including auction fees',
   AUCTIONFEES_GST      numeric(15,5)  comment 'The GST amount on the auction fees, always being zero.',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA.',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP.',
   AUCTIONFEES_TOTALGROSS_ADJ numeric(18,8)  comment 'The adjusted total Auction fees for the Directional Interconnector. Calculated as the amount of the total fees due from the SRA Auction Participant, pro-rated based on the total surplus for each Directional Interconnector the SRA Auction Participant contracted.'
);

alter table BILLINGIRPARTSURPLUSSUM comment 'BILLINGIRPARTSURPLUSSUM supports the Settlements Residue Auc';

alter table BILLINGIRPARTSURPLUSSUM
   add primary key (CONTRACTYEAR, WEEKNO, RESIDUEYEAR, QUARTER, BILLRUNNO, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGIRPARTSURPSUM_LCX                              */
/*==============================================================*/
create index BILLINGIRPARTSURPSUM_LCX on BILLINGIRPARTSURPLUSSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGIRPARTSURPLUSSUM_I01                           */
/*==============================================================*/
create index BILLINGIRPARTSURPLUSSUM_I01 on BILLINGIRPARTSURPLUSSUM
(
   RESIDUEYEAR,
   QUARTER
);

/*==============================================================*/
/* Table: BILLINGPRIORADJUSTMENTS                               */
/*==============================================================*/
create table BILLINGPRIORADJUSTMENTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Settlement year.',
   WEEKNO               numeric(3,0) not null  comment 'Settlement week number.',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number.',
   ADJCONTRACTYEAR      numeric(4,0) not null  comment 'ContractYear of the posted revision statement inserted to the Final Statement',
   ADJWEEKNO            numeric(3,0) not null  comment 'WeekNo of the posted revision statement inserted to the Final Statement',
   ADJBILLRUNNO         numeric(3,0) not null  comment 'Bill run number of the posted revision statement inserted to the Final Statement',
   PARTICIPANTID        varchar(10) not null  comment 'Participant ID',
   PREVAMOUNT           numeric(15,5)  comment 'Statement total of the previous posted revision statement inserted to the Final Statement.',
   ADJAMOUNT            numeric(15,5)  comment 'Adjusted amount.',
   IRN                  numeric(15,5)  comment 'Interest rate applied to the revision adjustment',
   IRP                  numeric(15,5)  comment 'unused; always null',
   INTERESTAMOUNT       numeric(15,5)  comment 'Interest amount.',
   LASTCHANGED          datetime  comment 'Last changed.',
   IRSR_PREVAMOUNT      numeric(15,5)  comment 'unused; always null',
   IRSR_ADJAMOUNT       numeric(15,5)  comment 'unused; always null',
   IRSR_INTERESTAMOUNT  numeric(15,5)  comment 'unused; always null'
);

alter table BILLINGPRIORADJUSTMENTS comment 'BILLINGPRIORADJUSTMENTS sets out prior period adjustments an';

alter table BILLINGPRIORADJUSTMENTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, ADJCONTRACTYEAR, ADJWEEKNO, ADJBILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGPRIORADJUSTMENTS_NDX2                          */
/*==============================================================*/
create index BILLINGPRIORADJUSTMENTS_NDX2 on BILLINGPRIORADJUSTMENTS
(
   PARTICIPANTID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: BILLINGPRIORADJMNTS_NDX_LCHD                          */
/*==============================================================*/
create index BILLINGPRIORADJMNTS_NDX_LCHD on BILLINGPRIORADJUSTMENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGREALLOC                                        */
/*==============================================================*/
create table BILLINGREALLOC
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   COUNTERPARTY         varchar(10) not null  comment 'Participant who is the counter party to this contract',
   VALUE                numeric(15,5)  comment 'Value billed on this contract',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGREALLOC comment 'BILLINGREALLOC shows reallocation contract values in each bi';

alter table BILLINGREALLOC
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, COUNTERPARTY);

/*==============================================================*/
/* Index: BILLINGREALLOC_NDX2                                   */
/*==============================================================*/
create index BILLINGREALLOC_NDX2 on BILLINGREALLOC
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: BILLINGREALLOC_LCX                                    */
/*==============================================================*/
create index BILLINGREALLOC_LCX on BILLINGREALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGREALLOC_DETAIL                                 */
/*==============================================================*/
create table BILLINGREALLOC_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'BILLING CONTRACTYEAR',
   WEEKNO               numeric(3,0) not null  comment 'BILLING WEEKNO',
   BILLRUNNO            numeric(3,0) not null  comment 'BILLING RUN NO',
   PARTICIPANTID        varchar(10) not null  comment 'REALLOCATION PARTICIPANTID',
   COUNTERPARTY         varchar(10) not null  comment 'REALLOCATION COUNTERPARTY PARTICIPANTID',
   REALLOCATIONID       varchar(20) not null  comment 'REALLOCATIONID',
   VALUE                numeric(15,5)  comment 'REALLOCATION VALUE',
   LASTCHANGED          datetime  comment 'DATETIME WHEN RECORD SAVED'
);

alter table BILLINGREALLOC_DETAIL comment 'Billing Reallocation Data aggregated by REALLOCATIONID for e';

alter table BILLINGREALLOC_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, COUNTERPARTY, REALLOCATIONID);

/*==============================================================*/
/* Index: BILLINGREALLOC_DETAIL_LCX                             */
/*==============================================================*/
create index BILLINGREALLOC_DETAIL_LCX on BILLINGREALLOC_DETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGREGIONEXPORTS                                  */
/*==============================================================*/
create table BILLINGREGIONEXPORTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   EXPORTTO             varchar(10) not null  comment 'Region exported to',
   ENERGY               numeric(16,6)  comment 'MWh Energy value exported',
   VALUE                numeric(15,5)  comment '$ Value of energy exported',
   SURPLUSENERGY        numeric(16,6)  comment 'This field is populated with 0',
   SURPLUSVALUE         numeric(15,5)  comment '$ Interregional residue',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGREGIONEXPORTS comment 'BILLINGREGIONEXPORTS sets out the region summary table of ov';

alter table BILLINGREGIONEXPORTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, REGIONID, EXPORTTO);

/*==============================================================*/
/* Index: BILLINGREGIONEXPORTS_LCX                              */
/*==============================================================*/
create index BILLINGREGIONEXPORTS_LCX on BILLINGREGIONEXPORTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGREGIONFIGURES                                  */
/*==============================================================*/
create table BILLINGREGIONFIGURES
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   ENERGYOUT            numeric(16,6)  comment 'MWh Energy output in the region during the billing period',
   VALUEOUT             numeric(16,6)  comment '$ Value of energy output in region during billing period',
   ENERGYPURCHASED      numeric(16,6)  comment 'MWh Amount of energy purchased in region during billing period',
   VALUEPURCHASED       numeric(16,6)  comment '$ Value of energy purchased during billing period',
   EXCESSGEN            numeric(16,6)  comment 'This field is populated with 0',
   RESERVETRADING       numeric(16,6)  comment 'This field is populated with 0',
   INTCOMPO             numeric(16,6)  comment 'This field is populated with 0',
   ADMINPRICECOMPO      numeric(16,6)  comment 'This field is populated with 0',
   SETTSURPLUS          numeric(16,6)  comment 'Intraregional residues in $',
   ASPAYMENT            numeric(16,6)  comment 'Ancillary service payments in $',
   POOLFEES             numeric(16,6)  comment 'This field is populated with 0',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   WDRSQ                numeric(18,8)  comment 'WDR Settlement Quantity Capped in MWh',
   WDRTA                numeric(18,8)  comment 'WDR transaction amount in $'
);

alter table BILLINGREGIONFIGURES comment 'BILLINGREGIONFIGURES sets out additional summary region deta';

alter table BILLINGREGIONFIGURES
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, REGIONID);

/*==============================================================*/
/* Index: BILLINGREGIONFIGURES_LCX                              */
/*==============================================================*/
create index BILLINGREGIONFIGURES_LCX on BILLINGREGIONFIGURES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGREGIONIMPORTS                                  */
/*==============================================================*/
create table BILLINGREGIONIMPORTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   IMPORTFROM           varchar(10) not null  comment 'Region energy imported from',
   ENERGY               numeric(16,6)  comment 'Amount of energy imported',
   VALUE                numeric(15,5)  comment 'Value of energy imported',
   SURPLUSENERGY        numeric(16,6)  comment 'Populated with 0',
   SURPLUSVALUE         numeric(15,5)  comment 'Interregional residue',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGREGIONIMPORTS comment 'BILLINGREGIONIMPORTS sets out the region summary table of ov';

alter table BILLINGREGIONIMPORTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, REGIONID, IMPORTFROM);

/*==============================================================*/
/* Index: BILLINGREGIONIMPORTS_LCX                              */
/*==============================================================*/
create index BILLINGREGIONIMPORTS_LCX on BILLINGREGIONIMPORTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGRESERVERECOVERY                                */
/*==============================================================*/
create table BILLINGRESERVERECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETRESERVE        numeric(15,5)  comment 'Amount Retailer pays for Reserve Trader Contracts with Market Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGRESERVERECOVERY comment 'BILLINGRESERVERECOVERY shows Market Reserve recovery details';

alter table BILLINGRESERVERECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGRESERVERECOVERY_LCX                            */
/*==============================================================*/
create index BILLINGRESERVERECOVERY_LCX on BILLINGRESERVERECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGRESERVEREGIONRECOVERY                          */
/*==============================================================*/
create table BILLINGRESERVEREGIONRECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier for region recovery.',
   REGIONRESERVE        numeric(15,5)  comment 'Amount Retailer pays for Reserve Trader Contracts with Region Recovery',
   LASTCHANGED          datetime  comment ''
);

alter table BILLINGRESERVEREGIONRECOVERY comment 'BILLINGRESERVEREGIONRECOVERY shows Billing Region Reserve re';

alter table BILLINGRESERVEREGIONRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGRESERVEREGIONRECOV_LCX                         */
/*==============================================================*/
create index BILLINGRESERVEREGIONRECOV_LCX on BILLINGRESERVEREGIONRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGRESERVETRADER                                  */
/*==============================================================*/
create table BILLINGRESERVETRADER
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETRESERVE        numeric(15,5)  comment 'Reserve Trader Amounts paid to Generator for Market Recovery',
   TOTALRESERVE         numeric(15,5)  comment 'Total Reserve Trader Amounts paid to Generator',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   TOTALCAPDIFFERENCE   numeric(15,5)  comment ''
);

alter table BILLINGRESERVETRADER comment 'BILLINGRESERVETRADER shows Billing Market Reserve TRADER pay';

alter table BILLINGRESERVETRADER
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGRESERVETRADER_LCX                              */
/*==============================================================*/
create index BILLINGRESERVETRADER_LCX on BILLINGRESERVETRADER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGRESERVETRADERREGION                            */
/*==============================================================*/
create table BILLINGRESERVETRADERREGION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   REGIONRESERVE        numeric(15,5)  comment 'Reserve Trader Amounts paid to Generator for Region Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGRESERVETRADERREGION comment 'BILLINGRESERVETRADERREGION shows Billing Region Reserve Trad';

alter table BILLINGRESERVETRADERREGION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINGRESERVETRADERREGIO_LCX                         */
/*==============================================================*/
create index BILLINGRESERVETRADERREGIO_LCX on BILLINGRESERVETRADERREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGRUNTRK                                         */
/*==============================================================*/
create table BILLINGRUNTRK
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Year of the run',
   WEEKNO               numeric(3,0) not null  comment 'Week number of the run',
   BILLRUNNO            numeric(3,0) not null  comment 'Sequential run number',
   STATUS               varchar(6)  comment 'The billing run type, PRELIM, FINAL, REVISE or INTERIM',
   ADJ_CLEARED          varchar(1)  comment 'Flag',
   AUTHORISEDDATE       datetime  comment 'null, since not used',
   AUTHORISEDBY         varchar(10)  comment 'null, since not used',
   POSTDATE             datetime  comment 'When the results were posted',
   POSTBY               varchar(10)  comment 'Who posted the results',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   RECEIPTPOSTDATE      datetime  comment 'null, since not used',
   RECEIPTPOSTBY        varchar(10)  comment 'null, since not used',
   PAYMENTPOSTDATE      datetime  comment 'When the payment was posted',
   PAYMENTPOSTBY        varchar(10)  comment 'Who posted the payment',
   SHORTFALL            numeric(16,6)  comment 'Payment shortfall amount',
   MAKEUP               numeric(15,5)  comment 'Not Used'
);

alter table BILLINGRUNTRK comment 'BILLINGRUNTRK identifies the Statement type (i.e. Status of ';

alter table BILLINGRUNTRK
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO);

/*==============================================================*/
/* Index: BILLINGRUNTRK_LCX                                     */
/*==============================================================*/
create index BILLINGRUNTRK_LCX on BILLINGRUNTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINGSMELTERREDUCTION                               */
/*==============================================================*/
create table BILLINGSMELTERREDUCTION
(
   CONTRACTYEAR         numeric(22,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(22,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(22,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   RATE1                numeric(15,6)  comment 'Rate in $/MWh',
   RA1                  numeric(15,6)  comment 'Payment',
   RATE2                numeric(15,6)  comment 'Rate in $/MWh',
   RA2                  numeric(15,6)  comment 'Payment',
   TE                   numeric(15,6)  comment 'Tabulated Energy',
   PCSD                 numeric(15,6)  comment 'Victorian Demand as defined by Code Chapter 9 definitions',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINGSMELTERREDUCTION comment 'BILLINGSMELTERREDUCTION shows the smelter reduction payment ';

alter table BILLINGSMELTERREDUCTION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINGSMELTERREDUCT_NDX2                             */
/*==============================================================*/
create index BILLINGSMELTERREDUCT_NDX2 on BILLINGSMELTERREDUCTION
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: BILLINGSMELTERREDUCTION_LCX                           */
/*==============================================================*/
create index BILLINGSMELTERREDUCTION_LCX on BILLINGSMELTERREDUCTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_APC_COMPENSATION                              */
/*==============================================================*/
create table BILLING_APC_COMPENSATION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   APEVENTID            numeric(6,0) not null  comment 'AP Event Id',
   CLAIMID              numeric(6,0) not null  comment 'AP Event Claim Id',
   PARTICIPANTID        varchar(20)  comment 'Participant identifier',
   COMPENSATION_AMOUNT  numeric(18,8)  comment 'Payment amount to the participant',
   EVENT_TYPE           varchar(20)  comment 'The Administered Price Event Type. Valid values: ENERGY, FCAS, BOTH',
   COMPENSATION_TYPE    varchar(20)  comment 'The Type of Administered Price Compensation Claim. Valid values: DIRECT_COST, OTHER_COST',
   LASTCHANGED          datetime  comment 'The date and time of last changed record'
);

alter table BILLING_APC_COMPENSATION comment 'Billing result table for APC compensation payments.';

alter table BILLING_APC_COMPENSATION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, APEVENTID, CLAIMID);

/*==============================================================*/
/* Table: BILLING_APC_RECOVERY                                  */
/*==============================================================*/
create table BILLING_APC_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   APEVENTID            numeric(6,0) not null  comment 'AP Event Id',
   CLAIMID              numeric(6,0) not null  comment 'AP Event Claim Id',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier',
   REGIONID             varchar(20) not null  comment 'Region Identifier',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'Recovery amount attributable to the participant in that region',
   ELIGIBILITY_START_INTERVAL datetime  comment 'The starting half hourly interval for the eligibility period for recovery of APC Payment',
   ELIGIBILITY_END_INTERVAL datetime  comment 'The ending half hourly interval for the eligibility period for recovery of APC Payment',
   PARTICIPANT_DEMAND   numeric(18,8)  comment 'The participant demand in the cost recovery region',
   REGION_DEMAND        numeric(18,8)  comment 'The sum of demand of all participants in the cost recovery region (Region Sum)',
   LASTCHANGED          datetime  comment 'The date and time of last changed record',
   PARTICIPANT_ACE_MWH  numeric(18,8)  comment 'The ACE MWh value of the participant from the Eligibility Interval used for the APC Recovery Calculation. If the Billing Week is prior to the IESS rule effective date, then value is Null.',
   REGION_ACE_MWH       numeric(18,8)  comment 'The ACE MWh value of the Region from the Eligibility Interval used for the APC Recovery Calculation. This is the sum of the ACE MWh of all the participants in that recovery. If the Billing Week is prior to the IESS rule effective date, then value is Null.'
);

alter table BILLING_APC_RECOVERY comment 'Billing result table for recovery of APC compensation paymen';

alter table BILLING_APC_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, APEVENTID, CLAIMID, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_CO2E_PUBLICATION                              */
/*==============================================================*/
create table BILLING_CO2E_PUBLICATION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week no',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run no',
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date (Calendar)',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   SENTOUTENERGY        numeric(18,8)  comment 'Total sent out energy for region (MWh)',
   GENERATOREMISSIONS   numeric(18,8)  comment 'Total generator emissions for region (Co2-e)',
   INTENSITYINDEX       numeric(18,8)  comment 'Carbon Dioxide Intensity index for region (CO2-e/MWh)'
);

alter table BILLING_CO2E_PUBLICATION comment 'Carbon Dioxide Intensity Index publication table';

alter table BILLING_CO2E_PUBLICATION
   add primary key (CONTRACTYEAR, WEEKNO, SETTLEMENTDATE, REGIONID);

/*==============================================================*/
/* Table: BILLING_CO2E_PUBLICATION_TRK                          */
/*==============================================================*/
create table BILLING_CO2E_PUBLICATION_TRK
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week no',
   BILLRUNNO            numeric(3,0)  comment 'Billing run no',
   LASTCHANGED          datetime  comment 'Last changed date time'
);

alter table BILLING_CO2E_PUBLICATION_TRK comment 'Carbon Dioxide Intensity Index publication tracking table';

alter table BILLING_CO2E_PUBLICATION_TRK
   add primary key (CONTRACTYEAR, WEEKNO);

/*==============================================================*/
/* Table: BILLING_CSP_DEROGATION_AMOUNT                         */
/*==============================================================*/
create table BILLING_CSP_DEROGATION_AMOUNT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   PARTICIPANTID        varchar(10) not null  comment 'The participant allocated the payment amount for the derogation',
   AMOUNT_ID            varchar(20) not null  comment 'Amount identifier represented as a string, from "ta1" through to "ta6" (or "ta8" for a lymmco derogation result)',
   DEROGATION_AMOUNT    numeric(18,8)  comment 'Derogation amount associated with the amount identifier',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table BILLING_CSP_DEROGATION_AMOUNT comment 'CSP derogation amounts with respect to participant allocated';

alter table BILLING_CSP_DEROGATION_AMOUNT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, AMOUNT_ID);

/*==============================================================*/
/* Index: BILLING_CSP_DEROGATN_AMNT_NDX1                        */
/*==============================================================*/
create index BILLING_CSP_DEROGATN_AMNT_NDX1 on BILLING_CSP_DEROGATION_AMOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_DAILY_ENERGY_SUMMARY                          */
/*==============================================================*/
create table BILLING_DAILY_ENERGY_SUMMARY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Billing Week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run number',
   SETTLEMENTDATE       datetime not null  comment 'settlement date',
   PARTICIPANTID        varchar(20) not null  comment 'participant identifier',
   REGIONID             varchar(20) not null  comment 'Unique Region Identifier',
   CUSTOMER_ENERGY_PURCHASED numeric(18,8)  comment 'Customer energy amount purchased on this settlement day by the participant in the region. NULL for Billing Week post the IESS rule effective date.',
   GENERATOR_ENERGY_SOLD numeric(18,8)  comment 'Generator energy amount sold on this settlement day by the participant in the region. NULL for Billing Week post the IESS rule effective date.',
   GENERATOR_ENERGY_PURCHASED numeric(18,8)  comment 'Generator energy amount purchased on this settlement day by the participant in the region. NULL for Billing Week post the IESS rule effective date.',
   ACE_MWH              numeric(18,8)  comment 'The Sum of ACE MWh value for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   ASOE_MWH             numeric(18,8)  comment 'The Sum of ASOE MWh value for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   ACE_AMOUNT           numeric(18,8)  comment 'The Sum of ACE Amount for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Sum of ASOE Amount for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   CE_MWH               numeric(18,8)  comment 'The Sum of CE MWh value for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   UFEA_MWH             numeric(18,8)  comment 'The Sum of UFEA MWh value for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   TOTAL_MWH            numeric(18,8)  comment 'The Sum of Total MWh value for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Sum of Total Amount for the Participant and region for the Settlement Date. NULL for Billing Week prior to the IESS rule effective date'
);

alter table BILLING_DAILY_ENERGY_SUMMARY comment 'Billing result table containing daily summary data for custo';

alter table BILLING_DAILY_ENERGY_SUMMARY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, SETTLEMENTDATE, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_DIRECTION_RECONCILIATN                        */
/*==============================================================*/
create table BILLING_DIRECTION_RECONCILIATN
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week no',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run no',
   DIRECTION_ID         varchar(20) not null  comment 'Direction identifier',
   DIRECTION_DESC       varchar(200)  comment 'Direction description',
   DIRECTION_START_DATE datetime  comment 'Direction start date time',
   DIRECTION_END_DATE   datetime  comment 'Direction end date time',
   COMPENSATION_AMOUNT  numeric(16,6)  comment 'Direction compensation amount',
   INDEPENDENT_EXPERT_FEE numeric(16,6)  comment 'Independent expert fee charged on calculating direction compensation amount',
   INTEREST_AMOUNT      numeric(16,6)  comment 'Interest occurred on direction compensation amount',
   CRA                  numeric(16,6)  comment 'Direction compensation recovery amount',
   NEM_FEE_ID           varchar(20)  comment 'Fixed settlement fee identifier for direction purpose',
   NEM_FIXED_FEE_AMOUNT numeric(16,6)  comment 'Fixed settlement fee for participants between direction start and end date',
   MKT_CUSTOMER_PERC    numeric(16,6)  comment 'Direction compensation recovery amount percentage breakdown among customers',
   GENERATOR_PERC       numeric(16,6)  comment 'Direction compensation recovery amount percentage breakdown among generators',
   LASTCHANGED          datetime  comment 'Last changed date time'
);

alter table BILLING_DIRECTION_RECONCILIATN comment 'Billing reconciliation result table for both provisional and';

alter table BILLING_DIRECTION_RECONCILIATN
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID);

/*==============================================================*/
/* Index: BILLING_DIRECTION_RCNCLTN_NDX1                        */
/*==============================================================*/
create index BILLING_DIRECTION_RCNCLTN_NDX1 on BILLING_DIRECTION_RECONCILIATN
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_DIRECTION_RECON_OTHER                         */
/*==============================================================*/
create table BILLING_DIRECTION_RECON_OTHER
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week no',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run no',
   DIRECTION_ID         varchar(20) not null  comment 'Direction identifier',
   REGIONID             varchar(20) not null  comment 'Region Identifier',
   DIRECTION_DESC       varchar(200)  comment 'Direction description',
   DIRECTION_TYPE_ID    varchar(20)  comment 'The service for which the direction occurred (ENERGY, ANCILLARY, NON_ENERGY_NON_AS, etc)',
   DIRECTION_START_DATE datetime  comment 'Settlement day on which the direction starts',
   DIRECTION_END_DATE   datetime  comment 'Settlement day on which the direction ends.  The same value for all regions',
   DIRECTION_START_INTERVAL datetime  comment 'Dispatch interval in which the direction starts.  The same value for all regions',
   DIRECTION_END_INTERVAL datetime  comment 'Dispatch interval in which the direction ends.  The same value for all regions',
   COMPENSATION_AMOUNT  numeric(18,8)  comment 'The final compensation amount for the direction.  The same value for all regions',
   INTEREST_AMOUNT      numeric(18,8)  comment 'The interest amount calculated on the final compensation amount for the direction.  The same value for all regions',
   INDEPENDENT_EXPERT_FEE numeric(18,8)  comment 'The independent expert fee amount for the direction.  The same value for all regions',
   CRA                  numeric(18,8)  comment 'The total recovery amount for the direction.  The same value for all regions',
   REGIONAL_CUSTOMER_ENERGY numeric(18,8)  comment 'The total customer energy for this region, over the duration of the direction. NULL for Billing Week post the IESS rule effective date.',
   REGIONAL_GENERATOR_ENERGY numeric(18,8)  comment 'The total generator energy for this region, over the duration of the direction. NULL for Billing Week post the IESS rule effective date.',
   REGIONAL_BENEFIT_FACTOR numeric(18,8)  comment 'The regional benefit factor allocated to this region for the direction',
   REGION_ACE_MWH       numeric(18,8)  comment 'The Sum of ACE MWh value for the Region over the duration of the direction. NULL for Billing Week prior to the IESS rule effective date',
   REGION_ASOE_MWH      numeric(18,8)  comment 'The Sum of ASOE MWh value for the Region over the duration of the direction. NULL for Billing Week prior to the IESS rule effective date',
   DIRECTION_SERVICE_ID varchar(20)  comment 'The Direction Service ID associated with the Direction Type ID. Eg For FCAS Direction Type, Direction Service could be any contingency service.'
);

alter table BILLING_DIRECTION_RECON_OTHER comment 'Billing reconciliation result table for both provisional and';

alter table BILLING_DIRECTION_RECON_OTHER
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, REGIONID);

/*==============================================================*/
/* Table: BILLING_DIR_FINAL_AMOUNT                              */
/*==============================================================*/
create table BILLING_DIR_FINAL_AMOUNT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   DIRECTION_ID         varchar(20) not null  comment 'The Direction Unique Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Direction Payment Participant ID',
   COMPENSATION_TYPE    varchar(40) not null  comment 'The Direction Payment Type, Directed_Comp, Affected_Comp, Eligible_Comp.',
   PROVISIONAL_AMOUNT   numeric(18,8)  comment 'The Direction Provisional Payment Amount',
   FINAL_AMOUNT         numeric(18,8)  comment 'The Direction Final Payment Amount',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_DIR_FINAL_AMOUNT comment 'The Billing Final Directions Payment Amount for Directed/Aff';

alter table BILLING_DIR_FINAL_AMOUNT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, PARTICIPANTID, COMPENSATION_TYPE);

/*==============================================================*/
/* Table: BILLING_DIR_FINAL_RECOVERY                            */
/*==============================================================*/
create table BILLING_DIR_FINAL_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   DIRECTION_ID         varchar(20) not null  comment 'The Direction Unique Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Direction Payment Participant ID',
   CRA_AMOUNT           numeric(18,8)  comment 'The Direction Compensation Recovery Amount',
   PROVISIONAL_AMOUNT   numeric(18,8)  comment 'The Provisional Recovery Amount',
   FINAL_AMOUNT         numeric(18,8)  comment 'The Final Recovery Amount',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_DIR_FINAL_RECOVERY comment 'The Billing Final Directions Recovery Amount for the partici';

alter table BILLING_DIR_FINAL_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_DIR_PROV_AMOUNT                               */
/*==============================================================*/
create table BILLING_DIR_PROV_AMOUNT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   DIRECTION_ID         varchar(20) not null  comment 'The Direction Unique Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Direction Payment Participant ID',
   COMPENSATION_TYPE    varchar(40) not null  comment 'The Direction Payment Type, Directed_Comp, Affected_Comp, Eligible_Comp',
   COMPENSATION_AMOUNT  numeric(18,8)  comment 'The Direction Payment Amount',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_DIR_PROV_AMOUNT comment 'The Billing Provisional Directions Payment Amount for Direct';

alter table BILLING_DIR_PROV_AMOUNT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, PARTICIPANTID, COMPENSATION_TYPE);

/*==============================================================*/
/* Table: BILLING_DIR_PROV_RECOVERY                             */
/*==============================================================*/
create table BILLING_DIR_PROV_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   DIRECTION_ID         varchar(20) not null  comment 'The Direction Unique Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Direction Payment Participant ID',
   CRA_AMOUNT           numeric(18,8)  comment 'The Direction Compensation Recovery Amount',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'The Direction Recovery Amount',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_DIR_PROV_RECOVERY comment 'The Billing Provisional Directions Recovery Amount for the p';

alter table BILLING_DIR_PROV_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_DIR_RECOVERY_DETAIL                           */
/*==============================================================*/
create table BILLING_DIR_RECOVERY_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   DIRECTION_ID         varchar(20) not null  comment 'The Direction Unique Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Direction Payment Participant ID',
   PARTICIPANTCATEGORYID varchar(20) not null  comment 'The Participant Category for recovery Customer/Generator /SmallGen',
   REGIONID             varchar(20) not null  comment 'The Region ID for the recovery',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'The Direction Recovery Amount',
   RECOVERY_ENERGY      numeric(18,8)  comment 'The Energy Value used for the Recovery',
   REGION_ENERGY        numeric(18,8)  comment 'The total Energy at the Region ID',
   EXCLUDED_ENERGY      numeric(18,8)  comment 'The Energy Value (Scheduled Loads) that is excluded',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_DIR_RECOVERY_DETAIL comment 'The Billing Directions Recovery Details for the participants';

alter table BILLING_DIR_RECOVERY_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, DIRECTION_ID, PARTICIPANTID, PARTICIPANTCATEGORYID, REGIONID);

/*==============================================================*/
/* Table: BILLING_EFTSHORTFALL_AMOUNT                           */
/*==============================================================*/
create table BILLING_EFTSHORTFALL_AMOUNT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The shortfall affected billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'The shortfall affected billing week no',
   BILLRUNNO            numeric(3,0) not null  comment 'The shortfall affected billing week run no',
   PARTICIPANTID        varchar(20) not null  comment 'The participant affected by the shortfall calculation',
   SHORTFALL_AMOUNT     numeric(18,8)  comment 'The Participant shortfall amount',
   SHORTFALL            numeric(18,8)  comment 'The market shortfall amount',
   SHORTFALL_COMPANY_ID varchar(20)  comment 'The Company ID associated with the Participant ID used in the shortfall calculation',
   COMPANY_SHORTFALL_AMOUNT numeric(18,8)  comment 'The shortfall amount for the Company ID associated with the Participant ID used in the shortfall calculation',
   PARTICIPANT_NET_ENERGY numeric(18,8)  comment 'The participant NET energy used in shortfall calculation',
   COMPANY_NET_ENERGY   numeric(18,8)  comment 'The NET energy for the Company ID associated with the Participant ID used in the shortfall calculation'
);

alter table BILLING_EFTSHORTFALL_AMOUNT comment 'The billing shortfall run amounts';

alter table BILLING_EFTSHORTFALL_AMOUNT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_EFTSHORTFALL_DETAIL                           */
/*==============================================================*/
create table BILLING_EFTSHORTFALL_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The shortfall affected billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'The shortfall affected billing week no',
   BILLRUNNO            numeric(3,0) not null  comment 'The shortfall affected billing week run no',
   PARTICIPANTID        varchar(20) not null  comment 'The participant affected by the shortfall calculation',
   TRANSACTION_TYPE     varchar(40) not null  comment 'The transaction type details associated with the shortfall calculation',
   AMOUNT               numeric(18,8)  comment 'The amount for each transaction type'
);

alter table BILLING_EFTSHORTFALL_DETAIL comment 'The Billing Shortfall Run Amount details';

alter table BILLING_EFTSHORTFALL_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, TRANSACTION_TYPE);

/*==============================================================*/
/* Table: BILLING_ENERGY_GENSET_DETAIL                          */
/*==============================================================*/
create table BILLING_ENERGY_GENSET_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing Week No',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing Run No',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   STATIONID            varchar(20) not null  comment 'The StationId identifier associated with the GensetId',
   DUID                 varchar(20) not null  comment 'The DUID for the meter associated with the GensetId',
   GENSETID             varchar(20) not null  comment 'The GensetId for the Meter Id received',
   REGIONID             varchar(20) not null  comment 'The Region Id for the Connection Point associated with the DUID',
   CONNECTIONPOINTID    varchar(20) not null  comment 'The Connection Point associated with the DUID',
   METERID              varchar(20) not null  comment 'The Meter ID Identifier (NMI)',
   CE_MWH               numeric(18,8)  comment 'The Consumed Energy for the Meter Id . Energy received in the meter reads (DLF Adjusted) in that Billing Week',
   UFEA_MWH             numeric(18,8)  comment 'The UFEA Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   ACE_MWH              numeric(18,8)  comment 'The Adjusted Consumed Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   ASOE_MWH             numeric(18,8)  comment 'The Adjusted Sent Out Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   TOTAL_MWH            numeric(18,8)  comment 'The Total MWh(ACE_MWh + ASOE_MWh) for that Connection Point for the Participant Id in that Billing Week',
   DME_MWH              numeric(18,8)  comment 'The DME MWh for that Connection Point for the Participant Id in that Billing Week. This is the MWh value that is used for the UFEA Allocation',
   ACE_AMOUNT           numeric(18,8)  comment 'The Adjusted Consumed Energy Dollar Amount for that Connection Point for the Participant Id in that Billing Week',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Adjusted Sent Out Energy Dollar Amount for that Connection Point for the Participant Id in that Billing Week',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Total Amount(ACE_Amount + ASOE_Amount) for that Connection Point for the Participant Id in that Billing Week',
   LASTCHANGED          datetime  comment 'The Last changed date time for the record'
);

alter table BILLING_ENERGY_GENSET_DETAIL comment 'The Billing Energy Genset report contains the Genset Energy ';

alter table BILLING_ENERGY_GENSET_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, STATIONID, DUID, GENSETID, REGIONID, CONNECTIONPOINTID, METERID);

/*==============================================================*/
/* Table: BILLING_ENERGY_TRANSACTIONS                           */
/*==============================================================*/
create table BILLING_ENERGY_TRANSACTIONS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   CONNECTIONPOINTID    varchar(20) not null  comment 'The ConnectionPoint Id for the Billing Aggregation for the Participant Id.',
   REGIONID             varchar(20) not null  comment 'The Region Id Identifier',
   CE_MWH               numeric(18,8)  comment 'The Consumed Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   UFEA_MWH             numeric(18,8)  comment 'The UFEA Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   ACE_MWH              numeric(18,8)  comment 'The Adjusted Consumed Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   ASOE_MWH             numeric(18,8)  comment 'The Adjusted Sent Out Energy MWh Consumed for that Connection Point for the Participant Id in that Billing Week',
   ACE_AMOUNT           numeric(18,8)  comment 'The Adjusted Consumed Energy Dollar Amount for that Connection Point for the Participant Id in that Billing Week',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Adjusted Sent Out Energy Dollar Amount for that Connection Point for the Participant Id in that Billing Week',
   TOTAL_MWH            numeric(18,8)  comment 'The Total MWh(ACE_MWh + ASOE_MWh) for that Connection Point for the Participant Id in that Billing Week',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Total Amount(ACE_Amount + ASOE_Amount) for that Connection Point for the Participant Id in that Billing Week',
   DME_MWH              numeric(18,8)  comment 'The DME MWh for that Connection Point for the Participant Id in that Billing Week. This is the MWh value that is used for the UFEA Allocation.',
   LASTCHANGED          datetime  comment 'The Last Changed date time for the record'
);

alter table BILLING_ENERGY_TRANSACTIONS comment 'The Billing Energy Transactions is the summary of the Settle';

alter table BILLING_ENERGY_TRANSACTIONS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONNECTIONPOINTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_ENERGY_TRAN_SAPS                              */
/*==============================================================*/
create table BILLING_ENERGY_TRAN_SAPS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(3,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The SAP Participant ID',
   TNI                  varchar(20) not null  comment 'The SAPS Connection Point ID',
   REGIONID             varchar(20)  comment 'The Region ID associated with the TNI',
   CONSUMED_ENERGY_MWH  numeric(18,8)  comment 'The Energy MWh Consumed for that TNI for the Participant Id in that Billing Week',
   SENTOUT_ENERGY_MWH   numeric(18,8)  comment 'The Energy MWh Sent Out for the TNI for the Participant Id in that Billing Week',
   CONSUMED_ENERGY_COST numeric(18,8)  comment 'The Cost of the Consumed Energy',
   SENTOUT_ENERGY_COST  numeric(18,8)  comment 'The Cost of the Sent Out Energy',
   LASTCHANGED          datetime  comment 'The Last datetime record is updated'
);

alter table BILLING_ENERGY_TRAN_SAPS comment 'The SAP Billing Transaction Details for the Participants';

alter table BILLING_ENERGY_TRAN_SAPS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, TNI);

/*==============================================================*/
/* Table: BILLING_FCAS_REG_AMT                                  */
/*==============================================================*/
create table BILLING_FCAS_REG_AMT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   UNITID               varchar(20) not null  comment 'The UnitId for which a FPP Factor is assigned',
   CONSTRAINTID         varchar(20) not null  comment 'The FCAS Reg Constraint Id',
   CONNECTIONPOINTID    varchar(20) not null  comment 'The ConnectionPointId from Settlement Results for the UnitId',
   REGIONID             varchar(20) not null  comment 'The Region Id Identifier',
   BIDTYPE              varchar(10)  comment 'The BidType for the Constraint Id',
   FPP_AMOUNT           numeric(18,8)  comment 'The FPP Amount for the Participant and the Unit',
   USED_AMOUNT          numeric(18,8)  comment 'The FCAS Regulation Used Amount for the Participant and the Unit',
   UNUSED_AMOUNT        numeric(18,8)  comment 'The FCAS Regulation Unused Amount for the Participant and the Unit',
   LASTCHANGED          datetime  comment 'The Lastchanged datetime of the record.'
);

alter table BILLING_FCAS_REG_AMT comment 'This report show the summary of the Billing run FCAS Regulat';

alter table BILLING_FCAS_REG_AMT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, UNITID, CONSTRAINTID, CONNECTIONPOINTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_FCAS_REG_RESIDAMT                             */
/*==============================================================*/
create table BILLING_FCAS_REG_RESIDAMT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   CONSTRAINTID         varchar(20) not null  comment 'The FCAS Reg Constraint Id',
   REGIONID             varchar(20) not null  comment 'The Region Id Identifier',
   BIDTYPE              varchar(10)  comment 'The BidType for the Constraint Id',
   ACE_MWH              numeric(18,8)  comment 'The ACE MWh used for the Residual Calculation for the Participant',
   ASOE_MWH             numeric(18,8)  comment 'The ASOE MWh used for the Residual Calculation of the Participant',
   RESIDUAL_MWH         numeric(18,8)  comment 'Sum of ACE_MWH + ASOE_MWH',
   FPP_ACE_AMOUNT       numeric(18,8)  comment 'The FPP ACE Portion Amount for the Billing Week',
   FPP_ASOE_AMOUNT      numeric(18,8)  comment 'The FPP ASOE Portion Amount for the Billing Week',
   FPP_RESIDUAL_AMOUNT  numeric(18,8)  comment 'The FPP Residual Amount for the Billing Week',
   USED_ACE_AMOUNT      numeric(18,8)  comment 'The Used ACE Portion Amount for the Billing Week',
   USED_ASOE_AMOUNT     numeric(18,8)  comment 'The Used ASOE Portion Amount for the Billing Week',
   USED_RESIDUAL_AMOUNT numeric(18,8)  comment 'The Used Residual Amount for the Billing Week',
   UNUSED_ACE_AMOUNT    numeric(18,8)  comment 'The Unused ACE Portion Amount for the Billing Week',
   UNUSED_ASOE_AMOUNT   numeric(18,8)  comment 'The Unused ASOE Portion Amount for the Billing Week',
   UNUSED_RESIDUAL_AMOUNT numeric(18,8)  comment 'The Unused Residual Amount for the Billing Week',
   LASTCHANGED          datetime  comment 'The Lastchanged datetime of the record.'
);

alter table BILLING_FCAS_REG_RESIDAMT comment 'This report show the summary of the Billing run FCAS Regulat';

alter table BILLING_FCAS_REG_RESIDAMT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONSTRAINTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_FPP                                           */
/*==============================================================*/
create table BILLING_FPP
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   REGIONID             varchar(20) not null  comment 'The Region Id Identifier',
   LOWERREG_AMOUNT      numeric(18,8)  comment 'The Lower Reg Service FPP Amount for the Participant and the Region for the Billing Week',
   LOWERREG_ACE_AMOUNT  numeric(18,8)  comment 'The Lower Reg Service FPP ACE Residual Amount for the Participant and the Region for the Billing Week',
   LOWERREG_ASOE_AMOUNT numeric(18,8)  comment 'The Lower Reg Service FPP ASOE Residual Amount for the Participant and the Region for the Billing Week',
   LOWERREG_RESIDUAL_AMOUNT numeric(18,8)  comment 'Sum of LOWERREG_ACE_AMOUNT + LOWERREG_ASOE_AMOUNT',
   RAISEREG_AMOUNT      numeric(18,8)  comment 'The Raise Reg Service FPP Amount for the Participant and the Region for the Billing Week',
   RAISEREG_ACE_AMOUNT  numeric(18,8)  comment 'The Raise Reg Service FPP ACE Residual Amount for the Participant and the Region for the Billing Week',
   RAISEREG_ASOE_AMOUNT numeric(18,8)  comment 'The Raise Reg Service FPP ASOE Residual Amount for the Participant and the Region for the Billing Week',
   RAISEREG_RESIDUAL_AMOUNT numeric(18,8)  comment 'RAISEREG_ACE_AMOUNT + RAISEREG_ASOE_AMOUNT',
   LASTCHANGED          datetime  comment 'The Lastchanged datetime of the record.'
);

alter table BILLING_FPP comment 'This report show the summary of the Billing run FPP Amounts ';

alter table BILLING_FPP
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Table: BILLING_GST_DETAIL                                    */
/*==============================================================*/
create table BILLING_GST_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   BAS_CLASS            varchar(30) not null  comment 'The BAS classification that the transaction type belongs to.',
   TRANSACTION_TYPE     varchar(30) not null  comment 'The transaction type (e.g. CUSTOMER_ENERGY_PURCHASES)',
   GST_EXCLUSIVE_AMOUNT numeric(15,5)  comment 'The GST exclusive amount paid by/to the participant to/by AEMO for this transaction type.',
   GST_AMOUNT           numeric(15,5)  comment 'The GST amount for this transaction type.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLING_GST_DETAIL comment 'BILLING_GST_DETAIL shows the BAS class, GST_Exclusive and GS';

alter table BILLING_GST_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, TRANSACTION_TYPE, BAS_CLASS);

/*==============================================================*/
/* Index: BILLING_GST_DETAIL_LCX                                */
/*==============================================================*/
create index BILLING_GST_DETAIL_LCX on BILLING_GST_DETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_GST_SUMMARY                                   */
/*==============================================================*/
create table BILLING_GST_SUMMARY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   BAS_CLASS            varchar(30) not null  comment 'The BAS classification',
   GST_EXCLUSIVE_AMOUNT numeric(15,5)  comment 'The GST exclusive amount paid by/to the participant to/by AEMO for this BAS classification.',
   GST_AMOUNT           numeric(15,5)  comment 'The GST amount for this BAS classification.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLING_GST_SUMMARY comment 'BILLING_GST_SUMMARY shows the GST_Exclusive and GST amount (';

alter table BILLING_GST_SUMMARY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, BAS_CLASS);

/*==============================================================*/
/* Index: BILLING_GST_SUMMARY_LCX                               */
/*==============================================================*/
create index BILLING_GST_SUMMARY_LCX on BILLING_GST_SUMMARY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_MR_PAYMENT                                    */
/*==============================================================*/
create table BILLING_MR_PAYMENT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Billing Week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run number',
   MR_DATE              datetime not null  comment 'Trading Date of Mandatory Restriction event; Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique Region Identifier',
   PARTICIPANTID        varchar(10)  comment 'Unique Participant identifier',
   DUID                 varchar(10) not null  comment 'Unique identifier for DUID / MNSP LinkID',
   MR_AMOUNT            numeric(16,6)  comment 'Payment amount by AEMO',
   LASTCHANGED          datetime  comment 'Date/Time record inserted/modified'
);

alter table BILLING_MR_PAYMENT comment 'BILLING_MR_PAYMENT shows aggregate payments on a dispatchabl';

alter table BILLING_MR_PAYMENT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, MR_DATE, REGIONID, DUID);

/*==============================================================*/
/* Index: BILLING_MR_PAYMENT_LCX                                */
/*==============================================================*/
create index BILLING_MR_PAYMENT_LCX on BILLING_MR_PAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_MR_RECOVERY                                   */
/*==============================================================*/
create table BILLING_MR_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Billing Week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run number',
   MR_DATE              datetime not null  comment 'Trading Date of Mandatory Restriction event; Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique Region Identifier',
   PARTICIPANTID        varchar(10)  comment 'Unique Participant identifier',
   DUID                 varchar(10) not null  comment 'Unique identifier for DUID / MNSP LinkID',
   MR_AMOUNT            numeric(16,6)  comment 'Payment amount to AEMO',
   LASTCHANGED          datetime  comment 'Date/Time record inserted/modified'
);

alter table BILLING_MR_RECOVERY comment 'BILLING_MR_RECOVERY shows aggregate recovery charges on a di';

alter table BILLING_MR_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, MR_DATE, REGIONID, DUID);

/*==============================================================*/
/* Index: BILLING_MR_RECOVERY_LCX                               */
/*==============================================================*/
create index BILLING_MR_RECOVERY_LCX on BILLING_MR_RECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_MR_SHORTFALL                                  */
/*==============================================================*/
create table BILLING_MR_SHORTFALL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Billing Week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run number',
   MR_DATE              datetime not null  comment 'Trading Date of Mandatory Restriction event; Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique Region Identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique Participant Identifier',
   AGE                  numeric(16,6)  comment 'The adjusted gross energy for the market customer in the restricted region for the duration of the mandatory restriction event (MWh)',
   RSA                  numeric(16,6)  comment 'Restriction Shortfall amount payable to AEMO for a mandatory restriction period',
   LASTCHANGED          datetime  comment 'Date/Time record inserted/modified'
);

alter table BILLING_MR_SHORTFALL comment 'BILLING_MR_SHORTFALL shows aggregate MR shortfall payments (';

alter table BILLING_MR_SHORTFALL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, MR_DATE, REGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLING_MR_SHORTFALL_LCX                              */
/*==============================================================*/
create index BILLING_MR_SHORTFALL_LCX on BILLING_MR_SHORTFALL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_MR_SUMMARY                                    */
/*==============================================================*/
create table BILLING_MR_SUMMARY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing Contract Year',
   WEEKNO               numeric(3,0) not null  comment 'Billing Week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing Run number',
   MR_DATE              datetime not null  comment 'Trading Date of Mandatory Restriction event; Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique Region Identifier',
   TOTAL_PAYMENTS       numeric(16,6)  comment 'Total payments by AEMO',
   TOTAL_RECOVERY       numeric(16,6)  comment 'Total payments to AEMO',
   TOTAL_RSA            numeric(16,6)  comment 'Total Restriction Shortfall Amount',
   AAGE                 numeric(16,6)  comment 'The aggregate of then adjusted gross energy of all the market customer in the restricted region for the duration of the mandatory restriction period (MWh)',
   LASTCHANGED          datetime  comment 'Date/Time record inserted/modified'
);

alter table BILLING_MR_SUMMARY comment 'BILLING_MR_SUMMARY shows aggregate payment/recovery and shor';

alter table BILLING_MR_SUMMARY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, MR_DATE, REGIONID);

/*==============================================================*/
/* Index: BILLING_MR_SUMMARY_LCX                                */
/*==============================================================*/
create index BILLING_MR_SUMMARY_LCX on BILLING_MR_SUMMARY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_NMAS_MANUAL_PAYMENT                           */
/*==============================================================*/
create table BILLING_NMAS_MANUAL_PAYMENT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year.',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Contract Participant Id.',
   CONTRACTID           varchar(20) not null  comment 'The NMAS System Security Contract ID.',
   DUID                 varchar(20) not null  comment 'The DUID associated with the Contract Payment.',
   SERVICETYPE          varchar(40) not null  comment 'The NMAS System Security Service Types (INERTIA, SYSTEM STRENGTH, TYPE1, TYPE2 and so on).',
   PAYMENTTYPE          varchar(20) not null  comment 'The Payment Type associated with the Service like Availability, Usage, Enablement, Energy Revenue, Test, ADHOC and so on.',
   REGIONID             varchar(10)  comment 'The Contract Region Id.',
   PAYMENTAMOUNT        numeric(18,8)  comment 'The NMAS Contract Manual Payment for the Payment Type.',
   LASTCHANGED          datetime  comment 'The last changed date time of the record.'
);

alter table BILLING_NMAS_MANUAL_PAYMENT comment 'This report contains the NMAS Manual Weekly Payments that ar';

alter table BILLING_NMAS_MANUAL_PAYMENT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONTRACTID, DUID, SERVICETYPE, PAYMENTTYPE);

/*==============================================================*/
/* Table: BILLING_NMAS_MANUAL_RECOVERY                          */
/*==============================================================*/
create table BILLING_NMAS_MANUAL_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The Billing Contract Year.',
   WEEKNO               numeric(3,0) not null  comment 'The Billing WeekNo',
   BILLRUNNO            numeric(4,0) not null  comment 'The Billing RunNo',
   PARTICIPANTID        varchar(20) not null  comment 'The Contract Participant Id.',
   CONTRACTID           varchar(20) not null  comment 'The NMAS System Security Contract ID.',
   SERVICETYPE          varchar(40) not null  comment 'The NMAS System Security Service Types (INERTIA, SYSTEM STRENGTH, TYPE1, TYPE2 and so on).',
   PAYMENTTYPE          varchar(20) not null  comment 'The Payment Type associated with the Service like Availability, Usage, Enablement, Energy Revenue, Test, ADHOC and so on.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PAYMENTAMOUNT        numeric(18,8)  comment 'The NMAS Contract Manual Payment for the Payment Type.',
   RECOVERYSTARTDATETIME datetime  comment 'The Recovery Start Date and Time for the Payment Calculation.',
   RECOVERYENDDATETIME  datetime  comment 'The Recovery End Date and Time for the Payment Calculation.',
   RECOVERYAMOUNT_ACE   numeric(18,8)  comment 'Recovery Amount on ACE portion ($).',
   RECOVERYAMOUNT_ASOE  numeric(18,8)  comment 'Recovery Amount on ASOE portion ($).',
   PARTICIPANT_ACE_MWH  numeric(18,8)  comment 'Participant Consumed Energy in MWh.',
   PARTICIPANT_ASOE_MWH numeric(18,8)  comment 'Participant Sent Out Energy in MWh.',
   REGION_ACE_MWH       numeric(18,8)  comment 'Region Consumed Energy in MWh.',
   REGION_ASOE_MWH      numeric(18,8)  comment 'Region Sent Out Energy in MWh.',
   LASTCHANGED          datetime  comment 'The last changed date time of the record.'
);

alter table BILLING_NMAS_MANUAL_RECOVERY comment 'This report shows the summary of the Billing NMAS Recovery A';

alter table BILLING_NMAS_MANUAL_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, CONTRACTID, SERVICETYPE, PAYMENTTYPE, REGIONID);

/*==============================================================*/
/* Table: BILLING_NMAS_TST_PAYMENTS                             */
/*==============================================================*/
create table BILLING_NMAS_TST_PAYMENTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1 January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1 January',
   BILLRUNNO            numeric(3,0) not null  comment 'The current Billing RunNo for the week',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant from whom the amount is recovered',
   SERVICE              varchar(10) not null  comment 'The type of NSCAS service. Current value values are:
             - REACTIVE
             - LOADSHED',
   CONTRACTID           varchar(10) not null  comment 'The NMAS Contract Id',
   PAYMENT_AMOUNT       numeric(18,8)  comment 'The Testing Payment Amount to recover'
);

alter table BILLING_NMAS_TST_PAYMENTS comment 'BILLING_NMAS_TEST_PAYMENTS publish the NSCAS/SRAS Testing Pa';

alter table BILLING_NMAS_TST_PAYMENTS
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, SERVICE, CONTRACTID);

/*==============================================================*/
/* Table: BILLING_NMAS_TST_RECOVERY                             */
/*==============================================================*/
create table BILLING_NMAS_TST_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1 January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1 January',
   BILLRUNNO            numeric(3,0) not null  comment 'The current Billing RunNo for the week',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant from whom the amount is recovered',
   SERVICE              varchar(10) not null  comment 'The type of NSCAS service. Current value values are:
             - REACTIVE
             - LOADSHED
             - RESTART',
   CONTRACTID           varchar(10) not null  comment 'The NMAS Contract Id',
   REGIONID             varchar(10) not null  comment 'The region from where the amount is recovered',
   RBF                  numeric(18,8)  comment 'The Benefitting Factor for the RegionId',
   TEST_PAYMENT         numeric(18,8)  comment 'The total Testing Payment Amount to recover from all benefitting regions',
   RECOVERY_START_DATE  datetime  comment 'The Recovery Start Date for the Testing Payment Calculation',
   RECOVERY_END_DATE    datetime  comment 'The Recovery End Date for the Testing Payment Calculation',
   PARTICIPANT_ENERGY   numeric(18,8)  comment 'The Participant energy in MWh for the recovery period',
   REGION_ENERGY        numeric(18,8)  comment 'The RegionId energy in MWh for the recovery period',
   NEM_ENERGY           numeric(18,8)  comment 'The NEM energy in MWh for the recovery period',
   CUSTOMER_PROPORTION  numeric(18,8)  comment 'The Customer Proportion for recovery amount in Percent',
   GENERATOR_PROPORTION numeric(18,8)  comment 'The Generator Proportion for recovery amount in Percent (100-Customer Portion)',
   PARTICIPANT_GENERATION numeric(18,8)  comment 'The Participant Generation for the recovery period',
   NEM_GENERATION       numeric(18,8)  comment 'The NEM Generation for the recovery period',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'The Total recovery amount for the billing week, being the sum of the customer and generator proportions for the PARTICIPANTID in REGIONID and sum of RecoveryAmount_ACE and RecoveryAmount_ASOE.',
   LASTCHANGED          datetime  comment 'The Last Updated date and time',
   PARTICIPANT_ACE_MWH  numeric(18,8)  comment 'The Participant ACE MWh Value used in the Recovery of the Testing Payment Amount if the service is recovered from ACE. NULL for Billing Week prior to the IESS rule effective date',
   REGION_ACE_MWH       numeric(18,8)  comment 'The Region ACE MWh Value used in the Recovery of the Testing Payment Amount if the service is recovered from ACE. NULL for Billing Week prior to the IESS rule effective date',
   ACE_PORTION          numeric(18,8)  comment 'The Portion of ACE MWh Value used in the Recovery Calculation. . NULL for Billing Week prior to the IESS rule effective date',
   ASOE_PORTION         numeric(18,8)  comment 'The Portion of ASOE MWh Value used in the Recovery Calculation (100 - ACE_Portion). . NULL for Billing Week prior to the IESS rule effective date',
   PARTICIPANT_ASOE_MWH numeric(18,8)  comment 'The Participant ASOE MWh Value used in the Recovery of the Testing Payment Amount if the service is recovered from ASOE. NULL for Billing Week prior to the IESS rule effective date',
   REGION_ASOE_MWH      numeric(18,8)  comment 'The Region ASOE MWh Value used in the Recovery of the Testing Payment Amount if the service is recovered from ASOE. NULL for Billing Week prior to the IESS rule effective date',
   RECOVERYAMOUNT_ACE   numeric(18,8)  comment 'The Participant Recovery Amount based on ACE MWh Value if the service is recovered from ACE . NULL for Billing Week prior to the IESS rule effective date',
   RECOVERYAMOUNT_ASOE  numeric(18,8)  comment 'The Participant Recovery Amount based on ASOE MWh Value if the service is recovered from ASOE . NULL for Billing Week prior to the IESS rule effective date'
);

alter table BILLING_NMAS_TST_RECOVERY comment 'BILLING_NMAS_TEST_RECOVERY sets out the recovery of NMAS tes';

alter table BILLING_NMAS_TST_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, SERVICE, CONTRACTID, REGIONID);

/*==============================================================*/
/* Index: BILLING_NMAS_TST_RECOVERY_LCX                         */
/*==============================================================*/
create index BILLING_NMAS_TST_RECOVERY_LCX on BILLING_NMAS_TST_RECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_NMAS_TST_RECVRY_RBF                           */
/*==============================================================*/
create table BILLING_NMAS_TST_RECVRY_RBF
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1 January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1 January',
   BILLRUNNO            numeric(3,0) not null  comment 'The current Billing RunNo for the week',
   SERVICE              varchar(10) not null  comment 'The type of NSCAS service. Current value values are:
             - REACTIVE
             - LOADSHED',
   CONTRACTID           varchar(10) not null  comment 'The NMAS Contract Id',
   REGIONID             varchar(10) not null  comment 'The region from where the amount is recovered',
   RBF                  numeric(18,8)  comment 'The Benefitting Factor for the RegionId',
   PAYMENT_AMOUNT       numeric(18,8)  comment 'The total Testing Payment Amount to recover from all benefitting regions',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'The Testing Payment amount to recover from RegionId',
   LASTCHANGED          datetime  comment 'The Last Updated date and time'
);

alter table BILLING_NMAS_TST_RECVRY_RBF comment 'BILLING_NMAS_TEST_RECVRY_RBF sets out the NSCAS/SRAS Testing';

alter table BILLING_NMAS_TST_RECVRY_RBF
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, SERVICE, CONTRACTID, REGIONID);

/*==============================================================*/
/* Index: BILLING_NMAS_TST_RCVRY_RBF_LCX                        */
/*==============================================================*/
create index BILLING_NMAS_TST_RCVRY_RBF_LCX on BILLING_NMAS_TST_RECVRY_RBF
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLING_NMAS_TST_RECVRY_TRK                           */
/*==============================================================*/
create table BILLING_NMAS_TST_RECVRY_TRK
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1 January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1 January',
   BILLRUNNO            numeric(3,0) not null  comment 'The current Billing RunNo for the week',
   RECOVERY_CONTRACTYEAR numeric(4,0) not null  comment 'AEMO Contract Year for energy data used in recovery calculation',
   RECOVERY_WEEKNO      numeric(3,0) not null  comment 'Week no for energy data used in recovery calculation',
   RECOVERY_BILLRUNNO   numeric(3,0) not null  comment 'Billing RunNo for energy data used in recovery calculation'
);

alter table BILLING_NMAS_TST_RECVRY_TRK comment 'BILLING_NMAS_TEST_RECVRY_TRK tracks the energy data used to ';

alter table BILLING_NMAS_TST_RECVRY_TRK
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, RECOVERY_CONTRACTYEAR, RECOVERY_WEEKNO, RECOVERY_BILLRUNNO);

/*==============================================================*/
/* Table: BILLING_RES_TRADER_PAYMENT                            */
/*==============================================================*/
create table BILLING_RES_TRADER_PAYMENT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   CONTRACTID           varchar(20) not null  comment 'Reserve trader contract identifier',
   PAYMENT_TYPE         varchar(40) not null  comment 'Payment type for the reserve trader contract payment amount',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier associated with the contract',
   PAYMENT_AMOUNT       numeric(18,8)  comment 'Payment amount to the participant'
);

alter table BILLING_RES_TRADER_PAYMENT comment 'Billing result table for reserve trader contract payments';

alter table BILLING_RES_TRADER_PAYMENT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, CONTRACTID, PAYMENT_TYPE, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_RES_TRADER_RECOVERY                           */
/*==============================================================*/
create table BILLING_RES_TRADER_RECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   REGIONID             varchar(20) not null  comment 'Region id for the aggregated recovery amount',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'Payment amount to be recovered from the participant'
);

alter table BILLING_RES_TRADER_RECOVERY comment 'Billing result table for reserve trader contract recovery';

alter table BILLING_RES_TRADER_RECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, REGIONID, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_SECDEPOSIT_APPLICATION                        */
/*==============================================================*/
create table BILLING_SECDEPOSIT_APPLICATION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The billing contract year where (security deposit application) SDA is applied',
   WEEKNO               numeric(3,0) not null  comment 'The billing week no. where the SDA is applied',
   BILLRUNNO            numeric(3,0) not null  comment 'The billing run no. where the SDA is applied',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant ID lodging the SDA',
   APPLICATION_AMOUNT   numeric(18,8)  comment 'The SDA application amount'
);

alter table BILLING_SECDEPOSIT_APPLICATION comment 'The security deposit application details';

alter table BILLING_SECDEPOSIT_APPLICATION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_SECDEP_INTEREST_PAY                           */
/*==============================================================*/
create table BILLING_SECDEP_INTEREST_PAY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The billing contract year the SDA application is processed and interest calculated',
   WEEKNO               numeric(3,0) not null  comment 'The billing week no. the SDA application is processed and interest calculated',
   BILLRUNNO            numeric(3,0) not null  comment 'The billing run no. the SDA application is processed and interest calculated',
   SECURITY_DEPOSIT_ID  varchar(20) not null  comment 'The security deposit ID for which billing has calculated the Interest amount',
   PARTICIPANTID        varchar(20) not null  comment 'The participant ID of the security deposit for whom the interest is paid',
   INTEREST_AMOUNT      numeric(18,8)  comment 'The security deposit interest amount calculated by billing',
   INTEREST_CALC_TYPE   varchar(20)  comment 'FIXED or DAILY',
   INTEREST_ACCT_ID     varchar(20)  comment 'The interest account ID used by billing for calculating the interest. 
             NULL if INTEREST_CALC_TYPE = FIXED',
   INTEREST_RATE        numeric(18,8)  comment 'The STATIC Interest Rate used by Billing for calculating the interest. This is NULL if INTEREST_CALC_TYPE <> FIXED'
);

alter table BILLING_SECDEP_INTEREST_PAY comment 'The interest amount for security deposit calculated by billi';

alter table BILLING_SECDEP_INTEREST_PAY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, SECURITY_DEPOSIT_ID, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_SECDEP_INTEREST_RATE                          */
/*==============================================================*/
create table BILLING_SECDEP_INTEREST_RATE
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'The billing contract year the SDA application is processed and interest calculated',
   WEEKNO               numeric(3,0) not null  comment 'The billing week no. the SDA application is processed and interest calculated',
   BILLRUNNO            numeric(3,0) not null  comment 'The billing run no. the SDA application is processed and interest calculated',
   INTEREST_ACCT_ID     varchar(20) not null  comment 'The interest account ID used by security deposit interest calculation',
   EFFECTIVEDATE        datetime not null  comment 'The effective date of the new interest change',
   INTEREST_RATE        numeric(18,8)  comment 'The interest rate to apply from the effective date'
);

alter table BILLING_SECDEP_INTEREST_RATE comment 'The DAILY interest rates used by billing when calculating th';

alter table BILLING_SECDEP_INTEREST_RATE
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, INTEREST_ACCT_ID, EFFECTIVEDATE);

/*==============================================================*/
/* Table: BILLING_SUBST_DEMAND                                  */
/*==============================================================*/
create table BILLING_SUBST_DEMAND
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   TNI                  varchar(20) not null  comment 'Unique identifier for the connection point',
   PARTICIPANTID        varchar(20) not null  comment 'Unique identifier for the participant',
   REGIONID             varchar(20)  comment 'Unique identifier for the region to which the TNI belongs to on this settlement date',
   SUBSTITUTEDEMAND     numeric(18,8)  comment 'Substitute metered quantity for non-energy recovery in MWh for the TNI and participant in the trading interval. A negative value indicates net consumption and a positive value indicates net generation'
);

alter table BILLING_SUBST_DEMAND comment 'Demand Values Substituted in Billing Calculation';

alter table BILLING_SUBST_DEMAND
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, SETTLEMENTDATE, TNI, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_SUBST_RUN_VERSION                             */
/*==============================================================*/
create table BILLING_SUBST_RUN_VERSION
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number',
   REFERENCESETTLEMENTDATE datetime not null  comment 'Settlement Date',
   REFERENCESETTLEMENTRUNNO numeric(3,0) not null  comment 'The settlement run number matching the settlement date for a settlement run included in the reference period'
);

alter table BILLING_SUBST_RUN_VERSION comment 'Details of settlement runs used as input in the substitute d';

alter table BILLING_SUBST_RUN_VERSION
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, REFERENCESETTLEMENTDATE, REFERENCESETTLEMENTRUNNO);

/*==============================================================*/
/* Table: BILLING_WDR                                           */
/*==============================================================*/
create table BILLING_WDR
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contract year of the Billing run',
   WEEKNO               numeric(3,0) not null  comment 'Week number of the Billing run',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number identifier',
   PARTICIPANTID        varchar(20) not null  comment 'DRSP or FRMP Participant Identifier',
   WDR_CREDIT_AMOUNT    numeric(18,8)  comment 'WDR credit transaction amount',
   WDR_DEBIT_AMOUNT     numeric(18,8)  comment 'WDR debit transaction amount'
);

alter table BILLING_WDR comment 'Billing WDR Transaction Weekly Summary';

alter table BILLING_WDR
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Table: BILLING_WDR_DETAIL                                    */
/*==============================================================*/
create table BILLING_WDR_DETAIL
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Contract year of the Billing run',
   WEEKNO               numeric(3,0) not null  comment 'Week number of the Billing run',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing run number identifier',
   WDRRRPERIOD          varchar(20) not null  comment 'Unique identifier for the period to which the WDRRR applies. For quarter-based periods, this will be equal to YYYY[Q]NN, for example, 2020Q3 for 2020 Quarter 3.',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   FRMP                 varchar(20) not null  comment 'Financial Responsible Market Participant Identifier',
   DRSP                 varchar(20) not null  comment 'Demand Response Service Provider Identifier',
   WDRSQ                numeric(18,8)  comment 'WDR Settlement Quantity capped in MWh',
   WDRRR                numeric(18,8)  comment 'WDR reimbursement rate in $/MWh',
   WDRTA                numeric(18,8)  comment 'WDR transaction amount in $ for demand response'
);

alter table BILLING_WDR_DETAIL comment 'Billing WDR transaction detail summary';

alter table BILLING_WDR_DETAIL
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, WDRRRPERIOD, REGIONID, FRMP, DRSP);

/*==============================================================*/
/* Table: BILLINTERVENTIONRECOVERY                              */
/*==============================================================*/
create table BILLINTERVENTIONRECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETINTERVENTION   numeric(15,5)  comment 'Amount Retailer pays for Intervention with Market Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINTERVENTIONRECOVERY comment 'BILLINTERVENTIONRECOVERY shows billing market intervention r';

alter table BILLINTERVENTIONRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID);

/*==============================================================*/
/* Index: BILLINTERVENTIONRECOVERY_LCX                          */
/*==============================================================*/
create index BILLINTERVENTIONRECOVERY_LCX on BILLINTERVENTIONRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLINTERVENTIONREGIONRECOVERY                        */
/*==============================================================*/
create table BILLINTERVENTIONREGIONRECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(3,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(3,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   REGIONINTERVENTION   numeric(15,5)  comment 'Amount retailer pays for intervention with Region Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLINTERVENTIONREGIONRECOVERY comment 'BILLINTERVENTIONREGIONRECOVERY shows billing region interven';

alter table BILLINTERVENTIONREGIONRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, REGIONID);

/*==============================================================*/
/* Index: BILLINTERVENTIONREGIONREC_LCX                         */
/*==============================================================*/
create index BILLINTERVENTIONREGIONREC_LCX on BILLINTERVENTIONREGIONRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLRESERVETRADERPAYMENT                              */
/*==============================================================*/
create table BILLRESERVETRADERPAYMENT
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing posted run number',
   PARTICIPANTID        varchar(20)  comment 'Participant identifier.',
   CONTRACTID           varchar(20) not null  comment 'RERT payment contract ID',
   PAYMENT_ID           numeric(3,0) not null  comment 'RERT payment number',
   PAYMENT_TYPE         varchar(40)  comment 'Description for the reserve trader contract payment amount.',
   PAYMENT_AMOUNT       numeric(18,8)  comment 'RERT payment amount for the payment type'
);

alter table BILLRESERVETRADERPAYMENT comment 'Details of the RERT Usage and Availability Payments made to ';

alter table BILLRESERVETRADERPAYMENT
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, CONTRACTID, PAYMENT_ID);

/*==============================================================*/
/* Table: BILLRESERVETRADERRECOVERY                             */
/*==============================================================*/
create table BILLRESERVETRADERRECOVERY
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'Billing contract year',
   WEEKNO               numeric(3,0) not null  comment 'Billing week number',
   BILLRUNNO            numeric(3,0) not null  comment 'Billing posted run number',
   PUBLICATION_ID       varchar(40) not null  comment 'Unique Publication Identifier for RERT Payment',
   PAYMENT_ID           numeric(3,0) not null  comment 'RERT payment number',
   PAYMENT_AMOUNT       numeric(18,8)  comment 'RERT payment amount',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier.',
   REGIONID             varchar(20) not null  comment 'Region from which the amount is recovered',
   PARTICIPANT_DEMAND   numeric(18,8)  comment 'Participant Demand Value used for RERT Recovery. NULL for Billing Week post the IESS rule effective date.',
   REGION_DEMAND        numeric(18,8)  comment 'Region Demand Value used for RERT Recovery. NULL for Billing Week post the IESS rule effective date.',
   ELIGIBILITY_START_INTERVAL datetime  comment 'Starting Period of RERT Recovery for Usage Payments',
   ELIGIBILITY_END_INTERVAL datetime  comment 'Ending Period of RERT Recovery for Usage Payments',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'Recovery Amount applicable for each Market Customer',
   EXCLUDED_ENERGY      numeric(18,8)  comment 'The Energy Value (Scheduled Loads) that is excluded',
   PARTICIPANT_ACE_MWH  numeric(18,8)  comment 'The Participant ACE MWh Value used in the Recovery of the RERT Amount. NULL for Billing Week prior to the IESS rule effective date',
   REGION_ACE_MWH       numeric(18,8)  comment 'The Region ACE MWh Value used in the Recovery of the RERT Amount. NULL for Billing Week prior to the IESS rule effective date'
);

alter table BILLRESERVETRADERRECOVERY comment 'Provides details of the RERT Recovery Amount for the Market ';

alter table BILLRESERVETRADERRECOVERY
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PUBLICATION_ID, PARTICIPANTID, REGIONID, PAYMENT_ID);

/*==============================================================*/
/* Table: BILLSMELTERRATE                                       */
/*==============================================================*/
create table BILLSMELTERRATE
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar settlement date record becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of the record for the given effective date',
   CONTRACTYEAR         numeric(22,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   RAR1                 numeric(6,2)  comment 'Smelter rate 1',
   RAR2                 numeric(6,2)  comment 'Smelter rate 2',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(10)  comment 'Who authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table BILLSMELTERRATE comment 'BILLSMELTERRATE is standing data, setting out the rates used';

alter table BILLSMELTERRATE
   add primary key (EFFECTIVEDATE, VERSIONNO, CONTRACTYEAR);

/*==============================================================*/
/* Index: BILLSMELTERRATE_LCX                                   */
/*==============================================================*/
create index BILLSMELTERRATE_LCX on BILLSMELTERRATE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: BILLWHITEHOLE                                         */
/*==============================================================*/
create table BILLWHITEHOLE
(
   CONTRACTYEAR         numeric(22,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   WEEKNO               numeric(22,0) not null  comment 'Week no within the contract year. Week no 1 is the week containing 1st January',
   BILLRUNNO            numeric(22,0) not null  comment 'Unique run no within a given contract year and week no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   NL                   numeric(15,6)  comment 'Sum of billing week (RRP * interconnector flow)',
   PARTICIPANTDEMAND    numeric(15,6)  comment 'The sum of all customer purchases in MWh',
   REGIONDEMAND         numeric(15,6)  comment 'Sum of all region purchases in MWh',
   WHITEHOLEPAYMENT     numeric(15,6)  comment 'Payment in $',
   LASTCHANGED          datetime  comment 'The latest date and time that a file was updated or inserted',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector ID'
);

alter table BILLWHITEHOLE comment 'BILLWHITEHOLE shows white hole payments based on participant';

alter table BILLWHITEHOLE
   add primary key (CONTRACTYEAR, WEEKNO, BILLRUNNO, PARTICIPANTID, INTERCONNECTORID);

/*==============================================================*/
/* Index: BILLWHITEHOLE_LCX                                     */
/*==============================================================*/
create index BILLWHITEHOLE_LCX on BILLWHITEHOLE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONNECTIONPOINT                                       */
/*==============================================================*/
create table CONNECTIONPOINT
(
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection Point Identifier',
   CONNECTIONPOINTNAME  varchar(80)  comment 'Connection point full description',
   CONNECTIONPOINTTYPE  varchar(20)  comment 'Connection point type. transmission, distribution, station, genunit, or interconnector',
   ADDRESS1             varchar(80)  comment 'Connection point location',
   ADDRESS2             varchar(80)  comment 'Connection point location',
   ADDRESS3             varchar(80)  comment 'Connection point location',
   ADDRESS4             varchar(80)  comment 'Not Used',
   CITY                 varchar(40)  comment 'City',
   STATE                varchar(10)  comment 'State of Australia',
   POSTCODE             varchar(10)  comment 'Post Code',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONNECTIONPOINT comment 'CONNECTIONPOINT shows all valid connection points and their ';

alter table CONNECTIONPOINT
   add primary key (CONNECTIONPOINTID);

/*==============================================================*/
/* Index: CONNECTIONPOINT_LCX                                   */
/*==============================================================*/
create index CONNECTIONPOINT_LCX on CONNECTIONPOINT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONNECTIONPOINTDETAILS                                */
/*==============================================================*/
create table CONNECTIONPOINTDETAILS
(
   EFFECTIVEDATE        datetime not null  comment 'Effective date of record',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of record for given effective date',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection point identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TRANSMISSIONCPTID    varchar(10)  comment 'Associated transmission connection point id for a distribution connection point',
   METERDATAPROVIDER    varchar(10)  comment 'The MDA providing meter data for this connection point',
   TRANSMISSIONLOSSFACTOR numeric(7,5)  comment 'The transmission level loss factor for this connection point',
   DISTRIBUTIONLOSSFACTOR numeric(7,5)  comment 'The distribution level loss factor for a distribution connection point',
   NETWORKSERVICEPROVIDER varchar(10)  comment 'The Network Service Provider',
   FINRESPORGAN         varchar(10)  comment 'Financially responsible organisation',
   NATIONALMETERINSTALLID numeric(7,5)  comment 'National Meter Id',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   INUSE                varchar(1)  comment 'Status flag.',
   LNSP                 varchar(10)  comment 'Local Electricity Network Service Provider',
   MDA                  varchar(10)  comment 'Metering Data Agent for connection point.',
   ROLR                 varchar(10)  comment 'Retailer of last resort.',
   RP                   varchar(10)  comment 'Responsible party.',
   AGGREGATEDDATA       varchar(1)  comment 'Aggregate flag.',
   VALID_TODATE         datetime  comment 'Date of validity.',
   LR                   varchar(10)  comment 'Local Retailer'
);

alter table CONNECTIONPOINTDETAILS comment 'CONNECTIONPOINTDETAILS is obsolete, since it was never popul';

alter table CONNECTIONPOINTDETAILS
   add primary key (EFFECTIVEDATE, VERSIONNO, CONNECTIONPOINTID);

/*==============================================================*/
/* Index: CONNECTIONPOINTDETAILS_LCX                            */
/*==============================================================*/
create index CONNECTIONPOINTDETAILS_LCX on CONNECTIONPOINTDETAILS
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: CONNECTIONPOINTDETAI_NDX2                             */
/*==============================================================*/
create index CONNECTIONPOINTDETAI_NDX2 on CONNECTIONPOINTDETAILS
(
   METERDATAPROVIDER,
   NETWORKSERVICEPROVIDER,
   FINRESPORGAN
);

/*==============================================================*/
/* Index: CONNECTIONPOINTDETAI_NDX3                             */
/*==============================================================*/
create index CONNECTIONPOINTDETAI_NDX3 on CONNECTIONPOINTDETAILS
(
   CONNECTIONPOINTID
);

/*==============================================================*/
/* Table: CONNECTIONPOINTOPERATINGSTA                           */
/*==============================================================*/
create table CONNECTIONPOINTOPERATINGSTA
(
   EFFECTIVEDATE        datetime not null  comment 'Effective date of record',
   VERSIONNO            numeric(3,0) not null  comment '',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection point identifier',
   OPERATINGSTATUS      varchar(16)  comment 'Active or inactive indicator',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONNECTIONPOINTOPERATINGSTA comment 'CONNECTIONPOINTOPERATINGSTA shows whether a connection point';

alter table CONNECTIONPOINTOPERATINGSTA
   add primary key (EFFECTIVEDATE, VERSIONNO, CONNECTIONPOINTID);

/*==============================================================*/
/* Index: CONNECTIONPOINTOPERA_NDX2                             */
/*==============================================================*/
create index CONNECTIONPOINTOPERA_NDX2 on CONNECTIONPOINTOPERATINGSTA
(
   CONNECTIONPOINTID
);

/*==============================================================*/
/* Index: CONNECTIONPOINTOPERATINGS_LCX                         */
/*==============================================================*/
create index CONNECTIONPOINTOPERATINGS_LCX on CONNECTIONPOINTOPERATINGSTA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONSTRAINTRELAXATION_OCD                              */
/*==============================================================*/
create table CONSTRAINTRELAXATION_OCD
(
   SETTLEMENTDATE       datetime not null  comment 'End date and time of the dispatch interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint identifier',
   RHS                  numeric(16,6)  comment 'Relaxed RHS used in attempt to avoid constraint violation',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   VERSIONNO            numeric(3,0) not null default 1  comment 'Version Number'
);

alter table CONSTRAINTRELAXATION_OCD comment 'CONSTRAINTRELAXATION_OCD contains details of interconnector ';

alter table CONSTRAINTRELAXATION_OCD
   add primary key (SETTLEMENTDATE, RUNNO, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Index: CONSTRAINTRELAX_OCD_LCX                               */
/*==============================================================*/
create index CONSTRAINTRELAX_OCD_LCX on CONSTRAINTRELAXATION_OCD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTAGC                                           */
/*==============================================================*/
create table CONTRACTAGC
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'End date of contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   CRR                  numeric(4,0)  comment 'Control Range Raise 5 Min MW',
   CRL                  numeric(4,0)  comment 'Control Range Lower 5 Min MW',
   RLPRICE              numeric(10,2)  comment 'Enabling Price in $',
   CCPRICE              numeric(10,2)  comment 'Compensation Cap in $',
   BS                   numeric(10,2)  comment 'Block Size',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTAGC comment 'CONTRACTAGC shows Automatic Generation Control (AGC) contrac';

alter table CONTRACTAGC
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTAGC_NDX2                                      */
/*==============================================================*/
create index CONTRACTAGC_NDX2 on CONTRACTAGC
(
   PARTICIPANTID,
   CONTRACTID
);

/*==============================================================*/
/* Index: CONTRACTAGC_LCX                                       */
/*==============================================================*/
create index CONTRACTAGC_LCX on CONTRACTAGC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTGOVERNOR                                      */
/*==============================================================*/
create table CONTRACTGOVERNOR
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   CCPRICE              numeric(10,2)  comment 'Compensation Cap',
   LOWER60SECBREAKPOINT numeric(9,6)  comment 'Limit Equation Lower 60 Second Breakpoint MW',
   LOWER60SECMAX        numeric(9,6)  comment 'Limit Equation Lower 60 Second Maximum MW',
   LOWER6SECBREAKPOINT  numeric(9,6)  comment 'Limit Equation Lower 6 Second Breakpoint MW',
   LOWER6SECMAX         numeric(9,6)  comment 'Limit Equation Lower 6 Second Maximum MW',
   RAISE60SECBREAKPOINT numeric(9,6)  comment 'Limit Equation Raise 60 Second Breakpoint MW',
   RAISE60SECCAPACITY   numeric(9,6)  comment 'Limit Equation Raise 60 Second Capacity MW',
   RAISE60SECMAX        numeric(9,6)  comment 'Limit Equation Raise 60 Second Maximum MW',
   RAISE6SECBREAKPOINT  numeric(9,6)  comment 'Limit Equation Raise 6 Second Breakpoint MW',
   RAISE6SECCAPACITY    numeric(9,6)  comment 'Limit Equation Raise 6 Second Capacity MW',
   RAISE6SECMAX         numeric(9,6)  comment 'Limit Equation Raise 6 Second Maximum MW',
   PRICE6SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   QUANT6SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   PRICE6SECRAISECONTRACT numeric(16,6)  comment 'Contract Price for 6 Second Raise',
   QUANT6SECRAISECONTRACT numeric(16,6)  comment 'Contract Quantity for 6 Second Raise',
   PRICE60SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   QUANT60SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   PRICE60SECRAISECONTRACT numeric(16,6)  comment 'Contract Price for 60 Second Raise',
   QUANT60SECRAISECONTRACT numeric(16,6)  comment 'Contract Quantity for 60 Second Raise',
   PRICE6SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   QUANT6SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   PRICE6SECLOWERCONTRACT numeric(16,6)  comment 'Contract Price for 6 Second Lower',
   QUANT6SECLOWERCONTRACT numeric(16,6)  comment 'Contract Quantity for 6 Second Lower',
   PRICE60SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   QUANT60SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   PRICE60SECLOWERCONTRACT numeric(16,6)  comment 'Contract Price for 60 Second Lower',
   QUANT60SECLOWERCONTRACT numeric(16,6)  comment 'Contract Quantity for 60 Second Lower',
   DEADBANDUP           numeric(4,2)  comment 'Raise Deadband',
   DEADBANDDOWN         numeric(4,2)  comment 'Lower Deadband',
   DROOP6SECRAISEBREAKPOINT numeric(9,6)  comment 'Droop Equation Raise 6 Second Breakpoint',
   DROOP6SECRAISECAPACITY numeric(9,6)  comment 'Droop Equation Raise 6 Second Capacity',
   DROOP6SECRAISEMAX    numeric(9,6)  comment 'Droop Equation Raise 6 Second Maximum',
   DROOP60SECRAISEBREAKPOINT numeric(9,6)  comment 'Droop Equation Raise 60 Second Breakpoint',
   DROOP60SECRAISECAPACITY numeric(9,6)  comment 'Droop Equation Raise 60 Second Capacity',
   DROOP60SECRAISEMAX   numeric(9,6)  comment 'Droop Equation Raise 60 Second Maximum',
   DROOP6SECLOWERBREAKPOINT numeric(9,6)  comment 'Droop Equation Lower 6 Second Breakpoint',
   DROOP6SECLOWERMAX    numeric(9,6)  comment 'Droop Equation Lower 6 Second Maximum',
   DROOP60SECLOWERBREAKPOINT numeric(9,6)  comment 'Droop Equation Lower 60 Second Breakpoint',
   DROOP60SECLOWERMAX   numeric(9,6)  comment 'Droop Equation Lower 60 Second Maximum',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTGOVERNOR comment 'CONTRACTGOVERNOR became unused when Ancillary Services Revie';

alter table CONTRACTGOVERNOR
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTGOVERNOR_NDX2                                 */
/*==============================================================*/
create index CONTRACTGOVERNOR_NDX2 on CONTRACTGOVERNOR
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTGOVERNOR_LCX                                  */
/*==============================================================*/
create index CONTRACTGOVERNOR_LCX on CONTRACTGOVERNOR
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTLOADSHED                                      */
/*==============================================================*/
create table CONTRACTLOADSHED
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   LSEPRICE             numeric(6,2)  comment 'The load shed enabling price for this contract',
   MCPPRICE             numeric(12,2)  comment 'Minimum Compensation price',
   TENDEREDPRICE        numeric(6,2)  comment 'Price Tendered for Compensation per Trading interval - Not used since 13/12/1998',
   LSCR                 numeric(6,2)  comment 'Load Shed Control Range',
   ILSCALINGFACTOR      numeric(15,5)  comment 'SPD scaling factor for load shed vs dispatched, (1 = dispatched)',
   LOWER60SECBREAKPOINT numeric(9,6)  comment 'Not used',
   LOWER60SECMAX        numeric(9,6)  comment 'Not used',
   LOWER6SECBREAKPOINT  numeric(9,6)  comment 'Not used',
   LOWER6SECMAX         numeric(9,6)  comment 'Not used',
   RAISE60SECBREAKPOINT numeric(9,6)  comment 'Not used',
   RAISE60SECCAPACITY   numeric(9,6)  comment 'Not used',
   RAISE60SECMAX        numeric(9,6)  comment 'Maximum 60 second raise',
   RAISE6SECBREAKPOINT  numeric(9,6)  comment 'Not used',
   RAISE6SECCAPACITY    numeric(9,6)  comment 'Not used',
   RAISE6SECMAX         numeric(9,6)  comment 'Limit Equation Raise 6 Second Maximum MW',
   PRICE6SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   QUANT6SECRAISEMANDATORY numeric(9,6)  comment 'Not used',
   PRICE6SECRAISECONTRACT numeric(16,6)  comment 'Contract Price for 6 Second Raise',
   QUANT6SECRAISECONTRACT numeric(9,6)  comment 'Contract Quantity for 6 Second Raise',
   PRICE60SECRAISEMANDATORY numeric(16,6)  comment 'Not used',
   QUANT60SECRAISEMANDATORY numeric(9,6)  comment 'Not used',
   PRICE60SECRAISECONTRACT numeric(16,6)  comment 'Not used',
   QUANT60SECRAISECONTRACT numeric(9,6)  comment 'Not used',
   PRICE6SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   QUANT6SECLOWERMANDATORY numeric(9,6)  comment 'Not used',
   PRICE6SECLOWERCONTRACT numeric(16,6)  comment 'Not used',
   QUANT6SECLOWERCONTRACT numeric(9,6)  comment 'Not used',
   PRICE60SECLOWERMANDATORY numeric(16,6)  comment 'Not used',
   QUANT60SECLOWERMANDATORY numeric(9,6)  comment 'Not used',
   PRICE60SECLOWERCONTRACT numeric(16,6)  comment 'Not used',
   QUANT60SECLOWERCONTRACT numeric(9,6)  comment 'Not used',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DEFAULT_TESTINGPAYMENT_AMOUNT numeric(18,8)  comment 'The NMAS default payment amount',
   SERVICE_START_DATE   datetime  comment 'The NMAS Testing Service Start Date'
);

alter table CONTRACTLOADSHED comment 'CONTRACTLOADSHED shows Governor contract details used in the';

alter table CONTRACTLOADSHED
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTLOADSHED_NDX2                                 */
/*==============================================================*/
create index CONTRACTLOADSHED_NDX2 on CONTRACTLOADSHED
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTLOADSHED_LCX                                  */
/*==============================================================*/
create index CONTRACTLOADSHED_LCX on CONTRACTLOADSHED
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTREACTIVEPOWER                                 */
/*==============================================================*/
create table CONTRACTREACTIVEPOWER
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   SYNCCOMPENSATION     varchar(1)  comment 'Sync Compensation Flag - Y for SYNCCOMP',
   MVARAPRICE           numeric(10,2)  comment 'Availability price per MVAr of RP absorption capability',
   MVAREPRICE           numeric(10,2)  comment 'Enabling price',
   MVARGPRICE           numeric(10,2)  comment 'Availability price per MVAr of RP generation capability',
   CCPRICE              numeric(10,2)  comment 'Compensation Cap',
   MTA                  numeric(10,2)  comment 'Reactive Power Absorption Capability (MVAr)',
   MTG                  numeric(10,2)  comment 'Reactive Power Generation Capability (MVAr)',
   MMCA                 numeric(10,2)  comment 'Minimum Capability for MVAr Absorption required by Code',
   MMCG                 numeric(10,2)  comment 'Minimum Capability for MVAr Generation required by Code',
   EU                   numeric(10,2)  comment 'Estimated Power consumption of unit when operating on SYNCCOMP',
   PP                   numeric(10,2)  comment 'Estimated Price for supply',
   BS                   numeric(10,2)  comment 'Block Size of Unit',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DEFAULT_TESTINGPAYMENT_AMOUNT numeric(18,8)  comment 'The NMAS default payment amount',
   SERVICE_START_DATE   datetime  comment 'The NMAS Testing Service Start Date',
   AVAILABILITY_MWH_THRESHOLD numeric(18,8)  comment 'The MWh the unit must produce in a trading interval to be eligible for an excess-to-gen availability payment',
   MVAR_THRESHOLD       numeric(18,8)  comment 'The threshold value for MegaVar (MVAr) to check whether the service is fully available.',
   REBATE_CAP           numeric(18,8)  comment 'The maximum capped amount for the rebate payment.',
   REBATE_AMOUNT_PER_MVAR numeric(18,8)  comment 'The per MVAR rebate amount used to calculate the rebate payment.',
   ISREBATEAPPLICABLE   numeric(1,0)  comment 'Used to check whether the contract is eligible for rebate. For new NSCAS contracts to apply new payment methodology this flag is 1.'
);

alter table CONTRACTREACTIVEPOWER comment 'CONTRACTREACTIVEPOWER shows Reactive Power contract details ';

alter table CONTRACTREACTIVEPOWER
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTREACTIVEPOWE_NDX2                             */
/*==============================================================*/
create index CONTRACTREACTIVEPOWE_NDX2 on CONTRACTREACTIVEPOWER
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTREACTIVEPOWER_LCX                             */
/*==============================================================*/
create index CONTRACTREACTIVEPOWER_LCX on CONTRACTREACTIVEPOWER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTRESERVEFLAG                                   */
/*==============================================================*/
create table CONTRACTRESERVEFLAG
(
   CONTRACTID           varchar(10) not null  comment 'Reserve Trader Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Reserve Trader Contract Version',
   PERIODID             numeric(3,0) not null  comment 'Calendar settlement date period identifier, i.e. period 1 is 00:30',
   RCF                  char(1)  comment 'Reserve Recovery Flag',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTRESERVEFLAG comment 'CONTRACTRESERVEFLAG has never been or will be used. It was t';

alter table CONTRACTRESERVEFLAG
   add primary key (CONTRACTID, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: CONTRACTRESERVEFLAG_LCX                               */
/*==============================================================*/
create index CONTRACTRESERVEFLAG_LCX on CONTRACTRESERVEFLAG
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTRESERVETHRESHOLD                              */
/*==============================================================*/
create table CONTRACTRESERVETHRESHOLD
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version',
   CRA                  numeric(16,6)  comment 'Availability Rate $',
   CRE                  numeric(16,6)  comment 'Enabling Rate $',
   CRU                  numeric(16,6)  comment 'Usage Rate $',
   CTA                  numeric(16,6)  comment 'Availability Threshold MW/h',
   CTE                  numeric(16,6)  comment 'Enabling Threshold MW/h',
   CTU                  numeric(16,6)  comment 'Usage Threshold MW/h',
   AUTHORISEDBY         varchar(15)  comment 'User name',
   AUTHORISEDDATE       datetime  comment 'Date contract was authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTRESERVETHRESHOLD comment 'CONTRACTRESERVETHRESHOLD shows reserve contract threshold de';

alter table CONTRACTRESERVETHRESHOLD
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTRESERVETHRESHOLD_LCX                          */
/*==============================================================*/
create index CONTRACTRESERVETHRESHOLD_LCX on CONTRACTRESERVETHRESHOLD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTRESERVETRADER                                 */
/*==============================================================*/
create table CONTRACTRESERVETRADER
(
   CONTRACTID           varchar(10) not null  comment 'Reserve Trader Contract Identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Terminate Date of contract',
   STARTPERIOD          numeric(3,0)  comment 'Starting period of contract',
   ENDPERIOD            numeric(3,0)  comment 'Terminate period of contract based on calendar date.',
   DEREGISTRATIONDATE   datetime  comment 'De-registration date of contract; Not Used',
   DEREGISTRATIONPERIOD numeric(3,0)  comment 'De-registration period of contract; Not Used',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10)  comment 'Region Identifier'
);

alter table CONTRACTRESERVETRADER comment 'CONTRACTRESERVETRADER shows reserve trader contract details.';

alter table CONTRACTRESERVETRADER
   add primary key (CONTRACTID);

/*==============================================================*/
/* Index: CONTRACTRESERVETRADER_LCX                             */
/*==============================================================*/
create index CONTRACTRESERVETRADER_LCX on CONTRACTRESERVETRADER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTRESTARTSERVICES                               */
/*==============================================================*/
create table CONTRACTRESTARTSERVICES
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   RESTARTTYPE          numeric(1,0)  comment 'Restart Type - 0 = BlackStart, 1 = Combination, 2 = Trip To House',
   RCPRICE              numeric(6,2)  comment 'Availability Price',
   TRIPTOHOUSELEVEL     numeric(5,0)  comment 'Trip To House Level',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DEFAULT_TESTINGPAYMENT_AMOUNT numeric(18,8)  comment 'The NMAS default payment amount',
   SERVICE_START_DATE   datetime  comment 'The NMAS Testing Service Start Date'
);

alter table CONTRACTRESTARTSERVICES comment 'CONTRACTRESTARTSERVICES shows Restart Services contract deta';

alter table CONTRACTRESTARTSERVICES
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTRESTARTSERVI_NDX2                             */
/*==============================================================*/
create index CONTRACTRESTARTSERVI_NDX2 on CONTRACTRESTARTSERVICES
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTRESTARTSERVICES_LCX                           */
/*==============================================================*/
create index CONTRACTRESTARTSERVICES_LCX on CONTRACTRESTARTSERVICES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTRESTARTUNITS                                  */
/*==============================================================*/
create table CONTRACTRESTARTUNITS
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of contract',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AUTHORISEDBY         varchar(15)  comment '',
   AUTHORISEDDATE       datetime  comment ''
);

alter table CONTRACTRESTARTUNITS comment 'CONTRACTRESTARTUNITS shows Restart units provided under a sy';

alter table CONTRACTRESTARTUNITS
   add primary key (CONTRACTID, VERSIONNO, DUID);

/*==============================================================*/
/* Index: CONTRACTRESTARTUNITS_NDX2                             */
/*==============================================================*/
create index CONTRACTRESTARTUNITS_NDX2 on CONTRACTRESTARTUNITS
(
   CONTRACTID
);

/*==============================================================*/
/* Index: CONTRACTRESTARTUNITS_LCX                              */
/*==============================================================*/
create index CONTRACTRESTARTUNITS_LCX on CONTRACTRESTARTUNITS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTUNITLOADING                                   */
/*==============================================================*/
create table CONTRACTUNITLOADING
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   RPRICE               numeric(10,2)  comment 'Enabling Price',
   SUPRICE              numeric(10,2)  comment 'Usage Price',
   CCPRICE              numeric(10,2)  comment 'Compensation Cap',
   ACR                  numeric(10,2)  comment 'Available Control Range',
   BS                   numeric(10,2)  comment 'Block Size of Unit',
   PP                   numeric(10,2)  comment 'Estimated Price for supply',
   EU                   numeric(10,2)  comment 'Estimated Power consumption of unit when enabled for RGUL',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTUNITLOADING comment 'CONTRACTUNITLOADING became unused when Ancillary Services Re';

alter table CONTRACTUNITLOADING
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTUNITLOADING_NDX2                              */
/*==============================================================*/
create index CONTRACTUNITLOADING_NDX2 on CONTRACTUNITLOADING
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTUNITLOADING_LCX                               */
/*==============================================================*/
create index CONTRACTUNITLOADING_LCX on CONTRACTUNITLOADING
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: CONTRACTUNITUNLOADING                                 */
/*==============================================================*/
create table CONTRACTUNITUNLOADING
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract Version No.',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Termination Date of Contract',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   RPRICE               numeric(10,2)  comment 'Enabling Price',
   SUPRICE              numeric(10,2)  comment 'Usage Price',
   CCPRICE              numeric(10,2)  comment 'Compensation Cap',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table CONTRACTUNITUNLOADING comment 'CONTRACTUNITUNLOADING shows Ancillary Service contract data ';

alter table CONTRACTUNITUNLOADING
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: CONTRACTUNITUNLOADIN_NDX2                             */
/*==============================================================*/
create index CONTRACTUNITUNLOADIN_NDX2 on CONTRACTUNITUNLOADING
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: CONTRACTUNITUNLOADING_LCX                             */
/*==============================================================*/
create index CONTRACTUNITUNLOADING_LCX on CONTRACTUNITUNLOADING
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DAYOFFER                                              */
/*==============================================================*/
create table DAYOFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:00am',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version no. for given offer date',
   OFFERDATE            datetime not null  comment 'Offer date of data',
   SELFCOMMITFLAG       varchar(1)  comment 'Not used',
   DAILYENERGYCONSTRAINT numeric(12,6)  comment 'Maximum energy available from Energy Constrained Plant.',
   ENTRYTYPE            varchar(20)  comment 'Daily or Rebid',
   CONTINGENCYPRICE     numeric(9,2)  comment 'Not used',
   REBIDEXPLANATION     varchar(64)  comment 'Explanation for all rebids and inflexibilities',
   BANDQUANTISATIONID   numeric(2,0)  comment 'Not used',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 7',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   MAXRAMPUP            numeric(9,2)  comment 'Not used',
   MAXRAMPDOWN          numeric(9,2)  comment 'Not used',
   MINIMUMLOAD          numeric(6,0)  comment 'Minimum MW load fast start plant in MW',
   T1                   numeric(6,0)  comment 'Time to synchronise in minutes',
   T2                   numeric(6,0)  comment 'Time to minimum load in minutes',
   T3                   numeric(6,0)  comment 'Time at minimum load in minutes',
   T4                   numeric(6,0)  comment 'Time to shutdown in minutes',
   NORMALSTATUS         varchar(3)  comment 'ON/OFF for loads',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_FACTOR            numeric(16,6)  comment 'Mandatory Restriction Price Scaling Factor'
);

alter table DAYOFFER comment 'DAYOFFER sets out the participants daily components of part';

alter table DAYOFFER
   add primary key (SETTLEMENTDATE, DUID, OFFERDATE, VERSIONNO);

/*==============================================================*/
/* Index: DAYOFFER_NDX2                                         */
/*==============================================================*/
create index DAYOFFER_NDX2 on DAYOFFER
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: DAYOFFER_LCX                                          */
/*==============================================================*/
create index DAYOFFER_LCX on DAYOFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DAYOFFER_D                                            */
/*==============================================================*/
create table DAYOFFER_D
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:00am',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version no. for given offer date',
   OFFERDATE            datetime not null  comment 'Offer date of data',
   SELFCOMMITFLAG       varchar(1)  comment 'Not used',
   DAILYENERGYCONSTRAINT numeric(12,6)  comment 'Maximum energy available from Energy Constrained Plant.',
   ENTRYTYPE            varchar(20)  comment 'Daily or Rebid',
   CONTINGENCYPRICE     numeric(9,2)  comment 'Not used',
   REBIDEXPLANATION     varchar(64)  comment 'Explanation for all rebids and inflexibilities',
   BANDQUANTISATIONID   numeric(2,0)  comment 'Not used',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 7',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   MAXRAMPUP            numeric(9,2)  comment 'Not used',
   MAXRAMPDOWN          numeric(9,2)  comment 'Not used',
   MINIMUMLOAD          numeric(6,0)  comment 'Minimum MW load fast start plant in MW',
   T1                   numeric(6,0)  comment 'Time to synchronise in minutes',
   T2                   numeric(6,0)  comment 'Time to minimum load in minutes',
   T3                   numeric(6,0)  comment 'Time at minimum load in minutes',
   T4                   numeric(6,0)  comment 'Time to shutdown in minutes',
   NORMALSTATUS         varchar(3)  comment 'ON/OFF for loads',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_FACTOR            numeric(6,0)  comment 'Mandatory Restriction Price Scaling Factor'
);

alter table DAYOFFER_D comment 'DAYOFFER_D sets out the participants daily components of pa';

alter table DAYOFFER_D
   add primary key (SETTLEMENTDATE, DUID, OFFERDATE, VERSIONNO);

/*==============================================================*/
/* Index: DAYOFFER_D_NDX2                                       */
/*==============================================================*/
create index DAYOFFER_D_NDX2 on DAYOFFER_D
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: DAYOFFER_D_LCX                                        */
/*==============================================================*/
create index DAYOFFER_D_LCX on DAYOFFER_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DAYTRACK                                              */
/*==============================================================*/
create table DAYTRACK
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   REGIONID             varchar(10)  comment 'Not Used',
   EXANTERUNSTATUS      varchar(15)  comment 'This is to determine whether the Settlement Run is a valid run or not.',
   EXANTERUNNO          numeric(3,0)  comment 'Not Used',
   EXPOSTRUNSTATUS      varchar(15)  comment 'Estimate for DAILY/INITIAL and Actual for PRELIM/FINAL and REVISE.',
   EXPOSTRUNNO          numeric(3,0) not null  comment 'Settlement Run No',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SETTLEMENTINTERVALLENGTH numeric(3,0)  comment 'Length of a settlement interval, in minutes (was 30 minutes, will be 5 minutes starting the commencement of 5MS rule change date).',
   METER_CASEID         numeric(5,0)  comment 'The Metering Case Id used for the Settlement Run. For Estimate Daily Run this will be 0',
   METER_RUNTYPE        varchar(10)  comment 'The Type of Settlement Run(ESTIMATE/PRELIM/FINAL/REVISE)'
);

alter table DAYTRACK comment 'DAYTRACK identifies the actual settlement run processed for ';

alter table DAYTRACK
   add primary key (SETTLEMENTDATE, EXPOSTRUNNO);

/*==============================================================*/
/* Index: DAYTRACK_LCX                                          */
/*==============================================================*/
create index DAYTRACK_LCX on DAYTRACK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DEFAULTDAYOFFER                                       */
/*==============================================================*/
create table DEFAULTDAYOFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:30',
   DUID                 varchar(10) not null  comment 'Dispatchable unit Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version No for given offer date',
   SELFCOMMITFLAG       varchar(1)  comment 'Not used',
   DAILYENERGYCONSTRAINT numeric(12,6)  comment 'Maximum energy available from Energy Constrained Plant.',
   ENTRYTYPE            varchar(20)  comment 'Daily or Rebid',
   CONTINGENCYPRICE     numeric(9,2)  comment 'Not used',
   REBIDEXPLANATION     varchar(64)  comment 'Explanation for all rebids and inflexibilities',
   BANDQUANTISATIONID   numeric(2,0)  comment 'Not used',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 7',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   MAXRAMPUP            numeric(9,2)  comment 'Not used',
   MAXRAMPDOWN          numeric(9,2)  comment 'Not used',
   MINIMUMLOAD          numeric(6,0)  comment 'Minimum stable load',
   T1                   numeric(6,0)  comment 'Time to synchronise in minutes',
   T2                   numeric(6,0)  comment 'Time to minimum load in minutes',
   T3                   numeric(6,0)  comment 'Time at minimum load in minutes',
   T4                   numeric(6,0)  comment 'Time to shut down in minutes',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DEFAULTDAYOFFER comment 'DEFAULTDAYOFFER shows day-based details of participants def';

alter table DEFAULTDAYOFFER
   add primary key (SETTLEMENTDATE, DUID, VERSIONNO);

/*==============================================================*/
/* Index: DEFAULTDAYOFFER_LCX                                   */
/*==============================================================*/
create index DEFAULTDAYOFFER_LCX on DEFAULTDAYOFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DEFAULTOFFERTRK                                       */
/*==============================================================*/
create table DEFAULTOFFERTRK
(
   DUID                 varchar(10) not null  comment 'Dispatchable Unit Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date default offer file is effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of file for this date',
   FILENAME             varchar(40)  comment 'Load File identifier',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DEFAULTOFFERTRK comment 'DEFAULTOFFERTRK shows the file names of default offers submi';

alter table DEFAULTOFFERTRK
   add primary key (DUID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: DEFAULTOFFERTRK_LCX                                   */
/*==============================================================*/
create index DEFAULTOFFERTRK_LCX on DEFAULTOFFERTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DEFAULTPEROFFER                                       */
/*==============================================================*/
create table DEFAULTPEROFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:30',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit Identifier',
   PERIODID             numeric(3,0) not null  comment 'Market data. Trading Interval number',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of the offer file.',
   SELFDISPATCH         numeric(9,6)  comment 'Not used',
   MAXAVAIL             numeric(12,6)  comment 'Maximum planned availability MW',
   FIXEDLOAD            numeric(9,6)  comment 'Fixed unit output MW. A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   ROCUP                numeric(6,0)  comment 'Rate of change up MW/min',
   ROCDOWN              numeric(6,0)  comment 'Rate of change down MW/min',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   BANDAVAIL1           numeric(6,0)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(6,0)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(6,0)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(6,0)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(6,0)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(6,0)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(6,0)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(6,0)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(6,0)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(6,0)  comment 'Availability at price band 10',
   PASAAVAILABILITY     numeric(12,0)  comment 'The physical plant capability including any capability potentially available within 24 hours.'
);

alter table DEFAULTPEROFFER comment 'DEFAULTPEROFFER shows half hourly period-based data in the d';

alter table DEFAULTPEROFFER
   add primary key (DUID, SETTLEMENTDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: DEFAULTPEROFFER_LCX                                   */
/*==============================================================*/
create index DEFAULTPEROFFER_LCX on DEFAULTPEROFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DELTAMW                                               */
/*==============================================================*/
create table DELTAMW
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:30',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of record for this date',
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   PERIODID             numeric(2,0) not null  comment 'Market trading interval from 1 to 48 starting at 04:30',
   DELTAMW              numeric(6,0)  comment 'Not Used',
   LOWER5MIN            numeric(6,0)  comment 'Lower 5 min local share requirement',
   LOWER60SEC           numeric(6,0)  comment 'Lower 60 sec local share requirement',
   LOWER6SEC            numeric(6,0)  comment 'Lower 6 sec local share requirement',
   RAISE5MIN            numeric(6,0)  comment 'Raise 5 minute local share requirement',
   RAISE60SEC           numeric(6,0)  comment 'Raise 60 sec local share requirement',
   RAISE6SEC            numeric(6,0)  comment 'Raise 6 sec local share requirement',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   RAISEREG             numeric(6,0)  comment 'Raise Regulation local share requirement',
   LOWERREG             numeric(6,0)  comment 'Lower Regulation local share requirement'
);

alter table DELTAMW comment 'DELTAMW sets out the Frequency Control Ancillary Services (F';

alter table DELTAMW
   add primary key (SETTLEMENTDATE, VERSIONNO, REGIONID, PERIODID);

/*==============================================================*/
/* Index: DELTAMW_LCX                                           */
/*==============================================================*/
create index DELTAMW_LCX on DELTAMW
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DEMANDOPERATIONALACTUAL                               */
/*==============================================================*/
create table DEMANDOPERATIONALACTUAL
(
   INTERVAL_DATETIME    datetime not null  comment 'Date time interval for operational demand value',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   OPERATIONAL_DEMAND   numeric(10,0)  comment 'Average 30-minute measured operational demand MW value (unadjusted)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   OPERATIONAL_DEMAND_ADJUSTMENT numeric(10,0)  comment 'Adjustment value containing the estimated amount of activated RERT and involuntary load shedding that occurred as a result of a NER 4.8.9 instruction for load shedding from AEMO.',
   WDR_ESTIMATE         numeric(10,0)  comment 'Estimated average 30-minute MW amount of Wholesale Demand Response that occurred'
);

alter table DEMANDOPERATIONALACTUAL comment 'Shows Actual Operational Demand for a particular date time i';

alter table DEMANDOPERATIONALACTUAL
   add primary key (INTERVAL_DATETIME, REGIONID);

/*==============================================================*/
/* Table: DEMANDOPERATIONALFORECAST                             */
/*==============================================================*/
create table DEMANDOPERATIONALFORECAST
(
   INTERVAL_DATETIME    datetime not null  comment 'Forecast for a particular date time interval',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   LOAD_DATE            datetime  comment 'Date time this forecast was produced',
   OPERATIONAL_DEMAND_POE10 numeric(15,2)  comment '10% probability of exceedance operational demand forecast value',
   OPERATIONAL_DEMAND_POE50 numeric(15,2)  comment '50% probability of exceedance operational demand forecast value',
   OPERATIONAL_DEMAND_POE90 numeric(15,2)  comment '90% probability of exceedance operational demand forecast value',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DEMANDOPERATIONALFORECAST comment 'Shows Forecast Operational Demand for a particular date time';

alter table DEMANDOPERATIONALFORECAST
   add primary key (INTERVAL_DATETIME, REGIONID);

/*==============================================================*/
/* Table: DISPATCHABLEUNIT                                      */
/*==============================================================*/
create table DISPATCHABLEUNIT
(
   DUID                 varchar(10) not null  comment 'Dispatchable Unit Identifier',
   DUNAME               varchar(20)  comment 'Dispatchable Unit full description',
   UNITTYPE             varchar(20)  comment 'Identifies LOAD, GENERATOR or BIDIRECTIONAL',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHABLEUNIT comment 'DISPATCHABLEUNIT sets out the unit name and type of each dis';

alter table DISPATCHABLEUNIT
   add primary key (DUID);

/*==============================================================*/
/* Index: DISPATCHABLEUNIT_LCX                                  */
/*==============================================================*/
create index DISPATCHABLEUNIT_LCX on DISPATCHABLEUNIT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHBIDTRK                                        */
/*==============================================================*/
create table DISPATCHBIDTRK
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no from 1 to 288 (as per bid)',
   OFFEREFFECTIVEDATE   datetime not null  comment 'Effective date of offer used',
   OFFERVERSIONNO       numeric(3,0) not null  comment 'Version no of offer used',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   BIDTYPE              varchar(10)  comment 'Bid type (daily, default or rebid)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHBIDTRK comment 'DISPATCHBIDTRK shows the bid tracking, including the bid ver';

alter table DISPATCHBIDTRK
   add primary key (SETTLEMENTDATE, RUNNO, OFFEREFFECTIVEDATE, OFFERVERSIONNO, DUID);

/*==============================================================*/
/* Index: DISPATCHBIDTRK_NDX2                                   */
/*==============================================================*/
create index DISPATCHBIDTRK_NDX2 on DISPATCHBIDTRK
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: DISPATCHBIDTRK_LCX                                    */
/*==============================================================*/
create index DISPATCHBIDTRK_LCX on DISPATCHBIDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHBLOCKEDCONSTRAINT                             */
/*==============================================================*/
create table DISPATCHBLOCKEDCONSTRAINT
(
   SETTLEMENTDATE       datetime not null  comment 'Dispatch Interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint identifier (synonymous with GenConID)'
);

alter table DISPATCHBLOCKEDCONSTRAINT comment 'DISPATCH Blocked Constraints lists any constraints that were';

alter table DISPATCHBLOCKEDCONSTRAINT
   add primary key (SETTLEMENTDATE, RUNNO, CONSTRAINTID);

/*==============================================================*/
/* Table: DISPATCHCASESOLUTION                                  */
/*==============================================================*/
create table DISPATCHCASESOLUTION
(
   SETTLEMENTDATE       datetime not null  comment 'Date and time of the dispatch interval (e.g. five minute dispatch interval ending 28/09/2000 16:35)',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention flag - refer to package documentation for definition and practical query examples',
   CASESUBTYPE          varchar(3)  comment 'Overconstrained dispatch indicator: 
             * OCD = detecting over-constrained dispatch
             * null = no special condition',
   SOLUTIONSTATUS       numeric(2,0)  comment 'If non-zero indicated one of the following conditions:
             * 1 = Supply Scarcity, Excess generation or constraint violations
             * X = Model failure',
   SPDVERSION           varchar(20)  comment 'Current version of SPD',
   NONPHYSICALLOSSES    numeric(1,0)  comment 'Non-Physical Losses algorithm invoked occurred during this run',
   TOTALOBJECTIVE       numeric(27,10)  comment 'The Objective function from the LP',
   TOTALAREAGENVIOLATION numeric(15,5)  comment 'Total Region Demand violations',
   TOTALINTERCONNECTORVIOLATION numeric(15,5)  comment 'Total interconnector violations',
   TOTALGENERICVIOLATION numeric(15,5)  comment 'Total generic constraint violations',
   TOTALRAMPRATEVIOLATION numeric(15,5)  comment 'Total ramp rate violations',
   TOTALUNITMWCAPACITYVIOLATION numeric(15,5)  comment 'Total unit capacity violations',
   TOTAL5MINVIOLATION   numeric(15,5)  comment 'Total of 5 minute ancillary service region violations',
   TOTALREGVIOLATION    numeric(15,5)  comment 'Total of Regulation ancillary service region violations',
   TOTAL6SECVIOLATION   numeric(15,5)  comment 'Total of 6 second ancillary service region violations',
   TOTAL60SECVIOLATION  numeric(15,5)  comment 'Total of 60 second ancillary service region violations',
   TOTALASPROFILEVIOLATION numeric(15,5)  comment 'Total of ancillary service trader profile violations',
   TOTALFASTSTARTVIOLATION numeric(15,5)  comment 'Total of fast start trader profile violations',
   TOTALENERGYOFFERVIOLATION numeric(15,5)  comment 'Total of unit summated offer band violations',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SWITCHRUNINITIALSTATUS numeric(1,0)  comment 'Flag indicating the SCADA status for FCAS Interconnector dead-band. "0" if SCADA Status or requesting Constraint not invoked. "1" if SCADA Status AND requesting Constraint is invoked',
   SWITCHRUNBESTSTATUS  numeric(1,0)  comment 'Flag indicating which Switch run was used for the Solution  from PeriodSolution',
   SWITCHRUNBESTSTATUS_INT numeric(1,0)  comment 'Flag indicating which Switch run was used for the Intervention Physical Solution - from PeriodSolution'
);

alter table DISPATCHCASESOLUTION comment 'DISPATCHCASESOLUTION shows information relating to the compl';

alter table DISPATCHCASESOLUTION
   add primary key (SETTLEMENTDATE, RUNNO);

/*==============================================================*/
/* Index: DISPATCHCASESOLUTION_LCX                              */
/*==============================================================*/
create index DISPATCHCASESOLUTION_LCX on DISPATCHCASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHCASESOLUTION_BNC                              */
/*==============================================================*/
create table DISPATCHCASESOLUTION_BNC
(
   SETTLEMENTDATE       datetime not null  comment 'End date and time of the dispatch interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Manual intervention flag',
   CASESUBTYPE          varchar(3)  comment 'always BNC',
   SOLUTIONSTATUS       numeric(2,0)  comment 'If non-zero indicated one of the following conditions:
             * 1 = Supply Scarcity, Excess generation or constraint violations
             * X = Model failure',
   SPDVERSION           numeric(10,3)  comment 'Current version of SPD',
   STARTPERIOD          varchar(20)  comment 'Period identifier of first interval of the case (yyyymmddppp)',
   NONPHYSICALLOSSES    numeric(1,0)  comment 'Non-Physical Losses algorithm invoked occurred during this run',
   TOTALOBJECTIVE       numeric(27,10)  comment 'The Objective function from the LP',
   TOTALAREAGENVIOLATION numeric(15,5)  comment 'Total Region Demand violations',
   TOTALINTERCONNECTORVIOLATION numeric(15,5)  comment 'Total interconnector violations',
   TOTALGENERICVIOLATION numeric(15,5)  comment 'Total generic constraint violations',
   TOTALRAMPRATEVIOLATION numeric(15,5)  comment 'Total ramp rate violations',
   TOTALUNITMWCAPACITYVIOLATION numeric(15,5)  comment 'Total unit capacity violations',
   TOTAL5MINVIOLATION   numeric(15,5)  comment 'Total of 5 minute ancillary service region violations',
   TOTALREGVIOLATION    numeric(15,5)  comment 'Total of Regulation ancillary service region violations',
   TOTAL6SECVIOLATION   numeric(15,5)  comment 'Total of 6 second ancillary service region violations',
   TOTAL60SECVIOLATION  numeric(15,5)  comment 'Total of 60 second ancillary service region violations',
   TOTALENERGYCONSTRVIOLATION numeric(15,5)  comment '',
   TOTALENERGYOFFERVIOLATION numeric(15,5)  comment 'Total of unit summated offer band violations',
   TOTALASPROFILEVIOLATION numeric(15,5)  comment 'Total of ancillary service trader profile violations',
   TOTALFASTSTARTVIOLATION numeric(15,5)  comment 'Total of fast start trader profile violations',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHCASESOLUTION_BNC comment 'DISPATCHCASESOLUTION_BNC was discontinued on 30 September 20';

alter table DISPATCHCASESOLUTION_BNC
   add primary key (SETTLEMENTDATE, RUNNO, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHCASESOLUTION_BNC_LCX                          */
/*==============================================================*/
create index DISPATCHCASESOLUTION_BNC_LCX on DISPATCHCASESOLUTION_BNC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHCASE_OCD                                      */
/*==============================================================*/
create table DISPATCHCASE_OCD
(
   SETTLEMENTDATE       datetime not null  comment 'End date and time of the dispatch interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHCASE_OCD comment 'DISPATCHCASE_OCD shows the key data to indicate when an over';

alter table DISPATCHCASE_OCD
   add primary key (SETTLEMENTDATE, RUNNO);

/*==============================================================*/
/* Index: DISPATCHCASE_OCD_LCX                                  */
/*==============================================================*/
create index DISPATCHCASE_OCD_LCX on DISPATCHCASE_OCD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHCONSTRAINT                                    */
/*==============================================================*/
create table DISPATCHCONSTRAINT
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint identifier (synonymous with GenConID)',
   DISPATCHINTERVAL     numeric(22,0) not null  comment 'Dispatch period identifier, from 001 to 288 in format YYYYMMDDPPP.',
   INTERVENTION         numeric(2,0) not null  comment 'Manual Intervention flag, which, if set (1), causes predispatch to solve twice.',
   RHS                  numeric(15,5)  comment 'Right hand Side value as used in dispatch.',
   MARGINALVALUE        numeric(15,5)  comment '$ Value of binding constraint',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Degree of violation in MW',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DUID                 varchar(20)  comment 'DUID to which the Constraint is confidential. Null denotes non-confidential',
   GENCONID_EFFECTIVEDATE datetime  comment 'Effective date of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   GENCONID_VERSIONNO   numeric(22,0)  comment 'Version number of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   LHS                  numeric(15,5)  comment 'Aggregation of the constraints LHS term solution values'
);

alter table DISPATCHCONSTRAINT comment 'DISPATCHCONSTRAINT sets out details of all binding and inter';

alter table DISPATCHCONSTRAINT
   add primary key (SETTLEMENTDATE, RUNNO, CONSTRAINTID, DISPATCHINTERVAL, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHCONSTRAINT_NDX2                               */
/*==============================================================*/
create index DISPATCHCONSTRAINT_NDX2 on DISPATCHCONSTRAINT
(
   SETTLEMENTDATE
);

/*==============================================================*/
/* Index: DISPATCHCONSTRAINT_LCX                                */
/*==============================================================*/
create index DISPATCHCONSTRAINT_LCX on DISPATCHCONSTRAINT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHINTERCONNECTORRES                             */
/*==============================================================*/
create table DISPATCHINTERCONNECTORRES
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector identifier',
   DISPATCHINTERVAL     numeric(22,0) not null  comment 'Dispatch period identifier, from 001 to 288 in format YYYYMMDDPPP.',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention case or not',
   METEREDMWFLOW        numeric(15,5)  comment 'Metered MW Flow from SCADA.',
   MWFLOW               numeric(15,5)  comment 'Target MW Flow for next 5 mins.',
   MWLOSSES             numeric(15,5)  comment 'Calculated MW Losses',
   MARGINALVALUE        numeric(15,5)  comment 'Shadow price resulting from thermal or reserve sharing constraints on Interconnector import/export (0 unless binding) - NEMDE Solution InterconnectorSolution element "Price" attribute',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Degree of violation on interconnector constraints',
   LASTCHANGED          datetime  comment 'Last changed.',
   EXPORTLIMIT          numeric(15,5)  comment 'Calculated export limit applying to energy only.',
   IMPORTLIMIT          numeric(15,5)  comment 'Calculated import limit applying to energy only.',
   MARGINALLOSS         numeric(15,5)  comment 'Marginal loss factor. Use this to adjust prices between regions.',
   EXPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the export limit',
   IMPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the import limit',
   FCASEXPORTLIMIT      numeric(15,5)  comment 'Calculated export limit applying to energy + FCAS.',
   FCASIMPORTLIMIT      numeric(15,5)  comment 'Calculated import limit applying to energy + FCAS.',
   LOCAL_PRICE_ADJUSTMENT_EXPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Export (Factor >= 0)',
   LOCALLY_CONSTRAINED_EXPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Export: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LOCAL_PRICE_ADJUSTMENT_IMPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Import (Factor >= 0)',
   LOCALLY_CONSTRAINED_IMPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Import: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints'
);

alter table DISPATCHINTERCONNECTORRES comment 'DISPATCHINTERCONNECTORRES sets out MW flow and losses on eac';

alter table DISPATCHINTERCONNECTORRES
   add primary key (SETTLEMENTDATE, RUNNO, INTERCONNECTORID, DISPATCHINTERVAL, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHINTERCONNECTORRES_LCX                         */
/*==============================================================*/
create index DISPATCHINTERCONNECTORRES_LCX on DISPATCHINTERCONNECTORRES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHLOAD                                          */
/*==============================================================*/
create table DISPATCHLOAD
(
   SETTLEMENTDATE       datetime not null  comment 'Market date and time starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   TRADETYPE            numeric(2,0)  comment 'Not used',
   DISPATCHINTERVAL     numeric(22,0)  comment 'Dispatch period identifier, from 001 to 288 in format YYYYMMDDPPP.',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention flag if intervention run',
   CONNECTIONPOINTID    varchar(12)  comment 'Connection point identifier for DUID',
   DISPATCHMODE         numeric(2,0)  comment 'Dispatch mode for fast start plant (0 to 4).',
   AGCSTATUS            numeric(2,0)  comment 'AGC Status from EMS
             * 1 = on
             * 0 = off',
   INITIALMW            numeric(15,5)  comment 'Initial MW at start of period. Negative values when Bi-directional Unit start from importing power, otherwise positive.',
   TOTALCLEARED         numeric(15,5)  comment 'Target MW for end of period. Negative values when Bi-directional Unit is importing power, otherwise positive.',
   RAMPDOWNRATE         numeric(15,5)  comment 'Ramp down rate used in dispatch (lesser of bid or telemetered rate).',
   RAMPUPRATE           numeric(15,5)  comment 'Ramp up rate (lesser of bid or telemetered rate).',
   LOWER5MIN            numeric(15,5)  comment 'Lower 5 min reserve target',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 sec reserve target',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 sec reserve target',
   RAISE5MIN            numeric(15,5)  comment 'Raise 5 min reserve target',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 sec reserve target',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 sec reserve target',
   DOWNEPF              numeric(15,5)  comment 'Not Used',
   UPEPF                numeric(15,5)  comment 'Not Used',
   MARGINAL5MINVALUE    numeric(15,5)  comment 'Marginal $ value for 5 min',
   MARGINAL60SECVALUE   numeric(15,5)  comment 'Marginal $ value for 60 seconds',
   MARGINAL6SECVALUE    numeric(15,5)  comment 'Marginal $ value for 6 seconds',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal $ value for energy',
   VIOLATION5MINDEGREE  numeric(15,5)  comment 'Violation MW 5 min',
   VIOLATION60SECDEGREE numeric(15,5)  comment 'Violation MW 60 seconds',
   VIOLATION6SECDEGREE  numeric(15,5)  comment 'Violation MW 6 seconds',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Violation MW energy',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   LOWERREG             numeric(15,5)  comment 'Lower Regulation reserve target',
   RAISEREG             numeric(15,5)  comment 'Raise Regulation reserve target',
   AVAILABILITY         numeric(15,5)  comment 'For Scheduled units, this is the MAXAVAIL bid availability For Semi-scheduled units, this is the lower of MAXAVAIL bid availability and UIGF',
   RAISE6SECFLAGS       numeric(3,0)  comment 'Raise 6sec status flag  - see',
   RAISE60SECFLAGS      numeric(3,0)  comment 'Raise 60sec status flag  - see',
   RAISE5MINFLAGS       numeric(3,0)  comment '',
   RAISEREGFLAGS        numeric(3,0)  comment 'Raise Reg status flag  - see',
   LOWER6SECFLAGS       numeric(3,0)  comment 'Lower 6sec status flag  - see',
   LOWER60SECFLAGS      numeric(3,0)  comment 'Lower 60sec status flag',
   LOWER5MINFLAGS       numeric(3,0)  comment 'Lower 5min status flag',
   LOWERREGFLAGS        numeric(3,0)  comment 'Lower Reg status flag  - see',
   RAISEREGAVAILABILITY numeric(15,5)  comment 'RaiseReg availability - minimum of bid and telemetered value',
   RAISEREGENABLEMENTMAX numeric(15,5)  comment 'RaiseReg enablement max point - minimum of bid and telemetered value',
   RAISEREGENABLEMENTMIN numeric(15,5)  comment 'RaiseReg Enablement Min point - maximum of bid and telemetered value',
   LOWERREGAVAILABILITY numeric(15,5)  comment 'Lower Reg availability - minimum of bid and telemetered value',
   LOWERREGENABLEMENTMAX numeric(15,5)  comment 'Lower Reg enablement Max point - minimum of bid and telemetered value',
   LOWERREGENABLEMENTMIN numeric(15,5)  comment 'Lower Reg Enablement Min point - maximum of bid and telemetered value',
   RAISE6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 6sec availability',
   RAISE60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 60sec availability',
   RAISE5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 5min availability',
   RAISEREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise reg availability',
   LOWER6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 6sec availability',
   LOWER60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 60sec availability',
   LOWER5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 5min availability',
   LOWERREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower reg availability',
   SEMIDISPATCHCAP      numeric(3,0)  comment 'Boolean representation flagging if the Target is Capped',
   DISPATCHMODETIME     numeric(4,0)  comment 'Minutes for which the unit has been in the current DISPATCHMODE. From NEMDE TRADERSOLUTION element FSTARGETMODETIME attribute.',
   CONFORMANCE_MODE     numeric(6,0)  comment 'Mode specific to units within an aggregate. 0 - no monitoring, 1 - aggregate monitoring, 2 - individual monitoring due to constraint',
   UIGF                 numeric(15,5)  comment 'For Semi-Scheduled units. Unconstrained Intermittent Generation Forecast value provided to NEMDE',
   RAISE1SEC            numeric(15,5)  comment 'Dispatched Raise1Sec - TraderSolution element R1Target attribute',
   RAISE1SECFLAGS       numeric(3,0)  comment 'TraderSolution element R1Flags attribute',
   LOWER1SEC            numeric(15,5)  comment 'Dispatched Lower1Sec - TraderSolution element L1Target attribute',
   LOWER1SECFLAGS       numeric(3,0)  comment 'TraderSolution element L1Flags attribute',
   RAISE1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Raise 1Sec Availability',
   LOWER1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Lower 1Sec Availability',
   INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'The energy storage at the start of this dispatch interval(MWh)',
   ENERGY_STORAGE       numeric(15,5)  comment 'The projected energy storage based on cleared energy and regulation FCAS dispatch(MWh)',
   MIN_AVAILABILITY     numeric(15,5)  comment 'BDU only. Load side availability (BidOfferPeriod.MAXAVAIL where DIRECTION = LOAD)',
   ELEMENT_CAP          numeric(5,0)  comment 'Cap on the number of turbines or inverters at a DUID.'
);

alter table DISPATCHLOAD comment 'DISPATCHLOAD set out the current SCADA MW and target MW for ';

alter table DISPATCHLOAD
   add primary key (SETTLEMENTDATE, RUNNO, DUID, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHLOAD_LCX                                      */
/*==============================================================*/
create index DISPATCHLOAD_LCX on DISPATCHLOAD
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: DISPATCHLOAD_NDX2                                     */
/*==============================================================*/
create index DISPATCHLOAD_NDX2 on DISPATCHLOAD
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHLOAD_BNC                                      */
/*==============================================================*/
create table DISPATCHLOAD_BNC
(
   SETTLEMENTDATE       datetime not null  comment 'End date and time of the dispatch interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention flag if intervention run',
   CONNECTIONPOINTID    varchar(12)  comment 'Connection point identifier for DUID',
   DISPATCHMODE         numeric(2,0)  comment 'Dispatch mode for fast start plant (0 to 4).',
   TOTALCLEARED         numeric(15,5)  comment 'Target MW for end of period',
   RAISEREG             numeric(15,5)  comment 'Raise Regulation reserve target',
   RAISE5MIN            numeric(15,5)  comment 'Raise 5 min reserve target',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 sec reserve target',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 sec reserve target',
   LOWERREG             numeric(15,5)  comment 'Lower Regulation reserve target',
   LOWER5MIN            numeric(15,5)  comment 'Lower 5 min reserve target',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 sec reserve target',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 sec reserve target',
   RAISEREGFLAGS        numeric(3,0)  comment 'Raise Reg status flag',
   RAISE5MINFLAGS       numeric(3,0)  comment 'Raise 5min status flag',
   RAISE60SECFLAGS      numeric(3,0)  comment 'Raise 60sec status flag',
   RAISE6SECFLAGS       numeric(3,0)  comment 'Raise 6sec status flag',
   LOWERREGFLAGS        numeric(3,0)  comment 'Lower Reg status flag',
   LOWER5MINFLAGS       numeric(3,0)  comment 'Lower 5min status flag',
   LOWER60SECFLAGS      numeric(3,0)  comment 'Lower 60sec status flag',
   LOWER6SECFLAGS       numeric(3,0)  comment 'Lower 6sec status flag',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHLOAD_BNC comment 'DISPATCHLOAD_BNC was discontinued on 30 September 2009. Prio';

alter table DISPATCHLOAD_BNC
   add primary key (SETTLEMENTDATE, RUNNO, DUID, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHLOAD_BNC_LCX                                  */
/*==============================================================*/
create index DISPATCHLOAD_BNC_LCX on DISPATCHLOAD_BNC
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: DISPATCHLOAD_BNC_NDX2                                 */
/*==============================================================*/
create index DISPATCHLOAD_BNC_NDX2 on DISPATCHLOAD_BNC
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHOFFERTRK                                      */
/*==============================================================*/
create table DISPATCHOFFERTRK
(
   SETTLEMENTDATE       datetime not null  comment 'Date and time of the dispatch interval (e.g. five minute dispatch interval ending 28/09/2000 16:35)',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   BIDTYPE              varchar(10) not null  comment 'Bid type Identifier - the ancillary service to which the bid applies',
   BIDSETTLEMENTDATE    datetime  comment 'Settlement date of bid applied',
   BIDOFFERDATE         datetime(3)  comment 'Time this bid was processed and loaded',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHOFFERTRK comment 'DISPATCHOFFERTRK is the energy and ancillary service bid tra';

alter table DISPATCHOFFERTRK
   add primary key (SETTLEMENTDATE, DUID, BIDTYPE);

/*==============================================================*/
/* Index: DISPATCHOFFERTRK_LCHD_IDX                             */
/*==============================================================*/
create index DISPATCHOFFERTRK_LCHD_IDX on DISPATCHOFFERTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: DISPATCHOFFERTRK_NDX2                                 */
/*==============================================================*/
create index DISPATCHOFFERTRK_NDX2 on DISPATCHOFFERTRK
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHPRICE                                         */
/*==============================================================*/
create table DISPATCHPRICE
(
   SETTLEMENTDATE       datetime not null  comment 'Market date and time starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   DISPATCHINTERVAL     varchar(22) not null  comment 'Dispatch interval identifier 001 to 288 in format YYYYMMDDPPP',
   INTERVENTION         numeric(2,0) not null  comment 'Manual intervention flag',
   RRP                  numeric(15,5)  comment 'Regional Reference Price for this dispatch period. RRP is the price used to settle the market',
   EEP                  numeric(15,5)  comment 'Excess energy price - no longer used',
   ROP                  numeric(15,5)  comment 'Regional Override Price, being the original price prior to any price scaling, price capping or VoLL override being applied. The APC flag allows the determination of whether capping, scaling or override occurred',
   APCFLAG              numeric(3,0)  comment 'APC Active flag (see note)',
   MARKETSUSPENDEDFLAG  numeric(3,0)  comment 'Market suspended flag',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   RAISE6SECRRP         numeric(15,5)  comment '',
   RAISE6SECROP         numeric(15,5)  comment '',
   RAISE6SECAPCFLAG     numeric(3,0)  comment '',
   RAISE60SECRRP        numeric(15,5)  comment '',
   RAISE60SECROP        numeric(15,5)  comment '',
   RAISE60SECAPCFLAG    numeric(3,0)  comment '',
   RAISE5MINRRP         numeric(15,5)  comment '',
   RAISE5MINROP         numeric(15,5)  comment '',
   RAISE5MINAPCFLAG     numeric(3,0)  comment '',
   RAISEREGRRP          numeric(15,5)  comment '',
   RAISEREGROP          numeric(15,5)  comment '',
   RAISEREGAPCFLAG      numeric(3,0)  comment '',
   LOWER6SECRRP         numeric(15,5)  comment '',
   LOWER6SECROP         numeric(15,5)  comment '',
   LOWER6SECAPCFLAG     numeric(3,0)  comment '',
   LOWER60SECRRP        numeric(15,5)  comment '',
   LOWER60SECROP        numeric(15,5)  comment '',
   LOWER60SECAPCFLAG    numeric(3,0)  comment '',
   LOWER5MINRRP         numeric(15,5)  comment '',
   LOWER5MINROP         numeric(15,5)  comment '',
   LOWER5MINAPCFLAG     numeric(3,0)  comment '',
   LOWERREGRRP          numeric(15,5)  comment '',
   LOWERREGROP          numeric(15,5)  comment '',
   LOWERREGAPCFLAG      numeric(3,0)  comment '',
   PRICE_STATUS         varchar(20)  comment 'Status of regional prices for this dispatch interval "NOT FIRM" or "FIRM"',
   PRE_AP_ENERGY_PRICE  numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_RAISE6_PRICE  numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_RAISE60_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_RAISE5MIN_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_RAISEREG_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_LOWER6_PRICE  numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_LOWER60_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_LOWER5MIN_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   PRE_AP_LOWERREG_PRICE numeric(15,5)  comment 'Price before ap capping or scaling - for rolling sum price monitoring',
   CUMUL_PRE_AP_ENERGY_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_RAISE6_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_RAISE60_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_RAISE5MIN_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_RAISEREG_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_LOWER6_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_LOWER60_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_LOWER5MIN_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_LOWERREG_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   OCD_STATUS           varchar(14)  comment 'Communicates the current OCD status for this dispatch interval.  Values of: ''NOT_OCD'', ''OCD_UNRESOLVED'', ''OCD_RESOLVED''.',
   MII_STATUS           varchar(21)  comment 'Communicates the current MII status for this dispatch interval.  Values of: ''NOT_MII'', ''MII_SUBJECT_TO_REVIEW'', ''MII_PRICE_REJECTED'', ''MII_PRICE_ACCEPTED''.',
   RAISE1SECRRP         numeric(15,5)  comment 'Regional Raise 1Sec Price - R1Price attribute after capping/flooring',
   RAISE1SECROP         numeric(15,5)  comment 'Raise1Sec Regional Original Price - uncapped/unfloored and unscaled',
   RAISE1SECAPCFLAG     numeric(3,0)  comment 'BitFlag field for Price adjustments - "1" = Voll_Override; "4" = Floor_VoLL; "8" = Manual_Override; "16" = Price_Scaled',
   LOWER1SECRRP         numeric(15,5)  comment 'Regional Lower 1Sec Price - RegionSolution element L1Price attribute',
   LOWER1SECROP         numeric(15,5)  comment 'Lower1Sec Regional Original Price - uncapped/unfloored and unscaled',
   LOWER1SECAPCFLAG     numeric(3,0)  comment 'BitFlag field for Price adjustments - "1" = Voll_Override; "4" = Floor_VoLL; "8" = Manual_Override; "16" = Price_Scaled',
   PRE_AP_RAISE1_PRICE  numeric(15,5)  comment 'Price before AP capping or scaling - for Rolling Sum Price monitoring',
   PRE_AP_LOWER1_PRICE  numeric(15,5)  comment 'Price before AP capping or scaling - for Rolling Sum Price monitoring',
   CUMUL_PRE_AP_RAISE1_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold',
   CUMUL_PRE_AP_LOWER1_PRICE numeric(15,5)  comment 'Cumulative price that triggers administered pricing event if above the threshold'
);

alter table DISPATCHPRICE comment 'DISPATCHPRICE records 5 minute dispatch prices for energy an';

alter table DISPATCHPRICE
   add primary key (SETTLEMENTDATE, RUNNO, REGIONID, DISPATCHINTERVAL, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHPRICE_LCX                                     */
/*==============================================================*/
create index DISPATCHPRICE_LCX on DISPATCHPRICE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHREGIONSUM                                     */
/*==============================================================*/
create table DISPATCHREGIONSUM
(
   SETTLEMENTDATE       datetime not null  comment 'Market date and time starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   DISPATCHINTERVAL     numeric(22,0) not null  comment 'Dispatch period identifier, from 001 to 288 in format YYYYMMDDPPP.',
   INTERVENTION         numeric(2,0) not null  comment 'Manual Intervention flag',
   TOTALDEMAND          numeric(15,5)  comment 'Demand (less loads)',
   AVAILABLEGENERATION  numeric(15,5)  comment 'Aggregate generation bid available in region',
   AVAILABLELOAD        numeric(15,5)  comment 'Aggregate load bid available in region',
   DEMANDFORECAST       numeric(15,5)  comment '5 minute forecast adjust',
   DISPATCHABLEGENERATION numeric(15,5)  comment 'Dispatched Generation',
   DISPATCHABLELOAD     numeric(15,5)  comment 'Dispatched Load (add to total demand to get inherent region demand).',
   NETINTERCHANGE       numeric(15,5)  comment 'Net interconnector flow from the regional reference node',
   EXCESSGENERATION     numeric(15,5)  comment 'MW quantity of excess',
   LOWER5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW dispatch',
   LOWER5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW imported',
   LOWER5MINLOCALDISPATCH numeric(15,5)  comment 'Lower 5 min local dispatch',
   LOWER5MINLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 5 min',
   LOWER5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min local requirement',
   LOWER5MINPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 5 min',
   LOWER5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min total requirement',
   LOWER5MINSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 5 min',
   LOWER60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW dispatch',
   LOWER60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW imported',
   LOWER60SECLOCALDISPATCH numeric(15,5)  comment 'Lower 60 sec local dispatch',
   LOWER60SECLOCALPRICE numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 60 sec',
   LOWER60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec local requirement',
   LOWER60SECPRICE      numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 60 sec',
   LOWER60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec total requirement',
   LOWER60SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 60 sec',
   LOWER6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW dispatch',
   LOWER6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW imported',
   LOWER6SECLOCALDISPATCH numeric(15,5)  comment 'Lower 6 sec local dispatch',
   LOWER6SECLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 6 sec',
   LOWER6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec local requirement',
   LOWER6SECPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 6 sec',
   LOWER6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec total requirement',
   LOWER6SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 6 sec',
   RAISE5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min MW dispatch',
   RAISE5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min MW imported',
   RAISE5MINLOCALDISPATCH numeric(15,5)  comment 'Raise 5 min local dispatch',
   RAISE5MINLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Raise price of lower 5 min',
   RAISE5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min local requirement',
   RAISE5MINPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 5 min',
   RAISE5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min total requirement',
   RAISE5MINSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 5 min',
   RAISE60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW dispatch',
   RAISE60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW imported',
   RAISE60SECLOCALDISPATCH numeric(15,5)  comment 'Raise 60 sec local dispatch',
   RAISE60SECLOCALPRICE numeric(15,5)  comment 'Not used since Dec 2003. Local price of raise 60 sec',
   RAISE60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec local requirement',
   RAISE60SECPRICE      numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 60 sec',
   RAISE60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec total requirement',
   RAISE60SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 60 sec',
   RAISE6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW dispatch',
   RAISE6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW imported',
   RAISE6SECLOCALDISPATCH numeric(15,5)  comment 'Raise 6 sec local dispatch',
   RAISE6SECLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of raise 6 sec',
   RAISE6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec local requirement',
   RAISE6SECPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 6 sec',
   RAISE6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec total requirement',
   RAISE6SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 6 sec',
   AGGEGATEDISPATCHERROR numeric(15,5)  comment 'Calculated dispatch error',
   AGGREGATEDISPATCHERROR numeric(15,5)  comment 'Calculated dispatch error',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   INITIALSUPPLY        numeric(15,5)  comment 'Sum of initial generation and import for region',
   CLEAREDSUPPLY        numeric(15,5)  comment 'Sum of cleared generation and import for region',
   LOWERREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation MW imported',
   LOWERREGLOCALDISPATCH numeric(15,5)  comment 'Lower Regulation local dispatch',
   LOWERREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation local requirement',
   LOWERREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation total requirement',
   RAISEREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation MW imported',
   RAISEREGLOCALDISPATCH numeric(15,5)  comment 'Raise Regulation local dispatch',
   RAISEREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation local requirement',
   RAISEREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation total requirement',
   RAISE5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min local requirement',
   RAISEREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg local requirement',
   RAISE60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 sec local requirement',
   RAISE6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 sec local requirement',
   LOWER5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min local requirement',
   LOWERREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg local requirement',
   LOWER60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 sec local requirement',
   LOWER6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 sec local requirement',
   RAISE5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min requirement',
   RAISEREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg requirement',
   RAISE60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 seconds requirement',
   RAISE6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 seconds requirement',
   LOWER5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min requirement',
   LOWERREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg requirement',
   LOWER60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 seconds requirement',
   LOWER6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 seconds requirement',
   RAISE6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 6sec availability',
   RAISE60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 60sec availability',
   RAISE5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 5min availability',
   RAISEREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise reg availability',
   LOWER6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 6sec availability',
   LOWER60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 60sec availability',
   LOWER5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 5min availability',
   LOWERREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower reg availability',
   LORSURPLUS           numeric(16,6)  comment 'Not in use after 17 Feb 2006. Total short term generation capacity reserve used in assessing lack of reserve condition',
   LRCSURPLUS           numeric(16,6)  comment 'Not in use after 17 Feb 2006. Total short term generation capacity reserve above the stated low reserve condition requirement',
   TOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW).',
   DEMAND_AND_NONSCHEDGEN numeric(15,5)  comment 'Sum of Cleared Scheduled generation, imported generation (at the region boundary) and allowances made for non-scheduled generation (MW).',
   UIGF                 numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW).',
   SEMISCHEDULE_CLEAREDMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW',
   SEMISCHEDULE_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced',
   SS_SOLAR_UIGF        numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is solar',
   SS_WIND_UIGF         numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is wind',
   SS_SOLAR_CLEAREDMW   numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is solar',
   SS_WIND_CLEAREDMW    numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is wind',
   SS_SOLAR_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is solar',
   SS_WIND_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is wind',
   WDR_INITIALMW        numeric(15,5)  comment 'Regional aggregated MW value at start of interval for Wholesale Demand Response (WDR) units',
   WDR_AVAILABLE        numeric(15,5)  comment 'Regional aggregated available MW for Wholesale Demand Response (WDR) units',
   WDR_DISPATCHED       numeric(15,5)  comment 'Regional aggregated dispatched MW for Wholesale Demand Response (WDR) units',
   SS_SOLAR_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Solar units in that region',
   SS_WIND_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Wind units in that region',
   RAISE1SECLOCALDISPATCH numeric(15,5)  comment 'Total Raise1Sec Dispatched in Region - RegionSolution element R1Dispatch attribute',
   LOWER1SECLOCALDISPATCH numeric(15,5)  comment 'Total Lower1Sec Dispatched in Region - RegionSolution element L1Dispatch attribute',
   RAISE1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Raise1Sec availability (summated from UnitSolution)',
   LOWER1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Lower1Sec availability (summated from UnitSolution)',
   BDU_ENERGY_STORAGE   numeric(15,5)  comment 'Regional aggregated energy storage where the DUID type is BDU (MWh)',
   BDU_MIN_AVAIL        numeric(15,5)  comment 'Total available load side BDU summated for region (MW)',
   BDU_MAX_AVAIL        numeric(15,5)  comment 'Total available generation side BDU summated for region (MW)',
   BDU_CLEAREDMW_GEN    numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of export (Generation)',
   BDU_CLEAREDMW_LOAD   numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of import (Load)',
   BDU_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy Storage for BDU at the start of the interval(MWh) - Region Aggregated',
   DECGEN_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy storage for Daily Energy Constrained Scheduled Generating Units at the start of the interval(MWh) - Region Aggregated'
);

alter table DISPATCHREGIONSUM comment 'DISPATCHREGIONSUM sets out the 5-minute solution for each di';

alter table DISPATCHREGIONSUM
   add primary key (SETTLEMENTDATE, RUNNO, REGIONID, DISPATCHINTERVAL, INTERVENTION);

/*==============================================================*/
/* Index: DISPATCHREGIONSUM_LCX                                 */
/*==============================================================*/
create index DISPATCHREGIONSUM_LCX on DISPATCHREGIONSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCHTRK                                           */
/*==============================================================*/
create table DISPATCHTRK
(
   SETTLEMENTDATE       datetime not null  comment 'Market date and time starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no, normally 1.',
   REASON               varchar(64)  comment 'Reason code (if rerun)',
   SPDRUNNO             numeric(3,0)  comment 'Case identifier for LP Solver',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCHTRK comment 'DISPATCHTRK is no longer used. DISPATCHTRK was  the cross-re';

alter table DISPATCHTRK
   add primary key (SETTLEMENTDATE, RUNNO);

/*==============================================================*/
/* Index: DISPATCHTRK_LCX                                       */
/*==============================================================*/
create index DISPATCHTRK_LCX on DISPATCHTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_CONSTRAINT_FCAS_OCD                          */
/*==============================================================*/
create table DISPATCH_CONSTRAINT_FCAS_OCD
(
   SETTLEMENTDATE       datetime not null  comment 'Dispatch interval that the prices were loaded to',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention 0/1',
   CONSTRAINTID         varchar(20) not null  comment 'ConstraintID/GenconID',
   VERSIONNO            numeric(3,0) not null  comment 'VersionNo',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed',
   RHS                  numeric(15,5)  comment 'RHS from OCD re-run',
   MARGINALVALUE        numeric(15,5)  comment 'marginalvalue from OCD re-run',
   VIOLATIONDEGREE      numeric(15,5)  comment 'The violation degree of this constraint in the solution result'
);

alter table DISPATCH_CONSTRAINT_FCAS_OCD comment 'FCAS constraint solution from OCD re-run.';

alter table DISPATCH_CONSTRAINT_FCAS_OCD
   add primary key (SETTLEMENTDATE, RUNNO, INTERVENTION, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Index: DISPATCH_CONSTRNT_FCASOCD_LCX                         */
/*==============================================================*/
create index DISPATCH_CONSTRNT_FCASOCD_LCX on DISPATCH_CONSTRAINT_FCAS_OCD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_FCAS_REQ                                     */
/*==============================================================*/
create table DISPATCH_FCAS_REQ
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date and time of Dispatch Interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention Flag',
   GENCONID             varchar(20) not null  comment 'Generic Constraint ID - Join to table GenConData',
   REGIONID             varchar(10) not null  comment '',
   BIDTYPE              varchar(10) not null  comment 'DUID offered type',
   GENCONEFFECTIVEDATE  datetime  comment 'Generic Constraint EffectiveDate - Join to table GenConData',
   GENCONVERSIONNO      numeric(3,0)  comment 'Generic Constraint Version number - Join to table GenConData',
   MARGINALVALUE        numeric(16,6)  comment '',
   LASTCHANGED          datetime  comment 'Date record is changed',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint for this service, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, before the regulation/contingency split',
   ESTIMATED_CMPF       numeric(18,8)  comment 'An estimated value for the constraint CMPF, based on dispatched data',
   ESTIMATED_CRMPF      numeric(18,8)  comment 'An estimated value for the constraint CRMPF, based on dispatched data',
   RECOVERY_FACTOR_CMPF numeric(18,8)  comment 'Estimated recovery factor for CMPF based recovery',
   RECOVERY_FACTOR_CRMPF numeric(18,8)  comment 'Estimated recovery factor for CRMPF based recovery'
);

alter table DISPATCH_FCAS_REQ comment 'DISPATCH_FCAS_REQ shows Dispatch Constraint tracking for Reg';

alter table DISPATCH_FCAS_REQ
   add primary key (SETTLEMENTDATE, RUNNO, INTERVENTION, GENCONID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Index: DISPATCH_FCAS_REQ_LCX                                 */
/*==============================================================*/
create index DISPATCH_FCAS_REQ_LCX on DISPATCH_FCAS_REQ
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_FCAS_REQ_CONSTRAINT                          */
/*==============================================================*/
create table DISPATCH_FCAS_REQ_CONSTRAINT
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the dispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The dispatch case run number that has triggers the constraint FCAS processor run',
   INTERVAL_DATETIME    datetime not null  comment 'The trading interval date and time of the dispatch interval that was processed by the constraint FCAS processor',
   CONSTRAINTID         varchar(20) not null  comment 'ConstraintID join to table GenConData',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   BIDTYPE              varchar(10) not null  comment 'DUID offered type',
   LHS                  numeric(15,5)  comment 'Constraints summed LHS - aggregate LHS Solution values from the physical run from the DISPATCHCONSTRAINT table',
   RHS                  numeric(15,5)  comment 'Constraints RHS value used in the solution - may be either dynamic (calculated) or static from the physical run from the DISPATCHCONSTRAINT table',
   MARGINALVALUE        numeric(15,5)  comment 'Shadow price of constraint from the DISPATCHCONSTRAINT table from the physical run.',
   RRP                  numeric(15,5)  comment 'Bid type prices for the region coming from the pricing run of the DISPATCHREGIONSUM table',
   REGIONAL_ENABLEMENT  numeric(15,5)  comment 'The dispatched MW for the bid type inside the region from the physical run of the DISPATCHREGIONSUM table',
   CONSTRAINT_ENABLEMENT numeric(15,5)  comment 'MW enabled for this bid type within the constraint',
   REGION_BASE_COST     numeric(18,8)  comment 'The regional payment allocated to the constraint for the interval pro-rated based on marginal value ratios over the binding constraints for that service in that region (this is an intermediate calculation to get to the base cost)',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, after the regulation/contingency split',
   P_REGULATION         numeric(18,8)  comment 'The adjusted marginal value of the constraint for FPP recovery (blank for constraints without REG terms)'
);

alter table DISPATCH_FCAS_REQ_CONSTRAINT comment 'The constraint level FCAS cost / price details for constrain';

alter table DISPATCH_FCAS_REQ_CONSTRAINT
   add primary key (RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Table: DISPATCH_FCAS_REQ_RUN                                 */
/*==============================================================*/
create table DISPATCH_FCAS_REQ_RUN
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the dispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The dispatch case run number that has triggers the constraint FCAS processor run',
   LASTCHANGED          datetime  comment 'The last time the constraint FCAS processor was executed for this case run time.'
);

alter table DISPATCH_FCAS_REQ_RUN comment 'The constraint FCAS processor run details. This enhanced out';

alter table DISPATCH_FCAS_REQ_RUN
   add primary key (RUN_DATETIME, RUNNO);

/*==============================================================*/
/* Table: DISPATCH_INTERCONNECTION                              */
/*==============================================================*/
create table DISPATCH_INTERCONNECTION
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Intervention case or not',
   FROM_REGIONID        varchar(20) not null  comment 'Nominated RegionID from which the energy flows',
   TO_REGIONID          varchar(20) not null  comment 'Nominated RegionID to which the energy flows',
   DISPATCHINTERVAL     numeric(22,0)  comment 'Dispatch period identifier, from 001 to 288 in format YYYYMMDDPPP',
   IRLF                 numeric(15,5)  comment 'Inter-Regional Loss Factor. Calculated based on the MWFLOW and the nominal From and To Region losses.',
   MWFLOW               numeric(16,6)  comment 'Summed MW flow of the parallel regulated Interconnectors',
   METEREDMWFLOW        numeric(16,6)  comment 'Summed Metered MW flow of the parallel regulated Interconnectors',
   FROM_REGION_MW_LOSSES numeric(16,6)  comment 'Losses across the Interconnection attributable to the nominal From Region',
   TO_REGION_MW_LOSSES  numeric(16,6)  comment 'Losses across the Interconnection attributable to the nominal To Region',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed'
);

alter table DISPATCH_INTERCONNECTION comment 'Inter-regional flow information common to or aggregated for ';

alter table DISPATCH_INTERCONNECTION
   add primary key (SETTLEMENTDATE, RUNNO, FROM_REGIONID, TO_REGIONID, INTERVENTION);

/*==============================================================*/
/* Table: DISPATCH_LOCAL_PRICE                                  */
/*==============================================================*/
create table DISPATCH_LOCAL_PRICE
(
   SETTLEMENTDATE       datetime not null  comment 'Market date time starting at 04:05',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier',
   LOCAL_PRICE_ADJUSTMENT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this unit: Sum(MarginalValue x Factor) for all relevant Constraints',
   LOCALLY_CONSTRAINED  numeric(1,0)  comment 'Key for Local_Price_Adjustment: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints'
);

alter table DISPATCH_LOCAL_PRICE comment 'Sets out local pricing offsets associated with each DUID con';

alter table DISPATCH_LOCAL_PRICE
   add primary key (SETTLEMENTDATE, DUID);

/*==============================================================*/
/* Table: DISPATCH_MNSPBIDTRK                                   */
/*==============================================================*/
create table DISPATCH_MNSPBIDTRK
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   PARTICIPANTID        varchar(10) not null  comment 'Participant that owns unit during effective record period',
   LINKID               varchar(10) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   OFFERSETTLEMENTDATE  datetime  comment 'Offer date for bid',
   OFFEREFFECTIVEDATE   datetime(3)  comment 'Time this bid was processed and loaded',
   OFFERVERSIONNO       numeric(3,0)  comment 'VersionNo of the bid/offer used',
   LASTCHANGED          datetime  comment 'Record creation timestamp'
);

alter table DISPATCH_MNSPBIDTRK comment 'DISPATCH_MNSPBIDTRK shows the MNSP bid tracking, including t';

alter table DISPATCH_MNSPBIDTRK
   add primary key (SETTLEMENTDATE, RUNNO, PARTICIPANTID, LINKID);

/*==============================================================*/
/* Index: DISPATCH_MNSPBIDTRK_LCX                               */
/*==============================================================*/
create index DISPATCH_MNSPBIDTRK_LCX on DISPATCH_MNSPBIDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_MR_SCHEDULE_TRK                              */
/*==============================================================*/
create table DISPATCH_MR_SCHEDULE_TRK
(
   SETTLEMENTDATE       datetime not null  comment 'Date Time of the Dispatch Interval',
   REGIONID             varchar(10) not null  comment 'Unique RegionID; Key reference to MR_Event_Schedule',
   MR_DATE              datetime  comment 'Mandatory Restriction date; Key reference to MR_Event_Schedule table',
   VERSION_DATETIME     datetime  comment 'Date Time the MR  acceptance stack was created; Key reference to MR_Event_Schedule table',
   LASTCHANGED          datetime  comment 'Date and  time the record was last inserted/modified'
);

alter table DISPATCH_MR_SCHEDULE_TRK comment 'DISPATCH_MR_SCHEDULE_TRK records the Mandatory Restrictions ';

alter table DISPATCH_MR_SCHEDULE_TRK
   add primary key (SETTLEMENTDATE, REGIONID);

/*==============================================================*/
/* Index: DISPATCH_MR_SCHEDULE_TRK_LCX                          */
/*==============================================================*/
create index DISPATCH_MR_SCHEDULE_TRK_LCX on DISPATCH_MR_SCHEDULE_TRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_PRICE_REVISION                               */
/*==============================================================*/
create table DISPATCH_PRICE_REVISION
(
   SETTLEMENTDATE       datetime not null  comment 'Market date and time starting at 04:05',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no; always 1',
   INTERVENTION         numeric(2,0) not null  comment 'Manual intervention flag; always 0',
   REGIONID             varchar(10) not null  comment 'Affected Region Identifier',
   BIDTYPE              varchar(10) not null  comment 'Affected Bid Type Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of price revision for this settlement date',
   RRP_NEW              numeric(15,5)  comment 'New RRP in DISPATCHPRICE table',
   RRP_OLD              numeric(15,5)  comment 'Old RRP from DISPATCHPRICE table',
   LASTCHANGED          datetime  comment 'The datetime the record was last changed'
);

alter table DISPATCH_PRICE_REVISION comment 'An audit trail of price changes on the DISPATCHPRICE table (';

alter table DISPATCH_PRICE_REVISION
   add primary key (SETTLEMENTDATE, RUNNO, INTERVENTION, REGIONID, BIDTYPE, VERSIONNO);

/*==============================================================*/
/* Index: DISPATCH_PRICE_REVISION_LCX                           */
/*==============================================================*/
create index DISPATCH_PRICE_REVISION_LCX on DISPATCH_PRICE_REVISION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_ROOFTOP_PV_FCST_TRK                          */
/*==============================================================*/
create table DISPATCH_ROOFTOP_PV_FCST_TRK
(
   RUN_DATETIME         datetime not null  comment 'Datetime (interval ending) of the Dispatch run.',
   AREAID               varchar(10) not null  comment 'Area identifier aligning with the load forecasting areas, tracks to ROOFTOP_PV_FCST_P5_RUN.AREAID.',
   FORECAST_RUN_DATETIME datetime  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime, unless a forecast run is missed, in this case the previous run is used. Tracks to ROOFTOP_PV_FCST_P5_RUN.FORECAST_RUN_DATETIME.',
   PROVIDERID           varchar(20)  comment 'Provider identifier of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.PROVIDERID.',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Priority of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.FORECAST_PRIORITY.',
   OFFERDATETIME        datetime  comment 'Submission datetime of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.OFFERDATETIME.'
);

alter table DISPATCH_ROOFTOP_PV_FCST_TRK comment 'Uniquely tracks which Rooftop PV forecast run (from ROOFTOP_';

alter table DISPATCH_ROOFTOP_PV_FCST_TRK
   add primary key (RUN_DATETIME, AREAID);

/*==============================================================*/
/* Table: DISPATCH_UNIT_CONFORMANCE                             */
/*==============================================================*/
create table DISPATCH_UNIT_CONFORMANCE
(
   INTERVAL_DATETIME    datetime not null  comment 'Dispatch Interval that the conformance data applies to',
   DUID                 varchar(20) not null  comment 'Dispatchable Unit Identifier, or Aggregate Dispatch Group identifier',
   TOTALCLEARED         numeric(16,6)  comment 'Dispatch Target - MW',
   ACTUALMW             numeric(16,6)  comment 'Unit output measured at the conclusion of the dispatch interval - MW (MWB)',
   ROC                  numeric(16,6)  comment 'Rate of change in direction of error MW per minute',
   AVAILABILITY         numeric(16,6)  comment 'Offered unit capacity - MW (MWO)',
   LOWERREG             numeric(16,6)  comment 'Lower Regulation FCAS enabled - MW (FCL)',
   RAISEREG             numeric(16,6)  comment 'Raise Regulation FCAS enabled - MW (FCR)',
   STRIGLM              numeric(16,6)  comment 'Calculated small trigger error limit in MW',
   LTRIGLM              numeric(16,6)  comment 'Calculated large trigger error limit in MW',
   MWERROR              numeric(16,6)  comment 'Calculated actual error',
   MAX_MWERROR          numeric(16,6)  comment 'Max of mwerror while that unit was not in a normal state',
   LECOUNT              numeric(6,0)  comment 'Large trigger error count. Reset when mwerror changes sign',
   SECOUNT              numeric(6,0)  comment 'Small trigger error count.  Reset when mwerror changes sign',
   STATUS               varchar(20)  comment 'Unit conformance status.
             NORMAL
             OFF-TARGET
             NOT-RESPONDING
             NC-PENDING
             NON-CONFORMING
             SUSPENDED',
   PARTICIPANT_STATUS_ACTION varchar(100)  comment 'Participant action required in response to current STATUS',
   OPERATING_MODE       varchar(20)  comment 'conformance operating mode
             MANUAL
             AUTO',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ADG_ID               varchar(20)  comment 'Aggregate Dispatch Group to which this dispatch unit belongs',
   SEMIDISPATCHCAP      numeric(3,0)  comment 'Boolean representation flagging if the Target is capped',
   CONFORMANCE_MODE     numeric(6,0)  comment 'For an individual unit in an aggregate dispatch group (where DUID <> ADG_ID), Mode specific to that unit. 0 - no monitoring, 1 - aggregate monitoring, 2 - individual monitoring due to constraint. For the aggregate dispatch group (where DUID = ADG_ID), 0 - no aggregate monitoring, 1 - aggregate monitoring'
);

alter table DISPATCH_UNIT_CONFORMANCE comment 'DISPATCH_UNIT_CONFORMANCE details the conformance of a sched';

alter table DISPATCH_UNIT_CONFORMANCE
   add primary key (INTERVAL_DATETIME, DUID);

/*==============================================================*/
/* Index: DISPATCH_UNIT_CONFORMANCE_LCX                         */
/*==============================================================*/
create index DISPATCH_UNIT_CONFORMANCE_LCX on DISPATCH_UNIT_CONFORMANCE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DISPATCH_UNIT_SCADA                                   */
/*==============================================================*/
create table DISPATCH_UNIT_SCADA
(
   SETTLEMENTDATE       datetime not null  comment 'Date Time of the Dispatch Interval',
   DUID                 varchar(20) not null  comment 'Dispatchable Unit Identifier',
   SCADAVALUE           numeric(16,6)  comment 'Instantaneous MW reading from SCADA at the start of the Dispatch interval',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DISPATCH_UNIT_SCADA comment 'Dispatchable unit MW from SCADA at the start of the dispatch';

alter table DISPATCH_UNIT_SCADA
   add primary key (SETTLEMENTDATE, DUID);

/*==============================================================*/
/* Table: DUALLOC                                               */
/*==============================================================*/
create table DUALLOC
(
   EFFECTIVEDATE        datetime not null  comment 'Effective calendar date of record',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of record',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   GENSETID             varchar(20) not null  comment 'Physical unit identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table DUALLOC comment 'DUALLOC cross references dispatch unit identifier to genset ';

alter table DUALLOC
   add primary key (DUID, EFFECTIVEDATE, VERSIONNO, GENSETID);

/*==============================================================*/
/* Index: DUALLOC_NDX2                                          */
/*==============================================================*/
create index DUALLOC_NDX2 on DUALLOC
(
   DUID
);

/*==============================================================*/
/* Index: DUALLOC_LCX                                           */
/*==============================================================*/
create index DUALLOC_LCX on DUALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DUDETAIL                                              */
/*==============================================================*/
create table DUDETAIL
(
   EFFECTIVEDATE        datetime not null  comment 'Effective calendar date of record',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'version of Dispatchable Unit details for this effective date',
   CONNECTIONPOINTID    varchar(10)  comment 'Country wide - Unique id of a connection point',
   VOLTLEVEL            varchar(10)  comment 'Voltage Level',
   REGISTEREDCAPACITY   numeric(6,0)  comment 'Registered capacity for normal operations',
   AGCCAPABILITY        varchar(1)  comment 'AGC Capability flag',
   DISPATCHTYPE         varchar(20)  comment 'Identifies LOAD, GENERATOR or BIDIRECTIONAL.',
   MAXCAPACITY          numeric(6,0)  comment 'Maximum Capacity as used for bid validation',
   STARTTYPE            varchar(20)  comment 'Identify unit as Fast or Slow',
   NORMALLYONFLAG       varchar(1)  comment 'For a dispatchable load indicates that the load is normally on or off.',
   PHYSICALDETAILSFLAG  varchar(1)  comment 'Indicates that the physical details for this unit are to be recorded',
   SPINNINGRESERVEFLAG  varchar(1)  comment 'Indicates spinning reserve capability',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   INTERMITTENTFLAG     varchar(1)  comment 'Indicate whether a unit is intermittent (e.g. a wind farm)',
   SEMISCHEDULE_FLAG    varchar(1)  comment 'Indicates if the DUID is a Semi-Scheduled Unit',
   MAXRATEOFCHANGEUP    numeric(6,0)  comment 'Maximum ramp up rate for Unit (Mw/min)',
   MAXRATEOFCHANGEDOWN  numeric(6,0)  comment 'Maximum ramp down rate for Unit (Mw/min)',
   DISPATCHSUBTYPE      varchar(20)  comment 'Additional information for DISPATCHTYPE. For DISPATCHTYPE = LOAD, subtype value is WDR for wholesale demand response units. For DISPATCHTYPE = LOAD, subtype value is NULL for Scheduled Loads. For DISPATCHTYPE = GENERATOR type, the subtype value is NULL.',
   ADG_ID               varchar(20)  comment 'Aggregate Dispatch Group to which this dispatch unit belongs',
   MINCAPACITY          numeric(6,0)  comment 'Minimum capacity only for load side of BDU, otherwise 0 (MW)',
   REGISTEREDMINCAPACITY numeric(6,0)  comment 'Registered minimum capacity only for load side of BDU, otherwise 0 (MW)',
   MAXRATEOFCHANGEUP_LOAD numeric(6,0)  comment 'Raise Ramp rate applied to BDU Load component (MW/min)',
   MAXRATEOFCHANGEDOWN_LOAD numeric(6,0)  comment 'Lower Ramp rate applied to BDU Load component (MW/min)',
   MAXSTORAGECAPACITY   numeric(15,5)  comment 'The rated storage capacity (MWh), information only',
   STORAGEIMPORTEFFICIENCYFACTOR numeric(15,5)  comment 'The storage energy import conversion efficiency. Number from 0 to 1 where 1 is lossless. Calculated as (increase in stored energy / increase in imported energy)',
   STORAGEEXPORTEFFICIENCYFACTOR numeric(15,5)  comment 'The storage energy export conversion efficiency. Number from 0 to 1 where 1 is lossless. Calculated as (decrease in exported energy / decrease in stored energy)',
   MIN_RAMP_RATE_UP     numeric(6,0)  comment 'Calculated Minimum Ramp Rate Up value accepted for Energy Offers or Bids with explanation for energy imports (all DUID types and BDU Generation side) (MW/min)',
   MIN_RAMP_RATE_DOWN   numeric(6,0)  comment 'Calculated Minimum Ramp Rate Down value accepted for Energy Offers or Bids with explanation for energy imports (all DUID types and BDU Generation side) (MW/min)',
   LOAD_MIN_RAMP_RATE_UP numeric(6,0)  comment 'Calculated Minimum Ramp Rate Up value accepted for Energy Offers or Bids on BDU Load component with explanation for energy imports (MW/min)',
   LOAD_MIN_RAMP_RATE_DOWN numeric(6,0)  comment 'Calculated Minimum Ramp Rate Down value accepted for Energy Offers or Bids on BDU Load component with explanation for energy imports (MW/min)',
   AGGREGATED           numeric(1,0)  comment 'Identifies if a unit is aggregated. This flag was initially added in GENUNITS_UNIT table which is now deprecated with IESS release.'
);

alter table DUDETAIL comment 'DUDETAIL sets out a records specific details for each unit i';

alter table DUDETAIL
   add primary key (DUID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: DUDETAIL_LCX                                          */
/*==============================================================*/
create index DUDETAIL_LCX on DUDETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: DUDETAILSUMMARY                                       */
/*==============================================================*/
create table DUDETAILSUMMARY
(
   DUID                 varchar(10) not null  comment 'Dispatchable Unit Identifier',
   START_DATE           datetime not null  comment 'Start date for effective record',
   END_DATE             datetime not null  comment 'End date for effective record',
   DISPATCHTYPE         varchar(20)  comment 'Identifies LOAD, GENERATOR or BIDIRECTIONAL. This will likely expand to more generic models as new technology types are integrated into the NEM',
   CONNECTIONPOINTID    varchar(10)  comment 'Country wide - Unique id of a connection point',
   REGIONID             varchar(10)  comment 'Region identifier that unit is in',
   STATIONID            varchar(10)  comment 'Station that unit is in',
   PARTICIPANTID        varchar(10)  comment 'Participant that owns unit during effective record period',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   TRANSMISSIONLOSSFACTOR numeric(15,5)  comment 'Used in Bidding, Dispatch and Settlements. For Bidding and Dispatch, where the DUID is a BDU with DISPATCHTYPE of BIDIRECTIONAL, the TLF for the load component of the BDU. For Settlements, where dual TLFs apply, the primary TLF is applied to all energy (load and generation) when the Net Energy Flow of the ConnectionPointID in the interval is negative (net load).',
   STARTTYPE            varchar(20)  comment 'Unit start type. At this time restricted to Fast, Slow or Non Dispatched',
   DISTRIBUTIONLOSSFACTOR numeric(15,5)  comment 'The distribution loss factor to the currently assigned connection point',
   MINIMUM_ENERGY_PRICE numeric(9,2)  comment 'Floored Offer/Bid Energy Price adjusted for TLF, DLF and MPF',
   MAXIMUM_ENERGY_PRICE numeric(9,2)  comment 'Capped Offer/Bid Energy Price adjusted for TLF, DLF and VoLL',
   SCHEDULE_TYPE        varchar(20)  comment 'Scheduled status of the unit:
                 ''SCHEDULED''
                 ''NON-SCHEDULED''
                 ''SEMI-SCHEDULED''',
   MIN_RAMP_RATE_UP     numeric(6,0)  comment 'MW/Min. Calculated Minimum Ramp Rate Up value accepted for Energy Offers or Bids with explanation',
   MIN_RAMP_RATE_DOWN   numeric(6,0)  comment 'MW/Min. Calculated Minimum Ramp Rate Down value accepted for Energy Offers or Bids with explanation',
   MAX_RAMP_RATE_UP     numeric(6,0)  comment 'Maximum ramp up rate for Unit (Mw/min) - from DUDetail table',
   MAX_RAMP_RATE_DOWN   numeric(6,0)  comment 'Maximum ramp down rate for Unit (Mw/min) - from DUDetail table',
   IS_AGGREGATED        numeric(1,0)  comment 'Whether the DUID is classified as an "Aggregated Unit" under the rules. This impacts the Minimum Ramp Rate calculation',
   DISPATCHSUBTYPE      varchar(20)  comment 'Additional information for DISPATCHTYPE. For DISPATCHTYPE = LOAD, subtype value is WDR for wholesale demand response units For DISPATCHTYPE = LOAD, subtype value is NULL for Scheduled Loads. For DISPATCHTYPE = GENERATOR type, subtype value is NULL.',
   ADG_ID               varchar(20)  comment 'Aggregate Dispatch Group. Group into which the DUID is aggregated for Conformance. Null if DUID not aggregated for Conformance',
   LOAD_MINIMUM_ENERGY_PRICE numeric(9,2)  comment 'BDU only. Floored Offer/Bid Energy Price adjusted for TLF, DLF and MPF for energy imports',
   LOAD_MAXIMUM_ENERGY_PRICE numeric(9,2)  comment 'BDU only. Capped Offer/Bid Energy Price adjusted for TLF, DLF and VoLL for energy imports',
   LOAD_MIN_RAMP_RATE_UP numeric(6,0)  comment 'BDU only. MW/Min. Calculated Minimum Ramp Rate Up value accepted for Energy Offers or Bids with explanation for energy imports',
   LOAD_MIN_RAMP_RATE_DOWN numeric(6,0)  comment 'BDU only. MW/Min. Calculated Minimum Ramp Rate Down value accepted for Energy Offers or Bids with explanation for energy imports',
   LOAD_MAX_RAMP_RATE_UP numeric(6,0)  comment 'BDU only. MW/Min. Registered Maximum Ramp Rate Up value accepted for Energy Offers or Bids for energy imports',
   LOAD_MAX_RAMP_RATE_DOWN numeric(6,0)  comment 'BDU only. MW/Min. Registered Maximum Ramp Rate Down value accepted for Energy Offers or Bids for energy imports',
   SECONDARY_TLF        numeric(18,8)  comment 'Used in Bidding, Dispatch and Settlements, only populated where Dual TLFs apply. For Bidding and Dispatch, the TLF for the generation component of a BDU, when null the TRANSMISSIONLOSSFACTOR is used for both the load and generation components. For Settlements, the secondary TLF is applied to all energy (load and generation) when the Net Energy Flow of the ConnectionPointID in the interval is positive (net generation).'
);

alter table DUDETAILSUMMARY comment 'DUDETAILSUMMARY sets out a single summary unit table so redu';

alter table DUDETAILSUMMARY
   add primary key (DUID, START_DATE);

/*==============================================================*/
/* Index: DUDETAILSUMMARY_LCX                                   */
/*==============================================================*/
create index DUDETAILSUMMARY_LCX on DUDETAILSUMMARY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: EMSMASTER                                             */
/*==============================================================*/
create table EMSMASTER
(
   SPD_ID               varchar(21) not null  comment 'ID defining data source',
   SPD_TYPE             varchar(1) not null  comment 'ID describing type of data source',
   DESCRIPTION          varchar(255)  comment 'The detailed description of the SCADA point associated with the SPD_ID',
   GROUPING_ID          varchar(20)  comment 'The Grouping associated with the SPD ID - most often a RegionID',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table EMSMASTER comment 'EMSMASTER provides a description of the SCADA measurements t';

alter table EMSMASTER
   add primary key (SPD_ID, SPD_TYPE);

/*==============================================================*/
/* Index: EMSMASTER_LCX                                         */
/*==============================================================*/
create index EMSMASTER_LCX on EMSMASTER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: FCAS_REGU_USAGE_FACTORS                               */
/*==============================================================*/
create table FCAS_REGU_USAGE_FACTORS
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date for this regulation FCAS usage factor',
   VERSIONNO            numeric(3,0) not null  comment 'Version with respect to effective date',
   REGIONID             varchar(20) not null  comment 'Unique RegionID',
   BIDTYPE              varchar(20) not null  comment 'The type of regulation FCAS service [RAISEREG,LOWERREG]',
   PERIODID             numeric(3,0) not null  comment 'The Period ID (1 - 48) within the calendar day to which this usage factor applies',
   USAGE_FACTOR         numeric(8,3)  comment 'The proportion of cleared regulation FCAS that is assumed to be used within a dispatch interval. Expressed as a fractional amount between 0 and 1',
   LASTCHANGED          datetime  comment 'The last time the data has been changed/updated'
);

alter table FCAS_REGU_USAGE_FACTORS comment 'Stores the proportion of enabled regulation FCAS dispatch th';

alter table FCAS_REGU_USAGE_FACTORS
   add primary key (EFFECTIVEDATE, VERSIONNO, REGIONID, BIDTYPE, PERIODID);

/*==============================================================*/
/* Table: FCAS_REGU_USAGE_FACTORS_TRK                           */
/*==============================================================*/
create table FCAS_REGU_USAGE_FACTORS_TRK
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date for this regulation FCAS usage factor',
   VERSIONNO            numeric(3,0) not null  comment 'Version of the date with respect to effective date',
   AUTHORISEDDATE       datetime  comment 'The date time that this set of usage factors was authorised',
   LASTCHANGED          datetime  comment 'The last time the data has been changed/updated'
);

alter table FCAS_REGU_USAGE_FACTORS_TRK comment 'Stores the proportion of enabled regulation FCAS dispatch th';

alter table FCAS_REGU_USAGE_FACTORS_TRK
   add primary key (EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Table: FORCEMAJEURE                                          */
/*==============================================================*/
create table FORCEMAJEURE
(
   FMID                 varchar(10) not null  comment 'Force Majeure Identifier',
   STARTDATE            datetime  comment 'Start Date for this event',
   STARTPERIOD          numeric(3,0)  comment 'Start Trading Interval for event',
   ENDDATE              datetime  comment 'End Date for this event',
   ENDPERIOD            numeric(3,0)  comment 'End Trading Interval for this event',
   APCSTARTDATE         datetime  comment 'APC Start Date',
   STARTAUTHORISEDBY    varchar(15)  comment 'User authorising start',
   ENDAUTHORISEDBY      varchar(15)  comment 'User authorising end of event',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table FORCEMAJEURE comment 'FORCEMAJEURE used to set out the start and end dates / perio';

alter table FORCEMAJEURE
   add primary key (FMID);

/*==============================================================*/
/* Index: FORCEMAJEURE_LCX                                      */
/*==============================================================*/
create index FORCEMAJEURE_LCX on FORCEMAJEURE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: FORCEMAJEUREREGION                                    */
/*==============================================================*/
create table FORCEMAJEUREREGION
(
   FMID                 varchar(10) not null  comment 'Force Majeure ID',
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table FORCEMAJEUREREGION comment 'FORCEMAJEUREREGION used to set out regions impacted by a for';

alter table FORCEMAJEUREREGION
   add primary key (FMID, REGIONID);

/*==============================================================*/
/* Index: FORCEMAJEUREREGION_LCX                                */
/*==============================================================*/
create index FORCEMAJEUREREGION_LCX on FORCEMAJEUREREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: FPP_CONSTRAINT_FREQ_MEASURE                           */
/*==============================================================*/
create table FPP_CONSTRAINT_FREQ_MEASURE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   MEASUREMENT_DATETIME datetime not null  comment 'Date and time of the SCADA data (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   FM_RAISE_HZ          numeric(18,8)  comment 'Calculated 4 second Frequency Measure in Hz for that constraint from the FPP database. Frequency Measure data is split across these two raise and lower columns in the following ways: >0 = Allocated to the FM_RAISE_HZ column <0 = Allocated to the FM_LOWER_HZ column 0 = To fill any gaps where the alternative column is not applicable (or no deviation from 50 Hz)',
   FM_LOWER_HZ          numeric(18,8)  comment 'Calculated 4 second Frequency Measure in Hz for that constraint from the FPP database. Frequency Measure data is split across these two raise and lower columns in the following ways: >0 = Allocated to the FM_RAISE_HZ column <0 = Allocated to the FM_LOWER_HZ column 0 = To fill any gaps where the alternative column is not applicable (or no deviation from 50 Hz)',
   USED_IN_RCR_FLAG     numeric(5,0)  comment 'Flag to indicate the result of the Frequency Measure alignment check between Mainland and Tasmania for global constraints. Supported values are: 0 = Not used in RCR calculation as the signs for the frequency measures between Mainland and Tasmania do not align 1 = Used in the RCR calculation as the signs for the frequency measures between Mainland and Tasmania do align in the case of global constraints. For non-global constraints this flag is set to 1',
   CORRELATION_FLAG     numeric(5,0)  comment 'Flag to indicate the result of the Frequency Measure correlation check between regions in the same constraint. Supported values are: 0 = Frequency measures in this constraint are not correlated (e.g. system separation between two regions) 1 = Frequency measures in this constraint are correlated'
);

alter table FPP_CONSTRAINT_FREQ_MEASURE comment 'This report delivers the weighted 4 second frequency measure';

alter table FPP_CONSTRAINT_FREQ_MEASURE
   add primary key (INTERVAL_DATETIME, MEASUREMENT_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_CONTRIBUTION_FACTOR                               */
/*==============================================================*/
create table FPP_CONTRIBUTION_FACTOR
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID/ TNI)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   CONTRIBUTION_FACTOR  numeric(18,8)  comment 'Contribution Factor (the calculated contribution factor for the FPP unit and constraint ID for that trading interval) - for further details please see the FPP procedure document',
   NEGATIVE_CONTRIBUTION_FACTOR numeric(18,8)  comment 'Negative Contribution Factor (the calculated negative contribution factor for the FPP unit and constraint ID for that trading interval) - for further details please see the FPP procedure document',
   DEFAULT_CONTRIBUTION_FACTOR numeric(18,8)  comment 'The Default Contribution Factor (the calculated default contribution factor based on historical performance for the FPP unit and constraint ID for that trading interval) that is effective for this trading interval, which joins back to FPP_FORECAST_DEFAULT_CF - for further details please see the FPP procedure document',
   CF_REASON_FLAG       numeric(5,0)  comment 'The reason flag showing the decision matrix for the contribution factor (CF) Supported values are: 0 = CF is calculated based on good input data 1 = CF is 0 because it is not primary in the group 2 = CF is not for the DUID but for the whole group 4 = CF is calculated based on substitute performance 8 = CF is 0 because FM is unreliable. 16 = CF is 0 because more than 50 percent input is bad or not available.',
   CF_ABS_POSITIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute positive performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising contribution factors (CF) where a units performance is positive. For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable',
   CF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising contribution factors (CF) where a units performance is negative. For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable',
   NCF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising negative contribution factors (NCF). For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable 0 = When NCF is zero (i.e. CF is positive), then this total will be represented as zero',
   PARTICIPANTID        varchar(20)  comment 'Participant ID',
   SETTLEMENTS_UNITID   varchar(50)  comment 'The Settlements Unit ID (registered DUID / TNI) Note that this SETTLEMENTS_UNITID is what is sent and used by the Settlements system, and may be different from the FPP_UNITID for non-scheduled loads where the FPP_UNITID may be a descriptive key, whereas what will be sent to Settlements as the SETTLEMENTS_UNITID will be the TNI code.'
);

alter table FPP_CONTRIBUTION_FACTOR comment 'This report delivers the calculated contribution factor valu';

alter table FPP_CONTRIBUTION_FACTOR
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_EST_COST                                          */
/*==============================================================*/
create table FPP_EST_COST
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID / TNI)',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the FPP run number from the FPP database, however there are some cases (like a new pricing run of the constraint FCAS processor received by the FPP system) where the version number listed here will be the financial estimate run number from the FPP database (this number is a different sequence from the FPP run number because there is no recalculation of performance or contribution, just changes to pricing / p regulation hence only the financial estimation is performed).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   FPP                  numeric(18,8)  comment 'FPP in AUD (the financial estimate of frequency performance payment calculated for the constraint / bid type / unit). This value can be either positive (credit) or negative (debit). For details on the calculation, please see FPP procedure and supporting documentation.',
   USED_FCAS            numeric(18,8)  comment 'Used recovery FCAS in AUD (the financial estimate of the recovery of used FCAS calculated for the constraint / bid type / unit). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   UNUSED_FCAS          numeric(18,8)  comment 'Unused recovery FCAS in AUD (the financial estimate of the recovery of unused FCAS calculated for the constraint / bid type / unit). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   PARTICIPANTID        varchar(20)  comment 'Participant ID'
);

alter table FPP_EST_COST comment 'This report delivers the estimated cost for each FPP unit fo';

alter table FPP_EST_COST
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_EST_PERF_COST_RATE                                */
/*==============================================================*/
create table FPP_EST_PERF_COST_RATE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the FPP run number from the FPP database, however there are some cases (like a new pricing run of the constraint FCAS processor received by the FPP system) where the version number listed here will be the financial estimate run number from the FPP database (this number is a different sequence from the FPP run number because there is no recalculation of performance or contribution, just changes to pricing / p regulation hence only the financial estimation is performed).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   FPP_PAYMENT_RATE     numeric(18,8)  comment 'The payment rate for FPP in AUD / MWHz (the denominator used is the sum of positive performance for the constraint calculated by contribution factor calculation). This value will be either 0 (nil), or a positive value (credit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   FPP_RECOVERY_RATE    numeric(18,8)  comment 'The recovery rate for FPP in AUD / MWHz (the denominator used is the absolute sum of negative performance for the constraint calculated by the contribution factor calculation). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   USED_FCAS_RATE       numeric(18,8)  comment 'The rate for used FCAS in AUD / MWHz (the denominator used is the absolute sum of negative performance for the constraint calculated by the negative contribution factor calculation). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   UNUSED_FCAS_RATE     numeric(18,8)  comment 'The rate for unused FCAS in AUD / MWHz (the denominator used is the absolute sum of negative performance for the constraint calculated by the default contribution factor calculation). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.'
);

alter table FPP_EST_PERF_COST_RATE comment 'This report delivers the estimated performance cost rate for';

alter table FPP_EST_PERF_COST_RATE
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_EST_RESIDUAL_COST_RATE                            */
/*==============================================================*/
create table FPP_EST_RESIDUAL_COST_RATE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the FPP run number from the FPP database, however there are some cases (like a new pricing run of the constraint FCAS processor received by the FPP system) where the version number listed here will be the financial estimate run number from the FPP database (this number is a different sequence from the FPP run number because there is no recalculation of performance or contribution, just changes to pricing / p regulation hence only the financial estimation is performed).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   FPP                  numeric(18,8)  comment 'FPP in AUD/MWh (the financial estimate of frequency performance payment calculated). This value can be either positive (credit) or negative (debit). For details on the calculation, please see FPP procedure and supporting documentation.',
   USED_FCAS            numeric(18,8)  comment 'Used recovery FCAS in AUD/MWh (the financial estimate of the recovery of used FCAS calculated). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.',
   UNUSED_FCAS          numeric(18,8)  comment 'Unused recovery FCAS in AUD/MWh (the financial estimate of the recovery of unused FCAS calculated). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation.'
);

alter table FPP_EST_RESIDUAL_COST_RATE comment 'This report delivers the estimated residual cost rate for ea';

alter table FPP_EST_RESIDUAL_COST_RATE
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_FCAS_SUMMARY                                      */
/*==============================================================*/
create table FPP_FCAS_SUMMARY
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the dispatch case that was the trigger for the constraint FCAS processor execution',
   RUNNO                numeric(5,0) not null  comment 'The dispatch case run number that was the trigger for the constraint FCAS processor execution',
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the FPP run number from the FPP database, however there are some cases (like a new pricing run of the constraint FCAS processor received by the FPP system) where the version number listed here will be the financial estimate run number from the FPP database (this number is a different sequence from the FPP run number because there is no recalculation of performance or contribution, just changes to pricing / p regulation hence only the financial estimation is performed).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations, i.e. RAISEREG or LOWERREG)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   REGULATION_MW        numeric(18,8)  comment 'Enabled regulation MW used in the FPP calculation (from FPP database)',
   CONSTRAINT_MARGINAL_VALUE numeric(18,8)  comment 'Marginal value in AUD/MW per hour related to the constraint (from FCAS data used for FPP calculations)',
   P_REGULATION         numeric(18,8)  comment 'P regulation value in AUD/MW per hour related to the constraint (from FCAS data used for FPP calculations also known as adjusted marginal value)',
   BASE_COST            numeric(18,8)  comment 'Base cost in AUD related to the constraint (from FCAS data used for FPP calculations)',
   TSFCAS               numeric(18,8)  comment 'TSFCAS in AUD related to the constraint (FCAS recovery amount related to the constraint also known as adjusted cost)',
   TOTAL_FPP            numeric(18,8)  comment 'Total amount of FPP in AUD changing hands related to the constraint (note that this is not the sum of FPP)',
   RCR                  numeric(18,5)  comment 'RCR MW (the calculated requirement for corrective response from FPP database). Note that this is a join back to the FPP_RCR table.',
   USAGE_VALUE          numeric(18,8)  comment 'Usage (calculation of the proportion of regulation FCAS that was calculated to be used). Note that this is a join back to the FPP_USAGE table.'
);

alter table FPP_FCAS_SUMMARY comment 'This report delivers a summary of FCAS requirements as used ';

alter table FPP_FCAS_SUMMARY
   add primary key (RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_FORECAST_DEFAULT_CF                               */
/*==============================================================*/
create table FPP_FORECAST_DEFAULT_CF
(
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID/ TNI)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   EFFECTIVE_START_DATETIME datetime not null  comment 'Effective period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this default contribution factor related to the combination of FPP unit ID / constraint. This is the billing period over which these default contribution factors will be effective / applied. In most cases this will align to the settlement week, however there are some cases (like a new constraint) where the effective start date will be prorated to align with the change.',
   EFFECTIVE_END_DATETIME datetime not null  comment 'Effective period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this default contribution factor related to the combination of FPP unit ID / constraint. This is the billing period over which these default contribution factors will be effective / applied. Effective end date will align with the end of a settlement week.',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the historical performance calculation run number from the FPP database (which is different from the FPP run number), however there are some cases (like a new constraint) where the version number listed here will be the FPP run number from the FPP database (this will be where the effective start date time will be prorated to align with the detection of this change).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   REGIONID             varchar(20)  comment 'Region ID of the frequency deviation / frequency measure',
   DEFAULT_CONTRIBUTION_FACTOR numeric(18,8)  comment 'Calculated default contribution factor from the historical performance period. For further details please see the FPP procedure document.',
   DCF_REASON_FLAG      numeric(5,0)  comment 'The reason flag showing the decision matrix for the default contribution factor (DCF)',
   DCF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint (raise or lower). This is used as the denominator in normalising default contribution factors (DCF) as the historical performance is always negative for DCF. For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable',
   SETTLEMENTS_UNITID   varchar(50)  comment 'The Settlements Unit ID (registered DUID / TNI) Note that this SETTLEMENTS_UNITID is what is sent and used by the Settlements system, and may be different from the FPP_UNITID for non-scheduled loads where the FPP_UNITID may be a descriptive key, whereas what will be sent to Settlements as the SETTLEMENTS_UNITID will be the TNI code.'
);

alter table FPP_FORECAST_DEFAULT_CF comment 'This report delivers the forecast default contribution facto';

alter table FPP_FORECAST_DEFAULT_CF
   add primary key (FPP_UNITID, CONSTRAINTID, EFFECTIVE_START_DATETIME, EFFECTIVE_END_DATETIME, VERSIONNO);

/*==============================================================*/
/* Table: FPP_FORECAST_RESIDUAL_DCF                             */
/*==============================================================*/
create table FPP_FORECAST_RESIDUAL_DCF
(
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   EFFECTIVE_START_DATETIME datetime not null  comment 'Effective period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this residual default contribution factor related to the constraint. This is the billing period over which these default contribution factors will be effective / applied. In most cases this will align to the settlement week, however there are some cases (like a new constraint) where the effective start date will be prorated to align with the change.',
   EFFECTIVE_END_DATETIME datetime not null  comment 'Effective period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this residual default contribution factor related to the constraint. This is the billing period over which these default contribution factors will be effective / applied. Effective end date will align with the end of a settlement week.',
   VERSIONNO            numeric(10,0) not null  comment 'The version number. In most cases this version will be the historical performance calculation run number from the FPP database (which is different from the FPP run number), however there are some cases (like a new constraint) where the version number listed here will be the FPP run number from the FPP database (this will be where the effective start date time will be prorated to align with the detection of this change).',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RESIDUAL_DCF         numeric(18,8)  comment 'Calculated residual default contribution factor from the historical performance period. For further details please see the FPP procedure document.',
   RESIDUAL_DCF_REASON_FLAG numeric(5,0)  comment 'The reason flag showing the decision matrix for the residual default contribution factor (DCF)',
   DCF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint (raise or lower). This is used as the denominator in normalising default contribution factors (DCF). For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable'
);

alter table FPP_FORECAST_RESIDUAL_DCF comment 'This report delivers the forecast residual default contribut';

alter table FPP_FORECAST_RESIDUAL_DCF
   add primary key (CONSTRAINTID, EFFECTIVE_START_DATETIME, EFFECTIVE_END_DATETIME, VERSIONNO);

/*==============================================================*/
/* Table: FPP_HIST_PERFORMANCE                                  */
/*==============================================================*/
create table FPP_HIST_PERFORMANCE
(
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID/ TNI)',
   EFFECTIVE_START_DATETIME datetime not null  comment 'Effective period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this historical performance values related to the FPP unit ID. This is the billing period over which these historical performance values will be effective / applied over. This will align to the settlement week.',
   EFFECTIVE_END_DATETIME datetime not null  comment 'Effective period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this historical performance values related to the FPP unit ID. This is the billing period over which these historical performance values will be effective / applied over. This will align to the settlement week.',
   VERSIONNO            numeric(10,0) not null  comment 'Version (FPP historical performance calculation run number from the FPP database) Note that due to the these historical calculations, the version numbers listed here are different to the normal FPP run number version for trading interval calculations.',
   HIST_PERIOD_START_DATETIME datetime  comment 'Historical period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the historical period for this historical performance calculation related to the FPP unit ID. This is the historical period of trading intervals that feed into the historical performance calculation. This will align to the settlement week.',
   HIST_PERIOD_END_DATETIME datetime  comment 'Historical period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the historical period for this historical performance calculation related to the FPP unit ID. This is the historical period of trading intervals that feed into the historical performance calculation. This will align to the settlement week.',
   REG_HIST_RAISE_PERFORMANCE numeric(18,5)  comment 'Calculated regulation historical raise performance from the historical performance period (substitute raise performance when live performance is unavailable and default raise performance used for default contribution factor calculation) - please see the NER and FPP procedure documents for further information',
   REG_HIST_LOWER_PERFORMANCE numeric(18,5)  comment 'Calculated regulation historical lower performance from the historical performance period (substitute lower performance when live performance is unavailable and default lower performance used for default contribution factor calculation) - please see the NER and FPP procedure documents for further information',
   FPP_HIST_RAISE_PERFORMANCE numeric(18,5)  comment 'Calculated FPP historical raise performance from the historical performance period (substitute raise performance calculated used for negative contribution factor calculation when live performance is unavailable) - please see the NER and FPP procedure documents for further information',
   FPP_HIST_LOWER_PERFORMANCE numeric(18,5)  comment 'Calculated FPP historical lower performance from the historical performance period (substitute lower performance calculated used for negative contribution factor calculation when live performance is unavailable) - please see the NER and FPP procedure documents for further information'
);

alter table FPP_HIST_PERFORMANCE comment 'This report delivers the historical performance calculated b';

alter table FPP_HIST_PERFORMANCE
   add primary key (FPP_UNITID, EFFECTIVE_START_DATETIME, EFFECTIVE_END_DATETIME, VERSIONNO);

/*==============================================================*/
/* Table: FPP_HIST_REGION_PERFORMANCE                           */
/*==============================================================*/
create table FPP_HIST_REGION_PERFORMANCE
(
   REGIONID             varchar(20) not null  comment 'Region ID of the historical region performance',
   EFFECTIVE_START_DATETIME datetime not null  comment 'Effective period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this historical performance values related to the region ID. This is the billing period over which these historical performance values will be effective / applied over. This will align to the settlement week.',
   EFFECTIVE_END_DATETIME datetime not null  comment 'Effective period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the effective period for this historical performance values related to the region ID. This is the billing period over which these historical performance values will be effective / applied over. This will align to the settlement week.',
   VERSIONNO            numeric(10,0) not null  comment 'Version (FPP historical performance calculation run number from the FPP database) Note that due to the these historical calculations, the version numbers listed here are different to the normal FPP run number version for trading interval calculations.',
   HIST_PERIOD_START_DATETIME datetime  comment 'Historical period start date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the historical period for this historical performance calculation related to the region ID. This is the historical period of trading intervals that feed into the historical performance calculation. This will align to the settlement week.',
   HIST_PERIOD_END_DATETIME datetime  comment 'Historical period end date and time (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) of the historical period for this historical performance calculation related to the region ID. This is the historical period of trading intervals that feed into the historical performance calculation. This will align to the settlement week.',
   REG_HIST_RAISE_PERFORMANCE numeric(18,5)  comment 'Calculated regulation historical raise performance from the historical performance period (substitute raise performance when live performance is unavailable and default raise performance used for default contribution factor calculation) - please see the NER and FPP procedure documents for further information',
   REG_HIST_LOWER_PERFORMANCE numeric(18,5)  comment 'Calculated regulation historical lower performance from the historical performance period (substitute lower performance when live performance is unavailable and default lower performance used for default contribution factor calculation) - please see the NER and FPP procedure documents for further information',
   FPP_HIST_RAISE_PERFORMANCE numeric(18,5)  comment 'Calculated FPP historical raise performance from the historical performance period (substitute raise performance calculated used for negative contribution factor calculation when live performance is unavailable) - please see the NER and FPP procedure documents for further information',
   FPP_HIST_LOWER_PERFORMANCE numeric(18,5)  comment 'Calculated FPP historical lower performance from the historical performance period (substitute lower performance calculated used for negative contribution factor calculation when live performance is unavailable) - please see the NER and FPP procedure documents for further information'
);

alter table FPP_HIST_REGION_PERFORMANCE comment 'This report delivers the historical region performance calcu';

alter table FPP_HIST_REGION_PERFORMANCE
   add primary key (REGIONID, EFFECTIVE_START_DATETIME, EFFECTIVE_END_DATETIME, VERSIONNO);

/*==============================================================*/
/* Table: FPP_P5_FWD_EST_COST                                   */
/*==============================================================*/
create table FPP_P5_FWD_EST_COST
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 5 minute predispatch case that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis of these forward estimates)',
   RUNNO                numeric(5,0) not null  comment 'The 5 minute predispatch case run number that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis for these forward estimates)',
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID / TNI)',
   VERSIONNO            numeric(5,0) not null  comment 'The version number of the effective default contribution factor for the unit / constraint combination taken from the FPP_FORECAST_DEFAULT_CF table',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   EST_UNUSED_FCAS      numeric(18,8)  comment 'Estimated unused recovery FCAS in AUD (the forward financial estimate of the recovery of unused FCAS, assuming that all is unused FCAS). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation. Please note that there may be cases where there is not yet a default contribution factor for the constraint (for example if there is a new constraint binding in p5min that has not yet bound in dispatch). In these scenarios there will be no EST_UNUSED_FCAS row sent for the constraint, as it is currently incalculable until a corresponding default contribution factor is calculated from a dispatch run with this constraint binding.',
   PARTICIPANTID        varchar(20)  comment 'Participant ID'
);

alter table FPP_P5_FWD_EST_COST comment 'This report delivers the forward estimated unit cost based o';

alter table FPP_P5_FWD_EST_COST
   add primary key (RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_P5_FWD_EST_RESIDUALRATE                           */
/*==============================================================*/
create table FPP_P5_FWD_EST_RESIDUALRATE
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 5 minute predispatch case that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis of these forward estimates)',
   RUNNO                numeric(5,0) not null  comment 'The 5 minute predispatch case run number that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis for these forward estimates)',
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'The version number of the effective default contribution factor for the unit / constraint combination taken from the FPP_FORECAST_DEFAULT_CF table',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   EST_UNUSED_FCAS      numeric(18,8)  comment 'Estimated unused recovery FCAS in AUD/MWh (the forward financial estimate of the recovery of unused FCAS, assuming that all is unused FCAS). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation. Please note that there may be cases where there is not yet a residual default contribution factor for the constraint (for example if there is a new constraint binding in p5min that has not yet bound in dispatch). In these scenarios there will be no EST_UNUSED_FCAS row sent for the constraint, as this is currently incalculable until a corresponding residual default contribution factor is calculated from a dispatch run with this constraint binding.'
);

alter table FPP_P5_FWD_EST_RESIDUALRATE comment 'This report delivers the forward estimated residual cost rat';

alter table FPP_P5_FWD_EST_RESIDUALRATE
   add primary key (RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_PD_FWD_EST_COST                                   */
/*==============================================================*/
create table FPP_PD_FWD_EST_COST
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Predispatch sequence number for the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 30 minute predispatch case that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis of these forward estimates)',
   RUNNO                numeric(5,0) not null  comment 'The 30 minute predispatch case run number that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis for these forward estimates)',
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the 30 minute predispatch interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID / TNI)',
   VERSIONNO            numeric(5,0) not null  comment 'The version number of the effective default contribution factor for the unit / constraint combination taken from the FPP_FORECAST_DEFAULT_CF table',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   EST_UNUSED_FCAS      numeric(18,8)  comment 'Estimated unused recovery FCAS in AUD (the forward financial estimate of the recovery of unused FCAS, assuming that all is unused FCAS). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation. Please note that there may be cases where there is not yet a default contribution factor for the constraint (for example if there is a new constraint binding in predispatch that has not yet bound in dispatch). In these scenarios there will be no EST_UNUSED_FCAS row sent for the constraint, as it is currently incalculable until a corresponding default contribution factor is calculated from a dispatch run with this constraint binding.',
   PARTICIPANTID        varchar(20)  comment 'Participant ID'
);

alter table FPP_PD_FWD_EST_COST comment 'This report delivers the forward estimated unit cost based o';

alter table FPP_PD_FWD_EST_COST
   add primary key (PREDISPATCHSEQNO, RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_PD_FWD_EST_RESIDUALRATE                           */
/*==============================================================*/
create table FPP_PD_FWD_EST_RESIDUALRATE
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Predispatch sequence number for the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 30 minute predispatch case that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis of these forward estimates)',
   RUNNO                numeric(5,0) not null  comment 'The 30 minute predispatch case run number that was the trigger for the constraint FCAS processor execution (as the FCAS requirement data is the basis for these forward estimates)',
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the 30 minute predispatch interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'The version number of the effective default contribution factor for the unit / constraint combination taken from the FPP_FORECAST_DEFAULT_CF table',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RELEVANT_REGIONS     varchar(200)  comment 'Relevant regions (a comma separated list of the relevant regions for the constraint from FCAS data)',
   EST_UNUSED_FCAS      numeric(18,8)  comment 'Estimated unused recovery FCAS in AUD/MWh (the forward financial estimate of the recovery of unused FCAS, assuming that all is unused FCAS). This value will be either 0 (nil), or a negative value (debit) only. For details on the calculation, please see FPP procedure and supporting documentation. Please note that there may be cases where there is not yet a residual default contribution factor for the constraint (for example if there is a new constraint binding in predispatch that has not yet bound in dispatch). In these scenarios there will be no EST_UNUSED_FCAS row sent for the constraint, as this is currently incalculable until a corresponding residual default contribution factor is calculated from a dispatch run with this constraint binding.'
);

alter table FPP_PD_FWD_EST_RESIDUALRATE comment 'This report delivers the forward estimated residual cost rat';

alter table FPP_PD_FWD_EST_RESIDUALRATE
   add primary key (PREDISPATCHSEQNO, RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_PERFORMANCE                                       */
/*==============================================================*/
create table FPP_PERFORMANCE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID/ TNI)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   RAISE_PERFORMANCE    numeric(18,5)  comment 'Raise performance value in MWHz units (calculated by FPP for that trading interval taken from FPP database)',
   RAISE_REASON_FLAG    numeric(5,0)  comment 'The reason flag showing the decision matrix for the raise performance value Supported values are: 0 = Performance is calculated based on good input data 1 = Performance is Null as unit is a Non Primary DUID in the group 2 = Performance against the Primary DUID representing the group 4 = Performance is Null as Input data is bad or unavailable 8 = Performance is Null as FM is unreliable 12 = Performance is Null as Input data is bad or unavailable and FM is unreliable 6 = Performance against the Primary DUID representing the group is Null as Input data is bad or unavailable 10 = Performance against the Primary DUID representing the group is Null as FM is unreliable 14 = Performance against the Primary DUID representing the group is Null as Input data is bad or unavailable  and FM is unreliable',
   LOWER_PERFORMANCE    numeric(18,5)  comment 'Lower performance value in MWHz units (calculated by FPP for that trading interval taken from FPP database)',
   LOWER_REASON_FLAG    numeric(5,0)  comment 'The reason flag showing the decision matrix for the lower performance value Supported values are: 0 = Performance is calculated based on good input data 1 = Performance is Null as unit is a Non Primary DUID in the group 2 = Performance against the Primary DUID representing the group 4 = Performance is Null as Input data is bad or unavailable 8 = Performance is Null as FM is unreliable 12 = Performance is Null as Input data is bad or unavailable and FM is unreliable 6 = Performance against the Primary DUID representing the group is Null as Input data is bad or unavailable 10 = Performance against the Primary DUID representing the group is Null as FM is unreliable 14 = Performance against the Primary DUID representing the group is Null as Input data is bad or unavailable  and FM is unreliable',
   PARTICIPANTID        varchar(20)  comment 'Participant ID'
);

alter table FPP_PERFORMANCE comment 'This report delivers the calculated performance value for ea';

alter table FPP_PERFORMANCE
   add primary key (INTERVAL_DATETIME, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_RCR                                               */
/*==============================================================*/
create table FPP_RCR
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RCR                  numeric(18,5)  comment 'RCR (the calculated requirement for corrective response from FPP database)',
   RCR_REASON_FLAG      numeric(5,0)  comment 'The reason flag showing the decision matrix for the requirement for corrective response (RCR) calculation Supported values are: 0 = RCR is calculated based on good input data 1 = RCR is 0 as FM is unreliable 2 = RCR is 0 as the percentage of units with unavailable input or bad data is greater than the threshold percentage'
);

alter table FPP_RCR comment 'This report delivers the calculated RCR for each constraint ';

alter table FPP_RCR
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_REGION_FREQ_MEASURE                               */
/*==============================================================*/
create table FPP_REGION_FREQ_MEASURE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   MEASUREMENT_DATETIME datetime not null  comment 'Date and time of the SCADA data (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   REGIONID             varchar(20) not null  comment 'Region ID of the frequency deviation / frequency measure',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   FREQ_DEVIATION_HZ    numeric(18,8)  comment 'Frequency Deviation (4 second frequency deviation in Hz for that region)',
   HZ_QUALITY_FLAG      numeric(5,0)  comment 'Frequency Quality (4 second frequency deviation quality for that region) Supported values are: 0 = Bad Quality 1 = Good Quality 2 = Suspect Quality -1 = Value not used as input in the FPP calculation (generally used to indicate when SCADA data was late arriving after the FPP calculation commenced)',
   FREQ_MEASURE_HZ      numeric(18,8)  comment 'Calculated 4 second Frequency Measure for that region from FPP database',
   FM_ALIGNMENT_FLAG    numeric(5,0)  comment 'Alignment Flag (4 second frequency deviation is aligned with 4 second frequency measure for that region) Supported values are: 0 = Misaligned 1 = Aligned'
);

alter table FPP_REGION_FREQ_MEASURE comment 'This report delivers the curated 4 second frequency deviatio';

alter table FPP_REGION_FREQ_MEASURE
   add primary key (INTERVAL_DATETIME, MEASUREMENT_DATETIME, REGIONID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_RESIDUAL_CF                                       */
/*==============================================================*/
create table FPP_RESIDUAL_CF
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   RESIDUAL_CF          numeric(18,8)  comment 'Residual Contribution Factor (the calculated residual contribution factor for the constraint ID for that trading interval) - for further details please see the FPP procedure document',
   NEGATIVE_RESIDUAL_CF numeric(18,8)  comment 'Negative Residual Contribution Factor (the calculated negative residual contribution factor for the constraint ID for that trading interval) - for further details please see the FPP procedure document',
   RESIDUAL_DCF         numeric(18,8)  comment 'The Residual Default Contribution Factor (the calculated residual default contribution factor based on historical performance for the constraint ID for that trading interval) that is effective for this trading interval, which joins back to FPP_FORECAST_RESIDUAL_DCF - for further details please see the FPP procedure document',
   RESIDUAL_CF_REASON_FLAG numeric(5,0)  comment 'The reason flag showing the decision matrix for the residual contribution factor (CF) Supported values are: 0 = CF is calculated based on good input data 8 = CF is 0 because FM is unreliable. 16 = CF is 0 because more than 50 percent input is bad or not available.',
   CF_ABS_POSITIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute positive performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising contribution factors (CF) where a units performance is positive. For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable',
   CF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising contribution factors (CF) where a units performance is negative. For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable',
   NCF_ABS_NEGATIVE_PERF_TOTAL numeric(18,8)  comment 'The sum of absolute negative performance in MWHz for the combination of constraint / bid type (raise or lower). This is used as the denominator in normalising negative contribution factors (NCF). For further details please see the FPP procedure document. >0 = Performance was calculated for the units NULL = Performance for the units was unavailable 0 = When NCF is zero (i.e. CF is positive), then this total will be represented as zero'
);

alter table FPP_RESIDUAL_CF comment 'This report delivers the calculated residual contribution fa';

alter table FPP_RESIDUAL_CF
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_RESIDUAL_PERFORMANCE                              */
/*==============================================================*/
create table FPP_RESIDUAL_PERFORMANCE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   REGIONID             varchar(20) not null  comment 'Region ID of the residual performance',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   RAISE_PERFORMANCE    numeric(18,5)  comment 'Raise performance value in MWHz units (calculated by FPP for that trading interval taken from FPP database)',
   RAISE_REASON_FLAG    numeric(5,0)  comment 'The reason flag showing the decision matrix for the raise performance value Supported values are: 0 = Performance is calculated based on good input data 4 = Performance is Null as Input data is bad or unavailable 8 = Performance is Null as FM is unreliable 12 = Performance is Null as Input data is bad or unavailable and FM is unreliable',
   LOWER_PERFORMANCE    numeric(18,5)  comment 'Lower performance value in MWHz units (calculated by FPP for that trading interval taken from FPP database)',
   LOWER_REASON_FLAG    numeric(5,0)  comment 'The reason flag showing the decision matrix for the lower performance value Supported values are: 0 = Performance is calculated based on good input data 4 = Performance is Null as Input data is bad or unavailable 8 = Performance is Null as FM is unreliable 12 = Performance is Null as Input data is bad or unavailable and FM is unreliable'
);

alter table FPP_RESIDUAL_PERFORMANCE comment 'This report delivers the calculated residual performance val';

alter table FPP_RESIDUAL_PERFORMANCE
   add primary key (INTERVAL_DATETIME, REGIONID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_RUN                                               */
/*==============================================================*/
create table FPP_RUN
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   FPPRUN_DATETIME      datetime  comment 'Completion time of the FPP calculation run (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   RUN_STATUS           varchar(20)  comment 'The status of FPP_RUN at the time the data model extract report was run. Typical value is Completed',
   AUTHORISED_DATETIME  datetime  comment 'Date and time of the authorisation of this FPP calculation run (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time) - Note may be delayed in cases of ex-post calculation runs'
);

alter table FPP_RUN comment 'This report delivers details of the 5-minute FPP calculation';

alter table FPP_RUN
   add primary key (INTERVAL_DATETIME, VERSIONNO);

/*==============================================================*/
/* Table: FPP_UNIT_MW                                           */
/*==============================================================*/
create table FPP_UNIT_MW
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   MEASUREMENT_DATETIME datetime not null  comment 'Date and time of the SCADA data (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   FPP_UNITID           varchar(20) not null  comment 'FPP Unit ID (registered DUID/TNI)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   MEASURED_MW          numeric(18,8)  comment 'Measured MW (4 second SCADA measurement in MW)',
   MW_QUALITY_FLAG      numeric(5,0)  comment 'MW Quality (4 second SCADA measurement Quality) Supported values are: 0 = Bad Quality 1 = Good Quality 2 = Suspect Quality -1 = Value not used as input in the FPP calculation (generally used to indicate when SCADA data was late arriving after the FPP calculation commenced)',
   SCHEDULED_MW         numeric(18,5)  comment 'Scheduled MW (reference trajectory value from FPP calculation process)',
   DEVIATION_MW         numeric(18,5)  comment 'Unit Deviation (output of the FPP calculation process)',
   PARTICIPANTID        varchar(20)  comment 'Participant ID'
);

alter table FPP_UNIT_MW comment 'This report delivers the curated 4 second measurement MW dat';

alter table FPP_UNIT_MW
   add primary key (INTERVAL_DATETIME, MEASUREMENT_DATETIME, FPP_UNITID, VERSIONNO);

/*==============================================================*/
/* Table: FPP_USAGE                                             */
/*==============================================================*/
create table FPP_USAGE
(
   INTERVAL_DATETIME    datetime not null  comment 'Date and time of the trading interval (DD/MM/YYYY HH24:MI:SS) fixed to the UTC+10 time zone (NEM time)',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint ID (binding constraint ID from FCAS data used in FPP calculations)',
   VERSIONNO            numeric(5,0) not null  comment 'Version (FPP run number from the FPP database)',
   BIDTYPE              varchar(10)  comment 'Bid type (the bid type saved in relation to constraint ID from FCAS data used in FPP calculations)',
   REGULATION_MW        numeric(18,8)  comment 'Enabled regulation MW used in the FPP calculation (from FPP database)',
   USED_MW              numeric(18,8)  comment 'Maximum used regulation MW value (quantity of regulation FCAS that was calculated to be used in MW)',
   USAGE_VALUE          numeric(18,8)  comment 'Usage (calculation of the proportion of regulation FCAS that was calculated to be used)',
   USAGE_REASON_FLAG    numeric(5,0)  comment 'The reason flag showing the decision matrix for the usage calculation Supported values are: 0 = Usage is calculated based on good input data 1 = Usage is 0 as FM is unreliable 2 = Usage is 0 as the percentage of units with unavailable input or bad data is greater than the threshold percentage'
);

alter table FPP_USAGE comment 'This report delivers the calculated usage for each constrain';

alter table FPP_USAGE
   add primary key (INTERVAL_DATETIME, CONSTRAINTID, VERSIONNO);

/*==============================================================*/
/* Table: GDINSTRUCT                                            */
/*==============================================================*/
create table GDINSTRUCT
(
   DUID                 varchar(10)  comment 'Dispatchable unit identifier',
   STATIONID            varchar(10)  comment 'Station Identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   ID                   numeric(22,0) not null  comment 'Instruction ID (sequential number)',
   INSTRUCTIONTYPEID    varchar(10)  comment 'Instruction type',
   INSTRUCTIONSUBTYPEID varchar(10)  comment 'Instruction sub type',
   INSTRUCTIONCLASSID   varchar(10)  comment 'Instruction class',
   REASON               varchar(64)  comment 'Reason',
   INSTLEVEL            numeric(6,0)  comment 'Instruction target level',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'User authorised by',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   ISSUEDTIME           datetime  comment 'Date / time issued',
   TARGETTIME           datetime  comment 'Date / time instruction to apply',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table GDINSTRUCT comment 'GDINSTRUCT shows all manually issued dispatch instructions f';

alter table GDINSTRUCT
   add primary key (ID);

/*==============================================================*/
/* Index: GDINSTRUCT_LCX                                        */
/*==============================================================*/
create index GDINSTRUCT_LCX on GDINSTRUCT
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: GDINSTRUCT_NDX2                                       */
/*==============================================================*/
create index GDINSTRUCT_NDX2 on GDINSTRUCT
(
   DUID
);

/*==============================================================*/
/* Index: GDINSTRUCT_NDX3                                       */
/*==============================================================*/
create index GDINSTRUCT_NDX3 on GDINSTRUCT
(
   TARGETTIME
);

/*==============================================================*/
/* Table: GENCONDATA                                            */
/*==============================================================*/
create table GENCONDATA
(
   EFFECTIVEDATE        datetime not null  comment 'Effective date of this constraint',
   VERSIONNO            numeric(3,0) not null  comment 'Version with respect to the effective date',
   GENCONID             varchar(20) not null  comment 'Unique ID for the constraint',
   CONSTRAINTTYPE       varchar(2)  comment 'The logical operator (=, >=, <=)',
   CONSTRAINTVALUE      numeric(16,6)  comment 'the RHS value used if there is no dynamic RHS defined in GenericConstraintRHS',
   DESCRIPTION          varchar(256)  comment 'Detail of the plant that is not in service',
   STATUS               varchar(8)  comment 'Not used',
   GENERICCONSTRAINTWEIGHT numeric(16,6)  comment 'The constraint violation penalty factor',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   DYNAMICRHS           numeric(15,5)  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DISPATCH             varchar(1)  comment 'Flag: constraint RHS used for Dispatch? 1-used, 0-not used',
   PREDISPATCH          varchar(1)  comment 'Flag to indicate if the constraint RHS is to be used for PreDispatch, 1-used, 0-not used',
   STPASA               varchar(1)  comment 'Flag to indicate if the constraint RHS is to be used for ST PASA, 1-used, 0-not used',
   MTPASA               varchar(1)  comment 'Flag to indicate if the constraint RHS is to be used for MT PASA, 1-used, 0-not used',
   IMPACT               varchar(64)  comment 'The device(s) that is affected by the constraint e.g. Interconnector, Generator(s) or Cutset',
   SOURCE               varchar(128)  comment 'The source of the constraint formulation',
   LIMITTYPE            varchar(64)  comment 'The limit type of the constraint e.g. Transient Stability, Voltage Stability',
   REASON               varchar(256)  comment 'The contingency or reason for the constraint',
   MODIFICATIONS        varchar(256)  comment 'Details of the changes made to this version of the constraint',
   ADDITIONALNOTES      varchar(256)  comment 'Extra notes on the constraint',
   P5MIN_SCOPE_OVERRIDE varchar(2)  comment 'Extra notes on the constraint: NULL = Dispatch RHS applied in 5MPD, PD = PreDispatch RHS applied in 5MPD',
   LRC                  varchar(1)  comment 'Flag to indicate if PASA LRC run uses the constraint; 1-used, 0-not used',
   LOR                  varchar(1)  comment 'Flag to indicate if PASA LOR run uses the constraint; 1-used, 0-not used',
   FORCE_SCADA          numeric(1,0)  comment 'Flags Constraints for which NEMDE must use "InitialMW" values instead of "WhatOfInitialMW" for Intervention Pricing runs'
);

alter table GENCONDATA comment 'GENCONDATA sets out the generic constraints contained within';

alter table GENCONDATA
   add primary key (EFFECTIVEDATE, VERSIONNO, GENCONID);

/*==============================================================*/
/* Index: GENCONDATA_LCX                                        */
/*==============================================================*/
create index GENCONDATA_LCX on GENCONDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENCONSET                                             */
/*==============================================================*/
create table GENCONSET
(
   GENCONSETID          varchar(20) not null  comment 'Unique ID for the Constraint Set',
   EFFECTIVEDATE        datetime not null  comment 'Date this record becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of the record for the given effective date',
   GENCONID             varchar(20) not null  comment 'Generic Contraint ID',
   GENCONEFFDATE        datetime  comment 'Since market start in 1998 these fields have not been used and any data that has been populated in the fields should be ignored',
   GENCONVERSIONNO      numeric(3,0)  comment 'Since market start in 1998 these fields have not been used and any data that has been populated in the fields should be ignored',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table GENCONSET comment 'GENCONSET sets out generic constraint sets that are invoked ';

alter table GENCONSET
   add primary key (GENCONSETID, EFFECTIVEDATE, VERSIONNO, GENCONID);

/*==============================================================*/
/* Index: GENCONSET_LCX                                         */
/*==============================================================*/
create index GENCONSET_LCX on GENCONSET
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENCONSETINVOKE                                       */
/*==============================================================*/
create table GENCONSETINVOKE
(
   INVOCATION_ID        numeric(9,0) not null  comment 'Abstract unique identifier for the record. Allows Invocations to be modified without affecting PK values',
   STARTDATE            datetime not null  comment 'Market date of start',
   STARTPERIOD          numeric(3,0) not null  comment 'The first dispatch interval of the invocation being the dispatch interval number starting from1 at 04:05.',
   GENCONSETID          varchar(20) not null  comment 'Unique generic constraint set identifier',
   ENDDATE              datetime  comment 'Market date end',
   ENDPERIOD            numeric(3,0)  comment 'Dispatch interval number end',
   STARTAUTHORISEDBY    varchar(15)  comment 'User authorising invoke, indicating a constraint set invocation is applicable (i.e. non-null). A null value indicates inactive invocation.',
   ENDAUTHORISEDBY      varchar(15)  comment 'user authorising revoke.',
   INTERVENTION         varchar(1)  comment '0 is not intervention, 1 is intervention and causes dispatch to solve twice.',
   ASCONSTRAINTTYPE     varchar(10)  comment 'Constraint type (e.g. ancillary services). This also flags where a constraint is an interconnector or intra-region network limit.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   STARTINTERVALDATETIME datetime  comment 'The settlement date and time corresponding to the first interval to which the constraint set is to be applied.',
   ENDINTERVALDATETIME  datetime  comment 'The settlement date and time corresponding to the last interval to which the constraint set is to be applied.',
   SYSTEMNORMAL         varchar(1)  comment 'Flag to indicate if the constraint set is a system normal (1) or an outage set (0)'
);

alter table GENCONSETINVOKE comment 'GENCONSETINVOKE provides details of invoked and revoked gene';

alter table GENCONSETINVOKE
   add primary key (INVOCATION_ID);

/*==============================================================*/
/* Index: GENCONSETINVOKE_LCX                                   */
/*==============================================================*/
create index GENCONSETINVOKE_LCX on GENCONSETINVOKE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENCONSETTRK                                          */
/*==============================================================*/
create table GENCONSETTRK
(
   GENCONSETID          varchar(20) not null  comment 'Unique ID for the Constraint Set',
   EFFECTIVEDATE        datetime not null  comment 'Date this record becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of the record for the given effective date',
   DESCRIPTION          varchar(256)  comment 'Description of the constraint',
   AUTHORISEDBY         varchar(15)  comment 'The person who authorised the constraint set',
   AUTHORISEDDATE       datetime  comment 'The date and time of authorising the constraint set',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   COVERAGE             varchar(64)  comment 'The region the constraint set is located in or a special grouping (e.g. CHIMERA)',
   MODIFICATIONS        varchar(256)  comment 'Details of the changes made to this version of the constraint set',
   SYSTEMNORMAL         varchar(1)  comment 'Not used as of 2005 End of Year Release [was Flag to indicate if the constraint set is a system normal (1) or and an outage set (0)]',
   OUTAGE               varchar(256)  comment 'Detail of the plant that is not in service'
);

alter table GENCONSETTRK comment 'GENCONSETTRK assists in determining the correct version of a';

alter table GENCONSETTRK
   add primary key (GENCONSETID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: GENCONSETTRK_LCX                                      */
/*==============================================================*/
create index GENCONSETTRK_LCX on GENCONSETTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENERICCONSTRAINTRHS                                  */
/*==============================================================*/
create table GENERICCONSTRAINTRHS
(
   GENCONID             varchar(20) not null  comment 'Generic Constraint Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Effective date of this record',
   VERSIONNO            numeric(22,0) not null  comment 'Version no of this record for the effective date',
   SCOPE                varchar(2) not null  comment 'Scope of RHS term (DS, PD, ST or EQ)',
   TERMID               numeric(4,0) not null  comment 'The unique identifier for the a constraint RHS term',
   GROUPID              numeric(3,0)  comment 'ID of super-term, if this is a sub-term',
   SPD_ID               varchar(21)  comment 'ID defining data source',
   SPD_TYPE             varchar(1)  comment 'ID describing type of data source',
   FACTOR               numeric(16,6)  comment 'Multiplier applied to operator result',
   OPERATION            varchar(10)  comment 'Unitary operator to apply to data value',
   DEFAULTVALUE         numeric(16,6)  comment 'Default value if primary source given by SPD_ID and SPD_TYPE not available.',
   PARAMETERTERM1       varchar(12)  comment 'The unique identifier for the first term (logic expression) to use in a Branch term',
   PARAMETERTERM2       varchar(12)  comment 'The unique identifier for the second term (logic<=0 result) to use in a Branch term',
   PARAMETERTERM3       varchar(12)  comment 'The unique identifier for the third term (logic>0 result) to use in a Branch term',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table GENERICCONSTRAINTRHS comment 'GENERICCONSTRAINTRHS sets out details of generic constraint ';

alter table GENERICCONSTRAINTRHS
   add primary key (GENCONID, EFFECTIVEDATE, VERSIONNO, SCOPE, TERMID);

/*==============================================================*/
/* Index: GENERICCONSTRAINTRHS_LCHD_IDX                         */
/*==============================================================*/
create index GENERICCONSTRAINTRHS_LCHD_IDX on GENERICCONSTRAINTRHS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENERICEQUATIONDESC                                   */
/*==============================================================*/
create table GENERICEQUATIONDESC
(
   EQUATIONID           varchar(20) not null  comment 'Generic Equation Identifier',
   DESCRIPTION          varchar(256)  comment 'Generic Equation Description',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   IMPACT               varchar(64)  comment 'The device(s) affected by the constraint (e.g. Interconnector, Generator(s) or Cutset)',
   SOURCE               varchar(128)  comment 'The source of the constraint formulation',
   LIMITTYPE            varchar(64)  comment 'The limit type of the constraint e.g. Transient Stability, Voltage Stability',
   REASON               varchar(256)  comment 'The contingency or reason for the constraint',
   MODIFICATIONS        varchar(256)  comment 'Details of the changes made to this version of the generic equation RHS',
   ADDITIONALNOTES      varchar(256)  comment 'Extra notes on the constraint'
);

alter table GENERICEQUATIONDESC comment 'GENERICEQUATIONDESC defines a generic equation identifier wi';

alter table GENERICEQUATIONDESC
   add primary key (EQUATIONID);

/*==============================================================*/
/* Index: GENERICEQUATIONDS_LCHD_IDX                            */
/*==============================================================*/
create index GENERICEQUATIONDS_LCHD_IDX on GENERICEQUATIONDESC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENERICEQUATIONRHS                                    */
/*==============================================================*/
create table GENERICEQUATIONRHS
(
   EQUATIONID           varchar(20) not null  comment 'Generic Equation Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Effective date of this record',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of this record for the effective date',
   TERMID               numeric(3,0) not null  comment 'The unique identifier for the a equation RHS term',
   GROUPID              numeric(3,0)  comment 'ID of super-term, if this is a sub-term',
   SPD_ID               varchar(21)  comment 'ID defining data source',
   SPD_TYPE             varchar(1)  comment 'ID describing type of data source',
   FACTOR               numeric(16,6)  comment 'Multiplier applied to operator result',
   OPERATION            varchar(10)  comment 'Unitary operator to apply to data value',
   DEFAULTVALUE         numeric(16,6)  comment 'Default value if primary source given by SPD_ID and SPD_TYPE not available.',
   PARAMETERTERM1       varchar(12)  comment 'The unique identifier for the first term (logic expression) to use in a Branch term',
   PARAMETERTERM2       varchar(12)  comment 'The unique identifier for the second term (logic<=0 result) to use in a Branch term',
   PARAMETERTERM3       varchar(12)  comment 'The unique identifier for the third term (logic>0 result) to use in a Branch term',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table GENERICEQUATIONRHS comment 'GENERICEQUATIONRHS stores the formulation of commonly used G';

alter table GENERICEQUATIONRHS
   add primary key (EQUATIONID, EFFECTIVEDATE, VERSIONNO, TERMID);

/*==============================================================*/
/* Index: GENERICEQUATION_LCHD_IDX                              */
/*==============================================================*/
create index GENERICEQUATION_LCHD_IDX on GENERICEQUATIONRHS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENMETER                                              */
/*==============================================================*/
create table GENMETER
(
   METERID              varchar(12) not null  comment 'Meter Id',
   GENSETID             varchar(20)  comment 'Generator Set ID',
   CONNECTIONPOINTID    varchar(10)  comment 'Not used',
   STATIONID            varchar(10)  comment 'Station Identifier',
   METERTYPE            varchar(20)  comment 'LOAD',
   METERCLASS           varchar(10)  comment 'WATT or AUXILARY',
   VOLTAGELEVEL         numeric(6,0)  comment 'Voltage',
   APPLYDATE            datetime not null  comment 'Application date',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of the record for the given effective date',
   AUTHORISEDBY         varchar(10)  comment 'AEMO user authorising',
   AUTHORISEDDATE       datetime  comment 'Date authorised',
   COMDATE              datetime  comment 'Not used',
   DECOMDATE            datetime  comment 'Not used',
   ENDDATE              datetime  comment 'Not used',
   STARTDATE            datetime  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table GENMETER comment 'GENMETER shows details of generator meter sets.';

alter table GENMETER
   add primary key (METERID, APPLYDATE, VERSIONNO);

/*==============================================================*/
/* Index: GENMETER_LCX                                          */
/*==============================================================*/
create index GENMETER_LCX on GENMETER
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: GENMETER_NDX2                                         */
/*==============================================================*/
create index GENMETER_NDX2 on GENMETER
(
   STATIONID
);

/*==============================================================*/
/* Table: GENUNITMTRINPERIOD                                    */
/*==============================================================*/
create table GENUNITMTRINPERIOD
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   SETTLEMENTDATE       datetime not null  comment 'Trading date of meter data submitted',
   VERSIONNO            numeric(6,0) not null  comment 'Version no of the record for the given effective date',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection Point NMI',
   PERIODID             numeric(3,0) not null  comment 'Period number where 1 period ending 00:30 EST',
   GENUNITID            varchar(10)  comment 'Physical unit ID',
   STATIONID            varchar(10)  comment 'Station Identifier',
   IMPORTENERGYVALUE    numeric(16,6)  comment 'Energy sent to the pool (MWh)',
   EXPORTENERGYVALUE    numeric(16,6)  comment 'Energy received from the pool (MWh)',
   IMPORTREACTIVEVALUE  numeric(16,6)  comment 'Reactive power sent to the network',
   EXPORTREACTIVEVALUE  numeric(16,6)  comment 'Reactive power received from the network',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MDA                  varchar(10) not null  comment 'Relevant Metering Data Agent',
   LOCAL_RETAILER       varchar(10) not null default 'POOLNSW'  comment 'Local Retailer for this NMI'
);

alter table GENUNITMTRINPERIOD comment 'GENUNITMTRINPERIOD shows meter reading by period for each ge';

alter table GENUNITMTRINPERIOD
   add primary key (SETTLEMENTDATE, MDA, VERSIONNO, CONNECTIONPOINTID, PARTICIPANTID, LOCAL_RETAILER, PERIODID);

/*==============================================================*/
/* Index: GENUNITMTRINPERIOD_LCX                                */
/*==============================================================*/
create index GENUNITMTRINPERIOD_LCX on GENUNITMTRINPERIOD
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: GENUNITMTRINPERIOD_NDX2                               */
/*==============================================================*/
create index GENUNITMTRINPERIOD_NDX2 on GENUNITMTRINPERIOD
(
   STATIONID
);

/*==============================================================*/
/* Table: GENUNITS                                              */
/*==============================================================*/
create table GENUNITS
(
   GENSETID             varchar(20) not null  comment 'Physical Unit identifier',
   STATIONID            varchar(10)  comment 'Station Identifier',
   SETLOSSFACTOR        numeric(16,6)  comment 'Not used',
   CDINDICATOR          varchar(10)  comment 'Centrally dispatched Indicator',
   AGCFLAG              varchar(2)  comment 'AGC Available flag',
   SPINNINGFLAG         varchar(2)  comment 'Not used',
   VOLTLEVEL            numeric(6,0)  comment 'Voltage level',
   REGISTEREDCAPACITY   numeric(6,0)  comment 'Registered capacity',
   DISPATCHTYPE         varchar(20)  comment 'Identifies LOAD, GENERATOR or BIDIRECTIONAL. This will likely expand to more generic models as new technology types are integrated into the NEM.',
   STARTTYPE            varchar(20)  comment 'Fast / Slow / Not Dispatched',
   MKTGENERATORIND      varchar(10)  comment 'Market Generator Indicator Flag',
   NORMALSTATUS         varchar(10)  comment 'On / Off for load',
   MAXCAPACITY          numeric(6,0)  comment 'Maximum capacity',
   GENSETTYPE           varchar(15)  comment 'Genset type',
   GENSETNAME           varchar(40)  comment 'Genset name',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   CO2E_EMISSIONS_FACTOR numeric(18,8)  comment 'The emissions factor for the generating unit, as calculated by Settlements staff members',
   CO2E_ENERGY_SOURCE   varchar(100)  comment 'The energy source for the generating unit, as used in the calculation of the CO2-e emissions factor.  Distinct from the Energy Source for a generating unit published as part of the Registration Master List',
   CO2E_DATA_SOURCE     varchar(20)  comment 'An indicator as to the source of the emission factor used in the calculation of the index. The applicable values for this field would be NTNDP which indicates the emission factor is quoted from the National Transmission Network Development Plan or Estimated to indicate the emission factor has been calculated using an internal AEMO procedure based upon the Department of Climate Change and Energy Efficiency NGA factors',
   MINCAPACITY          numeric(6,0)  comment 'Minimum capacity only for load side of BDU, otherwise 0 (MW)',
   REGISTEREDMINCAPACITY numeric(6,0)  comment 'Registered minimum capacity only for load side of BDU, otherwise 0 (MW)',
   MAXSTORAGECAPACITY   numeric(15,5)  comment 'The rated storage capacity (MWh), information only'
);

alter table GENUNITS comment 'GENUNITS shows Genset details for each physical unit with th';

alter table GENUNITS
   add primary key (GENSETID);

/*==============================================================*/
/* Index: GENUNITS_LCX                                          */
/*==============================================================*/
create index GENUNITS_LCX on GENUNITS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GENUNITS_UNIT                                         */
/*==============================================================*/
create table GENUNITS_UNIT
(
   GENSETID             varchar(20) not null  comment 'System wide unique Generating Set ID',
   EFFECTIVEDATE        datetime not null  comment 'Effective Date of this detail record',
   VERSIONNO            numeric(6,0) not null  comment 'Version with respect to the effective date',
   UNIT_GROUPING_LABEL  varchar(20) not null  comment 'Label of Physical Units within the station',
   UNIT_COUNT           numeric(10,0)  comment 'Number of units in this Gen Unit grouping',
   UNIT_SIZE            numeric(8,3)  comment 'Nameplate Capacity for each unit in this grouping',
   UNIT_MAX_SIZE        numeric(8,3)  comment 'Maximum Capacity for each unit in this grouping',
   AGGREGATION_FLAG     numeric(1,0)  comment 'Deprecated as this flag is moved to DUDETAIL table with IESS release.',
   LASTCHANGED          datetime  comment 'Date/Time when record was changed',
   UNITMINSIZE          numeric(8,3)  comment 'Only applicable for the LOAD side of BDU (MW)',
   MAXSTORAGECAPACITY   numeric(15,5)  comment 'The rated storage capacity (MWh), information only',
   REGISTEREDCAPACITY   numeric(8,3)  comment 'Registered capacity for normal operations',
   REGISTEREDMINCAPACITY numeric(8,3)  comment 'Only applicable for the LOAD side of BDU (MW)'
);

alter table GENUNITS_UNIT comment 'Physical units within a Gen Unit Set';

alter table GENUNITS_UNIT
   add primary key (GENSETID, EFFECTIVEDATE, VERSIONNO, UNIT_GROUPING_LABEL);

/*==============================================================*/
/* Table: GST_BAS_CLASS                                         */
/*==============================================================*/
create table GST_BAS_CLASS
(
   BAS_CLASS            varchar(30) not null  comment 'The BAS classification',
   DESCRIPTION          varchar(100)  comment 'Description of the BAS classification',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table GST_BAS_CLASS comment 'GST_BAS_CLASS contains a static list of BAS (Business Activi';

alter table GST_BAS_CLASS
   add primary key (BAS_CLASS);

/*==============================================================*/
/* Index: GST_BAS_CLASS_LCX                                     */
/*==============================================================*/
create index GST_BAS_CLASS_LCX on GST_BAS_CLASS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GST_RATE                                              */
/*==============================================================*/
create table GST_RATE
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of the data set',
   VERSIONNO            numeric(3,0) not null  comment 'The version number of the data set',
   BAS_CLASS            varchar(30) not null  comment 'The BAS classification',
   GST_RATE             numeric(8,5)  comment 'The GST rate that applies to this BAS classification',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table GST_RATE comment 'GST_RATE maintains the GST rates on a BAS (Business Activity';

alter table GST_RATE
   add primary key (EFFECTIVEDATE, VERSIONNO, BAS_CLASS);

/*==============================================================*/
/* Index: GST_RATE_LCX                                          */
/*==============================================================*/
create index GST_RATE_LCX on GST_RATE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GST_TRANSACTION_CLASS                                 */
/*==============================================================*/
create table GST_TRANSACTION_CLASS
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of the data set',
   VERSIONNO            numeric(3,0) not null  comment 'The version number of the data set',
   TRANSACTION_TYPE     varchar(30) not null  comment 'NEM settlement transaction type',
   BAS_CLASS            varchar(30) not null  comment 'The BAS classification that the transaction type corresponds to',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table GST_TRANSACTION_CLASS comment 'GST_TRANSACTION_CLASS maps NEM settlement transaction types ';

alter table GST_TRANSACTION_CLASS
   add primary key (EFFECTIVEDATE, VERSIONNO, TRANSACTION_TYPE, BAS_CLASS);

/*==============================================================*/
/* Index: GST_TRAN_CLASS_LCX                                    */
/*==============================================================*/
create index GST_TRAN_CLASS_LCX on GST_TRANSACTION_CLASS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: GST_TRANSACTION_TYPE                                  */
/*==============================================================*/
create table GST_TRANSACTION_TYPE
(
   TRANSACTION_TYPE     varchar(30) not null  comment 'The transaction type',
   DESCRIPTION          varchar(100)  comment 'Description of the transaction type',
   GL_FINANCIALCODE     varchar(10)  comment '',
   GL_TCODE             varchar(15)  comment '',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table GST_TRANSACTION_TYPE comment 'GST_TRANSACTION_TYPE shows a static list of transaction type';

alter table GST_TRANSACTION_TYPE
   add primary key (TRANSACTION_TYPE);

/*==============================================================*/
/* Index: GST_TRANSACTION_TYPE_LCX                              */
/*==============================================================*/
create index GST_TRANSACTION_TYPE_LCX on GST_TRANSACTION_TYPE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INSTRUCTIONSUBTYPE                                    */
/*==============================================================*/
create table INSTRUCTIONSUBTYPE
(
   INSTRUCTIONTYPEID    varchar(10) not null  comment 'Instruction type',
   INSTRUCTIONSUBTYPEID varchar(10) not null  comment 'Subtype for each dispatch instruction type, for example governor off.',
   DESCRIPTION          varchar(64)  comment 'Description of instruction subtype',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INSTRUCTIONSUBTYPE comment 'Each Dispatch instruction (GD instruct) has a type and subty';

alter table INSTRUCTIONSUBTYPE
   add primary key (INSTRUCTIONTYPEID, INSTRUCTIONSUBTYPEID);

/*==============================================================*/
/* Index: INSTRUCTIONSUBTYPE_LCX                                */
/*==============================================================*/
create index INSTRUCTIONSUBTYPE_LCX on INSTRUCTIONSUBTYPE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INSTRUCTIONTYPE                                       */
/*==============================================================*/
create table INSTRUCTIONTYPE
(
   INSTRUCTIONTYPEID    varchar(10) not null  comment 'Dispatch instruction type for example FCAS service.',
   DESCRIPTION          varchar(64)  comment 'Description of instruction type',
   REGIONID             varchar(10)  comment 'Region id if regional instruction only.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INSTRUCTIONTYPE comment 'Dispatch instruction (GD instruct) has types and subtypes. I';

alter table INSTRUCTIONTYPE
   add primary key (INSTRUCTIONTYPEID);

/*==============================================================*/
/* Index: INSTRUCTIONTYPE_LCX                                   */
/*==============================================================*/
create index INSTRUCTIONTYPE_LCX on INSTRUCTIONTYPE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTCONTRACT                                           */
/*==============================================================*/
create table INTCONTRACT
(
   CONTRACTID           varchar(10) not null  comment 'Intervention Contract Identifier',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   STARTDATE            datetime  comment 'Starting Date of Contract',
   ENDDATE              datetime  comment 'Terminate Date of contract',
   STARTPERIOD          numeric(3,0)  comment 'Starting period of contract',
   ENDPERIOD            numeric(3,0)  comment 'Terminate period of contract in trading interval',
   DEREGISTRATIONDATE   datetime  comment 'Not Used',
   DEREGISTRATIONPERIOD numeric(3,0)  comment 'Not Used',
   LASTCHANGED          datetime  comment 'Last changed date/time',
   REGIONID             varchar(10)  comment 'Region Identifier'
);

alter table INTCONTRACT comment 'INTCONTRACT shows intervention contract details. These are s';

alter table INTCONTRACT
   add primary key (CONTRACTID);

/*==============================================================*/
/* Index: INTCONTRACT_LCX                                       */
/*==============================================================*/
create index INTCONTRACT_LCX on INTCONTRACT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTCONTRACTAMOUNT                                     */
/*==============================================================*/
create table INTCONTRACTAMOUNT
(
   CONTRACTID           varchar(10) not null  comment 'Intervention Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Intervention Contract Version',
   PERIODID             numeric(3,0) not null  comment 'Period Identifier based on calendar settlement date - YYYYMMDDPP.',
   AMOUNT               numeric(16,6)  comment 'Intervention Amount for Trading Interval',
   RCF                  char(1)  comment 'Regional Recovery Flag',
   LASTCHANGED          datetime not null  comment 'Last date and time record changed'
);

alter table INTCONTRACTAMOUNT comment 'INTCONTRACTAMOUNT shows intervention contract amounts.';

alter table INTCONTRACTAMOUNT
   add primary key (CONTRACTID, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: INTCONTRACTAMOUNT_LCX                                 */
/*==============================================================*/
create index INTCONTRACTAMOUNT_LCX on INTCONTRACTAMOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTCONTRACTAMOUNTTRK                                  */
/*==============================================================*/
create table INTCONTRACTAMOUNTTRK
(
   CONTRACTID           varchar(10) not null  comment 'Intervention Contract Identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Intervention Contract Version',
   AUTHORISEDBY         varchar(15)  comment 'User name',
   AUTHORISEDDATE       datetime  comment 'Date contract was authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INTCONTRACTAMOUNTTRK comment 'INTCONTRACTAMOUNTTRK shows the latest valid version of each ';

alter table INTCONTRACTAMOUNTTRK
   add primary key (CONTRACTID, VERSIONNO);

/*==============================================================*/
/* Index: INTCONTRACTAMOUNTTRK_LCX                              */
/*==============================================================*/
create index INTCONTRACTAMOUNTTRK_LCX on INTCONTRACTAMOUNTTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTERCONNECTOR                                        */
/*==============================================================*/
create table INTERCONNECTOR
(
   INTERCONNECTORID     varchar(10) not null  comment 'Unique Id of this interconnector',
   REGIONFROM           varchar(10)  comment 'Starting region of the interconnect',
   RSOID                varchar(10)  comment 'Not used',
   REGIONTO             varchar(10)  comment 'Ending region of the interconnect',
   DESCRIPTION          varchar(64)  comment 'Description of interconnector',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INTERCONNECTOR comment 'INTERCONNECTOR sets out valid identifiers for each interconn';

alter table INTERCONNECTOR
   add primary key (INTERCONNECTORID);

/*==============================================================*/
/* Index: INTERCONNECTOR_LCX                                    */
/*==============================================================*/
create index INTERCONNECTOR_LCX on INTERCONNECTOR
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTERCONNECTORALLOC                                   */
/*==============================================================*/
create table INTERCONNECTORALLOC
(
   EFFECTIVEDATE        datetime not null  comment 'Effective Date of Allocation Details',
   VERSIONNO            numeric(5,0) not null  comment 'Version No in respect to effective date',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   ALLOCATION           numeric(12,5)  comment 'Allocation % / 100',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INTERCONNECTORALLOC comment 'INTERCONNECTORALLOC shows allocations of interconnector resi';

alter table INTERCONNECTORALLOC
   add primary key (EFFECTIVEDATE, VERSIONNO, INTERCONNECTORID, REGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: INTERCONNECTORALLOC_LCX                               */
/*==============================================================*/
create index INTERCONNECTORALLOC_LCX on INTERCONNECTORALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTERCONNECTORCONSTRAINT                              */
/*==============================================================*/
create table INTERCONNECTORCONSTRAINT
(
   RESERVEOVERALLLOADFACTOR numeric(5,2)  comment 'SPD Factor',
   FROMREGIONLOSSSHARE  numeric(5,2)  comment 'Loss share attributable to from region',
   EFFECTIVEDATE        datetime not null  comment 'Date that this limit is effective from',
   VERSIONNO            numeric(3,0) not null  comment 'Version for this date',
   INTERCONNECTORID     varchar(10) not null  comment 'Unique Id of this interconnector',
   MAXMWIN              numeric(15,5)  comment 'Limit of energy flowing into the RegionFrom',
   MAXMWOUT             numeric(15,5)  comment 'Limit of energy flowing out of the Region',
   LOSSCONSTANT         numeric(15,6)  comment 'Constant Loss factor',
   LOSSFLOWCOEFFICIENT  numeric(27,17)  comment 'Linear coefficient of loss factor calculation',
   EMSMEASURAND         varchar(40)  comment 'Identifies the EMS entity that represents the interconnector flow',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   DYNAMICRHS           varchar(1)  comment 'Not used',
   IMPORTLIMIT          numeric(6,0)  comment 'Interconnector import limit',
   EXPORTLIMIT          numeric(6,0)  comment 'Interconnector export limit',
   OUTAGEDERATIONFACTOR numeric(15,5)  comment 'SPD Factor',
   NONPHYSICALLOSSFACTOR numeric(15,5)  comment 'Factor for non-physical losses rerun',
   OVERLOADFACTOR60SEC  numeric(15,5)  comment 'Interconnector overload for 60 sec',
   OVERLOADFACTOR6SEC   numeric(15,5)  comment 'Interconnector overload for 6 sec',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   FCASSUPPORTUNAVAILABLE numeric(1,0)  comment 'Flag to indicate that the interconnector cannot support FCAS Transfers',
   ICTYPE               varchar(10)  comment 'Interconnector type - Currently either "REGULATED" or "MNSP"'
);

alter table INTERCONNECTORCONSTRAINT comment 'INTERCONNECTORCONSTRAINT sets out Interconnector limit data ';

alter table INTERCONNECTORCONSTRAINT
   add primary key (EFFECTIVEDATE, VERSIONNO, INTERCONNECTORID);

/*==============================================================*/
/* Index: INTERCONNECTORCONSTRAINT_LCX                          */
/*==============================================================*/
create index INTERCONNECTORCONSTRAINT_LCX on INTERCONNECTORCONSTRAINT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTERCONNMWFLOW                                       */
/*==============================================================*/
create table INTERCONNMWFLOW
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date (based on Trading day, not dispatch day - i.e. period 1 ends 00:30)',
   VERSIONNO            numeric(6,0) not null  comment 'Meter Data Version number',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement Period identifier (half hour period)',
   IMPORTENERGYVALUE    numeric(15,6)  comment 'Imported Energy value (MWh)',
   EXPORTENERGYVALUE    numeric(15,6)  comment 'Exported Energy value (MWh)',
   LASTCHANGED          datetime  comment 'Record creation timestamp'
);

alter table INTERCONNMWFLOW comment 'INTERCONNMWFLOW shows Metered Interconnector flow data. INTE';

alter table INTERCONNMWFLOW
   add primary key (SETTLEMENTDATE, VERSIONNO, INTERCONNECTORID, PERIODID);

/*==============================================================*/
/* Index: INTERCONNMWFLOW_LCIDX                                 */
/*==============================================================*/
create index INTERCONNMWFLOW_LCIDX on INTERCONNMWFLOW
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: INTERMITTENT_CLUSTER_AVAIL                            */
/*==============================================================*/
create table INTERMITTENT_CLUSTER_AVAIL
(
   TRADINGDATE          datetime not null  comment 'The trading day to which the availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this cluster availability submission was loaded',
   CLUSTERID            varchar(20) not null  comment 'Unique Cluster Identifier for this cluster within the DUID',
   PERIODID             numeric(3,0) not null  comment 'Trading interval number (148) within this TRADINGDATE for which ELEMENTS_UNAVAILABLE applies',
   ELEMENTS_UNAVAILABLE numeric(5,0)  comment 'Number of elements within this CLUSTERID (turbines for wind, or inverters for solar) that are not available for this TRADINGDATE and PERIODID (scheduled maintenance in AWEFS/ASEFS). Value between 0 and the registered Number of Cluster Elements.Value = 0 means no elements unavailable',
   ELEMENTS_AVAILABLE   numeric(5,0)  comment 'Number of elements within this CLUSTERID (turbines for wind, or inverters for solar) that are available for this TRADINGDATE and PERIODID (scheduled maintenance in AWEFS/ASEFS). Value between 0 and the registered Number of Cluster Elements. Value = 0 means no elements available'
);

alter table INTERMITTENT_CLUSTER_AVAIL comment 'A submission of expected plant availability for an intermitt';

alter table INTERMITTENT_CLUSTER_AVAIL
   add primary key (TRADINGDATE, DUID, OFFERDATETIME, CLUSTERID, PERIODID);

/*==============================================================*/
/* Table: INTERMITTENT_CLUSTER_AVAIL_DAY                        */
/*==============================================================*/
create table INTERMITTENT_CLUSTER_AVAIL_DAY
(
   TRADINGDATE          datetime not null  comment 'Trading Day for which this cluster availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this cluster availability submission was loaded',
   CLUSTERID            varchar(20) not null  comment 'Unique Cluster Identifier for this cluster within the DUID'
);

alter table INTERMITTENT_CLUSTER_AVAIL_DAY comment 'Summary record for an availability submission for an intermi';

alter table INTERMITTENT_CLUSTER_AVAIL_DAY
   add primary key (TRADINGDATE, DUID, OFFERDATETIME, CLUSTERID);

/*==============================================================*/
/* Table: INTERMITTENT_DS_PRED                                  */
/*==============================================================*/
create table INTERMITTENT_DS_PRED
(
   RUN_DATETIME         datetime not null  comment 'Date and Time when the forecast applies (dispatch interval ending)',
   DUID                 varchar(20) not null  comment 'DUID (or Area for non-scheduled) where this forecast applies',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this forecast submission was loaded',
   INTERVAL_DATETIME    datetime not null  comment 'Date and Time when the forecast applies (dispatch interval ending)',
   ORIGIN               varchar(20) not null  comment 'Origin of this forecast (PARTICIPANTID, AWEFS/ASEFS, or another vendor)',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Unsuppressed forecasts with higher priority values are used in Dispatch in preference to unsuppressed forecasts with lower priority values',
   FORECAST_MEAN        numeric(18,8)  comment 'Forecast MW value for this interval_DateTime',
   FORECAST_POE10       numeric(18,8)  comment 'Forecast 10% POE MW value for this interval_DateTime',
   FORECAST_POE50       numeric(18,8)  comment 'Forecast 50% POE MW value for this interval_DateTime. Used in Dispatch.',
   FORECAST_POE90       numeric(18,8)  comment 'Forecast 90% POE MW value for this interval_DateTime'
);

alter table INTERMITTENT_DS_PRED comment 'Unconstrained Intermittent Generation Forecasts (UIGF) for D';

alter table INTERMITTENT_DS_PRED
   add primary key (RUN_DATETIME, DUID, OFFERDATETIME, INTERVAL_DATETIME, ORIGIN, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTERMITTENT_DS_RUN                                   */
/*==============================================================*/
create table INTERMITTENT_DS_RUN
(
   RUN_DATETIME         datetime not null  comment 'Date and Time where the forecast applies (dispatch interval ending)',
   DUID                 varchar(20) not null  comment 'DUID (or Area for non-scheduled) where this forecast applies',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this forecast submission was loaded.',
   ORIGIN               varchar(20) not null  comment 'Origin of this forecast (PARTICIPANTID, AWEFS/ASEFS, or another vendor)',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Unsuppressed forecasts with higher priority values are used in Dispatch in preference to unsuppressed forecasts with lower priority values.',
   AUTHORISEDBY         varchar(20)  comment 'Authorising officer of this forecast (applicable for participant forecasts only). This column is not made available to the public.',
   COMMENTS             varchar(200)  comment 'Comments relating to the forecast. This column is not made available to the public.',
   LASTCHANGED          datetime  comment 'Last date and time the record changed.',
   MODEL                varchar(30)  comment 'Metadata relating to the forecast. This column is not made available to the public.',
   PARTICIPANT_TIMESTAMP datetime  comment 'Participant can document when the forecast was created',
   SUPPRESSED_AEMO      numeric(1,0)  comment 'Was this forecast suppressed by AEMO? Suppressed = 1,Not suppressed =0',
   SUPPRESSED_PARTICIPANT numeric(1,0)  comment 'Was this forecast suppressed by the participant? Suppressed submissions may not be used,  Suppressed = 1, Not suppressed =0',
   TRANSACTION_ID       varchar(100)  comment 'Uniquely identifies this interaction'
);

alter table INTERMITTENT_DS_RUN comment 'Unconstrained Intermittent Generation Forecasts (UIGF) for D';

alter table INTERMITTENT_DS_RUN
   add primary key (RUN_DATETIME, DUID, OFFERDATETIME, ORIGIN, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTERMITTENT_FORECAST_TRK                             */
/*==============================================================*/
create table INTERMITTENT_FORECAST_TRK
(
   SETTLEMENTDATE       datetime not null  comment 'DateTime of the Dispatch run (dispatch interval ending)',
   DUID                 varchar(20) not null  comment 'Tracks to INTERMITTENT_DS_RUN.DUID',
   ORIGIN               varchar(20)  comment 'Tracks to INTERMITTENT_DS_RUN.ORIGIN, except when the forecast used is either SCADA or FCST or Last Target',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Tracks to INTERMITTENT_DS_RUN.FORECAST_PRIORITY, except for -1 which denotes SCADA or FCST, and 0 which denotes Last Target',
   OFFERDATETIME        datetime  comment 'Tracks to INTERMITTENT_DS_RUN.OFFERDATETIME'
);

alter table INTERMITTENT_FORECAST_TRK comment 'Uniquely tracks which Intermittent Generation forecast was u';

alter table INTERMITTENT_FORECAST_TRK
   add primary key (SETTLEMENTDATE, DUID);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST                                 */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST
(
   RUN_DATETIME         datetime not null  comment 'Date Time of forecast (AEST).',
   DUID                 varchar(20) not null  comment 'Identifier of the intermittent generator.',
   START_INTERVAL_DATETIME datetime not null  comment 'Date Time (AEST) of the first half-hour interval being forecast.',
   END_INTERVAL_DATETIME datetime not null  comment 'Date Time (AEST) of the final half-hour interval being forecast.',
   VERSIONNO            numeric(10,0)  comment 'Versioning information for resolution back to AEMO''s wind generation forecasting system.',
   LASTCHANGED          datetime  comment 'Date Time record was created'
);

alter table INTERMITTENT_GEN_FCST comment 'Identifying record for a given forecast of an intermittent g';

alter table INTERMITTENT_GEN_FCST
   add primary key (RUN_DATETIME, DUID);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST_DATA                            */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST_DATA
(
   RUN_DATETIME         datetime not null  comment 'Date Time of forecast (AEST).',
   DUID                 varchar(20) not null  comment 'Identifier of the intermittent generator',
   INTERVAL_DATETIME    datetime not null  comment 'Date Time (AEST) of the halfhour interval being forecast',
   POWERMEAN            numeric(9,3)  comment 'The average forecast value in MW at the interval end',
   POWERPOE50           numeric(9,3)  comment '50% probability of exceedance forecast value in MW at the interval end',
   POWERPOELOW          numeric(9,3)  comment '90% probability of exceedance forecast value in MW at the interval end',
   POWERPOEHIGH         numeric(9,3)  comment '10% probability of exceedance forecast value in MW at the interval end',
   LASTCHANGED          datetime  comment 'Date Time record was created'
);

alter table INTERMITTENT_GEN_FCST_DATA comment 'Stores the forecast generation (MW) for each interval within';

alter table INTERMITTENT_GEN_FCST_DATA
   add primary key (RUN_DATETIME, DUID, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST_P5_PRED                         */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST_P5_PRED
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier for which this forecast applies.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   INTERVAL_DATETIME    datetime not null  comment 'Datetime (interval-ending) for the period that this forecast applies to, within the current forecast_run_datetime.',
   FORECAST_TYPE        varchar(20) not null  comment 'Type of forecast, for example, POE_10, POE_50, POE_90, MEAN and so on.',
   FORECAST_VALUE       numeric(18,8)  comment 'Forecast value in MW.'
);

alter table INTERMITTENT_GEN_FCST_P5_PRED comment 'Contains forecast predictions for intermittent wind and sola';

alter table INTERMITTENT_GEN_FCST_P5_PRED
   add primary key (FORECAST_RUN_DATETIME, DUID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY, INTERVAL_DATETIME, FORECAST_TYPE);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST_P5_RUN                          */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST_P5_RUN
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier for which this forecast applies.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   PROVIDER_TIMESTAMP   datetime  comment 'Datetime when the provider created the forecast.',
   REMARKS              varchar(300)  comment 'Comments relating to the forecast run. This column is not made available to the public.',
   MODEL_USED           varchar(30)  comment 'Metadata describing the model used to produce the forecast run. This column is not made available to the public.',
   SUPPRESSED_PROVIDER  numeric(1,0)  comment 'Flag indicating if the forecast run was suppressed by the provider when submitted. Suppressed forecasts are not used by downstream systems. Suppressed = 1, Unsuppressed = 0.',
   TRANSACTION_ID       varchar(100)  comment 'Transaction identifier for receiving the forecast run.',
   LASTCHANGED          datetime  comment 'Datetime when the forecast run was written into AEMO database.'
);

alter table INTERMITTENT_GEN_FCST_P5_RUN comment 'Contains forecast runs for intermittent wind and solar units';

alter table INTERMITTENT_GEN_FCST_P5_RUN
   add primary key (FORECAST_RUN_DATETIME, DUID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST_PRED                            */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST_PRED
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier for which this forecast applies.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   INTERVAL_DATETIME    datetime not null  comment 'Datetime (interval-ending) for the period that this forecast applies to, within the current forecast_run_datetime.',
   FORECAST_TYPE        varchar(20) not null  comment 'Type of forecast, for example, POE_10, POE_50, POE_90, MEAN and so on.',
   FORECAST_VALUE       numeric(18,8)  comment 'Forecast value in MW.'
);

alter table INTERMITTENT_GEN_FCST_PRED comment 'Contains forecast predictions for intermittent wind and sola';

alter table INTERMITTENT_GEN_FCST_PRED
   add primary key (FORECAST_RUN_DATETIME, DUID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY, INTERVAL_DATETIME, FORECAST_TYPE);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_FCST_RUN                             */
/*==============================================================*/
create table INTERMITTENT_GEN_FCST_RUN
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier for which this forecast applies.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   PROVIDER_TIMESTAMP   datetime  comment 'Datetime when the provider created the forecast.',
   REMARKS              varchar(300)  comment 'Comments relating to the forecast run. This column is not made available to the public.',
   MODEL_USED           varchar(30)  comment 'Metadata describing the model used to produce the forecast run. This column is not made available to the public.',
   SUPPRESSED_PROVIDER  numeric(1,0)  comment 'Flag indicating if the forecast run was suppressed by the provider when submitted. Suppressed forecasts are not used by downstream systems. Suppressed = 1, Unsuppressed = 0.',
   TRANSACTION_ID       varchar(100)  comment 'Transaction identifier for receiving the forecast run',
   LASTCHANGED          datetime  comment 'Datetime when the forecast run was written into AEMO database.'
);

alter table INTERMITTENT_GEN_FCST_RUN comment 'Contains forecast runs for intermittent wind and solar units';

alter table INTERMITTENT_GEN_FCST_RUN
   add primary key (FORECAST_RUN_DATETIME, DUID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_LIMIT                                */
/*==============================================================*/
create table INTERMITTENT_GEN_LIMIT
(
   TRADINGDATE          datetime not null  comment 'Trading Day for which this unit availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this unit availability submission was loaded',
   PERIODID             numeric(3,0) not null  comment 'Trading interval number (1...48) within this TRADINGDATE for which UPPERMWLIMIT applies',
   UPPERMWLIMIT         numeric(6,0)  comment 'Maximum imposed MW limit (down regulation in AWEFS/ASEFS). Value between 0 and the registered DUID Maximum Capacity. Value = -1 means no limit applies.'
);

alter table INTERMITTENT_GEN_LIMIT comment 'A submission of Upper MW Limit for an intermittent generatin';

alter table INTERMITTENT_GEN_LIMIT
   add primary key (TRADINGDATE, DUID, OFFERDATETIME, PERIODID);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_LIMIT_DAY                            */
/*==============================================================*/
create table INTERMITTENT_GEN_LIMIT_DAY
(
   TRADINGDATE          datetime not null  comment 'Trading Day for which this unit availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this unit availability submission was loaded',
   PARTICIPANTID        varchar(20)  comment 'Unique participant identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AUTHORISEDBYUSER     varchar(20)  comment 'User entering the unit availability submission',
   AUTHORISEDBYPARTICIPANTID varchar(20)  comment 'Participant entering the unit availability submission'
);

alter table INTERMITTENT_GEN_LIMIT_DAY comment 'Summary record for an Upper MW Limit submission for an inter';

alter table INTERMITTENT_GEN_LIMIT_DAY
   add primary key (TRADINGDATE, DUID, OFFERDATETIME);

/*==============================================================*/
/* Table: INTERMITTENT_GEN_SCADA                                */
/*==============================================================*/
create table INTERMITTENT_GEN_SCADA
(
   RUN_DATETIME         datetime not null  comment 'Date Time of the dispatch interval (interval ending)',
   DUID                 varchar(20) not null  comment 'Dispatchable Unit Identifier',
   SCADA_TYPE           varchar(20) not null  comment 'SCADA snapshot for intermittent generating unit at start of interval for a specified SCADA signal type. ELAV = Total Elements Available (# turbines for wind farms, # inverters for solar farms); LOCL = Local Limit (MW).',
   SCADA_VALUE          numeric(15,5)  comment 'SCADA value snapshot for intermittent generating unit at start of interval for a specified SCADA signal type.',
   SCADA_QUALITY        varchar(20)  comment 'SCADA quality snapshot for intermittent generating unit at start of interval for a specified SCADA signal type.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table INTERMITTENT_GEN_SCADA comment 'INTERMITTENT_GEN_SCADA provides the SCADA Availability for e';

alter table INTERMITTENT_GEN_SCADA
   add primary key (RUN_DATETIME, DUID, SCADA_TYPE);

/*==============================================================*/
/* Table: INTERMITTENT_P5_PRED                                  */
/*==============================================================*/
create table INTERMITTENT_P5_PRED
(
   RUN_DATETIME         datetime not null  comment 'Date and Time of the first interval of 5-Minute Predispatch where the forecast applies (dispatch interval ending)',
   DUID                 varchar(20) not null  comment 'DUID (or Area for non-scheduled) where this forecast applies',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this forecast submission was loaded',
   INTERVAL_DATETIME    datetime not null  comment 'Interval within the current RUN_DATETIME where this forecast applies (dispatch interval ending)',
   ORIGIN               varchar(20) not null  comment 'Origin of this forecast (PARTICIPANTID, AWEFS/ASEFS, or another vendor)',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Unsuppressed forecasts with higher priority values are used in 5-Minute Predispatch in preference to unsuppressed forecasts with lower priority values',
   FORECAST_MEAN        numeric(18,8)  comment 'Forecast MW value for this interval_DateTime',
   FORECAST_POE10       numeric(18,8)  comment 'Forecast 10% POE MW value for this interval_DateTime',
   FORECAST_POE50       numeric(18,8)  comment 'Forecast 50% POE MW value for this interval_DateTime.',
   FORECAST_POE90       numeric(18,8)  comment 'Forecast 90% POE MW value for this interval_DateTime'
);

alter table INTERMITTENT_P5_PRED comment 'Unconstrained Intermittent Generation Forecasts (UIGF) for 5';

alter table INTERMITTENT_P5_PRED
   add primary key (RUN_DATETIME, DUID, OFFERDATETIME, INTERVAL_DATETIME, ORIGIN, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTERMITTENT_P5_RUN                                   */
/*==============================================================*/
create table INTERMITTENT_P5_RUN
(
   RUN_DATETIME         datetime not null  comment 'Date and Time of the first interval of 5-minute pre-dispatch where the forecast applies.',
   DUID                 varchar(20) not null  comment 'DUID (or Area for non-scheduled) where this forecast applies',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this forecast submission was loaded',
   ORIGIN               varchar(20) not null  comment 'Origin of this forecast (PARTICIPANTID, AWEFS/ASEFS, or another vendor)',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Unsuppressed forecasts with higher priority values are used in 5-Minute Predispatch in preference to unsuppressed forecasts with lower priority values',
   AUTHORISEDBY         varchar(20)  comment 'Authorising officer of this forecast',
   COMMENTS             varchar(200)  comment 'Comments relating to the forecast',
   LASTCHANGED          datetime  comment 'Last date and time the record changed.',
   MODEL                varchar(30)  comment 'Metadata relating to the forecast.',
   PARTICIPANT_TIMESTAMP datetime  comment 'Participant can document when the forecast was created',
   SUPPRESSED_AEMO      numeric(1,0)  comment 'Was this forecast suppressed by AEMO? Suppressed = 1,Not suppressed =0',
   SUPPRESSED_PARTICIPANT numeric(1,0)  comment 'Was this forecast suppressed by the participant? Suppressed submissions may not be used, Suppressed = 1, Not suppressed =0',
   TRANSACTION_ID       varchar(100)  comment 'Uniquely identifies this interaction'
);

alter table INTERMITTENT_P5_RUN comment 'Unconstrained Intermittent Generation Forecasts (UIGF) for 5';

alter table INTERMITTENT_P5_RUN
   add primary key (RUN_DATETIME, DUID, OFFERDATETIME, ORIGIN, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: INTRAREGIONALLOC                                      */
/*==============================================================*/
create table INTRAREGIONALLOC
(
   EFFECTIVEDATE        datetime not null  comment 'Effective Date of Allocation Details',
   VERSIONNO            numeric(5,0) not null  comment 'Version No in respect to effective date',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   ALLOCATION           numeric(12,5)  comment 'Allocation Percent / 100',
   LASTCHANGED          datetime  comment 'Last changed date/time'
);

alter table INTRAREGIONALLOC comment 'INTRAREGIONALLOC shows allocations of intra-regional residue';

alter table INTRAREGIONALLOC
   add primary key (EFFECTIVEDATE, VERSIONNO, REGIONID, PARTICIPANTID);

/*==============================================================*/
/* Index: INTRAREGIONALLOC_LCX                                  */
/*==============================================================*/
create index INTRAREGIONALLOC_LCX on INTRAREGIONALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: IRFMAMOUNT                                            */
/*==============================================================*/
create table IRFMAMOUNT
(
   IRFMID               varchar(10) not null  comment 'Unique Industrial Relations Force Majeure event',
   EFFECTIVEDATE        datetime  comment 'Date of event',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of record of event',
   PERIODID             numeric(4,0) not null  comment 'Settlement period',
   AMOUNT               numeric(15,5)  comment 'Total settlement amount in $',
   AUTHORISEDBY         varchar(15)  comment 'Person authorising amount',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   LASTCHANGED          datetime  comment 'last changed'
);

alter table IRFMAMOUNT comment 'IRFMAMOUNT sets out settlement amounts associated with Indus';

alter table IRFMAMOUNT
   add primary key (IRFMID, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: IRFMAMOUNT_LCX                                        */
/*==============================================================*/
create index IRFMAMOUNT_LCX on IRFMAMOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: IRFMEVENTS                                            */
/*==============================================================*/
create table IRFMEVENTS
(
   IRFMID               varchar(10) not null  comment '',
   STARTDATE            datetime  comment '',
   STARTPERIOD          numeric(3,0)  comment '',
   ENDDATE              datetime  comment '',
   ENDPERIOD            numeric(3,0)  comment '',
   LASTCHANGED          datetime  comment ''
);

alter table IRFMEVENTS comment 'IRFMEVENTS sets out specific Industrial Relations Forced Maj';

alter table IRFMEVENTS
   add primary key (IRFMID);

/*==============================================================*/
/* Index: IRFMEVENTS_LCX                                        */
/*==============================================================*/
create index IRFMEVENTS_LCX on IRFMEVENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: LOSSFACTORMODEL                                       */
/*==============================================================*/
create table LOSSFACTORMODEL
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar date data set is effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version number within effective date of the status proposed',
   INTERCONNECTORID     varchar(10) not null  comment 'The unique identifier for the interconnector.',
   REGIONID             varchar(10) not null  comment 'The unique region identifier for a connection point of the interconnector',
   DEMANDCOEFFICIENT    numeric(27,17)  comment 'The coefficient applied to the region demand in the calculation of the interconnector loss factor',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table LOSSFACTORMODEL comment 'LOSSFACTORMODEL sets out the demand coefficients for each in';

alter table LOSSFACTORMODEL
   add primary key (EFFECTIVEDATE, VERSIONNO, INTERCONNECTORID, REGIONID);

/*==============================================================*/
/* Index: LOSSFACTORMODEL_LCX                                   */
/*==============================================================*/
create index LOSSFACTORMODEL_LCX on LOSSFACTORMODEL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: LOSSMODEL                                             */
/*==============================================================*/
create table LOSSMODEL
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar date data set is effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version number within effective date',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector identifier',
   PERIODID             varchar(20)  comment 'Not used',
   LOSSSEGMENT          numeric(6,0) not null  comment 'Segment Identifier (1 to 80 at present)',
   MWBREAKPOINT         numeric(6,0)  comment 'MW Value for segment',
   LOSSFACTOR           numeric(16,6)  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table LOSSMODEL comment 'LOSSMODEL sets out segment breakpoints in loss model for eac';

alter table LOSSMODEL
   add primary key (EFFECTIVEDATE, VERSIONNO, INTERCONNECTORID, LOSSSEGMENT);

/*==============================================================*/
/* Index: LOSSMODEL_LCX                                         */
/*==============================================================*/
create index LOSSMODEL_LCX on LOSSMODEL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETFEE                                             */
/*==============================================================*/
create table MARKETFEE
(
   MARKETFEEID          varchar(10) not null  comment 'Identifier for Market Fee',
   MARKETFEEPERIOD      varchar(20)  comment 'Period type - PERIOD, DAILY, WEEKLY',
   MARKETFEETYPE        varchar(12)  comment 'Type - MW or $',
   DESCRIPTION          varchar(64)  comment 'Description of market fee',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   GL_TCODE             varchar(15)  comment '',
   GL_FINANCIALCODE     varchar(10)  comment '',
   FEE_CLASS            varchar(40)  comment '',
   METER_TYPE           varchar(20)  comment 'The Energy Type for the Market Fees Calculation. E.g of Meter Types are CUSTOMER, GENERATOR, NREG, BDU etc. If Meter Type is mentioned as ALL then all the Meter Types for that Participant Category will be used in the Fee calculation',
   METER_SUBTYPE        varchar(20)  comment 'The Meter Sub Type values are ACE, ASOE or ALL. ACE represent ACE_MWH value , ASOE represent ASOE_MWH value and ALL represent sum of ACE_MWh and ASOE_MWh'
);

alter table MARKETFEE comment 'MARKETFEE sets out fee type and period for each market fee.';

alter table MARKETFEE
   add primary key (MARKETFEEID);

/*==============================================================*/
/* Index: MARKETFEE_LCX                                         */
/*==============================================================*/
create index MARKETFEE_LCX on MARKETFEE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETFEEDATA                                         */
/*==============================================================*/
create table MARKETFEEDATA
(
   MARKETFEEID          varchar(10) not null  comment 'Identifier for Market Fee',
   MARKETFEEVERSIONNO   numeric(3,0) not null  comment 'Version of fees for this id',
   EFFECTIVEDATE        datetime not null  comment 'Date on which this data becomes effective',
   MARKETFEEVALUE       numeric(22,8)  comment 'Market fee rate/MWh, a dollar amount',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKETFEEDATA comment 'MARKETFEEDATA sets out actual fee rates, as adjusted from ti';

alter table MARKETFEEDATA
   add primary key (MARKETFEEID, MARKETFEEVERSIONNO, EFFECTIVEDATE);

/*==============================================================*/
/* Index: MARKETFEEDATA_LCX                                     */
/*==============================================================*/
create index MARKETFEEDATA_LCX on MARKETFEEDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETFEETRK                                          */
/*==============================================================*/
create table MARKETFEETRK
(
   MARKETFEEVERSIONNO   numeric(3,0) not null  comment 'Version of fees for this ID',
   EFFECTIVEDATE        datetime not null  comment 'Effective Date of Market notice',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKETFEETRK comment 'MARKETFEETRK sets out versions of each market fee used and i';

alter table MARKETFEETRK
   add primary key (MARKETFEEVERSIONNO, EFFECTIVEDATE);

/*==============================================================*/
/* Index: MARKETFEETRK_LCX                                      */
/*==============================================================*/
create index MARKETFEETRK_LCX on MARKETFEETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETNOTICEDATA                                      */
/*==============================================================*/
create table MARKETNOTICEDATA
(
   NOTICEID             numeric(10,0) not null  comment 'Notice Identifier',
   EFFECTIVEDATE        datetime  comment 'Effective Date of Market notice',
   TYPEID               varchar(25)  comment 'Market Notice Type Identifier (Market - all participants. Participant - selected participants)',
   NOTICETYPE           varchar(25)  comment 'Market Notice Type',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REASON               varchar(2000)  comment 'Detail of market notices.',
   EXTERNALREFERENCE    varchar(255)  comment 'External Reference for extra data pertaining to market notice'
);

alter table MARKETNOTICEDATA comment 'MARKETNOTICEDATA shows market notices data provided to all p';

alter table MARKETNOTICEDATA
   add primary key (NOTICEID);

/*==============================================================*/
/* Index: MARKETNOTICEDATA_LCX                                  */
/*==============================================================*/
create index MARKETNOTICEDATA_LCX on MARKETNOTICEDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETNOTICETYPE                                      */
/*==============================================================*/
create table MARKETNOTICETYPE
(
   TYPEID               varchar(25) not null  comment 'Identifier for market notice type',
   DESCRIPTION          varchar(64)  comment 'Type description',
   RAISEDBY             varchar(10)  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKETNOTICETYPE comment 'MARKETNOTICETYPE sets out the different types of market noti';

alter table MARKETNOTICETYPE
   add primary key (TYPEID);

/*==============================================================*/
/* Index: MARKETNOTICETYPE_LCX                                  */
/*==============================================================*/
create index MARKETNOTICETYPE_LCX on MARKETNOTICETYPE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETSUSPENSION                                      */
/*==============================================================*/
create table MARKETSUSPENSION
(
   SUSPENSIONID         varchar(10) not null  comment 'Unique identifier for suspension',
   STARTDATE            datetime  comment 'Start date of suspension',
   STARTPERIOD          numeric(3,0)  comment 'Start trading interval of suspension',
   ENDDATE              datetime  comment 'End Date of suspension',
   ENDPERIOD            numeric(3,0)  comment 'End trading interval of suspension',
   REASON               varchar(64)  comment 'Reason for suspension',
   STARTAUTHORISEDBY    varchar(15)  comment 'User authorising start',
   ENDAUTHORISEDBY      varchar(15)  comment 'User authorising end',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKETSUSPENSION comment 'MARKETSUSPENSION is obsolete from 2017 End of Year DM4.27 Re';

alter table MARKETSUSPENSION
   add primary key (SUSPENSIONID);

/*==============================================================*/
/* Index: MARKETSUSPENSION_LCX                                  */
/*==============================================================*/
create index MARKETSUSPENSION_LCX on MARKETSUSPENSION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKETSUSREGION                                       */
/*==============================================================*/
create table MARKETSUSREGION
(
   SUSPENSIONID         varchar(10) not null  comment 'Unique identifier of suspension',
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKETSUSREGION comment 'MARKETSUSREGION  is obsolete from 2017 End of Year DM4.27 Re';

alter table MARKETSUSREGION
   add primary key (SUSPENSIONID, REGIONID);

/*==============================================================*/
/* Index: MARKETSUSREGION_LCX                                   */
/*==============================================================*/
create index MARKETSUSREGION_LCX on MARKETSUSREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKET_FEE_CAT_EXCL                                   */
/*==============================================================*/
create table MARKET_FEE_CAT_EXCL
(
   MARKETFEEID          varchar(20) not null  comment 'The excluded market fee',
   EFFECTIVEDATE        datetime not null  comment 'The date the exclusion is effective from',
   VERSION_DATETIME     datetime not null  comment 'The version information for this record',
   PARTICIPANT_CATEGORYID varchar(20) not null  comment 'Participant category to be excluded from this market fee'
);

alter table MARKET_FEE_CAT_EXCL comment 'Market fee exclusions for participant categories.';

alter table MARKET_FEE_CAT_EXCL
   add primary key (MARKETFEEID, EFFECTIVEDATE, VERSION_DATETIME, PARTICIPANT_CATEGORYID);

/*==============================================================*/
/* Table: MARKET_FEE_CAT_EXCL_TRK                               */
/*==============================================================*/
create table MARKET_FEE_CAT_EXCL_TRK
(
   MARKETFEEID          varchar(20) not null  comment 'The excluded market fee',
   EFFECTIVEDATE        datetime not null  comment 'The date the exclusion is effective from',
   VERSION_DATETIME     datetime not null  comment 'The version information for this record',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table MARKET_FEE_CAT_EXCL_TRK comment 'Tracking table for market fee exclusions for participant cat';

alter table MARKET_FEE_CAT_EXCL_TRK
   add primary key (MARKETFEEID, EFFECTIVEDATE, VERSION_DATETIME);

/*==============================================================*/
/* Table: MARKET_FEE_EXCLUSION                                  */
/*==============================================================*/
create table MARKET_FEE_EXCLUSION
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   EFFECTIVEDATE        datetime not null  comment 'Date on which this data becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version of fees for this ID',
   MARKETFEEID          varchar(10) not null  comment 'Identifier for Market Fee',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKET_FEE_EXCLUSION comment 'MARKET_FEE_EXCLUSION shows the list of market fees from whic';

alter table MARKET_FEE_EXCLUSION
   add primary key (PARTICIPANTID, EFFECTIVEDATE, VERSIONNO, MARKETFEEID);

/*==============================================================*/
/* Index: MARKET_FEE_EXCLUSION_LCX                              */
/*==============================================================*/
create index MARKET_FEE_EXCLUSION_LCX on MARKET_FEE_EXCLUSION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKET_FEE_EXCLUSIONTRK                               */
/*==============================================================*/
create table MARKET_FEE_EXCLUSIONTRK
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   EFFECTIVEDATE        datetime not null  comment 'Date on which this data becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version of fees for this ID',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKET_FEE_EXCLUSIONTRK comment 'MARKET_FEE_EXCLUSIONTRK shows authorisation details of parti';

alter table MARKET_FEE_EXCLUSIONTRK
   add primary key (PARTICIPANTID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: MARKET_FEE_EXCLUSIONTRK_LCX                           */
/*==============================================================*/
create index MARKET_FEE_EXCLUSIONTRK_LCX on MARKET_FEE_EXCLUSIONTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKET_PRICE_THRESHOLDS                               */
/*==============================================================*/
create table MARKET_PRICE_THRESHOLDS
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar date that this record becomes effective',
   VERSIONNO            numeric(4,0) not null  comment 'version no for the effective date',
   VOLL                 numeric(15,5)  comment 'value of lost load if total supply falls short of demand after load management then involuntary load',
   MARKETPRICEFLOOR     numeric(15,5)  comment 'The floor price that the spot market price will not fall below.',
   ADMINISTERED_PRICE_THRESHOLD numeric(15,5)  comment 'Threshold value beyond which Aggregate Prices per Region over 336 Trade Intervals (Energy), or 2016 Dispatch Intervals (FCAS), will result in an Administered Price declaration',
   AUTHORISEDDATE       datetime  comment 'date data authorised',
   AUTHORISEDBY         varchar(15)  comment 'user authorising',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKET_PRICE_THRESHOLDS comment 'MARKET_PRICE_THRESHOLDS sets out the market cap , floor and ';

alter table MARKET_PRICE_THRESHOLDS
   add primary key (EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: MARKET_PRICE_THRESHOLDS_LCX                           */
/*==============================================================*/
create index MARKET_PRICE_THRESHOLDS_LCX on MARKET_PRICE_THRESHOLDS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MARKET_SUSPEND_REGIME_SUM                             */
/*==============================================================*/
create table MARKET_SUSPEND_REGIME_SUM
(
   SUSPENSION_ID        varchar(20) not null  comment 'Unique identifier for this suspension event',
   REGIONID             varchar(20) not null  comment 'Region(s) covered by this evolution of the event',
   START_INTERVAL       datetime not null  comment 'First Dispatch interval from which this regime applies',
   END_INTERVAL         datetime  comment 'Last Dispatch interval for which this regime applies',
   PRICING_REGIME       varchar(20)  comment 'Pricing Regime applied',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKET_SUSPEND_REGIME_SUM comment 'Tracks the evolution of pricing regimes applied to the suspe';

alter table MARKET_SUSPEND_REGIME_SUM
   add primary key (SUSPENSION_ID, REGIONID, START_INTERVAL);

/*==============================================================*/
/* Table: MARKET_SUSPEND_REGION_SUM                             */
/*==============================================================*/
create table MARKET_SUSPEND_REGION_SUM
(
   SUSPENSION_ID        varchar(20) not null  comment 'Unique identifier for this suspension event',
   REGIONID             varchar(20) not null  comment 'Region(s) covered by the Suspension event',
   INITIAL_INTERVAL     datetime  comment 'Initial interval of the Suspension event',
   END_REGION_INTERVAL  datetime  comment 'Last Dispatch interval for the Suspension event for this Region',
   END_SUSPENSION_INTERVAL datetime  comment 'Last Dispatch interval for the Suspension event',
   LASTCHANGED          datetime  comment 'Last DateTime the Suspension was administered'
);

alter table MARKET_SUSPEND_REGION_SUM comment 'Summary of Market Suspension timings';

alter table MARKET_SUSPEND_REGION_SUM
   add primary key (SUSPENSION_ID, REGIONID);

/*==============================================================*/
/* Table: MARKET_SUSPEND_SCHEDULE                               */
/*==============================================================*/
create table MARKET_SUSPEND_SCHEDULE
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar date from when this record set is effective',
   DAY_TYPE             varchar(20) not null  comment 'Distinguishes which record set to apply - at time of writing this was Business or Non-business day but may change in the future depending on outcome of consultation',
   REGIONID             varchar(20) not null  comment 'Region affected.',
   PERIODID             numeric(3,0) not null  comment '48 intervals for a day, midnight base (equates to 00:30 - 00:00)',
   ENERGY_RRP           numeric(15,5)  comment 'Energy Price applied for this period for this Day Type',
   R6_RRP               numeric(15,5)  comment 'Raise 6Sec contingency Price applied for this period for this Day Type',
   R60_RRP              numeric(15,5)  comment 'Raise 60Sec contingency Price applied for this period for this Day Type',
   R5_RRP               numeric(15,5)  comment 'Raise 5Min contingency Price applied for this period for this Day Type',
   RREG_RRP             numeric(15,5)  comment 'Raise Regulation contingency Price applied for this period for this Day Type',
   L6_RRP               numeric(15,5)  comment 'Lower 6Sec contingency Price applied for this period for this Day Type',
   L60_RRP              numeric(15,5)  comment 'Lower 60Sec contingency Price applied for this period for this Day Type',
   L5_RRP               numeric(15,5)  comment 'Lower 5Min contingency Price applied for this period for this Day Type',
   LREG_RRP             numeric(15,5)  comment 'Lower Regulation Price applied for this period for this Day Type',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   L1_RRP               numeric(15,5)  comment 'Lower 1Sec contingency Price applied for this period for this Day Type',
   R1_RRP               numeric(15,5)  comment 'Raise 1Sec contingency Price applied for this period for this Day Type'
);

alter table MARKET_SUSPEND_SCHEDULE comment 'Trading prices that will apply in the event of a market susp';

alter table MARKET_SUSPEND_SCHEDULE
   add primary key (EFFECTIVEDATE, DAY_TYPE, REGIONID, PERIODID);

/*==============================================================*/
/* Table: MARKET_SUSPEND_SCHEDULE_TRK                           */
/*==============================================================*/
create table MARKET_SUSPEND_SCHEDULE_TRK
(
   EFFECTIVEDATE        datetime not null  comment 'Calendar date from when this record set is effective',
   SOURCE_START_DATE    datetime  comment 'Start Date of the date range for the source data',
   SOURCE_END_DATE      datetime  comment 'End Date of the date range for the source data',
   COMMENTS             varchar(1000)  comment 'Reason why this regime was applied',
   AUTHORISEDDATE       datetime  comment 'DateTime this record set was loaded',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MARKET_SUSPEND_SCHEDULE_TRK comment 'Parent table for pricing regimes used in suspensions';

alter table MARKET_SUSPEND_SCHEDULE_TRK
   add primary key (EFFECTIVEDATE);

/*==============================================================*/
/* Table: MAS_CP_CHANGE                                         */
/*==============================================================*/
create table MAS_CP_CHANGE
(
   NMI                  varchar(10) not null  comment 'National Metering Identifier',
   STATUS_FLAG          varchar(1)  comment 'Active/Inactive flag',
   CP_OLD_SECURITY_CODE varchar(4)  comment 'Old Security Code',
   CP_NEW_SECURITY_CODE varchar(4)  comment 'New Security Code',
   OLD_LOCAL_NETWORK_PROVIDER varchar(10)  comment 'Old Local Network Provider',
   OLD_LOCAL_RETAILER   varchar(10)  comment 'Old Local Retailer',
   OLD_FINANCIAL_PARTICIPANT varchar(10)  comment 'Old FRMP',
   OLD_METERING_DATA_AGENT varchar(10)  comment 'Old Metering Data Agent',
   OLD_RETAILER_OF_LAST_RESORT varchar(10)  comment 'Old Retailer of Last Resort',
   OLD_RESPONSIBLE_PERSON varchar(10)  comment 'Old Responsible Person',
   NEW_LOCAL_NETWORK_PROVIDER varchar(10)  comment 'New Local Network Provider',
   NEW_LOCAL_RETAILER   varchar(10)  comment 'New Local Retailer',
   NEW_FINANCIAL_PARTICIPANT varchar(10)  comment 'New FRMP',
   NEW_METERING_DATA_AGENT varchar(10)  comment 'New Metering Data Agent',
   NEW_RETAILER_OF_LAST_RESORT varchar(10)  comment 'New Retailer of Last Resort',
   NEW_RESPONSIBLE_PERSON varchar(10)  comment 'New Responsible Person',
   OLD_LNSP_OK          varchar(1)  comment 'Old LNSP approval flag',
   OLD_LR_OK            varchar(1)  comment 'Old LR approval flag',
   OLD_FRMP_OK          varchar(1)  comment 'Old FRMP approval flag',
   OLD_MDA_OK           varchar(1)  comment 'Old MDA approval flag',
   OLD_ROLR_OK          varchar(1)  comment 'Old ROLR approval flag',
   OLD_RP_OK            varchar(1)  comment 'Old RP approval flag',
   NEW_LNSP_OK          varchar(1)  comment 'New LNSP approval flag',
   NEW_LR_OK            varchar(1)  comment 'New LR approval flag',
   NEW_FRMP_OK          varchar(1)  comment 'New FRMP approval flag',
   NEW_MDA_OK           varchar(1)  comment 'New MDA approval flag',
   NEW_ROLR_OK          varchar(1)  comment 'New ROLR approval flag',
   NEW_RP_OK            varchar(1)  comment 'New RP approval flag',
   PRUDENTIAL_OK        varchar(1)  comment 'Prudential check flag',
   INITIAL_CHANGE_DATE  datetime  comment 'Initial change date',
   CURRENT_CHANGE_DATE  datetime  comment 'Current change date',
   CP_NAME              varchar(30)  comment 'Connection point name',
   CP_DETAIL_1          varchar(30)  comment 'Connection point detail 1',
   CP_DETAIL_2          varchar(30)  comment 'Connection point detail 2',
   CITY_SUBURB          varchar(30)  comment 'Connection point City/Suburb',
   STATE                varchar(3)  comment 'State of Australia',
   POST_CODE            varchar(4)  comment 'Connection point postcode',
   TX_NODE              varchar(4)  comment 'Connection point TNI',
   AGGREGATE_DATA       varchar(1)  comment 'Aggregate data Flag (YIN)',
   AVERAGE_DAILY_LOAD_KWH numeric(8,0)  comment 'Average Daily load in KWh',
   DISTRIBUTION_LOSS    numeric(5,4)  comment 'Distribution loss factors',
   OLD_LSNP_TEXT        varchar(30)  comment 'Old LNSP text field (LNSP misspelt in name)',
   OLD_LR_TEXT          varchar(30)  comment 'Old LR text field',
   OLD_FRMP_TEXT        varchar(30)  comment 'Old FRMP text field',
   OLD_MDA_TEXT         varchar(30)  comment 'Old MDA text field',
   OLD_ROLR_TEXT        varchar(30)  comment 'Old ROLR text field',
   OLD_RP_TEXT          varchar(30)  comment 'Old RP text field',
   NEW_LSNP_TEXT        varchar(30)  comment 'New LNSP text field (LNSP misspelt in name)',
   NEW_LR_TEXT          varchar(30)  comment 'New LR text field',
   NEW_FRMP_TEXT        varchar(30)  comment 'New FRMP text field',
   NEW_MDA_TEXT         varchar(30)  comment 'New MDA text field',
   NEW_ROLR_TEXT        varchar(30)  comment 'New ROLR text field',
   NEW_RP_TEXT          varchar(30)  comment 'New RP text field',
   LASTCHANGED          datetime  comment 'Last changed date.',
   NMI_CLASS            varchar(9)  comment 'Class of National Metering Identifier to allow for different business rules to apply',
   METERING_TYPE        varchar(9)  comment 'Type of metering installation (e.g. BASIC, MRIM, COMMS)',
   JURISDICTION         varchar(3)  comment 'Area; for application of rules',
   CREATE_DATE          datetime  comment 'Set by the system with today''s date when the change record is created.',
   EXPIRY_DATE          datetime  comment 'Set by the system (and cannot be changed).',
   METER_READ_DATE      datetime  comment 'Date of meter reading'
);

alter table MAS_CP_CHANGE comment 'MAS_CP_CHANGE records pending changes to the current MAS con';

alter table MAS_CP_CHANGE
   add primary key (NMI);

/*==============================================================*/
/* Index: MAS_CP_CHANGE_LCX                                     */
/*==============================================================*/
create index MAS_CP_CHANGE_LCX on MAS_CP_CHANGE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MAS_CP_MASTER                                         */
/*==============================================================*/
create table MAS_CP_MASTER
(
   NMI                  varchar(10) not null  comment 'National Metering Identifier',
   CP_SECURITY_CODE     varchar(4)  comment 'Security Code',
   IN_USE               varchar(1)  comment 'Active/Inactive Status flag (NEW/N/Y/X)',
   VALID_FROM_DATE      datetime not null  comment 'Record valid from date',
   VALID_TO_DATE        datetime not null  comment 'Record valid to date',
   LOCAL_NETWORK_PROVIDER varchar(10)  comment 'LNSP',
   LOCAL_RETAILER       varchar(10)  comment 'Local Retailer',
   FINANCIAL_PARTICIPANT varchar(10)  comment 'FRMP',
   METERING_DATA_AGENT  varchar(10)  comment 'MDA',
   RETAILER_OF_LAST_RESORT varchar(10)  comment 'ROLR',
   RESPONSIBLE_PERSON   varchar(10)  comment 'Responsible Person',
   CP_NAME              varchar(30)  comment 'Connection point name',
   CP_DETAIL_1          varchar(30)  comment 'Connection point detail 1',
   CP_DETAIL_2          varchar(30)  comment 'Connection point detail 2',
   CITY_SUBURB          varchar(30)  comment 'Connection point city/suburb',
   STATE                varchar(3)  comment 'State of Australia',
   POST_CODE            varchar(4)  comment 'Connection point postcode',
   TX_NODE              varchar(4)  comment 'Connection point TNI',
   AGGREGATE_DATA       varchar(1)  comment 'Aggregate data flag (YIN)',
   AVERAGE_DAILY_LOAD_KWH numeric(8,0)  comment 'Average daily load in KWh',
   DISTRIBUTION_LOSS    numeric(5,4)  comment 'Distribution loss factor',
   LSNP_TEXT            varchar(30)  comment 'LNSP text field (name has misspelt LNSP)',
   LR_TEXT              varchar(30)  comment 'LR text field',
   FRMP_TEXT            varchar(30)  comment 'FRMP text field',
   MDA_TEXT             varchar(30)  comment 'MDA text field',
   ROLR_TEXT            varchar(30)  comment 'ROLR text field',
   RP_TEXT              varchar(30)  comment 'RP text field',
   LASTCHANGED          datetime  comment 'Last changed date',
   NMI_CLASS            varchar(9)  comment '',
   METERING_TYPE        varchar(9)  comment '',
   JURISDICTION         varchar(3)  comment ''
);

alter table MAS_CP_MASTER comment 'MAS_CP_MASTER shows the current MAS configuration.';

alter table MAS_CP_MASTER
   add primary key (NMI, VALID_FROM_DATE);

alter table MAS_CP_MASTER
   add unique UC_MAS_CP_MASTER (NMI, VALID_TO_DATE);

/*==============================================================*/
/* Index: MAS_CP_MASTER_LCX                                     */
/*==============================================================*/
create index MAS_CP_MASTER_LCX on MAS_CP_MASTER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MCC_CASESOLUTION                                      */
/*==============================================================*/
create table MCC_CASESOLUTION
(
   RUN_DATETIME         datetime not null  comment '5-minute Dispatch Run identifier'
);

alter table MCC_CASESOLUTION comment 'Top level table for each MCC dispatch rerun process. Note th';

alter table MCC_CASESOLUTION
   add primary key (RUN_DATETIME);

/*==============================================================*/
/* Table: MCC_CONSTRAINTSOLUTION                                */
/*==============================================================*/
create table MCC_CONSTRAINTSOLUTION
(
   RUN_DATETIME         datetime not null  comment '5-minute Dispatch Run identifier',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint identifier (synonymous with GenConID)',
   RHS                  numeric(15,5)  comment 'Generic Constraint RHS Value for this MCC run',
   MARGINALVALUE        numeric(15,5)  comment 'Generic Constraint Marginal Value for this MCC run'
);

alter table MCC_CONSTRAINTSOLUTION comment 'Constraint solution data from the MCC dispatch rerun process';

alter table MCC_CONSTRAINTSOLUTION
   add primary key (RUN_DATETIME, CONSTRAINTID);

/*==============================================================*/
/* Table: METERDATA                                             */
/*==============================================================*/
create table METERDATA
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement period identifier (half hour period)',
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   METERRUNNO           numeric(6,0) not null  comment 'Data version no',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Transmission Node Identifier (TNI).  Identifies a Transmission NetworkConnection Point.',
   IMPORTENERGYVALUE    numeric(9,6)  comment 'Imported energy value (MWh)',
   EXPORTENERGYVALUE    numeric(9,6)  comment 'Exported energy value (MWh)',
   IMPORTREACTIVEVALUE  numeric(9,6)  comment 'Not used',
   EXPORTREACTIVEVALUE  numeric(9,6)  comment 'Not used',
   HOSTDISTRIBUTOR      varchar(10) not null  comment 'Local Retailer participant identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MDA                  varchar(10) not null  comment 'Defaults to MSATS'
);

alter table METERDATA comment 'METERDATA sets out a meter data for each customer connection';

alter table METERDATA
   add primary key (SETTLEMENTDATE, MDA, METERRUNNO, CONNECTIONPOINTID, PARTICIPANTID, HOSTDISTRIBUTOR, PERIODID);

/*==============================================================*/
/* Index: METERDATA_LCX                                         */
/*==============================================================*/
create index METERDATA_LCX on METERDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: METERDATATRK                                          */
/*==============================================================*/
create table METERDATATRK
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement calendar date',
   METERRUNNO           numeric(6,0) not null  comment 'Meter data version number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   FILENAME             varchar(40)  comment 'Meter file name (MSATS file name)',
   ACKFILENAME          varchar(40)  comment 'Not used',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Transmission Node Identifier (TNI)',
   AUTHORISEDDATE       datetime  comment 'Date processed',
   AUTHORISEDBY         varchar(15)  comment 'Not used',
   METERINGDATAAGENT    varchar(10) not null  comment 'Defaults to MSATS',
   HOSTDISTRIBUTOR      varchar(10) not null  comment 'Local retailer participant identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table METERDATATRK comment 'METERDATATRK records meter data files submitted for each con';

alter table METERDATATRK
   add primary key (SETTLEMENTDATE, METERINGDATAAGENT, METERRUNNO, CONNECTIONPOINTID, PARTICIPANTID, HOSTDISTRIBUTOR);

/*==============================================================*/
/* Index: METERDATATRK_LCX                                      */
/*==============================================================*/
create index METERDATATRK_LCX on METERDATATRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: METERDATA_AGGREGATE_READS                             */
/*==============================================================*/
create table METERDATA_AGGREGATE_READS
(
   CASE_ID              numeric(15,0) not null  comment 'Case Identifier',
   SETTLEMENTDATE       datetime not null  comment 'Settlement date within the case',
   CONNECTIONPOINTID    varchar(20) not null  comment 'Connection Point ID',
   METER_TYPE           varchar(20) not null  comment 'The meter type for the read, one of: CUSTOMER; GENERATOR; EMBEDDED_GENERATOR',
   FRMP                 varchar(20) not null  comment 'The financially responsible market participantid',
   LR                   varchar(20) not null  comment 'The local retailer at the connection point id',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval.',
   IMPORTVALUE          numeric(18,8) not null  comment 'The import(pool-centric) value for the meter read (MWh)',
   EXPORTVALUE          numeric(18,8) not null  comment 'The export(pool-centric) value for the meter read (MWh)',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table METERDATA_AGGREGATE_READS comment 'Publishes aggregated metering data associated with a wholesa';

alter table METERDATA_AGGREGATE_READS
   add primary key (CASE_ID, SETTLEMENTDATE, CONNECTIONPOINTID, METER_TYPE, FRMP, LR, PERIODID);

/*==============================================================*/
/* Table: METERDATA_GEN_DUID                                    */
/*==============================================================*/
create table METERDATA_GEN_DUID
(
   INTERVAL_DATETIME    datetime not null  comment 'Timestamp of the recorded interval',
   DUID                 varchar(10) not null  comment 'Unit ID',
   MWH_READING          numeric(18,8)  comment 'MW reading',
   LASTCHANGED          datetime  comment 'Timestamp of last record change'
);

alter table METERDATA_GEN_DUID comment 'Recorded actual generation of non-scheduled units where SCAD';

alter table METERDATA_GEN_DUID
   add primary key (INTERVAL_DATETIME, DUID);

/*==============================================================*/
/* Index: METERDATA_GEN_DUID_LCX                                */
/*==============================================================*/
create index METERDATA_GEN_DUID_LCX on METERDATA_GEN_DUID
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: METERDATA_INDIVIDUAL_READS                            */
/*==============================================================*/
create table METERDATA_INDIVIDUAL_READS
(
   CASE_ID              numeric(15,0) not null  comment 'Case Identifier',
   SETTLEMENTDATE       datetime not null  comment 'Settlement date within the case',
   METER_ID             varchar(20) not null  comment 'The National Metering Identifier (NMI)',
   METER_ID_SUFFIX      varchar(20) not null  comment 'The National Metering Identifier (NMI) data stream',
   FRMP                 varchar(20) not null  comment 'The financially responsible market participantid',
   LR                   varchar(20) not null  comment 'The local retailer at the connection point id',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval.',
   CONNECTIONPOINTID    varchar(20) not null  comment 'Connection Point ID',
   METER_TYPE           varchar(20) not null  comment 'The meter type for the read, one of: CUSTOMER; GENERATOR; EMBEDDED_GENERATOR',
   IMPORTVALUE          numeric(18,8) not null  comment 'The import(pool-centric) value for the meter read (MWh)',
   EXPORTVALUE          numeric(18,8) not null  comment 'The export(pool-centric) value for the meter read (MWh)',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table METERDATA_INDIVIDUAL_READS comment 'Publishes metering data associated with individual metering ';

alter table METERDATA_INDIVIDUAL_READS
   add primary key (CASE_ID, SETTLEMENTDATE, METER_ID, METER_ID_SUFFIX, PERIODID);

/*==============================================================*/
/* Table: METERDATA_INTERCONNECTOR                              */
/*==============================================================*/
create table METERDATA_INTERCONNECTOR
(
   CASE_ID              numeric(15,0) not null  comment 'Case Identifier',
   SETTLEMENTDATE       datetime not null  comment 'Settlement date within the case',
   INTERCONNECTORID     varchar(20) not null  comment 'Interconnector Identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval.',
   IMPORTVALUE          numeric(18,8)  comment 'The import direction value for the meter read (MWh)',
   EXPORTVALUE          numeric(18,8)  comment 'The export direction value for the meter read (MWh)',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table METERDATA_INTERCONNECTOR comment 'Publishes metering data associated with wholesale interconne';

alter table METERDATA_INTERCONNECTOR
   add primary key (CASE_ID, SETTLEMENTDATE, INTERCONNECTORID, PERIODID);

/*==============================================================*/
/* Table: METERDATA_SAPS                                        */
/*==============================================================*/
create table METERDATA_SAPS
(
   CASE_ID              numeric(15,0) not null  comment 'The Metering Case ID used for Settlements',
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date for that Week',
   CONNECTIONPOINT_ID   varchar(20) not null  comment 'The SAPS Connection Point Id',
   METER_TYPE           varchar(20) not null  comment 'The Meter Type Identifier , CUSTOMER or MSRP',
   FRMP                 varchar(20) not null  comment 'The Financial Responsible Market Participant',
   LR                   varchar(20) not null  comment 'The Local Retailer',
   PERIODID             numeric(4,0) not null  comment 'The Period ID Identifier',
   IMPORTVALUE          numeric(18,8)  comment 'The Sent Out Energy in MWh',
   EXPORTVALUE          numeric(18,8)  comment 'The Consumed Energy in MWh',
   LASTCHANGED          datetime  comment 'The Date time of the record last updated or inserted.'
);

alter table METERDATA_SAPS comment 'The SAPS Meter data for MSRP and Retailer used in the Settle';

alter table METERDATA_SAPS
   add primary key (CASE_ID, SETTLEMENTDATE, CONNECTIONPOINT_ID, METER_TYPE, FRMP, LR, PERIODID);

/*==============================================================*/
/* Table: METERDATA_TRK                                         */
/*==============================================================*/
create table METERDATA_TRK
(
   CASE_ID              numeric(15,0) not null  comment 'Case Identifier',
   AGGREGATE_READS_LOAD_DATETIME datetime  comment 'Timestamp of the aggregated reads being loaded for this case',
   INDIVIDUAL_READS_LOAD_DATETIME datetime  comment 'Timestamp of the non aggregated reads being loaded for this case',
   STARTDATE            datetime  comment 'The start date of data associated with the CASE_ID',
   ENDDATE              datetime  comment 'The end date of data associated with the Case_ID',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table METERDATA_TRK comment 'Tracking table for the publication of wholesale settlement d';

alter table METERDATA_TRK
   add primary key (CASE_ID);

/*==============================================================*/
/* Table: METERDATA_WDR_READS                                   */
/*==============================================================*/
create table METERDATA_WDR_READS
(
   MARKET_ID            varchar(20) not null  comment 'Unique identifier for the market to which this metering record applies.  Always equal to NEM in the current system.',
   CASE_ID              numeric(15,0) not null  comment 'Unique identifier for the metering case.',
   SETTLEMENTDATE       datetime not null  comment 'The settlement date for the metering record',
   METER_ID             varchar(20) not null  comment 'Unique identifier for the meter to which the metering record applies',
   TNI                  varchar(20)  comment 'Unique identifier for the transmission node to which this meter belongs on the settlement date',
   FRMP                 varchar(20)  comment 'Unique identifier for the participant acting as the FRMP for this NMI on the settlement date',
   DRSP                 varchar(20)  comment 'Unique identifier for the participant acting as the DRSP for this NMI on the settlement date',
   PERIODID             numeric(3,0) not null  comment 'Trading interval identifier, with Period 1 being the first TI for the calendar day, i.e interval ending 00:05.',
   METEREDQUANTITYIMPORT numeric(18,8)  comment 'Metered quantity Import in MWh for the NMI in the trading interval.  A negative value indicates net consumption, while a positive value indicates net generation',
   METEREDQUANTITYEXPORT numeric(18,8)  comment 'Metered quantity Export in MWh for the NMI in the trading interval.  A negative value indicates net consumption, while a positive value indicates net generation',
   BASELINEQUANTITY     numeric(18,8)  comment 'Baseline quantity in MWh for the NMI in the trading interval.  A negative value indicates net consumption, while a positive value indicates the net generation',
   QUALITYFLAG          varchar(20)  comment 'Quality flag for the meter read.  Where multiple datastreams exist against the NMI with different quality flags for each read, the lowest quality flag will be published against the NMI for the interval.',
   ISNONCOMPLIANT       numeric(1,0)  comment 'A value of TRUE (indicated by 1) for this column indicates that financial settlement of WDR transactions for this NMI should not proceed for the settlement date and trading interval. Possible values are 1 and 0.',
   BASELINECALCULATIONID varchar(100)  comment 'A reference to the baseline run that produced the baseline quantity for this NMI and interval'
);

alter table METERDATA_WDR_READS comment 'Metering Data WDR Readings';

alter table METERDATA_WDR_READS
   add primary key (MARKET_ID, CASE_ID, SETTLEMENTDATE, METER_ID, PERIODID);

/*==============================================================*/
/* Table: MMS_DATA_MODEL_AUDIT                                  */
/*==============================================================*/
create table MMS_DATA_MODEL_AUDIT
(
   INSTALLATION_DATE    datetime not null  comment 'The date in which the changes to the MMS Data Model were installed',
   MMSDM_VERSION        varchar(20) not null  comment 'The  version of MMS Data Model after the script has been applied',
   INSTALL_TYPE         varchar(10) not null  comment 'The type of the patch applied. Valid entries are: FULL, UPGRADE, DML',
   SCRIPT_VERSION       varchar(20)  comment 'The  version of the patch set to the MMS Data Model',
   NEM_CHANGE_NOTICE    varchar(20)  comment 'The NEM Change notice for which this MMS Data Model applies',
   PROJECT_TITLE        varchar(200)  comment 'The name of the business project for which these changes to the MMS Data Model apply',
   USERNAME             varchar(40)  comment 'The USER applying this script',
   STATUS               varchar(10)  comment 'The status of the upgrade. Valid entries are STARTED, FAILED, SUCCESS'
);

alter table MMS_DATA_MODEL_AUDIT comment 'MMS_DATA_MODEL_AUDIT shows the audit trail of scripts applie';

alter table MMS_DATA_MODEL_AUDIT
   add primary key (INSTALLATION_DATE, MMSDM_VERSION, INSTALL_TYPE);

/*==============================================================*/
/* Table: MNSP_BIDOFFERPERIOD                                   */
/*==============================================================*/
create table MNSP_BIDOFFERPERIOD
(
   LINKID               varchar(20) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   TRADINGDATE          datetime not null  comment 'The trading date this bid is for',
   OFFERDATETIME        datetime(3) not null  comment 'Time this bid was processed and loaded',
   PERIODID             numeric(3,0) not null  comment 'Period ID, 1 to 288',
   MAXAVAIL             numeric(8,3)  comment 'Maximum planned availability MW',
   FIXEDLOAD            numeric(8,3)  comment 'Fixed unit output, in MW. A value of NULL means no fixed load so the unit is dispatched according to bid and the market.',
   RAMPUPRATE           numeric(6,0)  comment 'Ramp rate (MW / min) in the positive direction of flow for this MNSP link for this half-hour period',
   BANDAVAIL1           numeric(8,3)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(8,3)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(8,3)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(8,3)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(8,3)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(8,3)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(8,3)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(8,3)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(8,3)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(8,3)  comment 'Availability at price band 10',
   PASAAVAILABILITY     numeric(8,3)  comment 'Allows for future use for Energy bids, being the physical plant capability including any capability potentially available within 24 hours',
   RECALL_PERIOD        numeric(8,3)  comment 'The advance notice(in hours) that a Scheduled Resource requires to achieve the PASA Availability MW for this trading interval'
);

alter table MNSP_BIDOFFERPERIOD comment 'MNSP_BIDOFFERPERIOD shows availability for 5-minute periods ';

alter table MNSP_BIDOFFERPERIOD
   add primary key (TRADINGDATE, LINKID, OFFERDATETIME, PERIODID);

/*==============================================================*/
/* Table: MNSP_DAYOFFER                                         */
/*==============================================================*/
create table MNSP_DAYOFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market Date from which bid is active',
   OFFERDATE            datetime(3) not null  comment 'Time this bid was processed and loaded',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data will take precedence',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   LINKID               varchar(10) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   ENTRYTYPE            varchar(20)  comment 'Bid type. Either Rebid or Daily',
   REBIDEXPLANATION     varchar(500)  comment 'Explanation for all rebids and inflexibilities',
   PRICEBAND1           numeric(9,2)  comment 'Price for Availability Band 1',
   PRICEBAND2           numeric(9,2)  comment 'Price for Availability Band 2',
   PRICEBAND3           numeric(9,2)  comment 'Price for Availability Band 3',
   PRICEBAND4           numeric(9,2)  comment 'Price for Availability Band 4',
   PRICEBAND5           numeric(9,2)  comment 'Price for Availability Band 5',
   PRICEBAND6           numeric(9,2)  comment 'Price for Availability Band 6',
   PRICEBAND7           numeric(9,2)  comment 'Price for Availability Band 7',
   PRICEBAND8           numeric(9,2)  comment 'Price for Availability Band 8',
   PRICEBAND9           numeric(9,2)  comment 'Price for Availability Band 9',
   PRICEBAND10          numeric(9,2)  comment 'Price for Availability Band 10',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_FACTOR            numeric(16,6)  comment 'Mandatory Restriction Offer Factor',
   REBID_EVENT_TIME     varchar(20)  comment 'The time of the event(s) or other occurrence(s) cited/adduced as the reason for the rebid. Required for rebids, not required for fixed load or low ramp rates. Expected in the format: HH:MM:SS e.g. 20:11:00',
   REBID_AWARE_TIME     varchar(20)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. The time at which the participant became aware of the event(s) / occurrence(s) that prompted the rebid. Not validated by AEMO',
   REBID_DECISION_TIME  varchar(20)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. The time at which the participant made the decision to rebid. Not validated by AEMO',
   REBID_CATEGORY       varchar(1)  comment 'Intended to support the Rebidding and Technical Parameters Guideline. A provided rebid category. Not validated by AEMO',
   REFERENCE_ID         varchar(100)  comment 'A participants unique Reference Id'
);

alter table MNSP_DAYOFFER comment 'MNSP_DAYOFFER updates as bids are processed. All bids are av';

alter table MNSP_DAYOFFER
   add primary key (SETTLEMENTDATE, OFFERDATE, VERSIONNO, PARTICIPANTID, LINKID);

/*==============================================================*/
/* Index: MNSP_DAYOFFER_LCX                                     */
/*==============================================================*/
create index MNSP_DAYOFFER_LCX on MNSP_DAYOFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MNSP_FILETRK                                          */
/*==============================================================*/
create table MNSP_FILETRK
(
   SETTLEMENTDATE       datetime not null  comment 'Market Date from which bid is active',
   OFFERDATE            datetime not null  comment 'The actual date and time the bid file was submitted by the participant',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   FILENAME             varchar(40) not null  comment 'File name for default bids, bids, rebids, re-offers or meter files, as appropriate to table',
   STATUS               varchar(10)  comment 'Load status [SUCCESSFUL/CORRUPT]',
   ACKFILENAME          varchar(40)  comment 'Acknowledge file name for bids, rebids',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MNSP_FILETRK comment 'MNSP_FILETRK shows all MNSPOFFERS transmitted to the MMS sys';

alter table MNSP_FILETRK
   add primary key (SETTLEMENTDATE, OFFERDATE, PARTICIPANTID, FILENAME);

/*==============================================================*/
/* Index: MNSP_FILETRK_LCX                                      */
/*==============================================================*/
create index MNSP_FILETRK_LCX on MNSP_FILETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MNSP_INTERCONNECTOR                                   */
/*==============================================================*/
create table MNSP_INTERCONNECTOR
(
   LINKID               varchar(10) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   EFFECTIVEDATE        datetime not null  comment 'Date when Interconnector becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data will take precedence',
   INTERCONNECTORID     varchar(10)  comment 'Interconnector Identifier',
   FROMREGION           varchar(10)  comment 'Nominated source region for Interconnector',
   TOREGION             varchar(10)  comment 'Nominated destination region for Interconnector',
   MAXCAPACITY          numeric(5,0)  comment 'Maximum capacity',
   TLF                  numeric(12,7)  comment 'Transmission Loss Factor (redundant from May 2012)',
   LHSFACTOR            numeric(12,7)  comment 'Factor applied to the LHS of constraint equations; set by AEMO',
   METERFLOWCONSTANT    numeric(12,7)  comment 'Obsolete; no longer applied. Ignore.',
   AUTHORISEDDATE       datetime  comment 'Date of authorisation. Nominal date but required to enable Interconnector.',
   AUTHORISEDBY         varchar(15)  comment 'Authorising officer',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   FROM_REGION_TLF      numeric(12,7)  comment 'Transmission Loss Factor for Link "From Region" end',
   TO_REGION_TLF        numeric(12,7)  comment 'Transmission Loss Factor for Link at "To Region" end'
);

alter table MNSP_INTERCONNECTOR comment 'MNSP_INTERCONNECTOR sets out attributes of each interconnect';

alter table MNSP_INTERCONNECTOR
   add primary key (LINKID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: MNSP_INTERCONNECTOR_LCX                               */
/*==============================================================*/
create index MNSP_INTERCONNECTOR_LCX on MNSP_INTERCONNECTOR
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MNSP_OFFERTRK                                         */
/*==============================================================*/
create table MNSP_OFFERTRK
(
   SETTLEMENTDATE       datetime not null  comment '',
   OFFERDATE            datetime not null  comment '',
   VERSIONNO            numeric(3,0) not null  comment '',
   PARTICIPANTID        varchar(10) not null  comment '',
   FILENAME             varchar(40) not null  comment '',
   AUTHORISEDDATE       datetime  comment '',
   AUTHORISEDBY         varchar(15)  comment '',
   LASTCHANGED          datetime  comment ''
);

alter table MNSP_OFFERTRK comment 'MNSP_OFFERTRK records all valid MNSPOFFERS loaded into the M';

alter table MNSP_OFFERTRK
   add primary key (SETTLEMENTDATE, OFFERDATE, VERSIONNO, PARTICIPANTID, FILENAME);

/*==============================================================*/
/* Index: MNSP_OFFERTRK_LCX                                     */
/*==============================================================*/
create index MNSP_OFFERTRK_LCX on MNSP_OFFERTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MNSP_PARTICIPANT                                      */
/*==============================================================*/
create table MNSP_PARTICIPANT
(
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Calendar date when Interconnector ownership becomes effective',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data takes precedence',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MNSP_PARTICIPANT comment 'MNSP_PARTICIPANT registers MNSP ownership.';

alter table MNSP_PARTICIPANT
   add primary key (INTERCONNECTORID, EFFECTIVEDATE, VERSIONNO, PARTICIPANTID);

/*==============================================================*/
/* Index: MNSP_PARTICIPANT_LCX                                  */
/*==============================================================*/
create index MNSP_PARTICIPANT_LCX on MNSP_PARTICIPANT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MNSP_PEROFFER                                         */
/*==============================================================*/
create table MNSP_PEROFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market Date from which bid is active',
   OFFERDATE            datetime not null  comment 'Offer date for bid',
   VERSIONNO            numeric(3,0) not null  comment 'Version of data for other key data - a higher version for same key data will take precedence',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   LINKID               varchar(10) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   PERIODID             numeric(22,0) not null  comment 'Trading Interval number',
   MAXAVAIL             numeric(6,0)  comment 'Maximum planned availability MW',
   BANDAVAIL1           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL2           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL3           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL4           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL5           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL6           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL7           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL8           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL9           numeric(6,0)  comment 'Band Availability for current Period',
   BANDAVAIL10          numeric(6,0)  comment 'Band Availability for current Period',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   FIXEDLOAD            numeric(12,6)  comment 'Inflexibility flag and availability. Fixed unit output MW. A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   RAMPUPRATE           numeric(6,0)  comment 'Ramp rate (MW / min) in the positive direction of flow for this MNSP link for this half-hour period',
   PASAAVAILABILITY     numeric(12,0)  comment 'Allows for future use for energy bids, being the physical plant capability including any capability potentially available within 24 hours',
   MR_CAPACITY          numeric(6,0)  comment 'Mandatory Restriction Offer amount'
);

alter table MNSP_PEROFFER comment 'MNSP_PEROFFER shows period by period availability and other ';

alter table MNSP_PEROFFER
   add primary key (SETTLEMENTDATE, OFFERDATE, VERSIONNO, PARTICIPANTID, LINKID, PERIODID);

/*==============================================================*/
/* Index: MNSP_PEROFFER_LCX                                     */
/*==============================================================*/
create index MNSP_PEROFFER_LCX on MNSP_PEROFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MR_DAYOFFER_STACK                                     */
/*==============================================================*/
create table MR_DAYOFFER_STACK
(
   MR_DATE              datetime not null  comment 'Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique RegionID',
   VERSION_DATETIME     datetime not null  comment 'Allows many Stack versions',
   STACK_POSITION       numeric(3,0) not null  comment 'Loss Adjusted Offer Factor Stack order starting at 1',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID or LinkID',
   AUTHORISED           numeric(1,0)  comment 'Confirms the unit is allowed to Contribute MR Capacity',
   OFFER_SETTLEMENTDATE datetime  comment 'Foreign key reference to XXXX_DayOffer.SettlementDate',
   OFFER_OFFERDATE      datetime  comment 'Foreign key reference to XXXX_DayOffer.OfferDate',
   OFFER_VERSIONNO      numeric(3,0)  comment 'Foreign key reference to XXXX_DayOffer.VersionNo',
   OFFER_TYPE           varchar(20)  comment 'Source tables - ENERGY or MNSP',
   LAOF                 numeric(16,6)  comment 'Loss Adjusted Offer Factor = TLF times MR_Factor',
   LASTCHANGED          datetime  comment 'Date and time the record was last inserted/modified'
);

alter table MR_DAYOFFER_STACK comment 'MR_DAYOFFER_STACK defines the Stack order for each version o';

alter table MR_DAYOFFER_STACK
   add primary key (MR_DATE, REGIONID, VERSION_DATETIME, STACK_POSITION);

/*==============================================================*/
/* Index: MR_DAYOFFER_STACK_LCX                                 */
/*==============================================================*/
create index MR_DAYOFFER_STACK_LCX on MR_DAYOFFER_STACK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MR_EVENT                                              */
/*==============================================================*/
create table MR_EVENT
(
   MR_DATE              datetime not null  comment 'Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique RegionID',
   DESCRIPTION          varchar(200)  comment 'Description of MR',
   AUTHORISEDDATE       datetime  comment 'Required for MR_Event to take effect',
   AUTHORISEDBY         varchar(20)  comment 'Ignored - Tracking purpose only',
   OFFER_CUT_OFF_TIME   datetime  comment 'Cut off after when new Offers and Scaling Factor changes are disallowed',
   SETTLEMENT_COMPLETE  numeric(1,0)  comment 'Flag:1 = MR settlement figures locked. Do not recalculate, 	0 = MR settlements to be recalculated',
   LASTCHANGED          datetime  comment 'Date/Time record inserted/modified'
);

alter table MR_EVENT comment 'MR_EVENT defines an MR Event for a given region on a specifi';

alter table MR_EVENT
   add primary key (MR_DATE, REGIONID);

/*==============================================================*/
/* Index: MR_EVENT_LCX                                          */
/*==============================================================*/
create index MR_EVENT_LCX on MR_EVENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MR_EVENT_SCHEDULE                                     */
/*==============================================================*/
create table MR_EVENT_SCHEDULE
(
   MR_DATE              datetime not null  comment 'Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique RegionID',
   VERSION_DATETIME     datetime not null  comment 'Effective Date/Time of Schedule; Allows many Stack versions',
   DEMAND_EFFECTIVEDATE datetime  comment 'Foreign key reference to ResDemandTrk.EffectiveDate',
   DEMAND_OFFERDATE     datetime  comment 'Foreign key reference to ResDemandTrk.OfferDate',
   DEMAND_VERSIONNO     numeric(3,0)  comment 'Foreign key reference to ResDemandTrk.VersionNo',
   AUTHORISEDBY         varchar(20)  comment 'Authorised person confirming Offer Stack (AKA Acceptance)',
   AUTHORISEDDATE       datetime  comment 'Date and time the Offer Stack confirmed',
   LASTCHANGED          datetime  comment 'Date and time the record was inserted/modified'
);

alter table MR_EVENT_SCHEDULE comment 'MR_EVENT_SCHEDULE defines the Stack version of the Acceptanc';

alter table MR_EVENT_SCHEDULE
   add primary key (MR_DATE, REGIONID, VERSION_DATETIME);

/*==============================================================*/
/* Index: MR_EVENT_SCHEDULE_LCX                                 */
/*==============================================================*/
create index MR_EVENT_SCHEDULE_LCX on MR_EVENT_SCHEDULE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MR_PEROFFER_STACK                                     */
/*==============================================================*/
create table MR_PEROFFER_STACK
(
   MR_DATE              datetime not null  comment 'Mandatory Restriction imposition date',
   REGIONID             varchar(10) not null  comment 'Unique RegionID',
   VERSION_DATETIME     datetime not null  comment 'Allows many Period Stack versions for the one Scaling Factor stack',
   STACK_POSITION       numeric(3,0) not null  comment 'LAOF Stack order',
   PERIODID             numeric(3,0) not null  comment 'Trade Period for the MR Offer',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID or LinkID. Only required here for CSV reports',
   ACCEPTED_CAPACITY    numeric(6,0)  comment 'MR Capacity to be Dispatched',
   DEDUCTED_CAPACITY    numeric(6,0)  comment 'Requested capacity reduction amount',
   LASTCHANGED          datetime  comment 'Date and time the record was last  inserted/modified'
);

alter table MR_PEROFFER_STACK comment 'MR_PEROFFER_STACK defines the accepted capacity on a period ';

alter table MR_PEROFFER_STACK
   add primary key (MR_DATE, REGIONID, VERSION_DATETIME, STACK_POSITION, PERIODID);

/*==============================================================*/
/* Index: MR_PEROFFER_STACK_LCX                                 */
/*==============================================================*/
create index MR_PEROFFER_STACK_LCX on MR_PEROFFER_STACK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASACONSTRAINTSOLUTION_D                            */
/*==============================================================*/
create table MTPASACONSTRAINTSOLUTION_D
(
   DATETIME             datetime not null  comment 'Date constraint is binding',
   CONSTRAINT_ID        varchar(20) not null  comment 'Constraint Identifier',
   DEGREE_OF_VIOLATION  numeric(16,6)  comment 'The degree in MW by which the constraint would be violated if the solution could not solve. This could be due to incorrect penalties etc. This figure should always be 0.',
   LASTCHANGED          datetime  comment 'Last changed data and time.',
   RUN_DATETIME         datetime  comment 'The run date and time'
);

alter table MTPASACONSTRAINTSOLUTION_D comment 'MTPASACONSTRAINTSOLUTION_D sets out MT PASA constraint solut';

alter table MTPASACONSTRAINTSOLUTION_D
   add primary key (DATETIME, CONSTRAINT_ID);

/*==============================================================*/
/* Index: MTPASACONSOLUTION_D_LCX                               */
/*==============================================================*/
create index MTPASACONSOLUTION_D_LCX on MTPASACONSTRAINTSOLUTION_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASAINTERCONNECTORSOLUTION_D                        */
/*==============================================================*/
create table MTPASAINTERCONNECTORSOLUTION_D
(
   DATETIME             datetime not null  comment 'Date of results. One record for each day for next two years.',
   INTERCONNECTOR_ID    varchar(12) not null  comment 'Interconnector Identifier',
   POSITIVE_INTERCONNECTOR_FLOW numeric(16,6)  comment 'The MW flow out',
   POSITIVE_TRANSFER_LIMITS numeric(16,6)  comment 'The MW transfer limits out',
   POSITIVE_BINDING     varchar(10)  comment 'Indication of a binding limit in the out direction',
   NEGATIVE_INTERCONNECTOR_FLOW numeric(16,6)  comment 'The MW flow in',
   NEGATIVE_TRANSFER_LIMITS numeric(16,6)  comment 'the MW transfer limits in',
   NEGATIVE_BINDING     varchar(10)  comment 'Indication of a binding limit in the in direction',
   LASTCHANGED          datetime  comment 'Last change date and time',
   RUN_DATETIME         datetime  comment 'The run date and time'
);

alter table MTPASAINTERCONNECTORSOLUTION_D comment 'MTPASAINTERCONNECTORSOLUTION_D shows interconnector results ';

alter table MTPASAINTERCONNECTORSOLUTION_D
   add primary key (DATETIME, INTERCONNECTOR_ID);

/*==============================================================*/
/* Index: MTPASAINTERCONSOLUTION_D_LCX                          */
/*==============================================================*/
create index MTPASAINTERCONSOLUTION_D_LCX on MTPASAINTERCONNECTORSOLUTION_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASAREGIONSOLUTION_D                                */
/*==============================================================*/
create table MTPASAREGIONSOLUTION_D
(
   DATETIME             datetime not null  comment 'Date of results. One record for each day for next two years.',
   REGION_ID            varchar(12) not null  comment 'Region Identifier',
   RUN_DATETIME         datetime  comment 'The run date and time',
   RESERVE_CONDITION    varchar(50)  comment 'The regional reserve condition',
   RESERVE_SURPLUS      numeric(16,6)  comment 'Regional reserve surplus value',
   CAPACITY_REQUIREMENT numeric(16,6)  comment 'Capacity in MW required to meet demand',
   MINIMUM_RESERVE_REQUIREMENT numeric(16,6)  comment 'Minimum required regional reserve value',
   REGION_DEMAND_10POE  numeric(16,6)  comment 'Regional 10% Probability of Exceedance demand forecast value',
   DEMAND_MINUS_SCHEDULED_LOAD numeric(16,6)  comment 'Regional demand minus the scheduled load value',
   CONSTRAINED_CAPACITY numeric(16,6)  comment 'The total regional capacity due to energy and network constraints',
   UNCONSTRAINED_CAPACITY numeric(16,6)  comment 'The total regional capacity, subject to network constraints.',
   NET_INTERCHANGE      numeric(16,6)  comment 'Regional net MW import via interconnectors',
   ENERGY_REQUIREMENT_10POE numeric(16,6)  comment 'Regional energy required to meet demand',
   REPORTED_BLOCK_ID    numeric(16,6)  comment 'The load duration curve block that is recorded in the report.',
   LASTCHANGED          datetime  comment 'Last change date and time.'
);

alter table MTPASAREGIONSOLUTION_D comment 'MTPASAREGIONSOLUTION_D shows region results for MT PASA, sho';

alter table MTPASAREGIONSOLUTION_D
   add primary key (DATETIME, REGION_ID);

/*==============================================================*/
/* Index: MTPASAREGIONSOLUTION_D_LCX                            */
/*==============================================================*/
create index MTPASAREGIONSOLUTION_D_LCX on MTPASAREGIONSOLUTION_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_CASERESULT                                     */
/*==============================================================*/
create table MTPASA_CASERESULT
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   PLEXOS_VERSION       varchar(20)  comment 'Version of PLEXOS used',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_CASERESULT comment 'MTPASA solution header table';

alter table MTPASA_CASERESULT
   add primary key (RUN_DATETIME, RUN_NO);

/*==============================================================*/
/* Table: MTPASA_CASESOLUTION                                   */
/*==============================================================*/
create table MTPASA_CASESOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.  Generated from the solution file caseid',
   RUN_NO               numeric(3,0) not null  comment 'Unique run id.  Generated from the solution file caseid',
   PASAVERSION          varchar(10)  comment 'Version of the PASA solver used to solve this case',
   RESERVECONDITION     numeric(1,0)  comment 'Low Reserve Condition (LRC) flag for the case (1 - LRC in the case, 0 - No LRCs in the case) for capacity run',
   LORCONDITION         numeric(1,0)  comment 'Lack of Reserve Condition (LOR) flag for the case indicates the most severe condition in the case  (3 = LOR3, 2 = LOR2, 1 = LOR1, 0 = No LOR)',
   CAPACITYOBJFUNCTION  numeric(12,3)  comment 'Objective Function from the Capacity Adequacy run',
   CAPACITYOPTION       numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the demand forecast used for capacity adequacy assessment: 0 = no assessment, 1 = 10%, 2 = 50%, 3 = 90%',
   MAXSURPLUSRESERVEOPTION numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the demand forecast used for assessment of Maximum surplus Reserve: 0 = no assessment, 1 = 10%, 2 = 50%, 3 = 90%',
   MAXSPARECAPACITYOPTION numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the demand forecast used for assessment of Maximum Spare Capacity: 0 = no assessment, 1 = 10%, 2 = 50%, 3 = 90%',
   INTERCONNECTORFLOWPENALTY numeric(12,3)  comment 'The penalty for non-zero interconnector flow',
   LASTCHANGED          datetime  comment 'Date and time the record was created or modified',
   RUNTYPE              varchar(50)  comment 'Discontinued in Dec 2005; was description of the constraints included in this run, being either System Normal and Planned Outage Constraints or System Normal Constraints Only',
   RELIABILITYLRCDEMANDOPTION numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for Reliability LRC assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   OUTAGELRCDEMANDOPTION numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for outage LRC assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   LORDEMANDOPTION      numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for LOR assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   RELIABILITYLRCCAPACITYOPTION varchar(10)  comment 'Generation Availability to be used in Reliability LRC run (either PASA or MARKET)',
   OUTAGELRCCAPACITYOPTION varchar(10)  comment 'Generation Availability to be used in Outage LRC run (either PASA or MARKET)',
   LORCAPACITYOPTION    varchar(10)  comment 'Generation Availability to be used in LOR run (either PASA or MARKET)',
   LORUIGFOPTION        numeric(3,0)  comment 'UIGF POE forecast availability used for this option',
   RELIABILITYLRCUIGFOPTION numeric(3,0)  comment 'UIGF POE forecast availability used for this option',
   OUTAGELRCUIGFOPTION  numeric(3,0)  comment 'UIGF POE forecast availability used for this option'
);

alter table MTPASA_CASESOLUTION comment 'MTPASA_CASESOLUTION is obsolete from 2017 End of Year DM4.27';

alter table MTPASA_CASESOLUTION
   add primary key (RUN_DATETIME, RUN_NO);

/*==============================================================*/
/* Index: MTPASA_CASESOLUTION_LCX                               */
/*==============================================================*/
create index MTPASA_CASESOLUTION_LCX on MTPASA_CASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_CASE_SET                                       */
/*==============================================================*/
create table MTPASA_CASE_SET
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins. Generated from the solution file CASEID.',
   RUN_NO               numeric(3,0) not null  comment 'Unique run id. Generated from the solution file CASEID.',
   CASESETID            numeric(3,0)  comment 'Unique id to link a set of cases run from the same inputs',
   RUNTYPEID            numeric(1,0)  comment 'Unique id for type of run, being either',
   LASTCHANGED          datetime  comment 'Date the solution was loaded'
);

alter table MTPASA_CASE_SET comment 'MTPASA_CASE_SET is obsolete from 2005 End of Year Release. T';

alter table MTPASA_CASE_SET
   add primary key (RUN_DATETIME, RUN_NO);

/*==============================================================*/
/* Index: MTPASA_CASE_SET_LCX                                   */
/*==============================================================*/
create index MTPASA_CASE_SET_LCX on MTPASA_CASE_SET
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_CONSTRAINTRESULT                               */
/*==============================================================*/
create table MTPASA_CONSTRAINTRESULT
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value is POE10',
   DAY                  datetime not null  comment 'Day this result is for',
   CONSTRAINTID         varchar(20) not null  comment 'The unique identifier for the constraint. Only binding or violating constraints are reported',
   EFFECTIVEDATE        datetime  comment 'The effective date of the constraint used',
   VERSIONNO            numeric(3,0)  comment 'The version of the constraint used',
   PERIODID             numeric(3,0)  comment 'Half hourly period reported, selected as period of maximum NEM scheduled demand (calculated as maximum of scheduled demands, averaged across iterations and reference years)',
   PROBABILITYOFBINDING numeric(8,5)  comment 'Proportion of a constraint binding, across iterations and reference years',
   PROBABILITYOFVIOLATION numeric(8,5)  comment 'Proportion of a constraint violating, across iterations and reference years',
   CONSTRAINTVIOLATION90 numeric(12,2)  comment 'The 90th percentile violation degree for this constraint, across iterations and reference years (MW)',
   CONSTRAINTVIOLATION50 numeric(12,2)  comment 'The 50th percentile violation degree for this constraint, across iterations and reference years (MW)',
   CONSTRAINTVIOLATION10 numeric(12,2)  comment 'The 10th percentile violation degree for this constraint, across iterations and reference years (MW)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_CONSTRAINTRESULT comment 'Constraint results for Binding or Violating Constraints';

alter table MTPASA_CONSTRAINTRESULT
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, DAY, CONSTRAINTID);

/*==============================================================*/
/* Table: MTPASA_CONSTRAINTSOLUTION                             */
/*==============================================================*/
create table MTPASA_CONSTRAINTSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins',
   RUN_NO               numeric(3,0) not null  comment 'Unique run id.  Generated from the solution file caseid',
   ENERGYBLOCK          datetime not null  comment 'Sunday at start of the week for this solutions energy block.  Generated from the solution file energy block',
   DAY                  datetime not null  comment 'Day this solution is for.  Generated from the solution file periodid',
   LDCBLOCK             numeric(3,0) not null  comment 'LDC block this solution is for.  Generated from the solution file periodid',
   CONSTRAINTID         varchar(20) not null  comment 'The unique identifier for the constraint',
   CAPACITYRHS          numeric(12,2)  comment 'The RHS value in the capacity evaluation',
   CAPACITYMARGINALVALUE numeric(12,2)  comment 'Capacity adequacy assessment marginal value; 0 if not binding',
   CAPACITYVIOLATIONDEGREE numeric(12,2)  comment 'Capacity adequacy assessment violation degree; 0 if not violating',
   LASTCHANGED          datetime  comment 'Date the solution was loaded',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run.  Values are RELIABILITY_LRC and OUTAGE_LRC'
);

alter table MTPASA_CONSTRAINTSOLUTION comment 'MTPASA_CONSTRAINTSOLUTION is obsolete from 2017 End of Year ';

alter table MTPASA_CONSTRAINTSOLUTION
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, ENERGYBLOCK, DAY, LDCBLOCK, CONSTRAINTID);

/*==============================================================*/
/* Index: MTPASA_CONSTRAINTSOLUTION_NDX2                        */
/*==============================================================*/
create index MTPASA_CONSTRAINTSOLUTION_NDX2 on MTPASA_CONSTRAINTSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_CONSTRAINTSUMMARY                              */
/*==============================================================*/
create table MTPASA_CONSTRAINTSUMMARY
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value is POE10',
   DAY                  datetime not null  comment 'Day this result is for',
   CONSTRAINTID         varchar(20) not null  comment 'The unique identifier for the constraint. Only binding or violating constraints are reported',
   EFFECTIVEDATE        datetime  comment 'The effective date of the constraint used',
   VERSIONNO            numeric(3,0)  comment 'The version of the constraintID',
   AGGREGATION_PERIOD   varchar(20) not null  comment 'Period data is aggregated over. Values are PEAK, SHOULDER, OFFPEAK. PEAK = 14:00-19:59, SHOULDER = 07:00-13:59 and 20:00-21:59, OFFPEAK = 22:00-06:59',
   CONSTRAINTHOURSBINDING numeric(12,2)  comment 'Constraint hours binding or violating for period, averaged across iterations and reference years',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_CONSTRAINTSUMMARY comment 'Constraint Summary results over aggregation periods';

alter table MTPASA_CONSTRAINTSUMMARY
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, DAY, CONSTRAINTID, AGGREGATION_PERIOD);

/*==============================================================*/
/* Table: MTPASA_DUIDAVAILABILITY                               */
/*==============================================================*/
create table MTPASA_DUIDAVAILABILITY
(
   PUBLISH_DATETIME     datetime not null  comment 'Date Time the report was published.',
   DAY                  datetime not null  comment 'Date on which the PASA availability of DUID applies.',
   REGIONID             varchar(20) not null  comment 'NEM Region.',
   DUID                 varchar(20) not null  comment 'NEM DUID.',
   PASAAVAILABILITY     numeric(12,0)  comment 'Offered PASA Availability of Scheduled generator DUID for the day.',
   LATEST_OFFER_DATETIME datetime  comment 'Date Time of the latest offer used for DUID for this date.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   CARRYOVERSTATUS      numeric(1,0)  comment 'Status of a reported capacity value (e.g. 1 for Yes, 0 for No)',
   PASAUNITSTATE        varchar(20)  comment 'The unit state value',
   PASARECALLTIME       numeric(4,0)  comment 'The recall time value'
);

alter table MTPASA_DUIDAVAILABILITY comment 'Offered PASA Availability of the scheduled generator DUID fo';

alter table MTPASA_DUIDAVAILABILITY
   add primary key (PUBLISH_DATETIME, DAY, REGIONID, DUID);

/*==============================================================*/
/* Table: MTPASA_INTERCONNECTORRESULT                           */
/*==============================================================*/
create table MTPASA_INTERCONNECTORRESULT
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value is POE10',
   DAY                  datetime not null  comment 'Day this result is for',
   INTERCONNECTORID     varchar(20) not null  comment 'The unique identifier for the interconnector',
   PERIODID             numeric(3,0)  comment 'Half hourly period reported, selected as period of maximum NEM scheduled demand (calculated as maximum of scheduled demands, averaged across iterations and reference years)',
   FLOW90               numeric(12,2)  comment 'The 90th percentile for flows, across iterations and reference years. Positive values indicate exporting, negative values indicate importing (MW)',
   FLOW50               numeric(12,2)  comment 'The 50th percentile for flows, across iterations and reference years. Positive values indicate exporting, negative values indicate importing (MW)',
   FLOW10               numeric(12,2)  comment 'The 10th percentile for flows, across iterations and reference years. Positive values indicate exporting, negative values indicate importing (MW)',
   PROBABILITYOFBINDINGEXPORT numeric(8,5)  comment 'Proportion of iterations and reference years with interconnector constrained when exporting',
   PROBABILITYOFBINDINGIMPORT numeric(8,5)  comment 'Proportion of iterations and reference years with interconnector constrained when importing',
   CALCULATEDEXPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of exporting energy on the basis of invoked constraints and static interconnector export limit, averaged across iterations and reference years',
   CALCULATEDIMPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of importing energy on the basis of invoked constraints and static interconnector import limit, averaged across iterations and reference years',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_INTERCONNECTORRESULT comment 'Interconnector results for interval of max demand per day';

alter table MTPASA_INTERCONNECTORRESULT
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, DAY, INTERCONNECTORID);

/*==============================================================*/
/* Table: MTPASA_INTERCONNECTORSOLUTION                         */
/*==============================================================*/
create table MTPASA_INTERCONNECTORSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins',
   RUN_NO               numeric(3,0) not null  comment 'Unique run id. Generated from the solution file caseid',
   ENERGYBLOCK          datetime not null  comment 'Sunday at start of the week for this solutions energy block. Generated from the solution file energy block',
   DAY                  datetime not null  comment 'Day this solution is for. Generated from the solution file periodid',
   LDCBLOCK             numeric(3,0) not null  comment 'LDC block this solution is for. Generated from the solution file periodid',
   INTERCONNECTORID     varchar(10) not null  comment 'The unique identifier for the interconnector',
   CAPACITYMWFLOW       numeric(12,2)  comment 'Interconnector loading level (MW) that can be reached in case of capacity scarcity in neighbouring regions subject to network and energy constraints',
   CAPACITYMARGINALVALUE numeric(12,2)  comment 'Capacity adequacy assessment marginal value; 0 if not binding',
   CAPACITYVIOLATIONDEGREE numeric(12,2)  comment 'Capacity adequacy assessment violation degree, 0 if not violating; where CapacityMWFLow <= export + violation Degree (Deficit)CapacityMWFLow >= import + CapacityViolationDegree (Deficit)',
   CALCULATEDEXPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of exporting energy on the basis of invoked constraints and static interconnector export limit',
   CALCULATEDIMPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of importing energy on the basis of invoked constraints and static interconnector import limit. Note unlike the input interconnector import limit this is a directional quantity and should be defined with respect to the interconnector flow',
   LASTCHANGED          datetime  comment 'Date the solution was loaded',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run.  Values are RELIABILITY_LRC and OUTAGE_LRC',
   EXPORTLIMITCONSTRAINTID varchar(20)  comment 'ID of the constraint that sets the Interconnector Export Limit',
   IMPORTLIMITCONSTRAINTID varchar(20)  comment 'ID of the constraint that sets the Interconnector Import Limit'
);

alter table MTPASA_INTERCONNECTORSOLUTION comment 'MTPASA_INTERCONNECTORSOLUTION is obsolete from 2017 End of Y';

alter table MTPASA_INTERCONNECTORSOLUTION
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, ENERGYBLOCK, DAY, LDCBLOCK, INTERCONNECTORID);

/*==============================================================*/
/* Index: MTPASA_INTERCONNECTORSOLN_NDX2                        */
/*==============================================================*/
create index MTPASA_INTERCONNECTORSOLN_NDX2 on MTPASA_INTERCONNECTORSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_INTERMITTENT_AVAIL                             */
/*==============================================================*/
create table MTPASA_INTERMITTENT_AVAIL
(
   TRADINGDATE          datetime not null  comment 'Trading Day for which this cluster availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date and Time when this cluster availability submission was loaded',
   CLUSTERID            varchar(20) not null  comment 'Unique Cluster Identifier for this cluster within the DUID',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ELEMENTS_UNAVAILABLE numeric(5,0)  comment 'Number of elements within this CLUSTERID (turbines for wind, or inverters for solar) that are not available for this TRADINGDATE. Value between 0 and the registered Number of Cluster Elements.Value = 0 means no elements unavailable',
   ELEMENTS_AVAILABLE   numeric(5,0)  comment 'Number of elements within this CLUSTERID (turbines for wind, or inverters for solar) that are available for this TRADINGDATE. Value between 0 and the registered Number of Cluster Elements. Value = 0 means no elements available'
);

alter table MTPASA_INTERMITTENT_AVAIL comment 'A submission of expected plant availability for intermittent';

alter table MTPASA_INTERMITTENT_AVAIL
   add primary key (TRADINGDATE, DUID, OFFERDATETIME, CLUSTERID);

/*==============================================================*/
/* Table: MTPASA_INTERMITTENT_LIMIT                             */
/*==============================================================*/
create table MTPASA_INTERMITTENT_LIMIT
(
   TRADINGDATE          datetime not null  comment 'Trading Day for which this unit availability submission applies',
   DUID                 varchar(20) not null  comment 'Unique Identifier of Dispatchable Unit',
   OFFERDATETIME        datetime not null  comment 'Date time file processed',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   UPPERMWLIMIT         numeric(6,0)  comment 'Maximum imposed MW limit. Value between 0 and the registered DUID Maximum Capacity.Value = -1 means no limit applies.',
   AUTHORISEDBYUSER     varchar(20)  comment 'User entering the unit availability submission',
   AUTHORISEDBYPARTICIPANTID varchar(20)  comment 'Participant entering the unit availability submission'
);

alter table MTPASA_INTERMITTENT_LIMIT comment 'A submission of expected maximum availability for intermitte';

alter table MTPASA_INTERMITTENT_LIMIT
   add primary key (TRADINGDATE, DUID, OFFERDATETIME);

/*==============================================================*/
/* Table: MTPASA_LOLPRESULT                                     */
/*==============================================================*/
create table MTPASA_LOLPRESULT
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always LOLP',
   DAY                  datetime not null  comment 'Day this result is for',
   REGIONID             varchar(20) not null  comment 'The unique region identifier',
   WORST_INTERVAL_PERIODID numeric(3,0)  comment 'The half hourly interval period with the highest LOLP, or highest region demand if LOLP = 0 for all intervals (1..48)',
   WORST_INTERVAL_DEMAND numeric(12,2)  comment 'The Abstract Operational Demand for the worst interval in this region (MW)',
   WORST_INTERVAL_INTGEN numeric(12,2)  comment 'The half hourly aggregate intermittent generation for the worst interval in this region (MW)',
   WORST_INTERVAL_DSP   numeric(12,2)  comment 'The half hourly aggregate demand side participation for the worst interval period in this region (MW)',
   LOSSOFLOADPROBABILITY numeric(8,5)  comment 'Loss of Load Probability for the worst interval in this region',
   LOSSOFLOADMAGNITUDE  varchar(20)  comment 'Loss of Load Magnitude for the worst interval in this region. Values are LOW, MEDIUM, HIGH',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_LOLPRESULT comment 'Results for Loss of Load Probability (LOLP) run per day';

alter table MTPASA_LOLPRESULT
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DAY, REGIONID);

/*==============================================================*/
/* Table: MTPASA_OFFERDATA                                      */
/*==============================================================*/
create table MTPASA_OFFERDATA
(
   PARTICIPANTID        varchar(20) not null  comment 'Unique participant identifier',
   OFFERDATETIME        datetime not null  comment 'Date time file processed',
   UNITID               varchar(20) not null  comment 'either duid or mnsp linkid',
   EFFECTIVEDATE        datetime not null  comment 'trade date when the offer becomes effective',
   ENERGY               numeric(9,0)  comment 'weekly energy constraint value',
   CAPACITY1            numeric(9,0)  comment 'capacity value day 1 (sunday)',
   CAPACITY2            numeric(9,0)  comment 'capacity value day 2 (monday)',
   CAPACITY3            numeric(9,0)  comment 'capacity value day 3 (tuesday)',
   CAPACITY4            numeric(9,0)  comment 'capacity value day 4 (wednesday)',
   CAPACITY5            numeric(9,0)  comment 'capacity value day 5 (thursday)',
   CAPACITY6            numeric(9,0)  comment 'capacity value day 6 (friday)',
   CAPACITY7            numeric(9,0)  comment 'capacity value day 7 (saturday)',
   LASTCHANGED          datetime  comment 'timestamp when record last changed',
   UNITSTATE1           varchar(20)  comment 'The unit state value for day 1 Sunday',
   UNITSTATE2           varchar(20)  comment 'The unit state value for day 2 Monday',
   UNITSTATE3           varchar(20)  comment 'The unit state value for day 3 Tuesday',
   UNITSTATE4           varchar(20)  comment 'The unit state value for 4 Wednesday',
   UNITSTATE5           varchar(20)  comment 'The unit state value for day 5 Thursday',
   UNITSTATE6           varchar(20)  comment 'The unit state value for day 6 Friday',
   UNITSTATE7           varchar(20)  comment 'The unit state value for day 7 Saturday',
   RECALLTIME1          numeric(4,0)  comment 'The recall time associated with the unit state for day 1 Sunday',
   RECALLTIME2          numeric(4,0)  comment 'The recall time associated with the unit state for day 2 Monday',
   RECALLTIME3          numeric(4,0)  comment 'The recall time associated with the unit state for day 3 Tuesday',
   RECALLTIME4          numeric(4,0)  comment 'The recall time associated with the unit state for day 4 Wednesday',
   RECALLTIME5          numeric(4,0)  comment 'The recall time associated with the unit state for day 5 Thursday',
   RECALLTIME6          numeric(4,0)  comment 'The recall time associated with the unit state for day 6 Friday',
   RECALLTIME7          numeric(4,0)  comment 'The recall time associated with the unit state for day 7 Saturday'
);

alter table MTPASA_OFFERDATA comment 'Participant submitted Offers for MTPASA process';

alter table MTPASA_OFFERDATA
   add primary key (PARTICIPANTID, OFFERDATETIME, UNITID, EFFECTIVEDATE);

/*==============================================================*/
/* Index: MTPASA_OFFERDATA_LCX                                  */
/*==============================================================*/
create index MTPASA_OFFERDATA_LCX on MTPASA_OFFERDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_OFFERFILETRK                                   */
/*==============================================================*/
create table MTPASA_OFFERFILETRK
(
   PARTICIPANTID        varchar(20) not null  comment 'Unique participant identifier',
   OFFERDATETIME        datetime not null  comment 'Date time file processed',
   FILENAME             varchar(200)  comment 'Submitted file name'
);

alter table MTPASA_OFFERFILETRK comment 'Participant submitted Offers for MTPASA process';

alter table MTPASA_OFFERFILETRK
   add primary key (PARTICIPANTID, OFFERDATETIME);

/*==============================================================*/
/* Table: MTPASA_REGIONAVAILABILITY                             */
/*==============================================================*/
create table MTPASA_REGIONAVAILABILITY
(
   PUBLISH_DATETIME     datetime not null  comment 'Date Time the report was published.',
   DAY                  datetime not null  comment 'Date on which the aggregation applies.',
   REGIONID             varchar(20) not null  comment 'NEM Region.',
   PASAAVAILABILITY_SCHEDULED numeric(12,0)  comment 'Aggregate of the offered PASA Availability for all Scheduled generators in this region.',
   LATEST_OFFER_DATETIME datetime  comment 'Date Time of the latest offer used in the aggregation for this region and date.',
   ENERGYUNCONSTRAINEDCAPACITY numeric(12,0)  comment 'Region energy unconstrained MW capacity',
   ENERGYCONSTRAINEDCAPACITY numeric(12,0)  comment 'Region energy constrained MW capacity',
   NONSCHEDULEDGENERATION numeric(12,2)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW)',
   DEMAND10             numeric(12,2)  comment '10% probability demand (ex non-scheduled demand)',
   DEMAND50             numeric(12,2)  comment '50% probability demand (ex non-scheduled demand)',
   ENERGYREQDEMAND10    numeric(12,2)  comment 'Total weekly operational as generated consumption (POE 10)',
   ENERGYREQDEMAND50    numeric(12,2)  comment 'Total weekly operational as generated consumption (POE 50)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DEMAND10MIN          numeric(12,2)  comment 'Minimum of the Operational Load as Generated (OPGEN) peaks that occur in all ref years for the P10 traces (MW).',
   DEMAND10MAX          numeric(12,2)  comment 'Maximum of the Operational Load as Generated (OPGEN) peaks that occur in all ref years for the P10 traces (MW).',
   DEMAND50MIN          numeric(12,2)  comment 'Minimum of the Operational Load as Generated (OPGEN) peaks that occur in all ref years for the P50 traces (MW).',
   DEMAND50MAX          numeric(12,2)  comment 'Maximum of the Operational Load as Generated (OPGEN) peaks that occur in all ref years for the P50 traces (MW).',
   CARRYOVERCAPACITY    numeric(12,0)  comment 'Split of the CARRYOVER component of aggregate capacity vs the currently reported capacity.'
);

alter table MTPASA_REGIONAVAILABILITY comment 'Stores the Region-aggregate offered PASA Availability of sch';

alter table MTPASA_REGIONAVAILABILITY
   add primary key (PUBLISH_DATETIME, DAY, REGIONID);

/*==============================================================*/
/* Table: MTPASA_REGIONAVAIL_TRK                                */
/*==============================================================*/
create table MTPASA_REGIONAVAIL_TRK
(
   PUBLISH_DATETIME     datetime not null  comment 'Date Time the report was published.',
   STARTDATE            datetime  comment 'First date of the report inclusive.',
   ENDDATE              datetime  comment 'Last date of the report inclusive.',
   LATEST_OFFER_DATETIME datetime  comment 'Date Time of the latest offer used in the report.'
);

alter table MTPASA_REGIONAVAIL_TRK comment 'The tracking table to assist in versioning of the region-agg';

alter table MTPASA_REGIONAVAIL_TRK
   add primary key (PUBLISH_DATETIME);

/*==============================================================*/
/* Table: MTPASA_REGIONITERATION                                */
/*==============================================================*/
create table MTPASA_REGIONITERATION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value is POE10 or POE50',
   AGGREGATION_PERIOD   varchar(20) not null  comment 'Period data is aggregated over. Values are YEAR',
   PERIOD_ENDING        datetime not null  comment 'Datetime of day at end of period (i.e. last day of year reported)',
   REGIONID             varchar(20) not null  comment 'The unique region identifier',
   USE_ITERATION_ID     numeric(5,0) not null  comment 'Iteration ID, only produced for iterations showing unserved energy>0',
   USE_ITERATION_EVENT_NUMBER numeric(12,2)  comment 'Number of half hours showing unserved energy over year, for iteration',
   USE_ITERATION_EVENT_AVERAGE numeric(12,2)  comment 'Average unserved energy event size for iteration over year (MW)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_REGIONITERATION comment 'Region results for Unserved Energy (USE)';

alter table MTPASA_REGIONITERATION
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, AGGREGATION_PERIOD, PERIOD_ENDING, REGIONID, USE_ITERATION_ID);

/*==============================================================*/
/* Table: MTPASA_REGIONRESULT                                   */
/*==============================================================*/
create table MTPASA_REGIONRESULT
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value is POE10',
   DAY                  datetime not null  comment 'Day this result is for',
   REGIONID             varchar(20) not null  comment 'The unique region identifier',
   PERIODID             numeric(3,0)  comment 'Half hourly period reported, selected as period of maximum NEM scheduled demand (calculated as maximum of scheduled demands, averaged across iterations and reference years)',
   DEMAND               numeric(12,2)  comment 'Demand value from selected half hourly interval (MW)',
   AGGREGATEINSTALLEDCAPACITY numeric(12,2)  comment 'The total installed capacity of all generation (MW)',
   NUMBEROFITERATIONS   numeric(12,2)  comment 'Total number of iterations and reference years performed',
   USE_NUMBEROFITERATIONS numeric(12,2)  comment 'Number of iterations and reference years with unserved energy>0',
   USE_MAX              numeric(12,2)  comment 'Maximum unserved energy, across iterations and reference years (MW)',
   USE_UPPERQUARTILE    numeric(12,2)  comment 'Upper quartile unserved energy, across iterations and reference years (MW)',
   USE_MEDIAN           numeric(12,2)  comment 'Median unserved energy, across iterations and reference years (MW)',
   USE_LOWERQUARTILE    numeric(12,2)  comment 'Lower quartile unserved energy, across iterations and reference years (MW)',
   USE_MIN              numeric(12,2)  comment 'Minimum unserved energy, across iterations and reference years (MW)',
   USE_AVERAGE          numeric(12,2)  comment 'Average unserved energy, across iterations and reference years (MW)',
   USE_EVENT_AVERAGE    numeric(12,2)  comment 'Average unserved energy event size, across iterations and reference years (MW)',
   TOTALSCHEDULEDGEN90  numeric(12,2)  comment 'The 90th percentile for scheduled generation across iterations and reference years (MW)',
   TOTALSCHEDULEDGEN50  numeric(12,2)  comment 'The 50th percentile for scheduled generation across iterations and reference years (MW)',
   TOTALSCHEDULEDGEN10  numeric(12,2)  comment 'The 10th percentile for scheduled generation across iterations and reference years (MW)',
   TOTALINTERMITTENTGEN90 numeric(12,2)  comment 'The 90th percentile for intermittent generation, across iterations and reference years (MW)',
   TOTALINTERMITTENTGEN50 numeric(12,2)  comment 'The 50th percentile for intermittent generation, across iterations and reference years (MW)',
   TOTALINTERMITTENTGEN10 numeric(12,2)  comment 'The 10th percentile for intermittent generation, across iterations and reference years (MW)',
   DEMANDSIDEPARTICIPATION90 numeric(12,2)  comment 'The 90th percentile for demand side participation, across iterations and reference years (MW)',
   DEMANDSIDEPARTICIPATION50 numeric(12,2)  comment 'The 50th percentile for demand side participation, across iterations and reference years (MW)',
   DEMANDSIDEPARTICIPATION10 numeric(12,2)  comment 'The 10th percentile for demand side participation, across iterations and reference years (MW)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   TOTALSEMISCHEDULEGEN90 numeric(12,2)  comment 'The 90% percentile for semi-scheduled generation across iterations and reference years (MW)',
   TOTALSEMISCHEDULEGEN50 numeric(12,2)  comment 'The 50% percentile for semi-scheduled generation across iterations and reference years (MW)',
   TOTALSEMISCHEDULEGEN10 numeric(12,2)  comment 'The 10% percentile for semi-scheduled generation across iterations and reference years (MW)',
   TOTALAVAILABLEGENMIN numeric(12,2)  comment 'Minimum available capacity, across iterations and reference years (MW).',
   TOTALAVAILABLEGEN10  numeric(12,2)  comment 'The 10% percentile for available capacity, across iterations and reference years (MW).',
   TOTALAVAILABLEGEN50  numeric(12,2)  comment 'The 50% percentile for available capacity, across iterations and reference years (MW).',
   TOTALAVAILABLEGEN90  numeric(12,2)  comment 'The 90% percentile for available capacity, across iterations and reference years (MW).',
   TOTALAVAILABLEGENMAX numeric(12,2)  comment 'Maximum available capacity, across iterations and reference years (MW).'
);

alter table MTPASA_REGIONRESULT comment 'Region results for interval of max demand per day.';

alter table MTPASA_REGIONRESULT
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, DAY, REGIONID);

/*==============================================================*/
/* Table: MTPASA_REGIONSOLUTION                                 */
/*==============================================================*/
create table MTPASA_REGIONSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins',
   RUN_NO               numeric(3,0) not null  comment 'Unique run id. Generated from the solution file caseid',
   ENERGYBLOCK          datetime not null  comment 'Sunday at start of the week for this solutions energy block. Generated from the solution file energy block',
   DAY                  datetime not null  comment 'Day this solution is for. Generated from the solution file periodid',
   LDCBLOCK             numeric(3,0) not null  comment 'LDC block this solution is for. Generated from the solution file periodid',
   REGIONID             varchar(10) not null  comment 'The unique region identifier',
   DEMAND10             numeric(12,2)  comment 'Input value for 10% probability demand',
   RESERVEREQ           numeric(12,2)  comment 'Not used from 21/05/2010. Prior to 21/05/2010: Input reserve requirement',
   CAPACITYREQ          numeric(12,2)  comment 'Not used from 21/05/2010. Prior to 21/05/2010: CA Demand + Reserve Requirement',
   ENERGYREQDEMAND10    numeric(12,2)  comment 'Sum of: (Region Period Demand - given Demand10)/PeriodLength(sum by Energy Block, entered in first period of energy block, GWh)',
   UNCONSTRAINEDCAPACITY numeric(12,0)  comment 'Region energy unconstrained MW capacity subject to network security constraints',
   CONSTRAINEDCAPACITY  numeric(12,0)  comment 'Region energy constrained MW capacity subject to energy and network security constraints',
   NETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Calculated in capacity adequacy evaluation: Export if > 0, Import if < 0.',
   SURPLUSCAPACITY      numeric(12,2)  comment 'Regional surplus capacity MW, +/- values indicate surplus/deficit capacity',
   SURPLUSRESERVE       numeric(12,2)  comment 'Not used from 21/05/2010. Prior to 21/05/2010: Regional reserve surplus. +/-0 values indicate surplus/deficit reserve',
   RESERVECONDITION     numeric(1,0)  comment 'The regional reserve condition: 0 = Adequate, 1 = LRC',
   MAXSURPLUSRESERVE    numeric(12,2)  comment 'The Maximum generation (MW) that could be withdrawn from this region without incurring a Low Reserve Condition.',
   MAXSPARECAPACITY     numeric(12,2)  comment 'The Maximum Spare Capacity evaluated for this region in this period. Calculated for each region in turn',
   LORCONDITION         numeric(1,0)  comment 'The LOR Condition determined from the Maximum Spare Capacity value: 0 = no condition, 1 = LOR1 condition, 2 = LOR2 condition, 3 = LOR3 condition',
   AGGREGATECAPACITYAVAILABLE numeric(12,2)  comment 'Sum of  MAXAVAIL quantities offered by all Scheduled Generators in a given Region for a given PERIODID.',
   AGGREGATESCHEDULEDLOAD numeric(12,2)  comment 'Sum of  MAXAVAIL quantities bid by of all Scheduled Loads in a given Region for a given PERIODID.',
   LASTCHANGED          datetime  comment 'Date the solution was loaded',
   AGGREGATEPASAAVAILABILITY numeric(12,0)  comment 'Sum of  PASAAVAILABILITY quantities offered by all Scheduled Generators in a given Region for a given PERIODID.',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run.  Values are RELIABILITY_LRC and OUTAGE_LRC',
   CALCULATEDLOR1LEVEL  numeric(16,6)  comment 'Region Reserve Level for LOR1 used. Can be static value or calculated value if an interconnector is a credible contingency',
   CALCULATEDLOR2LEVEL  numeric(16,6)  comment 'Region Reserve Level for LOR2 used. Can be static value or calculated value if an interconnector is a credible contingency',
   MSRNETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net interconnector flow from the region for this interval from the MSR assessment',
   LORNETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net interconnector flow from the region for this interval from the LOR assessment',
   TOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW).',
   DEMAND50             numeric(12,2)  comment 'Input value for 50% probability demand',
   DEMAND_AND_NONSCHEDGEN numeric(15,5)  comment 'Sum of Cleared Scheduled generation, imported generation (at the region boundary) and allowances made for non-scheduled generation (MW).',
   UIGF                 numeric(12,2)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW).',
   SEMISCHEDULEDCAPACITY numeric(12,2)  comment 'Aggregate Regional UIGF availability',
   LOR_SEMISCHEDULEDCAPACITY numeric(12,2)  comment 'Aggregate Regional UIGF availability for LOR',
   DEFICITRESERVE       numeric(16,6)  comment 'Regional reserve deficit (MW)',
   MAXUSEFULRESPONSE    numeric(12,2)  comment 'The Maximum market response (MW) needed for the region to eliminate a Low Reserve Condition (LRC)',
   MURNETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net interconnector flow from the region for this interval from the MRR assessment',
   LORTOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the LOR assessment',
   ENERGYREQDEMAND50    numeric(12,2)  comment 'Sum of: (Region Period Demand - given Demand50)/PeriodLength (sum by Energy Block, entered in first period of energy block, GWh)'
);

alter table MTPASA_REGIONSOLUTION comment 'MTPASA_CASESOLUTION is obsolete from 2017 End of Year DM4.27';

alter table MTPASA_REGIONSOLUTION
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, ENERGYBLOCK, DAY, LDCBLOCK, REGIONID);

/*==============================================================*/
/* Index: MTPASA_REGIONSOLUTION_NDX2                            */
/*==============================================================*/
create index MTPASA_REGIONSOLUTION_NDX2 on MTPASA_REGIONSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: MTPASA_REGIONSUMMARY                                  */
/*==============================================================*/
create table MTPASA_REGIONSUMMARY
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins.',
   RUN_NO               numeric(4,0) not null  comment 'Unique run id.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Always RELIABILITY',
   DEMAND_POE_TYPE      varchar(20) not null  comment 'Demand POE type used. Value are POE10, POE50',
   AGGREGATION_PERIOD   varchar(20) not null  comment 'Period data is aggregated over. Values are YEAR, MONTH',
   PERIOD_ENDING        datetime not null  comment 'Datetime of day at end of period (i.e. last day of month or year reported)',
   REGIONID             varchar(20) not null  comment 'The unique region identifier',
   NATIVEDEMAND         numeric(12,2)  comment 'Native demand calculated from Operational As Generated trace supplied by Energy Forecasting',
   USE_PERCENTILE10     numeric(12,2)  comment 'Unserved energy period amount at the 10th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE20     numeric(12,2)  comment 'Unserved energy period amount at the 20th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE30     numeric(12,2)  comment 'Unserved energy period amount at the 30th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE40     numeric(12,2)  comment 'Unserved energy period amount at the 40th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE50     numeric(12,2)  comment 'Unserved energy period amount at the 50th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE60     numeric(12,2)  comment 'Unserved energy period amount at the 60th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE70     numeric(12,2)  comment 'Unserved energy period amount at the 70th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE80     numeric(12,2)  comment 'Unserved energy period amount at the 80th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE90     numeric(12,2)  comment 'Unserved energy period amount at the 90th percentile of iterations and reference years (MWh)',
   USE_PERCENTILE100    numeric(12,2)  comment 'Unserved energy period amount at the 100th percentile of iterations and reference years (MWh)',
   USE_AVERAGE          numeric(12,2)  comment 'Average period unserved energy across iterations and reference years (MWh)',
   NUMBEROFITERATIONS   numeric(12,2)  comment 'Total number of iterations and reference years performed',
   USE_NUMBEROFITERATIONS numeric(12,2)  comment 'Number of iterations and reference years showing unserved energy',
   USE_EVENT_MAX        numeric(12,2)  comment 'Maximum unserved energy event size across all half hourly intervals and iterations and reference years that have unserved energy>0 (MW)',
   USE_EVENT_UPPERQUARTILE numeric(12,2)  comment 'Upper quartile unserved energy event size across all half hourly intervals and iterations and reference years that have unserved energy>0 (MW)',
   USE_EVENT_MEDIAN     numeric(12,2)  comment 'Median unserved energy event size across all half hourly intervals and iterations and reference years that have unserved energy>0 (MW)',
   USE_EVENT_LOWERQUARTILE numeric(12,2)  comment 'Lower quartile unserved energy event size across all half hourly intervals and iterations and reference years that have unserved energy>0 (MW)',
   USE_EVENT_MIN        numeric(12,2)  comment 'Minimum unserved energy event size across all half hourly intervals and iterations and reference years that have unserved energy>0 (MW)',
   WEIGHT               numeric(16,6)  comment 'Fixed Values of 0.696 for 50 POE and 0.304 for 10 POE.',
   USE_WEIGHTED_AVG     numeric(16,6)  comment 'Weighted average USE per region = (USE_AVERAGE_POE10/NATIVE_DEMAND_POE_10*WEIGHT_POE_10 + USE_AVERAGE_POE50/NATIVE_DEMAND_POE_50*WEIGHT_POE_50)*100',
   LRC                  numeric(12,2)  comment 'LRC Condition reported (Value=1) if USE_WEIGHTED_AVG >= 0.002% otherwise (Value=0)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table MTPASA_REGIONSUMMARY comment 'Region Results summary over aggregation periods.';

alter table MTPASA_REGIONSUMMARY
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, DEMAND_POE_TYPE, AGGREGATION_PERIOD, PERIOD_ENDING, REGIONID);

/*==============================================================*/
/* Table: MTPASA_RESERVELIMIT                                   */
/*==============================================================*/
create table MTPASA_RESERVELIMIT
(
   EFFECTIVEDATE        datetime not null  comment 'Trade date when the set of reserve requirements become effective',
   VERSION_DATETIME     datetime not null  comment 'Timestamp when the set of reserve requirements become effective',
   RESERVELIMITID       varchar(20) not null  comment 'MT PASA Reserve Requirement identifier',
   DESCRIPTION          varchar(200)  comment 'Description of this Reserve Requirement',
   RHS                  numeric(16,6)  comment 'Right hand side value for this Reserve requirement',
   LASTCHANGED          datetime  comment 'Timestamp the record was last modified.'
);

alter table MTPASA_RESERVELIMIT comment 'MT PASA input table defining a MT PASA Reserve Requirement w';

alter table MTPASA_RESERVELIMIT
   add primary key (EFFECTIVEDATE, VERSION_DATETIME, RESERVELIMITID);

/*==============================================================*/
/* Table: MTPASA_RESERVELIMITSOLUTION                           */
/*==============================================================*/
create table MTPASA_RESERVELIMITSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Date processing of the run begins',
   RUN_NO               numeric(3,0) not null  comment 'Unique run ID. Generated from the solution file Case ID.',
   RUNTYPE              varchar(20) not null  comment 'Type of run. Values are RELIABILITY_LRC and OUTAGE_LRC',
   ENERGYBLOCK          datetime not null  comment 'Sunday at start of the week for this solutions energy block. Generated from the solution file energy block.',
   DAY                  datetime not null  comment 'Day this solution is for. Generated from the solution file period id.',
   LDCBLOCK             numeric(3,0) not null  comment 'Load Duration Curve block this solution is for. Generated from the solution file period id.',
   RESERVELIMITID       varchar(20) not null  comment 'The unique identifier of the MT PASA LRC Reserve Requirement.',
   MARGINALVALUE        numeric(16,6)  comment 'Marginal Value of the Reserve Requirement Constraint. A non-zero value indicates that the reserve requirement is binding.',
   LASTCHANGED          datetime  comment 'Timestamp the record was last modified.'
);

alter table MTPASA_RESERVELIMITSOLUTION comment 'MTPASA_RESERVELIMITSOLUTION is obsolete from 2017 End of Yea';

alter table MTPASA_RESERVELIMITSOLUTION
   add primary key (RUN_DATETIME, RUN_NO, RUNTYPE, ENERGYBLOCK, DAY, LDCBLOCK, RESERVELIMITID);

/*==============================================================*/
/* Table: MTPASA_RESERVELIMIT_REGION                            */
/*==============================================================*/
create table MTPASA_RESERVELIMIT_REGION
(
   EFFECTIVEDATE        datetime not null  comment 'Trade date when the set of reserve requirements become effective',
   VERSION_DATETIME     datetime not null  comment 'Timestamp when the set of reserve requirements become effective',
   RESERVELIMITID       varchar(20) not null  comment 'MT PASA Reserve requirement identifier',
   REGIONID             varchar(20) not null  comment 'Region ID - identifier of a NEM region included in this requirement',
   COEF                 numeric(16,6)  comment 'Coefficient for the region in this reserve requirement',
   LASTCHANGED          datetime  comment 'Timestamp the record was last modified'
);

alter table MTPASA_RESERVELIMIT_REGION comment 'MT PASA input table to define the regions that are part of a';

alter table MTPASA_RESERVELIMIT_REGION
   add primary key (EFFECTIVEDATE, VERSION_DATETIME, RESERVELIMITID, REGIONID);

/*==============================================================*/
/* Table: MTPASA_RESERVELIMIT_SET                               */
/*==============================================================*/
create table MTPASA_RESERVELIMIT_SET
(
   EFFECTIVEDATE        datetime not null  comment 'Trade date when the set of reserve requirements become effective',
   VERSION_DATETIME     datetime not null  comment 'Timestamp when the set of reserve requirements become effective',
   RESERVELIMIT_SET_ID  varchar(20)  comment 'MT PASA LRC Reserve Requirement Set Identifier',
   DESCRIPTION          varchar(200)  comment 'Description of this set of Reserve Requirements',
   AUTHORISEDDATE       datetime  comment 'Date the requirement set was authorised',
   AUTHORISEDBY         varchar(20)  comment 'User authorising this requirement set',
   LASTCHANGED          datetime  comment 'Timestamp the record was last modified'
);

alter table MTPASA_RESERVELIMIT_SET comment 'MT PASA input table defining a set of MT PASA Reserve Requir';

alter table MTPASA_RESERVELIMIT_SET
   add primary key (EFFECTIVEDATE, VERSION_DATETIME);

/*==============================================================*/
/* Table: NEGATIVE_RESIDUE                                      */
/*==============================================================*/
create table NEGATIVE_RESIDUE
(
   SETTLEMENTDATE       datetime not null  comment 'Dispatch Interval',
   NRM_DATETIME         datetime not null  comment 'The time that residue information is processed',
   DIRECTIONAL_INTERCONNECTORID varchar(30) not null  comment 'Negative residue related direction interconnector id',
   NRM_ACTIVATED_FLAG   numeric(1,0)  comment 'Is 1 if negative residue process is on, else is 0',
   CUMUL_NEGRESIDUE_AMOUNT numeric(15,5)  comment 'Negative residue triggering amount',
   CUMUL_NEGRESIDUE_PREV_TI numeric(15,5)  comment 'Previous trading interval cumulative negative residue amount',
   NEGRESIDUE_CURRENT_TI numeric(15,5)  comment 'Current trading interval negative residue amount',
   NEGRESIDUE_PD_NEXT_TI numeric(15,5)  comment 'The cumulative negative residue for the next trading interval (PD)',
   PRICE_REVISION       varchar(30)  comment 'SubjectToReview, Indeterminate, Accepted or Rejected',
   PREDISPATCHSEQNO     varchar(20)  comment 'Predispatch sequence number',
   EVENT_ACTIVATED_DI   datetime  comment 'The starting DI when NRM event is active',
   EVENT_DEACTIVATED_DI datetime  comment 'The finishing DI when NRM event stops being active.',
   DI_NOTBINDING_COUNT  numeric(2,0)  comment 'Count of the number of DIs not binding by this constraint',
   DI_VIOLATED_COUNT    numeric(2,0)  comment 'Count of the number of DIs violated by this constraint',
   NRMCONSTRAINT_BLOCKED_FLAG numeric(1,0)  comment '1 if constraint is blocked, else 0'
);

alter table NEGATIVE_RESIDUE comment 'Shows the inputs provided to the Negative Residue Constraint';

alter table NEGATIVE_RESIDUE
   add primary key (SETTLEMENTDATE, NRM_DATETIME, DIRECTIONAL_INTERCONNECTORID);

/*==============================================================*/
/* Table: NETWORK_EQUIPMENTDETAIL                               */
/*==============================================================*/
create table NETWORK_EQUIPMENTDETAIL
(
   SUBSTATIONID         varchar(30) not null  comment 'ID uniquely identifying the substation this equipment is located at',
   EQUIPMENTTYPE        varchar(10) not null  comment 'The type of equipment. Valid values are:
             LINE = Line
             TRANS = Transformer
             CB = Circuit breaker
             ISOL = Isolator
             CAP = Capacitor
             REAC = Reactor
             UNIT = Unit',
   EQUIPMENTID          varchar(30) not null  comment 'A unique identifier for this type of equipment at this substation',
   VALIDFROM            datetime(3) not null  comment 'The date that this record is applies from (inclusive)',
   VALIDTO              datetime(3)  comment 'The date that this record applies until (exclusive)',
   VOLTAGE              varchar(20)  comment 'The voltage in KV for this equipment.
             Transformers may have multiple voltages defined.
             E.g. 132_110_33',
   DESCRIPTION          varchar(100)  comment 'A short description for this equipment.',
   LASTCHANGED          datetime(3)  comment 'The time that this record was last changed.',
   ELEMENTID            numeric(15,0) not null  comment 'Equipment element id'
);

alter table NETWORK_EQUIPMENTDETAIL comment 'NETWORK_EQUIPMENTDETAIL Provides details on equipment that m';

alter table NETWORK_EQUIPMENTDETAIL
   add primary key (ELEMENTID, SUBSTATIONID, EQUIPMENTTYPE, EQUIPMENTID, VALIDFROM);

/*==============================================================*/
/* Index: NETWORK_EQUIPMENTDETAIL_LCX                           */
/*==============================================================*/
create index NETWORK_EQUIPMENTDETAIL_LCX on NETWORK_EQUIPMENTDETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: NETWORK_OUTAGECONSTRAINTSET                           */
/*==============================================================*/
create table NETWORK_OUTAGECONSTRAINTSET
(
   OUTAGEID             numeric(15,0) not null  comment 'ID uniquely identifying the outage',
   GENCONSETID          varchar(50) not null  comment 'ID for the constraint set',
   STARTINTERVAL        datetime  comment 'The dispatch interval that this constraint applies from',
   ENDINTERVAL          datetime  comment 'The dispatch interval that this constraint applies until.'
);

alter table NETWORK_OUTAGECONSTRAINTSET comment 'NETWORK_OUTAGECONSTRAINTSET lists the Constraint Set or Sets';

alter table NETWORK_OUTAGECONSTRAINTSET
   add primary key (OUTAGEID, GENCONSETID);

/*==============================================================*/
/* Table: NETWORK_OUTAGEDETAIL                                  */
/*==============================================================*/
create table NETWORK_OUTAGEDETAIL
(
   OUTAGEID             numeric(15,0) not null  comment 'ID uniquely identifying the outage',
   SUBSTATIONID         varchar(30) not null  comment 'The substation this equipment is located at',
   EQUIPMENTTYPE        varchar(10) not null  comment 'The type of equipment. Valid values are:
             LINE = Line
             TRANS = Transformer
             CB = Circuit breaker
             ISOL = Isolator
             CAP = Capacitor
             REAC = Reactor
             UNIT = Unit',
   EQUIPMENTID          varchar(30) not null  comment 'A unique identifier for this equipment at this substation, and based on its type',
   STARTTIME            datetime not null  comment 'The planned starting date and time of the outage',
   ENDTIME              datetime  comment 'The planned ending date and time of the outage',
   SUBMITTEDDATE        datetime  comment 'The date and time this outage was first submitted',
   OUTAGESTATUSCODE     varchar(10)  comment 'A code representing the status of the outage.
             The OUTAGESTATUSCODE table will store a detailed description of each code.',
   RESUBMITREASON       varchar(50)  comment 'Changes to an outage key details may require the outage to be resubmitted.
             A new outage id will then be allocated and the outage will be reassessed.
             This field will detail the reason for the change.',
   RESUBMITOUTAGEID     numeric(15,0)  comment 'The new outage id created from a resubmit.',
   RECALLTIMEDAY        numeric(10,0)  comment 'The recall time in minutes during the day',
   RECALLTIMENIGHT      numeric(10,0)  comment 'The recall time in minutes during the night',
   LASTCHANGED          datetime(3)  comment 'The time that this record was last changed',
   REASON               varchar(100)  comment 'The reason provided by the asset owner for this outage',
   ISSECONDARY          numeric(1,0)  comment '1 = The outage is for a secondary piece of equipment that has an associated constraint set. The transmission equipment is still in service. 0 = The outage is for the transmission equipment',
   ACTUAL_STARTTIME     datetime  comment 'The actual starting date/time of the outage',
   ACTUAL_ENDTIME       datetime  comment 'The actual ending date/time of the outage',
   COMPANYREFCODE       varchar(20)  comment 'The asset owners reference code for this outage',
   ELEMENTID            numeric(15,0) not null  comment 'Equipment element id'
);

alter table NETWORK_OUTAGEDETAIL comment 'Lists asset owners planned outages for transmission equipmen';

alter table NETWORK_OUTAGEDETAIL
   add primary key (OUTAGEID, ELEMENTID, SUBSTATIONID, EQUIPMENTTYPE, EQUIPMENTID, STARTTIME);

/*==============================================================*/
/* Index: NETWORK_OUTAGEDETAIL_LCX                              */
/*==============================================================*/
create index NETWORK_OUTAGEDETAIL_LCX on NETWORK_OUTAGEDETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: NETWORK_OUTAGESTATUSCODE                              */
/*==============================================================*/
create table NETWORK_OUTAGESTATUSCODE
(
   OUTAGESTATUSCODE     varchar(10) not null  comment 'A code representing the status of an outage',
   DESCRIPTION          varchar(100)  comment 'A description of the status code',
   LASTCHANGED          datetime  comment 'The time that this record was last changed'
);

alter table NETWORK_OUTAGESTATUSCODE comment 'NETWORK_OUTAGESTATUSCODE describes the different outage stat';

alter table NETWORK_OUTAGESTATUSCODE
   add primary key (OUTAGESTATUSCODE);

/*==============================================================*/
/* Table: NETWORK_RATING                                        */
/*==============================================================*/
create table NETWORK_RATING
(
   SPD_ID               varchar(21) not null  comment 'ID defining this data source for use in constraints',
   VALIDFROM            datetime not null  comment 'The date that this record is applies from (inclusive)',
   VALIDTO              datetime  comment 'The date that this record applies until (exclusive)',
   REGIONID             varchar(10)  comment 'The region that this rating is for',
   SUBSTATIONID         varchar(30)  comment 'The substation the equipment is located at',
   EQUIPMENTTYPE        varchar(10)  comment 'The type of equipment. Valid values are:
             LINE = Line
             TRANS = Transformer
             CB = Circuit breaker
             ISOL = Isolator
             CAP = Capacitor
             REAC = Reactor
             UNIT = Unit',
   EQUIPMENTID          varchar(30)  comment 'A unique identifier for this equipment at this substation, and based on its type',
   RATINGLEVEL          varchar(10)  comment 'The rating level of the value used, one of:
             NORM = Continuous rating value. Applied under pre-contingent conditions.
             EMER = Continuous rating value. Applied under pre-contingent conditions
             LDSH = Load Shedding',
   ISDYNAMIC            numeric(1,0)  comment 'One of:
             1 = Normally uses dynamic ratings
             0 = No dynamic ratings, static ratings are used',
   LASTCHANGED          datetime  comment 'The time that this record was last changed'
);

alter table NETWORK_RATING comment 'NETWORK_RATING defines a list of the equipment ratings that ';

alter table NETWORK_RATING
   add primary key (SPD_ID, VALIDFROM);

/*==============================================================*/
/* Index: NETWORK_RATING_LCX                                    */
/*==============================================================*/
create index NETWORK_RATING_LCX on NETWORK_RATING
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: NETWORK_REALTIMERATING                                */
/*==============================================================*/
create table NETWORK_REALTIMERATING
(
   SETTLEMENTDATE       datetime not null  comment 'The dispatch interval the rating applies to',
   SPD_ID               varchar(21) not null  comment 'ID defining this data source for use in constraints',
   RATINGVALUE          numeric(16,6) not null  comment 'The defined equipment rating value in MVA'
);

alter table NETWORK_REALTIMERATING comment 'The NETWORK_REALTIMERATING table shows the equipment rating ';

alter table NETWORK_REALTIMERATING
   add primary key (SETTLEMENTDATE, SPD_ID);

/*==============================================================*/
/* Table: NETWORK_STATICRATING                                  */
/*==============================================================*/
create table NETWORK_STATICRATING
(
   SUBSTATIONID         varchar(30) not null  comment 'The substation the equipment is located at',
   EQUIPMENTTYPE        varchar(10) not null  comment 'The type of equipment. Valid values are:
             LINE = Line
             TRANS = Transformer
             CB = Circuit breaker
             ISOL = Isolator
             CAP = Capacitor
             REAC = Reactor
             UNIT = Unit',
   EQUIPMENTID          varchar(30) not null  comment 'A unique identifier for this type of equipment at this substation',
   RATINGLEVEL          varchar(10) not null  comment 'The rating level of the value used, one of:
             NORM = Continuous rating value. Applied under pre-contingent conditions.
             EMER = Continuous rating value. Applied under pre-contingent conditions
             LDSH = Load Shedding',
   APPLICATIONID        varchar(20) not null  comment 'The applicationid which defines the application timeframes of this rating.',
   VALIDFROM            datetime not null  comment 'The date that this record is applies from (inclusive)',
   VALIDTO              datetime  comment 'The date that this record applies until (exclusive)',
   RATINGVALUE          numeric(16,6)  comment 'The rating value in MVA that applies. This may be positive or negative depending on which side of the nominal MW flow direction the rating value applies.
             Flow into a transmission device is positive, flow out of the device is negative.',
   LASTCHANGED          datetime  comment 'The time that this record was last changed.'
);

alter table NETWORK_STATICRATING comment 'NETWORK_STATICRATING lists the static rating values that wil';

alter table NETWORK_STATICRATING
   add primary key (SUBSTATIONID, EQUIPMENTTYPE, EQUIPMENTID, RATINGLEVEL, APPLICATIONID, VALIDFROM);

/*==============================================================*/
/* Index: NETWORK_STATICRATING_LCX                              */
/*==============================================================*/
create index NETWORK_STATICRATING_LCX on NETWORK_STATICRATING
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: NETWORK_SUBSTATIONDETAIL                              */
/*==============================================================*/
create table NETWORK_SUBSTATIONDETAIL
(
   SUBSTATIONID         varchar(30) not null  comment 'ID uniquely identifying this substation',
   VALIDFROM            datetime(3) not null  comment 'The record is valid from this date (inclusive)',
   VALIDTO              datetime(3)  comment 'The record is valid up until this date (exclusive)',
   DESCRIPTION          varchar(100)  comment 'Description of the substation',
   REGIONID             varchar(10)  comment 'The NEM region the substation is in',
   OWNERID              varchar(30)  comment 'The TNSP who is responsible for this substation',
   LASTCHANGED          datetime(3)  comment 'The time that this record was last changed.'
);

alter table NETWORK_SUBSTATIONDETAIL comment 'NETWORK_SUBSTATIONDETAIL sets out the attributes of sub-stat';

alter table NETWORK_SUBSTATIONDETAIL
   add primary key (SUBSTATIONID, VALIDFROM);

/*==============================================================*/
/* Index: NETWORK_SUBSTATIONDETAIL_LCX                          */
/*==============================================================*/
create index NETWORK_SUBSTATIONDETAIL_LCX on NETWORK_SUBSTATIONDETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OARTRACK                                              */
/*==============================================================*/
create table OARTRACK
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   OFFERDATE            datetime not null  comment 'Date file offered',
   VERSIONNO            numeric(3,0) not null  comment 'Version no for this offer date',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   FILENAME             varchar(40)  comment 'Load file name',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   AUTHORISEDBY         varchar(10)  comment 'User authorising record',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table OARTRACK comment 'OARTRACK shows an audit trail of bids for a particular settl';

alter table OARTRACK
   add primary key (SETTLEMENTDATE, OFFERDATE, VERSIONNO, PARTICIPANTID);

/*==============================================================*/
/* Index: OARTRACK_NDX2                                         */
/*==============================================================*/
create index OARTRACK_NDX2 on OARTRACK
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: OARTRACK_LCX                                          */
/*==============================================================*/
create index OARTRACK_LCX on OARTRACK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERAGCDATA                                          */
/*==============================================================*/
create table OFFERAGCDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date of offer',
   VERSIONNO            numeric(3,0) not null  comment 'Version no of record',
   AVAILABILITY         numeric(4,0)  comment 'Availability flag (0 or 1)',
   UPPERLIMIT           numeric(4,0)  comment 'Upper control limit. This is used by SPD.',
   LOWERLIMIT           numeric(4,0)  comment 'Lower control limit MW. This is used by SPD.',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'Authorised by',
   FILENAME             varchar(40)  comment 'Name of reoffer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number',
   AGCUP                numeric(3,0)  comment 'AGC Ramp Rate Up. This is used by SPD.',
   AGCDOWN              numeric(3,0)  comment 'AGC Ramp Rate Down. This is used by SPD.'
);

alter table OFFERAGCDATA comment 'OFFERAGCDATA shows availability reoffers of Automatic Genera';

alter table OFFERAGCDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERAGCDATA_NDX2                                     */
/*==============================================================*/
create index OFFERAGCDATA_NDX2 on OFFERAGCDATA
(
   CONTRACTID
);

/*==============================================================*/
/* Index: OFFERAGCDATA_LCX                                      */
/*==============================================================*/
create index OFFERAGCDATA_LCX on OFFERAGCDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERASTRK                                            */
/*==============================================================*/
create table OFFERASTRK
(
   EFFECTIVEDATE        datetime not null  comment 'Market day starting at 4:00 am',
   VERSIONNO            numeric(3,0) not null  comment 'Version of the offer for that date',
   PARTICIPANTID        varchar(10) not null  comment 'Participant ID',
   FILENAME             varchar(40)  comment 'Submitted file name.',
   LASTCHANGED          datetime  comment 'Last changed date and time.'
);

alter table OFFERASTRK comment 'OFFERASTRK tracks successfully acknowledged ancillary servic';

alter table OFFERASTRK
   add primary key (EFFECTIVEDATE, VERSIONNO, PARTICIPANTID);

/*==============================================================*/
/* Index: OFFERASTRK_LCX                                        */
/*==============================================================*/
create index OFFERASTRK_LCX on OFFERASTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERFILETRK                                          */
/*==============================================================*/
create table OFFERFILETRK
(
   OFFERDATE            datetime not null  comment 'Date file offered',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   STATUS               varchar(10)  comment 'Load status [SUCCESSFUL/CORRUPT]',
   ACKFILENAME          varchar(40)  comment 'Acknowledge file name',
   ENDDATE              datetime  comment 'Not used',
   FILENAME             varchar(40) not null  comment 'Load file name',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table OFFERFILETRK comment 'OFFERFILETRK shows an audit trail of all bid files submitted';

alter table OFFERFILETRK
   add primary key (OFFERDATE, FILENAME, PARTICIPANTID);

/*==============================================================*/
/* Index: OFFERFILETRK_NDX2                                     */
/*==============================================================*/
create index OFFERFILETRK_NDX2 on OFFERFILETRK
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: OFFERFILETRK_LCX                                      */
/*==============================================================*/
create index OFFERFILETRK_LCX on OFFERFILETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERGOVDATA                                          */
/*==============================================================*/
create table OFFERGOVDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract Version No.',
   EFFECTIVEDATE        datetime not null  comment 'Effective Date of Re-Offer',
   VERSIONNO            numeric(3,0) not null  comment 'Version No. of Re-Offer',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number',
   SEC6AVAILUP          numeric(6,0)  comment 'Availability for 6 Second Raise (0 or 1. ''0''= unavailable, ''1'' = available)',
   SEC6AVAILDOWN        numeric(6,0)  comment 'Availability for 6 Second Lower (0 or 1)',
   SEC60AVAILUP         numeric(6,0)  comment 'Availability for 60 Second Raise (0 or 1)',
   SEC60AVAILDOWN       numeric(6,0)  comment 'Availability for 60 Second Lower (0 or 1)',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   FILENAME             varchar(40)  comment 'File name of Re-Offer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table OFFERGOVDATA comment 'OFFERGOVDATA sets out reoffers of governor (6 and 60 second ';

alter table OFFERGOVDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERGOVDATA_NDX2                                     */
/*==============================================================*/
create index OFFERGOVDATA_NDX2 on OFFERGOVDATA
(
   CONTRACTID
);

/*==============================================================*/
/* Index: OFFERGOVDATA_LCX                                      */
/*==============================================================*/
create index OFFERGOVDATA_LCX on OFFERGOVDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERLSHEDDATA                                        */
/*==============================================================*/
create table OFFERLSHEDDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date of reoffer',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of reoffer',
   AVAILABLELOAD        numeric(4,0)  comment 'Available load',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'Authorised by',
   FILENAME             varchar(40)  comment 'Name of reoffer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number'
);

alter table OFFERLSHEDDATA comment 'OFFERLSHEDDATA shows reoffers of load shed including availab';

alter table OFFERLSHEDDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERLSHEDDATA_LCX                                    */
/*==============================================================*/
create index OFFERLSHEDDATA_LCX on OFFERLSHEDDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERRESTARTDATA                                      */
/*==============================================================*/
create table OFFERRESTARTDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract identifier',
   OFFERDATE            datetime not null  comment 'Effective date of contract',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of contract',
   AVAILABILITY         varchar(3)  comment 'Available load',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'Authorised by',
   FILENAME             varchar(40)  comment 'Name of reoffer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number'
);

alter table OFFERRESTARTDATA comment 'OFFERRESTARTDATA sets out reoffers of system restart availab';

alter table OFFERRESTARTDATA
   add primary key (CONTRACTID, OFFERDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERRESTARTDATA_LCX                                  */
/*==============================================================*/
create index OFFERRESTARTDATA_LCX on OFFERRESTARTDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERRPOWERDATA                                       */
/*==============================================================*/
create table OFFERRPOWERDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract Version No.',
   EFFECTIVEDATE        datetime not null  comment 'Contract Version No.',
   VERSIONNO            numeric(3,0) not null  comment 'Version No. of Re-Offer',
   PERIODID             numeric(3,0) not null  comment 'Market trading interval',
   AVAILABILITY         numeric(3,0)  comment 'Availability of service',
   MTA                  numeric(6,0)  comment 'Reactive Power Absorption Capability (MVar)',
   MTG                  numeric(6,0)  comment 'Reactive Power Generation Capability (MVar)',
   AUTHORISEDDATE       datetime  comment 'Date Contract was Authorised',
   AUTHORISEDBY         varchar(15)  comment 'User Name',
   FILENAME             varchar(40)  comment 'File name of Re-Offer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table OFFERRPOWERDATA comment 'OFFERRPOWERDATA shows reoffers of reactive power capability ';

alter table OFFERRPOWERDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERRPOWERDATA_NDX2                                  */
/*==============================================================*/
create index OFFERRPOWERDATA_NDX2 on OFFERRPOWERDATA
(
   CONTRACTID
);

/*==============================================================*/
/* Index: OFFERRPOWERDATA_LCX                                   */
/*==============================================================*/
create index OFFERRPOWERDATA_LCX on OFFERRPOWERDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERULOADINGDATA                                     */
/*==============================================================*/
create table OFFERULOADINGDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract identifier',
   EFFECTIVEDATE        datetime not null  comment 'Effective date of contract',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of contract',
   AVAILABLELOAD        numeric(4,0)  comment 'Available load',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'Authorised by',
   FILENAME             varchar(40)  comment 'Name of reoffer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number'
);

alter table OFFERULOADINGDATA comment 'OFFERULOADINGDATA shows reoffers of rapid unit loading capab';

alter table OFFERULOADINGDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERULOADINGDATA_NDX2                                */
/*==============================================================*/
create index OFFERULOADINGDATA_NDX2 on OFFERULOADINGDATA
(
   CONTRACTID
);

/*==============================================================*/
/* Index: OFFERULOADINGDATA_LCX                                 */
/*==============================================================*/
create index OFFERULOADINGDATA_LCX on OFFERULOADINGDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OFFERUNLOADINGDATA                                    */
/*==============================================================*/
create table OFFERUNLOADINGDATA
(
   CONTRACTID           varchar(10) not null  comment 'Contract identifier',
   EFFECTIVEDATE        datetime not null  comment 'Market date of reoffer',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of reoffer',
   AVAILABLELOAD        numeric(4,0)  comment 'Available load',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(15)  comment 'Authorised by',
   FILENAME             varchar(40)  comment 'Name of reoffer file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PERIODID             numeric(3,0) not null  comment 'Market day trading interval number'
);

alter table OFFERUNLOADINGDATA comment 'OFFERUNLOADINGDATA shows reoffers of rapid unit unloading ca';

alter table OFFERUNLOADINGDATA
   add primary key (CONTRACTID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: OFFERUNLOADINGDATA_NDX2                               */
/*==============================================================*/
create index OFFERUNLOADINGDATA_NDX2 on OFFERUNLOADINGDATA
(
   CONTRACTID
);

/*==============================================================*/
/* Index: OFFERUNLOADINGDATA_LCX                                */
/*==============================================================*/
create index OFFERUNLOADINGDATA_LCX on OFFERUNLOADINGDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: OVERRIDERRP                                           */
/*==============================================================*/
create table OVERRIDERRP
(
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   STARTDATE            datetime not null  comment 'Starting date of override',
   STARTPERIOD          numeric(3,0) not null  comment 'Starting period of override',
   ENDDATE              datetime  comment 'Termination date of override',
   ENDPERIOD            numeric(3,0)  comment 'Terminate period of override',
   RRP                  numeric(15,0)  comment 'Dispatch Price',
   DESCRIPTION          varchar(128)  comment 'Description of reason for override',
   AUTHORISESTART       varchar(15)  comment 'Authorise Start of Override',
   AUTHORISEEND         varchar(15)  comment 'Authorise End of Override',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table OVERRIDERRP comment 'OVERRIDERRP shows details of override price periods.';

alter table OVERRIDERRP
   add primary key (STARTDATE, STARTPERIOD, REGIONID);

/*==============================================================*/
/* Index: OVERRIDERRP_LCX                                       */
/*==============================================================*/
create index OVERRIDERRP_LCX on OVERRIDERRP
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: P5MIN_BLOCKEDCONSTRAINT                               */
/*==============================================================*/
create table P5MIN_BLOCKEDCONSTRAINT
(
   RUN_DATETIME         datetime not null  comment '5-minute Predispatch Run',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint identifier (synonymous with GenConID)'
);

alter table P5MIN_BLOCKEDCONSTRAINT comment 'P5MIN Blocked Constraints lists any constraints that were bl';

alter table P5MIN_BLOCKEDCONSTRAINT
   add primary key (RUN_DATETIME, CONSTRAINTID);

/*==============================================================*/
/* Table: P5MIN_CASESOLUTION                                    */
/*==============================================================*/
create table P5MIN_CASESOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   STARTINTERVAL_DATETIME varchar(20)  comment 'Date and Time of first interval in study',
   TOTALOBJECTIVE       numeric(27,10)  comment 'The Objective function from the LP',
   NONPHYSICALLOSSES    numeric(1,0)  comment 'Flag to indicate non-physical losses occurred in this study',
   TOTALAREAGENVIOLATION numeric(15,5)  comment 'Sum of Regional Energy balance violations',
   TOTALINTERCONNECTORVIOLATION numeric(15,5)  comment 'Sum of Interconnector violations of standing data limits',
   TOTALGENERICVIOLATION numeric(15,5)  comment 'Sum of Generic Constraint violations',
   TOTALRAMPRATEVIOLATION numeric(15,5)  comment 'Sum of Unit Ramp Rate violations',
   TOTALUNITMWCAPACITYVIOLATION numeric(15,5)  comment 'Sum of unit capacity violations',
   TOTAL5MINVIOLATION   numeric(15,5)  comment 'Sum of regional 5 min FCAS violations',
   TOTALREGVIOLATION    numeric(15,5)  comment 'Sum of regional regulation FCAS violations',
   TOTAL6SECVIOLATION   numeric(15,5)  comment 'Sum of regional 6 sec FCAS violations',
   TOTAL60SECVIOLATION  numeric(15,5)  comment 'Sum of regional 60 sec FCAS violations',
   TOTALENERGYCONSTRVIOLATION numeric(15,5)  comment 'Sum of unit energy constrained violations',
   TOTALENERGYOFFERVIOLATION numeric(15,5)  comment 'Sum of unit offer violations',
   TOTALASPROFILEVIOLATION numeric(15,5)  comment 'Sum of unit FCAS profile offer violations',
   TOTALFASTSTARTVIOLATION numeric(15,5)  comment 'Sum of unit Fast start profile violations',
   LASTCHANGED          datetime  comment 'Last changed date and time of this record',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this Predispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run. This field has a default value of 0 and is not nullable'
);

alter table P5MIN_CASESOLUTION comment 'The five-minute predispatch (P5Min) is a MMS system providin';

alter table P5MIN_CASESOLUTION
   add primary key (RUN_DATETIME);

/*==============================================================*/
/* Index: P5MIN_CASESOLUTION_LCX                                */
/*==============================================================*/
create index P5MIN_CASESOLUTION_LCX on P5MIN_CASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: P5MIN_CONSTRAINTSOLUTION                              */
/*==============================================================*/
create table P5MIN_CONSTRAINTSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint identifier (synonymous with GenConID)',
   RHS                  numeric(15,5)  comment 'Right Hand Side value in the capacity evaluation',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal cost of constraint (>0 if binding)',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Amount of Violation (>0 if  violating)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DUID                 varchar(20)  comment 'DUID to which the Constraint is confidential. Null denotes non-confidential',
   GENCONID_EFFECTIVEDATE datetime  comment 'Effective date of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   GENCONID_VERSIONNO   numeric(22,0)  comment 'Version number of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   LHS                  numeric(15,5)  comment 'Aggregation of the constraints LHS term solution values',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run(INTERVENTION=1). In the event there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0)'
);

alter table P5MIN_CONSTRAINTSOLUTION comment 'The Five-Minute Pre-Dispatch (P5Min) is a MMS system providi';

alter table P5MIN_CONSTRAINTSOLUTION
   add primary key (RUN_DATETIME, CONSTRAINTID, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: P5MIN_CONSTRAINTSOLUTION_LCX                          */
/*==============================================================*/
create index P5MIN_CONSTRAINTSOLUTION_LCX on P5MIN_CONSTRAINTSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: P5MIN_FCAS_REQUIREMENT                                */
/*==============================================================*/
create table P5MIN_FCAS_REQUIREMENT
(
   RUN_DATETIME         datetime not null  comment 'First interval of the 5-minute Predispatch case',
   INTERVAL_DATETIME    datetime not null  comment 'Datetime of the 5-minute Predispatch interval',
   CONSTRAINTID         varchar(20) not null  comment 'ConstraintID Join to table GenConData',
   REGIONID             varchar(20) not null  comment 'Region Identifier',
   BIDTYPE              varchar(10) not null  comment 'DUID offered type',
   INTERVENTION         numeric(2,0)  comment 'Intervention flag',
   CONSTRAINT_EFFECTIVEDATE datetime  comment 'Constraint EffectiveDate Join to table GenConData',
   CONSTRAINT_VERSIONNO numeric(3,0)  comment 'Constraint Version number Join to table GenConData',
   MARGINALVALUE        numeric(18,8)  comment 'Marginal $ value for energy',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint for this service, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, after the regulation/contingency split',
   ESTIMATED_CMPF       numeric(18,8)  comment 'An estimated value for the constraint CMPF, based on 5- minute Predispatch data',
   ESTIMATED_CRMPF      numeric(18,8)  comment 'An estimated value for the constraint CRMPF, based on 5-minute Predispatch data',
   RECOVERY_FACTOR_CMPF numeric(18,8)  comment 'Estimated recovery factor for CMPF based recovery',
   RECOVERY_FACTOR_CRMPF numeric(18,8)  comment 'Estimated recovery for CRMPF based recovery',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table P5MIN_FCAS_REQUIREMENT comment '5-minute Predispatch constraint tracking for Regional FCAS r';

alter table P5MIN_FCAS_REQUIREMENT
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, CONSTRAINTID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Table: P5MIN_FCAS_REQ_CONSTRAINT                             */
/*==============================================================*/
create table P5MIN_FCAS_REQ_CONSTRAINT
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 5 minute predispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The 5 minute predispatch case run number that has triggers the constraint FCAS processor run',
   INTERVAL_DATETIME    datetime not null  comment 'The 5 minute interval date and time of the 5 minute predispatch interval that was processed by the constraint FCAS processor',
   CONSTRAINTID         varchar(20) not null  comment 'ConstraintID join to table GenConData',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   BIDTYPE              varchar(10) not null  comment 'DUID offered type',
   LHS                  numeric(15,5)  comment 'Constraints summed LHS - aggregate LHS Solution values from the physical run from the P5MIN_CONSTRAINTSOLUTION table',
   RHS                  numeric(15,5)  comment 'Constraints RHS value used in the solution - may be either dynamic (calculated) or static from the physical run from the P5MIN_CONSTRAINTSOLUTION table',
   MARGINALVALUE        numeric(15,5)  comment 'Shadow price of constraint from the P5MIN_CONSTRAINTSOLUTION table from the physical run.',
   RRP                  numeric(15,5)  comment 'Bid type prices for the region coming from the pricing run of the P5MIN_REGIONSOLUTION table',
   REGIONAL_ENABLEMENT  numeric(15,5)  comment 'The dispatched MW for the bid type inside the region from the physical run of the P5MIN_REGIONSOLUTION table',
   CONSTRAINT_ENABLEMENT numeric(15,5)  comment 'MW enabled for this bid type within the constraint',
   REGION_BASE_COST     numeric(18,8)  comment 'The regional payment allocated to the constraint for the interval pro- rated based on marginal value ratios over the binding constraints for that service in that region (this is an intermediate calculation to get to the base cost)',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, after the regulation/contingency split',
   P_REGULATION         numeric(18,8)  comment 'The adjusted marginal value of the constraint for FPP recovery (blank for constraints without REG terms)'
);

alter table P5MIN_FCAS_REQ_CONSTRAINT comment 'The constraint level FCAS cost / price details for constrain';

alter table P5MIN_FCAS_REQ_CONSTRAINT
   add primary key (RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Table: P5MIN_FCAS_REQ_RUN                                    */
/*==============================================================*/
create table P5MIN_FCAS_REQ_RUN
(
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 5 minute predispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The 5 minute predispatch case run number that has triggers the constraint FCAS processor run',
   LASTCHANGED          datetime  comment 'The last time the constraint FCAS processor was executed for this case run time.'
);

alter table P5MIN_FCAS_REQ_RUN comment 'The constraint FCAS processor run details. This enhanced out';

alter table P5MIN_FCAS_REQ_RUN
   add primary key (RUN_DATETIME, RUNNO);

/*==============================================================*/
/* Table: P5MIN_INTERCONNECTORSOLN                              */
/*==============================================================*/
create table P5MIN_INTERCONNECTORSOLN
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector identifier',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   METEREDMWFLOW        numeric(15,5)  comment 'SCADA MW Flow measured at Run start. For periods subsequent to the first period of a P5MIN run, this value represents the cleared target for the previous period of that P5MIN run.',
   MWFLOW               numeric(15,5)  comment 'Cleared Interconnector loading level (MW)',
   MWLOSSES             numeric(15,5)  comment 'Interconnector Losses at cleared flow',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal cost of Interconnector standing data limits (if binding)',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Violation of Interconnector standing data limits',
   MNSP                 numeric(1,0)  comment 'Flag indicating MNSP registration',
   EXPORTLIMIT          numeric(15,5)  comment 'Calculated Interconnector limit of exporting energy on the basis of invoked constraints and static interconnector export limit',
   IMPORTLIMIT          numeric(15,5)  comment 'Calculated Interconnector limit of importing energy on the basis of invoked constraints and static interconnector import limit. Note unlike the input interconnector import limit this is a directional quantity and should be defined with respect to the interconnector flow.',
   MARGINALLOSS         numeric(15,5)  comment 'Marginal loss factor at the cleared flow',
   EXPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the export limit',
   IMPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the import limit',
   FCASEXPORTLIMIT      numeric(15,5)  comment 'Calculated export limit applying to energy + Frequency Controlled Ancillary Services.',
   FCASIMPORTLIMIT      numeric(15,5)  comment 'Calculated import limit applying to energy + Frequency Controlled Ancillary Services.',
   LASTCHANGED          datetime  comment 'Last changed date of this record',
   LOCAL_PRICE_ADJUSTMENT_EXPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Export (Factor >= 0)',
   LOCALLY_CONSTRAINED_EXPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Export: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LOCAL_PRICE_ADJUSTMENT_IMPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Import (Factor >= 0)',
   LOCALLY_CONSTRAINED_IMPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Import: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0)'
);

alter table P5MIN_INTERCONNECTORSOLN comment 'The five-minute predispatch (P5Min) is a MMS system providin';

alter table P5MIN_INTERCONNECTORSOLN
   add primary key (RUN_DATETIME, INTERCONNECTORID, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: P5MIN_INTERCONNECTORSOLN_LCX                          */
/*==============================================================*/
create index P5MIN_INTERCONNECTORSOLN_LCX on P5MIN_INTERCONNECTORSOLN
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: P5MIN_INTERMITTENT_FCST_TRK                           */
/*==============================================================*/
create table P5MIN_INTERMITTENT_FCST_TRK
(
   RUN_DATETIME         datetime not null  comment 'Datetime (interval ending) of the 5-Minute Pre-dispatch run.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier, tracks to INTERMITTENT_GEN_FCST_P5_RUN.DUID.',
   FORECAST_RUN_DATETIME datetime  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime, unless a forecast run is missed in which case the previous run is used. Tracks to INTERMITTENT_GEN_FCST_P5_RUN.FORECAST_RUN_DATETIME.',
   PROVIDERID           varchar(20)  comment 'Provider of the forecast run used for the 5MPD run, tracks to INTERMITTENT_GEN_FCST_P5_RUN.PROVIDERID.',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Priority of the forecast run used for the 5MPD run, tracks to INTERMITTENT_GEN_FCST_P5_RUN.FORECAST_PRIORITY.',
   OFFERDATETIME        datetime  comment 'Submission datetime of the forecast run used for the 5MPD run, tracks to INTERMITTENT_GEN_FCST_P5_RUN.OFFERDATETIME.'
);

alter table P5MIN_INTERMITTENT_FCST_TRK comment 'Uniquely tracks which Intermittent Generation forecast run (';

alter table P5MIN_INTERMITTENT_FCST_TRK
   add primary key (RUN_DATETIME, DUID);

/*==============================================================*/
/* Table: P5MIN_INTERSENSITIVITIES                              */
/*==============================================================*/
create table P5MIN_INTERSENSITIVITIES
(
   RUN_DATETIME         datetime not null  comment 'Definitive Run from which this solution derives',
   INTERCONNECTORID     varchar(20) not null  comment 'Interconnector identifier',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   INTERVENTION         numeric(1,0) not null  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0)',
   INTERVENTION_ACTIVE  numeric(1,0)  comment 'Flag to indicate if the sensitivity run contains an active intervention constraint: 0 = No, 1 = Yes',
   MWFLOW1              numeric(15,5)  comment 'MW Flow value. Flow1 = MW flow for given Interconnector for Scenario 1',
   MWFLOW2              numeric(15,5)  comment 'MW Flow value. Flow2 = MW flow for given Interconnector for Scenario 2',
   MWFLOW3              numeric(15,5)  comment 'MW Flow value. Flow3 = MW flow for given Interconnector for Scenario 3',
   MWFLOW4              numeric(15,5)  comment 'MW Flow value. Flow4 = MW flow for given Interconnector for Scenario 4',
   MWFLOW5              numeric(15,5)  comment 'MW Flow value. Flow5 = MW flow for given Interconnector for Scenario 5',
   MWFLOW6              numeric(15,5)  comment 'MW Flow value. Flow6 = MW flow for given Interconnector for Scenario 6',
   MWFLOW7              numeric(15,5)  comment 'MW Flow value. Flow7 = MW flow for given Interconnector for Scenario 7',
   MWFLOW8              numeric(15,5)  comment 'MW Flow value. Flow8 = MW flow for given Interconnector for Scenario 8',
   MWFLOW9              numeric(15,5)  comment 'MW Flow value. Flow9 = MW flow for given Interconnector for Scenario 9',
   MWFLOW10             numeric(15,5)  comment 'MW Flow value. Flow10 = MW flow for given Interconnector for Scenario 10',
   MWFLOW11             numeric(15,5)  comment 'MW Flow value. Flow11 = MW flow for given Interconnector for Scenario 11',
   MWFLOW12             numeric(15,5)  comment 'MW Flow value. Flow12 = MW flow for given Interconnector for Scenario 12',
   MWFLOW13             numeric(15,5)  comment 'MW Flow value. Flow13 = MW flow for given Interconnector for Scenario 13',
   MWFLOW14             numeric(15,5)  comment 'MW Flow value. Flow14 = MW flow for given Interconnector for Scenario 14',
   MWFLOW15             numeric(15,5)  comment 'MW Flow value. Flow15 = MW flow for given Interconnector for Scenario 15',
   MWFLOW16             numeric(15,5)  comment 'MW Flow value. Flow16 = MW flow for given Interconnector for Scenario 16',
   MWFLOW17             numeric(15,5)  comment 'MW Flow value. Flow17 = MW flow for given Interconnector for Scenario 17',
   MWFLOW18             numeric(15,5)  comment 'MW Flow value. Flow18 = MW flow for given Interconnector for Scenario 18',
   MWFLOW19             numeric(15,5)  comment 'MW Flow value. Flow19 = MW flow for given Interconnector for Scenario 19',
   MWFLOW20             numeric(15,5)  comment 'MW Flow value. Flow20 = MW flow for given Interconnector for Scenario 20',
   MWFLOW21             numeric(15,5)  comment 'MW Flow value. Flow21 = MW flow for given Interconnector for Scenario 21',
   MWFLOW22             numeric(15,5)  comment 'MW Flow value. Flow22 = MW flow for given Interconnector for Scenario 22',
   MWFLOW23             numeric(15,5)  comment 'MW Flow value. Flow23 = MW flow for given Interconnector for Scenario 23',
   MWFLOW24             numeric(15,5)  comment 'MW Flow value. Flow24 = MW flow for given Interconnector for Scenario 24',
   MWFLOW25             numeric(15,5)  comment 'MW Flow value. Flow25 = MW flow for given Interconnector for Scenario 25',
   MWFLOW26             numeric(15,5)  comment 'MW Flow value. Flow26 = MW flow for given Interconnector for Scenario 26',
   MWFLOW27             numeric(15,5)  comment 'MW Flow value. Flow27 = MW flow for given Interconnector for Scenario 27',
   MWFLOW28             numeric(15,5)  comment 'MW Flow value. Flow28 = MW flow for given Interconnector for Scenario 28',
   MWFLOW29             numeric(15,5)  comment 'MW Flow value. Flow29 = MW flow for given Interconnector for Scenario 29',
   MWFLOW30             numeric(15,5)  comment 'MW Flow value. Flow30 = MW flow for given Interconnector for Scenario 30',
   MWFLOW31             numeric(15,5)  comment 'MW Flow value. Flow31 = MW flow for given Interconnector for Scenario 31',
   MWFLOW32             numeric(15,5)  comment 'MW Flow value. Flow32 = MW flow for given Interconnector for Scenario 32',
   MWFLOW33             numeric(15,5)  comment 'MW Flow value. Flow33 = MW flow for given Interconnector for Scenario 33',
   MWFLOW34             numeric(15,5)  comment 'MW Flow value. Flow34 = MW flow for given Interconnector for Scenario 34',
   MWFLOW35             numeric(15,5)  comment 'MW Flow value. Flow35 = MW flow for given Interconnector for Scenario 35',
   MWFLOW36             numeric(15,5)  comment 'MW Flow value. Flow36 = MW flow for given Interconnector for Scenario 36',
   MWFLOW37             numeric(15,5)  comment 'MW Flow value. Flow37 = MW flow for given Interconnector for Scenario 37',
   MWFLOW38             numeric(15,5)  comment 'MW Flow value. Flow38 = MW flow for given Interconnector for Scenario 38',
   MWFLOW39             numeric(15,5)  comment 'MW Flow value. Flow39 = MW flow for given Interconnector for Scenario 39',
   MWFLOW40             numeric(15,5)  comment 'MW Flow value. Flow40 = MW flow for given Interconnector for Scenario 40',
   MWFLOW41             numeric(15,5)  comment 'MW Flow value. Flow41 = MW flow for given Interconnector for Scenario 41',
   MWFLOW42             numeric(15,5)  comment 'MW Flow value. Flow42 = MW flow for given Interconnector for Scenario 42',
   MWFLOW43             numeric(15,5)  comment 'MW Flow value. Flow43 = MW flow for given Interconnector for Scenario 43',
   LASTCHANGED          datetime  comment 'Timestamp when this record was last modified'
);

alter table P5MIN_INTERSENSITIVITIES comment 'Price Sensitivies for 5MinPD solution. New solution every 5 ';

alter table P5MIN_INTERSENSITIVITIES
   add primary key (RUN_DATETIME, INTERCONNECTORID, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: P5MIN_LOCAL_PRICE                                     */
/*==============================================================*/
create table P5MIN_LOCAL_PRICE
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier',
   LOCAL_PRICE_ADJUSTMENT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this unit: Sum(MarginalValue x Factor) for all relevant Constraints',
   LOCALLY_CONSTRAINED  numeric(1,0)  comment 'Key for Local_Price_Adjustment: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints'
);

alter table P5MIN_LOCAL_PRICE comment 'Sets out local pricing offsets associated with each DUID con';

alter table P5MIN_LOCAL_PRICE
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, DUID);

/*==============================================================*/
/* Table: P5MIN_PRICESENSITIVITIES                              */
/*==============================================================*/
create table P5MIN_PRICESENSITIVITIES
(
   RUN_DATETIME         datetime not null  comment 'Definitive Run from which this solution derives',
   REGIONID             varchar(20) not null  comment 'Region',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   INTERVENTION         numeric(1,0) not null  comment 'Whether an Intervention constraint was defined in this run',
   INTERVENTION_ACTIVE  numeric(1,0)  comment 'Flag to indicate if the sensitivity run contains an active intervention constraint: 0 = No, 1 = Yes',
   RRP1                 numeric(15,5)  comment 'Regional Reference price for scenario 1',
   RRP2                 numeric(15,5)  comment 'Regional Reference price for scenario 2',
   RRP3                 numeric(15,5)  comment 'Regional Reference price for scenario 3',
   RRP4                 numeric(15,5)  comment 'Regional Reference price for scenario 4',
   RRP5                 numeric(15,5)  comment 'Regional Reference price for scenario 5',
   RRP6                 numeric(15,5)  comment 'Regional Reference price for scenario 6',
   RRP7                 numeric(15,5)  comment 'Regional Reference price for scenario 7',
   RRP8                 numeric(15,5)  comment 'Regional Reference price for scenario 8',
   RRP9                 numeric(15,5)  comment 'Regional Reference price for scenario 9',
   RRP10                numeric(15,5)  comment 'Regional Reference price for scenario 10',
   RRP11                numeric(15,5)  comment 'Regional Reference price for scenario 11',
   RRP12                numeric(15,5)  comment 'Regional Reference price for scenario 12',
   RRP13                numeric(15,5)  comment 'Regional Reference price for scenario 13',
   RRP14                numeric(15,5)  comment 'Regional Reference price for scenario 14',
   RRP15                numeric(15,5)  comment 'Regional Reference price for scenario 15',
   RRP16                numeric(15,5)  comment 'Regional Reference price for scenario 16',
   RRP17                numeric(15,5)  comment 'Regional Reference price for scenario 17',
   RRP18                numeric(15,5)  comment 'Regional Reference price for scenario 18',
   RRP19                numeric(15,5)  comment 'Regional Reference price for scenario 19',
   RRP20                numeric(15,5)  comment 'Regional Reference price for scenario 20',
   RRP21                numeric(15,5)  comment 'Regional Reference price for scenario 21',
   RRP22                numeric(15,5)  comment 'Regional Reference price for scenario 22',
   RRP23                numeric(15,5)  comment 'Regional Reference price for scenario 23',
   RRP24                numeric(15,5)  comment 'Regional Reference price for scenario 24',
   RRP25                numeric(15,5)  comment 'Regional Reference price for scenario 25',
   RRP26                numeric(15,5)  comment 'Regional Reference price for scenario 26',
   RRP27                numeric(15,5)  comment 'Regional Reference price for scenario 27',
   RRP28                numeric(15,5)  comment 'Regional Reference price for scenario 28',
   RRP29                numeric(15,5)  comment 'Regional Reference price for scenario 29',
   RRP30                numeric(15,5)  comment 'Regional Reference price for scenario 30',
   RRP31                numeric(15,5)  comment 'Regional Reference price for scenario 31',
   RRP32                numeric(15,5)  comment 'Regional Reference price for scenario 32',
   RRP33                numeric(15,5)  comment 'Regional Reference price for scenario 33',
   RRP34                numeric(15,5)  comment 'Regional Reference price for scenario 34',
   RRP35                numeric(15,5)  comment 'Regional Reference price for scenario 35',
   RRP36                numeric(15,5)  comment 'Regional Reference price for scenario 36',
   RRP37                numeric(15,5)  comment 'Regional Reference price for scenario 37',
   RRP38                numeric(15,5)  comment 'Regional Reference price for scenario 38',
   RRP39                numeric(15,5)  comment 'Regional Reference price for scenario 39',
   RRP40                numeric(15,5)  comment 'Regional Reference price for scenario 40',
   RRP41                numeric(15,5)  comment 'Regional Reference price for scenario 41',
   RRP42                numeric(15,5)  comment 'Regional Reference price for scenario 42',
   RRP43                numeric(15,5)  comment 'Regional Reference price for scenario 43',
   LASTCHANGED          datetime  comment 'Timestamp when this record was last modified'
);

alter table P5MIN_PRICESENSITIVITIES comment 'Price Sensitivies for 5MinPD solution. New solution every 5 ';

alter table P5MIN_PRICESENSITIVITIES
   add primary key (RUN_DATETIME, REGIONID, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: P5MIN_REGIONSOLUTION                                  */
/*==============================================================*/
create table P5MIN_REGIONSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   RRP                  numeric(15,5)  comment 'Region Reference Price (Energy)',
   ROP                  numeric(15,5)  comment 'Region Override Price (Energy)',
   EXCESSGENERATION     numeric(15,5)  comment 'Total Energy Imbalance (MW)',
   RAISE6SECRRP         numeric(15,5)  comment 'Region Reference Price (Raise6Sec)',
   RAISE6SECROP         numeric(15,5)  comment 'Original regional price (Raise6Sec)',
   RAISE60SECRRP        numeric(15,5)  comment 'Region Reference Price (Raise60Sec)',
   RAISE60SECROP        numeric(15,5)  comment 'Original regional price (Raise60Sec)',
   RAISE5MINRRP         numeric(15,5)  comment 'Region Reference Price (Raise5Min)',
   RAISE5MINROP         numeric(15,5)  comment 'Original regional price (Raise5Min)',
   RAISEREGRRP          numeric(15,5)  comment 'Region Reference Price (RaiseReg)',
   RAISEREGROP          numeric(15,5)  comment 'Original regional price (RaiseReg)',
   LOWER6SECRRP         numeric(15,5)  comment 'Region Reference Price (Lower6Sec)',
   LOWER6SECROP         numeric(15,5)  comment 'Original regional price (Lower6Sec)',
   LOWER60SECRRP        numeric(15,5)  comment 'Region Reference Price (Lower60Sec)',
   LOWER60SECROP        numeric(15,5)  comment 'Original regional price (Lower60Sec)',
   LOWER5MINRRP         numeric(15,5)  comment 'Region Reference Price (Lower5Min)',
   LOWER5MINROP         numeric(15,5)  comment 'Original regional price (Lower5Min)',
   LOWERREGRRP          numeric(15,5)  comment 'Region Reference Price (LowerReg)',
   LOWERREGROP          numeric(15,5)  comment 'Original regional price (LowerReg)',
   TOTALDEMAND          numeric(15,5)  comment 'Regional Demand - NB NOT net of Interconnector flows or Loads',
   AVAILABLEGENERATION  numeric(15,5)  comment 'Regional Available generation',
   AVAILABLELOAD        numeric(15,5)  comment 'Regional Available Load',
   DEMANDFORECAST       numeric(15,5)  comment 'Predicted change in regional demand for this interval',
   DISPATCHABLEGENERATION numeric(15,5)  comment 'Regional Generation Dispatched',
   DISPATCHABLELOAD     numeric(15,5)  comment 'Regional Load Dispatched',
   NETINTERCHANGE       numeric(15,5)  comment 'Net interconnector Flows',
   LOWER5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW dispatch',
   LOWER5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW imported',
   LOWER5MINLOCALDISPATCH numeric(15,5)  comment 'Lower 5 min local dispatch',
   LOWER5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min local requirement',
   LOWER5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min total requirement',
   LOWER60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW dispatch',
   LOWER60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW imported',
   LOWER60SECLOCALDISPATCH numeric(15,5)  comment 'Lower 60 sec local dispatch',
   LOWER60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec local requirement',
   LOWER60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec total requirement',
   LOWER6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW dispatch',
   LOWER6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW imported',
   LOWER6SECLOCALDISPATCH numeric(15,5)  comment 'Lower 6 sec local dispatch',
   LOWER6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec local requirement',
   LOWER6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec total requirement',
   RAISE5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Total Raise 5 min MW dispatch',
   RAISE5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min MW imported',
   RAISE5MINLOCALDISPATCH numeric(15,5)  comment 'Raise 5 min local dispatch',
   RAISE5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min local requirement',
   RAISE5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min total requirement',
   RAISE60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW dispatch',
   RAISE60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW imported',
   RAISE60SECLOCALDISPATCH numeric(15,5)  comment 'Raise 50 sec local dispatch',
   RAISE60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec local requirement',
   RAISE60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec total requirement',
   RAISE6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW dispatch',
   RAISE6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW imported',
   RAISE6SECLOCALDISPATCH numeric(15,5)  comment 'Raise 6 sec local dispatch',
   RAISE6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec local requirement',
   RAISE6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec total requirement',
   AGGREGATEDISPATCHERROR numeric(15,5)  comment 'Aggregate dispatch error applied',
   INITIALSUPPLY        numeric(15,5)  comment 'Sum of initial generation and import for region',
   CLEAREDSUPPLY        numeric(15,5)  comment 'Sum of cleared generation and import for region',
   LOWERREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation MW imported',
   LOWERREGDISPATCH     numeric(15,5)  comment 'Not used since Dec 2003. Total Lower Regulation dispatch',
   LOWERREGLOCALDISPATCH numeric(15,5)  comment 'Lower Regulation local dispatch',
   LOWERREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation local requirement',
   LOWERREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation total requirement',
   RAISEREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation MW imported',
   RAISEREGDISPATCH     numeric(15,5)  comment 'Not used since Dec 2003. Total Raise Regulation dispatch',
   RAISEREGLOCALDISPATCH numeric(15,5)  comment 'Raise Regulation local dispatch',
   RAISEREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation local requirement',
   RAISEREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation total requirement',
   RAISE5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min local requirement',
   RAISEREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg local requirement',
   RAISE60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 sec local requirement',
   RAISE6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 sec local requirement',
   LOWER5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min local requirement',
   LOWERREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg local requirement',
   LOWER60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 sec local requirement',
   LOWER6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 sec local requirement',
   RAISE5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min requirement',
   RAISEREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg requirement',
   RAISE60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 seconds requirement',
   RAISE6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 seconds requirement',
   LOWER5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min requirement',
   LOWERREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg requirement',
   LOWER60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 seconds requirement',
   LOWER6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 seconds requirement',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   TOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW).',
   DEMAND_AND_NONSCHEDGEN numeric(15,5)  comment 'Sum of Cleared Scheduled generation, imported generation (at the region boundary) and allowances made for non-scheduled generation (MW).',
   UIGF                 numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW).',
   SEMISCHEDULE_CLEAREDMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW',
   SEMISCHEDULE_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   SS_SOLAR_UIGF        numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is solar',
   SS_WIND_UIGF         numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is wind',
   SS_SOLAR_CLEAREDMW   numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is solar',
   SS_WIND_CLEAREDMW    numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is wind',
   SS_SOLAR_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is solar',
   SS_WIND_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is wind',
   WDR_INITIALMW        numeric(15,5)  comment 'Regional aggregated MW value at start of interval for Wholesale Demand Response (WDR) units',
   WDR_AVAILABLE        numeric(15,5)  comment 'Regional aggregated available MW for Wholesale Demand Response (WDR) units',
   WDR_DISPATCHED       numeric(15,5)  comment 'Regional aggregated dispatched MW for Wholesale Demand Response (WDR) units',
   SS_SOLAR_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Solar units in that region',
   SS_WIND_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Wind units in that region',
   RAISE1SECRRP         numeric(15,5)  comment 'Regional Raise 1Sec Price - R1Price attribute after capping/flooring',
   RAISE1SECROP         numeric(15,5)  comment 'Raise1Sec Regional Original Price - uncapped/unfloored and unscaled',
   LOWER1SECRRP         numeric(15,5)  comment 'Regional Lower 1Sec Price - RegionSolution element L1Price attribute',
   LOWER1SECROP         numeric(15,5)  comment 'Lower1Sec Regional Original Price - uncapped/unfloored and unscaled',
   RAISE1SECLOCALDISPATCH numeric(15,5)  comment 'Total Raise1Sec Dispatched in Region - RegionSolution element R1Dispatch attribute',
   LOWER1SECLOCALDISPATCH numeric(15,5)  comment 'Total Lower1Sec Dispatched in Region - RegionSolution element L1Dispatch attribute',
   BDU_ENERGY_STORAGE   numeric(15,5)  comment 'Regional aggregated energy storage where the DUID type is BDU (MWh)',
   BDU_MIN_AVAIL        numeric(15,5)  comment 'Total available load side BDU summated for region (MW)',
   BDU_MAX_AVAIL        numeric(15,5)  comment 'Total available generation side BDU summated for region (MW)',
   BDU_CLEAREDMW_GEN    numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of export (Generation)',
   BDU_CLEAREDMW_LOAD   numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of import (Load)',
   BDU_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy Storage for BDU at the start of the interval(MWh) - Region Aggregated',
   DECGEN_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy storage for Daily Energy Constrained Scheduled Generating Units at the start of the interval(MWh) - Region Aggregated'
);

alter table P5MIN_REGIONSOLUTION comment 'The five-minute predispatch (P5Min) is a MMS system providin';

alter table P5MIN_REGIONSOLUTION
   add primary key (RUN_DATETIME, REGIONID, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: P5MIN_REGIONSOLUTION_LCX                              */
/*==============================================================*/
create index P5MIN_REGIONSOLUTION_LCX on P5MIN_REGIONSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: P5MIN_ROOFTOP_PV_FCST_TRK                             */
/*==============================================================*/
create table P5MIN_ROOFTOP_PV_FCST_TRK
(
   RUN_DATETIME         datetime not null  comment 'Datetime (interval ending) of the 5-Minute Pre-dispatch run.',
   AREAID               varchar(10) not null  comment 'Area identifier aligning with the load forecasting areas, tracks to ROOFTOP_PV_FCST_P5_RUN.AREAID.',
   FORECAST_RUN_DATETIME datetime  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime, unless a forecast run is missed, in this case the previous run is used. Tracks to ROOFTOP_PV_FCST_P5_RUN.FORECAST_RUN_DATETIME.',
   PROVIDERID           varchar(20)  comment 'Provider identifier of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.PROVIDERID.',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Priority of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.FORECAST_PRIORITY.',
   OFFERDATETIME        datetime  comment 'Submission datetime of the forecast run used for the DS run, tracks to ROOFTOP_PV_FCST_P5_RUN.OFFERDATETIME.'
);

alter table P5MIN_ROOFTOP_PV_FCST_TRK comment 'Uniquely tracks which Rooftop PV forecast run (from ROOFTOP_';

alter table P5MIN_ROOFTOP_PV_FCST_TRK
   add primary key (RUN_DATETIME, AREAID);

/*==============================================================*/
/* Table: P5MIN_SCENARIODEMAND                                  */
/*==============================================================*/
create table P5MIN_SCENARIODEMAND
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of this set of scenarios',
   VERSION_DATETIME     datetime not null  comment 'The version of this set of scenarios',
   SCENARIO             numeric(2,0) not null  comment 'The scenario identifier',
   REGIONID             varchar(20) not null  comment 'The region to which to apply the deltaMW for this SCENARIO',
   DELTAMW              numeric(4,0)  comment 'The MW offset to apply to region total demand for this SCENARIO'
);

alter table P5MIN_SCENARIODEMAND comment 'The P5Min scenario MW offsets';

alter table P5MIN_SCENARIODEMAND
   add primary key (EFFECTIVEDATE, VERSION_DATETIME, REGIONID, SCENARIO);

/*==============================================================*/
/* Table: P5MIN_SCENARIODEMANDTRK                               */
/*==============================================================*/
create table P5MIN_SCENARIODEMANDTRK
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of this set of scenarios',
   VERSION_DATETIME     datetime not null  comment 'The version of this set of scenarios',
   AUTHORISEDDATE       datetime  comment 'The datetime that the scenario update was authorised',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed'
);

alter table P5MIN_SCENARIODEMANDTRK comment 'Tracks the 5Min scenario offset updates across time';

alter table P5MIN_SCENARIODEMANDTRK
   add primary key (EFFECTIVEDATE, VERSION_DATETIME);

/*==============================================================*/
/* Table: P5MIN_UNITSOLUTION                                    */
/*==============================================================*/
create table P5MIN_UNITSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier',
   CONNECTIONPOINTID    varchar(12)  comment 'Connection point identifier for DUID',
   TRADETYPE            numeric(2,0)  comment 'Generator or Load',
   AGCSTATUS            numeric(2,0)  comment 'AGC Status from EMS: 1 = on, 0 = off',
   INITIALMW            numeric(15,5)  comment 'Initial MW at start of period. For periods subsequent to the first period of a P5MIN run, this value represents the cleared target for the previous period of that P5MIN run. Negative values when Bi-directional Unit start from importing power, otherwise positive.',
   TOTALCLEARED         numeric(15,5)  comment 'Target MW for end of period. Negative values when Bi-directional Unit is importing power, otherwise positive.',
   RAMPDOWNRATE         numeric(15,5)  comment 'Ramp down rate (lessor of bid or telemetered rate).',
   RAMPUPRATE           numeric(15,5)  comment 'Ramp up rate (lessor of bid or telemetered rate).',
   LOWER5MIN            numeric(15,5)  comment 'Lower 5 min reserve target',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 sec reserve target',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 sec reserve target',
   RAISE5MIN            numeric(15,5)  comment 'Raise 5 min reserve target',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 sec reserve target',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 sec reserve target',
   LOWERREG             numeric(15,5)  comment 'Lower Regulation reserve target',
   RAISEREG             numeric(15,5)  comment 'Raise Regulation reserve target',
   AVAILABILITY         numeric(15,5)  comment 'For Scheduled units, this is the MAXAVAIL bid availability For Semi-scheduled units, this is the lower of MAXAVAIL bid availability and UIGF',
   RAISE6SECFLAGS       numeric(3,0)  comment 'Raise 6sec status flag',
   RAISE60SECFLAGS      numeric(3,0)  comment 'Raise 60sec status flag',
   RAISE5MINFLAGS       numeric(3,0)  comment 'Raise 5min status flag',
   RAISEREGFLAGS        numeric(3,0)  comment 'Raise Reg status flag',
   LOWER6SECFLAGS       numeric(3,0)  comment 'Lower 6sec status flag',
   LOWER60SECFLAGS      numeric(3,0)  comment 'Lower 60sec status flag',
   LOWER5MINFLAGS       numeric(3,0)  comment 'Lower 5min status flag',
   LOWERREGFLAGS        numeric(3,0)  comment 'Lower Reg status flag',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SEMIDISPATCHCAP      numeric(3,0)  comment 'Boolean representation flagging if the Target is Capped',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run(INTERVENTION=1). In the event there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   DISPATCHMODETIME     numeric(4,0)  comment 'Minutes for which the unit has been in the current DISPATCHMODE. From NEMDE TRADERSOLUTION element FSTARGETMODETIME attribute.',
   CONFORMANCE_MODE     numeric(6,0)  comment 'Mode specific to units within an aggregate. 0 - no monitoring, 1 - aggregate monitoring, 2 - individual monitoring due to constraint',
   UIGF                 numeric(15,5)  comment 'For Semi-Scheduled units. Unconstrained Intermittent Generation Forecast value provided to NEMDE',
   RAISE1SEC            numeric(15,5)  comment 'Dispatched Raise1Sec - TraderSolution element R1Target attribute',
   RAISE1SECFLAGS       numeric(3,0)  comment 'TraderSolution element R1Flags attribute',
   LOWER1SEC            numeric(15,5)  comment 'Dispatched Lower1Sec - TraderSolution element L1Target attribute',
   LOWER1SECFLAGS       numeric(3,0)  comment 'TraderSolution element L1Flags attribute',
   INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'The energy storage at the start of this dispatch interval(MWh)',
   ENERGY_STORAGE       numeric(15,5)  comment 'The projected energy storage based on cleared energy and regulation FCAS dispatch(MWh)',
   ENERGY_STORAGE_MIN   numeric(15,5)  comment 'BDU only - Minimum Energy Storage constraint limit (MWh)',
   ENERGY_STORAGE_MAX   numeric(15,5)  comment 'BDU only - Maximum Energy Storage constraint limit (MWh)',
   MIN_AVAILABILITY     numeric(15,5)  comment 'BDU only. Load side availability (BidOfferPeriod.MAXAVAIL where DIRECTION = LOAD).',
   ELEMENT_CAP          numeric(5,0)  comment 'Cap on the number of turbines or inverters at a DUID.'
);

alter table P5MIN_UNITSOLUTION comment 'The five-minute predispatch (P5Min) is a MMS system providin';

alter table P5MIN_UNITSOLUTION
   add primary key (RUN_DATETIME, DUID, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: P5MIN_UNITSOLUTION_LCX                                */
/*==============================================================*/
create index P5MIN_UNITSOLUTION_LCX on P5MIN_UNITSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANT                                           */
/*==============================================================*/
create table PARTICIPANT
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTCLASSID   varchar(20)  comment 'Class of participant',
   NAME                 varchar(80)  comment 'Full name of participant',
   DESCRIPTION          varchar(64)  comment 'Not used',
   ACN                  varchar(9)  comment 'Australian Company Number; Nine Numbers XXX-XXX-XXX',
   PRIMARYBUSINESS      varchar(40)  comment 'Identifies primary business activity of participant',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANT comment 'PARTICIPANT sets out Participant ID, name and class for all ';

alter table PARTICIPANT
   add primary key (PARTICIPANTID);

/*==============================================================*/
/* Index: PARTICIPANT_LCX                                       */
/*==============================================================*/
create index PARTICIPANT_LCX on PARTICIPANT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANTACCOUNT                                    */
/*==============================================================*/
create table PARTICIPANTACCOUNT
(
   ACCOUNTNAME          varchar(80)  comment 'Name of the account',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   ACCOUNTNUMBER        varchar(16)  comment 'Account number',
   BANKNAME             varchar(16)  comment 'Bank name',
   BANKNUMBER           numeric(10,0)  comment 'Bank number',
   BRANCHNAME           varchar(16)  comment 'Branch name',
   BRANCHNUMBER         numeric(10,0)  comment 'Branch number',
   BSBNUMBER            varchar(20)  comment 'BSB number',
   NEMMCOCREDITACCOUNTNUMBER numeric(10,0)  comment 'AEMO credit account number',
   NEMMCODEBITACCOUNTNUMBER numeric(10,0)  comment 'AEMO debit account number',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   EFFECTIVEDATE        datetime  comment 'Date record authorised',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ABN                  varchar(20)  comment 'Australian Business Number'
);

alter table PARTICIPANTACCOUNT comment 'PARTICIPANTACCOUNT shows financial details on participants.';

alter table PARTICIPANTACCOUNT
   add primary key (PARTICIPANTID);

/*==============================================================*/
/* Index: PARTICIPANTACCOUNT_LCX                                */
/*==============================================================*/
create index PARTICIPANTACCOUNT_LCX on PARTICIPANTACCOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANTCATEGORY                                   */
/*==============================================================*/
create table PARTICIPANTCATEGORY
(
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'Participant category identifier',
   DESCRIPTION          varchar(64)  comment 'Category description',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANTCATEGORY comment 'PARTICIPANTCATEGORY sets out valid participant categories.';

alter table PARTICIPANTCATEGORY
   add primary key (PARTICIPANTCATEGORYID);

/*==============================================================*/
/* Index: PARTICIPANTCATEGORY_LCX                               */
/*==============================================================*/
create index PARTICIPANTCATEGORY_LCX on PARTICIPANTCATEGORY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANTCATEGORYALLOC                              */
/*==============================================================*/
create table PARTICIPANTCATEGORYALLOC
(
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'Category unique identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANTCATEGORYALLOC comment 'PARTICIPANTCATEGORYALLOC sets out the assignment of particip';

alter table PARTICIPANTCATEGORYALLOC
   add primary key (PARTICIPANTCATEGORYID, PARTICIPANTID);

/*==============================================================*/
/* Index: PARTICIPANTCATEGORYALLOC_LCX                          */
/*==============================================================*/
create index PARTICIPANTCATEGORYALLOC_LCX on PARTICIPANTCATEGORYALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANTCLASS                                      */
/*==============================================================*/
create table PARTICIPANTCLASS
(
   PARTICIPANTCLASSID   varchar(20) not null  comment 'Class of participant',
   DESCRIPTION          varchar(64)  comment 'Description of participant class',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANTCLASS comment 'PARTICIPANTCLASS sets out valid participant classifications.';

alter table PARTICIPANTCLASS
   add primary key (PARTICIPANTCLASSID);

/*==============================================================*/
/* Index: PARTICIPANTCLASS_LCX                                  */
/*==============================================================*/
create index PARTICIPANTCLASS_LCX on PARTICIPANTCLASS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANTCREDITDETAIL                               */
/*==============================================================*/
create table PARTICIPANTCREDITDETAIL
(
   EFFECTIVEDATE        datetime not null  comment '',
   PARTICIPANTID        varchar(10) not null  comment '',
   CREDITLIMIT          numeric(10,0)  comment '',
   AUTHORISEDBY         varchar(15)  comment '',
   AUTHORISEDDATE       datetime  comment '',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANTCREDITDETAIL
   add primary key (EFFECTIVEDATE, PARTICIPANTID);

/*==============================================================*/
/* Index: PARTICIPANTCREDITDETAIL_LCX                           */
/*==============================================================*/
create index PARTICIPANTCREDITDETAIL_LCX on PARTICIPANTCREDITDETAIL
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: PARTICIPANTCREDITDET_NDX2                             */
/*==============================================================*/
create index PARTICIPANTCREDITDET_NDX2 on PARTICIPANTCREDITDETAIL
(
   PARTICIPANTID
);

/*==============================================================*/
/* Table: PARTICIPANTNOTICETRK                                  */
/*==============================================================*/
create table PARTICIPANTNOTICETRK
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   NOTICEID             numeric(10,0) not null  comment 'Market notice identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANTNOTICETRK comment 'PARTICIPANTNOTICETRK provides the cross-reference between pa';

alter table PARTICIPANTNOTICETRK
   add primary key (PARTICIPANTID, NOTICEID);

/*==============================================================*/
/* Index: PARTICIPANTNOTICETRK_NDX2                             */
/*==============================================================*/
create index PARTICIPANTNOTICETRK_NDX2 on PARTICIPANTNOTICETRK
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: PARTICIPANTNOTICETRK_LCX                              */
/*==============================================================*/
create index PARTICIPANTNOTICETRK_LCX on PARTICIPANTNOTICETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PARTICIPANT_BANDFEE_ALLOC                             */
/*==============================================================*/
create table PARTICIPANT_BANDFEE_ALLOC
(
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   MARKETFEEID          varchar(10) not null  comment 'Identifier for Market Fee',
   EFFECTIVEDATE        datetime not null  comment 'Date on which this data becomes effective.',
   VERSIONNO            numeric(3,0) not null  comment 'Period identifier',
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'The participant category that the market fee recovery amount pertains to.',
   MARKETFEEVALUE       numeric(15,5)  comment 'The value of this market fee',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PARTICIPANT_BANDFEE_ALLOC comment 'PARTICIPANT_BANDFEE_ALLOC shows the market fee for each Part';

alter table PARTICIPANT_BANDFEE_ALLOC
   add primary key (PARTICIPANTID, MARKETFEEID, EFFECTIVEDATE, VERSIONNO, PARTICIPANTCATEGORYID);

/*==============================================================*/
/* Index: PARTICIPANT_BANDFEE_ALOC_LCX                          */
/*==============================================================*/
create index PARTICIPANT_BANDFEE_ALOC_LCX on PARTICIPANT_BANDFEE_ALLOC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PASACASESOLUTION                                      */
/*==============================================================*/
create table PASACASESOLUTION
(
   CASEID               varchar(20) not null  comment 'PASA Case Identifier',
   SOLUTIONCOMPLETE     numeric(16,6)  comment 'Not used',
   PASAVERSION          numeric(27,10)  comment 'Software version identifier',
   EXCESSGENERATION     numeric(16,6)  comment 'Excess generation detected flag',
   DEFICITCAPACITY      numeric(16,6)  comment 'Deficit capacity detected flag',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime  comment 'Scheduled date and time of the run'
);

alter table PASACASESOLUTION comment 'PASACASESOLUTION sets out ST PASA case listing providing det';

alter table PASACASESOLUTION
   add primary key (CASEID);

/*==============================================================*/
/* Index: PASACASESOLUTION_LCX                                  */
/*==============================================================*/
create index PASACASESOLUTION_LCX on PASACASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PASACONSTRAINTSOLUTION                                */
/*==============================================================*/
create table PASACONSTRAINTSOLUTION
(
   CASEID               varchar(20) not null  comment 'PASA Case Identifier',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint Id',
   PERIODID             varchar(20) not null  comment 'PASA Interval (48 half hours)',
   CAPACITYMARGINALVALUE numeric(16,6)  comment 'Binding value of capacity and adequacy (if insufficient to measure)',
   CAPACITYVIOLATIONDEGREE numeric(16,6)  comment 'Deficit MW of surplus capacity',
   EXCESSGENMARGINALVALUE numeric(16,6)  comment 'Binding value of dispatch generator above aggregate self dispatch',
   EXCESSGENVIOLATIONDEGREE numeric(16,6)  comment 'Deficit of generator above aggregate self dispatch level',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime  comment 'Date and time of the end of the period'
);

alter table PASACONSTRAINTSOLUTION comment 'PASACONSTRAINTSOLUTION records the latest binding STPASA con';

alter table PASACONSTRAINTSOLUTION
   add primary key (PERIODID, CONSTRAINTID);

/*==============================================================*/
/* Index: PASACONSTRAINTSOLUTION_LCX                            */
/*==============================================================*/
create index PASACONSTRAINTSOLUTION_LCX on PASACONSTRAINTSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PASAINTERCONNECTORSOLUTION                            */
/*==============================================================*/
create table PASAINTERCONNECTORSOLUTION
(
   CASEID               varchar(20) not null  comment 'PASA Case Identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector Id',
   PERIODID             varchar(20) not null  comment 'PASA Interval (48 half hours)',
   CAPACITYMWFLOW       numeric(16,6)  comment 'Capacity MW flow',
   CAPACITYMARGINALVALUE numeric(16,6)  comment 'Marginal value in capacity',
   CAPACITYVIOLATIONDEGREE numeric(16,6)  comment 'Violation value in capacity',
   EXCESSGENMWFLOW      numeric(16,6)  comment 'Excess generation MW flow',
   EXCESSGENMARGINALVALUE numeric(16,6)  comment 'Marginal value in excess generation',
   EXCESSGENVIOLATIONDEGREE numeric(16,6)  comment 'Violation value in excess generation',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   IMPORTLIMIT          numeric(15,5)  comment 'Calculated import limit',
   EXPORTLIMIT          numeric(15,5)  comment 'Calculated export limit',
   DATETIME             datetime  comment 'Date and time of the end of the period'
);

alter table PASAINTERCONNECTORSOLUTION comment 'PASAINTERCONNECTORSOLUTION records ST PASA interconnector so';

alter table PASAINTERCONNECTORSOLUTION
   add primary key (PERIODID, INTERCONNECTORID);

/*==============================================================*/
/* Index: PASAINTERCONNECTORSOLUTIO_LCX                         */
/*==============================================================*/
create index PASAINTERCONNECTORSOLUTIO_LCX on PASAINTERCONNECTORSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PASAREGIONSOLUTION                                    */
/*==============================================================*/
create table PASAREGIONSOLUTION
(
   CASEID               varchar(20) not null  comment 'PASA Case Identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             varchar(20) not null  comment 'PASA Interval (48 half hours)',
   DEMAND10             numeric(16,6)  comment '10% exceedence forecast',
   DEMAND50             numeric(16,6)  comment '50% exceedence forecast',
   DEMAND90             numeric(16,6)  comment '90% exceedence forecast',
   UNCONSTRAINEDCAPACITY numeric(16,6)  comment 'Unconstrained capacity',
   CONSTRAINEDCAPACITY  numeric(16,6)  comment 'Constrained capacity',
   CAPACITYSURPLUS      numeric(16,6)  comment 'Surplus capacity',
   RESERVEREQ           numeric(16,6)  comment 'Reserve requirement',
   RESERVECONDITION     numeric(16,6)  comment 'Reserve condition',
   RESERVESURPLUS       numeric(16,6)  comment 'Reserve surplus',
   LOADREJECTIONRESERVEREQ numeric(16,6)  comment 'Load rejection reserve requirement',
   LOADREJECTIONRESERVESURPLUS numeric(16,6)  comment 'Load rejection reserve surplus',
   NETINTERCHANGEUNDEREXCESS numeric(16,6)  comment 'Net interchange excess',
   NETINTERCHANGEUNDERSCARCITY numeric(16,6)  comment 'Net interchange scarcity',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   EXCESSGENERATION     numeric(22,0)  comment 'Excess generation in period OR Deficit generation if VoLL',
   ENERGYREQUIRED       numeric(15,5)  comment 'Total amount of energy required for the reported day',
   CAPACITYREQUIRED     numeric(15,5)  comment 'Trading interval demand for the region that has a 10% probability of being exceeded, plus the medium term capacity reserve standard.',
   DATETIME             datetime  comment 'Date and time of the end of the period'
);

alter table PASAREGIONSOLUTION comment 'PASAREGIONSOLUTION shows the Regional solution for ST PASA s';

alter table PASAREGIONSOLUTION
   add primary key (PERIODID, REGIONID);

/*==============================================================*/
/* Index: PASAREGIONSOLUTION_LCX                                */
/*==============================================================*/
create index PASAREGIONSOLUTION_LCX on PASAREGIONSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PD7DAY_CASESOLUTION                                   */
/*==============================================================*/
create table PD7DAY_CASESOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this Predispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PD7DAY_CASESOLUTION comment 'PD7DAY case solution table';

alter table PD7DAY_CASESOLUTION
   add primary key (RUN_DATETIME);

/*==============================================================*/
/* Table: PD7DAY_CONSTRAINTSOLUTION                             */
/*==============================================================*/
create table PD7DAY_CONSTRAINTSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVENTION         numeric(2,0) not null  comment 'Flag to indicate if this Predispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run.',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint identifier (synonymous with GenConID)',
   RHS                  numeric(15,5)  comment 'Right Hand Side value in the capacity evaluation in MW',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal cost of constraint (>0 if binding) in $/MW',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Amount of Violation (>0 if violating) in MW',
   LHS                  numeric(15,5)  comment 'Aggregation of the constraints LHS term solution values in MW',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PD7DAY_CONSTRAINTSOLUTION comment 'PD7DAY constraint solution';

alter table PD7DAY_CONSTRAINTSOLUTION
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, CONSTRAINTID, INTERVENTION);

/*==============================================================*/
/* Table: PD7DAY_INTERCONNECTORSOLUTION                         */
/*==============================================================*/
create table PD7DAY_INTERCONNECTORSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVENTION         numeric(2,0) not null  comment 'Flag to indicate if this Predispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run.',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   INTERCONNECTORID     varchar(20) not null  comment 'Interconnector identifier',
   METEREDMWFLOW        numeric(15,5)  comment 'SCADA MW Flow measured at Run start. For periods subsequent to the first period of a PD7DAY run, this value represents the cleared target for the previous period of that PD7DAY run.',
   MWFLOW               numeric(15,5)  comment 'Cleared Interconnector loading level (MW)',
   MWLOSSES             numeric(15,5)  comment 'Interconnector Losses at cleared flow',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal cost of Interconnector standing data limits (if binding)',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Violation of Interconnector standing data limits',
   EXPORTLIMIT          numeric(15,5)  comment 'Calculated Interconnector limit of exporting energy on the basis of invoked constraints and static interconnector export limit',
   IMPORTLIMIT          numeric(15,5)  comment 'Calculated Interconnector limit of importing energy on the basis of invoked constraints and static interconnector import limit. Note unlike the input interconnector import limit this is a directional quantity and should be defined with respect to the interconnector flow.',
   MARGINALLOSS         numeric(15,5)  comment 'Marginal loss factor at the cleared flow',
   EXPORTCONSTRAINTID   varchar(20)  comment 'Generic Constraint setting the export limit',
   IMPORTCONSTRAINTID   varchar(20)  comment 'Generic Constraint setting the import limit',
   FCASEXPORTLIMIT      numeric(15,5)  comment 'Calculated export limit applying to energy + Frequency Controlled Ancillary Services.',
   FCASIMPORTLIMIT      numeric(15,5)  comment 'Calculated import limit applying to energy + Frequency Controlled Ancillary Services.',
   LOCAL_PRICE_ADJUSTMENT_EXPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Export (Factor >= 0)',
   LOCALLY_CONSTRAINED_EXPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Export: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LOCAL_PRICE_ADJUSTMENT_IMPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Import (Factor >= 0)',
   LOCALLY_CONSTRAINED_IMPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Import: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PD7DAY_INTERCONNECTORSOLUTION comment 'PD7DAY intereconnector solution';

alter table PD7DAY_INTERCONNECTORSOLUTION
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, INTERCONNECTORID, INTERVENTION);

/*==============================================================*/
/* Table: PD7DAY_MARKET_SUMMARY                                 */
/*==============================================================*/
create table PD7DAY_MARKET_SUMMARY
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   GPG_FUEL_FORECAST_TJ numeric(15,5)  comment 'The total gas consumption in TJ'
);

alter table PD7DAY_MARKET_SUMMARY comment 'PD7DAY market summary showing calculated gas fuel forecasts';

alter table PD7DAY_MARKET_SUMMARY
   add primary key (RUN_DATETIME, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: PD7DAY_PRICESOLUTION                                  */
/*==============================================================*/
create table PD7DAY_PRICESOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVENTION         numeric(2,0) not null  comment 'Flag to indicate if this Predispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run.',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   REGIONID             varchar(20) not null  comment 'Region Identifier',
   RRP                  numeric(15,5)  comment 'Region Reference Price (Energy)',
   LOWER1SECRRP         numeric(15,5)  comment 'Regional Lower 1Sec Price - RegionSolution element L1Price attribute',
   LOWER6SECRRP         numeric(15,5)  comment 'Region Reference Price (Lower6Sec)',
   LOWER60SECRRP        numeric(15,5)  comment 'Region Reference Price (Lower60Sec)',
   LOWER5MINRRP         numeric(15,5)  comment 'Region Reference Price (Lower5Min)',
   LOWERREGRRP          numeric(15,5)  comment 'Region Reference Price (LowerReg)',
   RAISE1SECRRP         numeric(15,5)  comment 'Regional Raise 1Sec Price - R1Price attribute after capping/flooring',
   RAISE6SECRRP         numeric(15,5)  comment 'Region Reference Price (Raise6Sec)',
   RAISE60SECRRP        numeric(15,5)  comment 'Region Reference Price (Raise60Sec)',
   RAISE5MINRRP         numeric(15,5)  comment 'Region Reference Price (Raise5Min)',
   RAISEREGRRP          numeric(15,5)  comment 'Region Reference Price (RaiseReg)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   BDU_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy Storage for BDU at the start of the interval(MWh) - Region Aggregated',
   DECGEN_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy storage for Daily Energy Constrained Scheduled Generating Units at the start of the interval(MWh) - Region Aggregated'
);

alter table PD7DAY_PRICESOLUTION comment 'PD7DAY price solution';

alter table PD7DAY_PRICESOLUTION
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, REGIONID, INTERVENTION);

/*==============================================================*/
/* Table: PDPASA_CASESOLUTION                                   */
/*==============================================================*/
create table PDPASA_CASESOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Case identifier by the time the case was run',
   PASAVERSION          varchar(10)  comment 'Version of the PASA solver used to solve this case',
   RESERVECONDITION     numeric(1,0)  comment 'Low Reserve Condition (LRC) flag for the case (1 - LRC in the case, 0 - No LRCs in the case) for capacity run',
   LORCONDITION         numeric(1,0)  comment 'Lack of Reserve Condition (LOR) flag for the case indicates the most severe condition in the case  (3 = LOR3, 2 = LOR2, 1 = LOR1, 0 = No LOR)',
   CAPACITYOBJFUNCTION  numeric(12,3)  comment 'Objective Function from the Capacity Adequacy run',
   CAPACITYOPTION       numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the Probability of Exceedance (POE) demand forecast used for capacity adequacy (LRC) assessment. 0 if no assessment, 1 for 10% POE, 2 for 50% POE, 3 for 90% POE.',
   MAXSURPLUSRESERVEOPTION numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the Probability of Exceedance (POE) demand forecast used for assessment of Maximum surplus Reserve. 0 if no assessment, 1 for 10% POE, 2 for 50% POE, 3 for 90% POE',
   MAXSPARECAPACITYOPTION numeric(12,3)  comment 'Not populated as of 2005 End of Year Release; was the Probability of Exceedance (POE) demand forecast used for assessment of Maximum Spare Capacity. 0 if no assessment, 1 for 10% POE, 2 for 50% POE, 3 for 90% POE',
   INTERCONNECTORFLOWPENALTY numeric(12,3)  comment 'The penalty for non-zero interconnector flow',
   LASTCHANGED          datetime  comment 'Date and time the record was created or modified',
   RELIABILITYLRCDEMANDOPTION numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for Reliability LRC assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   OUTAGELRCDEMANDOPTION numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for outage LRC assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   LORDEMANDOPTION      numeric(12,3)  comment 'Specifies the Probability of Exceedence (POE) demand forecast for LOR assessment (0 if no assessment, 10 for 10%, 50 for 50%, 90 for 90%)',
   RELIABILITYLRCCAPACITYOPTION varchar(10)  comment 'Generation Availability to be used in Reliability LRC run (either PASA or MARKET)',
   OUTAGELRCCAPACITYOPTION varchar(10)  comment 'Generation Availability to be used in Outage LRC run (either PASA or MARKET)',
   LORCAPACITYOPTION    varchar(10)  comment 'Generation Availability to be used in LOR run (either PASA or MARKET)',
   LORUIGFOPTION        numeric(3,0)  comment 'UIGF POE forecast availability used for this option',
   RELIABILITYLRCUIGFOPTION numeric(3,0)  comment 'UIGF POE forecast availability used for this option',
   OUTAGELRCUIGFOPTION  numeric(3,0)  comment 'UIGF POE forecast availability used for this option'
);

alter table PDPASA_CASESOLUTION comment 'The top-level table identifying a PDPASA case, reporting opt';

alter table PDPASA_CASESOLUTION
   add primary key (RUN_DATETIME);

/*==============================================================*/
/* Index: PDPASA_CASESOLUTION_LCX                               */
/*==============================================================*/
create index PDPASA_CASESOLUTION_LCX on PDPASA_CASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PDPASA_CONSTRAINTSOLUTION                             */
/*==============================================================*/
create table PDPASA_CONSTRAINTSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint identifier (synonymous with GenConID)',
   CAPACITYRHS          numeric(12,2)  comment 'The RHS value in the capacity evaluation.',
   CAPACITYMARGINALVALUE numeric(12,2)  comment 'Capacity adequacy assessment marginal value, 0 if not binding',
   CAPACITYVIOLATIONDEGREE numeric(12,2)  comment 'Capacity adequacy assessment violation degree for generic constraint; 0 if not violating',
   LASTCHANGED          datetime  comment 'Last changed date of this record',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run. Values are OUTAGE_LRC and LOR. Note that the PDPASA OUTAGE_LRC Run Type is discontinued from 31 July 2025, with only the LOR Run Type reported.',
   STUDYREGIONID        varchar(20) not null default 'MARKET'  comment 'Primary Region for LP Solve (or MARKET if none).'
);

alter table PDPASA_CONSTRAINTSOLUTION comment 'PDPASA_CONSTRAINTSOLUTION shows binding and violated constra';

alter table PDPASA_CONSTRAINTSOLUTION
   add primary key (RUN_DATETIME, RUNTYPE, INTERVAL_DATETIME, CONSTRAINTID, STUDYREGIONID);

/*==============================================================*/
/* Table: PDPASA_DUIDAVAILABILITY                               */
/*==============================================================*/
create table PDPASA_DUIDAVAILABILITY
(
   RUN_DATETIME         datetime not null  comment 'PDPASA run, identified by the first half hour ended interval of the run.',
   INTERVAL_DATETIME    datetime not null  comment 'Half hour ended interval',
   DUID                 varchar(20) not null  comment 'NEM Dispatchable Unit Identifier',
   GENERATION_MAX_AVAILABILITY numeric(12,6)  comment 'Available Capacity for a scheduled generating unit, semi-scheduled generating unit, BDU (Gen side), WDR or MNSP.',
   GENERATION_PASA_AVAILABILITY numeric(12,0)  comment 'PASA Availability for a scheduled generating unit, BDU (Gen side), WDR or MNSP. Null for a semi-scheduled generating unit.',
   GENERATION_RECALL_PERIOD numeric(8,3)  comment 'Recall Period associated with the PASA Availability for a scheduled generating unit, BDU (Gen side), WDR or MNSP. Null for a semi-scheduled generating unit.',
   LOAD_MAX_AVAILABILITY numeric(12,6)  comment 'Available Capacity for a scheduled load or BDU(Load side).',
   LOAD_PASA_AVAILABILITY numeric(12,0)  comment 'PASA Availability for a scheduled load or BDU(Load side).',
   LOAD_RECALL_PERIOD   numeric(8,3)  comment 'Recall Period associated with the PASA Availability for a scheduled load or BDU(Load side).',
   LASTCHANGED          datetime  comment 'Report Creation Date Time.'
);

alter table PDPASA_DUIDAVAILABILITY comment 'This report delivers available capacity, PASA availability a';

alter table PDPASA_DUIDAVAILABILITY
   add primary key (RUN_DATETIME, INTERVAL_DATETIME, DUID);

/*==============================================================*/
/* Table: PDPASA_INTERCONNECTORSOLN                             */
/*==============================================================*/
create table PDPASA_INTERCONNECTORSOLN
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this study',
   INTERVAL_DATETIME    datetime not null  comment 'The unique identifier for the interval within this study',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector Identifier',
   CAPACITYMWFLOW       numeric(12,2)  comment 'Interconnector loading level (MW) that can be reached in case of capacity scarcity in neighbouring regions subject to network and energy constraints',
   CAPACITYMARGINALVALUE numeric(12,2)  comment 'Capacity adequacy assessment marginal value, 0 if not binding',
   CAPACITYVIOLATIONDEGREE numeric(12,2)  comment 'Capacity adequacy assessment violation degree for interconnector capacity; 0 if not violating',
   CALCULATEDEXPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of exporting energy on the basis of invoked constraints and static interconnector export limit',
   CALCULATEDIMPORTLIMIT numeric(12,2)  comment 'Calculated Interconnector limit of importing energy on the basis of invoked constraints and static interconnector import limit. Note unlike the input interconnector import limit this is a directional quantity and should be defined with respect to the interconnector flow.',
   LASTCHANGED          datetime  comment 'Last changed date of this record',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run. Values are OUTAGE_LRC and LOR. Note that the PDPASA OUTAGE_LRC Run Type is discontinued from 31 July 2025, with only the LOR Run Type reported.',
   EXPORTLIMITCONSTRAINTID varchar(20)  comment 'ID of the constraint that sets the Interconnector Export Limit',
   IMPORTLIMITCONSTRAINTID varchar(20)  comment 'ID of the constraint that sets the Interconnector Import Limit',
   STUDYREGIONID        varchar(20) not null default 'MARKET'  comment 'Primary Region for LP Solve (or MARKET if none).'
);

alter table PDPASA_INTERCONNECTORSOLN comment 'PDPASA_INTERCONNECTORSOLN shows the results of the capacity ';

alter table PDPASA_INTERCONNECTORSOLN
   add primary key (RUN_DATETIME, RUNTYPE, INTERVAL_DATETIME, INTERCONNECTORID, STUDYREGIONID);

/*==============================================================*/
/* Table: PDPASA_REGIONSOLUTION                                 */
/*==============================================================*/
create table PDPASA_REGIONSOLUTION
(
   RUN_DATETIME         datetime not null  comment 'Unique Timestamp Identifier for this run, identified by the first half hour ended interval of the run.',
   INTERVAL_DATETIME    datetime not null  comment 'End date time of the interval',
   REGIONID             varchar(10) not null  comment 'Region identifier',
   DEMAND10             numeric(12,2)  comment '10% Probability of Exceedance demand forecast',
   DEMAND50             numeric(12,2)  comment '50% Probability of Exceedance demand forecast',
   DEMAND90             numeric(12,2)  comment '90% Probability of Exceedance demand forecast',
   RESERVEREQ           numeric(12,2)  comment 'Reserve Requirement (MW). This field is not populated after 30 July 2025.',
   CAPACITYREQ          numeric(12,2)  comment 'Demand + Reserve requirements (MW). This field is not populated after 30 July 2025.',
   ENERGYREQDEMAND50    numeric(12,2)  comment 'Sum of: (Region Demand50)/Period (sum by trading day, entered in first period of trading day, GWh).',
   UNCONSTRAINEDCAPACITY numeric(12,0)  comment 'Aggregate generation + WDR capacity from Non-Energy Constrained plant subjected to restrictions due to network constraints.',
   CONSTRAINEDCAPACITY  numeric(12,0)  comment 'Aggregate generation + WDR capacity from Energy Constrained plant subjected to restrictions due to network constraints.',
   NETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net export (MW) out of this region in the LOR evaluation. Export if > 0, Import if < 0. This value is the same as LORNETINTERCHANGEUNDERSCARCITY.',
   SURPLUSCAPACITY      numeric(12,2)  comment 'Regional surplus capacity (MW), +/- values indicate surplus/deficit capacity respectively. This value reflects Regional LOR reserve.',
   SURPLUSRESERVE       numeric(12,2)  comment 'Regional surplus reserve (MW). This value also reflects Regional LOR reserve. Note: For LOR runs, RESERVEREQ requirement input is not used.',
   RESERVECONDITION     numeric(1,0)  comment 'Regional reserve condition from LRC run. This field is not populated after 30 July 2025.',
   MAXSURPLUSRESERVE    numeric(12,2)  comment 'Maximum Surplus Reserve (MW) evaluated for this region from LRC runs. This field is no longer populated.',
   MAXSPARECAPACITY     numeric(12,2)  comment 'Maximum Spare Capacity (MW) evaluated for this region. Calculated for each region in turn. This value reflects Regional LOR reserve.',
   LORCONDITION         numeric(1,0)  comment 'Lack of Reserve Condition (LOR) flag for this region and interval   (3 = LOR3, 2 = LOR2, 1 = LOR1, 0 = No LOR)',
   AGGREGATECAPACITYAVAILABLE numeric(12,2)  comment 'Sum of MAXAVAIL quantities offered by all Scheduled units and Availability of all semi-scheduled units limited by MAXAVAIL in a given Region for a given PERIODID',
   AGGREGATESCHEDULEDLOAD numeric(12,2)  comment 'Sum of  MAXAVAIL quantities bid by of all Scheduled Loads in a given Region for a given PERIODID.',
   LASTCHANGED          datetime  comment 'Date time this record was created.',
   AGGREGATEPASAAVAILABILITY numeric(12,0)  comment 'Sum of PASAAVAILABILITY for all scheduled generating units and scheduled bidirectional units (Gen side) with a Recall_Period <= 24 hours plus the sum of Unconstrained Intermittent Generation Forecasts (UIGF) for all semi-scheduled generating units. For the OUTAGE_LRC run, UIGF is the POE90 forecast. For the LOR Run, UIGF is the POE50 forecast. Note that the OUTAGE_LRC Run Type is discontinued from 31 July 2025.',
   RUNTYPE              varchar(20) not null default 'OUTAGE_LRC'  comment 'Type of run. Values are OUTAGE_LRC and LOR. Note that the PDPASA OUTAGE_LRC Run Type is discontinued from 31 July 2025, with only the LOR Run Type reported.',
   ENERGYREQDEMAND10    numeric(12,2)  comment 'Energy (GWh) required for this energy block based on the 10% probability of exceedance demand. Listed in the first interval of the energy block',
   CALCULATEDLOR1LEVEL  numeric(16,6)  comment 'Region Reserve Level for LOR1 used. Can be static value or calculated value if an interconnector is a credible contingency',
   CALCULATEDLOR2LEVEL  numeric(16,6)  comment 'Region Reserve Level for LOR2 used. Can be static value or calculated value if an interconnector is a credible contingency',
   MSRNETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net interconnector flow from the region for this interval from the MSR assessment. This field is no longer populated.',
   LORNETINTERCHANGEUNDERSCARCITY numeric(12,2)  comment 'Net interconnector flow from the region for this interval from the LOR assessment',
   TOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW).',
   DEMAND_AND_NONSCHEDGEN numeric(15,5)  comment 'Sum of Cleared Scheduled generation, imported generation (at the region boundary) and allowances made for non-scheduled generation (MW).',
   UIGF                 numeric(12,2)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW).',
   SEMISCHEDULEDCAPACITY numeric(12,2)  comment 'Constrained generation forecast (MW) for semi-scheduled units for the region. For OUTAGE_LRC run and LOR run, semi-scheduled generation is constrained by both System Normal and Outage constraints. All run types (OUTAGE_LRC, LOR) incorporate MAXAVAIL limits.',
   LOR_SEMISCHEDULEDCAPACITY numeric(12,2)  comment 'Constrained generation forecast for semi-scheduled units for the region for the LOR run. Semi-scheduled generation is constrained by both System Normal and Outage constraints, and incorporate MAXAVAIL limits.',
   LCR                  numeric(16,6)  comment 'Largest Credible Risk. MW value for highest credible contingency',
   LCR2                 numeric(16,6)  comment 'Two Largest Credible Risks. MW value for highest two credible contingencies.',
   FUM                  numeric(16,6)  comment 'Forecasting Uncertainty Measure. MW value of reserve calculated as defined in the Reserve Level Declaration Guidelines',
   SS_SOLAR_UIGF        numeric(12,2)  comment 'Unconstrained Intermittent Generation Forecast for solar for the region. For OUTAGE_LRC run, this is the POE90 forecast (determined by LRCUIGFOption in CaseSolution). For LOR run, this is the POE50 forecast.',
   SS_WIND_UIGF         numeric(12,2)  comment 'Unconstrained Intermittent Generation Forecast for wind for the region. For OUTAGE_LRC run, this is the POE90 forecast (determined by LRCUIGFOption in CaseSolution). For LOR run, this is the POE50 forecast.',
   SS_SOLAR_CAPACITY    numeric(12,2)  comment 'Constrained generation forecast for solar for the region. For OUTAGE_LRC run and LOR run. solar generation is constrained by both System Normal and Outage constraints. All run types (OUTAGE_LRC, LOR) incorporate MAXAVAIL limits.',
   SS_WIND_CAPACITY     numeric(12,2)  comment 'Constrained generation forecast for wind for the region. For OUTAGE_LRC run and LOR run, wind generation is constrained by both System Normal and Outage constraints. All run types (OUTAGE_LRC, LOR) incorporate MAXAVAIL limits.',
   SS_SOLAR_CLEARED     numeric(12,2)  comment 'Constrained generation forecast (MW) for solar for the region. For OUTAGE_LRC run and LOR run, solar generation is constrained by both System Normal and Outage constraints. All run types (OUTAGE_LRC, LOR) incorporate MAXAVAIL limits. This value is the same as SS_SOLAR_CAPACITY.',
   SS_WIND_CLEARED      numeric(12,2)  comment 'Constrained generation forecast (MW) for wind for the region. For OUTAGE_LRC run and LOR run, wind generation is constrained by both System Normal and Outage constraints. All run types (OUTAGE_LRC, LOR) incorporate MAXAVAIL limits. This value is the same as SS_WIND_CAPACITY.',
   WDR_AVAILABLE        numeric(12,2)  comment 'Regional aggregated Wholesale Demand Response (WDR) availability in MW.',
   WDR_PASAAVAILABLE    numeric(12,2)  comment 'Regional aggregated Wholesale Demand Response (WDR) PASA availability in MW.',
   WDR_CAPACITY         numeric(12,2)  comment 'Regional aggregated Wholesale Demand Response (WDR) capacity in MW.'
);

alter table PDPASA_REGIONSOLUTION comment 'The PDPASA region solution data.Note that the OUTAGE_LRC Run';

alter table PDPASA_REGIONSOLUTION
   add primary key (RUN_DATETIME, RUNTYPE, INTERVAL_DATETIME, REGIONID);

/*==============================================================*/
/* Index: PDPASA_REGIONSOLUTION_LCX                             */
/*==============================================================*/
create index PDPASA_REGIONSOLUTION_LCX on PDPASA_REGIONSOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PD_FCAS_REQ_CONSTRAINT                                */
/*==============================================================*/
create table PD_FCAS_REQ_CONSTRAINT
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Predispatch sequence number for the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The 30 minute predispatch case run number that has triggers the constraint FCAS processor run',
   INTERVAL_DATETIME    datetime not null  comment 'The 30 minute interval date and time of the 30 minute predispatch interval that was processed by the constraint FCAS processor',
   CONSTRAINTID         varchar(20) not null  comment 'ConstraintID join to table GenConData',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   BIDTYPE              varchar(10) not null  comment 'DUID offered type',
   LHS                  numeric(15,5)  comment 'Constraints summed LHS - aggregate LHS Solution values from the physical run from the PREDISPATCHCONSTRAINT table',
   RHS                  numeric(15,5)  comment 'Constraints RHS value used in the solution - may be either dynamic (calculated) or static from the physical run from the PREDISPATCHCONSTRAINT table',
   MARGINALVALUE        numeric(15,5)  comment 'Shadow price of constraint from the PREDISPATCHCONSTRAINT table from the physical run.',
   RRP                  numeric(15,5)  comment 'Bid type prices for the region coming from the pricing run of the PREDISPATCHREGIONSUM table',
   REGIONAL_ENABLEMENT  numeric(15,5)  comment 'The dispatched MW for the bid type inside the region from the physical run of the PREDISPATCHREGIONSUM table',
   CONSTRAINT_ENABLEMENT numeric(15,5)  comment 'MW enabled for this bid type within the constraint',
   REGION_BASE_COST     numeric(18,8)  comment 'The regional payment allocated to the constraint for the interval pro-rated based on marginal value ratios over the binding constraints for that service in that region (this is an intermediate calculation to get to the base cost)',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, after the regulation/contingency split',
   P_REGULATION         numeric(18,8)  comment 'The adjusted marginal value of the constraint for FPP recovery (blank for constraints without REG terms)'
);

alter table PD_FCAS_REQ_CONSTRAINT comment 'The constraint level FCAS cost / price details for constrain';

alter table PD_FCAS_REQ_CONSTRAINT
   add primary key (PREDISPATCHSEQNO, RUN_DATETIME, RUNNO, INTERVAL_DATETIME, CONSTRAINTID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Table: PD_FCAS_REQ_RUN                                       */
/*==============================================================*/
create table PD_FCAS_REQ_RUN
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Predispatch sequence number for the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUN_DATETIME         datetime not null  comment 'The run date and time of the 30 minute predispatch case that triggers the constraint FCAS processor run',
   RUNNO                numeric(5,0) not null  comment 'The 30 minute predispatch case run number that has triggers the constraint FCAS processor run',
   LASTCHANGED          datetime  comment 'The last time the constraint FCAS processor was executed for this case run time.'
);

alter table PD_FCAS_REQ_RUN comment 'The constraint FCAS processor run details. This enhanced out';

alter table PD_FCAS_REQ_RUN
   add primary key (PREDISPATCHSEQNO, RUN_DATETIME, RUNNO);

/*==============================================================*/
/* Table: PD_INTERMITTENT_FCST_TRK                              */
/*==============================================================*/
create table PD_INTERMITTENT_FCST_TRK
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of Pre-dispatch run in the form YYYYMMDDPP with 01 at 04:30.',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier, tracks to INTERMITTENT_GEN_FCST_RUN.DUID.',
   FORECAST_RUN_DATETIME datetime  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime, unless a forecast run is missed, in this case the previous run is used. Tracks to INTERMITTENT_GEN_FCST_RUN.FORECAST_RUN_DATETIME.',
   PROVIDERID           varchar(20)  comment 'Provider of the forecast run used for the PD run, tracks to INTERMITTENT_GEN_FCST_RUN.PROVIDERID.',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Priority of the forecast run used for the PD run, tracks to INTERMITTENT_GEN_FCST_RUN.FORECAST_PRIORITY.',
   OFFERDATETIME        datetime  comment 'Submission datetime of the forecast run used for the PD run, tracks to INTERMITTENT_GEN_FCST_RUN.OFFERDATETIME.'
);

alter table PD_INTERMITTENT_FCST_TRK comment 'Uniquely tracks which Intermittent Generation forecast run (';

alter table PD_INTERMITTENT_FCST_TRK
   add primary key (PREDISPATCHSEQNO, DUID);

/*==============================================================*/
/* Table: PD_ROOFTOP_PV_FCST_TRK                                */
/*==============================================================*/
create table PD_ROOFTOP_PV_FCST_TRK
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of Pre-dispatch run in the form YYYYMMDDPP with 01 at 04:30.',
   AREAID               varchar(10) not null  comment 'Area identifier aligning with the load forecasting areas, tracks to ROOFTOP_PV_FCST_RUN.AREAID.',
   FORECAST_RUN_DATETIME datetime  comment 'Datetime (interval ending) when the forecast run is valid. It would align with run_datetime, unless a forecast run is missed, in this case the previous run will be used. Tracks to ROOFTOP_PV_FCST_RUN.FORECAST_RUN_DATETIME.',
   PROVIDERID           varchar(20)  comment 'Provider identifier of the forecast run used for the PD run, tracks to ROOFTOP_PV_FCST_RUN.PROVIDERID.',
   FORECAST_PRIORITY    numeric(10,0)  comment 'Priority of the forecast run used for the PD run, tracks to ROOFTOP_PV_FCST_RUN.FORECAST_PRIORITY.',
   OFFERDATETIME        datetime  comment 'Submission datetime of the forecast run used for the PD run, tracks to ROOFTOP_PV_FCST_RUN.OFFERDATETIME.'
);

alter table PD_ROOFTOP_PV_FCST_TRK comment 'Uniquely tracks which Rooftop PV forecast run (from ROOFTOP_';

alter table PD_ROOFTOP_PV_FCST_TRK
   add primary key (PREDISPATCHSEQNO, AREAID);

/*==============================================================*/
/* Table: PERDEMAND                                             */
/*==============================================================*/
create table PERDEMAND
(
   EFFECTIVEDATE        datetime  comment 'Market date the forecast is made for. First date of the 7 days.',
   SETTLEMENTDATE       datetime not null  comment 'Market date of forecast up to 7 days ahead.',
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   OFFERDATE            datetime not null  comment 'Date record issued',
   PERIODID             numeric(3,0) not null  comment 'Half hourly trading intervals from 04:30.',
   VERSIONNO            numeric(3,0) not null  comment 'The version of the RESDEMAND file for this date',
   RESDEMAND            numeric(10,0)  comment 'Base Demand forecast for period',
   DEMAND90PROBABILITY  numeric(10,0)  comment 'Demand at 90% probability of exceedance',
   DEMAND10PROBABILITY  numeric(10,0)  comment 'Demand level for a 10% probability of exceedance',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   MR_SCHEDULE          numeric(6,0)  comment 'MR_Schedule = Unrestricted Demand - POE'
);

alter table PERDEMAND comment 'PERDEMAND sets out the regional demands and MR schedule data';

alter table PERDEMAND
   add primary key (SETTLEMENTDATE, REGIONID, OFFERDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: PERDEMAND_LCX                                         */
/*==============================================================*/
create index PERDEMAND_LCX on PERDEMAND
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PEROFFER                                              */
/*==============================================================*/
create table PEROFFER
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:00am',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   OFFERDATE            datetime not null  comment 'Offer date made',
   PERIODID             numeric(3,0) not null  comment 'Period identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of offer',
   SELFDISPATCH         numeric(12,6)  comment 'Not used',
   MAXAVAIL             numeric(12,6)  comment 'Maximum plant availability',
   FIXEDLOAD            numeric(12,6)  comment 'Fixed unit output MW. A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   ROCUP                numeric(6,0)  comment 'MW/min for raise',
   ROCDOWN              numeric(6,0)  comment 'MW/Min for lower',
   BANDAVAIL1           numeric(6,0)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(6,0)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(6,0)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(6,0)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(6,0)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(6,0)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(6,0)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(6,0)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(6,0)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(6,0)  comment 'Availability at price band 10',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PASAAVAILABILITY     numeric(12,0)  comment 'The physical plant capability including any capability potentially available within 24 hours.',
   MR_CAPACITY          numeric(6,0)  comment 'Mandatory Restriction Offer amount'
);

alter table PEROFFER comment 'PEROFFER contains the half-hourly period details of daily bi';

alter table PEROFFER
   add primary key (SETTLEMENTDATE, DUID, OFFERDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: PEROFFER_NDX2                                         */
/*==============================================================*/
create index PEROFFER_NDX2 on PEROFFER
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: PEROFFER_LCX                                          */
/*==============================================================*/
create index PEROFFER_LCX on PEROFFER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PEROFFER_D                                            */
/*==============================================================*/
create table PEROFFER_D
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:00am',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   OFFERDATE            datetime not null  comment 'Offer date made',
   PERIODID             numeric(3,0) not null  comment 'Period identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of offer',
   SELFDISPATCH         numeric(12,6)  comment 'Not used',
   MAXAVAIL             numeric(12,6)  comment 'Maximum plant availability',
   FIXEDLOAD            numeric(12,6)  comment 'Fixed unit output MW. A value of zero means no fixed load so the unit is dispatched according to bid and market (rather than zero fixed load)',
   ROCUP                numeric(6,0)  comment 'MW/min for raise',
   ROCDOWN              numeric(6,0)  comment 'MW/Min for lower',
   BANDAVAIL1           numeric(6,0)  comment 'Availability at price band 1',
   BANDAVAIL2           numeric(6,0)  comment 'Availability at price band 2',
   BANDAVAIL3           numeric(6,0)  comment 'Availability at price band 3',
   BANDAVAIL4           numeric(6,0)  comment 'Availability at price band 4',
   BANDAVAIL5           numeric(6,0)  comment 'Availability at price band 5',
   BANDAVAIL6           numeric(6,0)  comment 'Availability at price band 6',
   BANDAVAIL7           numeric(6,0)  comment 'Availability at price band 7',
   BANDAVAIL8           numeric(6,0)  comment 'Availability at price band 8',
   BANDAVAIL9           numeric(6,0)  comment 'Availability at price band 9',
   BANDAVAIL10          numeric(6,0)  comment 'Availability at price band 10',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PASAAVAILABILITY     numeric(12,0)  comment 'The physical plant capability including any capability potentially available within 24 hours.',
   MR_CAPACITY          numeric(6,0)  comment 'Mandatory Restriction Offer amount'
);

alter table PEROFFER_D comment 'PEROFFER_D contains the half-hourly period details of daily ';

alter table PEROFFER_D
   add primary key (SETTLEMENTDATE, DUID, OFFERDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: PEROFFER_D_NDX2                                       */
/*==============================================================*/
create index PEROFFER_D_NDX2 on PEROFFER_D
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: PEROFFER_D_LCX                                        */
/*==============================================================*/
create index PEROFFER_D_LCX on PEROFFER_D
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PMS_GROUP                                             */
/*==============================================================*/
create table PMS_GROUP
(
   GROUPID              numeric(20,0) not null  comment 'Abstract identifier for the group',
   CREATEDDATE          datetime(3)  comment 'Date record was created',
   LASTCHANGED          datetime(3)  comment 'Date record was last changed'
);

alter table PMS_GROUP comment 'Entity table for group';

alter table PMS_GROUP
   add primary key (GROUPID);

/*==============================================================*/
/* Table: PMS_GROUPNMI                                          */
/*==============================================================*/
create table PMS_GROUPNMI
(
   GROUPNMIID           numeric(20,0) not null  comment 'Record Identifier of the NMI within a Group. When data is updated, existing record identifier is terminated, and new record identifier(s) are allocated.',
   GROUPID              numeric(20,0)  comment 'Group id of the Group which the NMI belongs in.',
   VERSIONFROM          datetime(3)  comment 'Date for which this version is effective from',
   VERSIONTO            datetime(3)  comment 'Date for which this version is effective to. Will be set to current day plus one if it is the current active record or past date if the record has been superseded/ended.',
   STARTDATE            datetime(3)  comment 'Effective date of when this service started operation',
   ENDDATE              datetime(3)  comment 'Date for which this version is effective to. Will be set to current day plus one if it is the current active record or past date if the record has been superseded/ended.',
   NMI                  varchar(20)  comment 'National Meter Identifier linked to the group.',
   SITENAME             varchar(50)  comment 'Site name',
   NERRGROUPPREMISES    numeric(1,0)  comment 'Specifies whether NMI is in a NERR aggregated premises (TRUE = 1/FALSE = 0)',
   BASELINEMETHODOLOGYID varchar(50)  comment 'Baseline methodology to be used for the PoL and Baseline assessment of the NMI',
   MRC                  numeric(10,3)  comment 'Maximum responsive component for the NMI',
   MRCREASON            varchar(500)  comment 'Reason for the MRC',
   RETAILCUSTOMER       varchar(50)  comment 'Retail customer of the NMI',
   SUSPENDED            numeric(1,0)  comment 'Indicates whether the NMI has been suspended from use. (TRUE = 1/FALSE = 0)',
   UNAVAILABLE          numeric(1,0)  comment 'Indicates whether the NMI is unavailable for use. (TRUE = 1/FALSE = 0)',
   APPROVEDDATE         datetime(3)  comment 'Date which this record was approved',
   LASTCHANGED          datetime(3)  comment 'Date time which record was last changed'
);

alter table PMS_GROUPNMI comment 'Describe the NMIs that a group uses to provide its service';

alter table PMS_GROUPNMI
   add primary key (GROUPNMIID);

/*==============================================================*/
/* Index: PMS_GROUPNMI_IDX                                      */
/*==============================================================*/
create index PMS_GROUPNMI_IDX on PMS_GROUPNMI
(
   GROUPID,
   NMI
);

/*==============================================================*/
/* Table: PMS_GROUPSERVICE                                      */
/*==============================================================*/
create table PMS_GROUPSERVICE
(
   GROUPSERVICEID       numeric(20,0) not null  comment 'Record identifier of the Service allocated to the Group. When data is updated, existing record identifier is terminated, and new record identifier(s) are allocated.',
   GROUPID              numeric(20,0)  comment 'Group id of the Group where the Service is attached to.',
   VERSIONFROM          datetime(3)  comment 'Date for which this version is effective from.',
   VERSIONTO            datetime(3)  comment 'Date for which this version is effective to. Will be set to max date 9999/12/31 23:59:59.999 until this version ends or a change to the version is required.',
   STARTDATE            datetime(3)  comment 'Effective date of when this service started operation',
   ENDDATE              datetime(3)  comment 'Effective date of when this service ended operation. Will be set to max date 9999/12/31 23:59:59.999 until its service ends or a change to the service is required.',
   MARKET               varchar(50)  comment 'Market that this group is operating its service in. Will only be NEM initially.',
   SERVICETYPE          varchar(50)  comment 'Service that this group is operating. Will be only be ENERGY initially',
   ENTITYTYPE           varchar(50)  comment 'Describes the entity that is operating. Will only be WDRU initially.',
   ENTITYID             varchar(50)  comment 'Describe the entity ID in the market that it will be operating in. Will only contain the DUID of the group initially.',
   MRC                  numeric(10,3)  comment 'Maximum responsive component for the service offering',
   MRCREASON            varchar(500)  comment 'Reason for the MRC.',
   MAXIMUMRAMPRATEPERMIN numeric(10,0)  comment 'Maximum ramp rate MW per minute of the service.',
   REGION               varchar(20)  comment 'Region the group is operating this service in One of NSW1, QLD1, VIC1, SA1 or TAS1',
   APPROVEDDATE         datetime(3)  comment 'Date which this record was approved',
   LASTCHANGED          datetime(3)  comment 'Date time which record was last changed'
);

alter table PMS_GROUPSERVICE comment 'Describe the services a group provides and its relation to a';

alter table PMS_GROUPSERVICE
   add primary key (GROUPSERVICEID);

/*==============================================================*/
/* Index: PMS_GROUPSERVICE_IDX                                  */
/*==============================================================*/
create index PMS_GROUPSERVICE_IDX on PMS_GROUPSERVICE
(
   ENTITYID,
   GROUPID
);

/*==============================================================*/
/* Table: PREDISPATCHBIDTRK                                     */
/*==============================================================*/
create table PREDISPATCHBIDTRK
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   PERIODID             varchar(20) not null  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   BIDTYPE              varchar(10)  comment 'Bid type (daily, default or rebid)',
   OFFERDATE            datetime  comment 'Offer date for bid',
   VERSIONNO            numeric(3,0)  comment 'Version no of offer for the offer date',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SETTLEMENTDATE       datetime  comment 'Market Settlement Date',
   DATETIME             datetime  comment 'Period date and time'
);

alter table PREDISPATCHBIDTRK comment 'PREDISPATCHBIDTRK contains an audit trail of bids used in ea';

alter table PREDISPATCHBIDTRK
   add primary key (PREDISPATCHSEQNO, DUID, PERIODID);

/*==============================================================*/
/* Index: PREDISPATCHBIDTRK_LCX                                 */
/*==============================================================*/
create index PREDISPATCHBIDTRK_LCX on PREDISPATCHBIDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: PREDISPATCHBIDTRK_NDX2                                */
/*==============================================================*/
create index PREDISPATCHBIDTRK_NDX2 on PREDISPATCHBIDTRK
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: PREDISPATCHBIDTRK_NDX3                                */
/*==============================================================*/
create index PREDISPATCHBIDTRK_NDX3 on PREDISPATCHBIDTRK
(
   DUID,
   SETTLEMENTDATE
);

/*==============================================================*/
/* Table: PREDISPATCHBLOCKEDCONSTRAINT                          */
/*==============================================================*/
create table PREDISPATCHBLOCKEDCONSTRAINT
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   CONSTRAINTID         varchar(20) not null  comment 'Generic Constraint identifier (synonymous with GenConID)'
);

alter table PREDISPATCHBLOCKEDCONSTRAINT comment 'PREDISPATCH Blocked Constraints lists any constraints that w';

alter table PREDISPATCHBLOCKEDCONSTRAINT
   add primary key (PREDISPATCHSEQNO, CONSTRAINTID);

/*==============================================================*/
/* Table: PREDISPATCHCASESOLUTION                               */
/*==============================================================*/
create table PREDISPATCHCASESOLUTION
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0) not null  comment 'Predispatch run no, normally 1.',
   SOLUTIONSTATUS       numeric(2,0)  comment 'If non-zero indicated one of the following conditions: 1 = Supply Scarcity, Excess generation or constraint violations, -X = Model failure',
   SPDVERSION           varchar(20)  comment 'Current version of SPD',
   NONPHYSICALLOSSES    numeric(1,0)  comment 'Non-Physical Losses algorithm invoked during this run',
   TOTALOBJECTIVE       numeric(27,10)  comment 'The Objective function from the LP',
   TOTALAREAGENVIOLATION numeric(15,5)  comment 'Total Region Demand violations',
   TOTALINTERCONNECTORVIOLATION numeric(15,5)  comment 'Total interconnector violations',
   TOTALGENERICVIOLATION numeric(15,5)  comment 'Total generic constraint violations',
   TOTALRAMPRATEVIOLATION numeric(15,5)  comment 'Total ramp rate violations',
   TOTALUNITMWCAPACITYVIOLATION numeric(15,5)  comment 'Total unit capacity violations',
   TOTAL5MINVIOLATION   numeric(15,5)  comment 'Total of 5 minute ancillary service region violations',
   TOTALREGVIOLATION    numeric(15,5)  comment 'Total of Regulation ancillary service region violations',
   TOTAL6SECVIOLATION   numeric(15,5)  comment 'Total of 6 second ancillary service region violations',
   TOTAL60SECVIOLATION  numeric(15,5)  comment 'Total of 60 second ancillary service region violations',
   TOTALASPROFILEVIOLATION numeric(15,5)  comment 'Total of ancillary service trader profile violations',
   TOTALENERGYCONSTRVIOLATION numeric(15,5)  comment 'Total of Energy Constrained unit offer violations.',
   TOTALENERGYOFFERVIOLATION numeric(15,5)  comment 'Total of unit summated offer band violations',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this Pre-Dispatch case includes an intervention pricing run: 0 = case does not include an intervention pricing run, 1 = case does include an intervention pricing run. This field has a default value of 0 and is not nullable'
);

alter table PREDISPATCHCASESOLUTION comment 'PREDISPATCHCASESOLUTION provides information relating to the';

alter table PREDISPATCHCASESOLUTION
   add primary key (PREDISPATCHSEQNO, RUNNO);

/*==============================================================*/
/* Index: PREDISPATCHCASESOL_NDX_LCHD                           */
/*==============================================================*/
create index PREDISPATCHCASESOL_NDX_LCHD on PREDISPATCHCASESOLUTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHCONSTRAINT                                 */
/*==============================================================*/
create table PREDISPATCHCONSTRAINT
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'SPD Predispatch run no, typically 1. It increments if the case is re-run.',
   CONSTRAINTID         varchar(20) not null  comment 'Generic constraint identifier',
   PERIODID             varchar(20)  comment 'Unique period identifier, in the format yyyymmddpp. The period (pp) is 01 to 48, with 01 corresponding to the half-hour ending at 04:30am.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   RHS                  numeric(15,5)  comment 'RHS value used.',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal value of violated constraint',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Degree of constraint violation',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime not null  comment 'Period date and time',
   DUID                 varchar(20)  comment 'DUID to which the Constraint is confidential. Null denotes non-confidential',
   GENCONID_EFFECTIVEDATE datetime  comment 'Effective date of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   GENCONID_VERSIONNO   numeric(22,0)  comment 'Version number of the Generic Constraint (ConstraintID). This field is used to track the version of this generic constraint applied in this dispatch interval',
   LHS                  numeric(15,5)  comment 'Aggregation of the constraints LHS term solution values'
);

alter table PREDISPATCHCONSTRAINT comment 'PREDISPATCHCONSTRAINT sets out constraints that are binding ';

alter table PREDISPATCHCONSTRAINT
   add primary key (DATETIME, CONSTRAINTID);

/*==============================================================*/
/* Index: PREDISPATCHCONSTRAIN_NDX2                             */
/*==============================================================*/
create index PREDISPATCHCONSTRAIN_NDX2 on PREDISPATCHCONSTRAINT
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Index: PREDISPATCHCONSTRAINT_LCX                             */
/*==============================================================*/
create index PREDISPATCHCONSTRAINT_LCX on PREDISPATCHCONSTRAINT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHINTERCONNECTORRES                          */
/*==============================================================*/
create table PREDISPATCHINTERCONNECTORRES
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'SPD Predispatch run no, typically 1. It increments if the case is re-run.',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector identifier',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   METEREDMWFLOW        numeric(15,5)  comment 'Metered MW Flow from EMS. For periods subsequent to the first period of a Pre-Dispatch run, this value represents the cleared target for the previous period of that Pre-Dispatch run.',
   MWFLOW               numeric(15,5)  comment 'Calculated MW Flow',
   MWLOSSES             numeric(15,5)  comment 'Calculated MW Losses',
   MARGINALVALUE        numeric(15,5)  comment '$ Marginal value of interconnector constraint from SPD',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Degree of violation of interconnector constraint in MW',
   LASTCHANGED          datetime  comment 'Last changed.',
   DATETIME             datetime not null  comment 'Period date and time',
   EXPORTLIMIT          numeric(15,5)  comment 'Calculated export limit.',
   IMPORTLIMIT          numeric(15,5)  comment 'Calculated import limit.',
   MARGINALLOSS         numeric(15,5)  comment 'Marginal loss factor. Use this to adjust bids between reports.',
   EXPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the export limit',
   IMPORTGENCONID       varchar(20)  comment 'Generic Constraint setting the import limit',
   FCASEXPORTLIMIT      numeric(15,5)  comment 'Calculated export limit applying to energy + FCAS.',
   FCASIMPORTLIMIT      numeric(15,5)  comment 'Calculated import limit applying to energy + FCAS.',
   LOCAL_PRICE_ADJUSTMENT_EXPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Export (Factor >= 0)',
   LOCALLY_CONSTRAINED_EXPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Export: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LOCAL_PRICE_ADJUSTMENT_IMPORT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this Interconnector: Sum(MarginalValue x Factor) for all relevant Constraints, for Import (Factor >= 0)',
   LOCALLY_CONSTRAINED_IMPORT numeric(1,0)  comment 'Key for Local_Price_Adjustment_Import: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints'
);

alter table PREDISPATCHINTERCONNECTORRES comment 'PREDISPATCHINTERCONNECTORRES records Interconnector flows an';

alter table PREDISPATCHINTERCONNECTORRES
   add primary key (DATETIME, INTERCONNECTORID);

/*==============================================================*/
/* Index: PREDISPATCHINTERCONNECTOR_LCX                         */
/*==============================================================*/
create index PREDISPATCHINTERCONNECTOR_LCX on PREDISPATCHINTERCONNECTORRES
(
   LASTCHANGED
);

/*==============================================================*/
/* Index: PREDISPATCHINTCONRES_NDX3                             */
/*==============================================================*/
create index PREDISPATCHINTCONRES_NDX3 on PREDISPATCHINTERCONNECTORRES
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Table: PREDISPATCHINTERSENSITIVITIES                         */
/*==============================================================*/
create table PREDISPATCHINTERSENSITIVITIES
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'LP Solver Predispatch run no, typically 1. It increments if the case is re-run.',
   INTERCONNECTORID     varchar(10) not null  comment 'Unique interconnector identifier',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   DATETIME             datetime not null  comment 'Period date and time',
   INTERVENTION_ACTIVE  numeric(1,0)  comment 'Flag to indicate if the sensitivity run contains an active intervention constraint: 0 = No, 1 = Yes',
   MWFLOW1              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 1',
   MWFLOW2              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 2',
   MWFLOW3              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 3',
   MWFLOW4              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 4',
   MWFLOW5              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 5',
   MWFLOW6              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 6',
   MWFLOW7              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 7',
   MWFLOW8              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 8',
   MWFLOW9              numeric(15,5)  comment 'MW flow for given Interconnector for scenario 9',
   MWFLOW10             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 10',
   MWFLOW11             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 11',
   MWFLOW12             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 12',
   MWFLOW13             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 13',
   MWFLOW14             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 14',
   MWFLOW15             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 15',
   MWFLOW16             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 16',
   MWFLOW17             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 17',
   MWFLOW18             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 18',
   MWFLOW19             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 19',
   MWFLOW20             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 20',
   MWFLOW21             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 21',
   MWFLOW22             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 22',
   MWFLOW23             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 23',
   MWFLOW24             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 24',
   MWFLOW25             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 25',
   MWFLOW26             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 26',
   MWFLOW27             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 27',
   MWFLOW28             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 28',
   MWFLOW29             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 29',
   MWFLOW30             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 30',
   MWFLOW31             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 31',
   MWFLOW32             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 32',
   MWFLOW33             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 33',
   MWFLOW34             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 34',
   MWFLOW35             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 35',
   MWFLOW36             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 36',
   MWFLOW37             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 37',
   MWFLOW38             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 38',
   MWFLOW39             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 39',
   MWFLOW40             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 40',
   MWFLOW41             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 41',
   MWFLOW42             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 42',
   MWFLOW43             numeric(15,5)  comment 'MW flow for given Interconnector for scenario 43',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PREDISPATCHINTERSENSITIVITIES comment 'PREDISPATCHINTERSENSITIVITIES sets out the sensitivity flows';

alter table PREDISPATCHINTERSENSITIVITIES
   add primary key (INTERCONNECTORID, DATETIME);

/*==============================================================*/
/* Index: PREDISPATCHINTERSENSITIVIT_LCX                        */
/*==============================================================*/
create index PREDISPATCHINTERSENSITIVIT_LCX on PREDISPATCHINTERSENSITIVITIES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHLOAD                                       */
/*==============================================================*/
create table PREDISPATCHLOAD
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'SPD Predispatch run no, typically 1. It increments if the case is re-run.',
   DUID                 varchar(10) not null  comment 'Dispatchable unit identifier for fast start',
   TRADETYPE            numeric(2,0)  comment 'Not used',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   CONNECTIONPOINTID    varchar(12)  comment 'Connection point identifier',
   AGCSTATUS            numeric(2,0)  comment 'AGC Status from EMS',
   DISPATCHMODE         numeric(2,0)  comment 'Dispatch mode of unit for fast start (1-4)',
   INITIALMW            numeric(15,5)  comment 'Initial MW at start of first period. For periods subsequent to the first period of a Pre-Dispatch run, this value represents the cleared target for the previous period of that Pre-Dispatch run. Negative values when Bi-directional Unit start from importing power, otherwise positive.',
   TOTALCLEARED         numeric(15,5)  comment 'Target MW for end of period. Negative values when Bi-directional Unit is importing power, otherwise positive.',
   LOWER5MIN            numeric(15,5)  comment 'Lower 5 min MW target in period',
   LOWER60SEC           numeric(15,5)  comment 'Lower 60 sec MW target in period',
   LOWER6SEC            numeric(15,5)  comment 'Lower 6 sec MW target in period',
   RAISE5MIN            numeric(15,5)  comment 'Raise 5 min MW target in period',
   RAISE60SEC           numeric(15,5)  comment 'Raise 60 sec MW target in period',
   RAISE6SEC            numeric(15,5)  comment 'Raise 6 sec MW target in period',
   RAMPDOWNRATE         numeric(15,5)  comment 'Ramp down rate in period in MW/minute',
   RAMPUPRATE           numeric(15,5)  comment 'Ramp up rate in period in MW/minute',
   DOWNEPF              numeric(15,5)  comment 'Not used in Pre-Dispatch',
   UPEPF                numeric(15,5)  comment 'Not used in Pre-Dispatch',
   MARGINAL5MINVALUE    numeric(15,5)  comment 'Marginal $ value for 5 min from LP Solver',
   MARGINAL60SECVALUE   numeric(15,5)  comment 'Marginal $ value for 60 seconds from LP Solver',
   MARGINAL6SECVALUE    numeric(15,5)  comment 'Marginal $ value for 6 seconds from LP Solver',
   MARGINALVALUE        numeric(15,5)  comment 'Marginal $ value for energy from LP Solver',
   VIOLATION5MINDEGREE  numeric(15,5)  comment 'Violation MW 5 min',
   VIOLATION60SECDEGREE numeric(15,5)  comment 'Violation MW 60 seconds',
   VIOLATION6SECDEGREE  numeric(15,5)  comment 'Violation MW 6 seconds',
   VIOLATIONDEGREE      numeric(15,5)  comment 'Violation MW energy',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime not null  comment 'Period date and time',
   LOWERREG             numeric(15,5)  comment 'Lower Regulation reserve target',
   RAISEREG             numeric(15,5)  comment 'Raise Regulation reserve target',
   AVAILABILITY         numeric(15,5)  comment 'For Scheduled units, this is the MAXAVAIL bid availability For Semi-scheduled units, this is the lower of MAXAVAIL bid availability and UIGF',
   RAISE6SECFLAGS       numeric(3,0)  comment 'Raise 6sec status flag',
   RAISE60SECFLAGS      numeric(3,0)  comment 'Raise 60sec status flag',
   RAISE5MINFLAGS       numeric(3,0)  comment 'Raise 5min status flag',
   RAISEREGFLAGS        numeric(3,0)  comment 'Raise reg status flag',
   LOWER6SECFLAGS       numeric(3,0)  comment 'Lower 6sec status flag',
   LOWER60SECFLAGS      numeric(3,0)  comment 'Lower 60sec status flag',
   LOWER5MINFLAGS       numeric(3,0)  comment 'Lower 5min status flag',
   LOWERREGFLAGS        numeric(3,0)  comment 'Lower Reg status flag',
   RAISE6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 6sec availability',
   RAISE60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 60sec availability',
   RAISE5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 5min availability',
   RAISEREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise reg availability',
   LOWER6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 6sec availability',
   LOWER60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 60sec availability',
   LOWER5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 5min availability',
   LOWERREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower reg availability',
   SEMIDISPATCHCAP      numeric(3,0)  comment 'Boolean representation flagging if the Target is Capped',
   CONFORMANCE_MODE     numeric(6,0)  comment 'Mode specific to units within an aggregate. 0 - no monitoring, 1 - aggregate monitoring, 2 - individual monitoring due to constraint',
   UIGF                 numeric(15,5)  comment 'For Semi-Scheduled units. Unconstrained Intermittent Generation Forecast value provided to NEMDE',
   RAISE1SEC            numeric(15,5)  comment 'Dispatched Raise1Sec - TraderSolution element R1Target attribute',
   RAISE1SECFLAGS       numeric(3,0)  comment 'TraderSolution element R1Flags attribute',
   LOWER1SEC            numeric(15,5)  comment 'Dispatched Lower1Sec - TraderSolution element L1Target attribute',
   LOWER1SECFLAGS       numeric(3,0)  comment 'TraderSolution element L1Flags attribute',
   RAISE1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Raise 1Sec Availability',
   LOWER1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Lower 1Sec Availability',
   INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'The energy storage at the start of this dispatch interval(MWh)',
   ENERGY_STORAGE       numeric(15,5)  comment 'The projected energy storage based on cleared energy and regulation FCAS dispatch(MWh)',
   ENERGY_STORAGE_MIN   numeric(15,5)  comment 'BDU only - Minimum Energy Storage constraint limit (MWh)',
   ENERGY_STORAGE_MAX   numeric(15,5)  comment 'BDU only - Maximum Energy Storage constraint limit (MWh)',
   MIN_AVAILABILITY     numeric(15,5)  comment 'BDU only. Load side availability (BidOfferPeriod.MAXAVAIL where DIRECTION = LOAD)',
   ELEMENT_CAP          numeric(5,0)  comment 'Cap on the number of turbines or inverters at a DUID.'
);

alter table PREDISPATCHLOAD comment 'PREDISPATCHLOAD shows pre-dispatch targets for each dispatch';

alter table PREDISPATCHLOAD
   add primary key (DATETIME, DUID);

/*==============================================================*/
/* Index: PREDISPATCHLOAD_NDX2                                  */
/*==============================================================*/
create index PREDISPATCHLOAD_NDX2 on PREDISPATCHLOAD
(
   DUID,
   LASTCHANGED
);

/*==============================================================*/
/* Index: PREDISPATCHLOAD_NDX3                                  */
/*==============================================================*/
create index PREDISPATCHLOAD_NDX3 on PREDISPATCHLOAD
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Index: PREDISPATCHLOAD_LCX                                   */
/*==============================================================*/
create index PREDISPATCHLOAD_LCX on PREDISPATCHLOAD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHOFFERTRK                                   */
/*==============================================================*/
create table PREDISPATCHOFFERTRK
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   BIDTYPE              varchar(20) not null  comment 'Bid type Identifier - the ancillary service to which the bid applies',
   PERIODID             varchar(20) not null  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   BIDSETTLEMENTDATE    datetime  comment 'Settlement date of bid applied',
   BIDOFFERDATE         datetime(3)  comment 'Time this bid was processed and loaded',
   DATETIME             datetime  comment 'Period date and time',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PREDISPATCHOFFERTRK comment 'PREDISPATCHOFFERTRK is for the ancillary service bid trackin';

alter table PREDISPATCHOFFERTRK
   add primary key (PREDISPATCHSEQNO, DUID, BIDTYPE, PERIODID);

/*==============================================================*/
/* Index: PREDISPATCHOFFERTRK_LCHD_IDX                          */
/*==============================================================*/
create index PREDISPATCHOFFERTRK_LCHD_IDX on PREDISPATCHOFFERTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHPRICE                                      */
/*==============================================================*/
create table PREDISPATCHPRICE
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'LP Solver Predispatch run no, typically 1. It increments if the case is re-run.',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   EEP                  numeric(15,5)  comment 'Excess energy price',
   RRP1                 numeric(15,5)  comment 'Not used',
   EEP1                 numeric(15,5)  comment 'Not used',
   RRP2                 numeric(15,5)  comment 'Not used',
   EEP2                 numeric(15,5)  comment 'Not used',
   RRP3                 numeric(15,5)  comment 'Not used',
   EEP3                 numeric(15,5)  comment 'Not used',
   RRP4                 numeric(15,5)  comment 'Not used',
   EEP4                 numeric(15,5)  comment 'Not used',
   RRP5                 numeric(15,5)  comment 'Not used',
   EEP5                 numeric(15,5)  comment 'Not used',
   RRP6                 numeric(15,5)  comment 'Not used',
   EEP6                 numeric(15,5)  comment 'Not used',
   RRP7                 numeric(15,5)  comment 'Not used',
   EEP7                 numeric(15,5)  comment 'Not used',
   RRP8                 numeric(15,5)  comment 'Not used',
   EEP8                 numeric(15,5)  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime not null  comment 'Period date and time',
   RAISE6SECRRP         numeric(15,5)  comment 'Regional reference price for this dispatch period',
   RAISE60SECRRP        numeric(15,5)  comment 'Regional reference price for this dispatch period',
   RAISE5MINRRP         numeric(15,5)  comment 'Regional reference price for this dispatch period',
   RAISEREGRRP          numeric(15,5)  comment 'Regional reference price for this dispatch period',
   LOWER6SECRRP         numeric(15,5)  comment 'Regional reference price for this dispatch period',
   LOWER60SECRRP        numeric(15,5)  comment 'Regional reference price for this dispatch period',
   LOWER5MINRRP         numeric(15,5)  comment 'Regional reference price for this dispatch period',
   LOWERREGRRP          numeric(15,5)  comment 'Regional reference price for this dispatch period',
   RAISE1SECRRP         numeric(15,5)  comment 'Regional Raise 1Sec Price - R1Price attribute after capping /flooring',
   LOWER1SECRRP         numeric(15,5)  comment 'Regional Lower 1Sec Price - RegionSolution element L1Price attribute'
);

alter table PREDISPATCHPRICE comment 'PREDISPATCHPRICE records predispatch prices for each region ';

alter table PREDISPATCHPRICE
   add primary key (DATETIME, REGIONID);

/*==============================================================*/
/* Index: PREDISPATCHPRICE_NDX3                                 */
/*==============================================================*/
create index PREDISPATCHPRICE_NDX3 on PREDISPATCHPRICE
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Index: PREDISPATCHPRICE_LCX                                  */
/*==============================================================*/
create index PREDISPATCHPRICE_LCX on PREDISPATCHPRICE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHPRICESENSITIVITIES                         */
/*==============================================================*/
create table PREDISPATCHPRICESENSITIVITIES
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'LP Solver Predispatch run no, typically 1. It increments if the case is re-run.',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   RRPEEP1              numeric(15,5)  comment 'Regional Energy Price for scenario 1',
   RRPEEP2              numeric(15,5)  comment 'Regional Energy Price for scenario 2',
   RRPEEP3              numeric(15,5)  comment 'Regional Energy Price for scenario 3',
   RRPEEP4              numeric(15,5)  comment 'Regional Energy Price for scenario 4',
   RRPEEP5              numeric(15,5)  comment 'Regional Energy Price for scenario 5',
   RRPEEP6              numeric(15,5)  comment 'Regional Energy Price for scenario 6',
   RRPEEP7              numeric(15,5)  comment 'Regional Energy Price for scenario 7',
   RRPEEP8              numeric(15,5)  comment 'Regional Energy Price for scenario 8',
   RRPEEP9              numeric(15,5)  comment 'Regional Energy Price for scenario 9',
   RRPEEP10             numeric(15,5)  comment 'Regional Energy Price for scenario 10',
   RRPEEP11             numeric(15,5)  comment 'Regional Energy Price for scenario 11',
   RRPEEP12             numeric(15,5)  comment 'Regional Energy Price for scenario 12',
   RRPEEP13             numeric(15,5)  comment 'Regional Energy Price for scenario 13',
   RRPEEP14             numeric(15,5)  comment 'Regional Energy Price for scenario 14',
   RRPEEP15             numeric(15,5)  comment 'Regional Energy Price for scenario 15',
   RRPEEP16             numeric(15,5)  comment 'Regional Energy Price for scenario 16',
   RRPEEP17             numeric(15,5)  comment 'Regional Energy Price for scenario 17',
   RRPEEP18             numeric(15,5)  comment 'Regional Energy Price for scenario 18',
   RRPEEP19             numeric(15,5)  comment 'Regional Energy Price for scenario 19',
   RRPEEP20             numeric(15,5)  comment 'Regional Energy Price for scenario 20',
   RRPEEP21             numeric(15,5)  comment 'Regional Energy Price for scenario 21',
   RRPEEP22             numeric(15,5)  comment 'Regional Energy Price for scenario 22',
   RRPEEP23             numeric(15,5)  comment 'Regional Energy Price for scenario 23',
   RRPEEP24             numeric(15,5)  comment 'Regional Energy Price for scenario 24',
   RRPEEP25             numeric(15,5)  comment 'Regional Energy Price for scenario 25',
   RRPEEP26             numeric(15,5)  comment 'Regional Energy Price for scenario 26',
   RRPEEP27             numeric(15,5)  comment 'Regional Energy Price for scenario 27',
   RRPEEP28             numeric(15,5)  comment 'Regional Energy Price for scenario 28',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DATETIME             datetime not null  comment 'Period date and time',
   RRPEEP29             numeric(15,5)  comment 'Regional Energy Price for scenario 29',
   RRPEEP30             numeric(15,5)  comment 'Regional Energy Price for scenario 30',
   RRPEEP31             numeric(15,5)  comment 'Regional Energy Price for scenario 31',
   RRPEEP32             numeric(15,5)  comment 'Regional Energy Price for scenario 32',
   RRPEEP33             numeric(15,5)  comment 'Regional Energy Price for scenario 33',
   RRPEEP34             numeric(15,5)  comment 'Regional Energy Price for scenario 34',
   RRPEEP35             numeric(15,5)  comment 'Regional Energy Price for scenario 35',
   INTERVENTION_ACTIVE  numeric(1,0)  comment 'Flag to indicate if the sensitivity run contains an active intervention constraint: 0 = No, 1 = Yes',
   RRPEEP36             numeric(15,5)  comment 'Regional Energy Price for scenario 36',
   RRPEEP37             numeric(15,5)  comment 'Regional Energy Price for scenario 37',
   RRPEEP38             numeric(15,5)  comment 'Regional Energy Price for scenario 38',
   RRPEEP39             numeric(15,5)  comment 'Regional Energy Price for scenario 39',
   RRPEEP40             numeric(15,5)  comment 'Regional Energy Price for scenario 40',
   RRPEEP41             numeric(15,5)  comment 'Regional Energy Price for scenario 41',
   RRPEEP42             numeric(15,5)  comment 'Regional Energy Price for scenario 42',
   RRPEEP43             numeric(15,5)  comment 'Regional Energy Price for scenario 43'
);

alter table PREDISPATCHPRICESENSITIVITIES comment 'PREDISPATCHPRICESENSITIVITIES sets out the sensitivity price';

alter table PREDISPATCHPRICESENSITIVITIES
   add primary key (DATETIME, REGIONID);

/*==============================================================*/
/* Index: PREDISPATCHPRCESENS_NDX3                              */
/*==============================================================*/
create index PREDISPATCHPRCESENS_NDX3 on PREDISPATCHPRICESENSITIVITIES
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Index: PREDISPATCHPRICESENSITIVI_LCX                         */
/*==============================================================*/
create index PREDISPATCHPRICESENSITIVI_LCX on PREDISPATCHPRICESENSITIVITIES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHREGIONSUM                                  */
/*==============================================================*/
create table PREDISPATCHREGIONSUM
(
   PREDISPATCHSEQNO     varchar(20)  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   RUNNO                numeric(3,0)  comment 'LP Solver Pre-Dispatch run no, typically 1. It increments if the case is re-run.',
   REGIONID             varchar(10) not null  comment 'Unique region identifier',
   PERIODID             varchar(20)  comment 'PERIODID is just a period count, starting from 1 for each Pre-Dispatch run. Use DATETIME to determine half hour period.',
   INTERVENTION         numeric(2,0)  comment 'Flag to indicate if this result set was sourced from the pricing run (INTERVENTION=0) or the physical run (INTERVENTION=1). In the event that there is not intervention in the market, both pricing and physical runs correspond to INTERVENTION=0',
   TOTALDEMAND          numeric(15,5)  comment 'Total demand in MW for period (less normally on loads)',
   AVAILABLEGENERATION  numeric(15,5)  comment 'Aggregate generation bid available in region',
   AVAILABLELOAD        numeric(15,5)  comment 'Aggregate load bid available in region',
   DEMANDFORECAST       numeric(15,5)  comment 'Delta MW value only',
   DISPATCHABLEGENERATION numeric(15,5)  comment 'Generation dispatched in period',
   DISPATCHABLELOAD     numeric(15,5)  comment 'Load dispatched in period',
   NETINTERCHANGE       numeric(15,5)  comment 'Net interconnector flow from the regional reference node',
   EXCESSGENERATION     numeric(15,5)  comment 'Excess generation in period / Deficit generation if VOLL',
   LOWER5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW dispatch',
   LOWER5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min MW imported',
   LOWER5MINLOCALDISPATCH numeric(15,5)  comment 'Lower 5 min local dispatch',
   LOWER5MINLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 5 min',
   LOWER5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min local requirement',
   LOWER5MINPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 5 min',
   LOWER5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 5 min total requirement',
   LOWER5MINSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 5 min',
   LOWER60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW dispatch',
   LOWER60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec MW imported',
   LOWER60SECLOCALDISPATCH numeric(15,5)  comment 'Lower 60 sec local dispatch',
   LOWER60SECLOCALPRICE numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 60 sec',
   LOWER60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec local requirement',
   LOWER60SECPRICE      numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 60 sec',
   LOWER60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Lower 60 sec total requirement',
   LOWER60SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 60 sec',
   LOWER6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW dispatch',
   LOWER6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec MW imported',
   LOWER6SECLOCALDISPATCH numeric(15,5)  comment 'Lower 6 sec local dispatch',
   LOWER6SECLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of lower 6 sec',
   LOWER6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec local requirement',
   LOWER6SECPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of lower 6 sec',
   LOWER6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Lower 6 sec total requirement',
   LOWER6SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of lower 6 sec',
   RAISE5MINDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min MW dispatch',
   RAISE5MINIMPORT      numeric(15,5)  comment 'Not used since Dec 2003.  Raise 5 min MW imported',
   RAISE5MINLOCALDISPATCH numeric(15,5)  comment 'Raise 5 min local dispatch',
   RAISE5MINLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of raise 5 min',
   RAISE5MINLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min local requirement',
   RAISE5MINPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 5 min',
   RAISE5MINREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 5 min total requirement',
   RAISE5MINSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 5 min',
   RAISE60SECDISPATCH   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW dispatch',
   RAISE60SECIMPORT     numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec MW imported',
   RAISE60SECLOCALDISPATCH numeric(15,5)  comment 'Raise 60 sec local dispatch',
   RAISE60SECLOCALPRICE numeric(15,5)  comment 'Not used since Dec 2003. Local price of raise 60 sec',
   RAISE60SECLOCALREQ   numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec local requirement',
   RAISE60SECPRICE      numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 60 sec',
   RAISE60SECREQ        numeric(15,5)  comment 'Not used since Dec 2003. Raise 60 sec total requirement',
   RAISE60SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 60 sec',
   RAISE6SECDISPATCH    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW dispatch',
   RAISE6SECIMPORT      numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec MW imported',
   RAISE6SECLOCALDISPATCH numeric(15,5)  comment 'Raise 6 sec local dispatch',
   RAISE6SECLOCALPRICE  numeric(15,5)  comment 'Not used since Dec 2003. Local price of raise 6 sec',
   RAISE6SECLOCALREQ    numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec local requirement',
   RAISE6SECPRICE       numeric(15,5)  comment 'Not used since Dec 2003. Regional price of raise 6 sec',
   RAISE6SECREQ         numeric(15,5)  comment 'Not used since Dec 2003. Raise 6 sec total requirement',
   RAISE6SECSUPPLYPRICE numeric(15,5)  comment 'Not used since Dec 2003. Supply price of raise 6 sec',
   LASTCHANGED          datetime  comment 'Period date and time',
   DATETIME             datetime not null  comment 'Period expressed as Date/Time',
   INITIALSUPPLY        numeric(15,5)  comment 'Sum of initial generation and import for region',
   CLEAREDSUPPLY        numeric(15,5)  comment 'Sum of cleared generation and import for region',
   LOWERREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation MW imported',
   LOWERREGLOCALDISPATCH numeric(15,5)  comment 'Lower Regulation local dispatch',
   LOWERREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation local requirement',
   LOWERREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Lower Regulation total requirement',
   RAISEREGIMPORT       numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation MW imported',
   RAISEREGLOCALDISPATCH numeric(15,5)  comment 'Raise Regulation local dispatch',
   RAISEREGLOCALREQ     numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation local requirement',
   RAISEREGREQ          numeric(15,5)  comment 'Not used since Dec 2003. Raise Regulation total requirement',
   RAISE5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min local requirement',
   RAISEREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg local requirement',
   RAISE60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 sec local requirement',
   RAISE6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 sec local requirement',
   LOWER5MINLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min local requirement',
   LOWERREGLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg local requirement',
   LOWER60SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 sec local requirement',
   LOWER6SECLOCALVIOLATION numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 sec local requirement',
   RAISE5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 5 min requirement',
   RAISEREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise Reg requirement',
   RAISE60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 60 seconds requirement',
   RAISE6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Raise 6 seconds requirement',
   LOWER5MINVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 5 min requirement',
   LOWERREGVIOLATION    numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower Reg requirement',
   LOWER60SECVIOLATION  numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 60 seconds requirement',
   LOWER6SECVIOLATION   numeric(15,5)  comment 'Not used since Dec 2003. Violation (MW) of Lower 6 seconds requirement',
   RAISE6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 6sec availability',
   RAISE60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 60sec availability',
   RAISE5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise 5min availability',
   RAISEREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted raise reg availability',
   LOWER6SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 6sec availability',
   LOWER60SECACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 60sec availability',
   LOWER5MINACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower 5min availability',
   LOWERREGACTUALAVAILABILITY numeric(16,6)  comment 'trapezium adjusted lower reg availability',
   DECAVAILABILITY      numeric(16,6)  comment 'generation availability taking into account daily energy constraints',
   LORSURPLUS           numeric(16,6)  comment 'Not used after Feb 2006. Total short term generation capacity reserve used in assessing lack of reserve condition',
   LRCSURPLUS           numeric(16,6)  comment 'Not used after Feb 2006. Total short term generation capacity reserve above the stated low reserve condition requirement',
   TOTALINTERMITTENTGENERATION numeric(15,5)  comment 'Allowance made for non-scheduled generation in the demand forecast (MW).',
   DEMAND_AND_NONSCHEDGEN numeric(15,5)  comment 'Sum of Cleared Scheduled generation, imported generation (at the region boundary) and allowances made for non-scheduled generation (MW).',
   UIGF                 numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW).',
   SEMISCHEDULE_CLEAREDMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW',
   SEMISCHEDULE_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced',
   SS_SOLAR_UIGF        numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is solar',
   SS_WIND_UIGF         numeric(15,5)  comment 'Regional aggregated Unconstrained Intermittent Generation Forecast of Semi-scheduled generation (MW) where the primary fuel source is wind',
   SS_SOLAR_CLEAREDMW   numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is solar',
   SS_WIND_CLEAREDMW    numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where the primary fuel source is wind',
   SS_SOLAR_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is solar',
   SS_WIND_COMPLIANCEMW numeric(15,5)  comment 'Regional aggregated Semi-Schedule generator Cleared MW where Semi-Dispatch cap is enforced and the primary fuel source is wind',
   WDR_INITIALMW        numeric(15,5)  comment 'Regional aggregated MW value at start of interval for Wholesale Demand Response (WDR) units',
   WDR_AVAILABLE        numeric(15,5)  comment 'Regional aggregated available MW for Wholesale Demand Response (WDR) units',
   WDR_DISPATCHED       numeric(15,5)  comment 'Regional aggregated dispatched MW for Wholesale Demand Response (WDR) units',
   SS_SOLAR_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Solar units in that region',
   SS_WIND_AVAILABILITY numeric(15,5)  comment 'For Semi-Scheduled units. Aggregate Energy Availability from Wind units in that region',
   RAISE1SECLOCALDISPATCH numeric(15,5)  comment 'Total Raise1Sec Dispatched in Region - RegionSolution element R1Dispatch attribute',
   LOWER1SECLOCALDISPATCH numeric(15,5)  comment 'Total Lower1Sec Dispatched in Region - RegionSolution element L1Dispatch attribute',
   RAISE1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Raise1Sec availability (summated from UnitSolution)',
   LOWER1SECACTUALAVAILABILITY numeric(16,6)  comment 'Trapezium adjusted Lower1Sec availability (summated from UnitSolution)',
   BDU_ENERGY_STORAGE   numeric(15,5)  comment 'Regional aggregated energy storage where the DUID type is BDU (MWh)',
   BDU_MIN_AVAIL        numeric(15,5)  comment 'Total available load side BDU summated for region (MW)',
   BDU_MAX_AVAIL        numeric(15,5)  comment 'Total available generation side BDU summated for region (MW)',
   BDU_CLEAREDMW_GEN    numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of export (Generation)',
   BDU_CLEAREDMW_LOAD   numeric(15,5)  comment 'Regional aggregated cleared MW where the DUID type is BDU. Net of import (Load)',
   BDU_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy Storage for BDU at the start of the interval(MWh) - Region Aggregated',
   DECGEN_INITIAL_ENERGY_STORAGE numeric(15,5)  comment 'Energy storage for Daily Energy Constrained Scheduled Generating Units at the start of the interval(MWh) - Region Aggregated'
);

alter table PREDISPATCHREGIONSUM comment 'PREDISPATCHREGIONSUM sets out the overall regional Pre-Dispa';

alter table PREDISPATCHREGIONSUM
   add primary key (DATETIME, REGIONID);

/*==============================================================*/
/* Index: PREDISPATCHRGNSUM_NDX3                                */
/*==============================================================*/
create index PREDISPATCHRGNSUM_NDX3 on PREDISPATCHREGIONSUM
(
   PREDISPATCHSEQNO
);

/*==============================================================*/
/* Index: PREDISPATCHREGIONSUM_LCX                              */
/*==============================================================*/
create index PREDISPATCHREGIONSUM_LCX on PREDISPATCHREGIONSUM
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCHSCENARIODEMAND                             */
/*==============================================================*/
create table PREDISPATCHSCENARIODEMAND
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of this set of scenarios',
   VERSIONNO            numeric(3,0) not null  comment 'The version of this set of scenarios',
   SCENARIO             numeric(2,0) not null  comment 'The scenario identifier.',
   REGIONID             varchar(20) not null  comment 'The region to which to apply the deltaMW for this SCENARIO.',
   DELTAMW              numeric(4,0)  comment 'The MW offset that is applied for this scenario'
);

alter table PREDISPATCHSCENARIODEMAND comment 'PREDISPATCHSCENARIODEMAND defines the demand offsets that ar';

alter table PREDISPATCHSCENARIODEMAND
   add primary key (EFFECTIVEDATE, VERSIONNO, SCENARIO, REGIONID);

/*==============================================================*/
/* Table: PREDISPATCHSCENARIODEMANDTRK                          */
/*==============================================================*/
create table PREDISPATCHSCENARIODEMANDTRK
(
   EFFECTIVEDATE        datetime not null  comment 'The effective date of this set of scenarios',
   VERSIONNO            numeric(3,0) not null  comment 'The version of this set of scenarios',
   AUTHORISEDBY         varchar(15)  comment 'The user that authorised the scenario update',
   AUTHORISEDDATE       datetime  comment 'The datetime that the scenario update was authorised',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed'
);

alter table PREDISPATCHSCENARIODEMANDTRK comment 'Tracks the predispatch scenario offset updates across time';

alter table PREDISPATCHSCENARIODEMANDTRK
   add primary key (EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: PREDISPATCHSCENARIODMNDTRK_LCX                        */
/*==============================================================*/
create index PREDISPATCHSCENARIODMNDTRK_LCX on PREDISPATCHSCENARIODEMANDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCH_FCAS_REQ                                  */
/*==============================================================*/
create table PREDISPATCH_FCAS_REQ
(
   PREDISPATCHSEQNO     varchar(20)  comment 'PreDispatch Sequence number',
   RUNNO                numeric(3,0)  comment 'Case Run number',
   INTERVENTION         numeric(2,0)  comment 'Intervention Flag',
   PERIODID             varchar(20)  comment 'Unique period identifier, in the format yyyymmddpp. The period (pp) is 01 to 48, with 01 corresponding to the half-hour ending at 04:30am.',
   GENCONID             varchar(20) not null  comment 'Generic Constraint ID - Join to table GenConData',
   REGIONID             varchar(10) not null  comment 'Region ID',
   BIDTYPE              varchar(10) not null  comment 'Bid Type Identifier',
   GENCONEFFECTIVEDATE  datetime  comment 'Generic Constraint EffectiveDate - Join to table GenConData',
   GENCONVERSIONNO      numeric(3,0)  comment 'Generic Constraint Version number - Join to table GenConData',
   MARGINALVALUE        numeric(16,6)  comment 'Marginal Value of generic constraint',
   DATETIME             datetime not null  comment 'Date and Time of trading interval',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   BASE_COST            numeric(18,8)  comment 'The base cost of the constraint for this service, before the regulation/contingency split',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, before the regulation/contingency split',
   ESTIMATED_CMPF       numeric(18,8)  comment 'An estimated value for the constraint CMPF, based on dispatched data',
   ESTIMATED_CRMPF      numeric(18,8)  comment 'An estimated value for the constraint CRMPF, based on dispatched data',
   RECOVERY_FACTOR_CMPF numeric(18,8)  comment 'Estimated recovery factor for CMPF based recovery',
   RECOVERY_FACTOR_CRMPF numeric(18,8)  comment 'Estimated recovery factor for CRMPF based recovery'
);

alter table PREDISPATCH_FCAS_REQ comment 'PREDISPATCH_FCAS_REQ shows Predispatch Constraint tracking f';

alter table PREDISPATCH_FCAS_REQ
   add primary key (DATETIME, GENCONID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Index: PREDISPATCH_FCAS_REQ_LCX                              */
/*==============================================================*/
create index PREDISPATCH_FCAS_REQ_LCX on PREDISPATCH_FCAS_REQ
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PREDISPATCH_LOCAL_PRICE                               */
/*==============================================================*/
create table PREDISPATCH_LOCAL_PRICE
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Unique identifier of predispatch run in the form YYYYMMDDPP with 01 at 04:30',
   DATETIME             datetime not null  comment 'The unique identifier for the interval within this study',
   DUID                 varchar(20) not null  comment 'Dispatchable unit identifier',
   PERIODID             varchar(20)  comment 'A period count, starting from 1 for each predispatch run. Use DATETIME to determine half hour period',
   LOCAL_PRICE_ADJUSTMENT numeric(10,2)  comment 'Aggregate Constraint contribution cost of this unit: Sum(MarginalValue x Factor) for all relevant Constraints',
   LOCALLY_CONSTRAINED  numeric(1,0)  comment 'Key for Local_Price_Adjustment: 2 = at least one Outage Constraint; 1 = at least 1 System Normal Constraint (and no Outage Constraint); 0 = No System Normal or Outage Constraints',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table PREDISPATCH_LOCAL_PRICE comment 'Sets out local pricing offsets associated with each DUID con';

alter table PREDISPATCH_LOCAL_PRICE
   add primary key (DATETIME, DUID);

/*==============================================================*/
/* Table: PREDISPATCH_MNSPBIDTRK                                */
/*==============================================================*/
create table PREDISPATCH_MNSPBIDTRK
(
   PREDISPATCHSEQNO     varchar(20) not null  comment 'Predispatch run identifier',
   LINKID               varchar(10) not null  comment 'Identifier for each of the two MNSP Interconnector Links. Each link pertains to the direction from and to.',
   PERIODID             varchar(20) not null  comment 'Trading Interval number',
   PARTICIPANTID        varchar(10)  comment 'Participant Identifier',
   SETTLEMENTDATE       datetime  comment 'Market Date from which bid is active',
   OFFERDATE            datetime(3)  comment 'Time this bid was processed and loaded',
   VERSIONNO            numeric(3,0)  comment 'Version No. for given offer date and settlement date used',
   DATETIME             datetime  comment 'Period expressed as Date/Time',
   LASTCHANGED          datetime  comment 'Record creation timestamp'
);

alter table PREDISPATCH_MNSPBIDTRK comment 'PREDISPATCH_MNSPBIDTRK shows the MNSP bid tracking, includin';

alter table PREDISPATCH_MNSPBIDTRK
   add primary key (PREDISPATCHSEQNO, LINKID, PERIODID);

/*==============================================================*/
/* Index: PREDISPATCH_MNSPBIDTRK_LCX                            */
/*==============================================================*/
create index PREDISPATCH_MNSPBIDTRK_LCX on PREDISPATCH_MNSPBIDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PRUDENTIALCOMPANYPOSITION                             */
/*==============================================================*/
create table PRUDENTIALCOMPANYPOSITION
(
   PRUDENTIAL_DATE      datetime not null  comment 'The prudential date',
   RUNNO                numeric(3,0) not null  comment 'The run number for the prudential date',
   COMPANY_ID           varchar(20) not null  comment 'The company identifier',
   MCL                  numeric(16,6)  comment 'The Maximum Credit Limit of the company at the time of the prudential run',
   CREDIT_SUPPORT       numeric(16,6)  comment 'The Credit Support of the company at the time of the prudential run',
   TRADING_LIMIT        numeric(16,6)  comment 'The Trading Limit of the company at the time of the prudential run',
   CURRENT_AMOUNT_BALANCE numeric(16,6)  comment 'The balance of the company for all unpaid billing weeks at the time of the prudential run',
   SECURITY_DEPOSIT_PROVISION numeric(16,6)  comment 'The sum of all active security deposit provision amounts at the time of the prudential run',
   SECURITY_DEPOSIT_OFFSET numeric(16,6)  comment 'The sum of all active security deposit application amounts at the time of the prudential run',
   SECURITY_DEPOSIT_BALANCE numeric(16,6)  comment 'The balance of all active security deposits at the time of the prudential run',
   EXPOST_REALLOC_BALANCE numeric(16,6)  comment 'The balance of all ex-post reallocations for the company that were calculated outside of billing runs at the time of the prudential run',
   DEFAULT_BALANCE      numeric(16,6)  comment 'The balance of all defaults for the company at the time of the prudential run',
   OUTSTANDINGS         numeric(16,6)  comment 'The total outstandings for the company at the time of the prudential run',
   TRADING_MARGIN       numeric(16,6)  comment 'The trading margin for the company at the time of the prudential run',
   TYPICAL_ACCRUAL      numeric(16,6)  comment 'The typical accrual for the company at the time of the prudential run',
   PRUDENTIAL_MARGIN    numeric(16,6)  comment 'The prudential margin is the current value determined by AEMO for the registered participant. It represents the buffer below the value of credit support which is used to set the trading limit',
   EARLY_PAYMENT_AMOUNT numeric(18,8)  comment 'The early payment amount deducted from Outstandings in the prudential run',
   PERCENTAGE_OUTSTANDINGS numeric(18,8)  comment 'The percentage of outstandings calculated against the trading margin and prudential margin',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed'
);

alter table PRUDENTIALCOMPANYPOSITION comment 'The prudential position of each company as at the datetime o';

alter table PRUDENTIALCOMPANYPOSITION
   add primary key (PRUDENTIAL_DATE, RUNNO, COMPANY_ID);

/*==============================================================*/
/* Index: PRUDENTIALCOMPANYPOSITION_LCX                         */
/*==============================================================*/
create index PRUDENTIALCOMPANYPOSITION_LCX on PRUDENTIALCOMPANYPOSITION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: PRUDENTIALRUNTRK                                      */
/*==============================================================*/
create table PRUDENTIALRUNTRK
(
   PRUDENTIAL_DATE      datetime not null  comment 'The prudential date',
   RUNNO                numeric(3,0) not null  comment 'The run number for the prudential date',
   AUTHORISEDBY         varchar(15)  comment 'The user that authorised the prudential run',
   AUTHORISEDDATE       datetime  comment 'The datetime that the prudential run was authorised',
   LASTCHANGED          datetime  comment 'The datetime that the record was last changed'
);

alter table PRUDENTIALRUNTRK comment 'Records the prudential run accepted by Settlements staff for';

alter table PRUDENTIALRUNTRK
   add primary key (PRUDENTIAL_DATE, RUNNO);

/*==============================================================*/
/* Index: PRUDENTIALRUNTRK_LCX                                  */
/*==============================================================*/
create index PRUDENTIALRUNTRK_LCX on PRUDENTIALRUNTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REALLOCATION                                          */
/*==============================================================*/
create table REALLOCATION
(
   REALLOCATIONID       varchar(20) not null  comment 'Reallocation identifier',
   CREDITPARTICIPANTID  varchar(10)  comment 'The participant to be credited for the reallocation',
   DEBITPARTICIPANTID   varchar(10)  comment 'The participant to be debited for the reallocation',
   REGIONID             varchar(10)  comment 'Region identifier, being the spot price reference node for this reallocation',
   AGREEMENTTYPE        varchar(10)  comment '$, (Quantity) Mwh, SWAP, CAP or FLOOR',
   CREDITREFERENCE      varchar(400)  comment 'Optional reference detail for credit participant',
   DEBITREFERENCE       varchar(400)  comment 'Optional reference detail for debit participant',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   STARTDATE            datetime  comment 'First day of the Reallocation contract',
   ENDDATE              datetime  comment 'Last day of the Reallocation contract',
   CURRENT_STEPID       varchar(20)  comment 'Reallocation state. One of SUBMITTED, AUTHORISED, CANCELLED.',
   DAYTYPE              varchar(20)  comment 'The day type profile for which the reallocation applies over the start and end date range. Valid entries are BUSINESS, NON_BUSINESS or FLAT.',
   REALLOCATION_TYPE    varchar(1)  comment 'Denotes a Credit or Debit reallocation with a value of "C" or "D" respectively',
   CALENDARID           varchar(30)  comment 'Unique ID of the calendar for which data is requested',
   INTERVALLENGTH       numeric(3,0)  comment 'The length of settlement intervals (in minutes) in the reallocation profile'
);

alter table REALLOCATION comment 'The REALLOCATION table shows the financial transactions agre';

alter table REALLOCATION
   add primary key (REALLOCATIONID);

/*==============================================================*/
/* Index: REALLOCATION_LCX                                      */
/*==============================================================*/
create index REALLOCATION_LCX on REALLOCATION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REALLOCATIONDETAILS                                   */
/*==============================================================*/
create table REALLOCATIONDETAILS
(
   REALLOCATIONID       varchar(20) not null  comment 'Identification of the reallocation agreement',
   EFFECTIVEDATE        datetime not null  comment 'Calendar settlement date the agreement starts from',
   VERSIONNO            numeric(3,0) not null  comment 'Version number on the effective date, highest is the reallocation used on that date',
   AUTHORISEDDATE       datetime  comment 'Date the entry was authorised',
   AUTHORISEDBY         varchar(10)  comment 'User who authorised the record',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REALLOCATIONDETAILS comment 'REALLOCATIONDETAILS sets out specific reallocation agreement';

alter table REALLOCATIONDETAILS
   add primary key (REALLOCATIONID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: REALLOCATIONDETAILS_LCX                               */
/*==============================================================*/
create index REALLOCATIONDETAILS_LCX on REALLOCATIONDETAILS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REALLOCATIONINTERVAL                                  */
/*==============================================================*/
create table REALLOCATIONINTERVAL
(
   REALLOCATIONID       varchar(20) not null  comment 'Reallocation identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   VALUE                numeric(15,5)  comment 'Reallocation value in the units of the agreement type',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   NRP                  numeric(15,5)  comment 'Nominated Reallocation Price, only used in agreement types of SWAP, CAP and FLOOR, being the contract strike price in $/MWh'
);

alter table REALLOCATIONINTERVAL comment '30-minute or (5-minute for 5MS) data comprising a single rea';

alter table REALLOCATIONINTERVAL
   add primary key (REALLOCATIONID, PERIODID);

/*==============================================================*/
/* Index: REALLOCATIONINTERVAL_LCX                              */
/*==============================================================*/
create index REALLOCATIONINTERVAL_LCX on REALLOCATIONINTERVAL
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REALLOCATIONINTERVALS                                 */
/*==============================================================*/
create table REALLOCATIONINTERVALS
(
   REALLOCATIONID       varchar(20) not null  comment 'Identification of the reallocation agreement',
   EFFECTIVEDATE        datetime not null  comment 'Date the agreement starts from',
   VERSIONNO            numeric(3,0) not null  comment 'Version number on the effective date, highest is the reallocation used on that date',
   PERIODID             numeric(3,0) not null  comment 'Period number where period 1 use the half hour ended 00:30 EST',
   REALLOCATIONVALUE    numeric(6,2)  comment 'Either $ or MWh depending on agreement type',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REALLOCATIONINTERVALS comment 'REALLOCATIONINTERVALS identifies the the reallocation agreem';

alter table REALLOCATIONINTERVALS
   add primary key (REALLOCATIONID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: REALLOCATIONINTERVALS_LCX                             */
/*==============================================================*/
create index REALLOCATIONINTERVALS_LCX on REALLOCATIONINTERVALS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REALLOCATIONS                                         */
/*==============================================================*/
create table REALLOCATIONS
(
   REALLOCATIONID       varchar(20) not null  comment 'Identification of the reallocation agreement',
   STARTDATE            datetime  comment 'Starting data for the agreement',
   STARTPERIOD          numeric(3,0)  comment 'Starting period number',
   ENDDATE              datetime  comment 'Ending date for the agreement',
   ENDPERIOD            numeric(3,0)  comment 'Ending period number',
   PARTICIPANTTOID      varchar(10)  comment 'Participant who receives the money',
   PARTICIPANTFROMID    varchar(10)  comment 'Participant who provides the money',
   AGREEMENTTYPE        varchar(10)  comment 'Either $ or MWh',
   DEREGISTRATIONDATE   datetime  comment 'Not used',
   DEREGISTRATIONPERIOD numeric(3,0)  comment 'Not used',
   REGIONID             varchar(10)  comment 'Place where the RRP is taken for the agreement',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REALLOCATIONS comment 'REALLOCATIONS shows reallocation agreement identifiers with ';

alter table REALLOCATIONS
   add primary key (REALLOCATIONID);

/*==============================================================*/
/* Index: REALLOCATIONS_LCX                                     */
/*==============================================================*/
create index REALLOCATIONS_LCX on REALLOCATIONS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGION                                                */
/*==============================================================*/
create table REGION
(
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   DESCRIPTION          varchar(64)  comment 'Full description of region',
   REGIONSTATUS         varchar(8)  comment 'Status of the region e.g. working, inactive, archive.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REGION comment 'REGION sets out valid region IDs.';

alter table REGION
   add primary key (REGIONID);

/*==============================================================*/
/* Index: REGION_LCX                                            */
/*==============================================================*/
create index REGION_LCX on REGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGIONAPC                                             */
/*==============================================================*/
create table REGIONAPC
(
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Date the APC profile applies from',
   VERSIONNO            numeric(3,0) not null  comment 'Version number for the same date',
   AUTHORISEDDATE       datetime  comment 'Authorised date',
   AUTHORISEDBY         varchar(10)  comment 'Authorised by',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REGIONAPC comment 'REGIONAPC defines Administered Price profiles (Energy and FC';

alter table REGIONAPC
   add primary key (REGIONID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: REGIONAPC_LCX                                         */
/*==============================================================*/
create index REGIONAPC_LCX on REGIONAPC
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGIONAPCINTERVALS                                    */
/*==============================================================*/
create table REGIONAPCINTERVALS
(
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   EFFECTIVEDATE        datetime not null  comment 'Date the APC profile applies from',
   VERSIONNO            numeric(3,0) not null  comment 'Version number for the same date',
   PERIODID             numeric(3,0) not null  comment '30-minute period',
   APCVALUE             numeric(16,6)  comment 'Administered price cap in $',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   APCTYPE              numeric(3,0)  comment 'not used',
   FCASAPCVALUE         numeric(16,6)  comment 'FCAS Administered price cap in $',
   APFVALUE             numeric(16,6)  comment 'Administered price floor in $'
);

alter table REGIONAPCINTERVALS comment 'REGIONAPCINTERVALS contains Administered Price profiles (Ene';

alter table REGIONAPCINTERVALS
   add primary key (REGIONID, EFFECTIVEDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: REGIONAPCINTERVALS_LCX                                */
/*==============================================================*/
create index REGIONAPCINTERVALS_LCX on REGIONAPCINTERVALS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGIONFCASRELAXATION_OCD                              */
/*==============================================================*/
create table REGIONFCASRELAXATION_OCD
(
   SETTLEMENTDATE       datetime not null  comment 'End date and time of the dispatch interval',
   RUNNO                numeric(3,0) not null  comment 'Dispatch run no',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   SERVICETYPE          varchar(10) not null  comment 'Ancillary service type identifier (e.g. LOWER60SEC)',
   GLOBAL               numeric(1,0) not null  comment 'FCAS Requirement: 1 = global, 0 = local',
   REQUIREMENT          numeric(15,5)  comment 'Relaxed Requirement used in attempt to avoid violation',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REGIONFCASRELAXATION_OCD comment 'REGIONFCASRELAXATION_OCD contains details of regional FCAS r';

alter table REGIONFCASRELAXATION_OCD
   add primary key (SETTLEMENTDATE, RUNNO, REGIONID, SERVICETYPE, GLOBAL);

/*==============================================================*/
/* Index: REGIONFCASRELAXATION_OCD_LCX                          */
/*==============================================================*/
create index REGIONFCASRELAXATION_OCD_LCX on REGIONFCASRELAXATION_OCD
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGIONSTANDINGDATA                                    */
/*==============================================================*/
create table REGIONSTANDINGDATA
(
   EFFECTIVEDATE        datetime not null  comment 'Effective date of this record, only the latest date applies',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of the standing data that should be effective on this date',
   REGIONID             varchar(10) not null  comment 'Differentiates this region from all other regions',
   RSOID                varchar(10)  comment 'the unique identifier of the participant with responsibility for the region.',
   REGIONALREFERENCEPOINTID varchar(10)  comment 'unique id of a connection point, being the reference point for this region',
   PEAKTRADINGPERIOD    numeric(3,0)  comment 'Period identifier of the peak trading period of this connection point',
   AUTHORISEDDATE       datetime  comment 'Date record authorised',
   AUTHORISEDBY         varchar(15)  comment 'User authorising record',
   SCALINGFACTOR        numeric(15,5)  comment 'Scaling factor for regional FCAS requirement',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table REGIONSTANDINGDATA comment 'REGIONSTANDINGDATA sets out standing region data including t';

alter table REGIONSTANDINGDATA
   add primary key (EFFECTIVEDATE, VERSIONNO, REGIONID);

/*==============================================================*/
/* Index: REGIONSTANDINGDATA_LCX                                */
/*==============================================================*/
create index REGIONSTANDINGDATA_LCX on REGIONSTANDINGDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: REGION_AREA                                           */
/*==============================================================*/
create table REGION_AREA
(
   REGIONID             varchar(10) not null  comment 'Region identifier',
   EFFECTIVEDATE        datetime not null  comment 'Calendar date from when this record set is effective.',
   VERSIONNO            numeric(3,0) not null  comment 'Version number for the same effectivedate.',
   AREAID               varchar(10) not null  comment 'Area identifier',
   LASTCHANGED          datetime  comment 'Last date and time record changed.'
);

alter table REGION_AREA comment 'Table containing static metadata for mapping the Areas to Re';

alter table REGION_AREA
   add primary key (REGIONID, EFFECTIVEDATE, VERSIONNO, AREAID);

/*==============================================================*/
/* Table: RESDEMANDTRK                                          */
/*==============================================================*/
create table RESDEMANDTRK
(
   EFFECTIVEDATE        datetime not null  comment 'Trading Date of the regional forecast',
   REGIONID             varchar(10) not null  comment 'Unique RegionID',
   OFFERDATE            datetime not null  comment 'Date the forecast was created',
   VERSIONNO            numeric(3,0) not null  comment 'Version of this forecast with respect to the Effectivedate and Offerdate',
   FILENAME             varchar(40)  comment 'Tracking purposes only',
   AUTHORISEDDATE       datetime  comment 'Date forecast authorised',
   AUTHORISEDBY         varchar(10)  comment 'Identifier of authorising user',
   LASTCHANGED          datetime  comment 'Date and time the record was last modified'
);

alter table RESDEMANDTRK comment 'RESDEMANDTRK defines the existence and versioning informatio';

alter table RESDEMANDTRK
   add primary key (REGIONID, EFFECTIVEDATE, OFFERDATE, VERSIONNO);

/*==============================================================*/
/* Index: RESDEMANDTRK_LCX                                      */
/*==============================================================*/
create index RESDEMANDTRK_LCX on RESDEMANDTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESERVE                                               */
/*==============================================================*/
create table RESERVE
(
   SETTLEMENTDATE       datetime not null  comment 'Market date starting at 04:00am',
   VERSIONNO            numeric(3,0) not null  comment 'Version No of record for this date, the version of the file loaded to produce these reserve figures',
   REGIONID             varchar(12) not null  comment 'Differentiates this region from all other regions',
   PERIODID             numeric(2,0) not null  comment 'Market Trading Interval',
   LOWER5MIN            numeric(6,0)  comment 'Lower 5 minute reserve requirement',
   LOWER60SEC           numeric(6,0)  comment 'Lower 60 second reserve requirement',
   LOWER6SEC            numeric(6,0)  comment 'Lower 6 second reserve requirement',
   RAISE5MIN            numeric(6,0)  comment 'Raise 5 minute reserve requirement',
   RAISE60SEC           numeric(6,0)  comment 'Raise 60 second reserve requirement',
   RAISE6SEC            numeric(6,0)  comment 'Raise 6 second reserve requirement',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PASARESERVE          numeric(6,0)  comment 'PASA reserve requirement',
   LOADREJECTIONRESERVEREQ numeric(10,0)  comment 'PASA Load rejection reserve requirement',
   RAISEREG             numeric(6,0)  comment 'Raise Regulation reserve requirement',
   LOWERREG             numeric(6,0)  comment 'Lower Regulation reserve requirement',
   LOR1LEVEL            numeric(6,0)  comment 'PASA Lack of Reserve 1 Level',
   LOR2LEVEL            numeric(6,0)  comment 'PASA Lack of Reserve 1 Level'
);

alter table RESERVE comment 'RESERVE sets out specific reserve requirements for dispatch,';

alter table RESERVE
   add primary key (SETTLEMENTDATE, REGIONID, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: RESERVE_LCX                                           */
/*==============================================================*/
create index RESERVE_LCX on RESERVE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUECONTRACTPAYMENTS                               */
/*==============================================================*/
create table RESIDUECONTRACTPAYMENTS
(
   CONTRACTID           varchar(30) not null  comment 'SRA Contract ID',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed'
);

alter table RESIDUECONTRACTPAYMENTS comment 'RESIDUECONTRACTPAYMENTS shows Settlement Residue Auction pay';

alter table RESIDUECONTRACTPAYMENTS
   add primary key (CONTRACTID, PARTICIPANTID);

/*==============================================================*/
/* Index: RESIDUECONTRACTPAYMENTS_LCX                           */
/*==============================================================*/
create index RESIDUECONTRACTPAYMENTS_LCX on RESIDUECONTRACTPAYMENTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUEFILETRK                                        */
/*==============================================================*/
create table RESIDUEFILETRK
(
   CONTRACTID           varchar(30)  comment 'SRA ContractID',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   LOADDATE             datetime not null  comment 'Date-Time SRA offer was loaded',
   FILENAME             varchar(40)  comment 'SRA offer file name',
   ACKFILENAME          varchar(40)  comment 'SRA acknowledgment file name',
   STATUS               varchar(10)  comment 'Load status [SUCCESSFUL/CORRUPT]',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date. (new in March 2003 to support SRA Inter-Temporal Linking)'
);

alter table RESIDUEFILETRK comment 'RESIDUEFILETRK records all Settlement Residue Auction offers';

alter table RESIDUEFILETRK
   add primary key (AUCTIONID, PARTICIPANTID, LOADDATE);

/*==============================================================*/
/* Index: RESIDUEFILETRK_NDX_LCHD                               */
/*==============================================================*/
create index RESIDUEFILETRK_NDX_LCHD on RESIDUEFILETRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_BID_TRK                                       */
/*==============================================================*/
create table RESIDUE_BID_TRK
(
   CONTRACTID           varchar(30)  comment 'SRA Contract unique identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Version of Bid used',
   PARTICIPANTID        varchar(10) not null  comment 'Identifier of participant',
   BIDLOADDATE          datetime  comment 'Date and time bid used',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed',
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date. (new in March 2003 to support SRA Inter-Temporal Linking)'
);

alter table RESIDUE_BID_TRK comment 'RESIDUE_BID_TRK supports the Settlement Residue Auction, by ';

alter table RESIDUE_BID_TRK
   add primary key (AUCTIONID, VERSIONNO, PARTICIPANTID);

/*==============================================================*/
/* Index: RESIDUEBID_NDX_LCHD                                   */
/*==============================================================*/
create index RESIDUEBID_NDX_LCHD on RESIDUE_BID_TRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_CONTRACTS                                     */
/*==============================================================*/
create table RESIDUE_CONTRACTS
(
   CONTRACTYEAR         numeric(4,0) not null  comment 'SRA Contracted Year',
   QUARTER              numeric(1,0) not null  comment 'SRA Contracted Quarter',
   TRANCHE              numeric(2,0) not null  comment 'Label identifying the arbitrary segmented share of the Interconnector flow',
   CONTRACTID           varchar(30)  comment 'Unique identifier for each SRA Contract as specified by AEMO',
   STARTDATE            datetime  comment 'SRA Quarter start date',
   ENDDATE              datetime  comment 'SRA Quarter end date',
   NOTIFYDATE           datetime  comment 'Open date of bidding, calculated as RNOTIFYDATE business days before the auction date',
   AUCTIONDATE          datetime  comment 'Close date of bidding, calculated as RAUCDATE business days before the contract start date',
   CALCMETHOD           varchar(20)  comment 'Identifies methodology used',
   AUTHORISEDDATE       datetime  comment 'Authorisation date for this record',
   AUTHORISEDBY         varchar(15)  comment 'Name of authorising officer or process',
   NOTIFYPOSTDATE       datetime  comment 'Date notification posted',
   NOTIFYBY             varchar(15)  comment 'Name of notifying person',
   POSTDATE             datetime  comment 'Date of publishing the auction results',
   POSTEDBY             varchar(15)  comment 'Name of publishing officer or process',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   DESCRIPTION          varchar(80)  comment 'Description of Contract',
   AUCTIONID            varchar(30)  comment 'Unique id for each auction date (new in March 2003 to support SRA Inter-Temporal Linking)'
);

alter table RESIDUE_CONTRACTS comment 'RESIDUE_CONTRACTS supports the Settlement Residue Auction, b';

alter table RESIDUE_CONTRACTS
   add primary key (CONTRACTYEAR, QUARTER, TRANCHE);

/*==============================================================*/
/* Index: RESIDUE_CONTRACTS_LCX                                 */
/*==============================================================*/
create index RESIDUE_CONTRACTS_LCX on RESIDUE_CONTRACTS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_CON_DATA                                      */
/*==============================================================*/
create table RESIDUE_CON_DATA
(
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract run version',
   PARTICIPANTID        varchar(10) not null  comment 'Identifier of Contracted Participant',
   INTERCONNECTORID     varchar(10) not null  comment 'Identifier of Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   UNITSPURCHASED       numeric(17,5)  comment 'Units purchased on the directional interconnector (i.e. Contracted quantity)',
   LINKPAYMENT          numeric(17,5)  comment 'Payment due (i.e. total purchase price)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   SECONDARY_UNITS_SOLD numeric(18,8)  comment 'The number of cancelled Units for all Auction Participants.'
);

alter table RESIDUE_CON_DATA comment 'RESIDUE_CON_DATA supports the Settlement Residue Auction, by';

alter table RESIDUE_CON_DATA
   add primary key (CONTRACTID, VERSIONNO, PARTICIPANTID, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: RESIDUE_CON_DATA_LCX                                  */
/*==============================================================*/
create index RESIDUE_CON_DATA_LCX on RESIDUE_CON_DATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_CON_ESTIMATES_TRK                             */
/*==============================================================*/
create table RESIDUE_CON_ESTIMATES_TRK
(
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier',
   CONTRACTYEAR         numeric(4,0) not null  comment 'AEMO Contract Year number starting in week containing 1st January',
   QUARTER              numeric(1,0) not null  comment 'Contract Quarter',
   VALUATIONID          varchar(15) not null  comment 'Identifier of the estimator',
   VERSIONNO            numeric(3,0)  comment 'Version of a record, as nominated by the participant',
   LASTCHANGED          datetime  comment 'Date and time this record was changed'
);

alter table RESIDUE_CON_ESTIMATES_TRK comment 'RESIDUE_CON_ESTIMATES_TRK supports the Settlement Residue Au';

alter table RESIDUE_CON_ESTIMATES_TRK
   add primary key (CONTRACTID, CONTRACTYEAR, QUARTER, VALUATIONID);

/*==============================================================*/
/* Index: REVCONESTIMATESTRK_NDX_LCHD                           */
/*==============================================================*/
create index REVCONESTIMATESTRK_NDX_LCHD on RESIDUE_CON_ESTIMATES_TRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_CON_FUNDS                                     */
/*==============================================================*/
create table RESIDUE_CON_FUNDS
(
   CONTRACTID           varchar(30) not null  comment 'SRA Contract unique identifier as specified by AEMO',
   INTERCONNECTORID     varchar(10) not null  comment 'Identifier for the Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   DEFAULTUNITS         numeric(5,0)  comment 'Actual number of units allocated based on the auction default percentage for the tranche and the total number of units to be auctioned for this quarter',
   ROLLOVERUNITS        numeric(5,0)  comment 'Units reallocated from the previous tranche of this quarter',
   REALLOCATEDUNITS     numeric(5,0)  comment 'Units reallocated from the previous tranche of this quarter because they were not taken up by the participant',
   UNITSOFFERED         numeric(5,0)  comment 'Total units offered for Contract',
   MEANRESERVEPRICE     numeric(9,2)  comment 'Average reserve price calculated from the selected estimates',
   SCALEFACTOR          numeric(8,5)  comment 'Scaling factor for regional Frequency control Ancillary Service requirement',
   ACTUALRESERVEPRICE   numeric(9,2)  comment 'Actual reserve price',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table RESIDUE_CON_FUNDS comment 'RESIDUE_CON_FUNDS supports the Settlement Residue Auction, b';

alter table RESIDUE_CON_FUNDS
   add primary key (CONTRACTID, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: RESIDUE_CON_FUNDS_LCX                                 */
/*==============================================================*/
create index RESIDUE_CON_FUNDS_LCX on RESIDUE_CON_FUNDS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_FUNDS_BID                                     */
/*==============================================================*/
create table RESIDUE_FUNDS_BID
(
   CONTRACTID           varchar(30) not null  comment 'SRA Contract identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   LOADDATE             datetime not null  comment 'Date and time the batcher loaded the SRA offer',
   OPTIONID             numeric(3,0) not null  comment 'Unique option identifier (1..20)',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector Identifier',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   UNITS                numeric(5,0)  comment 'Quantity of units bid for',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table RESIDUE_FUNDS_BID comment 'RESIDUE_FUNDS_BID supports the Settlement Residue Auction, b';

alter table RESIDUE_FUNDS_BID
   add primary key (CONTRACTID, PARTICIPANTID, LOADDATE, OPTIONID, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: RESIDUE_FUNDS_BID_LCX                                 */
/*==============================================================*/
create index RESIDUE_FUNDS_BID_LCX on RESIDUE_FUNDS_BID
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_PRICE_BID                                     */
/*==============================================================*/
create table RESIDUE_PRICE_BID
(
   CONTRACTID           varchar(30)  comment 'Not to be used. Unique id for each SRA contract (specified by AEMO)',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   LOADDATE             datetime not null  comment 'Date and Time the batcher loaded the bid',
   OPTIONID             numeric(3,0) not null  comment 'Unique option (bid) identifier (1..800)',
   BIDPRICE             numeric(17,5)  comment 'Price offered for each unit',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed',
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date (new in March 2003 to support SRA Inter-Temporal Linking)'
);

alter table RESIDUE_PRICE_BID comment 'RESIDUE_PRICE_BID supports the Settlement Residue Auction, h';

alter table RESIDUE_PRICE_BID
   add primary key (AUCTIONID, PARTICIPANTID, LOADDATE, OPTIONID);

/*==============================================================*/
/* Index: RESIDUE_PRICE_BID_LCX                                 */
/*==============================================================*/
create index RESIDUE_PRICE_BID_LCX on RESIDUE_PRICE_BID
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_PRICE_FUNDS_BID                               */
/*==============================================================*/
create table RESIDUE_PRICE_FUNDS_BID
(
   CONTRACTID           varchar(30) not null  comment 'Unique id for each contract specified by AEMO',
   INTERCONNECTORID     varchar(10) not null  comment 'Unique interconnector identifier',
   FROMREGIONID         varchar(10) not null  comment 'Unique region identifier',
   UNITS                numeric(5,0)  comment 'Quantity of units bid',
   BIDPRICE             numeric(17,5)  comment 'Price bid for each unit',
   LINKEDBIDFLAG        numeric(6,0) not null  comment 'A unique option id, with respect to the auction, created to show which bid elements are linked.',
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed'
);

alter table RESIDUE_PRICE_FUNDS_BID comment 'RESIDUE_PRICE_FUNDS_BIDshows the bids producing the auction ';

alter table RESIDUE_PRICE_FUNDS_BID
   add primary key (AUCTIONID, CONTRACTID, INTERCONNECTORID, FROMREGIONID, LINKEDBIDFLAG);

/*==============================================================*/
/* Index: RESIDUE_PRICE_FUNDS_BID_LCX                           */
/*==============================================================*/
create index RESIDUE_PRICE_FUNDS_BID_LCX on RESIDUE_PRICE_FUNDS_BID
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_PUBLIC_DATA                                   */
/*==============================================================*/
create table RESIDUE_PUBLIC_DATA
(
   CONTRACTID           varchar(30) not null  comment 'Unique id for each contract to be specified by AEMO',
   VERSIONNO            numeric(3,0) not null  comment 'Version Number',
   INTERCONNECTORID     varchar(10) not null  comment 'Unique interconnector identifier',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   UNITSOFFERED         numeric(5,0)  comment 'Total units offered for auction',
   UNITSSOLD            numeric(16,6)  comment 'Units Sold (modified format and usage in March 2003 to support SRA Inter-Temporal Linking)',
   CLEARINGPRICE        numeric(17,5)  comment 'Clearing price',
   RESERVEPRICE         numeric(17,5)  comment 'Reserve price',
   LASTCHANGED          datetime  comment 'Date and time this record was last changed'
);

alter table RESIDUE_PUBLIC_DATA comment 'RESIDUE_PUBLIC_DATA shows the public auction results.
';

alter table RESIDUE_PUBLIC_DATA
   add primary key (CONTRACTID, VERSIONNO, INTERCONNECTORID, FROMREGIONID);

/*==============================================================*/
/* Index: RESIDUE_PUBLIC_DATA_LCX                               */
/*==============================================================*/
create index RESIDUE_PUBLIC_DATA_LCX on RESIDUE_PUBLIC_DATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: RESIDUE_TRK                                           */
/*==============================================================*/
create table RESIDUE_TRK
(
   CONTRACTID           varchar(30)  comment 'SRA Contract identifier',
   VERSIONNO            numeric(3,0) not null  comment 'Contract run version',
   RUNDATE              datetime  comment 'Date auction results determined',
   AUTHORISEDDATE       datetime  comment 'Date results published',
   AUTHORISEDBY         varchar(15)  comment 'Authorising officer or process',
   POSTDATE             datetime  comment 'Date the run is authorised',
   POSTEDBY             varchar(15)  comment 'Name of authorising officer or process',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   STATUS               varchar(15)  comment 'Load status [SUCCESSFUL/CORRUPT]',
   AUCTIONID            varchar(30) not null  comment 'Unique id for each auction date. (new in March 2003 to support SRA Inter-Temporal Linking)'
);

alter table RESIDUE_TRK comment 'RESIDUE_TRK supports the Settlement Residue Auction, by show';

alter table RESIDUE_TRK
   add primary key (AUCTIONID, VERSIONNO);

/*==============================================================*/
/* Index: RESIDUETRK_NDX_LCHD                                   */
/*==============================================================*/
create index RESIDUETRK_NDX_LCHD on RESIDUE_TRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: ROOFTOP_PV_ACTUAL                                     */
/*==============================================================*/
create table ROOFTOP_PV_ACTUAL
(
   INTERVAL_DATETIME    datetime not null  comment 'The forecast half-hour interval (time ending)',
   TYPE                 varchar(20) not null  comment 'One of DAILY, MEASUREMENT or SATELLITE. DAILY- best quality estimated actuals, available day after. MEASUREMENT- best quality estimated actuals on day, delayed by 1 half hour. SATELLITE- estimated actuals using satellite imagery, delayed by 1 half hour.',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   POWER                numeric(12,3)  comment 'Estimated generation in MW at the interval end',
   QI                   numeric(2,1)  comment 'Quality indicator. Represents the quality of the estimate.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table ROOFTOP_PV_ACTUAL comment 'Estimate of regional Rooftop Solar actual generation for eac';

alter table ROOFTOP_PV_ACTUAL
   add primary key (INTERVAL_DATETIME, TYPE, REGIONID);

/*==============================================================*/
/* Table: ROOFTOP_PV_ACTUAL_PRED                                */
/*==============================================================*/
create table ROOFTOP_PV_ACTUAL_PRED
(
   PREDICTION_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) from which this prediction run is valid.',
   INTERVAL_DURATION    numeric(3,0) not null  comment 'Duration of each interval (in minutes) for this prediction, for example, 5 or 30.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this prediction submission was loaded.',
   ESTIMATE_TYPE        varchar(20) not null  comment 'Type of Rooftop PV estimate, for example, MEASURED, SATELLITE and so on.',
   PROVIDERID           varchar(20) not null  comment 'Provider identifier, for example, AEMO, PROVIDER_A and so on.',
   PREDICTION_PRIORITY  numeric(10,0) not null  comment 'Priority of prediction run, higher number is used in preference to lower number for the same provider.',
   INTERVAL_DATETIME    datetime not null  comment 'Date and Time the forecast applies (dispatch interval ending).',
   PREDICTION_VALUE     numeric(18,8)  comment 'Prediction value in MW.',
   PREDICTION_QUALITY   numeric(2,0)  comment 'Prediction quality. Higher number represents better quality.'
);

alter table ROOFTOP_PV_ACTUAL_PRED comment 'Contains predictions for rooftop PV area estimated actuals, ';

alter table ROOFTOP_PV_ACTUAL_PRED
   add primary key (PREDICTION_RUN_DATETIME, INTERVAL_DURATION, AREAID, OFFERDATETIME, ESTIMATE_TYPE, PROVIDERID, PREDICTION_PRIORITY, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: ROOFTOP_PV_ACTUAL_RUN                                 */
/*==============================================================*/
create table ROOFTOP_PV_ACTUAL_RUN
(
   PREDICTION_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) from which this prediction run is valid.',
   INTERVAL_DURATION    numeric(3,0) not null  comment 'Duration of each interval (in minutes) for this prediction, for example, 5 or 30.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this prediction submission was loaded.',
   ESTIMATE_TYPE        varchar(20) not null  comment 'Type of Rooftop PV estimate, for example, MEASURED, SATELLITE and so on.',
   PROVIDERID           varchar(20) not null  comment 'Provider identifier, for example, AEMO, PROVIDER_A and so on.',
   PREDICTION_PRIORITY  numeric(10,0) not null  comment 'Priority of prediction run, higher number is used in preference to lower number for the same provider.',
   PROVIDER_TIMESTAMP   datetime  comment 'Datetime when the provider created the forecast.',
   REMARKS              varchar(300)  comment 'Comments relating to the prediction run.',
   MODEL_USED           varchar(30)  comment 'Metadata describing the model used to produce the prediction run.',
   SUPPRESSED_PROVIDER  numeric(1,0)  comment 'Flag indicating if the prediction run was suppressed by the provider when submitted. Suppressed predictions are not used by downstream forecasting systems. Suppressed = 1, Unsuppressed = 0.',
   INSTALLED_CAPACITY   numeric(18,8)  comment 'Installed rooftop PV capacity used for the prediction run, in MW.',
   LASTCHANGED          datetime  comment 'Datetime when the prediction run was written into AEMO database.'
);

alter table ROOFTOP_PV_ACTUAL_RUN comment 'Contains prediction runs for rooftop PV area estimated actua';

alter table ROOFTOP_PV_ACTUAL_RUN
   add primary key (PREDICTION_RUN_DATETIME, INTERVAL_DURATION, AREAID, OFFERDATETIME, ESTIMATE_TYPE, PROVIDERID, PREDICTION_PRIORITY);

/*==============================================================*/
/* Table: ROOFTOP_PV_FCST_P5_PRED                               */
/*==============================================================*/
create table ROOFTOP_PV_FCST_P5_PRED
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed in which case the previous run is used.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier, for example, AEMO, PROVIDER_A and so on.',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   INTERVAL_DATETIME    datetime not null  comment 'Datetime (interval-ending) for the period that this forecast applies to, within the current forecast_run_datetime.',
   FORECAST_TYPE        varchar(20) not null  comment 'Type of forecast, for example, POE_10, POE_50, POE_90, MEAN and so on.',
   FORECAST_VALUE       numeric(18,8)  comment 'Forecast value in MW.'
);

alter table ROOFTOP_PV_FCST_P5_PRED comment 'Contains forecast predictions for rooftop PV areas, with a 5';

alter table ROOFTOP_PV_FCST_P5_PRED
   add primary key (FORECAST_RUN_DATETIME, AREAID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY, INTERVAL_DATETIME, FORECAST_TYPE);

/*==============================================================*/
/* Table: ROOFTOP_PV_FCST_P5_RUN                                */
/*==============================================================*/
create table ROOFTOP_PV_FCST_P5_RUN
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier, for example, AEMO, PROVIDER_A and so on.',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   PROVIDER_TIMESTAMP   datetime  comment 'Datetime when the provider created the forecast.',
   REMARKS              varchar(300)  comment 'Comments relating to the forecast run.',
   MODEL_USED           varchar(30)  comment 'Metadata describing the model used to produce the forecast run.',
   SUPPRESSED_PROVIDER  numeric(1,0)  comment 'Flag indicating if the forecast run was suppressed by the provider when submitted. Suppressed forecasts are not used by downstream systems. Suppressed = 1, Unsuppressed = 0.',
   INSTALLED_CAPACITY   numeric(18,8)  comment 'Installed rooftop PV capacity that was used for the forecast run, in MW.',
   LASTCHANGED          datetime  comment 'Datetime when the forecast run was written into AEMO database.'
);

alter table ROOFTOP_PV_FCST_P5_RUN comment 'Contains forecast runs for rooftop PV areas, with a 5-minute';

alter table ROOFTOP_PV_FCST_P5_RUN
   add primary key (FORECAST_RUN_DATETIME, AREAID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: ROOFTOP_PV_FCST_PRED                                  */
/*==============================================================*/
create table ROOFTOP_PV_FCST_PRED
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier, for example, AEMO, PROVIDER_A and so on.',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   INTERVAL_DATETIME    datetime not null  comment 'Datetime (interval-ending) for the period that this forecast applies to, within the current forecast_run_datetime.',
   FORECAST_TYPE        varchar(20) not null  comment 'Type of forecast, for example, POE_10, POE_50, POE_90, MEAN and so on.',
   FORECAST_VALUE       numeric(18,8)  comment 'Forecast value in MW.'
);

alter table ROOFTOP_PV_FCST_PRED comment 'Contains forecast predictions for rooftop PV areas, with a 3';

alter table ROOFTOP_PV_FCST_PRED
   add primary key (FORECAST_RUN_DATETIME, AREAID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY, INTERVAL_DATETIME, FORECAST_TYPE);

/*==============================================================*/
/* Table: ROOFTOP_PV_FCST_RUN                                   */
/*==============================================================*/
create table ROOFTOP_PV_FCST_RUN
(
   FORECAST_RUN_DATETIME datetime not null  comment 'Datetime (interval ending) when this forecast run is valid. It aligns with run_datetime in downstream processes, unless a forecast run is missed, in this case the previous run is used.',
   AREAID               varchar(10) not null  comment 'Area identifier, aligning with the load forecasting areas.',
   OFFERDATETIME        datetime not null  comment 'Datetime when this forecast submission was loaded.',
   PROVIDERID           varchar(20) not null  comment 'Forecast provider identifier, for example, AEMO, PROVIDER_A and so on.',
   FORECAST_PRIORITY    numeric(10,0) not null  comment 'Priority of forecast run, higher number is used in preference to lower number for the same provider.',
   PROVIDER_TIMESTAMP   datetime  comment 'Datetime when the provider created the forecast.',
   REMARKS              varchar(300)  comment 'Comments relating to the forecast run.',
   MODEL_USED           varchar(30)  comment 'Metadata describing the model used to produce the forecast run.',
   SUPPRESSED_PROVIDER  numeric(1,0)  comment 'Flag indicating if the forecast run was suppressed by the provider when submitted. Suppressed forecasts are not used by downstream systems. Suppressed = 1, Unsuppressed = 0.',
   INSTALLED_CAPACITY   numeric(18,8)  comment 'Installed rooftop PV capacity that was used for the forecast run, in MW.',
   LASTCHANGED          datetime  comment 'Datetime when the forecast run was written into AEMO database.'
);

alter table ROOFTOP_PV_FCST_RUN comment 'Contains forecast runs for rooftop PV areas, with a 30-minut';

alter table ROOFTOP_PV_FCST_RUN
   add primary key (FORECAST_RUN_DATETIME, AREAID, OFFERDATETIME, PROVIDERID, FORECAST_PRIORITY);

/*==============================================================*/
/* Table: ROOFTOP_PV_FORECAST                                   */
/*==============================================================*/
create table ROOFTOP_PV_FORECAST
(
   VERSION_DATETIME     datetime not null  comment 'Date time this forecast was produced',
   REGIONID             varchar(20) not null  comment 'Region identifier',
   INTERVAL_DATETIME    datetime not null  comment 'The forecast half-hour interval (time ending)',
   POWERMEAN            numeric(12,3)  comment 'The average forecast value in MW at the interval end',
   POWERPOE50           numeric(12,3)  comment '50% probability of exceedance forecast value in MW at the interval end',
   POWERPOELOW          numeric(12,3)  comment '90% probability of exceedance forecast value in MW at the interval end',
   POWERPOEHIGH         numeric(12,3)  comment '10% probability of exceedance forecast value in MW at the interval end',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table ROOFTOP_PV_FORECAST comment 'Regional forecasts of Rooftop Solar generation across the ha';

alter table ROOFTOP_PV_FORECAST
   add primary key (VERSION_DATETIME, INTERVAL_DATETIME, REGIONID);

/*==============================================================*/
/* Table: SECDEPOSIT_INTEREST_RATE                              */
/*==============================================================*/
create table SECDEPOSIT_INTEREST_RATE
(
   INTEREST_ACCT_ID     varchar(20) not null  comment 'The interest account ID for calculating the interest payment',
   EFFECTIVEDATE        datetime not null  comment 'The effective date of the interest rate change',
   VERSION_DATETIME     datetime not null  comment 'Date Time this record was added',
   INTEREST_RATE        numeric(18,8)  comment 'The interest rate for the interest account ID as on the effective date.'
);

alter table SECDEPOSIT_INTEREST_RATE comment 'The security deposit interest rate on a daily basis. This is';

alter table SECDEPOSIT_INTEREST_RATE
   add primary key (INTEREST_ACCT_ID, EFFECTIVEDATE, VERSION_DATETIME);

/*==============================================================*/
/* Table: SECDEPOSIT_PROVISION                                  */
/*==============================================================*/
create table SECDEPOSIT_PROVISION
(
   SECURITY_DEPOSIT_ID  varchar(20) not null  comment 'The security deposit ID',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant ID linked to the security deposit ID',
   TRANSACTION_DATE     datetime  comment 'The date the security deposit ID is entered and authorised by settlements',
   MATURITY_CONTRACTYEAR numeric(4,0)  comment 'The contract year of the billing week when the security deposit is maturing',
   MATURITY_WEEKNO      numeric(3,0)  comment 'The week no of the billing week when the security deposit is maturing',
   AMOUNT               numeric(18,8)  comment 'The security deposit amount',
   INTEREST_RATE        numeric(18,8)  comment 'The interest rate assigned to the security deposit ID. Null if INTEREST_CALC_TYPE <> FIXED',
   INTEREST_CALC_TYPE   varchar(20)  comment 'FIXED OR DAILY',
   INTEREST_ACCT_ID     varchar(20)  comment 'The Interest Account ID for calculating the Interest Payment. This is NULL if the INTEREST_CALC_TYPE = FIXED'
);

alter table SECDEPOSIT_PROVISION comment 'The security deposit provision entry details';

alter table SECDEPOSIT_PROVISION
   add primary key (SECURITY_DEPOSIT_ID, PARTICIPANTID);

/*==============================================================*/
/* Table: SETAGCPAYMENT                                         */
/*==============================================================*/
create table SETAGCPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement Period Identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor of Unit',
   EBP                  numeric(15,5)  comment 'Eligible Bid Price',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   CLEAREDMW            numeric(15,5)  comment 'Cleared MW of Unit in Enabled Dispatch period',
   INITIALMW            numeric(15,5)  comment 'Initial MW of Unit in Enabled Dispatch period',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'AS contract version no',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETAGCPAYMENT comment 'SETAGCPAYMENT sets out specific payment details for Automati';

alter table SETAGCPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETAGCPAYMENT_NDX2                                    */
/*==============================================================*/
create index SETAGCPAYMENT_NDX2 on SETAGCPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETAGCPAYMENT_LCX                                     */
/*==============================================================*/
create index SETAGCPAYMENT_LCX on SETAGCPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETAGCRECOVERY                                        */
/*==============================================================*/
create table SETAGCRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment '',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'Total Regional Demand',
   ENABLINGRECOVERY     numeric(15,5)  comment 'Enabling Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ENABLINGRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total Regional Demand for Generator'
);

alter table SETAGCRECOVERY comment 'SETAGCRECOVERY shows reimbursements for Automatic Generation';

alter table SETAGCRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETAGCRECOVERY_LCX                                    */
/*==============================================================*/
create index SETAGCRECOVERY_LCX on SETAGCRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETAPCCOMPENSATION                                    */
/*==============================================================*/
create table SETAPCCOMPENSATION
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement period (based on calendar day)',
   APCCOMPENSATION      numeric(15,5)  comment 'APC amount',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETAPCCOMPENSATION comment 'SETAPCCOMPENSATION shows Administered Price Cap (APC) compen';

alter table SETAPCCOMPENSATION
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, REGIONID, PERIODID);

/*==============================================================*/
/* Index: SETAPCCOMPENSATION_LCX                                */
/*==============================================================*/
create index SETAPCCOMPENSATION_LCX on SETAPCCOMPENSATION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETAPCRECOVERY                                        */
/*==============================================================*/
create table SETAPCRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement period (based on calendar day)',
   TOTALCOMPENSATION    numeric(15,5)  comment 'Total compensation',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant MW Demand',
   REGIONDEMAND         numeric(15,5)  comment 'Total region demand',
   APCRECOVERY          numeric(15,5)  comment 'APC Recovery amount',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETAPCRECOVERY comment 'SETAPCRECOVERY shows reimbursements for Administered Price C';

alter table SETAPCRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, REGIONID, PERIODID);

/*==============================================================*/
/* Index: SETAPCRECOVERY_LCX                                    */
/*==============================================================*/
create index SETAPCRECOVERY_LCX on SETAPCRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETCFG_PARTICIPANT_MPF                                */
/*==============================================================*/
create table SETCFG_PARTICIPANT_MPF
(
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   EFFECTIVEDATE        datetime not null  comment 'Effective date of the MPF data',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of the MPF data',
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'Participant Category',
   CONNECTIONPOINTID    varchar(10) not null  comment 'Connection point identifier',
   MPF                  numeric(15,5)  comment 'Market Participation Factor',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETCFG_PARTICIPANT_MPF comment 'SETCFG_PARTICIPANT_MPF shows the Market Participation Factor';

alter table SETCFG_PARTICIPANT_MPF
   add primary key (PARTICIPANTID, EFFECTIVEDATE, VERSIONNO, PARTICIPANTCATEGORYID, CONNECTIONPOINTID);

/*==============================================================*/
/* Index: SETCFG_PARTI_MPF_LCHD_IDX                             */
/*==============================================================*/
create index SETCFG_PARTI_MPF_LCHD_IDX on SETCFG_PARTICIPANT_MPF
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETCFG_PARTICIPANT_MPFTRK                             */
/*==============================================================*/
create table SETCFG_PARTICIPANT_MPFTRK
(
   PARTICIPANTID        varchar(10) not null  comment 'Participant identifier',
   EFFECTIVEDATE        datetime not null  comment 'Effective date of the MPF data',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of the MPF data',
   AUTHORISEDBY         varchar(15)  comment 'Authorising user',
   AUTHORISEDDATE       datetime  comment 'Authorised date and time',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETCFG_PARTICIPANT_MPFTRK comment 'SETCFG_PARTICIPANT_MPFTRK is the tracking table for Market P';

alter table SETCFG_PARTICIPANT_MPFTRK
   add primary key (PARTICIPANTID, EFFECTIVEDATE, VERSIONNO);

/*==============================================================*/
/* Index: SETCFG_PARTI_MPFTRK_LCHD_IDX                          */
/*==============================================================*/
create index SETCFG_PARTI_MPFTRK_LCHD_IDX on SETCFG_PARTICIPANT_MPFTRK
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETCFG_SAPS_SETT_PRICE                                */
/*==============================================================*/
create table SETCFG_SAPS_SETT_PRICE
(
   FROMDATE             datetime not null  comment 'The From Date of the SAPS Pricing Application Period',
   TODATE               datetime not null  comment 'The To Date of the SAPS Pricing Application Period',
   REGIONID             varchar(20) not null  comment 'The Region ID for which the calculated SAPS Price is applicable',
   VERSION_DATETIME     datetime not null  comment 'The Date time of the record generation',
   SAPS_RRP             numeric(18,8)  comment 'The Region Reference Price for SAPS in the Region',
   ISFIRM               numeric(3,0)  comment 'Whether the SAPS Price is Firm or Non-Firm',
   LASTCHANGED          datetime  comment 'The Last Changed Date time of the record'
);

alter table SETCFG_SAPS_SETT_PRICE comment 'The Settlement Price for SAPS Energy in each Region';

alter table SETCFG_SAPS_SETT_PRICE
   add primary key (FROMDATE, TODATE, REGIONID, VERSION_DATETIME);

/*==============================================================*/
/* Table: SETCFG_WDRRR_CALENDAR                                 */
/*==============================================================*/
create table SETCFG_WDRRR_CALENDAR
(
   WDRRRPERIOD          varchar(20) not null  comment 'Unique identifier for the period to which the WDRRR applies. For quarter-based periods, this will be equal to YYYY[Q]NN, for example,2020Q3 for 2020 Quarter 3.',
   REGIONID             varchar(20) not null  comment 'Unique Identifier for the region id',
   VERSION_DATETIME     datetime(3) not null  comment 'The Version Date time of the latest changes.',
   STARTDATE            datetime  comment 'Start Date of Period (Inclusive).',
   ENDDATE              datetime  comment 'End Date of Period (Inclusive).',
   LASTCHANGED          datetime(3)  comment 'Last changed date for the record.'
);

alter table SETCFG_WDRRR_CALENDAR comment 'Wholesale Demand Response Reimbursement Rate Calendar';

alter table SETCFG_WDRRR_CALENDAR
   add primary key (WDRRRPERIOD, REGIONID, VERSION_DATETIME);

/*==============================================================*/
/* Table: SETCFG_WDR_REIMBURSE_RATE                             */
/*==============================================================*/
create table SETCFG_WDR_REIMBURSE_RATE
(
   WDRRRPERIOD          varchar(20) not null  comment 'Unique identifier for the period to which the WDRRR applies. For quarter-based periods, this will be equal to YYYY[Q]NN, e.g. 2020Q3 for 2020 Quarter 3.',
   REGIONID             varchar(20) not null  comment 'Unique identifier for the region',
   VERSION_DATETIME     datetime(3) not null  comment 'The Version Date time of the latest changes.',
   WDRRR                numeric(18,8)  comment 'WDRRR value for the period and region ($/MWh)',
   ISFIRM               numeric(3,0)  comment 'A flag to indicate that the WDRRR value is FIRM for the period and region, i.e. it is based on a complete set of firm prices from dispatch. Possible Values are 1 and 0',
   LASTCHANGED          datetime(3)  comment 'Last changed date for the record'
);

alter table SETCFG_WDR_REIMBURSE_RATE comment 'Settlements WDR transactions';

alter table SETCFG_WDR_REIMBURSE_RATE
   add primary key (WDRRRPERIOD, REGIONID, VERSION_DATETIME);

/*==============================================================*/
/* Table: SETCPDATA                                             */
/*==============================================================*/
create table SETCPDATA
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(10,0) not null  comment 'Settlement run no',
   PERIODID             numeric(10,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   TCPID                varchar(10) not null  comment 'Connection point identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   IGENERGY             numeric(16,6)  comment 'Import Gross energy into the pool - MWh',
   XGENERGY             numeric(16,6)  comment 'Export Gross energy from the pool - MWh',
   INENERGY             numeric(16,6)  comment 'Import Nett energy into the pool - MWh, plus UFEA if the UFEA amount is positive. When GS commences, this includes the UFEA amount in the settlement runs.',
   XNENERGY             numeric(16,6)  comment 'Export Nett energy from the pool - MWh, plus (UFEA * -1) if the UFEA amount is negative. When GS commences, this includes the UFEA amount in the settlement runs.',
   IPOWER               numeric(16,6)  comment 'Import reactive power',
   XPOWER               numeric(16,6)  comment 'Export reactive power',
   RRP                  numeric(20,5)  comment 'Regional Reference Price',
   EEP                  numeric(16,6)  comment 'Excess Energy Price',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   CPRRP                numeric(16,6)  comment 'Connection Point Price = RRP * TLF',
   CPEEP                numeric(16,6)  comment 'Connection Point Excess Energy Price = EEP * TLF',
   TA                   numeric(16,6)  comment 'Export - Import of Net energy (MWh)',
   EP                   numeric(16,6)  comment 'settlement amount in $ for trading period',
   APC                  numeric(16,6)  comment 'Not used',
   RESC                 numeric(16,6)  comment 'Not used',
   RESP                 numeric(16,6)  comment 'Not used',
   METERRUNNO           numeric(10,0)  comment 'Meter Run Number = version number of the meter file',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   HOSTDISTRIBUTOR      varchar(10)  comment 'Not used',
   MDA                  varchar(10) not null  comment 'Metering Data Agent',
   AFE                  numeric(18,8)  comment 'Accounted For Energy for this Market Customer FRMP and TNI in the Settlements Trading Interval, excluding any UFEA component',
   DME                  numeric(18,8)  comment 'Sum of ME- for all NMIs at this Market Customer FRMP and TNI in the Settlements Trading Interval.',
   UFEA                 numeric(18,8)  comment 'Share of UFE allocated to this FRMP and TNI in the Settlements Trading Interval.',
   AGE                  numeric(18,8)  comment 'Adjusted Gross Energy for this Market Customer FRMP and TNI in the Settlements Trading Interval. When GS commences, this includes the UFEA amount in the settlement runs.',
   IMPORTENERGYCOST     numeric(18,8)  comment 'The total cost of energy sold at the connection point by the participant in this settlement interval',
   EXPORTENERGYCOST     numeric(18,8)  comment 'The total cost of energy purchased at the connection point by the participant in this settlement interval'
);

alter table SETCPDATA comment 'SETCPDATA shows meter settlement data for each connection po';

alter table SETCPDATA
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, PARTICIPANTID, TCPID, MDA);

/*==============================================================*/
/* Index: SETCPDATA_NDX2                                        */
/*==============================================================*/
create index SETCPDATA_NDX2 on SETCPDATA
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETCPDATA_LCX                                         */
/*==============================================================*/
create index SETCPDATA_LCX on SETCPDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETCPDATAREGION                                       */
/*==============================================================*/
create table SETCPDATAREGION
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(22,10) not null  comment 'Settlement run no',
   PERIODID             numeric(22,10) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   SUMIGENERGY          numeric(27,5)  comment 'Import Gross energy into the pool - MWh',
   SUMXGENERGY          numeric(27,5)  comment 'Export Gross energy from the pool - MWh',
   SUMINENERGY          numeric(27,5)  comment 'Import Nett energy into the pool - MWh',
   SUMXNENERGY          numeric(27,5)  comment 'Export Nett energy from the pool - MWh',
   SUMIPOWER            numeric(22,0)  comment 'Not used',
   SUMXPOWER            numeric(22,0)  comment 'Not used',
   LASTCHANGED          datetime  comment 'current system date, to enable automatic replication',
   SUMEP                numeric(15,5)  comment 'Sum of energy price across the region'
);

alter table SETCPDATAREGION comment 'SETCPDATAREGION sets out summary meter settlement data for e';

alter table SETCPDATAREGION
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETCPDATAREGION_LCX                                   */
/*==============================================================*/
create index SETCPDATAREGION_LCX on SETCPDATAREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETFCASCOMP                                           */
/*==============================================================*/
create table SETFCASCOMP
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit ID',
   REGIONID             varchar(10)  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'Period Identifier',
   CCPRICE              numeric(15,5)  comment 'Compensation Cap',
   CLEAREDMW            numeric(15,5)  comment 'Cleared MW of Unit in First Dispatch period in Trading Interval',
   UNCONSTRAINEDMW      numeric(15,5)  comment 'Initial MW of Unit in First Dispatch period in Trading Interval',
   EBP                  numeric(15,5)  comment 'Eligible Bid Price',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor of Unit',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   EXCESSGEN            numeric(15,5)  comment 'Excess Generation Payment in trading interval',
   FCASCOMP             numeric(15,5)  comment 'Frequency Control AS Compensation payment to Generator',
   LASTCHANGED          datetime  comment ''
);

alter table SETFCASCOMP comment 'SETFCASCOMP shows the compensation details for Frequency Con';

alter table SETFCASCOMP
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, DUID, PERIODID);

/*==============================================================*/
/* Index: SETFCASCOMP_LCX                                       */
/*==============================================================*/
create index SETFCASCOMP_LCX on SETFCASCOMP
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETFCASRECOVERY                                       */
/*==============================================================*/
create table SETFCASRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run no',
   DUID                 varchar(10)  comment 'Dispatchable Unit identifier',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlement Period identifier',
   FCASCOMP             numeric(15,5)  comment 'Frequency Control Ancillary Service Compensation Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'Total Regional demand',
   FCASRECOVERY         numeric(15,5)  comment 'Frequency Control Ancillary Service recovery amount.',
   LASTCHANGED          datetime  comment 'Date and Time last changed',
   FCASRECOVERY_GEN     numeric(15,5)  comment 'Frequency Control Ancillary Service recovery amount for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total Regional Demand for Generator'
);

alter table SETFCASRECOVERY comment 'SETFCASERECOVERY shows reimbursements for the Frequency Cont';

alter table SETFCASRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, REGIONID, PERIODID);

/*==============================================================*/
/* Index: SETFCASRECOVERY_LCX                                   */
/*==============================================================*/
create index SETFCASRECOVERY_LCX on SETFCASRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETFCASREGIONRECOVERY                                 */
/*==============================================================*/
create table SETFCASREGIONRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date of trading interval',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run no',
   BIDTYPE              varchar(10) not null  comment 'FCAS Service Type',
   REGIONID             varchar(10) not null  comment 'RegionID',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   GENERATORREGIONENERGY numeric(16,6)  comment 'Generator Regional Energy Amount. NULL for Settlement dates post the IESS rule effective date',
   CUSTOMERREGIONENERGY numeric(16,6)  comment 'Customer Region Energy Amount. NULL for Settlement dates post the IESS rule effective date',
   REGIONRECOVERY       numeric(18,8)  comment 'The NEM Regional Recovery Amount for FCAS',
   LASTCHANGED          datetime  comment 'Last Date record changed',
   REGION_ACE_MWH       numeric(18,8)  comment 'The Regional ACE MWh value used for the FCAS Recovery. NULL for Settlement dates prior to the IESS rule effective date',
   REGION_ASOE_MWH      numeric(18,8)  comment 'The Regional ASOE MWh value used for the FCAS Recovery. NULL for Settlement dates prior to the IESS rule effective date',
   REGIONRECOVERYAMOUNT_ACE numeric(18,8)  comment 'The Total Dollar Amount for the Region recovered using the ACE MWh Values. NULL for Settlement dates prior to the IESS rule effective date',
   REGIONRECOVERYAMOUNT_ASOE numeric(18,8)  comment 'The Total Dollar Amount for the Region recovered using the ASOE MWh Values. NULL for Settlement dates prior to the IESS rule effective date',
   REGIONRECOVERYAMOUNT numeric(18,8)  comment 'The Total Dollar Amount for the Region (RegionRecoveryAmountACE + RegionRecoveryAmountASOE). NULL for Settlement dates prior to the IESS rule effective date'
);

alter table SETFCASREGIONRECOVERY comment 'The FCAS Recovery amount from each NEM Region and the Energy';

alter table SETFCASREGIONRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, BIDTYPE, REGIONID, PERIODID);

/*==============================================================*/
/* Index: SETFCASREGIONRECOVERY_NDX_LCHD                        */
/*==============================================================*/
create index SETFCASREGIONRECOVERY_NDX_LCHD on SETFCASREGIONRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETGENDATA                                            */
/*==============================================================*/
create table SETGENDATA
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(10,0) not null  comment 'Settlement run no',
   PERIODID             numeric(10,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   STATIONID            varchar(10) not null  comment 'Station Identifier',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit identifier',
   GENSETID             varchar(10) not null  comment 'Physical unit identifier',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   GENERGY              numeric(16,6)  comment 'Generated energy',
   AENERGY              numeric(16,6)  comment 'Purchased Energy',
   GPOWER               numeric(16,6)  comment 'Not used',
   APOWER               numeric(16,6)  comment 'Not used',
   RRP                  numeric(20,5)  comment 'Regional Reference Price',
   EEP                  numeric(16,6)  comment 'Excess Energy Price',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   CPRRP                numeric(16,6)  comment 'Connection Point Price = RRP * TLF',
   CPEEP                numeric(16,6)  comment 'Connection Point Excess Energy Price = EEP * TLF',
   NETENERGY            numeric(16,6)  comment 'Generated energy',
   ENERGYCOST           numeric(16,6)  comment 'Cost of net energy $',
   EXCESSENERGYCOST     numeric(16,6)  comment 'Cost of excess energy $',
   APC                  numeric(16,6)  comment 'Administered Price Compensation',
   RESC                 numeric(16,6)  comment 'Not used',
   RESP                 numeric(16,6)  comment 'Not used',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   EXPENERGY            numeric(15,6)  comment 'Export Energy (Generator Purchases) (MWh)',
   EXPENERGYCOST        numeric(15,6)  comment 'Export Energy Cost ($)',
   METERRUNNO           numeric(6,0)  comment 'Identifier of the meter run used in this settlement calculation',
   MDA                  varchar(10)  comment 'Metering Data Agent',
   SECONDARY_TLF        numeric(7,5)  comment 'Secondary Transmission Loss Factor'
);

alter table SETGENDATA comment 'SETGENDATA shows meter settlement data for each generation m';

alter table SETGENDATA
   add primary key (SETTLEMENTDATE, VERSIONNO, REGIONID, STATIONID, DUID, GENSETID, PERIODID);

/*==============================================================*/
/* Index: SETGENDATA_NDX2                                       */
/*==============================================================*/
create index SETGENDATA_NDX2 on SETGENDATA
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETGENDATA_LCX                                        */
/*==============================================================*/
create index SETGENDATA_LCX on SETGENDATA
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETGENDATAREGION                                      */
/*==============================================================*/
create table SETGENDATAREGION
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(22,10) not null  comment 'Settlement run no',
   PERIODID             numeric(22,10) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   GENERGY              numeric(22,0)  comment 'Generated energy - Not used in MMS Data Model',
   AENERGY              numeric(22,0)  comment 'Purchased Energy - Not used in MMS Data Model',
   GPOWER               numeric(22,0)  comment 'Not used in MMS Data Model',
   APOWER               numeric(22,0)  comment 'Not used in MMS Data Model',
   NETENERGY            numeric(27,5)  comment 'Net energy MW/hours',
   ENERGYCOST           numeric(27,5)  comment 'Cost of net energy $',
   EXCESSENERGYCOST     numeric(27,5)  comment 'Cost of excess energy $',
   EXPENERGY            numeric(27,6)  comment 'Export Energy (Generator Purchases)',
   EXPENERGYCOST        numeric(27,6)  comment 'Export Energy Cost',
   LASTCHANGED          datetime  comment 'current system date, to enable automatic replication'
);

alter table SETGENDATAREGION comment 'SETGENDATAREGION sets out summary settlement data for genera';

alter table SETGENDATAREGION
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETGENDATAREGION_LCX                                  */
/*==============================================================*/
create index SETGENDATAREGION_LCX on SETGENDATAREGION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETGOVPAYMENT                                         */
/*==============================================================*/
create table SETGOVPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Period Identifier',
   DUID                 varchar(10)  comment 'Dispatchable Unit ID',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor of Unit',
   RL6SECRAISE          numeric(15,5)  comment 'contract enabling price - 6 sec raise',
   RL60SECRAISE         numeric(15,5)  comment 'contract enabling price - 60 sec raise',
   RL6SECLOWER          numeric(15,5)  comment 'contract enabling price - 6 sec lower',
   RL60SECLOWER         numeric(15,5)  comment 'contract enabling price - 60 sec lower',
   DEADBANDUP           numeric(7,5)  comment 'contracted dead band up',
   DEADBANDDOWN         numeric(7,5)  comment 'contracted dead band down',
   R6                   numeric(15,5)  comment '6 sec raise response for 1% deviation in frequency (droop equation)',
   R60                  numeric(15,5)  comment '60 sec raise response for 1% deviation in frequency (droop equation)',
   L6                   numeric(15,5)  comment '6 sec lower response for 1% deviation in frequency (droop equation)',
   L60                  numeric(15,5)  comment '60 sec lower response for 1% deviation in frequency (droop equation)',
   RL6                  numeric(15,5)  comment '6 sec raise response limit equation',
   RL60                 numeric(15,5)  comment '60 sec raise response limit equation',
   LL6                  numeric(15,5)  comment '6 sec lower response limit equation',
   LL60                 numeric(15,5)  comment '6 sec lower response limit equation',
   ENABLING6RPAYMENT    numeric(15,5)  comment '6 sec raise enabling payment',
   ENABLING60RPAYMENT   numeric(15,5)  comment '60 sec raise enabling payment',
   ENABLING6LPAYMENT    numeric(15,5)  comment '6 sec lower enabling payment',
   ENABLING60LPAYMENT   numeric(15,5)  comment '60 sec lower enabling payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'AS contract version no',
   OFFERDATE            datetime  comment 're-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 're-offer offer version',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETGOVPAYMENT comment 'SETGOVPAYMENTshows specific payment details for Governor ser';

alter table SETGOVPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETGOVPAYMENT_NDX2                                    */
/*==============================================================*/
create index SETGOVPAYMENT_NDX2 on SETGOVPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETGOVPAYMENT_LCX                                     */
/*==============================================================*/
create index SETGOVPAYMENT_LCX on SETGOVPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETGOVRECOVERY                                        */
/*==============================================================*/
create table SETGOVRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment '',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   ENABLING6RPAYMENT    numeric(15,5)  comment 'Enabling Payment 6 Second Raise',
   ENABLING60RPAYMENT   numeric(15,5)  comment 'Enabling Payment 60 Second Raise',
   ENABLING6LPAYMENT    numeric(15,5)  comment 'Enabling Payment 6 Second Lower',
   ENABLING60LPAYMENT   numeric(15,5)  comment 'Enabling Payment 60 Second Lower',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'Total Regional Demand',
   ENABLING6RRECOVERY   numeric(15,5)  comment 'Enabling Recovery 6 Second Raise',
   ENABLING60RRECOVERY  numeric(15,5)  comment 'Enabling Recovery 60 Second Raise',
   ENABLING6LRECOVERY   numeric(15,5)  comment 'Enabling Recovery 6 Second Lower',
   ENABLING60LRECOVERY  numeric(15,5)  comment 'Enabling Recovery 60 Second Lower',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ENABLING6LRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery 6 Second Lower for Generator',
   ENABLING6RRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery 6 Second Raise for Generator',
   ENABLING60LRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery 60 Second Lower for Generator',
   ENABLING60RRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery 60 Second Raise for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total Regional Demand for Generator'
);

alter table SETGOVRECOVERY comment 'SETGOVRECOVERY shows reimbursements for the Governor Ancilla';

alter table SETGOVRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETGOVRECOVERY_LCX                                    */
/*==============================================================*/
create index SETGOVRECOVERY_LCX on SETGOVRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETINTERVENTION                                       */
/*==============================================================*/
create table SETINTERVENTION
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PERIODID             numeric(3,0) not null  comment 'Settlement Period identifier',
   CONTRACTID           varchar(10)  comment 'Intervention Contract Identifier',
   CONTRACTVERSION      numeric(3,0)  comment 'Intervention Contract Version',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit ID',
   RCF                  char(1)  comment 'Regional Recovery Flag',
   INTERVENTIONPAYMENT  numeric(12,5)  comment 'Payment to Generator for Intervention',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETINTERVENTION comment 'SETINTERVENTION shows intervention settlement payment detail';

alter table SETINTERVENTION
   add primary key (SETTLEMENTDATE, VERSIONNO, DUID, PERIODID);

/*==============================================================*/
/* Index: SETINTERVENTION_LCX                                   */
/*==============================================================*/
create index SETINTERVENTION_LCX on SETINTERVENTION
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETINTERVENTIONRECOVERY                               */
/*==============================================================*/
create table SETINTERVENTIONRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PERIODID             numeric(3,0) not null  comment 'Settlement Period identifier',
   CONTRACTID           varchar(10) not null  comment 'Intervention Contract Identifier',
   RCF                  char(1)  comment 'Regional Recovery Flag',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTDEMAND    numeric(12,5)  comment 'Demand of Participant in Region/Market',
   TOTALDEMAND          numeric(12,5)  comment 'Total Demand of Region/Market',
   INTERVENTIONPAYMENT  numeric(12,5)  comment 'Payment to Generator for Intervention',
   INTERVENTIONAMOUNT   numeric(12,5)  comment 'Retailer Payment to Pool for Intervention',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10)  comment 'Region Identifier'
);

alter table SETINTERVENTIONRECOVERY comment 'SETINTERVENTIONRECOVERY shows intervention recovery details ';

alter table SETINTERVENTIONRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, CONTRACTID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETINTERVENTIONRECOVERY_LCX                           */
/*==============================================================*/
create index SETINTERVENTIONRECOVERY_LCX on SETINTERVENTIONRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETINTRAREGIONRESIDUES                                */
/*==============================================================*/
create table SETINTRAREGIONRESIDUES
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   RUNNO                numeric(3,0) not null  comment 'Settlement run number',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   EP                   numeric(15,5)  comment 'Energy payments to generators. NULL for Settlement dates post the IESS rule effective date',
   EC                   numeric(15,5)  comment 'Energy purchased by customers. NULL for Settlement dates post the IESS rule effective date',
   RRP                  numeric(15,5)  comment 'Regional price',
   EXP                  numeric(15,5)  comment 'Net import in MWh into the region calculated at the regional reference node (export is negative)',
   IRSS                 numeric(15,5)  comment 'Intra-regional surplus (a negative sign indicates surplus, and a positive sign indicates a deficiency)',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ACE_AMOUNT           numeric(18,8)  comment 'The Adjusted Consumed Energy Dollar Amount for the Region used in the calculation of IRSS (Intra Residue Amount). NULL for Settlement dates prior to the IESS rule effective date',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Adjusted Sent Out Energy Dollar Amount for the Region used in the calculation of IRSS (Intra Residue Amount). NULL for Settlement dates prior to the IESS rule effective date'
);

alter table SETINTRAREGIONRESIDUES comment 'The Settlement Intra Region Residues Result.';

alter table SETINTRAREGIONRESIDUES
   add primary key (SETTLEMENTDATE, RUNNO, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETINTRAREGIONRESIDUES_LCX                            */
/*==============================================================*/
create index SETINTRAREGIONRESIDUES_LCX on SETINTRAREGIONRESIDUES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETIRAUCSURPLUS                                       */
/*==============================================================*/
create table SETIRAUCSURPLUS
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number',
   CONTRACTID           varchar(10) not null  comment 'SRA Contract unique identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Contracted Interconnector identifier',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALSURPLUS         numeric(15,5)  comment 'Total value of surplus before allocation',
   CONTRACTALLOCATION   numeric(8,5)  comment 'Percentage allocated to participant',
   SURPLUSVALUE         numeric(15,5)  comment 'Amount NSP is paid for Inter/intra-Regional surplus energy produced',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP'
);

alter table SETIRAUCSURPLUS comment 'This view supports the Settlements Residue Auction, by holdi';

alter table SETIRAUCSURPLUS
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETIRAUCSURPLUS_LCX                                   */
/*==============================================================*/
create index SETIRAUCSURPLUS_LCX on SETIRAUCSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETIRFMRECOVERY                                       */
/*==============================================================*/
create table SETIRFMRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   PERIODID             numeric(3,0) not null  comment 'Settlement period ID',
   IRFMID               varchar(10) not null  comment 'Industrial Relations Forced Majeure event number',
   IRMFVERSION          numeric(3,0)  comment 'Industrial Relations Forced Majeure event number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant unique identifier',
   PARTICIPANTDEMAND    numeric(12,5)  comment 'Participant demand',
   TOTALTCD             numeric(12,5)  comment 'Total non franchised load in Victoria.',
   TOTALTFD             numeric(12,5)  comment 'Total franchised load in Victoria.',
   IRFMAMOUNT           numeric(12,5)  comment 'Industrial Relations Forced Majeure event amount in $.',
   IRFMPAYMENT          numeric(12,5)  comment 'Industrial Relations Forced Majeure payment amount in $.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETIRFMRECOVERY comment 'SETIRFMRECOVERY sets out reimbursements for Industrial Relat';

alter table SETIRFMRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, IRFMID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETIRFMRECOVERY_LCX                                   */
/*==============================================================*/
create index SETIRFMRECOVERY_LCX on SETIRFMRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETIRNSPSURPLUS                                       */
/*==============================================================*/
create table SETIRNSPSURPLUS
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number',
   CONTRACTID           varchar(10) not null  comment 'SRA Contract unique identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant unique identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Identifier of Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALSURPLUS         numeric(15,5)  comment 'Total value of surplus',
   CONTRACTALLOCATION   numeric(8,5)  comment 'Percentage of total surplus allocated to participant',
   SURPLUSVALUE         numeric(15,5)  comment 'Amount NSP is paid for Inter/intra-Regional surplus energy produced by the participant',
   LASTCHANGED          datetime  comment 'Date and time this record was last modified',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP'
);

alter table SETIRNSPSURPLUS comment 'This view supports the Settlements Residue Auction, by showi';

alter table SETIRNSPSURPLUS
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETIRNSPSURPLUS_LCX                                   */
/*==============================================================*/
create index SETIRNSPSURPLUS_LCX on SETIRNSPSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETIRPARTSURPLUS                                      */
/*==============================================================*/
create table SETIRPARTSURPLUS
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number',
   CONTRACTID           varchar(10) not null  comment 'Ancillary Service Contract',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant unique identifier',
   INTERCONNECTORID     varchar(10) not null  comment 'Identifier of the Contracted Interconnector',
   FROMREGIONID         varchar(10) not null  comment 'Nominated source region for Interconnector',
   TOTALSURPLUS         numeric(15,5)  comment 'Total value of surplus before allocation',
   CONTRACTALLOCATION   numeric(8,5)  comment 'Allocated percentage to participant',
   SURPLUSVALUE         numeric(15,5)  comment 'Amount NSP is paid for Inter/intra-Regional surplus energy produced',
   LASTCHANGED          datetime  comment 'Date and time this record was last updated',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP'
);

alter table SETIRPARTSURPLUS comment 'This view supports the Settlements Residue Auction, holding ';

alter table SETIRPARTSURPLUS
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, CONTRACTID, INTERCONNECTORID, FROMREGIONID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETIRPARTSURPLUS_LCX                                  */
/*==============================================================*/
create index SETIRPARTSURPLUS_LCX on SETIRPARTSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETIRSURPLUS                                          */
/*==============================================================*/
create table SETIRSURPLUS
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   INTERCONNECTORID     varchar(10) not null  comment 'Interconnector',
   REGIONID             varchar(10) not null  comment 'Side of interconnector',
   MWFLOW               numeric(15,6)  comment 'Net flow at the regional node (MWh), including losses',
   LOSSFACTOR           numeric(15,5)  comment 'MW losses along interconnector NOTE: This is not a loss factor, but a loss figure expressed in MWH',
   SURPLUSVALUE         numeric(15,5)  comment 'Amount of surplus in $',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   CSP_DEROGATION_AMOUNT numeric(18,8)  comment 'The CSP derogation amount applied as an adjustment to SRA',
   UNADJUSTED_IRSR      numeric(18,8)  comment 'The SRA amount unadjusted by CSP'
);

alter table SETIRSURPLUS comment 'SETIRSURPLUS records the interregional residue calculation f';

alter table SETIRSURPLUS
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, PERIODID, INTERCONNECTORID, REGIONID);

/*==============================================================*/
/* Index: SETIRSURPLUS_LCX                                      */
/*==============================================================*/
create index SETIRSURPLUS_LCX on SETIRSURPLUS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLOCALAREAENERGY                                    */
/*==============================================================*/
create table SETLOCALAREAENERGY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date of the settlement run',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number of the settlement run',
   LOCALAREAID          varchar(30) not null  comment 'Unique identifier for the local area',
   PERIODID             numeric(3,0) not null  comment 'Settlement Trading Interval',
   UFE                  numeric(18,8)  comment 'Total unaccounted-for energy for the local area in this trading interval, in MWh',
   DDME                 numeric(18,8)  comment 'DDME component of UFE for the local area in this trading interval, in MWh.',
   TME                  numeric(18,8)  comment 'TME component of UFE for the local area in this trading interval, in MWh.',
   ADME                 numeric(18,8)  comment 'ADME component of UFE for the local area in this trading interval, in MWh.',
   ADMELA               numeric(18,8)  comment 'The sum of all DME amounts for each Market Customer FRMP and TNI in the local area, in this trading interval.',
   LASTCHANGED          datetime  comment 'Last changed date time for the record'
);

alter table SETLOCALAREAENERGY comment 'SETLOCALAREAENERGY shows the UFE, AGE and associated values ';

alter table SETLOCALAREAENERGY
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, LOCALAREAID, PERIODID);

/*==============================================================*/
/* Table: SETLOCALAREATNI                                       */
/*==============================================================*/
create table SETLOCALAREATNI
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date of the settlement run',
   SETTLEMENTRUNNO      numeric(3,0) not null  comment 'Settlement run number of the settlement run',
   LOCALAREAID          varchar(30) not null  comment 'Unique identifier for the local area',
   TNI                  varchar(30) not null  comment 'Unique identifier for a TNI constituent to the local area as at the settlement run',
   LASTCHANGED          datetime  comment 'Last changed date time for the record'
);

alter table SETLOCALAREATNI comment 'SETLOCALAREATNI shows the list of TNIs constituent to a loca';

alter table SETLOCALAREATNI
   add primary key (SETTLEMENTDATE, SETTLEMENTRUNNO, LOCALAREAID, TNI);

/*==============================================================*/
/* Table: SETLSHEDPAYMENT                                       */
/*==============================================================*/
create table SETLSHEDPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   CONTRACTID           varchar(10) not null  comment 'AS Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   DUID                 varchar(10)  comment 'Dispatchable Unit Identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   LSEPRICE             numeric(15,5)  comment 'Load Shed Enabling Price',
   MCPPRICE             numeric(15,5)  comment 'Minimum Compensation Price',
   LSCR                 numeric(4,0)  comment 'Load Shed Control Range',
   LSEPAYMENT           numeric(15,5)  comment 'Load Shed Enabling Payment',
   CCPAYMENT            numeric(15,5)  comment 'Compensation Payment',
   CONSTRAINEDMW        numeric(15,5)  comment 'Cleared MW of unit at time of load shed usage',
   UNCONSTRAINEDMW      numeric(15,5)  comment 'Unconstrained MW of unit at time of load shed usage',
   ALS                  numeric(15,5)  comment 'Amount of load shed',
   INITIALDEMAND        numeric(15,5)  comment 'Initial demand of unit at time of load shed usage',
   FINALDEMAND          numeric(15,5)  comment 'Final demand of unit at time of load shed usage',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'AS Contract Version No.',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AVAILABILITYPAYMENT  numeric(16,6)  comment 'Payment amount for the Load Shed Availability service'
);

alter table SETLSHEDPAYMENT comment 'SETLSHEDPAYMENT shows specific payment details for load shed';

alter table SETLSHEDPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETLSHEDPAYMENT_NDX2                                  */
/*==============================================================*/
create index SETLSHEDPAYMENT_NDX2 on SETLSHEDPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETLSHEDPAYMENT_LCX                                   */
/*==============================================================*/
create index SETLSHEDPAYMENT_LCX on SETLSHEDPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLSHEDRECOVERY                                      */
/*==============================================================*/
create table SETLSHEDRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment 'Contract Identifier for reserve, intervention, settlement and ancillary service contracts. Contracts are coded by type and unit.',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   LSEPAYMENT           numeric(15,5)  comment 'Load Shed Enabling Payment',
   CCPAYMENT            numeric(15,5)  comment 'Compensation Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Total Participant NEM Demand',
   REGIONDEMAND         numeric(15,5)  comment 'Total NEM Demand',
   LSERECOVERY          numeric(15,5)  comment 'Load Shed Enabling Recovery',
   CCRECOVERY           numeric(15,5)  comment 'Compensation Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   LSERECOVERY_GEN      numeric(15,5)  comment 'Load Shed Enabling Recovery for Generator',
   CCRECOVERY_GEN       numeric(15,5)  comment 'Compensation Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Total Participant NEM Demand for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total NEM Demand for Generator',
   AVAILABILITYRECOVERY numeric(16,6)  comment 'Recovery amount for the Load Shed Availability service attributable to customer connection points',
   AVAILABILITYRECOVERY_GEN numeric(16,6)  comment 'Recovery amount for the Load Shed Availability service attributable to generator connection points'
);

alter table SETLSHEDRECOVERY comment 'SETLSHEDRECOVERY shows reimbursements for Load shed Ancillar';

alter table SETLSHEDRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETLSHEDRECOVERY_LCX                                  */
/*==============================================================*/
create index SETLSHEDRECOVERY_LCX on SETLSHEDRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLULOADPAYMENT                                      */
/*==============================================================*/
create table SETLULOADPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   CONTRACTID           varchar(10) not null  comment 'AS Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   DUID                 varchar(10)  comment 'Dispatchable Unit Identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   EBP                  numeric(15,5)  comment 'Eligible Bid Price',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   ENABLINGPRICE        numeric(15,5)  comment 'Enabling Price',
   USAGEPRICE           numeric(15,5)  comment 'Usage Price',
   CCPRICE              numeric(15,5)  comment 'Compensation Cap',
   BLOCKSIZE            numeric(4,0)  comment 'Indicates how much of the unit at one given time is available for the ancillary service.',
   ACR                  numeric(6,2)  comment 'Dispatch target',
   UNITOUTPUT           numeric(15,5)  comment 'Unit output.',
   UNITEXCESSGEN        numeric(15,5)  comment 'Excess Generation',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   USAGEPAYMENT         numeric(15,5)  comment 'Usage Payment',
   COMPENSATIONPAYMENT  numeric(15,5)  comment 'Compensation Payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'Contract Version No.',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETLULOADPAYMENT comment 'SETLULOADPAYMENT shows specific payment details for rapid un';

alter table SETLULOADPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETLULOADPAYMENT_NDX2                                 */
/*==============================================================*/
create index SETLULOADPAYMENT_NDX2 on SETLULOADPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETLULOADPAYMENT_LCX                                  */
/*==============================================================*/
create index SETLULOADPAYMENT_LCX on SETLULOADPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLULOADRECOVERY                                     */
/*==============================================================*/
create table SETLULOADRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment 'AS Contract ID',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   USAGEPAYMENT         numeric(15,5)  comment 'Usage Payment',
   COMPENSATIONPAYMENT  numeric(15,5)  comment 'Compensation Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'Total Regional Demand',
   ENABLINGRECOVERY     numeric(15,5)  comment 'Enabling Recovery',
   USAGERECOVERY        numeric(15,5)  comment 'Usage Recovery',
   COMPENSATIONRECOVERY numeric(15,5)  comment 'Compensation Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ENABLINGRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery for Generator',
   USAGERECOVERY_GEN    numeric(15,5)  comment 'Usage Recovery for Generator',
   COMPENSATIONRECOVERY_GEN numeric(15,5)  comment 'Compensation Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total Regional Demand for Generator'
);

alter table SETLULOADRECOVERY comment 'SETLULOADRECOVERY shows reimbursements for rapid-unit-load A';

alter table SETLULOADRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETLULOADRECOVERY_LCX                                 */
/*==============================================================*/
create index SETLULOADRECOVERY_LCX on SETLULOADRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLUNLOADPAYMENT                                     */
/*==============================================================*/
create table SETLUNLOADPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   CONTRACTID           varchar(10) not null  comment 'Ancillary Services contract identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   DUID                 varchar(10)  comment 'Dispatchable unit identifier',
   REGIONID             varchar(10)  comment 'Region identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   EBP                  numeric(15,5)  comment 'Eligible bid price',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   ENABLINGPRICE        numeric(15,5)  comment 'Enabling price',
   USAGEPRICE           numeric(15,5)  comment 'Usage Price',
   CCPRICE              numeric(15,5)  comment 'Compensation cap',
   CLEAREDMW            numeric(15,5)  comment 'Cleared MW of Unit in Dispatch, Predispatch or Trading period.',
   UNCONSTRAINEDMW      numeric(15,5)  comment 'MW output the generator would have been running at had it not been constrained up to provide unit unloading',
   CONTROLRANGE         numeric(4,0)  comment 'The MW output achieved in 5 minutes from startup and is what payment is based on.',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling payment',
   USAGEPAYMENT         numeric(15,5)  comment 'Usage Payment',
   COMPENSATIONPAYMENT  numeric(15,5)  comment 'Compensation payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'Contract version number',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Date last changed'
);

alter table SETLUNLOADPAYMENT comment 'SETLUNLOADPAYMENT shows specific payment details for rapid u';

alter table SETLUNLOADPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETLUNLOADPAYMENT_NDX2                                */
/*==============================================================*/
create index SETLUNLOADPAYMENT_NDX2 on SETLUNLOADPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETLUNLOADPAYMENT_LCX                                 */
/*==============================================================*/
create index SETLUNLOADPAYMENT_LCX on SETLUNLOADPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETLUNLOADRECOVERY                                    */
/*==============================================================*/
create table SETLUNLOADRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment 'AS Contract',
   PERIODID             numeric(3,0) not null  comment 'Trading Interval',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   USAGEPAYMENT         numeric(15,5)  comment 'Usage Payment',
   COMPENSATIONPAYMENT  numeric(15,5)  comment 'Compensation Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'Total Regional Demand',
   ENABLINGRECOVERY     numeric(15,5)  comment 'Enabling Recovery',
   USAGERECOVERY        numeric(15,5)  comment 'Usage Recovery',
   COMPENSATIONRECOVERY numeric(15,5)  comment 'Compensation Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ENABLINGRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery for Generator',
   USAGERECOVERY_GEN    numeric(15,5)  comment 'Usage Recovery for Generator',
   COMPENSATIONRECOVERY_GEN numeric(15,5)  comment 'Compensation Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total Regional Demand for Generator'
);

alter table SETLUNLOADRECOVERY comment 'SETLUNLOADRECOVERY shows reimbursements for rapid unit unloa';

alter table SETLUNLOADRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETLUNLOADRECOVERY_LCX                                */
/*==============================================================*/
create index SETLUNLOADRECOVERY_LCX on SETLUNLOADRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETMARKETFEES                                         */
/*==============================================================*/
create table SETMARKETFEES
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   RUNNO                numeric(3,0) not null  comment 'Settlement run no',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   MARKETFEEID          varchar(10) not null  comment 'Market fee identifier (e.g. V_EST)',
   MARKETFEEVALUE       numeric(15,5)  comment 'Fee charge',
   ENERGY               numeric(16,6)  comment 'Energy amount for variable fees',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   PARTICIPANTCATEGORYID varchar(10) not null  comment 'The participant category that the market fee recovery pertains to. Corresponds to the PARTICIPANTCATEGORYID column of the PARTICIPANT_BANDFEE_CATEGORYALLOC_C_V view for BAND$ type fees, or to the MARKETFEETYPE column of the MARKETFEE_P_V view for all other fee types.',
   FEERATE              numeric(18,8)  comment 'The rate applied to this fee for the participant at the settlement date',
   FEEUNITS             numeric(18,8)  comment 'The number of units applicable to this fee for the participant, in the trading interval.',
   METER_TYPE           varchar(20)  comment 'The Energy Type for the Market Fees Calculation. E.g of Meter Types are CUSTOMER, GENERATOR, NREG, BDU etc. If Meter Type is mentioned as ALL then all the Meter Types for that Participant Category will be used in the Fee calculation',
   METER_SUBTYPE        varchar(20)  comment 'The Meter Sub Type values are ACE, ASOE or ALL. ACE represent ACE_MWH value or ASOE represent ASOE_MWH value and ALL represent sum of ACE_MWh and ASOE_MWh'
);

alter table SETMARKETFEES comment 'SETMARKETFEES shows payments for market fees for each settle';

alter table SETMARKETFEES
   add primary key (SETTLEMENTDATE, RUNNO, PARTICIPANTID, MARKETFEEID, PARTICIPANTCATEGORYID, PERIODID);

/*==============================================================*/
/* Index: SETMARKETFEES_LCX                                     */
/*==============================================================*/
create index SETMARKETFEES_LCX on SETMARKETFEES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETREALLOCATIONS                                      */
/*==============================================================*/
create table SETREALLOCATIONS
(
   SETTLEMENTDATE       datetime not null  comment 'Calendar Settlement Date',
   RUNNO                numeric(3,0) not null  comment 'Settlement run no',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   REALLOCATIONID       varchar(20) not null  comment 'Reallocation contract identifier',
   REALLOCATIONVALUE    numeric(15,5)  comment 'Reallocation value in $',
   ENERGY               numeric(15,5)  comment 'Energy in MWh if reallocation agreement type is MWh',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETREALLOCATIONS comment 'SETREALLOCATIONS shows the trading interval value of realloc';

alter table SETREALLOCATIONS
   add primary key (SETTLEMENTDATE, RUNNO, PERIODID, PARTICIPANTID, REALLOCATIONID);

/*==============================================================*/
/* Index: SETREALLOCATIONS_LCX                                  */
/*==============================================================*/
create index SETREALLOCATIONS_LCX on SETREALLOCATIONS
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRESERVERECOVERY                                    */
/*==============================================================*/
create table SETRESERVERECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   CONTRACTID           varchar(10) not null  comment '',
   RCF                  char(1)  comment 'Regional Recovery Flag',
   SPOTPAYMENT          numeric(12,5)  comment 'Cap difference for generator',
   PARTICIPANTID        varchar(10) not null  comment 'Unique participant identifier',
   PARTICIPANTDEMAND    numeric(12,5)  comment 'Demand of Participant in Region/Market',
   TOTALDEMAND          numeric(12,5)  comment 'Total Demand of Region/Market',
   RESERVEPAYMENT       numeric(12,5)  comment 'Payment made to generator for Reserve Trader Contract',
   RESERVEAMOUNT        numeric(12,5)  comment 'Payment owed by Retailer to pool for Reserve Trader Contract',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   REGIONID             varchar(10)  comment 'Region Identifier'
);

alter table SETRESERVERECOVERY comment 'SETRESERVERECOVERY shows reserve recovery details.';

alter table SETRESERVERECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, CONTRACTID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETRESERVERECOVERY_LCX                                */
/*==============================================================*/
create index SETRESERVERECOVERY_LCX on SETRESERVERECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRESERVETRADER                                      */
/*==============================================================*/
create table SETRESERVETRADER
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PERIODID             numeric(3,0) not null  comment 'Period Identifier',
   CONTRACTID           varchar(10)  comment 'Reserve Trader Contract Identifier',
   CONTRACTVERSION      numeric(3,0)  comment 'Reserve Trader Contract Version',
   PARTICIPANTID        varchar(10)  comment 'Unique participant identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   DUID                 varchar(10) not null  comment 'Dispatchable Unit ID',
   RCF                  char(1)  comment 'Reserve Recovery Flag',
   UNITAVAIL            numeric(6,2)  comment 'Offered Availability of Unit',
   CPA                  numeric(12,5)  comment 'Contract Availability Payment',
   CPE                  numeric(12,5)  comment 'Contract Enabling Payment',
   CPU                  numeric(12,5)  comment 'Contract Usage Payment',
   CPTOTAL              numeric(12,5)  comment 'Total Payment for Contract',
   CAPDIFFERENCE        numeric(12,5)  comment 'Spot payment applicable to the capacity above the enabling threshold',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SETRESERVETRADER comment 'SETRESERVETRADER shows reserve trader details.';

alter table SETRESERVETRADER
   add primary key (SETTLEMENTDATE, VERSIONNO, DUID, PERIODID);

/*==============================================================*/
/* Index: SETRESERVETRADER_LCX                                  */
/*==============================================================*/
create index SETRESERVETRADER_LCX on SETRESERVETRADER
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRESTARTPAYMENT                                     */
/*==============================================================*/
create table SETRESTARTPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   CONTRACTID           varchar(10) not null  comment 'Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10)  comment 'Region Identifier',
   RESTARTTYPE          numeric(1,0)  comment 'System Restart Type (0 = FRC, 1 = GRC, 2 = TTH)',
   AVAFLAG              numeric(1,0)  comment 'Availability Flag',
   AVAILABILITYPRICE    numeric(15,5)  comment 'Availability Price',
   TCF                  numeric(1,0)  comment 'Service Test Flag',
   AVAILABILITYPAYMENT  numeric(15,5)  comment 'Availability Payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'Contract Version No.',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   ENABLINGPAYMENT      numeric(18,8)  comment 'The enabling payment made for system restart in this half-hour interval'
);

alter table SETRESTARTPAYMENT comment 'SETRESTARTPAYMENT shows specific payment details for System ';

alter table SETRESTARTPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETRESTARTPAYMENT_NDX2                                */
/*==============================================================*/
create index SETRESTARTPAYMENT_NDX2 on SETRESTARTPAYMENT
(
   PARTICIPANTID
);

/*==============================================================*/
/* Index: SETRESTARTPAYMENT_LCX                                 */
/*==============================================================*/
create index SETRESTARTPAYMENT_LCX on SETRESTARTPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRESTARTRECOVERY                                    */
/*==============================================================*/
create table SETRESTARTRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment 'Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   AVAILABILITYPAYMENT  numeric(15,5)  comment 'Availability Payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Participant Demand in Region',
   REGIONDEMAND         numeric(15,5)  comment 'NEM Demand (NB sum of ALL Regions)',
   AVAILABILITYRECOVERY numeric(15,5)  comment 'Availability Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AVAILABILITYRECOVERY_GEN numeric(15,5)  comment 'Availability Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Participant Demand in Region for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Sum of all generation including SGA generation across all regions of the NEM and floored to zero',
   ENABLINGPAYMENT      numeric(18,8)  comment 'The enabling payment made for system restart in this half-hour interval',
   ENABLINGRECOVERY     numeric(18,8)  comment 'The enabling recovery amount for system restart in this half-hour interval attributable to customer activity',
   ENABLINGRECOVERY_GEN numeric(18,8)  comment 'The enabling recovery amount for system restart in this half-hour interval attributable to generator activity'
);

alter table SETRESTARTRECOVERY comment 'SETRESTARTRECOVERY shows reimbursements for system restart A';

alter table SETRESTARTRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETRESTARTRECOVERY_LCX                                */
/*==============================================================*/
create index SETRESTARTRECOVERY_LCX on SETRESTARTRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRPOWERPAYMENT                                      */
/*==============================================================*/
create table SETRPOWERPAYMENT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   CONTRACTID           varchar(10) not null  comment 'AS Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   DUID                 varchar(10)  comment 'Dispatchable Unit Identifier',
   REGIONID             varchar(10)  comment 'Region Identifier',
   TLF                  numeric(7,5)  comment 'Transmission Loss Factor',
   EBP                  numeric(15,5)  comment 'Eligible Bid Price',
   RRP                  numeric(15,5)  comment 'Regional Reference Price',
   MVARAPRICE           numeric(15,5)  comment 'Availability price per MVAr of RP absorption capability',
   MVAREPRICE           numeric(15,5)  comment 'Enabling Price',
   MVARGPRICE           numeric(15,5)  comment 'Availability price per MVAr of RP generation capability',
   CCPRICE              numeric(15,5)  comment 'Compensation Cap',
   SYNCCOMPENSATION     numeric(1,0)  comment 'Sync Compensation Flag',
   MTA                  numeric(15,5)  comment 'Reactive Power Absorption Capability (MVAr)',
   MTG                  numeric(15,5)  comment 'Reactive Power Generation Capability (MVAr)',
   BLOCKSIZE            numeric(4,0)  comment 'Block size of unit',
   AVAFLAG              numeric(1,0)  comment 'Availability Flag',
   CLEAREDMW            numeric(15,5)  comment 'Cleared MW of unit',
   UNCONSTRAINEDMW      numeric(15,5)  comment 'Unconstrained MW of unit',
   AVAILABILITYPAYMENT  numeric(15,5)  comment 'Availability Payment',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   CCPAYMENT            numeric(15,5)  comment 'Compensation Payment',
   CONTRACTVERSIONNO    numeric(3,0)  comment 'AS Contract Version No.',
   OFFERDATE            datetime  comment 'Re-offer offer date',
   OFFERVERSIONNO       numeric(3,0)  comment 'Re-Offer Version No.',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AVAILABILITYPAYMENT_REBATE numeric(18,8)  comment 'The rebate amount if MegaVar (MVAr) is below the threshold.'
);

alter table SETRPOWERPAYMENT comment 'SETRPOWERPAYMENT shows specific payment details for Reactive';

alter table SETRPOWERPAYMENT
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, CONTRACTID, PERIODID);

/*==============================================================*/
/* Index: SETRPOWERPAYMENT_LCX                                  */
/*==============================================================*/
create index SETRPOWERPAYMENT_LCX on SETRPOWERPAYMENT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETRPOWERRECOVERY                                     */
/*==============================================================*/
create table SETRPOWERRECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No.',
   PARTICIPANTID        varchar(10) not null  comment 'Participant to pay recovery',
   CONTRACTID           varchar(10)  comment 'AS Contract Identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   AVAILABILITYPAYMENT  numeric(15,5)  comment 'Availability Payment',
   ENABLINGPAYMENT      numeric(15,5)  comment 'Enabling Payment',
   CCPAYMENT            numeric(15,5)  comment 'Compensation payment',
   PARTICIPANTDEMAND    numeric(15,5)  comment 'Total Participant NEM Demand',
   REGIONDEMAND         numeric(15,5)  comment 'Total NEM Demand',
   AVAILABILITYRECOVERY numeric(15,5)  comment 'Availability Recovery',
   ENABLINGRECOVERY     numeric(15,5)  comment 'Enabling Recovery',
   CCRECOVERY           numeric(15,5)  comment 'Compensation Recovery',
   LASTCHANGED          datetime  comment 'Last date and time record changed',
   AVAILABILITYRECOVERY_GEN numeric(15,5)  comment 'Availability Recovery for Generator',
   ENABLINGRECOVERY_GEN numeric(15,5)  comment 'Enabling Recovery for Generator',
   CCRECOVERY_GEN       numeric(15,5)  comment 'Compensation Recovery for Generator',
   PARTICIPANTDEMAND_GEN numeric(15,5)  comment 'Total Participant NEM Demand for Generator',
   REGIONDEMAND_GEN     numeric(15,5)  comment 'Total NEM Demand for Generator'
);

alter table SETRPOWERRECOVERY comment 'SETRPOWERRECOVERY shows reimbursements for Reactive Power An';

alter table SETRPOWERRECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Index: SETRPOWERRECOVERY_LCX                                 */
/*==============================================================*/
create index SETRPOWERRECOVERY_LCX on SETRPOWERRECOVERY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETSMALLGENDATA                                       */
/*==============================================================*/
create table SETSMALLGENDATA
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   VERSIONNO            numeric(3,0) not null  comment 'Version number of the record for the settlement date',
   CONNECTIONPOINTID    varchar(20) not null  comment 'Transmission Node Identifier (TNI)',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   PARTICIPANTID        varchar(20) not null  comment 'Unique participant identifier',
   REGIONID             varchar(20)  comment 'Region Identifier',
   IMPORTENERGY         numeric(18,8)  comment 'The import direction value for the meter read (MWh)',
   EXPORTENERGY         numeric(18,8)  comment 'The export direction value for the meter read (MWh)',
   RRP                  numeric(18,8)  comment 'Regional Reference Price',
   TLF                  numeric(18,8)  comment 'Transmission Loss Factor',
   IMPENERGYCOST        numeric(18,8)  comment 'Import Energy Cost ($)',
   EXPENERGYCOST        numeric(18,8)  comment 'Export Energy Cost ($)',
   LASTCHANGED          datetime  comment 'Last date and time the record changed'
);

alter table SETSMALLGENDATA comment 'Publishes metering data and associated settlement values for';

alter table SETSMALLGENDATA
   add primary key (SETTLEMENTDATE, VERSIONNO, CONNECTIONPOINTID, PERIODID, PARTICIPANTID);

/*==============================================================*/
/* Table: SETVICBOUNDARYENERGY                                  */
/*==============================================================*/
create table SETVICBOUNDARYENERGY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement and date',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   PARTICIPANTID        varchar(10) not null  comment 'Participant Identifier',
   PERIODID             numeric(3,0) not null  comment 'Period Identifier',
   BOUNDARYENERGY       numeric(15,5)  comment 'Interval energy purchases in Victoria when host distributor = Pool (in MWh)',
   LASTCHANGED          datetime  comment 'Last changed'
);

alter table SETVICBOUNDARYENERGY comment 'SETVICBOUNDARYENERGY is as requested by Participants for the';

alter table SETVICBOUNDARYENERGY
   add primary key (SETTLEMENTDATE, VERSIONNO, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Index: SETVICBOUNDARYENERGY_LCX                              */
/*==============================================================*/
create index SETVICBOUNDARYENERGY_LCX on SETVICBOUNDARYENERGY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETVICENERGYFIGURES                                   */
/*==============================================================*/
create table SETVICENERGYFIGURES
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   PERIODID             numeric(3,0) not null  comment 'Settlement period',
   TOTALGENOUTPUT       numeric(15,5)  comment 'Total generator output',
   TOTALPCSD            numeric(15,5)  comment 'Total participant demand',
   LASTCHANGED          datetime  comment 'Last changed',
   TLR                  numeric(15,6)  comment 'Transmission loss factor',
   MLF                  numeric(15,6)  comment 'Marginal loss factor'
);

alter table SETVICENERGYFIGURES comment 'SETVICENERGYFIGURES is used in settlement of Victorian Vesti';

alter table SETVICENERGYFIGURES
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: SETVICENERGYFIGURES_LCX                               */
/*==============================================================*/
create index SETVICENERGYFIGURES_LCX on SETVICENERGYFIGURES
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SETVICENERGYFLOW                                      */
/*==============================================================*/
create table SETVICENERGYFLOW
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement date',
   VERSIONNO            numeric(3,0) not null  comment 'Version number',
   PERIODID             numeric(3,0) not null  comment 'Settlement period',
   NETFLOW              numeric(15,5)  comment 'Net metered energy flowing across the V-SN and V-SA interconnectors',
   LASTCHANGED          datetime  comment 'Last changed'
);

alter table SETVICENERGYFLOW comment 'SETVICENERGYFLOW is used in settlement of Victorian Vesting ';

alter table SETVICENERGYFLOW
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: SETVICENERGYFLOW_LCX                                  */
/*==============================================================*/
create index SETVICENERGYFLOW_LCX on SETVICENERGYFLOW
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_ANCILLARY_SUMMARY                                 */
/*==============================================================*/
create table SET_ANCILLARY_SUMMARY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement Run No',
   SERVICE              varchar(20) not null  comment 'Ancillary service identifier (e.g. REACTIVE_POWER)',
   PAYMENTTYPE          varchar(20) not null  comment 'Payment type identifier (e.g. COMPENSATION)',
   REGIONID             varchar(10) not null  comment 'Region Identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading interval',
   PAYMENTAMOUNT        numeric(18,8)  comment 'The NEM ancillary summary regional payment amount ($)',
   LASTCHANGED          datetime  comment 'Last date and time record changed'
);

alter table SET_ANCILLARY_SUMMARY comment 'SET_ANCILLARY_SUMMARY summarises payments for all Ancillary ';

alter table SET_ANCILLARY_SUMMARY
   add primary key (SETTLEMENTDATE, VERSIONNO, SERVICE, PAYMENTTYPE, REGIONID, PERIODID);

/*==============================================================*/
/* Index: SET_ANCILLARY_SUMMARY_LCHD_IDX                        */
/*==============================================================*/
create index SET_ANCILLARY_SUMMARY_LCHD_IDX on SET_ANCILLARY_SUMMARY
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_APC_COMPENSATION                                  */
/*==============================================================*/
create table SET_APC_COMPENSATION
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement run date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   APEVENTID            numeric(6,0) not null  comment 'AP Event Id',
   CLAIMID              numeric(6,0) not null  comment 'AP Event Claim Id',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier',
   PERIODID             numeric(3,0) not null  comment 'Trading interval identifier',
   COMPENSATION_AMOUNT  numeric(18,8)  comment 'Compensation amount for the event claim in this interval'
);

alter table SET_APC_COMPENSATION comment 'APC Compensation payment amounts in the Settlements timefram';

alter table SET_APC_COMPENSATION
   add primary key (SETTLEMENTDATE, VERSIONNO, APEVENTID, CLAIMID, PARTICIPANTID, PERIODID);

/*==============================================================*/
/* Table: SET_APC_RECOVERY                                      */
/*==============================================================*/
create table SET_APC_RECOVERY
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement run date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   APEVENTID            numeric(6,0) not null  comment 'AP Event Id',
   CLAIMID              numeric(6,0) not null  comment 'AP Event Claim Id',
   PARTICIPANTID        varchar(20) not null  comment 'Participant identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements Trading Interval.',
   REGIONID             varchar(20) not null  comment 'Region id for the recovery amount',
   RECOVERY_AMOUNT      numeric(18,8)  comment 'Recovery amount in the region attributable to the participant for the event claim in this interval',
   REGION_RECOVERY_AMOUNT numeric(18,8)  comment 'Total Recovery amount in the region for the event claim in this interval'
);

alter table SET_APC_RECOVERY comment 'APC Compensation recovery amounts in the Settlements timefra';

alter table SET_APC_RECOVERY
   add primary key (SETTLEMENTDATE, VERSIONNO, APEVENTID, CLAIMID, PARTICIPANTID, PERIODID, REGIONID);

/*==============================================================*/
/* Table: SET_CSP_DEROGATION_AMOUNT                             */
/*==============================================================*/
create table SET_CSP_DEROGATION_AMOUNT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   PERIODID             numeric(3,0) not null  comment 'Period identifier',
   PARTICIPANTID        varchar(10) not null  comment 'The participant allocated the payment amount for the derogation.',
   AMOUNT_ID            varchar(20) not null  comment 'Amount identifier represented as a string, from "TA1" through to "TA6" (or "TA8" for a LYMMCO derogation result)',
   DEROGATION_AMOUNT    numeric(18,8)  comment 'Derogation amount associated with the amount identifier',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table SET_CSP_DEROGATION_AMOUNT comment 'A settlement table for the publication of Snowy CSP derogati';

alter table SET_CSP_DEROGATION_AMOUNT
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, PARTICIPANTID, AMOUNT_ID);

/*==============================================================*/
/* Index: SET_CSP_DEROGATION_AMOUNT_NDX1                        */
/*==============================================================*/
create index SET_CSP_DEROGATION_AMOUNT_NDX1 on SET_CSP_DEROGATION_AMOUNT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_CSP_SUPPORTDATA_CONSTRAINT                        */
/*==============================================================*/
create table SET_CSP_SUPPORTDATA_CONSTRAINT
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   INTERVAL_DATETIME    datetime not null  comment 'Dispatch interval identifier',
   CONSTRAINTID         varchar(20) not null  comment 'Constraint identifier',
   PERIODID             numeric(3,0) not null  comment 'Settlements trading interval identifier',
   MARGINALVALUE        numeric(18,8)  comment 'Marginal value of the constraint',
   RHS                  numeric(18,8)  comment 'RHS value of the constraint',
   LOWERTUMUT_FACTOR    numeric(18,8)  comment 'Value of the Lower Tumut left-hand term of the constraint',
   UPPERTUMUT_FACTOR    numeric(18,8)  comment 'Value of the Upper Tumut left hand term of the constraint',
   LOWERTUMUT_CSPA_COEFF numeric(18,8)  comment 'LOWERTUMUT_FACTOR x MARGINALVALUE',
   UPPERTUMUT_CSPA_COEFF numeric(18,8)  comment 'UPPERTUMUT_FACTOR x MARGINALVALUE',
   ABS_X                numeric(18,8)  comment 'Equal to RHS if the constraint direction is SOUTH, otherwise zero',
   ABS_Y                numeric(18,8)  comment 'Equal to RHS if the constraint direction is NORTH, otherwise zero',
   LASTCHANGED          datetime  comment 'Last changed date of the record'
);

alter table SET_CSP_SUPPORTDATA_CONSTRAINT comment 'A settlements table for the publication of support data for ';

alter table SET_CSP_SUPPORTDATA_CONSTRAINT
   add primary key (SETTLEMENTDATE, VERSIONNO, INTERVAL_DATETIME, CONSTRAINTID, PERIODID);

/*==============================================================*/
/* Index: SET_CSP_SUPPORTDATA_CNSTR_NDX1                        */
/*==============================================================*/
create index SET_CSP_SUPPORTDATA_CNSTR_NDX1 on SET_CSP_SUPPORTDATA_CONSTRAINT
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_CSP_SUPPORTDATA_ENERGYDIFF                        */
/*==============================================================*/
create table SET_CSP_SUPPORTDATA_ENERGYDIFF
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   PERIODID             numeric(3,0) not null  comment 'Period identifier',
   LOWERTUMUT_SPDP      numeric(18,8)  comment 'Lower Tumut Substitute Price for the half hour interval',
   UPPERTUMUT_SPDP      numeric(18,8)  comment 'Upper Tumut Substitute Price for the half hour interval',
   LOWERTUMUT_EVDP      numeric(18,8)  comment 'Lower Tumut Energy Value Differential for the half hour interval',
   UPPERTUMUT_EVDP      numeric(18,8)  comment 'Upper Tumut Energy Value Differential for the half hour interval',
   FLOW_DIRECTION       varchar(20)  comment 'Indicates the determined direction of flow in the half hour.  Will be either NORTH or SOUTH',
   TOTAL_X              numeric(18,8)  comment 'Sum of all "ABS_X" values in the half hour',
   TOTAL_Y              numeric(18,8)  comment 'Sum of all "ABS_Y" values in the half hour',
   LOWERTUMUT_AGE       numeric(18,8)  comment 'Energy output of the Lower Tumut unit in the half hour interval',
   UPPERTUMUT_AGE       numeric(18,8)  comment 'Energy output of the Upper Tumut unit in the half hour interval',
   EVA                  numeric(18,8)  comment 'Energy value adjustment for northward flows in the half-hour interval',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table SET_CSP_SUPPORTDATA_ENERGYDIFF comment 'A settlements table for the publication of support data for ';

alter table SET_CSP_SUPPORTDATA_ENERGYDIFF
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID);

/*==============================================================*/
/* Index: SET_CSP_SUPPDATA_ENERGYDF_NDX1                        */
/*==============================================================*/
create index SET_CSP_SUPPDATA_ENERGYDF_NDX1 on SET_CSP_SUPPORTDATA_ENERGYDIFF
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_CSP_SUPPORTDATA_SUBPRICE                          */
/*==============================================================*/
create table SET_CSP_SUPPORTDATA_SUBPRICE
(
   SETTLEMENTDATE       datetime not null  comment 'Settlement Date',
   VERSIONNO            numeric(3,0) not null  comment 'Settlement run number',
   INTERVAL_DATETIME    datetime not null  comment 'Dispatch interval identifier',
   PERIODID             numeric(3,0)  comment 'Period identifier',
   RRP                  numeric(18,8)  comment 'SNOWY1 RRP for the dispatch interval',
   IS_CSP_INTERVAL      numeric(1,0)  comment 'A flag to indicate whether a binding CSP constraint was present in the dispatch interval.  A value of 1 indicates that CSP processing occurred due to a binding CSP constraint, while a value of 0 indicates that no binding CSP constraints were present in this interval',
   LOWERTUMUT_TLF       numeric(18,8)  comment 'Transmission loss factor of the Lower Tumut unit',
   UPPERTUMUT_TLF       numeric(18,8)  comment 'Transmission Loss factor of the Upper Tumut unit',
   LOWERTUMUT_PRICE     numeric(18,8)  comment 'The dispatch price at the Lower Tumut node',
   UPPERTUMUT_PRICE     numeric(18,8)  comment 'The dispatch price at the Upper Tumut node',
   LOWERTUMUT_CSPA_COEFF numeric(18,8)  comment 'Sum of CSPAxCOEFF for all constraints and Lower Tumut left-hand terms',
   UPPERTUMUT_CSPA_COEFF numeric(18,8)  comment 'Sum of CSPAxCOEFF for all constraints and Upper Tumut left-hand terms',
   LOWERTUMUT_SPDP_UNCAPPED numeric(18,8)  comment 'LOWERTUMUT_SPDP before VOLL or MPF capping is applied',
   UPPERTUMUT_SPDP_UNCAPPED numeric(18,8)  comment 'UPPERTUMUT_SPDP before VOLL or MPF capping is applied',
   LOWERTUMUT_SPDP      numeric(18,8)  comment 'Substitute Price for Lower Tumut',
   UPPERTUMUT_SPDP      numeric(18,8)  comment 'Substitute Price for Upper Tumut',
   INTERVAL_ABS_X       numeric(18,8)  comment 'Sum of all ABS_X values for binding CSP constraints in the dispatch interval',
   INTERVAL_ABS_Y       numeric(18,8)  comment 'Sum of all ABS_Y values for binding CSP constraints in the dispatch interval',
   LASTCHANGED          datetime  comment 'Last changed date for the record'
);

alter table SET_CSP_SUPPORTDATA_SUBPRICE comment 'A settlements table for the publication of support data for ';

alter table SET_CSP_SUPPORTDATA_SUBPRICE
   add primary key (SETTLEMENTDATE, VERSIONNO, INTERVAL_DATETIME);

/*==============================================================*/
/* Index: SET_CSP_SUPPDATA_SUBPRCE_NDX1                         */
/*==============================================================*/
create index SET_CSP_SUPPDATA_SUBPRCE_NDX1 on SET_CSP_SUPPORTDATA_SUBPRICE
(
   LASTCHANGED
);

/*==============================================================*/
/* Table: SET_ENERGY_GENSET_DETAIL                              */
/*==============================================================*/
create table SET_ENERGY_GENSET_DETAIL
(
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date of the Billing Week',
   VERSIONNO            numeric(3,0) not null  comment 'The Settlement Run No',
   PERIODID             numeric(3,0) not null  comment 'The Period ID Identifier',
   PARTICIPANTID        varchar(20)  comment 'The Participant Id Identifier',
   STATIONID            varchar(20) not null  comment 'The StationId identifier associated with the GensetId',
   DUID                 varchar(20) not null  comment 'The DUID for the meter associated with the GensetId',
   GENSETID             varchar(20) not null  comment 'The GensetId for the Meter Id received',
   REGIONID             varchar(20)  comment 'The Region Id for the Connection Point associated with the DUID',
   CONNECTIONPOINTID    varchar(20)  comment 'The Connection Point associated with the DUID',
   RRP                  numeric(18,8)  comment 'The Regional Reference Price for the Settlement Period',
   TLF                  numeric(18,8)  comment 'The Transmission Loss Factor applied to the Connection Point Id. TLF is calculated based on the Net Flow at the TNI.',
   METERID              varchar(20)  comment 'The Meter ID Identifier (NMI)',
   CE_MWH               numeric(18,8)  comment 'The Consumed Energy for the Meter Id . Energy received in the meter reads (DLF Adjusted)',
   UFEA_MWH             numeric(18,8)  comment 'The UFEA allocation amount applied to the Meter Data',
   ACE_MWH              numeric(18,8)  comment 'The Adjusted Consumed Energy for the Meter Id (CE_MWh + UFEA)',
   ASOE_MWH             numeric(18,8)  comment 'The Adjusted Sent Out Energy for the Meter Id.',
   TOTAL_MWH            numeric(18,8)  comment 'The Total MWh for the Meter Id (ACE_MWh + ASOE_MWh)',
   DME_MWH              numeric(18,8)  comment 'The DME MWh value that is used to calculate the UFEA Allocation Amount',
   ACE_AMOUNT           numeric(18,8)  comment 'The Adjusted Consumed Energy Dollar Amount',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Adjusted Sent Out Energy Dollar Amount',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Total Amount for the Meter Id (ACE_Amount + ASOE_Amount)',
   LASTCHANGED          datetime  comment 'The Last changed Date time of the record'
);

alter table SET_ENERGY_GENSET_DETAIL comment 'The Settlement Energy Genset report contains the Energy Tran';

alter table SET_ENERGY_GENSET_DETAIL
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, STATIONID, DUID, GENSETID);

/*==============================================================*/
/* Table: SET_ENERGY_REGION_SUMMARY                             */
/*==============================================================*/
create table SET_ENERGY_REGION_SUMMARY
(
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date of the Billing Week',
   VERSIONNO            numeric(3,0) not null  comment 'The Settlement Run No',
   PERIODID             numeric(3,0) not null  comment 'The Period ID Identifier',
   REGIONID             varchar(20) not null  comment 'The NEM Region Id Identifier',
   CE_MWH               numeric(18,8)  comment 'The Consumed Energy summary for the Region Id',
   UFEA_MWH             numeric(18,8)  comment 'The UFEA Energy summary for the Region Id',
   ACE_MWH              numeric(18,8)  comment 'The Adjusted Consumed Energy summary for the Region Id',
   ASOE_MWH             numeric(18,8)  comment 'The Adjusted Sent Out Energy summary for the Region Id',
   ACE_AMOUNT           numeric(18,8)  comment 'The Adjusted Consumed Energy Amount for the Region Id',
   ASOE_AMOUNT          numeric(18,8)  comment 'The Adjusted Sent Out Energy Amount for the Region Id',
   TOTAL_MWH            numeric(18,8)  comment 'The Total Energy summary for the Region Id',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Total Dollar Amount summary for the Region Id',
   LASTCHANGED          datetime  comment 'The Last changed Date time of the record'
);

alter table SET_ENERGY_REGION_SUMMARY comment 'The Settlement Energy Region Summary report contains the Ene';

alter table SET_ENERGY_REGION_SUMMARY
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, REGIONID);

/*==============================================================*/
/* Table: SET_ENERGY_TRANSACTIONS                               */
/*==============================================================*/
create table SET_ENERGY_TRANSACTIONS
(
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date of the Billing Week',
   VERSIONNO            numeric(3,0) not null  comment 'The Settlement Run No',
   PERIODID             numeric(3,0) not null  comment 'The Period ID Identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant Id Identifier',
   CONNECTIONPOINTID    varchar(20) not null  comment 'The Connection Point associated with the Energy Transaction reads.',
   METER_TYPE           varchar(20) not null  comment 'The type of meter reads received. Eg Customer, Generator, BDU, NREG etc.',
   REGIONID             varchar(20)  comment 'The NEM Region Id Identifier',
   RRP                  numeric(18,8)  comment 'The Regional Reference Price for the Region',
   TLF                  numeric(18,8)  comment 'The Transmission Loss Factor applied to the Connection Point Id. TLF is calculated based on the Net Flow at the TNI.',
   CE_MWH               numeric(18,8)  comment 'The Consumed Energy . Energy received in the meter reads (DLF Adjusted)',
   UFEA_MWH             numeric(18,8)  comment 'The UFE Allocation Amount applied to the Participant',
   ACE_MWH              numeric(18,8)  comment 'The Adjusted Consumed Energy MWh ( CE_MWh + UFEA) for the ConnectionPointId',
   ASOE_MWH             numeric(18,8)  comment 'The Adjusted Sent Out Energy for the ConnectionPointId . Energy received in the meter reads adjusted by DLF.',
   TOTAL_MWH            numeric(18,8)  comment 'The Total MWh Value for the Participant. ACE_MWh + ASOE_MWh',
   ACE_AMOUNT           numeric(18,8)  comment 'The dollar amount for Adjusted Consumed Energy MWh (ACE_MWh * TLF * RRP)',
   ASOE_AMOUNT          numeric(18,8)  comment 'The dollar amount for Adjusted Sent Out Energy MWh (ASOE_MWh * TLF * RRP)',
   TOTAL_AMOUNT         numeric(18,8)  comment 'The Total Dollar Value for the Participant. ACE_Amount + ASOE_Amount',
   CASE_ID              numeric(10,0)  comment 'The Metering Case ID',
   DME_MWH              numeric(18,8)  comment 'The DME MWh (Distribution Connected) that is used in the UFEA Calculation.',
   AGGREGATE_READ_FLAG  numeric(3,0)  comment 'The Flag is 1 if the meter data source is from Aggregate Reads Meter Data, Else 0',
   INDIVIDUAL_READ_FLAG numeric(3,0)  comment 'The Flag is 1 if the meter data source is from Individual Reads Meter Data, Else 0',
   LASTCHANGED          datetime  comment 'The Last changed Date time of the record'
);

alter table SET_ENERGY_TRANSACTIONS comment 'The Settlement Energy Transactions report contains the Energ';

alter table SET_ENERGY_TRANSACTIONS
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, PARTICIPANTID, CONNECTIONPOINTID, METER_TYPE);

/*==============================================================*/
/* Table: SET_ENERGY_TRAN_SAPS                                  */
/*==============================================================*/
create table SET_ENERGY_TRAN_SAPS
(
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date of the Billing Week',
   VERSIONNO            numeric(3,0) not null  comment 'The Settlement Run No',
   PERIODID             numeric(3,0) not null  comment 'The Period Id identifier',
   PARTICIPANTID        varchar(20) not null  comment 'The Participant ID for the SAPS TNI',
   TNI                  varchar(20) not null  comment 'The SAPS Connection Point Identifier',
   REGIONID             varchar(20)  comment 'The SAPS Region ID',
   SAPS_RRP             numeric(18,8)  comment 'The SAPS Settlement Price for the Region',
   CONSUMED_ENERGY_MWH  numeric(18,8)  comment 'The Energy MWh Consumed for that TNI for the Participant ID',
   SENTOUT_ENERGY_MWH   numeric(18,8)  comment 'The Energy MWh Sent Out for the TNI for the Participant Id',
   CONSUMED_ENERGY_COST numeric(18,8)  comment 'The Cost of the Consumed Energy',
   SENTOUT_ENERGY_COST  numeric(18,8)  comment 'The Cost of the Sent Out Energy',
   LASTCHANGED          datetime  comment 'The Last changed Date time of the record'
);

alter table SET_ENERGY_TRAN_SAPS comment 'The table shows the Transaction Details for the SAPS Connect';

alter table SET_ENERGY_TRAN_SAPS
   add primary key (SETTLEMENTDATE, VERSIONNO, PERIODID, PARTICIPANTID, TNI);

/*==============================================================*/
/* Table: SET_FCAS_CLAWBACK_REQ                                 */
/*==============================================================*/
create table SET_FCAS_CLAWBACK_REQ
(
   INTERVAL_DATETIME    datetime not null  comment 'The Interval Datetime for which a the Clawback Run has been completed.',
   RUNNO                numeric(3,0) not null  comment 'The RunNo associated with the Clawback Run for the above interval date time.',
   CONSTRAINTID         varchar(20) not null  comment 'The FCAS Constraint ID used in the FCAS Requirements.',
   REGIONID             varchar(20) not null  comment 'The Region ID associated with each Constraint Requirements',
   BIDTYPE              varchar(10) not null  comment 'The FCAS Service - DUID offered type',
   REGION_ENABLEMENT    numeric(18,8)  comment 'The Overridden Regional Enablement. SUM(FCAS MW) from FCAS.Clawback_Unitsolution',
   CONSTRAINT_ENABLEMENT numeric(18,8)  comment 'How much is enabled for this bid Type within the constraint. Sum(Regional_Enablement) Group by Interval_Datetime, ConstraintId, BidType',
   REGION_BASE_COST     numeric(18,8)  comment 'The Region Base Cost adjusted by the Regional Enablement Adj Ratio',
   BASE_COST            numeric(18,8)  comment 'The Base cost of the constraint before the regulation/contingency split. SUM(REGION_BASE_COST) Group by interval datetime, ConstraintId',
   ADJUSTED_COST        numeric(18,8)  comment 'The adjusted cost of the constraint for this service, after the regulation/contingency split. This is adjusted by the Base Cost Adjustment Ratio.',
   P_REGULATION         numeric(18,8)  comment 'P Regulation value is not affected by Clawback. This value is copied from Original Data source(DISPATCH )',
   PREV_REGION_ENABLEMENT numeric(18,8)  comment 'The Regional Enablement before Override',
   PREV_CONSTRAINT_ENABLEMENT numeric(18,8)  comment 'The Constraint Enablement before Override',
   PREV_REGION_BASE_COST numeric(18,8)  comment 'The Region Base Cost before Override',
   PREV_BASE_COST       numeric(18,8)  comment 'The Base Cost before Override',
   PREV_ADJUSTED_COST   numeric(18,8)  comment 'The Adjusted Cost before override',
   LASTCHANGED          datetime  comment 'The Last Changed Date time of the record.'
);

alter table SET_FCAS_CLAWBACK_REQ comment 'This report contains the Interval Datetime affected by the C';

alter table SET_FCAS_CLAWBACK_REQ
   add primary key (INTERVAL_DATETIME, RUNNO, CONSTRAINTID, REGIONID, BIDTYPE);

/*==============================================================*/
/* Table: SET_FCAS_CLAWBACK_RUN_TRK                             */
/*==============================================================*/
create table SET_FCAS_CLAWBACK_RUN_TRK
(
   SETTLEMENTDATE       datetime not null  comment 'The Settlement Date of the Billing Week',
   VERSIONNO            numeric(3,0) not null  comment 'The Settlement Run No',
   INTERVAL_DATETIME    datetime not null  comment 'The Interval Datetime for which a Clawback Run has been completed.',
   RUNNO                numeric(3,0)  comment 'The RunNo associated with the Clawback for the above interval date time.',
   CLAWBACK_DATE        datetime  comment 'The Date time the Clawback data has been loaded into the System for processing.',
   PREV_DATA_SOURCE     varchar(20)  comment 'The Clawback Data source Used. If this interval has any Clawback already applied in past then value will be CLAWBACK , else DISPATCH. For the first Clawback processing for the Interval the Source is DISPATCH.',
   LASTCHANGED          datetime  comment 'The Last changed Date time of the record'
);

alter table SET_FCAS_CLAWBACK_RUN_TRK comment 'This Settlements FCAS Clawback Run Track report contains the';

alter table SET_FCAS_CLAWBACK_RUN_TRK
   add primary key (SETTLEMENTDATE, VERSIONNO, INTERVAL_DATETIME);

/*==============================================================*/
/* Table: SET_FCAS_CLAWBACK_UNITSOLN                            */
/*==============================================================*/
create table SET_FCAS_CLAWBACK_UNITSOLN
(
   INTERVAL_DATETIME    datetime not null  comment 'The Interval Datetime for which a the Clawback Run has been completed.',
   RUNNO                numeric(3,0) not null  comment 'The RunNo associated with the Clawback Run for the above interval date time.',
   DUID                 varchar(20) not null  comment 'The DUID for which the Reduced MW has been applied for the FCAS Service.',
   LOWER1SEC            numeric(18,8)  comment 'The Clawback Volume for the LOWER1SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   LOWER5MIN            numeric(18,8)  comment 'The Clawback Volume for the LOWER5MIN Service. If this service is not affected in that Clawback then retain Prev Value.',
   LOWER60SEC           numeric(18,8)  comment 'The Clawback Volume for the LOWER60SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   LOWER6SEC            numeric(18,8)  comment 'The Clawback Volume for the LOWER6SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   RAISE1SEC            numeric(18,8)  comment 'The Clawback Volume for the RAISE1SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   RAISE5MIN            numeric(18,8)  comment 'The Clawback Volume for the RAISE5MIN Service. If this service is not affected in that Clawback then retain Prev Value.',
   RAISE60SEC           numeric(18,8)  comment 'The Clawback Volume for the RAISE60SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   RAISE6SEC            numeric(18,8)  comment 'The Clawback Volume for the RAISE6SEC Service. If this service is not affected in that Clawback then retain Prev Value.',
   LOWERREG             numeric(18,8)  comment 'The Clawback Volume for the LOWERREG Service. If this service is not affected in that Clawback then retain Prev Value.',
   RAISEREG             numeric(18,8)  comment 'The Clawback Volume for the RAISEREG Service. If this service is not affected in that Clawback then retain Prev Value.',
   LASTCHANGED          datetime  comment 'The Last Changed Date time of the record.'
);

alter