/*==============================================================*/
/* Data Model:     AEMO Gas Data Model v2.2.1 MSSQLServer       */
/* Created on:     2024/11/04 11:25:32                          */
/*==============================================================*/


/*==============================================================*/
/* Table: GAS_BLEND_CURTAILMENT                                 */
/*==============================================================*/
create table GAS_BLEND_CURTAILMENT (
   GASYEAR              numeric(4,0)         not null,
   MONTHNO              numeric(4,0)         not null,
   FACILITYID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   CONNECTIONPOINTID    numeric(10,0)        not null,
   FLOWDIRECTION        varchar(20)          not null,
   BLENDCURTAILEVENTS   numeric(20,0)        null,
   BLENDCURTAILQTY      numeric(18,3)        null,
   BLENDHIGH            numeric(18,3)        null,
   BLENDLOW             numeric(18,3)        null,
   BLENDAVG             numeric(18,3)        null,
   GASTYPE              varchar(200)         null,
   BLENDLIMIT           numeric(18,3)        null,
   MAXGASDATE           datetime             null,
   MINGASDATE           datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_BLEND_CURTAILMENT
   add constraint GAS_BLEND_CURTAILMENT_PK primary key (GASYEAR, MONTHNO, FACILITYID, VERSIONDATETIME, CONNECTIONPOINTID, FLOWDIRECTION)
go

alter table GAS_SHORT_TERM_SWAP_TRANS
   alter column QUANTITY numeric(22,8)
go

alter table GAS_SHORT_TERM_TRANS
   alter column QUANTITY numeric(22,8)
go

