/*==============================================================*/
/* Data Model:     AEMO Gas Data Model v2.2 MSSQLServer         */
/* Created on:     2022/08/28 16:37:01                          */
/*==============================================================*/


/*==============================================================*/
/* Table: GAS_BASIN                                             */
/*==============================================================*/
create table GAS_BASIN (
   BASINID              numeric(20,0)        not null,
   BASINNAME            varchar(100)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_BASIN
   add constraint GAS_BASIN_PK primary key (BASINID)
go

/*==============================================================*/
/* Table: GAS_CAPACITY_TYPE                                     */
/*==============================================================*/
create table GAS_CAPACITY_TYPE (
   CAPACITYTYPE         varchar(20)          not null,
   DESCRIPTION          varchar(800)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_CAPACITY_TYPE
   add constraint GAS_CAPACITY_TYPE_PK primary key (CAPACITYTYPE)
go

/*==============================================================*/
/* Table: GAS_CONNECTIONPOINT_CAPACITY                          */
/*==============================================================*/
create table GAS_CONNECTIONPOINT_CAPACITY (
   CONNECTIONPOINTID    numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   CAPACITYQUANTITY     numeric(18,3)        null,
   DESCRIPTION          varchar(255)         null
)
go

alter table GAS_CONNECTIONPOINT_CAPACITY
   add constraint GAS_CONNECTPOINT_CAPACITY_PK primary key (CONNECTIONPOINTID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_CONTACT                                           */
/*==============================================================*/
create table GAS_CONTACT (
   PERSONID             numeric(10,0)        not null,
   TITLE                varchar(10)          null,
   FIRSTNAME            varchar(40)          null,
   LASTNAME             varchar(40)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_CONTACT
   add constraint GAS_CONTACT_PK primary key (PERSONID)
go

/*==============================================================*/
/* Table: GAS_CONTACT_DETAIL                                    */
/*==============================================================*/
create table GAS_CONTACT_DETAIL (
   PERSONID             numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   POSITION             varchar(40)          null,
   PHONE                varchar(30)          null,
   FAX                  varchar(30)          null,
   MOBILE               varchar(30)          null,
   EMAIL                varchar(255)         null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null
)
go

alter table GAS_CONTACT_DETAIL
   add constraint GAS_CONTACT_DETAIL_PK primary key (PERSONID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_DAILY_FLOW_ACTUAL                                 */
/*==============================================================*/
create table GAS_DAILY_FLOW_ACTUAL (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   CONNECTIONPOINTID    numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   FLOWDIRECTION        varchar(20)          not null,
   ACTUALQUANTITY       numeric(18,3)        null,
   QUALITY              varchar(5)           null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_DAILY_FLOW_ACTUAL
   add constraint GAS_DAILY_FLOW_ACTUAL_PK primary key (GASDATE, FACILITYID, CONNECTIONPOINTID, VERSIONDATETIME, FLOWDIRECTION)
go

/*==============================================================*/
/* Table: GAS_DAILY_STORAGE_ACTUAL                              */
/*==============================================================*/
create table GAS_DAILY_STORAGE_ACTUAL (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   ACTUALQUANTITY       numeric(18,3)        null,
   LASTCHANGED          datetime             null,
   CUSHIONGASQUANTITY   numeric(18,3)        null
)
go

alter table GAS_DAILY_STORAGE_ACTUAL
   add constraint GAS_DAILY_STORAGE_ACTUAL_PK primary key (GASDATE, FACILITYID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_DATA_MODEL_AUDIT                                  */
/*==============================================================*/
create table GAS_DATA_MODEL_AUDIT (
   INSTALLATION_DATE    datetime             not null,
   GASDM_VERSION        varchar(20)          not null,
   INSTALL_TYPE         varchar(10)          not null,
   SCRIPT_VERSION       varchar(20)          null,
   GAS_CHANGE_NOTICE    varchar(20)          null,
   PROJECT_TITLE        varchar(200)         null,
   USERNAME             varchar(40)          null,
   STATUS               varchar(10)          null
)
go

alter table GAS_DATA_MODEL_AUDIT
   add constraint GAS_DATA_MODEL_AUDIT_PK primary key (INSTALLATION_DATE, GASDM_VERSION, INSTALL_TYPE)
go

/*==============================================================*/
/* Table: GAS_DEVFACILITY                                       */
/*==============================================================*/
create table GAS_DEVFACILITY (
   DEVFACILITYID        numeric(20,0)        not null,
   DESCRIPTION          varchar(100)         null,
   FACILITYTYPE         varchar(40)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_DEVFACILITY
   add constraint GAS_DEVFACILITY_PK primary key (DEVFACILITYID)
go

/*==============================================================*/
/* Table: GAS_DEVFACILITY_DETAIL                                */
/*==============================================================*/
create table GAS_DEVFACILITY_DETAIL (
   DEVFACILITYID        numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   PROPOSEDNAME         varchar(100)         null,
   MINNAMEPLATE         numeric(18,3)        null,
   MAXNAMEPLATE         numeric(18,3)        null,
   LOCATION             varchar(200)         null,
   PLANNEDCOMMISSIONFROM varchar(7)           null,
   PLANNEDCOMMISSIONTO  varchar(7)           null,
   DEVELOPMENTSTAGE     varchar(200)         null,
   COMMENTS             varchar(400)         null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_DEVFACILITY_DETAIL
   add constraint GAS_DEVFACILITY_DETAIL_PK primary key (DEVFACILITYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_DEVFACILITY_FACILITY                              */
/*==============================================================*/
create table GAS_DEVFACILITY_FACILITY (
   DEVFACILITYID        numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   FACILITYID           numeric(20,0)        not null
)
go

alter table GAS_DEVFACILITY_FACILITY
   add constraint GAS_DEVFACILITY_FACILITY_PK primary key (DEVFACILITYID, EFFECTIVEDATE, VERSIONDATETIME, FACILITYID)
go

/*==============================================================*/
/* Table: GAS_FACILITY                                          */
/*==============================================================*/
create table GAS_FACILITY (
   FACILITYID           numeric(10,0)        not null,
   FACILITYNAME         varchar(100)         null,
   FACILITYTYPE         varchar(40)          null,
   LASTCHANGED          datetime             null,
   FACILITYSHORTNAME    varchar(30)          null
)
go

alter table GAS_FACILITY
   add constraint GAS_FACILITY_PK primary key (FACILITYID)
go

/*==============================================================*/
/* Table: GAS_FACILITY_DETAIL                                   */
/*==============================================================*/
create table GAS_FACILITY_DETAIL (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   GASDAYSTARTHOUR      numeric(2,0)         null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_DETAIL
   add constraint GAS_FACILITY_DETAIL_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FACILITY_DETAIL_CAPACITY                          */
/*==============================================================*/
create table GAS_FACILITY_DETAIL_CAPACITY (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   CAPACITYTYPE         varchar(20)          not null,
   VERSIONDATETIME      datetime             not null,
   LOWRANGE             numeric(3,0)         null,
   HIRANGE              numeric(3,0)         null,
   UNITS                varchar(5)           null,
   COMMENTS             varchar(255)         null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null
)
go

alter table GAS_FACILITY_DETAIL_CAPACITY
   add constraint GAS_FACILITY_DETAIL_CAP_PK primary key (FACILITYID, EFFECTIVEDATE, CAPACITYTYPE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FACILITY_NODE                                     */
/*==============================================================*/
create table GAS_FACILITY_NODE (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   NODEID               numeric(10,0)        not null
)
go

alter table GAS_FACILITY_NODE
   add constraint GAS_FACILITY_NODE_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME, NODEID)
go

/*==============================================================*/
/* Table: GAS_FACILITY_NODE_CONNECTION                          */
/*==============================================================*/
create table GAS_FACILITY_NODE_CONNECTION (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   NODEID               numeric(10,0)        not null,
   CONNECTIONPOINTID    numeric(10,0)        not null,
   FLOWDIRECTION        varchar(20)          not null,
   ISEXEMPT             numeric(1,0)         null,
   HASAGGREGATIONPRIORITY numeric(1,0)         null,
   CONNECTIONPOINTNAME  varchar(200)         null,
   MIRN                 varchar(20)          null,
   HASFORECAST          numeric(1,0)         null,
   CONNECTIONPOINTSHORTNAME varchar(30)          null,
   EXEMPTIONDESCRIPTION varchar(200)         null
)
go

alter table GAS_FACILITY_NODE_CONNECTION
   add constraint GAS_FACILITY_NODE_CONNECT_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME, NODEID, CONNECTIONPOINTID, FLOWDIRECTION)
go

/*==============================================================*/
/* Table: GAS_FACILITY_NODE_TRK                                 */
/*==============================================================*/
create table GAS_FACILITY_NODE_TRK (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_NODE_TRK
   add constraint GAS_FACILITY_NODE_TRK_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FACILITY_OPSTATE                                  */
/*==============================================================*/
create table GAS_FACILITY_OPSTATE (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   OPERATINGSTATE       varchar(20)          null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_OPSTATE
   add constraint GAS_FACILITY_OPSTATE_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FACILITY_OWNER                                    */
/*==============================================================*/
create table GAS_FACILITY_OWNER (
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   FACILITYID           numeric(10,0)        not null
)
go

alter table GAS_FACILITY_OWNER
   add constraint GAS_FACILITY_OWNER_PK primary key (COMPANYID, EFFECTIVEDATE, VERSIONDATETIME, FACILITYID)
go

/*==============================================================*/
/* Table: GAS_FACILITY_OWNER_TRK                                */
/*==============================================================*/
create table GAS_FACILITY_OWNER_TRK (
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_OWNER_TRK
   add constraint GAS_FACILITY_OWNER_TRK_PK primary key (COMPANYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FACILITY_SUMMARY                                  */
/*==============================================================*/
create table GAS_FACILITY_SUMMARY (
   FACILITYID           numeric(10,0)        not null,
   STARTDATE            datetime             not null,
   ENDDATE              datetime             null,
   NODEID               numeric(10,0)        null,
   CONNECTIONPOINTID    numeric(10,0)        not null,
   FLOWDIRECTION        varchar(20)          not null,
   CONNECTIONPOINTNAME  varchar(200)         null,
   STATEID              numeric(10,0)        null,
   STATE                varchar(5)           null,
   FACILITYNAME         varchar(100)         null,
   FACILITYTYPE         varchar(40)          null,
   FACILITYTYPEDESCRIPTION varchar(800)         null,
   GASDAYSTARTHOUR      numeric(2,0)         null,
   COMPANYID            numeric(10,0)        null,
   COMPANYNAME          varchar(50)          null,
   LOCATIONID           numeric(10,0)        null,
   LOCATIONNAME         varchar(100)         null,
   LOCATIONTYPE         varchar(40)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_SUMMARY
   add constraint GAS_FACILITY_SUMMARY_PK primary key (FACILITYID, STARTDATE, CONNECTIONPOINTID, FLOWDIRECTION)
go

/*==============================================================*/
/* Table: GAS_FACILITY_TYPE                                     */
/*==============================================================*/
create table GAS_FACILITY_TYPE (
   FACILITYTYPE         varchar(40)          not null,
   DESCRIPTION          varchar(800)         null,
   ACTIONTYPE           varchar(40)          null,
   ISREPORTABLE         numeric(1,0)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FACILITY_TYPE
   add constraint GAS_FACILITY_TYPE_PK primary key (FACILITYTYPE)
go

/*==============================================================*/
/* Table: GAS_FIELD                                             */
/*==============================================================*/
create table GAS_FIELD (
   FIELDID              numeric(20,0)        not null,
   LASTCHANGED          datetime             null,
   STATEID              numeric(10,0)        null,
   STATE                varchar(5)           null
)
go

alter table GAS_FIELD
   add constraint GAS_FIELD_PK primary key (FIELDID)
go

/*==============================================================*/
/* Table: GAS_FIELDINTEREST                                     */
/*==============================================================*/
create table GAS_FIELDINTEREST (
   FIELDINTERESTID      numeric(20,0)        not null,
   FIELDID              numeric(20,0)        null,
   ANNUALREPORTINGDATE  varchar(30)          null
)
go

alter table GAS_FIELDINTEREST
   add constraint GAS_FIELDINTEREST_PK primary key (FIELDINTERESTID)
go

/*==============================================================*/
/* Table: GAS_FIELDINTEREST_DETAIL                              */
/*==============================================================*/
create table GAS_FIELDINTEREST_DETAIL (
   FIELDINTERESTID      numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   PETROLEUMTENEMENTS   varchar(300)         null,
   PROCESSINGFACILITIES varchar(300)         null,
   RESOURCECLASSIFICATION varchar(100)         null,
   RESOURCESUBCLASSIFICATION varchar(100)         null,
   NATUREOFGAS          varchar(100)         null,
   TENEMENTSHARE        numeric(10,3)        null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FIELDINTEREST_DETAIL
   add constraint GAS_FIELDINTEREST_DETAIL_PK primary key (FIELDINTERESTID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FIELDINTEREST_PARTICIPANT                         */
/*==============================================================*/
create table GAS_FIELDINTEREST_PARTICIPANT (
   FIELDINTERESTID      numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   COMPANYID            numeric(10,0)        not null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FIELDINTEREST_PARTICIPANT
   add constraint GAS_FIELDINT_PARTICIPANT_PK primary key (FIELDINTERESTID, EFFECTIVEDATE, VERSIONDATETIME, COMPANYID)
go

/*==============================================================*/
/* Table: GAS_FIELDINTEREST_SHARE                               */
/*==============================================================*/
create table GAS_FIELDINTEREST_SHARE (
   FIELDINTERESTID      numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   REPORTEDCOMPANY      varchar(100)         not null,
   PERCENTAGESHARE      numeric(18,8)        null
)
go

alter table GAS_FIELDINTEREST_SHARE
   add constraint GAS_FIELDINTEREST_SHARE_PK primary key (FIELDINTERESTID, EFFECTIVEDATE, VERSIONDATETIME, REPORTEDCOMPANY)
go

/*==============================================================*/
/* Table: GAS_FIELDINTEREST_SHARETRK                            */
/*==============================================================*/
create table GAS_FIELDINTEREST_SHARETRK (
   FIELDINTERESTID      numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FIELDINTEREST_SHARETRK
   add constraint GAS_FIELDINTEREST_SHARETRK_PK primary key (FIELDINTERESTID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_FIELD_DETAIL                                      */
/*==============================================================*/
create table GAS_FIELD_DETAIL (
   FIELDID              numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   FIELDNAME            varchar(100)         null,
   FIELDSHORTNAME       varchar(30)          null,
   DESCRIPTION          varchar(400)         null,
   LOCATIONDESCRIPTION  varchar(200)         null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_FIELD_DETAIL
   add constraint GAS_FIELD_DETAIL_PK primary key (FIELDID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_GSH_TRADES                                        */
/*==============================================================*/
create table GAS_GSH_TRADES (
   TRADE_DATE           datetime             not null,
   TRANSACTION_TYPE     varchar(20)          not null,
   PRODUCT              varchar(80)          not null,
   LOCATION             varchar(100)         not null,
   NO_OF_TRADES         numeric(10)          null,
   TRADE_PRICE          numeric(18,8)        not null,
   DAILY_QTY_GJ         numeric(18,8)        null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   MANUAL_TRADE         varchar(50)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_GSH_TRADES
   add constraint GAS_GSH_TRADES_PK primary key (TRADE_DATE, TRANSACTION_TYPE, PRODUCT, LOCATION, TRADE_PRICE)
go

/*==============================================================*/
/* Table: GAS_LINEPACK_ADEQUACY                                 */
/*==============================================================*/
create table GAS_LINEPACK_ADEQUACY (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   FLAG                 varchar(5)           null,
   DESCRIPTION          varchar(800)         null
)
go

alter table GAS_LINEPACK_ADEQUACY
   add constraint GAS_LINEPACK_ADEQUACY_PK primary key (GASDATE, FACILITYID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_LNG_SHIPMENT                                      */
/*==============================================================*/
create table GAS_LNG_SHIPMENT (
   TRANSACTIONID        varchar(40)          not null,
   FACILITYID           numeric(20,0)        not null,
   VERSIONDATETIME      datetime             not null,
   SHIPMENTDATE         datetime             null,
   VOLUMEPJ             numeric(18,8)        null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_LNG_SHIPMENT
   add constraint GAS_LNG_SHIPMENT_PK primary key (TRANSACTIONID, FACILITYID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_LNG_TRANSACTION                                   */
/*==============================================================*/
create table GAS_LNG_TRANSACTION (
   TRANSACTIONSTARTDATE datetime             not null,
   TRANSACTIONENDDATE   datetime             null,
   VOLWEIGHTPRICE       numeric(18,8)        null,
   VOLUMEPJ             numeric(18,8)        null,
   SUPPLYPERIODSTART    datetime             null,
   SUPPLYPERIODEND      datetime             null
)
go

alter table GAS_LNG_TRANSACTION
   add constraint GAS_LNG_TRANSACTION_PK primary key (TRANSACTIONSTARTDATE)
go

/*==============================================================*/
/* Table: GAS_LOCATION                                          */
/*==============================================================*/
create table GAS_LOCATION (
   LOCATIONID           numeric(10,0)        not null,
   LOCATIONNAME         varchar(100)         null,
   LOCATIONTYPE         varchar(40)          null,
   STATEID              numeric(10,0)        null,
   DESCRIPTION          varchar(800)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_LOCATION
   add constraint GAS_LOCATION_PK primary key (LOCATIONID)
go

/*==============================================================*/
/* Table: GAS_LOCATION_NODE                                     */
/*==============================================================*/
create table GAS_LOCATION_NODE (
   LOCATIONID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   NODEID               numeric(10,0)        not null
)
go

alter table GAS_LOCATION_NODE
   add constraint GAS_LOCATION_NODE_PK primary key (LOCATIONID, EFFECTIVEDATE, VERSIONDATETIME, NODEID)
go

/*==============================================================*/
/* Table: GAS_LOCATION_NODE_TRK                                 */
/*==============================================================*/
create table GAS_LOCATION_NODE_TRK (
   LOCATIONID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_LOCATION_NODE_TRK
   add constraint GAS_LOCATION_NODE_TRK_PK primary key (LOCATIONID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_LOCATION_OPSTATE                                  */
/*==============================================================*/
create table GAS_LOCATION_OPSTATE (
   LOCATIONID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   OPERATINGSTATE       varchar(20)          null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_LOCATION_OPSTATE
   add constraint GAS_LOCATION_OPSTATE_PK primary key (LOCATIONID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_MARKET                                            */
/*==============================================================*/
create table GAS_MARKET (
   MARKETID             varchar(20)          not null,
   DESCRIPTION          varchar(255)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_MARKET
   add constraint GAS_MARKET_PK primary key (MARKETID)
go

/*==============================================================*/
/* Table: GAS_MEDIUM_TERM_CAP_OUTLOOK                           */
/*==============================================================*/
create table GAS_MEDIUM_TERM_CAP_OUTLOOK (
   FACILITYID           numeric(10,0)        not null,
   FROMGASDATE          datetime             not null,
   TOGASDATE            datetime             null,
   VERSIONDATETIME      datetime             not null,
   CAPACITYTYPE         varchar(20)          not null,
   FLOWDIRECTION        varchar(20)          not null,
   RECEIPTLOCATION      numeric(10,0)        not null,
   DELIVERYLOCATION     numeric(10,0)        not null,
   OUTLOOKQUANTITY      numeric(18,3)        null,
   CAPACITYDESCRIPTION  varchar(1000)        null,
   DESCRIPTION          varchar(1000)        null,
   ACTIVEFLAG           numeric(1,0)         null,
   DISABLEDDATETIME     datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_MEDIUM_TERM_CAP_OUTLOOK
   add constraint GAS_MEDIUM_TERM_CAP_OUTLOOK_PK primary key (FACILITYID, FROMGASDATE, VERSIONDATETIME, CAPACITYTYPE, FLOWDIRECTION, RECEIPTLOCATION, DELIVERYLOCATION)
go

/*==============================================================*/
/* Table: GAS_NAMEPLATE_RATING                                  */
/*==============================================================*/
create table GAS_NAMEPLATE_RATING (
   FACILITYID           numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   CAPACITYTYPE         varchar(20)          not null,
   FLOWDIRECTION        varchar(20)          not null,
   RECEIPTLOCATION      numeric(10,0)        not null,
   DELIVERYLOCATION     numeric(10,0)        not null,
   CAPACITYQUANTITY     numeric(18,3)        null,
   CAPACITYDESCRIPTION  varchar(1000)        null,
   DESCRIPTION          varchar(1000)        null
)
go

alter table GAS_NAMEPLATE_RATING
   add constraint GAS_NAMEPLATE_RATING_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME, CAPACITYTYPE, FLOWDIRECTION, RECEIPTLOCATION, DELIVERYLOCATION)
go

/*==============================================================*/
/* Table: GAS_NODE                                              */
/*==============================================================*/
create table GAS_NODE (
   NODEID               numeric(10,0)        not null,
   STATEID              numeric(10,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_NODE
   add constraint GAS_NODE_PK primary key (NODEID)
go

/*==============================================================*/
/* Table: GAS_NODE_OPSTATE                                      */
/*==============================================================*/
create table GAS_NODE_OPSTATE (
   NODEID               numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   OPERATINGSTATE       varchar(20)          null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_NODE_OPSTATE
   add constraint GAS_NODE_OPSTATE_PK primary key (NODEID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_NOMINATIONS_FORECAST                              */
/*==============================================================*/
create table GAS_NOMINATIONS_FORECAST (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   CONNECTIONPOINTID    numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   FLOWDIRECTION        varchar(20)          not null,
   NOMINATIONQUANTITY   numeric(18,3)        null
)
go

alter table GAS_NOMINATIONS_FORECAST
   add constraint GAS_NOMINATIONS_FORECAST_PK primary key (GASDATE, FACILITYID, CONNECTIONPOINTID, VERSIONDATETIME, FLOWDIRECTION)
go

/*==============================================================*/
/* Table: GAS_NOMINATIONS_FORECAST_AGG                          */
/*==============================================================*/
create table GAS_NOMINATIONS_FORECAST_AGG (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   LOCATIONID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   DEMAND               numeric(18,3)        null,
   SUPPLY               numeric(18,3)        null,
   TRANSFERIN           numeric(18,3)        null,
   TRANSFEROUT          numeric(18,3)        null,
   COMPLETENESS         numeric(3,0)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_NOMINATIONS_FORECAST_AGG
   add constraint GAS_NOMINATIONS_FCST_AGG_PK primary key (GASDATE, FACILITYID, LOCATIONID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_PARTICIPANT                                       */
/*==============================================================*/
create table GAS_PARTICIPANT (
   COMPANYID            numeric(10,0)        not null,
   DESCRIPTION          varchar(800)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_PARTICIPANT
   add constraint GAS_PARTICIPANT_PK primary key (COMPANYID)
go

/*==============================================================*/
/* Table: GAS_PARTICIPANT_CONTACT                               */
/*==============================================================*/
create table GAS_PARTICIPANT_CONTACT (
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   PERSONID             numeric(10,0)        not null
)
go

alter table GAS_PARTICIPANT_CONTACT
   add constraint GAS_PARTICIPANT_CONTACT_PK primary key (COMPANYID, EFFECTIVEDATE, VERSIONDATETIME, PERSONID)
go

/*==============================================================*/
/* Table: GAS_PARTICIPANT_CONTACT_TRK                           */
/*==============================================================*/
create table GAS_PARTICIPANT_CONTACT_TRK (
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null
)
go

alter table GAS_PARTICIPANT_CONTACT_TRK
   add constraint GAS_PARTICIPANT_CONTACT_TRK_PK primary key (COMPANYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_PARTICIPANT_DETAIL                                */
/*==============================================================*/
create table GAS_PARTICIPANT_DETAIL (
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   COMPANYNAME          varchar(50)          null,
   ABN                  varchar(30)          null,
   ADDRESSTYPE          varchar(40)          null,
   ADDRESS              varchar(120)         null,
   LOCALE               varchar(40)          null,
   JURISDICTION         varchar(5)           null,
   POSTCODE             varchar(4)           null,
   COMPANYPHONE         varchar(30)          null,
   COMPANYFAX           varchar(30)          null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null,
   ORGANISATIONTYPENAME varchar(40)          null
)
go

alter table GAS_PARTICIPANT_DETAIL
   add constraint GAS_PARTICIPANT_DETAIL_PK primary key (COMPANYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_PARTICIPANT_OPSTATE                               */
/*==============================================================*/
create table GAS_PARTICIPANT_OPSTATE (
   MARKETID             varchar(20)          not null,
   COMPANYID            numeric(10,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   OPERATINGSTATE       varchar(20)          null,
   AUTHORISEDDATE       datetime             null,
   AUTHORISEDBY         varchar(30)          null
)
go

alter table GAS_PARTICIPANT_OPSTATE
   add constraint GAS_PARTICIPANT_OPSTATE_PK primary key (MARKETID, COMPANYID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_RESERVES_AND_RESOURCES                            */
/*==============================================================*/
create table GAS_RESERVES_AND_RESOURCES (
   FIELDINTERESTID      numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   DEVELOPEDRESERVE1P   numeric(18,3)        null,
   DEVELOPEDRESERVE2P   numeric(18,3)        null,
   DEVELOPEDRESERVE3P   numeric(18,3)        null,
   UNDEVELOPEDRESERVE1P numeric(18,3)        null,
   UNDEVELOPEDRESERVE2P numeric(18,3)        null,
   UNDEVELOPEDRESERVE3P numeric(18,3)        null,
   RESOURCES2C          numeric(18,3)        null,
   PRODUCTIONCHANGERESERVE2P numeric(18,3)        null,
   PROVEDAREAEXTENSIONRESERVE2P numeric(18,3)        null,
   PERCENTAGECHANGERESERVE2P numeric(18,3)        null,
   UPWARDREVISION3PRESERVETO2P numeric(18,3)        null,
   DOWNWARDREVISION2PRESERVETO3P numeric(18,3)        null,
   OTHERREVISIONSRESERVE2P numeric(18,3)        null,
   MATURITYSUBCLASS2P   varchar(100)         null,
   MATURITYSUBCLASS2C   varchar(100)         null,
   MINDATE2P            datetime             null,
   MAXDATE2P            datetime             null,
   MINDATE2C            datetime             null,
   MAXDATE2C            datetime             null,
   EXPECTEDBARRIERS2C   varchar(400)         null,
   RESOURCESESTIMATEMETHOD varchar(200)         null,
   CONVERSIONFACTORQTYTCFTOPJ numeric(18,3)        null,
   ECONOMICASSUMPTION   varchar(400)         null,
   UPDATEREASON         varchar(400)         null,
   PREPAREDBY           varchar(100)         null,
   INDEPENDENTESTIMATE  varchar(3)           null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_RESERVES_AND_RESOURCES
   add constraint GAS_RESERVES_AND_RESOURCES_PK primary key (FIELDINTERESTID, EFFECTIVEDATE, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_SEC_CAP_ORDERS                                    */
/*==============================================================*/
create table GAS_SEC_CAP_ORDERS (
   ORDERID              varchar(40)          not null,
   SUBMITTINGCOMPANYID  numeric(10,0)        null,
   VERSIONDATETIME      datetime             null,
   FACILITYID           numeric(10,0)        null,
   BUYSELL              varchar(5)           null,
   AVAILABLEQUANTITY    numeric(18,3)        null,
   PRICE                numeric(18,2)        null,
   FROMGASDATE          datetime             null,
   TOGASDATE            datetime             null,
   RECEIPTLOCATION      numeric(10,0)        null,
   DELIVERYLOCATION     numeric(10,0)        null,
   CONTACTDETAILS       varchar(1000)        null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_SEC_CAP_ORDERS
   add constraint GAS_SEC_CAP_ORDERS_PK primary key (ORDERID)
go

/*==============================================================*/
/* Index: GAS_SEC_CAP_ORDERS_IDX1                               */
/*==============================================================*/




create nonclustered index GAS_SEC_CAP_ORDERS_IDX1 on GAS_SEC_CAP_ORDERS (SUBMITTINGCOMPANYID ASC,
  VERSIONDATETIME ASC)
go

/*==============================================================*/
/* Index: GAS_SEC_CAP_ORDERS_IDX2                               */
/*==============================================================*/




create nonclustered index GAS_SEC_CAP_ORDERS_IDX2 on GAS_SEC_CAP_ORDERS (FROMGASDATE ASC,
  TOGASDATE ASC)
go

/*==============================================================*/
/* Table: GAS_SEC_CAP_ORDERS_TRK                                */
/*==============================================================*/
create table GAS_SEC_CAP_ORDERS_TRK (
   SUBMITTINGCOMPANYID  numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_SEC_CAP_ORDERS_TRK
   add constraint GAS_SEC_CAP_ORDERS_TRK_PK primary key (SUBMITTINGCOMPANYID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_SEC_CAP_TRADES                                    */
/*==============================================================*/
create table GAS_SEC_CAP_TRADES (
   TRADEID              varchar(40)          not null,
   SUBMITTINGCOMPANYID  numeric(10,0)        null,
   VERSIONDATETIME      datetime             null,
   FACILITYID           numeric(10,0)        null,
   GASDATE              datetime             null,
   RECEIPTLOCATION      numeric(10,0)        null,
   DELIVERYLOCATION     numeric(10,0)        null,
   NAMEPLATECAPACITY    numeric(18,3)        null,
   DAILYNOMINATIONS     numeric(18,3)        null,
   DAILYUTILISATIONPERCENT numeric(18,2)        null,
   AVAILABLECAPACITY    numeric(18,3)        null,
   CAPACITYONOFFER      numeric(18,3)        null,
   DAILYCAPACITYTRADED  numeric(18,3)        null,
   DAILYCAPACITY        numeric(18,3)        null,
   CONTRACTEDCAPACITY   numeric(18,3)        null,
   AVERAGEANNUALCAPACITYTRADED numeric(18,3)        null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_SEC_CAP_TRADES
   add constraint GAS_SEC_CAP_TRADES_PK primary key (TRADEID)
go

/*==============================================================*/
/* Index: GAS_SEC_CAP_TRADES_IDX1                               */
/*==============================================================*/




create nonclustered index GAS_SEC_CAP_TRADES_IDX1 on GAS_SEC_CAP_TRADES (SUBMITTINGCOMPANYID ASC,
  VERSIONDATETIME ASC)
go

/*==============================================================*/
/* Index: GAS_SEC_CAP_TRADES_IDX2                               */
/*==============================================================*/




create nonclustered index GAS_SEC_CAP_TRADES_IDX2 on GAS_SEC_CAP_TRADES (GASDATE ASC)
go

/*==============================================================*/
/* Table: GAS_SEC_CAP_TRADES_TRK                                */
/*==============================================================*/
create table GAS_SEC_CAP_TRADES_TRK (
   SUBMITTINGCOMPANYID  numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_SEC_CAP_TRADES_TRK
   add constraint GAS_SEC_CAP_TRADES_TRK_PK primary key (SUBMITTINGCOMPANYID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_SHIPPER_LIST                                      */
/*==============================================================*/
create table GAS_SHIPPER_LIST (
   FACILITYID           numeric(20,0)        not null,
   EFFECTIVEDATE        datetime             not null,
   VERSIONDATETIME      datetime             not null,
   SHIPPERNAME          varchar(200)         not null
)
go

alter table GAS_SHIPPER_LIST
   add constraint GAS_SHIPPER_LIST_PK primary key (FACILITYID, EFFECTIVEDATE, VERSIONDATETIME, SHIPPERNAME)
go

/*==============================================================*/
/* Table: GAS_SHORT_TERM_CAP_OUTLOOK                            */
/*==============================================================*/
create table GAS_SHORT_TERM_CAP_OUTLOOK (
   GASDATE              datetime             not null,
   FACILITYID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   CAPACITYTYPE         varchar(20)          not null,
   FLOWDIRECTION        varchar(20)          not null,
   RECEIPTLOCATION      numeric(10,0)        not null,
   DELIVERYLOCATION     numeric(10,0)        not null,
   OUTLOOKQUANTITY      numeric(18,3)        null,
   CAPACITYDESCRIPTION  varchar(1000)        null,
   DESCRIPTION          varchar(1000)        null
)
go

alter table GAS_SHORT_TERM_CAP_OUTLOOK
   add constraint GAS_SHORT_TERM_CAP_OUTLOOK_PK primary key (GASDATE, FACILITYID, VERSIONDATETIME, CAPACITYTYPE, FLOWDIRECTION, RECEIPTLOCATION, DELIVERYLOCATION)
go

/*==============================================================*/
/* Table: GAS_SHORT_TERM_SWAP_TRANS                             */
/*==============================================================*/
create table GAS_SHORT_TERM_SWAP_TRANS (
   PERIODSTARTDATE      datetime             not null,
   PERIODENDDATE        datetime             null,
   STATE                varchar(5)           not null,
   QUANTITY             numeric(18,8)        null,
   VOLUMEWEIGHTEDPRICE  numeric(18,8)        null,
   TRANSACTIONTYPE      varchar(255)         null,
   SUPPLYPERIODSTART    datetime             null,
   SUPPLYPERIODEND      datetime             null
)
go

alter table GAS_SHORT_TERM_SWAP_TRANS
   add constraint GAS_SHORT_TERM_SWAP_TRANS_PK primary key (PERIODSTARTDATE, STATE)
go

/*==============================================================*/
/* Table: GAS_SHORT_TERM_TRANS                                  */
/*==============================================================*/
create table GAS_SHORT_TERM_TRANS (
   PERIODSTARTDATE      datetime             not null,
   PERIODENDDATE        datetime             null,
   STATE                varchar(5)           not null,
   QUANTITY             numeric(18,8)        null,
   VOLUMEWEIGHTEDPRICE  numeric(18,8)        null,
   TRANSACTIONTYPE      varchar(255)         null,
   SUPPLYPERIODSTART    datetime             null,
   SUPPLYPERIODEND      datetime             null
)
go

alter table GAS_SHORT_TERM_TRANS
   add constraint GAS_SHORT_TERM_TRANS_PK primary key (PERIODSTARTDATE, STATE)
go

/*==============================================================*/
/* Table: GAS_STATE                                             */
/*==============================================================*/
create table GAS_STATE (
   STATEID              numeric(10,0)        not null,
   STATE                varchar(5)           null,
   STATENAME            varchar(50)          null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_STATE
   add constraint GAS_STATE_PK primary key (STATEID)
go

/*==============================================================*/
/* Table: GAS_STORAGE_CAPACITY_TRANS                            */
/*==============================================================*/
create table GAS_STORAGE_CAPACITY_TRANS (
   TRADEID              numeric(20,0)        not null,
   VERSIONDATETIME      datetime             not null,
   TRADEDATE            datetime             null,
   FROMGASDATE          datetime             null,
   TOGASDATE            datetime             null,
   FACILITYID           numeric(20,0)        null,
   PRIORITY             varchar(255)         null,
   MAXIMUMSTORAGEQUANTITY numeric(18,3)        null,
   INJECTIONCAPACITY    numeric(18,3)        null,
   WITHDRAWALCAPACITY   numeric(18,3)        null,
   PRICE                numeric(18,3)        null,
   PRICESTRUCTURE       varchar(255)         null,
   PRICEESCALATIONMECHANISM varchar(255)         null,
   CANCELLED            numeric(1,0)         null,
   LASTCHANGED          datetime             null
)
go

alter table GAS_STORAGE_CAPACITY_TRANS
   add constraint GAS_STORAGE_CAPACITY_TRANS_PK primary key (TRADEID, VERSIONDATETIME)
go

/*==============================================================*/
/* Table: GAS_UNCONTRACTED_CAP_OUTLOOK                          */
/*==============================================================*/
create table GAS_UNCONTRACTED_CAP_OUTLOOK (
   OUTLOOKYEAR          numeric(4,0)         not null,
   OUTLOOKMONTH         numeric(4,0)         not null,
   FACILITYID           numeric(10,0)        not null,
   VERSIONDATETIME      datetime             not null,
   CAPACITYTYPE         varchar(20)          not null,
   FLOWDIRECTION        varchar(20)          not null,
   RECEIPTLOCATION      numeric(10,0)        not null,
   DELIVERYLOCATION     numeric(10,0)        not null,
   OUTLOOKQUANTITY      numeric(18,3)        null,
   CAPACITYDESCRIPTION  varchar(1000)        null,
   DESCRIPTION          varchar(1000)        null
)
go

alter table GAS_UNCONTRACTED_CAP_OUTLOOK
   add constraint GAS_UNCON_CAP_OUTLOOK_PK primary key (OUTLOOKYEAR, OUTLOOKMONTH, FACILITYID, VERSIONDATETIME, CAPACITYTYPE, FLOWDIRECTION, RECEIPTLOCATION, DELIVERYLOCATION)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID                                       */
/*==============================================================*/
create table GSH_AUCTION_BID (
   GAS_DATE             datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   SUBMISSION_TIME      datetime             not null,
   BID_ID               numeric(8,0)         not null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID
   add constraint GSH_AUCTION_BID_PK primary key (GAS_DATE, PARTICIPANT_CODE, SUBMISSION_TIME, BID_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID_PRODUCT                               */
/*==============================================================*/
create table GSH_AUCTION_BID_PRODUCT (
   GAS_DATE             datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   SUBMISSION_TIME      datetime             not null,
   BID_ID               numeric(8,0)         not null,
   AUCTION_PRODUCT_TYPE varchar(20)          not null,
   RECEIPT_POINT_ID     numeric(8,0)         not null,
   RECEIPT_POINT_NAME   varchar(255)         null,
   RP_DWGM_REFERENCE    varchar(255)         null,
   DELIVERY_POINT_ID    numeric(8,0)         not null,
   DELIVERY_POINT_NAME  varchar(255)         null,
   DP_DWGM_REFERENCE    varchar(255)         null,
   SERVICE_REFERENCE    varchar(255)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID_PRODUCT
   add constraint GSH_AUCTION_BID_PRODUCT_PK primary key (GAS_DATE, PARTICIPANT_CODE, SUBMISSION_TIME, BID_ID, AUCTION_PRODUCT_TYPE, DELIVERY_POINT_ID, RECEIPT_POINT_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID_PROFILE                               */
/*==============================================================*/
create table GSH_AUCTION_BID_PROFILE (
   GAS_DATE             datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   SUBMISSION_TIME      datetime             not null,
   LAST_UPDATED_BY      varchar(20)          null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID_PROFILE
   add constraint GSH_AUCTION_BID_PROFILE_PK primary key (GAS_DATE, PARTICIPANT_CODE, SUBMISSION_TIME)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID_STEPS                                 */
/*==============================================================*/
create table GSH_AUCTION_BID_STEPS (
   GAS_DATE             datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   SUBMISSION_TIME      datetime             not null,
   BID_ID               numeric(8,0)         not null,
   STEP_NUMBER          numeric(6,0)         not null,
   STEP_QUANTITY        numeric(18,8)        null,
   STEP_PRICE           numeric(18,8)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID_STEPS
   add constraint GSH_AUCTION_BID_STEPS_PK primary key (GAS_DATE, PARTICIPANT_CODE, SUBMISSION_TIME, BID_ID, STEP_NUMBER)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID_SUBMISSION                            */
/*==============================================================*/
create table GSH_AUCTION_BID_SUBMISSION (
   SUBMISSION_ID        numeric(8,0)         not null,
   PARTICIPANT_CODE     varchar(20)          null,
   SUBMISSION_TIME      datetime             null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   LAST_UPDATED         datetime             null,
   LAST_UPDATED_BY      varchar(100)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID_SUBMISSION
   add constraint GSH_AUCTION_BID_SUBMISSION_PK primary key (SUBMISSION_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_BID_TRK                                   */
/*==============================================================*/
create table GSH_AUCTION_BID_TRK (
   AUCTION_DATE         datetime             not null,
   VERSION_DATETIME     datetime             not null,
   GAS_DATE             datetime             not null,
   PARTICIPANT_ID       varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   BID_ID               numeric(8,0)         not null,
   SUBMISSION_TIME      datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_BID_TRK
   add constraint GSH_AUCTION_BID_TRK_PK primary key (AUCTION_DATE, GAS_DATE, VERSION_DATETIME, PARTICIPANT_ID, BID_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_CURTAIL_NOTICE                            */
/*==============================================================*/
create table GSH_AUCTION_CURTAIL_NOTICE (
   NOTICE_ID            numeric(8,0)         not null,
   FACILITY_ID          numeric(8,0)         not null,
   CURTAILED            varchar(3)           null,
   MATERIAL             varchar(3)           null,
   DESCRIPTION          varchar(255)         null,
   EFFECTIVE_DATE_TIME  datetime             not null,
   FACILITY_NAME        varchar(100)         null,
   AUCTION_SERVICE      varchar(20)          not null,
   GAS_DATE             datetime             not null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_CURTAIL_NOTICE
   add constraint GSH_AUCTION_CURTAIL_NOTICE_PK primary key (NOTICE_ID, FACILITY_ID, AUCTION_SERVICE, EFFECTIVE_DATE_TIME, GAS_DATE)
go

/*==============================================================*/
/* Table: GSH_AUCTION_PRICE_VOLUME                              */
/*==============================================================*/
create table GSH_AUCTION_PRICE_VOLUME (
   AUCTION_DATE         datetime             not null,
   GAS_DATE             datetime             not null,
   FACILITY_ID          numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   LIMIT_ID             numeric(8,0)         not null,
   LIMIT_NAME           varchar(100)         null,
   LIMIT_TYPE           varchar(100)         null,
   CLEARED_QUANTITY     numeric(12,4)        null,
   CLEARED_PRICE        numeric(12,4)        null,
   HIGH_PRICE_SENSITIVITY numeric(12,4)        null,
   LOW_PRICE_SENSITIVITY numeric(12,4)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_PRICE_VOLUME
   add constraint GSH_AUCTION_PRICE_VOLUME_PK primary key (AUCTION_DATE, GAS_DATE, FACILITY_ID, LIMIT_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_QUANTITIES                                */
/*==============================================================*/
create table GSH_AUCTION_QUANTITIES (
   AUCTION_DATE         datetime             not null,
   GAS_DATE             datetime             not null,
   FACILITY_ID          numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   LIMIT_ID             numeric(8,0)         not null,
   LIMIT_NAME           varchar(100)         null,
   LIMIT_TYPE           varchar(100)         not null,
   LIMIT_QUANTITY       numeric(10,0)        null,
   TRANSITIONAL_RIGHTS_QUANTITY numeric(10,0)        null,
   OPERATIONAL_OVERRIDE varchar(3)           null,
   VERSION_DATETIME     datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_QUANTITIES
   add constraint GSH_AUCTION_QUANTITIES_PK primary key (AUCTION_DATE, GAS_DATE, FACILITY_ID, LIMIT_ID, LIMIT_TYPE)
go

/*==============================================================*/
/* Table: GSH_AUCTION_RESULTS                                   */
/*==============================================================*/
create table GSH_AUCTION_RESULTS (
   AUCTION_TRANSACTION_ID numeric(12,0)        not null,
   AUCTION_DATE         datetime             null,
   FACILITY_ID          numeric(8,0)         null,
   FACILITY_NAME        varchar(100)         null,
   PARTICIPANT_ID       varchar(20)          null,
   PARTICIPANT_CODE     varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   SERVICE_REFERENCE    varchar(255)         null,
   RECEIPT_POINT_ID     numeric(8,0)         null,
   RECEIPT_POINT_NAME   varchar(255)         null,
   RP_DWGM_REFERENCE    varchar(255)         null,
   DELIVERY_POINT_ID    numeric(8,0)         null,
   DELIVERY_POINT_NAME  varchar(255)         null,
   DP_DWGM_REFERENCE    varchar(255)         null,
   AUCTION_QUANTITY_WON numeric(8,0)         null,
   GAS_DATE             datetime             null,
   PRODUCT_PRICE        numeric(18,8)        null,
   VERSION_DATETIME     datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_RESULTS
   add constraint GSH_AUCTION_RESULTS_PK primary key (AUCTION_TRANSACTION_ID)
go

/*==============================================================*/
/* Table: GSH_AUCTION_RUN                                       */
/*==============================================================*/
create table GSH_AUCTION_RUN (
   AUCTION_DATE         datetime             not null,
   GAS_DATE             datetime             not null,
   AUCTION_RUN_DATETIME datetime             not null,
   PARTICIPANT_ID       varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_AUCTION_RUN
   add constraint GSH_AUCTION_RUN_PK primary key (AUCTION_DATE, GAS_DATE, AUCTION_RUN_DATETIME, PARTICIPANT_ID)
go

/*==============================================================*/
/* Table: GSH_BENCHMARK_PRICE                                   */
/*==============================================================*/
create table GSH_BENCHMARK_PRICE (
   GAS_DATE             datetime             not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   PRODUCT_TYPE         varchar(80)          not null,
   BENCHMARK_PRICE      numeric(18,8)        null,
   IS_FIRM              varchar(1)           null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_BENCHMARK_PRICE
   add constraint GSH_BENCHMARK_PRICE_PK primary key (GAS_DATE, PRODUCT_LOCATION, PRODUCT_TYPE)
go

/*==============================================================*/
/* Table: GSH_CAPACITY_TRANSACTION                              */
/*==============================================================*/
create table GSH_CAPACITY_TRANSACTION (
   TRANSACTION_ID       varchar(50)          not null,
   VERSION_DATETIME     datetime             not null,
   TRADE_DATE           datetime             null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   TRADE_TYPE           varchar(30)          null,
   FACILITY_ID          numeric(10,0)        null,
   FACILITY_NAME        varchar(100)         null,
   TRANSPORTATION_SERVICE_TYPE varchar(12)          null,
   FLOW_DIRECTION       varchar(20)          null,
   RECEIPT_ZONE_ID      numeric(10,0)        null,
   RECEIPT_ZONE_NAME    varchar(255)         null,
   DELIVERY_ZONE_ID     numeric(10,0)        null,
   DELIVERY_ZONE_NAME   varchar(255)         null,
   PARK_LOAN_POINT_ID   numeric(10,0)        null,
   PARK_LOAN_POINT_NAME varchar(255)         null,
   STANDARD_OTSA        varchar(255)         null,
   PRIORITY             varchar(255)         null,
   MAX_DAILY_QUANTITY   numeric(10,0)        null,
   MAX_HOURLY_QUANTITY  numeric(10,0)        null,
   PRICE                numeric(18,8)        null,
   PRICE_STRUCTURE      varchar(255)         null,
   PRICE_ESCALATION_MECHANISM varchar(255)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_CAPACITY_TRANSACTION
   add constraint GSH_CAPACITY_TRANSACTION_PK primary key (TRANSACTION_ID, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_CAP_XFR_AUCTION_NOTICE                            */
/*==============================================================*/
create table GSH_CAP_XFR_AUCTION_NOTICE (
   NOTICE_ID            numeric(8,0)         not null,
   NOTICE_DATE          datetime             null,
   GAS_DATE             datetime             null,
   FACILITY_ID          numeric(8,0)         null,
   FACILITY_NAME        varchar(100)         null,
   MARKET               varchar(20)          null,
   NOTICE_TYPE          varchar(50)          null,
   DESCRIPTION          varchar(1000)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_CAP_XFR_AUCTION_NOTICE
   add constraint GSH_CAP_XFR_AUCTION_NOTICE_PK primary key (NOTICE_ID)
go

/*==============================================================*/
/* Table: GSH_CAP_XFR_NOTICE                                    */
/*==============================================================*/
create table GSH_CAP_XFR_NOTICE (
   CAPACITY_TRANSFER_ID varchar(20)          not null,
   FACILITY_ID          numeric(8,0)         null,
   FACILITY_NAME        varchar(100)         null,
   PARTICIPANT_ID       varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   SERVICE_REFERENCE    varchar(255)         null,
   STTM_CONTRACT_REFERENCE varchar(255)         null,
   RECEIPT_POINT_ID     numeric(8,0)         null,
   RECEIPT_POINT_NAME   varchar(255)         null,
   DELIVERY_POINT_ID    numeric(8,0)         null,
   DELIVERY_POINT_NAME  varchar(255)         null,
   RECEIPT_ZONE_ID      numeric(8,0)         null,
   RECEIPT_ZONE_NAME    varchar(255)         null,
   DELIVERY_ZONE_ID     numeric(8,0)         null,
   DELIVERY_ZONE_NAME   varchar(255)         null,
   GAS_DATE             datetime             null,
   INCREMENTAL_QUANTITY_CHANGE numeric(10,0)        null,
   OVERALL_QUANTITY_CHANGE numeric(10,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_CAP_XFR_NOTICE
   add constraint GSH_CAP_XFR_NOTICE_PK primary key (CAPACITY_TRANSFER_ID)
go

/*==============================================================*/
/* Table: GSH_CONTRACT_DETAILS                                  */
/*==============================================================*/
create table GSH_CONTRACT_DETAILS (
   PARTICIPANT_ID       varchar(20)          not null,
   PARTICIPANT_NAME     varchar(80)          null,
   PARTICIPANT_CODE     varchar(20)          null,
   FACILITY_ID          numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   SERVICE_REFERENCE    varchar(255)         not null,
   SERVICE_REFERENCE_DESCRIPTION varchar(255)         null,
   STTM_CONTRACT_REFERENCE varchar(255)         null,
   CONTRACT_TYPE        varchar(20)          null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_CONTRACT_DETAILS
   add constraint GSH_CONTRACT_DETAILS_PK primary key (PARTICIPANT_ID, FACILITY_ID, SERVICE_REFERENCE)
go

/*==============================================================*/
/* Table: GSH_CONTRACT_REFERENCES                               */
/*==============================================================*/
create table GSH_CONTRACT_REFERENCES (
   PARTICIPANT_CODE     varchar(20)          not null,
   PRODUCT_NAME         varchar(80)          not null,
   BUY_SELL_POSITION    varchar(4)           not null,
   FROM_GAS_DATE        datetime             not null,
   TO_GAS_DATE          datetime             not null,
   STEP_NUMBER          numeric(6,0)         not null,
   SERVICE_REFERENCE    varchar(255)         null,
   SERVICE_REFERENCE_STATUS varchar(20)          null,
   STTM_CONTRACT_REFERENCE varchar(255)         null,
   STTM_CONTRACT_REFERENCE_STATUS varchar(20)          null,
   DWGM_REFERENCE       varchar(255)         null,
   DWGM_REFERENCE_STATUS varchar(20)          null,
   STEP_QUANTITY        numeric(10,0)        null,
   VERSION_DATETIME     datetime             not null,
   LAST_UPDATED         datetime             null,
   LAST_UPDATED_BY      varchar(20)          null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_CONTRACT_REFERENCES
   add constraint GSH_CONTRACT_REFERENCES_PK primary key (PARTICIPANT_CODE, PRODUCT_NAME, BUY_SELL_POSITION, FROM_GAS_DATE, TO_GAS_DATE, STEP_NUMBER, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_DELIVERED_QUANTITY                                */
/*==============================================================*/
create table GSH_DELIVERED_QUANTITY (
   GAS_DATE             datetime             not null,
   TRANSACTION_ID       varchar(20)          not null,
   VERSION_DATETIME     datetime             not null,
   BUYER_PARTICIPANT_CODE varchar(20)          null,
   BUYER_PARTICIPANT_NAME varchar(80)          null,
   SELLER_PARTICIPANT_CODE varchar(20)          null,
   SELLER_PARTICIPANT_NAME varchar(80)          null,
   PRODUCT_LOCATION     varchar(80)          null,
   TRANSACTION_QUANTITY numeric(18,8)        null,
   SETTLEMENTS_OFF_MARKET varchar(1)           null,
   DELIVERED_QUANTITY   numeric(18,8)        null,
   REASON_FOR_VARIATION varchar(80)          null,
   STATUS               varchar(20)          null,
   LAST_UPDATED_BY_PARTICIPANT varchar(20)          null,
   LAST_UPDATED         datetime             null,
   LASTCHANGED          datetime             null,
   ETS_TRADE_ID         varchar(20)          null
)
go

alter table GSH_DELIVERED_QUANTITY
   add constraint GSH_DELIVERED_QUANTITY_PK primary key (GAS_DATE, TRANSACTION_ID, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_DELIVERY_NETT_POINTS                              */
/*==============================================================*/
create table GSH_DELIVERY_NETT_POINTS (
   MARKET_ID            varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   VERSION_DATETIME     datetime             not null,
   POSITION_TYPE        varchar(20)          not null,
   PRIORITY             numeric(3,0)         not null,
   DELIVERY_POINT       varchar(40)          null,
   VOLUME               numeric(18,8)        null,
   LAST_UPDATED         datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_DELIVERY_NETT_POINTS
   add constraint GSH_DELIVERY_NETT_POINTS_PK primary key (MARKET_ID, PARTICIPANT_CODE, PRODUCT_LOCATION, VERSION_DATETIME, POSITION_TYPE, PRIORITY)
go

/*==============================================================*/
/* Table: GSH_DELIVERY_NETT_PREFS                               */
/*==============================================================*/
create table GSH_DELIVERY_NETT_PREFS (
   MARKET_ID            varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   VERSION_DATETIME     datetime             not null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   CHOSEN_POSITION      varchar(20)          null,
   USE_TRANSACTIONS     varchar(1)           null,
   USE_GROUPS           varchar(1)           null,
   LAST_UPDATED         datetime             null,
   LAST_UPDATED_BY      varchar(20)          null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_DELIVERY_NETT_PREFS
   add constraint GSH_DELIVERY_NETT_PREFS_PK primary key (MARKET_ID, PARTICIPANT_CODE, PRODUCT_LOCATION, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_DELIVERY_OBLIGATIONS                              */
/*==============================================================*/
create table GSH_DELIVERY_OBLIGATIONS (
   NETTING_TRANSACTION_ID varchar(20)          not null,
   BUYER_PARTICIPANT_CODE varchar(20)          null,
   BUYER_PARTICIPANT_NAME varchar(80)          null,
   SELLER_PARTICIPANT_CODE varchar(20)          null,
   SELLER_PARTICIPANT_NAME varchar(80)          null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   PRODUCT_LOCATION     varchar(80)          null,
   DELIVERY_QUANTITY    numeric(18,8)        null,
   DELIVERY_POINT       varchar(40)          null,
   DELIVERY_TYPE_ALERT  varchar(20)          null,
   LASTCHANGED          datetime             null,
   ETS_TRADE_ID         varchar(20)          null,
   RECEIPT_POINT        varchar(40)          null
)
go

alter table GSH_DELIVERY_OBLIGATIONS
   add constraint GSH_DELIVERY_OBLIGATION_PK primary key (NETTING_TRANSACTION_ID)
go

/*==============================================================*/
/* Table: GSH_FACILITIES                                        */
/*==============================================================*/
create table GSH_FACILITIES (
   FACILITY_ID          numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   FACILITY_NAME        varchar(100)         null,
   FACILITY_DESCRIPTION varchar(400)         null,
   FACILITY_TYPE        varchar(20)          null,
   OPERATOR_ID          varchar(20)          null,
   OPERATOR_NAME        varchar(100)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_FACILITIES
   add constraint GSH_FACILITIES_PK primary key (FACILITY_ID, EFFECTIVEDATE, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_HISTORICAL_SUMMARY                                */
/*==============================================================*/
create table GSH_HISTORICAL_SUMMARY (
   GAS_DATE             datetime             not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   VOLUME_WEIGHTED_AVERAGE_PRICE numeric(18,8)        null,
   TOTAL_QUANTITY       numeric(18,8)        null,
   ROLLING_WEIGHTED_AVERAGE_PRICE numeric(18,8)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_HISTORICAL_SUMMARY
   add constraint GSH_HISTORICAL_SUMMARY_PK primary key (GAS_DATE, PRODUCT_LOCATION)
go

/*==============================================================*/
/* Table: GSH_NOTIONAL_POINTS                                   */
/*==============================================================*/
create table GSH_NOTIONAL_POINTS (
   FACILITY_ID          numeric(8,0)         not null,
   SERVICE_POINT_ID     numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   SERVICE_POINT_NAME   varchar(100)         null,
   PHYSICAL_POINT_NAME  varchar(100)         not null,
   GBB_CONNECTION_POINT_ID numeric(8,0)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_NOTIONAL_POINTS
   add constraint GSH_NOTIONAL_POINTS_PK primary key (FACILITY_ID, EFFECTIVEDATE, VERSION_DATETIME, SERVICE_POINT_ID, PHYSICAL_POINT_NAME)
go

/*==============================================================*/
/* Table: GSH_ORDERS                                            */
/*==============================================================*/
create table GSH_ORDERS (
   MARKET_ID            varchar(20)          not null,
   ORDER_ID             varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   PRODUCT_LOCATION     varchar(80)          null,
   PRODUCT_TYPE         varchar(80)          null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   ORDER_DATE           datetime             null,
   ORDER_STATUS         varchar(20)          null,
   ORDER_SIDE           varchar(5)           null,
   ORDER_QUANTITY       numeric(18,8)        null,
   ORDER_PRICE          numeric(18,8)        null,
   EXPIRY_TYPE          varchar(80)          null,
   EXPIRY_DATE          datetime             null,
   DELIVERY_POINT       varchar(40)          null,
   LAST_UPDATED         datetime             null,
   LAST_UPDATED_BY      varchar(20)          null,
   LASTCHANGED          datetime             null,
   ALL_OR_NONE          numeric(1,0)         null,
   DURATION             varchar(20)          null,
   HIDDEN_VOLUME        numeric(18,8)        null,
   RECEIPT_POINT        varchar(40)          null,
   VALID_SERVICE_REFERENCE varchar(3)           null,
   VALID_STTM_CONTRACT_REFERENCE varchar(3)           null,
   VALID_DWGM_REFERENCE varchar(3)           null
)
go

alter table GSH_ORDERS
   add constraint GSH_ORDERS_PK primary key (MARKET_ID, ORDER_ID)
go

/*==============================================================*/
/* Table: GSH_PARK_SERVICES                                     */
/*==============================================================*/
create table GSH_PARK_SERVICES (
   FACILITY_ID          numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   PARK_PRODUCT_NAME    varchar(100)         not null,
   PARK_SERVICE_POINT_ID numeric(8,0)         null,
   PARK_SERVICE_POINT_NAME varchar(100)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_PARK_SERVICES
   add constraint GSH_PARK_SERVICES_PK primary key (FACILITY_ID, EFFECTIVEDATE, VERSION_DATETIME, PARK_PRODUCT_NAME)
go

/*==============================================================*/
/* Table: GSH_PARTICIPANTS                                      */
/*==============================================================*/
create table GSH_PARTICIPANTS (
   PARTICIPANT_ID       varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   ORGANISATION_NAME    varchar(80)          null,
   ORGANISATION_CODE    varchar(20)          null,
   TRADING_NAME         varchar(80)          null,
   HEAD_OFFICE_ADDRESS_LINE_1 varchar(80)          null,
   HEAD_OFFICE_ADDRESS_LINE_2 varchar(80)          null,
   HEAD_OFFICE_ADDRESS_LINE_3 varchar(80)          null,
   HEAD_OFFICE_ADDRESS_LINE_4 varchar(80)          null,
   PHONE_NUMBER         varchar(80)          null,
   FAX_NUMBER           varchar(80)          null,
   ABN                  varchar(20)          null,
   ARBN                 varchar(20)          null,
   ACN                  varchar(20)          null,
   CLASSIFICATIONS      varchar(255)         null,
   LASTCHANGED          datetime             null,
   MARKET_ID            varchar(20)          not null default 'Gas Supply Hub',
   AGENT_ID             varchar(20)          null,
   AGENT_NAME           varchar(80)          null
)
go

alter table GSH_PARTICIPANTS
   add constraint GSH_PARTICIPANTS_PK primary key (MARKET_ID, PARTICIPANT_ID)
go

/*==============================================================*/
/* Table: GSH_PARTICIPANT_CONTACTS                              */
/*==============================================================*/
create table GSH_PARTICIPANT_CONTACTS (
   CONTACT_ID           varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   ROLE                 varchar(80)          null,
   FIRST_NAME           varchar(80)          null,
   LAST_NAME            varchar(80)          null,
   SALUTATION           varchar(20)          null,
   JOB_TITLE            varchar(80)          null,
   ADDRESS_LINE_1       varchar(80)          null,
   ADDRESS_LINE_2       varchar(80)          null,
   ADDRESS_LINE_3       varchar(80)          null,
   ADDRESS_LINE_4       varchar(80)          null,
   BUSINESS_PHONE_NUMBER varchar(80)          null,
   MOBILE_NUMBER        varchar(80)          null,
   FAX_NUMBER           varchar(80)          null,
   EMAIL_ADDRESS        varchar(255)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_PARTICIPANT_CONTACTS
   add constraint GSH_PARTICIPANT_CONTACTS_PK primary key (CONTACT_ID)
go

/*==============================================================*/
/* Table: GSH_PARTICIPANT_OPSTATE                               */
/*==============================================================*/
create table GSH_PARTICIPANT_OPSTATE (
   MARKET_ID            varchar(20)          not null,
   PARTICIPANT_ID       varchar(20)          not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   STATUS               varchar(30)          null,
   AUTHORISEDDATE       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_PARTICIPANT_OPSTATE
   add constraint GSH_PARTICIPANT_OPSTATE_PK primary key (MARKET_ID, PARTICIPANT_ID, EFFECTIVEDATE, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_PIPELINE_SEGMENTS                                 */
/*==============================================================*/
create table GSH_PIPELINE_SEGMENTS (
   FACILITY_ID          numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   SEGMENT_ID           numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   SEGMENT_NAME         varchar(100)         null,
   SEGMENT_TYPE         varchar(20)          null,
   FROM_ID              numeric(8,0)         not null,
   FROM_NAME            varchar(100)         null,
   TO_ID                numeric(8,0)         not null,
   TO_NAME              varchar(100)         null,
   CONNECTION_TYPE      varchar(20)          not null,
   FOR_AUCTION_PUBLICATION varchar(3)           null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_PIPELINE_SEGMENTS
   add constraint GSH_PIPELINE_SEGMENTS_PK primary key (FACILITY_ID, EFFECTIVEDATE, VERSION_DATETIME, SEGMENT_ID, CONNECTION_TYPE, FROM_ID, TO_ID)
go

/*==============================================================*/
/* Table: GSH_PRD_AUCT_FWD_EXPOSURE                             */
/*==============================================================*/
create table GSH_PRD_AUCT_FWD_EXPOSURE (
   MARKET_ID            varchar(20)          null,
   ORGANISATION_CODE    varchar(20)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   GAS_DATE             datetime             not null,
   BIDS_FORWARD_EXP_AMT_NET_GST numeric(18,8)        null,
   BIDS_FORWARD_EXP_GST_AMT numeric(18,8)        null,
   BID_QUANTITY         numeric(18,8)        null
)
go

alter table GSH_PRD_AUCT_FWD_EXPOSURE
   add constraint GSH_PRD_AUCT_FWD_EXPOSURE_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, GAS_DATE)
go

/*==============================================================*/
/* Table: GSH_PRD_BANK_GUARANTEES                               */
/*==============================================================*/
create table GSH_PRD_BANK_GUARANTEES (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   BANK_GUARANTEE_NO    varchar(20)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   EFFECTIVE_FROM_DATE  datetime             null,
   EXPIRY_DATE          datetime             null,
   PRUDENTIAL_EXPIRY_DATE datetime             null,
   AMOUNT               numeric(18,8)        null,
   BANK_GUARANTEE_ALERT varchar(255)         null
)
go

alter table GSH_PRD_BANK_GUARANTEES
   add constraint GSH_PRD_BANK_GUARANTEES_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, BANK_GUARANTEE_NO)
go

/*==============================================================*/
/* Table: GSH_PRD_EST_MARKET_EXPOSURE                           */
/*==============================================================*/
create table GSH_PRD_EST_MARKET_EXPOSURE (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   ORGANISATION_NAME    varchar(80)          null,
   TOTAL_BANK_GUARANTEES numeric(18,8)        null,
   TRADING_LIMIT        numeric(18,8)        null,
   SECURITY_DEPOSITS    numeric(18,8)        null,
   EARLY_PAYMENTS       numeric(18,8)        null,
   OUTSTANDING_AMOUNT   numeric(18,8)        null,
   REALLOC_ADJ_AMT_TO_OUTSTANDING numeric(18,8)        null,
   SETTLEMENT_EXPOSURE_AMOUNT numeric(18,8)        null,
   TRADES_FORWARD_EXPOSURE_AMOUNT numeric(18,8)        null,
   FORWARD_REALLOCATIONS_AMOUNT numeric(18,8)        null,
   FORWARD_EXPOSURE_AMOUNT numeric(18,8)        null,
   PRUDENTIAL_EXPOSURE  numeric(18,8)        null,
   PERCENTAGE_EXPOSURE  numeric(18,8)        null,
   TRADING_MARGIN       numeric(18,8)        null,
   BANK_GUARANTEE_RATIO numeric(18,8)        null,
   EXPOSURE_NOTIFICATION varchar(80)          null,
   LASTCHANGED          datetime             null,
   DAA_SETTLEMENT_EXPOSURE_AMOUNT numeric(18,8)        null,
   DAA_FORWARD_EXPOSURE_AMOUNT numeric(18,8)        null
)
go

alter table GSH_PRD_EST_MARKET_EXPOSURE
   add constraint GSH_PRD_EST_MARKET_EXPOSURE_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME)
go

/*==============================================================*/
/* Table: GSH_PRD_REALLOCATIONS                                 */
/*==============================================================*/
create table GSH_PRD_REALLOCATIONS (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   REALLOCATION_ID      varchar(20)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   REALLOCATION_ROLE    varchar(80)          null,
   COUNTERPARTY_PARTICIPANT_CODE varchar(20)          null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   AGREEMENT_TYPE       varchar(80)          null,
   REALLOC_ADJ_AMT_TO_OUTSTANDING numeric(18,8)        null,
   FORWARD_REALLOCATION_AMOUNT numeric(18,8)        null
)
go

alter table GSH_PRD_REALLOCATIONS
   add constraint GSH_PRD_REALLOCATIONS_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, PARTICIPANT_CODE, REALLOCATION_ID)
go

/*==============================================================*/
/* Table: GSH_PRD_SECURITY_DEPOSITS                             */
/*==============================================================*/
create table GSH_PRD_SECURITY_DEPOSITS (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   SECURITY_DEPOSIT_ID  varchar(20)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   EFFECTIVE_FROM_DATE  datetime             null,
   MATURITY_DATE        datetime             null,
   TOTAL_SECURITY_DEPOSIT_AMOUNT numeric(18,8)        null,
   NON_APPLIED_SEC_DEPOSIT_AMT numeric(18,8)        null,
   INTEREST_ACCT_ID     varchar(20)          null,
   INTEREST_CALC_TYPE   varchar(20)          null
)
go

alter table GSH_PRD_SECURITY_DEPOSITS
   add constraint GSH_PRD_SECURITY_DEPOSITS_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, PARTICIPANT_CODE, SECURITY_DEPOSIT_ID)
go

/*==============================================================*/
/* Table: GSH_PRD_SETTLEMENT_AMOUNTS                            */
/*==============================================================*/
create table GSH_PRD_SETTLEMENT_AMOUNTS (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   SETTLEMENT_TYPE      varchar(20)          null,
   SETTLEMENT_VERSION_ID numeric(18,0)        null,
   SETTLEMENT_EXPOSURE_AMOUNT numeric(18,8)        null,
   PUBLICATION_DATE     datetime             null,
   PAYMENT_DUE_DATE     datetime             null
)
go

alter table GSH_PRD_SETTLEMENT_AMOUNTS
   add constraint GSH_PRD_SETTLEMENT_AMOUNTS_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, PARTICIPANT_CODE, BILLING_PERIOD)
go

/*==============================================================*/
/* Table: GSH_PRD_TRADE_FWD_EXPOSURE                            */
/*==============================================================*/
create table GSH_PRD_TRADE_FWD_EXPOSURE (
   ORGANISATION_CODE    varchar(20)          not null,
   PRUDENTIAL_RUN_ID    numeric(4,0)         not null,
   PRUDENTIAL_DATETIME  datetime             not null,
   GAS_DATE             datetime             not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   ORGANISATION_NAME    varchar(80)          null,
   TRADES_FORWARD_EXP_AMT_NET_GST numeric(18,8)        null,
   TRADES_FORWARD_EXP_GST_AMT numeric(18,8)        null,
   BUY_ORDER_QUANTITY   numeric(18,8)        null,
   BUY_TRADE_QUANTITY   numeric(18,8)        null,
   SELL_ORDER_QUANTITY  numeric(18,8)        null,
   SELL_TRADE_QUANTITY  numeric(18,8)        null,
   BUY_LOAD_WEIGHTED_AVG_PRICE numeric(18,8)        null,
   SELL_LOAD_WEIGHTED_AVG_PRICE numeric(18,8)        null
)
go

alter table GSH_PRD_TRADE_FWD_EXPOSURE
   add constraint GSH_PRD_TRADE_FWD_EXPOSURE_PK primary key (ORGANISATION_CODE, PRUDENTIAL_RUN_ID, PRUDENTIAL_DATETIME, GAS_DATE, PRODUCT_LOCATION)
go

/*==============================================================*/
/* Table: GSH_RCPT_DELIV_POINT_PREFS                            */
/*==============================================================*/
create table GSH_RCPT_DELIV_POINT_PREFS (
   PARTICIPANT_CODE     varchar(20)          not null,
   PRODUCT_NAME         varchar(80)          not null,
   BUY_SELL_POSITION    varchar(4)           not null,
   STEP_NUMBER          numeric(6)           not null,
   VERSION_DATETIME     datetime             not null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   OVERRIDE_FLAG        varchar(3)           null,
   PRODUCT_RECEIPT_POINT varchar(40)          null,
   RECEIPT_POINT_ID     numeric(8,0)         null,
   RECEIPT_POINT_NAME   varchar(255)         null,
   PRODUCT_DELIVERY_POINT varchar(40)          null,
   DELIVERY_POINT_ID    numeric(8,0)         null,
   DELIVERY_POINT_NAME  varchar(255)         null,
   STEP_QUANTITY        numeric(10,0)        null,
   LAST_UPDATED         datetime             null,
   LAST_UPDATED_BY      varchar(20)          null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_RCPT_DELIV_POINT_PREFS
   add constraint GSH_RCPT_DELIV_POINT_PREFS_PK primary key (PARTICIPANT_CODE, PRODUCT_NAME, BUY_SELL_POSITION, STEP_NUMBER, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_REALLOC_DAILY_AMOUNT                              */
/*==============================================================*/
create table GSH_REALLOC_DAILY_AMOUNT (
   REALLOCATION_ID      varchar(20)          not null,
   GAS_DATE             datetime             not null,
   AMOUNT               numeric(18,8)        null
)
go

alter table GSH_REALLOC_DAILY_AMOUNT
   add constraint GSH_REALLOC_DAILY_AMOUNT_PK primary key (REALLOCATION_ID, GAS_DATE)
go

/*==============================================================*/
/* Table: GSH_REALLOC_REALLOCATION                              */
/*==============================================================*/
create table GSH_REALLOC_REALLOCATION (
   REALLOCATION_ID      varchar(20)          not null,
   DEBIT_PARTICIPANT_CODE varchar(20)          null,
   DEBIT_PARTICIPANT_NAME varchar(80)          null,
   DEBIT_PARTICIPANT_REFERENCE varchar(80)          null,
   CREDIT_PARTICIPANT_CODE varchar(20)          null,
   CREDIT_PARTICIPANT_NAME varchar(80)          null,
   CREDIT_PARTICIPANT_REFERENCE varchar(80)          null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   AGREEMENT_TYPE       varchar(80)          null,
   PRODUCT_LOCATION     varchar(80)          null,
   REALLOCATION_STATUS  varchar(80)          null,
   REASON               varchar(255)         null,
   LAST_UPDATED         datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_REALLOC_REALLOCATION
   add constraint GSH_RALLOC_REALLOCATION_PK primary key (REALLOCATION_ID)
go

/*==============================================================*/
/* Table: GSH_REVISED_AUCT_QUANTITIES                           */
/*==============================================================*/
create table GSH_REVISED_AUCT_QUANTITIES (
   AUCTION_DATE         datetime             not null,
   GAS_DATE             datetime             not null,
   FACILITY_ID          numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   SERVICE_TYPE         varchar(20)          not null,
   AGG_CLEARED_QUANTITY numeric(10,0)        null,
   AGG_REVISED_QUANTITY numeric(10,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_REVISED_AUCT_QUANTITIES
   add constraint GSH_REVISED_AUCT_QUANTITIES_PK primary key (AUCTION_DATE, GAS_DATE, FACILITY_ID, SERVICE_TYPE)
go

/*==============================================================*/
/* Table: GSH_SECDEPOSIT_INTEREST_RATE                          */
/*==============================================================*/
create table GSH_SECDEPOSIT_INTEREST_RATE (
   INTEREST_ACCT_ID     varchar(20)          not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   INTEREST_RATE        numeric(18,8)        null
)
go

alter table GSH_SECDEPOSIT_INTEREST_RATE
   add constraint GSH_SECDEP_INTEREST_RATE_PK primary key (INTEREST_ACCT_ID, EFFECTIVEDATE, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_SERVICE_POINTS                                    */
/*==============================================================*/
create table GSH_SERVICE_POINTS (
   FACILITY_ID          numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   SERVICE_POINT_ID     numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   SERVICE_POINT_NAME   varchar(100)         null,
   SERVICE_POINT_TYPE   varchar(100)         not null,
   SERVICE_POINT_DESCRIPTION varchar(255)         null,
   AUCTION_PRODUCT_TYPE varchar(20)          not null,
   NOTIONAL_POINT       varchar(3)           null,
   ZONE_ID              numeric(8,0)         null,
   ZONE_NAME            varchar(100)         null,
   GBB_CONNECTION_POINT_ID numeric(8,0)         null,
   GBB_CONNECTION_POINT_NAME varchar(100)         null,
   FOR_AUCTION_PUBLICATION varchar(3)           null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_SERVICE_POINTS
   add constraint GSH_SERVICE_POINTS_PK primary key (FACILITY_ID, EFFECTIVEDATE, VERSION_DATETIME, SERVICE_POINT_ID, SERVICE_POINT_TYPE, AUCTION_PRODUCT_TYPE)
go

/*==============================================================*/
/* Table: GSH_SHIPPER_CAP_XFR_NOTICE                            */
/*==============================================================*/
create table GSH_SHIPPER_CAP_XFR_NOTICE (
   CAPACITY_TRANSFER_ID varchar(20)          not null,
   GAS_DATE             datetime             null,
   PARTICIPANT_CODE     varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   FACILITY_ID          numeric(8,0)         null,
   FACILITY_NAME        varchar(100)         null,
   SERVICE_REFERENCE    varchar(255)         null,
   STTM_CONTRACT_REFERENCE varchar(255)         null,
   DWGM_REFERENCE       varchar(255)         null,
   RECEIPT_POINT_ID     numeric(8,0)         null,
   RECEIPT_POINT_NAME   varchar(255)         null,
   DELIVERY_POINT_ID    numeric(8,0)         null,
   DELIVERY_POINT_NAME  varchar(255)         null,
   RECEIPT_ZONE_ID      numeric(8,0)         null,
   RECEIPT_ZONE_NAME    varchar(255)         null,
   DELIVERY_ZONE_ID     numeric(8,0)         null,
   DELIVERY_ZONE_NAME   varchar(255)         null,
   STATUS               varchar(20)          null,
   SYSTEM               varchar(20)          null,
   REASON               varchar(40)          null,
   TRANSACTION_COMPLETED_FLAG varchar(3)           null,
   OVERALL_QUANTITY_CHANGE numeric(10,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_SHIPPER_CAP_XFR_NOTICE
   add constraint GSH_SHIPPER_CAP_XFR_NOTICE_PK primary key (CAPACITY_TRANSFER_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_ADHOC                                        */
/*==============================================================*/
create table GSH_SUPP_ADHOC (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null,
   ADHOC_DESCRIPTION    varchar(255)         null
)
go

alter table GSH_SUPP_ADHOC
   add constraint GSH_SUPP_ADHOC_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_AUCTION_QUANTITIES                           */
/*==============================================================*/
create table GSH_SUPP_AUCTION_QUANTITIES (
   MARKET_ID            varchar(20)          null,
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             null,
   AUCTION_TRANSACTION_ID numeric(12,0)        not null,
   AUCTION_QUANTITY     numeric(10,0)        null,
   REVISED_AUCTION_QUANTITY numeric(10,0)        null,
   PRODUCT_PRICE        numeric(18,8)        null
)
go

alter table GSH_SUPP_AUCTION_QUANTITIES
   add constraint GSH_SUPP_AUCTION_QUANTITIES_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, AUCTION_TRANSACTION_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_CAPACITY_AUCTION                             */
/*==============================================================*/
create table GSH_SUPP_CAPACITY_AUCTION (
   MARKET_ID            varchar(20)          null,
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_CAPACITY_AUCTION
   add constraint GSH_SUPP_CAPACITY_AUCTION_PK primary key (SETTLEMENT_RUN_ID, GAS_DATE, PARTICIPANT_CODE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_CAPACITY_TRANSFERS                           */
/*==============================================================*/
create table GSH_SUPP_CAPACITY_TRANSFERS (
   MARKET_ID            varchar(20)          null,
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   PARTICIPANT_CODE     varchar(20)          null,
   GAS_DATE             datetime             null,
   CAPACITY_TRANSFER_ID varchar(20)          not null,
   TRADE_SIDE           varchar(20)          null,
   CAPACITY_QUANTITY    numeric(18,8)        null,
   CONFIRMED_CAPACITY_QUANTITY numeric(18,8)        null,
   INVALID_QUANTITY     numeric(18,8)        null
)
go

alter table GSH_SUPP_CAPACITY_TRANSFERS
   add constraint GSH_SUPP_CAPACITY_TRANSFERS_PK primary key (SETTLEMENT_RUN_ID, CAPACITY_TRANSFER_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_CAPACITY_VARIANCE                            */
/*==============================================================*/
create table GSH_SUPP_CAPACITY_VARIANCE (
   MARKET_ID            varchar(20)          null,
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_CAPACITY_VARIANCE
   add constraint GSH_SUPP_CAPACITY_VARIANCE_PK primary key (SETTLEMENT_RUN_ID, GAS_DATE, PARTICIPANT_CODE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_DELIVERED_QUANTITY                           */
/*==============================================================*/
create table GSH_SUPP_DELIVERED_QUANTITY (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TRADE_ID             varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   TRADE_SIDE           varchar(20)          null,
   TRADE_QUANTITY       numeric(18,8)        null,
   DELIVERED_QUANTITY   numeric(18,8)        null
)
go

alter table GSH_SUPP_DELIVERED_QUANTITY
   add constraint GSH_SUPP_DELIVERED_QUANTITY_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, TRADE_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_DELIVERY_VARIANCE                            */
/*==============================================================*/
create table GSH_SUPP_DELIVERY_VARIANCE (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_DELIVERY_VARIANCE
   add constraint GSH_SUPP_DELIVERY_VARIANCE_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_EXECUTED_TRADES                              */
/*==============================================================*/
create table GSH_SUPP_EXECUTED_TRADES (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   TRADE_ID             varchar(20)          not null,
   GAS_DATE             datetime             not null,
   BILLING_PERIOD       varchar(20)          null,
   TRADE_SIDE           varchar(20)          null,
   TRADE_QUANTITY       numeric(18,8)        null,
   TRADE_PRICE          numeric(18,8)        null
)
go

alter table GSH_SUPP_EXECUTED_TRADES
   add constraint GSH_SUPP_EXECUTED_TRADES_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, TRADE_ID, GAS_DATE)
go

/*==============================================================*/
/* Table: GSH_SUPP_FEE                                          */
/*==============================================================*/
create table GSH_SUPP_FEE (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   FEE_TYPE             varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_FEE
   add constraint GSH_SUPP_FEE_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, FEE_TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_PHYSICAL_GAS                                 */
/*==============================================================*/
create table GSH_SUPP_PHYSICAL_GAS (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_PHYSICAL_GAS
   add constraint GSH_SUPP_PHYSICAL_GAS_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_REALLOCATIONS                                */
/*==============================================================*/
create table GSH_SUPP_REALLOCATIONS (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   REALLOCATION_ID      varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   REALLOCATION_SIDE    varchar(20)          null,
   AGREEMENT_TYPE       varchar(80)          null,
   REFERENCE_PRICE      numeric(18,8)        null,
   AMOUNT               numeric(18,8)        null
)
go

alter table GSH_SUPP_REALLOCATIONS
   add constraint GSH_SUPP_REALLOCATIONS_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, GAS_DATE, REALLOCATION_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_SERVICES                                     */
/*==============================================================*/
create table GSH_SUPP_SERVICES (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   GAS_DATE             datetime             not null,
   TYPE                 varchar(20)          not null,
   BILLING_PERIOD       varchar(20)          null,
   AMOUNT               numeric(18,8)        null,
   GST_AMOUNT           numeric(18,8)        null
)
go

alter table GSH_SUPP_SERVICES
   add constraint GSH_SUPP_SERVICES_PK primary key (GAS_DATE, SETTLEMENT_RUN_ID, PARTICIPANT_CODE, TYPE)
go

/*==============================================================*/
/* Table: GSH_SUPP_SETTLEMENT_RUN                               */
/*==============================================================*/
create table GSH_SUPP_SETTLEMENT_RUN (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   SETTLEMENT_RUN_TYPE  varchar(20)          null,
   START_GAS_DATE       datetime             null,
   END_GAS_DATE         datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_SUPP_SETTLEMENT_RUN
   add constraint GSH_SUP_DAT_SETTLEMENT_RUN_PK primary key (SETTLEMENT_RUN_ID)
go

/*==============================================================*/
/* Table: GSH_SUPP_SETTLEMENT_SUMMARY                           */
/*==============================================================*/
create table GSH_SUPP_SETTLEMENT_SUMMARY (
   SETTLEMENT_RUN_ID    numeric(18,0)        not null,
   PARTICIPANT_CODE     varchar(20)          not null,
   REVISION_SETTLEMENT_RUN_ID numeric(18,0)        not null,
   BILLING_PERIOD       varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   NET_SETTLEMENT_AMOUNT numeric(18,8)        null,
   NET_SETTLEMENT_AMOUNT_GST numeric(18,8)        null,
   TOTAL_REALLOCATION_DEBIT_AMT numeric(18,8)        null,
   TOTAL_REALLOCATION_CREDIT_AMT numeric(18,8)        null,
   TOTAL_SECURITY_DEPOSITS numeric(18,8)        null,
   SECURITY_DEPOSIT_INTEREST numeric(18,8)        null,
   SETTLEMENT_ADJUSTMENT_AMOUNT numeric(18,8)        null,
   INTEREST_ON_REVISION numeric(18,8)        null,
   TOTAL_PAYABLE_AMOUNT numeric(18,8)        null
)
go

alter table GSH_SUPP_SETTLEMENT_SUMMARY
   add constraint GSH_SUPP_SETTLEMENT_SUMMARY_PK primary key (SETTLEMENT_RUN_ID, PARTICIPANT_CODE, REVISION_SETTLEMENT_RUN_ID)
go

/*==============================================================*/
/* Table: GSH_TRADES                                            */
/*==============================================================*/
create table GSH_TRADES (
   MARKET_ID            varchar(20)          not null,
   TRADE_ID             varchar(20)          not null,
   BUYER_PARTICIPANT_CODE varchar(20)          null,
   BUYER_PARTICIPANT_NAME varchar(80)          null,
   SELLER_PARTICIPANT_CODE varchar(20)          null,
   SELLER_PARTICIPANT_NAME varchar(80)          null,
   FROM_GAS_DATE        datetime             null,
   TO_GAS_DATE          datetime             null,
   TRADE_DATETIME       datetime             null,
   TRADE_TYPE           varchar(20)          null,
   PRODUCT_LOCATION     varchar(80)          null,
   PRODUCT_TYPE         varchar(80)          null,
   TRADE_QUANTITY       numeric(18,8)        null,
   TRADE_PRICE          numeric(18,8)        null,
   DELIVERY_POINT       varchar(40)          null,
   ORDER_ID             varchar(20)          null,
   LAST_UPDATED         datetime             null,
   LASTCHANGED          datetime             null,
   BUYER_USER_NAME      varchar(100)         null,
   SELLER_USER_NAME     varchar(100)         null,
   RELATIONSHIP_ID      varchar(20)          null,
   RECEIPT_POINT        varchar(40)          null,
   VALID_SERVICE_REFERENCE varchar(3)           null,
   VALID_STTM_CONTRACT_REFERENCE varchar(3)           null,
   VALID_DWGM_REFERENCE varchar(3)           null,
   TRADE_STATUS         varchar(20)          null,
   GAS_FUTURE_ID        varchar(20)          null
)
go

alter table GSH_TRADES
   add constraint GSH_TRADES_PK primary key (MARKET_ID, TRADE_ID)
go

/*==============================================================*/
/* Table: GSH_TRADES_STAGING                                    */
/*==============================================================*/
create table GSH_TRADES_STAGING (
   RECORD_ID            varchar(20)          not null,
   MARKET_ID            varchar(20)          null,
   PARTICIPANT_ID       varchar(20)          null,
   GAS_FUTURE_ID        varchar(20)          null,
   PRODUCT_GROUP_CODE   varchar(20)          null,
   PRODUCT_TYPE_CODE    varchar(20)          null,
   DELIVERY_POINT       varchar(40)          null,
   START_DATE           datetime             null,
   END_DATE             datetime             null,
   TRADE_TYPE           varchar(20)          null,
   VOLUME               numeric(18,8)        null,
   PRICE                numeric(18,8)        null,
   STATUS               varchar(20)          null,
   VALIDATION_MSG       varchar(255)         null,
   SUBMITTED_TIME       datetime             null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_TRADES_STAGING
   add constraint GSH_TRADES_STAGING_PK primary key (RECORD_ID)
go

/*==============================================================*/
/* Table: GSH_TRADING_CONTACTS                                  */
/*==============================================================*/
create table GSH_TRADING_CONTACTS (
   CONTACT_ID           varchar(20)          not null,
   PARTICIPANT_CODE     varchar(20)          null,
   PARTICIPANT_NAME     varchar(80)          null,
   ROLE                 varchar(80)          null,
   FIRST_NAME           varchar(80)          null,
   LAST_NAME            varchar(80)          null,
   SALUTATION           varchar(20)          null,
   JOB_TITLE            varchar(80)          null,
   ADDRESS_LINE_1       varchar(80)          null,
   ADDRESS_LINE_2       varchar(80)          null,
   ADDRESS_LINE_3       varchar(80)          null,
   ADDRESS_LINE_4       varchar(80)          null,
   BUSINESS_PHONE_NUMBER varchar(80)          null,
   MOBILE_NUMBER        varchar(80)          null,
   FAX_NUMBER           varchar(80)          null,
   EMAIL_ADDRESS        varchar(255)         null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_TRADING_CONTACTS
   add constraint GSH_TRADING_CONTACTS_PK primary key (CONTACT_ID)
go

/*==============================================================*/
/* Table: GSH_TRANSACTION_SUMMARY                               */
/*==============================================================*/
create table GSH_TRANSACTION_SUMMARY (
   CURRENTDATE          datetime             not null,
   PRODUCT_LOCATION     varchar(80)          not null,
   PRODUCT_TYPE         varchar(80)          not null,
   FROM_GAS_DATE        datetime             not null,
   TO_GAS_DATE          datetime             not null,
   HIGH_PRICE           numeric(18,8)        null,
   LOW_PRICE            numeric(18,8)        null,
   OPEN_PRICE           numeric(18,8)        null,
   CLOSE_PRICE          numeric(18,8)        null,
   VOLUME_WEIGHTED_AVERAGE_PRICE numeric(18,8)        null,
   TOTAL_QUANTITY       numeric(18,8)        null,
   TOTAL_NUMBER_OF_TRADES numeric(18,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_TRANSACTION_SUMMARY
   add constraint GSH_TRANSACTION_SUMMARY_PK primary key (CURRENTDATE, PRODUCT_LOCATION, PRODUCT_TYPE, FROM_GAS_DATE, TO_GAS_DATE)
go

/*==============================================================*/
/* Table: GSH_ZONES                                             */
/*==============================================================*/
create table GSH_ZONES (
   ZONE_ID              numeric(8,0)         not null,
   EFFECTIVEDATE        datetime             not null,
   VERSION_DATETIME     datetime             not null,
   ZONE_NAME            varchar(100)         null,
   ZONE_TYPE            varchar(20)          null,
   ZONE_DESCRIPTION     varchar(400)         null,
   FOR_AUCTION_PUBLICATION varchar(3)           null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_ZONES
   add constraint GSH_ZONES_PK primary key (ZONE_ID, EFFECTIVEDATE, VERSION_DATETIME)
go

/*==============================================================*/
/* Table: GSH_ZONE_CURTAILMENT                                  */
/*==============================================================*/
create table GSH_ZONE_CURTAILMENT (
   FACILITY_ID          numeric(8,0)         not null,
   FACILITY_NAME        varchar(100)         null,
   SERVICE_POINT_ID     numeric(8,0)         not null,
   SERVICE_POINT_NAME   varchar(100)         null,
   SERVICE_POINT_TYPE   varchar(100)         null,
   SERVICE_POINT_DESCRIPTION varchar(255)         null,
   GAS_DATE             datetime             not null,
   CURTAILED_QUANTITY   numeric(10,0)        null,
   LASTCHANGED          datetime             null
)
go

alter table GSH_ZONE_CURTAILMENT
   add constraint GSH_ZONE_CURTAILMENT_PK primary key (FACILITY_ID, SERVICE_POINT_ID, GAS_DATE)
go

