/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.SourceItem;
import au.com.aemo.Common.API.SourceStatus;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsDataSource;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/filesystem")
public class WebAPIFileSystemStatus {
    private static Logger logger = LoggerFactory.getLogger(WebAPIFileSystemStatus.class);

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getDataSources() {
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        String string = JsonUtilities.listToJson(filesystemManager.getDataSources());
        return string;
    }

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ, Path="${source}")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getDataSourceStatus(@WebParam(source="source", mandatory=true) String string) {
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        fsDataSource fsDataSource2 = filesystemManager.getDataSource(string);
        SourceStatus sourceStatus = new SourceStatus();
        sourceStatus.properties.add(new SourceItem("Name", fsDataSource2.getName()));
        sourceStatus.properties.add(new SourceItem("Protocol", fsDataSource2.getProtocol()));
        sourceStatus.properties.add(new SourceItem("Last Send Activity", Util.dateToStr(fsDataSource2.getLastSendActivity(), "dd/MM/yyyy HH:mm:ss")));
        sourceStatus.properties.add(new SourceItem("Total Files Sent", Long.toString(fsDataSource2.getTotalFilesSent())));
        sourceStatus.properties.add(new SourceItem("Total Data Sent", Util.formatBytes((long)(fsDataSource2.getTotalKiloBytesSent() * 1024.0))));
        sourceStatus.properties.add(new SourceItem("Last Receive Activity", Util.dateToStr(fsDataSource2.getLastReceiveActivity(), "dd/MM/yyyy HH:mm:ss")));
        sourceStatus.properties.add(new SourceItem("Total Files Received", Long.toString(fsDataSource2.getTotalFilesReceived())));
        sourceStatus.properties.add(new SourceItem("Total Data Received", Util.formatBytes((long)(fsDataSource2.getTotalKiloBytesReceived() * 1024.0))));
        String string2 = JsonUtilities.toJson(sourceStatus);
        return string2;
    }
}

