/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.ServerStatus;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Files.FilesystemMonitor;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPath;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

@WebPath(value="/api/server/status")
public class WebAPIServerStatus {
    @WebGET(Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getServerStatus() throws Exception {
        ServerStatus serverStatus = new ServerStatus();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        serverStatus.CommittedVirtualMemorySize = operatingSystemMXBean.getCommittedVirtualMemorySize();
        serverStatus.TotalSwapSpaceSize = operatingSystemMXBean.getTotalSwapSpaceSize();
        serverStatus.FreeSwapSpaceSize = operatingSystemMXBean.getFreeSwapSpaceSize();
        serverStatus.ProcessCpuTime = operatingSystemMXBean.getProcessCpuTime();
        serverStatus.FreePhysicalMemorySize = operatingSystemMXBean.getFreePhysicalMemorySize();
        serverStatus.TotalPhysicalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize();
        serverStatus.SystemCpuLoad = operatingSystemMXBean.getSystemCpuLoad();
        serverStatus.ProcessCpuLoad = operatingSystemMXBean.getProcessCpuLoad();
        serverStatus.Storage = FilesystemMonitor.getInstance().getStatus();
        return JsonUtilities.toJson(serverStatus);
    }
}

