/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Application;

import au.com.aemo.Common.Cryptography.Crypt;
import au.com.aemo.Common.DataVault.ApplicationDataVaultManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationValueResolver {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationValueResolver.class);
    private static final String START_CONST = "${";
    private static final String END_CONST = "}";
    private static final String PREFIX_ENV = "env:";
    private static final String PREFIX_SYS = "sys:";
    private static final String PREFIX_VAULT = "vault:";
    private static final String PREFIX_DATE = "date:";
    private static final int MAX_SUBST_DEPTH = 5;
    private static final Map<String, String> ENV = System.getenv();

    public String resolveValue(String string, boolean bl) {
        return this.resolveValue(string, bl, 0);
    }

    public String resolveExternalVariable(String string, int n) {
        return null;
    }

    public String resolveValue(String object, boolean bl, int n) {
        if (object != null) {
            int n2 = 0;
            int n3 = ((String)object).indexOf(START_CONST, n2);
            while (n3 != -1) {
                Object object2;
                Object object3;
                if (n + 1 > 5) {
                    return object;
                }
                int n4 = ((String)object).indexOf(END_CONST, n3);
                if (n4 == -1) {
                    return object;
                }
                String string = ((String)object).substring(n3 + START_CONST.length(), n4);
                String string2 = null;
                boolean bl2 = false;
                if (string.startsWith(PREFIX_ENV)) {
                    object3 = string.substring(PREFIX_ENV.length());
                    int n5 = ((String)object3).indexOf(":");
                    if (n5 > 0) {
                        object2 = ((String)object3).substring(0, n5);
                        if (((String)object2).equalsIgnoreCase("decrypt")) {
                            bl2 = true;
                        } else {
                            Util_Logger.warning(logger, "Unsupported operation [" + (String)object2 + "] detected for variable " + string + ". Only supported option is decrypt");
                        }
                        object3 = ((String)object3).substring(n5 + 1);
                    }
                    string2 = ENV.get(object3);
                } else if (string.startsWith(PREFIX_SYS)) {
                    object3 = string.substring(PREFIX_SYS.length());
                    int n6 = ((String)object3).indexOf(":");
                    if (n6 > 0) {
                        object2 = ((String)object3).substring(0, n6);
                        if (((String)object2).equalsIgnoreCase("decrypt")) {
                            bl2 = true;
                        } else {
                            Util_Logger.warning(logger, "Unsupported operation [" + (String)object2 + "] detected for variable " + string + ". Only supported option is decrypt");
                        }
                        object3 = ((String)object3).substring(n6 + 1);
                    }
                    string2 = System.getProperty((String)object3);
                } else if (string.startsWith(PREFIX_VAULT)) {
                    if (bl) {
                        object3 = string.substring(PREFIX_VAULT.length());
                        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
                        string2 = applicationDataVaultManager.getValue((String)object3);
                    }
                } else if (string.startsWith(PREFIX_DATE)) {
                    object3 = string.substring(PREFIX_DATE.length());
                    int n7 = ((String)object3).indexOf(":");
                    if (n7 > 0) {
                        object2 = null;
                        String string3 = ((String)object3).substring(0, n7).toLowerCase();
                        if (string3.equalsIgnoreCase("today")) {
                            object2 = new Date();
                        } else if (string3.equalsIgnoreCase("tomorrow")) {
                            object2 = Util.dateOffset(new Date(), 1, 5);
                        } else if (string3.equalsIgnoreCase("yesterday")) {
                            object2 = Util.dateOffset(new Date(), -1, 5);
                        } else if (string3.startsWith("today")) {
                            int n8 = Integer.parseInt(string3.substring(5));
                            object2 = Util.dateOffset(new Date(), n8, 5);
                        } else {
                            Util_Logger.warning(logger, "Unsupported date [" + string3 + "] detected for variable " + string);
                        }
                        if (object2 != null) {
                            String string4 = ((String)object3).substring(n7 + 1);
                            string2 = Util.dateToStr((Date)object2, string4);
                        }
                    } else {
                        Util_Logger.warning(logger, "Missing date format detected for variable " + string);
                    }
                } else {
                    string2 = this.resolveExternalVariable(string, n + 1);
                }
                if (string2 == null) {
                    return object;
                }
                if (bl2) {
                    try {
                        object3 = Crypt.getInstance();
                        string2 = ((Crypt)object3).decrypt(string2);
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Unable to decrypt variable " + string + ": " + exception.getMessage(), exception);
                        return object;
                    }
                }
                object3 = n3 > 0 ? ((String)object).substring(0, n3) : "";
                object3 = (String)object3 + string2;
                n2 = ((String)object3).length();
                object = object3 = (String)object3 + ((String)object).substring(n4 + 1);
                n3 = ((String)object).indexOf(START_CONST, n2);
            }
        }
        return object;
    }
}

