/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.CSV;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvWriter
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(CsvWriter.class);
    static final boolean debugging = false;
    PrintWriter pw;
    int quoteLevel;
    char separator;
    private char quote;
    boolean wasPreviousField = false;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public CsvWriter(Writer writer, int n, char c, char c2) {
        this.pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        if (this.pw == null) {
            throw new IllegalArgumentException("invalid Writer");
        }
        this.quoteLevel = n;
        this.separator = c;
        this.quote = c2;
    }

    public CsvWriter(Writer writer) {
        this(writer, 1, ',', '\"');
    }

    public void put(String string) {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        if (string == null) {
            string = "";
        }
        if (this.wasPreviousField) {
            this.pw.print(this.separator);
        }
        if (string.indexOf(this.quote) >= 0) {
            this.pw.print(this.quote);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == this.quote) {
                    this.pw.print(this.quote);
                    this.pw.print(this.quote);
                    continue;
                }
                this.pw.print(c);
            }
            this.pw.print(this.quote);
        } else if (this.quoteLevel == 2 || this.quoteLevel == 1 && string.indexOf(32) >= 0 || string.indexOf(this.separator) >= 0) {
            this.pw.print(this.quote);
            this.pw.print(string);
            this.pw.print(this.quote);
        } else {
            this.pw.print(string);
        }
        this.wasPreviousField = true;
    }

    public void put(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.put(stringArray[i]);
        }
    }

    public void nl() {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVSWriter");
        }
        this.pw.println("");
        this.wasPreviousField = false;
    }

    public void flush() {
        if (this.pw != null) {
            this.pw.flush();
            this.pw = null;
        }
    }

    @Override
    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

