/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.DataVault;

import au.com.aemo.Common.DataVault.ApplicationDataVaultProviderInt;
import au.com.aemo.Common.DataVault.ApplicationDataVaultToken;
import au.com.aemo.Common.DataVault.DataVault;
import au.com.aemo.Common.DataVault.GoogleSecretResponse;
import au.com.aemo.Common.DataVault.GoogleTokenResponse;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHelper;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.Web.WebRequestConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataVaultProviderGoogleSecretsManager
implements ApplicationDataVaultProviderInt {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDataVaultProviderGoogleSecretsManager.class);
    private static final String ID = "GOOGLE_SECRETS_MANAGER";
    private static final String AUTH_METHOD_VMMI = "VMMI";
    private DataVault Config;
    private ApplicationDataVaultToken Token;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void initialise(DataVault dataVault) throws Exception {
        if (Util.isBlank(dataVault.Reference)) {
            Util_Logger.error(logger, "URL reference is not defined for Google Key Vault [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.AuthMethod)) {
            Util_Logger.error(logger, "Auth Method is not defined for Google Key Vault [" + dataVault.Name + "]");
        }
        this.Config = dataVault;
        this.Token = this.getToken();
        if (this.Token == null) {
            throw new Exception("Failed to intialise Google Key Vault [" + this.Config.Name + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationDataVaultToken getToken() {
        ApplicationDataVaultToken applicationDataVaultToken = null;
        if (this.Config.AuthMethod.toUpperCase().startsWith(AUTH_METHOD_VMMI)) {
            String string = Util.isBlank(this.Config.ServiceContext, "default");
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URL("http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/" + string + "/token");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("Metadata-Flavor", "Google");
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                GoogleTokenResponse googleTokenResponse = JsonUtilities.fromJson(webHttpResponse.Body, GoogleTokenResponse.class);
                applicationDataVaultToken = new ApplicationDataVaultToken(googleTokenResponse.access_token, Util.dateOffset(new Date(), googleTokenResponse.expires_in, 13));
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error extracting managed identity token for Google Key Vault: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        } else {
            Util_Logger.errorNoRaise(logger, "Detected unsupported Auth_Method [" + this.Config.AuthMethod + "] in Google Key Vault [" + this.Config.Name + "] configuration");
        }
        return applicationDataVaultToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by JSON serialisation")
    public String getValue(String string) {
        String string2 = null;
        if (this.Token == null) {
            this.Token = this.getToken();
        } else if (this.Token.isExpired()) {
            this.Token = this.getToken();
        }
        if (this.Token == null) {
            Util_Logger.errorNoRaise(logger, "Unable to extract Google Key Vault secret [" + string + "] as authorisation token is unavailable");
        } else {
            HttpURLConnection httpURLConnection = null;
            try {
                String string3 = Util.isBlank(this.Config.API_Key, "DEFAULT_API_KEY");
                URL uRL = new URL(this.Config.Reference + string + "/versions/latest:access?key=[" + string3 + "]");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("Accept", "application/json");
                        httpURLConnection.setRequestProperty("Authorization", "Bearer " + ApplicationDataVaultProviderGoogleSecretsManager.this.Token.getToken());
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                GoogleSecretResponse googleSecretResponse = JsonUtilities.fromJson(webHttpResponse.Body, GoogleSecretResponse.class);
                string2 = new String(Base64.getDecoder().decode(googleSecretResponse.payload.data));
                Util_Logger.info(logger, "Successfully extracted secret [" + string + "] from Google Key Vault [" + this.Config.Name + "])");
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to extract Google Key Vault secret [" + string + "]: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return string2;
    }
}

