/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Cryptography.Crypt;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbHandler
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(DbHandler.class);
    private DatabaseConfig itsConfig;
    private String itsAppName;
    private String itsAppVersion;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public DbHandler(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        this.itsAppName = string;
        this.itsAppVersion = string2;
        this.itsConfig = databaseConfig;
    }

    public abstract void afterConnect(Connection var1) throws SQLException;

    public abstract boolean isValid(Connection var1);

    public abstract Map<String, DbHandlerField> getColumnList(Connection var1, String var2, String var3) throws ApplicationException;

    public abstract List<String> getPkList(Connection var1, String var2, String var3) throws ApplicationException;

    public abstract long getSequence(Connection var1, String var2, String var3) throws ApplicationException;

    public abstract String getCurrentDateTime();

    public abstract String getNoTable();

    public abstract String getCurrentUser();

    public abstract String getCurrentSchema();

    public abstract List<DbSpaceStats> getSpaceUsage() throws ApplicationException;

    public abstract String getSqlDate(Date var1);

    public abstract String getSqlDate(String var1);

    public abstract String ifNull(String var1, String var2);

    public abstract DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField var1);

    public abstract String getSqlRowLimited(String var1, String var2, int var3);

    public abstract String getBitOperator(String var1, String var2);

    public abstract String getSqlDateRoundUp(String var1, int var2) throws Exception;

    public abstract String getSqlDateDiffInSecs(String var1, String var2) throws Exception;

    public abstract String getSqlDateAdd(String var1, String var2, int var3) throws Exception;

    public abstract String getDateFieldFormat(DbHandlerField var1);

    public abstract String concatStr(String var1, String var2);

    public abstract boolean isPrimaryKeyViolation(SQLException var1);

    public final String getAppName() {
        return this.itsAppName;
    }

    public final String getAppVersion() {
        return this.itsAppVersion;
    }

    public void preConnect(Properties properties) {
    }

    public final Connection getConnection() throws Exception {
        String string = this.getURL();
        String string2 = this.itsConfig.User;
        String string3 = this.itsConfig.Password;
        boolean bl = this.itsConfig.PasswordEncrypted;
        String string4 = this.itsConfig.Driver;
        return this.getConnection(string, string2, string3, bl, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(String string, String string2, String string3, boolean bl, String string4) throws Exception {
        String[] stringArray;
        Connection connection = null;
        Properties properties = this.getProperties();
        if (Util.isBlank(string2) || Util.isBlank(string3)) {
            Util_Logger.info(logger, "Using external identified user for DB connection");
        } else {
            properties.put("user", string2);
            if (bl) {
                stringArray = Crypt.getInstance();
                properties.put("password", stringArray.decrypt(string3));
            } else {
                properties.put("password", string3);
            }
        }
        this.preConnect(properties);
        Class.forName(string4);
        connection = DriverManager.getConnection(string, properties);
        connection.setAutoCommit(false);
        this.afterConnect(connection);
        if (this.itsConfig != null && !Util.isBlank(this.itsConfig.DbConnInitSQL)) {
            stringArray = Util.getColumns(this.itsConfig.DbConnInitSQL, ';');
            try (Statement statement = null;){
                statement = connection.createStatement();
                for (String string5 : stringArray) {
                    statement.execute(string5);
                }
            }
        }
        return connection;
    }

    public final boolean hasConfig() {
        return this.itsConfig != null;
    }

    public final String getDbDateFormat() {
        return this.itsConfig.DbDateFormat;
    }

    public final String getDbTimestampFormat() {
        return this.itsConfig.DbTimestampFormat;
    }

    public final String getJavaDateFormat() {
        return this.itsConfig.JavaDateFormat;
    }

    public final String getJavaTimestampFormat() {
        return this.itsConfig.JavaTimestampFormat;
    }

    public final String getPrimaryKeySQLErrorCode(String string) {
        if (this.itsConfig != null) {
            return Util.isBlank(this.itsConfig.PrimaryKeySQLErrorCode, string);
        }
        return string;
    }

    public final boolean safeInsertMode() {
        if (this.itsConfig.InsertMode == null) {
            return true;
        }
        return this.itsConfig.InsertMode.equalsIgnoreCase("safe");
    }

    public final String getDefaultSchema() {
        return this.itsConfig.DefaultSchema;
    }

    public final void setDefaultSchema(String string) {
        this.itsConfig.DefaultSchema = string;
    }

    public String getDefaultSchemaSQL() {
        return null;
    }

    public final Properties getProperties() throws ApplicationException {
        String[] stringArray;
        Properties properties = new Properties();
        if (this.itsConfig != null && !Util.isBlank(this.itsConfig.DbProps) && (stringArray = Util.getColumns(this.itsConfig.DbProps, ',')) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Util_Logger.debug(logger, "Adding DB property " + stringArray[i]);
                String[] stringArray2 = Util.getColumns(stringArray[i], '=');
                properties.put(stringArray2[0], stringArray2[1]);
            }
        }
        return properties;
    }

    public boolean getPreferExistsStatement() {
        return true;
    }

    public int maptoFieldTypeId(String string) {
        return 12;
    }

    public final String escapeString(String string) {
        return Util.replaceAll(string, "'", "''");
    }

    public void setSqlPreparedStatementFormat(PreparedStatement preparedStatement, int n, String string, int n2) throws ApplicationException {
        try {
            if (!Util.isBlank(string)) {
                switch (n2) {
                    case 12: {
                        preparedStatement.setString(n, string);
                        break;
                    }
                    case 3: {
                        preparedStatement.setDouble(n, Double.parseDouble(string));
                        break;
                    }
                    case 93: {
                        preparedStatement.setTimestamp(n, new Timestamp(Util.strToDate(string, this.getJavaTimestampFormat()).getTime()));
                        break;
                    }
                    case 6: {
                        preparedStatement.setFloat(n, Float.parseFloat(string));
                        break;
                    }
                    case 4: {
                        preparedStatement.setInt(n, Integer.parseInt(string));
                        break;
                    }
                    case 2: {
                        preparedStatement.setDouble(n, Double.parseDouble(string));
                        break;
                    }
                    case 7: {
                        preparedStatement.setDouble(n, Double.parseDouble(string));
                        break;
                    }
                    case 5: {
                        preparedStatement.setInt(n, Integer.parseInt(string));
                        break;
                    }
                    case -6: {
                        preparedStatement.setInt(n, Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        preparedStatement.setString(n, string);
                        break;
                    }
                    default: {
                        preparedStatement.setString(n, string);
                        break;
                    }
                }
            } else {
                preparedStatement.setNull(n, n2);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error setting prepared statement parameter " + n + " to " + string + ": " + exception.getMessage(), exception);
        }
    }

    public String getTableReference(String string, String string2) {
        if (Util.isBlank(string)) {
            return string2;
        }
        return string + "." + string2;
    }

    protected String getDbName(String string) {
        String[] stringArray;
        Object object = "";
        if (!Util.isBlank(string) && (stringArray = Util.getColumns(string, '.')).length > 1 && !Util.isBlank(stringArray[0])) {
            object = stringArray[0] + ".";
        }
        return object;
    }

    protected String getSchemaName(String string) {
        String string2 = "";
        if (!Util.isBlank(string)) {
            String[] stringArray = Util.getColumns(string, '.');
            int n = 0;
            if (stringArray.length > 1) {
                n = 1;
            }
            if (!Util.isBlank(stringArray[n])) {
                string2 = stringArray[n];
            }
        }
        return string2;
    }

    protected String getInformationSchemaPredicate(String string, String string2) {
        Object object = "";
        if (!Util.isBlank(string2)) {
            String[] stringArray = Util.getColumns(string2, '.');
            if (stringArray.length == 1) {
                object = (String)object + " AND " + (String)(string == null ? "" : string + ".") + "TABLE_SCHEMA = '" + stringArray[0] + "'";
            } else {
                if (!Util.isBlank(stringArray[0])) {
                    object = (String)object + " AND " + (String)(string == null ? "" : string + ".") + "TABLE_CATALOG = '" + stringArray[0] + "'";
                }
                if (!Util.isBlank(stringArray[1])) {
                    object = (String)object + " AND " + (String)(string == null ? "" : string + ".") + "TABLE_SCHEMA = '" + stringArray[1] + "'";
                }
            }
        } else if (!Util.isBlank(this.getCurrentSchema())) {
            object = (String)object + " AND " + (String)(string == null ? "" : string + ".") + "TABLE_SCHEMA = " + this.getCurrentSchema();
        }
        return object;
    }

    public boolean checkSchemaExists(Connection connection, String string) throws ApplicationException {
        boolean bl = false;
        try {
            String string2 = "SELECT count(1) FROM " + this.getDbName(string) + "INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                preparedStatement.setString(1, this.getSchemaName(string));
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        bl = resultSet.getInt(1) > 0;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkSchemaExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    public boolean checkTableExists(Connection connection, String string, String string2) throws ApplicationException {
        boolean bl = false;
        try (Statement statement = connection.createStatement();){
            String string3 = "SELECT count(1) FROM " + this.getDbName(string) + "INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = '" + string2 + "'" + this.getInformationSchemaPredicate(null, string);
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    bl = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkTableExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    public boolean checkColumnExists(Connection connection, String string, String string2, String string3) throws ApplicationException {
        boolean bl = false;
        try (Statement statement = connection.createStatement();){
            String string4 = "SELECT count(1) FROM " + this.getDbName(string) + "INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" + string2 + "' AND COLUMN_NAME = '" + string3 + "'" + this.getInformationSchemaPredicate(null, string);
            try (ResultSet resultSet = statement.executeQuery(string4);){
                while (resultSet.next()) {
                    bl = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkColumnExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    protected String getTablespaceToReportSQL(String string, String string2) {
        if (this.itsConfig == null) {
            return "";
        }
        if (this.itsConfig.DbTablespacesToReport == null) {
            return "";
        }
        if (this.itsConfig.DbTablespacesToReport.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        stringBuilder.append(" in (");
        String string3 = "";
        for (String string4 : this.itsConfig.DbTablespacesToReport) {
            stringBuilder.append(string3);
            stringBuilder.append("'");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            string3 = ",";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getScriptDelimiter() {
        return null;
    }

    public String getCodeBlockDeclare() {
        return null;
    }

    public String getCodeBlockBegin() {
        return null;
    }

    public String getCodeBlockEnd() {
        return null;
    }

    public String getURL() {
        return this.itsConfig.URL;
    }
}

