/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Table meta data is consumed by trusted code")
public class DbHandlerMetadata {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerMetadata.class);
    private String itsTable;
    private String itsSchema;
    private Map<String, DbHandlerField> itsColumns;
    private List<String> itsPkColumns;

    public DbHandlerMetadata(String string, String string2) throws Exception {
        this.itsSchema = string;
        this.itsTable = string2;
    }

    public String getSchema() {
        return this.itsSchema;
    }

    public String getTable() {
        return this.itsTable;
    }

    public void getDbMetaData(Connection connection, DbHandler dbHandler) throws ApplicationException {
        try {
            this.itsColumns = dbHandler.getColumnList(connection, this.itsSchema, this.itsTable);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading column meta-data for " + this.itsSchema + " " + this.itsTable + ": " + exception.getMessage(), exception);
        }
        try {
            this.itsPkColumns = dbHandler.getPkList(connection, this.itsSchema, this.itsTable);
            for (String string : this.itsPkColumns) {
                this.itsColumns.get(string).setIsPrimaryKey(true);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading PK column meta-data for " + this.itsSchema + " " + this.itsTable + ": " + exception.getMessage(), exception);
        }
    }

    public Map<String, DbHandlerField> getColumnList() {
        return this.itsColumns;
    }

    public List<String> getPkList() {
        return this.itsPkColumns;
    }
}

