/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FTP;

import au.com.aemo.Common.Cryptography.Crypt;
import au.com.aemo.Common.FTP.FtpConnectionInt;
import au.com.aemo.Common.FTP.FtpConnectionPool;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionPoolFactory
implements PooledObjectFactory<FtpConnectionInt> {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionPool.class);
    private Class itsFtpProvider;
    private String itsId;
    private String itsConfigId;
    private Properties itsConfiguration;
    private int itsConnectionId;
    private String itsApplicationId;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Private constructor")
    public FtpConnectionPoolFactory(String string, String string2, Properties properties, String string3) {
        this.itsId = string2;
        this.itsConfigId = string + "_" + this.itsId + "_";
        this.itsConnectionId = 1;
        this.itsConfiguration = properties;
        this.itsApplicationId = string3;
        try {
            String string4 = Util.getProperty(this.itsConfiguration, "ftp_provider", "au.com.aemo.Common.FTP.FtpConnectionIntEDT");
            String string5 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_provider", string4);
            this.itsFtpProvider = Class.forName(string5);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error extracting FTP provider: " + exception.getMessage(), exception);
        }
    }

    public synchronized PooledObject<FtpConnectionInt> makeObject() throws Exception {
        Object object;
        String string = Util.getProperty(this.itsConfiguration, this.itsConfigId + "host");
        String string2 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "port", null);
        Integer n = null;
        if (!Util.isBlank(string2)) {
            n = Integer.parseInt(string2);
        }
        String string3 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "username");
        String string4 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "password");
        boolean bl = Util.getProperty(this.itsConfiguration, this.itsConfigId + "password_encrypted", "true").equalsIgnoreCase("true");
        if (bl) {
            object = Crypt.getInstance();
            string4 = ((Crypt)object).decrypt(string4);
        }
        object = Util.getProperty(this.itsConfiguration, this.itsConfigId + "account_info", null);
        String string5 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "proxy_address", null);
        String string6 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "proxy_port", null);
        String string7 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_mode", "passive");
        int n2 = Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_timeout", "200"));
        boolean bl2 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_extract_last_modified_date", "false").equalsIgnoreCase("true");
        boolean bl3 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_validate_server", "false").equalsIgnoreCase("true");
        String string8 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_known_hosts_file", null);
        String string9 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_key_file", null);
        String string10 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_server_certificate_file", null);
        boolean bl4 = Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_use_implicit_ftps", "true").equalsIgnoreCase("true");
        if (this.itsFtpProvider == null) {
            Util_Logger.error(logger, "Error extracting FTP provider, please check properties configuration file");
        }
        FtpConnectionInt ftpConnectionInt = (FtpConnectionInt)this.itsFtpProvider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String string11 = this.itsConfigId + this.itsConnectionId;
        ++this.itsConnectionId;
        ftpConnectionInt.connect(string, n, string3, string4, (String)object, string5, string6, n2, string7, string11, this.itsApplicationId, bl2, bl3, string8, string9, string10, bl4);
        Util_Logger.debug(logger, "Created FTP session [" + ftpConnectionInt.getId() + "]");
        return new DefaultPooledObject((Object)ftpConnectionInt);
    }

    public boolean validateObject(PooledObject<FtpConnectionInt> pooledObject) {
        boolean bl = false;
        FtpConnectionInt ftpConnectionInt = (FtpConnectionInt)pooledObject.getObject();
        if (ftpConnectionInt == null) {
            return false;
        }
        bl = ftpConnectionInt.isConnected();
        Util_Logger.debug(logger, "Validated FTP session [" + ftpConnectionInt.getId() + "], status=" + bl);
        return bl;
    }

    public void activateObject(PooledObject<FtpConnectionInt> pooledObject) {
        try {
            FtpConnectionInt ftpConnectionInt = (FtpConnectionInt)pooledObject.getObject();
            Util_Logger.debug(logger, "Activating FTP session [" + ftpConnectionInt.getId() + "]");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void passivateObject(PooledObject<FtpConnectionInt> pooledObject) throws Exception {
        FtpConnectionInt ftpConnectionInt = (FtpConnectionInt)pooledObject.getObject();
        if (ftpConnectionInt != null) {
            Util_Logger.debug(logger, "Passivating FTP session [" + ftpConnectionInt.getId() + "]");
        }
    }

    public void destroyObject(PooledObject<FtpConnectionInt> pooledObject) throws Exception {
        FtpConnectionInt ftpConnectionInt = (FtpConnectionInt)pooledObject.getObject();
        if (ftpConnectionInt != null) {
            Util_Logger.debug(logger, "Destroying FTP session [" + ftpConnectionInt.getId() + "]");
            ftpConnectionInt.disconnect();
        }
    }
}

