/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAMQP;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAPI;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAWS;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAzure;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryEHub;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryFtp;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryGoogle;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryGraphQL;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryLocal;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryNull;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryWeb;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryWebhook;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsDataSource;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationFactory;
import au.com.aemo.Common.FileSystem.fsEventNotificationFactoryInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationInt;
import au.com.aemo.Common.JSON.JsonTransformManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemManager {
    private static Logger logger = LoggerFactory.getLogger(FilesystemManager.class);
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_LOCAL = "LOCAL";
    public static final String PROTOCOL_WEB = "WEB";
    public static final String PROTOCOL_NULL = "NULL";
    public static final String PROTOCOL_AZURE = "AZURE";
    public static final String PROTOCOL_AWS = "AWS";
    public static final String PROTOCOL_API = "API";
    public static final String PROTOCOL_GOOGLE = "GOOGLE";
    public static final String PROTOCOL_GRAPHQL = "GRAPHQL";
    public static final String PROTOCOL_WEBHOOK = "WEBHOOK";
    public static final String PROTOCOL_EHUB = "EHUB";
    public static final String PROTOCOL_AMQP = "AMQP";
    public static final String EVENT_SIGNALR = "SIGNALR";
    public static final String EVENT_AMQP = "AMQP";
    public static final String SOURCE_INTERNAL = "internal";
    private String itsAppName;
    private String itsAppVersion;
    private String itsConfigPrefix;
    private Properties itsConfiguration;
    private Map<String, fsConnectionFactoryInt> itsDataSourceFactories;
    private Map<String, fsEventNotificationInt> itsProducers = new HashMap<String, fsEventNotificationInt>();
    private Map<String, String> itsConsumers = new HashMap<String, String>();
    private Map<String, fsDataSource> itsDataSources;
    private Date itsStartTime;
    private boolean isReady = false;

    private FilesystemManager() {
        this.itsDataSourceFactories = new HashMap<String, fsConnectionFactoryInt>();
        this.registerDataSourceFactory(fsConnectionFactoryFtp.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryLocal.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryWeb.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryNull.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAzure.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAWS.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAPI.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryGoogle.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryGraphQL.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryWebhook.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryEHub.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAMQP.getInstance());
    }

    public static FilesystemManager getInstance() {
        return SingletonHolder.instance;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void configure(String string, String string2, String string3, Properties properties) {
        this.itsAppName = string;
        this.itsAppVersion = string2;
        this.itsConfigPrefix = string3;
        this.itsConfiguration = properties;
    }

    public void start() throws Exception {
        Util_Logger.info(logger, "Starting filesystem manager with config prefix [" + this.itsConfigPrefix + "]");
        try {
            this.itsDataSources = new HashMap<String, fsDataSource>();
            String string = this.getConfig("data_sources", null);
            if (!Util.isBlank(string)) {
                String[] object = Util.getColumns(string, ',');
                for (String string2 : object) {
                    String string3;
                    if (Util.isBlank(string2)) continue;
                    String string4 = this.getConfig(string2 + "_mode", PROTOCOL_LOCAL);
                    fsDataSource fsDataSource2 = new fsDataSource(string2, string4);
                    String string5 = this.getConfig(string2 + "_send_inactivity_timeout", "");
                    if (!Util.isBlank(string5) && Util.isInteger(string5)) {
                        int n = Integer.valueOf(string5);
                        fsDataSource2.setSendInactivityTimeoutSecs(n);
                    }
                    if (!Util.isBlank(string3 = this.getConfig(string2 + "_receive_inactivity_timeout", "")) && Util.isInteger(string3)) {
                        int n = Integer.valueOf(string3);
                        fsDataSource2.setReceiveInactivityTimeoutSecs(n);
                    }
                    this.addDataSource(fsDataSource2);
                }
            }
            for (fsDataSource fsDataSource3 : this.itsDataSources.values()) {
                fsConnectionFactoryInt fsConnectionFactoryInt2 = this.getDataSourceFactory(fsDataSource3.getProtocol());
                fsConnectionFactoryInt2.setIsActive(true);
            }
            Util_Logger.info(logger, "Registered [" + this.itsDataSources.size() + "] data sources with [" + this.itsDataSourceFactories.size() + "] factory protocol providers");
            boolean bl = true;
            for (fsConnectionFactoryInt fsConnectionFactoryInt3 : this.itsDataSourceFactories.values()) {
                if (!fsConnectionFactoryInt3.getIsActive()) continue;
                Util_Logger.info(logger, "Starting " + fsConnectionFactoryInt3.getName() + " data source factory");
                fsConnectionFactoryInt3.start();
                bl = bl && fsConnectionFactoryInt3.getIsRunning();
            }
            JsonTransformManager.getInstance().loadTransformConfig();
            this.itsStartTime = new Date();
            this.isReady = bl;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting FilesystemManager: " + exception.getMessage(), exception);
        }
        if (!this.isReady) {
            throw new Exception("Error starting filesystem manager");
        }
    }

    public void stop() {
        if (this.isReady) {
            Util_Logger.info(logger, "Stopping filesystem manager with config prefix [" + this.itsConfigPrefix + "]");
            for (Map.Entry<String, fsEventNotificationInt> object : this.itsProducers.entrySet()) {
                Util_Logger.info(logger, "Stopping " + object.getKey() + " event notification provider");
                object.getValue().stop();
            }
            for (fsConnectionFactoryInt fsConnectionFactoryInt2 : this.itsDataSourceFactories.values()) {
                if (!fsConnectionFactoryInt2.getIsRunning()) continue;
                Util_Logger.debug(logger, "Stopping " + fsConnectionFactoryInt2.getName() + " data source factory");
                fsConnectionFactoryInt2.stop();
            }
        }
    }

    public String getAppName() {
        return this.itsAppName;
    }

    public String getAppVersion() {
        return this.itsAppVersion;
    }

    public String getConfigPrefix() {
        return this.itsConfigPrefix;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is consumed by trusted code")
    public Properties getConfiguration() {
        return this.itsConfiguration;
    }

    public String getConfig(String string, String string2) {
        return Util.getProperty(this.itsConfiguration, this.itsConfigPrefix + "_" + string, string2);
    }

    public void registerDataSourceFactory(fsConnectionFactoryInt fsConnectionFactoryInt2) {
        this.itsDataSourceFactories.put(fsConnectionFactoryInt2.getName().toUpperCase(), fsConnectionFactoryInt2);
    }

    public boolean getIsReady() {
        return this.isReady;
    }

    public fsConnectionFactoryInt getDataSourceFactory(String string) {
        return this.itsDataSourceFactories.get(string.toUpperCase());
    }

    public fsDataSource getDataSource(String string) {
        fsDataSource fsDataSource2 = null;
        if (this.itsDataSources != null) {
            fsDataSource2 = this.itsDataSources.get(string.toUpperCase());
        }
        return fsDataSource2;
    }

    private void addDataSource(fsDataSource fsDataSource2) {
        if (fsDataSource2 != null) {
            this.itsDataSources.put(fsDataSource2.getName().toUpperCase(), fsDataSource2);
        }
    }

    public void updateSendActivity(String string, int n, double d) {
        fsDataSource fsDataSource2 = this.getDataSource(string);
        if (fsDataSource2 != null) {
            fsDataSource2.updateSendActivity(n, d);
        }
    }

    public void updateReceiveActivity(String string, int n, double d) {
        fsDataSource fsDataSource2 = this.getDataSource(string);
        if (fsDataSource2 != null) {
            fsDataSource2.updateReceiveActivity(n, d);
        }
    }

    public void performInactivityCheck() {
        if (this.itsDataSources != null) {
            try {
                Util_Logger.info(logger, "Performing data source inactivity check");
                Date date = new Date();
                for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
                    Object object;
                    boolean bl = true;
                    if (fsDataSource2.getSendInactivityTimeoutSecs() != null) {
                        Date date2 = Util.dateOffset(date, -fsDataSource2.getSendInactivityTimeoutSecs().intValue(), 13);
                        object = fsDataSource2.getLastSendActivity();
                        if (object == null) {
                            object = this.itsStartTime;
                        }
                        if (((Date)object).before(date2)) {
                            bl = false;
                            Util_Logger.warning(logger, "Detected send inactivity timeout on data source [" + fsDataSource2.getName() + "], last activity was at " + Util.dateToStr((Date)object, "dd-MM-yyyy HH:mm:ss"));
                        }
                    }
                    boolean bl2 = true;
                    if (fsDataSource2.getReceiveInactivityTimeoutSecs() != null) {
                        object = Util.dateOffset(date, -fsDataSource2.getReceiveInactivityTimeoutSecs().intValue(), 13);
                        Date date3 = fsDataSource2.getLastReceiveActivity();
                        if (date3 == null) {
                            date3 = this.itsStartTime;
                        }
                        if (date3.before((Date)object)) {
                            bl2 = false;
                            Util_Logger.warning(logger, "Detected receive inactivity timeout on data source [" + fsDataSource2.getName() + "], last activity was at " + Util.dateToStr(date3, "dd-MM-yyyy HH:mm:ss"));
                        }
                    }
                    if (bl && bl2 || (object = this.getDataSourceFactory(fsDataSource2.getProtocol())) == null) continue;
                    Util_Logger.warning(logger, "Resetting connections to data source [" + fsDataSource2.getName() + "]");
                    object.resetPool(fsDataSource2.getName());
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error performing data source inactivity checks: " + exception.getMessage(), exception);
            }
        }
    }

    public List<String> getDataSources(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
            if (!fsDataSource2.getProtocol().equalsIgnoreCase(string)) continue;
            arrayList.add(fsDataSource2.getName());
        }
        return arrayList;
    }

    public List<String> getDataSources() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
            arrayList.add(fsDataSource2.getName());
        }
        return arrayList;
    }

    public void resetPool() {
        for (fsConnectionFactoryInt fsConnectionFactoryInt2 : this.itsDataSourceFactories.values()) {
            fsConnectionFactoryInt2.resetPool();
        }
    }

    public String getInternalProtocol() {
        fsDataSource fsDataSource2 = null;
        if (this.itsDataSources != null) {
            fsDataSource2 = this.itsDataSources.get(SOURCE_INTERNAL);
        }
        if (fsDataSource2 != null) {
            return fsDataSource2.getProtocol();
        }
        return PROTOCOL_LOCAL;
    }

    public fsConnectionInt getInternalConnection() {
        fsConnectionFactoryInt fsConnectionFactoryInt2 = this.getDataSourceFactory(this.getInternalProtocol());
        fsConnectionInt fsConnectionInt2 = fsConnectionFactoryInt2.getConnection(SOURCE_INTERNAL);
        return fsConnectionInt2;
    }

    public synchronized void startEventNotificationProviders() throws ApplicationException {
        for (Map.Entry<String, fsEventNotificationInt> entry : this.itsProducers.entrySet()) {
            Util_Logger.info(logger, "Starting [" + entry.getKey() + "] event notification provider with [" + entry.getValue().getListenerCount() + "] listeners");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(() -> ((fsEventNotificationInt)entry.getValue()).start());
        }
    }

    public List<fsEventData> getNewFileEvents(String string) throws ApplicationException {
        List<fsEventData> list = null;
        String string2 = this.itsConsumers.get(string);
        if (!Util.isBlank(string2)) {
            fsEventNotificationInt fsEventNotificationInt2 = this.itsProducers.get(string2);
            if (fsEventNotificationInt2 != null) {
                list = fsEventNotificationInt2.getNewFileEvents(string);
            } else {
                Util_Logger.error(logger, "Unable to find event producer for event producer [" + string2 + "]");
            }
        } else {
            Util_Logger.error(logger, "Unable to find event producer for event consumer [" + string + "]");
        }
        return list;
    }

    public void processedNewFileEvent(String string, List<fsEventData> list) throws ApplicationException {
        String string2 = this.itsConsumers.get(string);
        if (!Util.isBlank(string2)) {
            fsEventNotificationInt fsEventNotificationInt2 = this.itsProducers.get(string2);
            if (fsEventNotificationInt2 != null) {
                fsEventNotificationInt2.processedNewFileEvent(string, list);
            } else {
                Util_Logger.error(logger, "Unable to find event producer for event producer [" + string2 + "]");
            }
        } else {
            Util_Logger.error(logger, "Unable to find event producer for event consumer [" + string + "]");
        }
    }

    private eventProviderDetails getEventProviderDetails(fsEventListenerInt fsEventListenerInt2) {
        eventProviderDetails eventProviderDetails2 = new eventProviderDetails();
        if (fsEventListenerInt2.getDataSourceIsEventBased()) {
            eventProviderDetails2.DataSource = fsEventListenerInt2.getDataSourceId();
        } else if (!Util.isBlank(fsEventListenerInt2.getEventDataSource())) {
            eventProviderDetails2.DataSource = fsEventListenerInt2.getEventDataSource();
        }
        eventProviderDetails2.Protocol = this.getDataSource(eventProviderDetails2.DataSource).getProtocol();
        return eventProviderDetails2;
    }

    public void registerListener(fsEventListenerInt fsEventListenerInt2) throws ApplicationException {
        try {
            eventProviderDetails eventProviderDetails2 = this.getEventProviderDetails(fsEventListenerInt2);
            if (!Util.isBlank(eventProviderDetails2.DataSource)) {
                fsEventNotificationInt fsEventNotificationInt2 = this.itsProducers.get(fsEventListenerInt2.getEventProducerId());
                if (fsEventNotificationInt2 == null) {
                    fsEventNotificationFactory fsEventNotificationFactory2 = fsEventNotificationFactory.getInstance();
                    fsEventNotificationFactoryInt fsEventNotificationFactoryInt2 = fsEventNotificationFactory2.getFactory(eventProviderDetails2.Protocol);
                    fsEventNotificationInt2 = fsEventNotificationFactoryInt2.createInstance(eventProviderDetails2.DataSource, fsEventListenerInt2.getEventEndpoint(), fsEventListenerInt2.getSubscribedEventsList());
                    this.itsProducers.put(fsEventListenerInt2.getEventProducerId(), fsEventNotificationInt2);
                }
                fsEventNotificationInt2.registerListener(fsEventListenerInt2);
                this.itsConsumers.put(fsEventListenerInt2.getEventConsumerId(), fsEventListenerInt2.getEventProducerId());
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error registering consumer [" + fsEventListenerInt2.getEventConsumerId() + "] to event producer", exception);
        }
    }

    private static class SingletonHolder {
        private static FilesystemManager instance = new FilesystemManager();

        private SingletonHolder() {
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Cannot be a static class")
    private class eventProviderDetails {
        public String Protocol;
        public String DataSource;

        private eventProviderDetails() {
        }
    }
}

