/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.Web.WebClientAuthAPIKey;
import au.com.aemo.Common.Web.WebClientAuthBasic;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebClientAuthNone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class fsConnectionFactoryBase
implements fsConnectionFactoryInt {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFactoryBase.class);
    private String itsMode;
    private boolean isRunning = false;
    private boolean isActive = false;

    public fsConnectionFactoryBase(String string) {
        this.itsMode = string;
    }

    @Override
    public boolean getIsRunning() {
        return this.isRunning;
    }

    @Override
    public void setIsRunning(boolean bl) {
        this.isRunning = bl;
    }

    @Override
    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    public String getName() {
        return this.itsMode;
    }

    @Override
    public void start() {
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void freeConnection(fsConnectionInt fsConnectionInt2) {
    }

    @Override
    public void resetPool(String string) {
    }

    @Override
    public void resetPool() {
    }

    @Override
    public boolean getIsEventBased() {
        return false;
    }

    public WebClientAuthInt getWebAuthProvider(String string) {
        String string2;
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        WebClientAuthInt webClientAuthInt = null;
        switch (string2 = filesystemManager.getConfig(string + "_auth_provider", "").toUpperCase()) {
            case "BASIC": {
                WebClientAuthBasic webClientAuthBasic = new WebClientAuthBasic();
                String string3 = filesystemManager.getConfig(string + "_basic_auth_username", "");
                String string4 = filesystemManager.getConfig(string + "_basic_auth_password", "");
                webClientAuthBasic.setBasicAuthCredentials(string3, string4);
                webClientAuthInt = webClientAuthBasic;
                break;
            }
            case "APIKEY": {
                WebClientAuthAPIKey webClientAuthAPIKey = new WebClientAuthAPIKey();
                String string5 = filesystemManager.getConfig(string + "_api_key_name", "");
                String string6 = filesystemManager.getConfig(string + "_api_key_value", "");
                webClientAuthAPIKey.setAPIKey(string5, string6);
                webClientAuthInt = webClientAuthAPIKey;
                break;
            }
            case "NONE": {
                WebClientAuthNone webClientAuthNone;
                webClientAuthInt = webClientAuthNone = new WebClientAuthNone();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported auth provider [" + string2 + "] for data source " + string);
            }
        }
        return webClientAuthInt;
    }
}

