/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryBase;
import au.com.aemo.Common.FileSystem.fsConnectionGraphQL;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsGraphQLDataManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionFactoryGraphQL
extends fsConnectionFactoryBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFactoryGraphQL.class);

    private fsConnectionFactoryGraphQL() {
        super("GRAPHQL");
    }

    public static fsConnectionFactoryGraphQL getInstance() {
        return SingletonHolder.instance;
    }

    public fsConnectionGraphQL getConnectionInternal(String string) {
        Object object;
        Proxy proxy = null;
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        String string2 = filesystemManager.getConfig(string + "_url", "");
        String string3 = filesystemManager.getConfig(string + "_proxy_host", "");
        String string4 = filesystemManager.getConfig(string + "_proxy_port", "");
        int n = Integer.parseInt(filesystemManager.getConfig(string + "_timeout_connection", "10"));
        int n2 = Integer.parseInt(filesystemManager.getConfig(string + "_timeout_transfer", "120"));
        int n3 = Integer.parseInt(filesystemManager.getConfig(string + "_max_process_attempts", "5"));
        if (!Util.isBlank(string3) && !Util.isBlank(string4)) {
            object = new InetSocketAddress(string3, Integer.parseInt(string4));
            proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
        }
        object = new fsConnectionGraphQL(string, string2, proxy, n, n2, n3);
        return object;
    }

    @Override
    public fsConnectionInt getConnection(String string) {
        fsConnectionGraphQL fsConnectionGraphQL2 = this.getConnectionInternal(string);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> fsGraphQLDataManager.getInstance().discoverAvailableObjects(string, fsConnectionGraphQL2));
        return fsConnectionGraphQL2;
    }

    @Override
    public void start() {
        try {
            this.primeGraphQLDataManager();
            this.setIsRunning(true);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error priming GraphQL Data Manager: " + exception.getMessage(), exception);
        }
    }

    private void primeGraphQLDataManager() throws ApplicationException {
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        for (String string : filesystemManager.getDataSources("GRAPHQL")) {
            fsConnectionGraphQL fsConnectionGraphQL2 = this.getConnectionInternal(string);
            fsGraphQLDataManager.getInstance().discoverAvailableObjects(string, fsConnectionGraphQL2);
        }
    }

    private static class SingletonHolder {
        private static fsConnectionFactoryGraphQL instance = new fsConnectionFactoryGraphQL();

        private SingletonHolder() {
        }
    }
}

