/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class fsEventNotificationBase
implements fsEventNotificationInt {
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationBase.class);
    private fsConnectionFactoryInt itsListener;
    private String itsDataSourceId;
    private List<fsEventListenerInt> itsListeners;
    private volatile Map<String, List<fsEventData>> itsEventNewFiles = new HashMap<String, List<fsEventData>>();

    public fsEventNotificationBase(String string) {
        this.itsDataSourceId = string;
        this.itsListeners = new ArrayList<fsEventListenerInt>();
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public synchronized void registerListener(fsEventListenerInt fsEventListenerInt2) {
        Util_Logger.info(logger, "Registering listener [" + fsEventListenerInt2.getEventConsumerId() + "] to event notification source [" + this.itsDataSourceId + "]");
        this.itsListeners.add(fsEventListenerInt2);
    }

    @Override
    public int getListenerCount() {
        return this.itsListeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addNewFileEvent(fsEventData fsEventData2) {
        Map<String, List<fsEventData>> map = this.itsEventNewFiles;
        synchronized (map) {
            for (fsEventListenerInt fsEventListenerInt2 : this.itsListeners) {
                List<fsEventData> list = this.itsEventNewFiles.get(fsEventListenerInt2.getEventConsumerId());
                if (list == null) {
                    list = new ArrayList<fsEventData>();
                    this.itsEventNewFiles.put(fsEventListenerInt2.getEventConsumerId(), list);
                }
                list.add(fsEventData2);
                Util_Logger.debug(logger, "Added event [" + fsEventData2.getEventId() + "] to consumer [" + fsEventListenerInt2.getEventConsumerId() + "], total events in queue is " + list.size());
                ArrayList<fsEventData> arrayList = new ArrayList<fsEventData>();
                for (fsEventData fsEventData3 : list) {
                    if (!fsEventData3.isCompleted()) continue;
                    arrayList.add(fsEventData3);
                }
                list.removeAll(arrayList);
            }
        }
        boolean bl = false;
        for (fsEventListenerInt fsEventListenerInt2 : this.itsListeners) {
            Util_Logger.debug(logger, "Notifying consumer [" + fsEventListenerInt2.getEventConsumerId() + "] of new event [" + fsEventData2.getEventId() + "]");
            fsEventListenerInt2.notifyNewFileEvent();
            bl = true;
        }
        if (!bl) {
            Util_Logger.warning(logger, "No consumers registered for notifications from event source [" + fsEventData2.getDataSourceId() + "]");
        }
    }

    @Override
    public List<fsEventData> getNewFileEvents(String string) {
        List<fsEventData> list;
        ArrayList<fsEventData> arrayList = new ArrayList<fsEventData>();
        if (!Util.isBlank(string) && (list = this.itsEventNewFiles.get(string)) != null) {
            for (fsEventData fsEventData2 : list) {
                if (fsEventData2.isCompleted()) continue;
                arrayList.add(fsEventData2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processedNewFileEvent(String string, List<fsEventData> list) {
        if (list != null && list.size() > 0) {
            Map<String, List<fsEventData>> map = this.itsEventNewFiles;
            synchronized (map) {
                List<fsEventData> list2 = this.itsEventNewFiles.get(string);
                if (list2 != null) {
                    list2.removeAll(list);
                }
            }
        }
    }
}

