/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventNotificationBase;
import au.com.aemo.Common.JSON.JsonTransformManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Logging.Util_Logger;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.signalr.HubConnection;
import com.microsoft.signalr.HubConnectionBuilder;
import com.microsoft.signalr.TransportEnum;
import com.microsoft.signalr.TypeReference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsEventNotificationSignalR
extends fsEventNotificationBase {
    public static final String JSON_EVENT_TRANSFORM_ID = "signalr_event_transform";
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationSignalR.class);
    private String itsSignalRNotificationURL;
    private List<String> itsSubscribedEvents;
    private HubConnection hubConnection;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsEventNotificationSignalR(String string, String string2, List<String> list) {
        super(string);
        this.itsSignalRNotificationURL = string2;
        this.itsSubscribedEvents = list;
    }

    @Override
    public void start() {
        Util_Logger.info(logger, "Starting SignalR event notification on URL [" + this.itsSignalRNotificationURL + "]");
        this.hubConnection = HubConnectionBuilder.create((String)this.itsSignalRNotificationURL).withTransport(TransportEnum.LONG_POLLING).build();
        this.hubConnection.onClosed(exception -> {
            Util_Logger.errorNoRaise(logger, "Detected SignalR service disconnection for data source [" + this.getDataSourceId() + "]: " + exception.getMessage(), exception);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.info(logger, "Restarting SignalR service connection for data source [" + this.getDataSourceId() + "]");
            this.hubConnection.start();
        });
        Type type = new TypeReference<Map<String, String>>(){}.getType();
        try {
            for (String string : this.itsSubscribedEvents) {
                Util_Logger.info(logger, "Subscribing to SignalR event [" + string + "] for event source [" + this.getDataSourceId() + "]");
                this.hubConnection.on(string, map -> {
                    try {
                        Object object;
                        JsonTransformManager jsonTransformManager = JsonTransformManager.getInstance();
                        JsonObject jsonObject = jsonTransformManager.getTransform(this.getDataSourceId(), JSON_EVENT_TRANSFORM_ID);
                        if (jsonObject != null) {
                            object = JsonUtilities.getJsonObjectFromString(JsonUtilities.toJson(map));
                            JsonUtilities iterator = new JsonUtilities();
                            JsonObject jsonObject2 = iterator.transformJson((JsonObject)object, jsonObject, null);
                            map = (Map)JsonUtilities.fromJson((JsonElement)jsonObject2, type);
                        }
                        Util_Logger.info(logger, "Received new event [" + string + "] solution type with " + map.size() + " parameters");
                        for (Map.Entry entry : map.entrySet()) {
                            Util_Logger.info(logger, "     Param " + (String)entry.getKey() + " : " + (String)entry.getValue());
                        }
                        object = new fsEventData();
                        ((fsEventData)object).setEventId(string);
                        ((fsEventData)object).setDataSourceId(this.getDataSourceId());
                        for (Map.Entry entry : map.entrySet()) {
                            ((fsEventData)object).addEventParameter((String)entry.getKey(), (String)entry.getValue());
                        }
                        this.addNewFileEvent((fsEventData)object);
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error processing new signalR event: " + exception.getMessage(), exception);
                    }
                }, type);
            }
        }
        catch (Exception exception2) {
            Util_Logger.errorNoRaise(logger, "Unable to extract SignalR event subscriptions for data source [" + this.getDataSourceId() + "]" + exception2.getMessage(), exception2);
        }
        this.hubConnection.start().blockingAwait();
    }

    @Override
    public void stop() {
        if (this.hubConnection != null) {
            try {
                this.hubConnection.stop();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error stopping SignalR HubConnection for data source [" + this.getDataSourceId() + "]: " + exception.getMessage(), exception);
            }
        }
    }
}

