/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="File meta data is consumed by trusted code")
public class fsFileInfo {
    private static Logger logger = LoggerFactory.getLogger(fsFileInfo.class);
    private String Filename;
    private String Directory;
    private fsFileTypeEnum FileType;
    private Date ModifiedDate;
    private boolean ModifiedDateExact;
    private String Name;
    private String Extension;
    private Long Size;
    private String UniqueId;
    private fsFileLockInt LockData;
    private fsEventData EventData;
    private volatile boolean Completed = false;
    private volatile int ProcessAttempts;
    private Date EventReceivedDate = new Date();
    private fsTransactionMetaData TransactionMetaData = new fsTransactionMetaData();

    public fsFileInfo() {
    }

    public fsFileInfo(fsFileInfo fsFileInfo2) {
        this.Filename = fsFileInfo2.Filename;
        this.Directory = fsFileInfo2.Directory;
        this.FileType = fsFileInfo2.FileType;
        this.ModifiedDate = fsFileInfo2.ModifiedDate;
        this.ModifiedDateExact = fsFileInfo2.ModifiedDateExact;
        this.Name = fsFileInfo2.Name;
        this.Extension = fsFileInfo2.Extension;
        this.Size = fsFileInfo2.Size;
        this.EventData = fsFileInfo2.EventData;
        this.TransactionMetaData = fsFileInfo2.TransactionMetaData;
        this.EventReceivedDate = fsFileInfo2.EventReceivedDate;
        this.UniqueId = fsFileInfo2.UniqueId;
    }

    public fsFileInfo(File file) {
        this.setDirectory(file.getParent());
        this.setFilename(file.getName());
        if (file.exists()) {
            if (file.isFile()) {
                this.setFileType(fsFileTypeEnum.FILE);
            } else {
                this.setFileType(fsFileTypeEnum.DIRECTORY);
            }
        }
        this.setSize(file.length());
        this.setModifiedDate(new Date(file.lastModified()), true);
    }

    public String getFilename() {
        return this.Filename;
    }

    public void setFilename(String string) {
        this.Filename = string;
        int n = string.lastIndexOf(".");
        if (n < 0) {
            this.Name = string;
            this.Extension = null;
        } else {
            this.Name = string.substring(0, n);
            this.Extension = string.substring(n + 1, string.length());
        }
        if (Util.isBlank(this.getUniqueId())) {
            this.setUniqueId(string);
        }
    }

    public String getUniqueId() {
        return this.UniqueId;
    }

    public void setUniqueId(String string) {
        this.UniqueId = string;
    }

    public void setFileType(fsFileTypeEnum fsFileTypeEnum2) {
        this.FileType = fsFileTypeEnum2;
    }

    public boolean isDirectory() {
        return this.FileType == fsFileTypeEnum.DIRECTORY;
    }

    public Date getModifiedDate() {
        return this.ModifiedDate;
    }

    public boolean getModifiedDateExact() {
        return this.ModifiedDateExact;
    }

    public void setModifiedDate(Date date, boolean bl) {
        this.ModifiedDate = date;
        this.ModifiedDateExact = bl;
    }

    public String getDirectory() {
        return this.Directory;
    }

    public void setDirectory(String string) {
        this.Directory = string;
    }

    public String getExtension() {
        return this.Extension;
    }

    public String getName() {
        return this.Name;
    }

    public Long getSize() {
        return this.Size;
    }

    public void setSize(Long l) {
        this.Size = l;
    }

    public String getPath() {
        if (Util.isBlank(this.Directory)) {
            return this.Filename;
        }
        return this.Directory + "/" + this.Filename;
    }

    public fsFileLockInt getLockData() {
        return this.LockData;
    }

    public void setLockData(fsFileLockInt fsFileLockInt2) {
        this.LockData = fsFileLockInt2;
    }

    public fsEventData getEventData() {
        return this.EventData;
    }

    public void setEventData(fsEventData fsEventData2) {
        this.EventData = fsEventData2;
        this.EventReceivedDate = fsEventData2 != null ? fsEventData2.getEventDate() : null;
    }

    public boolean isCompleted() {
        return this.Completed;
    }

    public void setCompleted(boolean bl) {
        this.Completed = bl;
        if (this.EventData != null) {
            this.EventData.setCompleted();
        }
    }

    public boolean hasLock() {
        return this.LockData != null;
    }

    public boolean hasValidLock() {
        boolean bl = false;
        if (this.hasLock()) {
            bl = this.LockData.isValid();
        }
        return bl;
    }

    public boolean processWithLock() {
        boolean bl = false;
        if (this.LockData != null) {
            bl = this.LockData.implementsLock();
        }
        return bl;
    }

    public boolean canProcessLockCheck() {
        boolean bl = true;
        if (this.processWithLock()) {
            bl = this.hasValidLock();
        }
        return bl;
    }

    public void releaseLock() {
        if (this.LockData != null) {
            this.LockData.release();
            this.LockData = null;
        }
    }

    public int getProcessAttempts() {
        return this.ProcessAttempts;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Only one thread will ever be processing and increment this.ProcessAttempts")
    public void incrementProcessAttempts() {
        ++this.ProcessAttempts;
    }

    public fsTransactionMetaData getTransactionMetaData() {
        return this.TransactionMetaData;
    }

    public void setTransactionMetaData(fsTransactionMetaData fsTransactionMetaData2) {
        this.TransactionMetaData = fsTransactionMetaData2;
    }

    public Date getEventReceivedDate() {
        return this.EventReceivedDate;
    }

    public Map<String, String> getAPIHeaderValues() {
        Map<String, String> map = null;
        if (this.EventData != null) {
            map = this.EventData.getAPIHeaderValues();
        }
        return map;
    }

    public boolean isBusinessResponseCode(int n) {
        boolean bl = false;
        if (this.EventData != null) {
            bl = this.EventData.isBusinessResponseCode(n);
        }
        return bl;
    }

    public void addAPIHeaderValues(String string) throws ApplicationException {
        if (!Util.isBlank(string)) {
            List<String> list = Util.getList(string, ',');
            for (String string2 : list) {
                if (Util.isBlank(string2)) continue;
                int n = string2.indexOf(":");
                if (n > 0) {
                    fsEventData fsEventData2 = this.getEventData();
                    if (fsEventData2 == null) {
                        fsEventData2 = new fsEventData();
                        this.setEventData(fsEventData2);
                    }
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    String string5 = FileNameTokenResolver.process(string4, this);
                    Util_Logger.debug(logger, "Resolved API header value [" + string3 + "] to [" + string5 + "]");
                    fsEventData2.addAPIHeaderValues(string3, string5);
                    continue;
                }
                Util_Logger.error(logger, "Detected invalid API header value specification [" + string2 + "]");
            }
        }
    }

    public void addEventParameter(String string, String string2) {
        fsEventData fsEventData2 = this.getEventData();
        if (fsEventData2 == null) {
            fsEventData2 = new fsEventData();
            this.setEventData(fsEventData2);
        }
        fsEventData2.addEventParameter(string, string2);
    }

    public void processFilenameMask(String string) {
        if (!Util.isBlank(string)) {
            Matcher matcher;
            Pattern pattern = Pattern.compile(string, 2);
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = Pattern.compile("\\(\\?<(.+?)>.*?\\)").matcher(pattern.pattern());
            while (((Matcher)object).find()) {
                for (int i = 1; i <= ((Matcher)object).groupCount(); ++i) {
                    arrayList.add(((Matcher)object).group(i));
                }
            }
            object = this.getEventData();
            if (object == null) {
                object = new fsEventData();
                this.setEventData((fsEventData)object);
            }
            if ((matcher = pattern.matcher(this.getFilename())).matches()) {
                for (String string2 : arrayList) {
                    String string3 = matcher.group(string2);
                    Util_Logger.debug(logger, "Adding variable [" + string2 + "] = [" + string3 + "] derived from input filename mask");
                    ((fsEventData)object).addEventParameter(string2, string3);
                }
            } else {
                Util_Logger.info(logger, "Input file [" + this.getFilename() + "] does not match input filename mask, skipping variable evaluation");
            }
        }
    }
}

