/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameTokenResolver {
    private static Logger logger = LoggerFactory.getLogger(FileNameTokenResolver.class);

    public static String process(String string, fsFileInfo fsFileInfo2) throws ApplicationException {
        Object object;
        fsEventData fsEventData2;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (!Util.isBlank(fsFileInfo2.getName())) {
            treeMap.put("name", fsFileInfo2.getName());
        }
        if (!Util.isBlank(fsFileInfo2.getExtension())) {
            treeMap.put("ext", fsFileInfo2.getExtension());
        }
        if ((fsEventData2 = fsFileInfo2.getEventData()) != null) {
            if (fsEventData2.getAPIHeaderValues() != null) {
                object = fsEventData2.getAPIHeaderValues().entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    if (((String)entry.getValue()).contains("{") || ((String)entry.getValue()).contains("}")) continue;
                    treeMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (fsEventData2.getEventParameters() != null) {
                treeMap.putAll(fsEventData2.getEventParameters());
            }
        }
        if ((object = fsFileInfo2.getTransactionMetaData()) != null) {
            treeMap.putAll(((fsTransactionMetaData)object).getTransactionMetaData());
        }
        return FileNameTokenResolver.process(string, treeMap);
    }

    public static String process(String string) throws ApplicationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return FileNameTokenResolver.process(string, hashMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String process(String string, Map<String, String> map) throws ApplicationException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                hashMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            if (logger.isDebugEnabled()) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    Util_Logger.debug(logger, "Token resolver variable [" + (String)entry.getKey() + "] = [" + (String)entry.getValue() + "]");
                }
            }
            Iterator iterator = Pattern.compile("\\{(.+?)\\}");
            Matcher matcher = ((Pattern)((Object)iterator)).matcher(string);
            int n = 0;
            while (matcher.find()) {
                Object object;
                Object object2;
                String[] stringArray;
                String string2 = matcher.group(1);
                String string3 = null;
                if (string2.toLowerCase().startsWith("date:")) {
                    String string4;
                    stringArray = string2.split(":");
                    object2 = new Date();
                    if (stringArray.length > 2) {
                        if (!Util.isInteger(stringArray[1])) {
                            string4 = (String)hashMap.get(stringArray[1].toLowerCase());
                            if (string4 == null) throw new Exception("Missing filename token parameter [" + stringArray[1] + "]");
                            object2 = Util.strToDate(string4, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                        } else {
                            int n2 = Integer.parseInt(stringArray[1]);
                            object2 = Util.dateOffset((Date)object2, n2, 5);
                        }
                        if (stringArray.length == 4) {
                            int n3 = Integer.parseInt(stringArray[1]);
                            object2 = Util.dateOffset((Date)object2, n3, 5);
                        }
                    }
                    string4 = stringArray[stringArray.length - 1];
                    string3 = Util.dateToStr((Date)object2, string4);
                } else if (string2.toLowerCase().startsWith("split:")) {
                    stringArray = string2.split(":");
                    if (stringArray.length != 4) throw new Exception("Invalid split operation, expected split:{param}:{delim}:{position}");
                    object2 = (String)hashMap.get(stringArray[1].toLowerCase());
                    char c = stringArray[2].charAt(0);
                    object = Util.getColumns((String)object2, c);
                    int n4 = -1;
                    if (Util.isInteger(stringArray[3])) {
                        n4 = Integer.parseInt(stringArray[3]);
                    } else if (stringArray[3].equalsIgnoreCase("last")) {
                        n4 = ((String[])object).length - 1;
                    }
                    if (n4 < 0 || n4 >= ((String[])object).length) {
                        throw new Exception("Invalid split index [" + stringArray[3] + "] for value [" + (String)object2 + "] with delimiter [" + c + "]");
                    }
                    string3 = object[n4];
                } else if (string2.toLowerCase().startsWith("if:")) {
                    String string5;
                    stringArray = string2.split(":");
                    if (stringArray.length != 4) throw new Exception("Invalid if operation, expected if:{test variable/condition}:{value if true}:{value if false}");
                    if (stringArray[1].indexOf(61) > 0) {
                        String string6;
                        String string7;
                        object2 = Util.getColumns(stringArray[1], '=');
                        if (((String[])object2).length != 2) throw new Exception("Invalid if operation, expected if:{test variable}={test value}:{value if true}:{value if false}");
                        string5 = object2[0].toLowerCase();
                        object = Util.noNull((String)hashMap.get(string5));
                        string3 = ((String)object).equalsIgnoreCase(string7 = ((String)object2[1]).trim()) ? (hashMap.containsKey(string6 = stringArray[2].toLowerCase()) ? (String)hashMap.get(string6) : stringArray[2]) : (hashMap.containsKey(string6 = stringArray[3].toLowerCase()) ? (String)hashMap.get(string6) : stringArray[3]);
                    } else {
                        object2 = (String)hashMap.get(stringArray[1].toLowerCase());
                        string3 = Util.strToBoolean((String)object2) ? (hashMap.containsKey(string5 = stringArray[2].toLowerCase()) ? (String)hashMap.get(string5) : stringArray[2]) : (hashMap.containsKey(string5 = stringArray[3].toLowerCase()) ? (String)hashMap.get(string5) : stringArray[3]);
                    }
                } else if (string2.toLowerCase().startsWith("uppercase:")) {
                    stringArray = string2.split(":");
                    if (stringArray.length != 2) throw new Exception("Invalid uppercase operation, expected uppercase:{value}");
                    object2 = stringArray[1].toLowerCase();
                    string3 = ((String)(hashMap.containsKey(object2) ? (String)hashMap.get(object2) : object2)).toUpperCase();
                } else if (string2.toLowerCase().startsWith("lowercase:")) {
                    stringArray = string2.split(":");
                    if (stringArray.length != 2) throw new Exception("Invalid lowercase operation, expected lowercase:{value}");
                    object2 = stringArray[1].toLowerCase();
                    string3 = ((String)(hashMap.containsKey(object2) ? (String)hashMap.get(object2) : object2)).toLowerCase();
                } else {
                    string3 = (String)hashMap.get(string2.toLowerCase());
                }
                stringBuilder.append(string.substring(n, matcher.start()));
                if (string3 == null) {
                    stringBuilder.append(matcher.group(0));
                    Util_Logger.warning(logger, "Unable to resolve token [" + matcher.group(0) + "] in [" + string + "]");
                } else {
                    stringBuilder.append(string3);
                }
                n = matcher.end();
            }
            stringBuilder.append(string.substring(n, string.length()));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error resolving filename: " + exception.getMessage(), exception);
        }
        return stringBuilder.toString();
    }
}

