/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.JSON;

import au.com.aemo.Common.JSON.JsonTransformSpec;
import au.com.aemo.Common.JSON.JsonTree;
import au.com.aemo.Common.JSON.listContainer;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtilities {
    public static final String FIELDSET = "fieldset";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String VIA = "via";
    public static final String FOR_EACH = "forEach";
    public static final String JSON_ELEMENT_ID = "__Id";
    public static final String JSON_PARENT_ELEMENT_ID = "__ParentId";
    public static final String JSON_TRANSFORM = "__XFORM";
    public static final String VARIBALE_DATE = "date";
    private static final DateTimeFormatter jsonDateFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 8, true).appendZoneId().optionalStart().appendPattern("XXX").optionalEnd().optionalStart().appendPattern("X").optionalEnd().toFormatter();
    private static Logger logger = LoggerFactory.getLogger(JsonUtilities.class);
    private JsonTree itsTree = new JsonTree();

    private static Gson GsonBuilder() {
        return JsonUtilities.GsonBuilder(true);
    }

    private static Gson GsonBuilder(boolean bl) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        if (bl) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create();
    }

    public static String toJson(Object object) {
        Gson gson = JsonUtilities.GsonBuilder();
        return gson.toJson(object);
    }

    public static <T> String listToJson(List<T> list) {
        listContainer listContainer2 = new listContainer();
        listContainer2.list = list;
        Gson gson = JsonUtilities.GsonBuilder();
        return gson.toJson(listContainer2);
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        Gson gson = JsonUtilities.GsonBuilder();
        return (T)gson.fromJson(string, clazz);
    }

    public static <T> T fromJson(JsonElement jsonElement, Class<T> clazz) {
        Gson gson = JsonUtilities.GsonBuilder();
        return (T)gson.fromJson(jsonElement, clazz);
    }

    public static <T> T fromJson(String string, Type type) {
        Gson gson = JsonUtilities.GsonBuilder();
        return (T)gson.fromJson(string, type);
    }

    public static <T> T fromJson(JsonElement jsonElement, Type type) {
        Gson gson = JsonUtilities.GsonBuilder();
        return (T)gson.fromJson(jsonElement, type);
    }

    public static String getJsonMember(String string, String string2) {
        String string3 = null;
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)string);
        JsonElement jsonElement = jsonObject.get(string2);
        if (jsonElement != null) {
            string3 = jsonElement.getAsString();
        }
        return string3;
    }

    public static String getJsonObject(String string, String string2) {
        String string3 = null;
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)string);
        JsonElement jsonElement = jsonObject.get(string2);
        if (jsonElement != null) {
            string3 = jsonElement.toString();
        }
        return string3;
    }

    public static JsonObject getJsonObjectFromFile(String string) throws Exception {
        JsonObject jsonObject = null;
        try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(string, new String[0]));){
            jsonObject = (JsonObject)JsonParser.parseReader((Reader)bufferedReader);
        }
        return jsonObject;
    }

    public static JsonObject getJsonObjectFromString(String string) throws Exception {
        return (JsonObject)JsonParser.parseString((String)string);
    }

    public static JsonObject getJsonObjectFromStream(JsonReader jsonReader) {
        JsonObject jsonObject = (JsonObject)JsonParser.parseReader((JsonReader)jsonReader);
        return jsonObject;
    }

    public static void writeJsonObjectToFile(JsonObject jsonObject, String string, boolean bl) throws Exception {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string, new String[0]), new OpenOption[0]);){
            Gson gson = JsonUtilities.GsonBuilder(bl);
            gson.toJson((JsonElement)jsonObject, (Appendable)bufferedWriter);
            bufferedWriter.flush();
        }
    }

    public static String writeJsonObjectToString(JsonObject jsonObject, boolean bl) throws Exception {
        Gson gson = JsonUtilities.GsonBuilder(bl);
        return gson.toJson((JsonElement)jsonObject);
    }

    public static Date strToDate(String string) throws ParseException {
        LocalDateTime localDateTime = LocalDateTime.parse(string, jsonDateFormat);
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    private JsonObject denormaliseData(JsonObject jsonObject, JsonObject jsonObject2) {
        JsonObject jsonObject3 = new JsonObject();
        JsonObject jsonObject4 = jsonObject2;
        while (jsonObject4 != null) {
            if (jsonObject4.isJsonObject()) {
                JsonObject jsonObject5 = jsonObject4.getAsJsonObject();
                for (Map.Entry entry : jsonObject5.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive() || this.isInternalIndexingAttribute((String)entry.getKey())) continue;
                    jsonObject3.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
            jsonObject4 = this.itsTree.getParent(jsonObject4);
        }
        for (Object object : jsonObject.entrySet()) {
            if (!((JsonElement)object.getValue()).isJsonPrimitive()) continue;
            jsonObject3.add((String)object.getKey(), (JsonElement)object.getValue());
        }
        return jsonObject3;
    }

    private void buildTransformedObjectElement(JsonElement jsonElement, JsonTransformSpec jsonTransformSpec, JsonObject jsonObject, Map<String, Object> map) {
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            String string = jsonElement.getAsString();
            if (jsonTransformSpec.via != null) {
                try {
                    string = jsonTransformSpec.via.transformSourceValue(string, map);
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Invalid JSON transform: unable to transform [" + string + "] with type [" + jsonTransformSpec.via.type + "] and soourceFormat [" + jsonTransformSpec.via.sourceFormat + "] : " + exception.getMessage(), exception);
                    throw new IllegalArgumentException("Invalid JSON transform", exception);
                }
            }
            jsonObject.addProperty(jsonTransformSpec.to, string);
        }
    }

    private JsonArray getArrayElements(JsonElement jsonElement, JsonTransformSpec jsonTransformSpec) {
        JsonArray jsonArray = null;
        try {
            if (Util.isBlank(jsonTransformSpec.from)) {
                throw new IllegalArgumentException("Invalid JSON transform: missing from specification in forEach transform");
            }
            jsonArray = (JsonArray)JsonPath.read((Object)jsonElement, (String)jsonTransformSpec.from, (Predicate[])new Predicate[0]);
            if (jsonArray.size() == 0) {
                throw new IllegalArgumentException("Invalid JSON transform: unable to identify matching elements in forEach transform from [" + jsonTransformSpec.from + "] in source JSON");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid JSON transform: " + exception.getMessage(), exception);
        }
        return jsonArray;
    }

    private boolean isInternalIndexingAttribute(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase(JSON_ELEMENT_ID)) {
            bl = true;
        } else if (string.equalsIgnoreCase(JSON_PARENT_ELEMENT_ID)) {
            bl = true;
        }
        return bl;
    }

    private JsonObject buildTransformedObjectNode(JsonElement jsonElement, JsonTransformSpec jsonTransformSpec, Map<String, Object> map) {
        JsonArray jsonArray;
        JsonTransformSpec jsonTransformSpec22;
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        JsonObject jsonObject3 = jsonElement.getAsJsonObject();
        JsonObject jsonObject4 = this.itsTree.getParent(jsonObject3);
        if (jsonTransformSpec.includeParentFields) {
            jsonObject = this.denormaliseData(jsonObject2, jsonObject4);
            for (Object object : jsonObject.entrySet()) {
                jsonTransformSpec22 = null;
                if (jsonTransformSpec.fieldset != null) {
                    for (JsonTransformSpec jsonTransformSpec3 : jsonTransformSpec.fieldset) {
                        if (jsonTransformSpec3.from == null || !jsonTransformSpec3.from.equalsIgnoreCase((String)object.getKey())) continue;
                        jsonTransformSpec22 = jsonTransformSpec3;
                        break;
                    }
                }
                if (jsonTransformSpec22 != null) {
                    this.buildTransformedObjectElement((JsonElement)object.getValue(), jsonTransformSpec22, jsonObject2, map);
                    continue;
                }
                jsonObject2.add((String)object.getKey(), (JsonElement)object.getValue());
            }
        }
        jsonObject = new ArrayList();
        for (Object object : jsonObject3.entrySet()) {
            if (((JsonElement)object.getValue()).isJsonPrimitive()) {
                if (this.isInternalIndexingAttribute((String)object.getKey())) continue;
                jsonTransformSpec22 = null;
                if (jsonTransformSpec.fieldset != null) {
                    for (JsonTransformSpec jsonTransformSpec3 : jsonTransformSpec.fieldset) {
                        if (jsonTransformSpec3.from == null || !jsonTransformSpec3.from.equalsIgnoreCase((String)object.getKey())) continue;
                        jsonTransformSpec22 = jsonTransformSpec3;
                        break;
                    }
                }
                if (jsonTransformSpec22 != null) {
                    this.buildTransformedObjectElement((JsonElement)object.getValue(), jsonTransformSpec22, jsonObject2, map);
                    continue;
                }
                jsonObject.add(object);
                continue;
            }
            if (!((JsonElement)object.getValue()).isJsonArray() || jsonTransformSpec.fieldset == null) continue;
            jsonTransformSpec22 = null;
            jsonArray = jsonTransformSpec.fieldset.iterator();
            while (jsonArray.hasNext()) {
                JsonTransformSpec jsonTransformSpec3;
                jsonTransformSpec3 = jsonArray.next();
                if (jsonTransformSpec3.forEach == null || !jsonTransformSpec3.forEach.from.equalsIgnoreCase((String)object.getKey())) continue;
                jsonTransformSpec22 = jsonTransformSpec3.forEach;
                break;
            }
            if (jsonTransformSpec22 == null || (jsonArray = this.getArrayElements(jsonElement, jsonTransformSpec22)).size() <= 0) continue;
            this.buildTransformedObjectArray(jsonArray, jsonTransformSpec22, jsonObject2, map);
        }
        if (jsonTransformSpec.includeAllFields) {
            for (Object object : jsonObject) {
                jsonObject2.add((String)object.getKey(), (JsonElement)object.getValue());
            }
        }
        if (jsonTransformSpec.fieldset != null) {
            Object object = null;
            for (JsonTransformSpec jsonTransformSpec22 : jsonTransformSpec.fieldset) {
                if (jsonTransformSpec22.forEach != null) {
                    object = jsonTransformSpec22.forEach;
                    jsonArray = this.getArrayElements(jsonElement, (JsonTransformSpec)object);
                    if (jsonArray.size() <= 0) continue;
                    this.buildTransformedObjectArray(jsonArray, (JsonTransformSpec)object, jsonObject2, map);
                    continue;
                }
                if (jsonTransformSpec22.dynamic == null) continue;
                jsonArray = this.buildDerivedObject(jsonElement, jsonTransformSpec22, jsonObject2, map);
                jsonObject2.add(jsonTransformSpec22.to, (JsonElement)jsonArray);
            }
        }
        return jsonObject2;
    }

    private void buildTransformedObjectArray(JsonArray jsonArray, JsonTransformSpec jsonTransformSpec, JsonObject jsonObject, Map<String, Object> map) {
        Object object;
        JsonElement jsonElement2;
        JsonArray jsonArray2 = new JsonArray();
        for (JsonElement jsonElement2 : jsonArray) {
            JsonObject jsonObject2 = this.buildTransformedObjectNode(jsonElement2, jsonTransformSpec, map);
            jsonArray2.add((JsonElement)jsonObject2);
        }
        if (jsonTransformSpec.uniqueRecords) {
            object = new HashMap();
            jsonElement2 = new JsonArray();
            for (JsonElement jsonElement3 : jsonArray2) {
                if (object.containsKey(jsonElement3.toString())) continue;
                object.put(jsonElement3.toString(), jsonElement3);
                jsonElement2.add(jsonElement3);
            }
            jsonObject.add(jsonTransformSpec.to, jsonElement2);
        } else {
            jsonObject.add(jsonTransformSpec.to, (JsonElement)jsonArray2);
        }
        object = jsonObject.get(jsonTransformSpec.to);
        if (object != null) {
            jsonElement2 = object.getAsJsonArray();
            jsonElement2.addAll(jsonArray2);
        } else {
            jsonObject.add(jsonTransformSpec.to, (JsonElement)jsonArray2);
        }
    }

    private JsonElement buildDerivedObject(JsonElement jsonElement, JsonTransformSpec jsonTransformSpec, JsonObject jsonObject, Map<String, Object> map) {
        JsonElement jsonElement2 = null;
        if (jsonTransformSpec.forEach != null) {
            if (jsonTransformSpec.forEach.to == null) {
                throw new IllegalArgumentException("Invalid JSON transform, to property is required");
            }
            JsonArray jsonArray = this.getArrayElements(jsonElement, jsonTransformSpec.forEach);
            this.buildTransformedObjectArray(jsonArray, jsonTransformSpec.forEach, jsonObject, map);
        } else if (jsonTransformSpec.from != null) {
            if (jsonTransformSpec.to == null) {
                throw new IllegalArgumentException("Invalid JSON transform, to property is required");
            }
            JsonElement jsonElement3 = (JsonElement)JsonPath.read((Object)jsonElement, (String)jsonTransformSpec.from, (Predicate[])new Predicate[0]);
            String string = jsonElement3.getAsString();
            if (jsonTransformSpec.via != null) {
                try {
                    string = jsonTransformSpec.via.transformSourceValue(string, map);
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Invalid JSON transform: unable to transform [" + string + "] with type [" + jsonTransformSpec.via.type + "] and soourceFormat [" + jsonTransformSpec.via.sourceFormat + "] : " + exception.getMessage(), exception);
                    throw new IllegalArgumentException("Invalid JSON transform", exception);
                }
            }
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty(jsonTransformSpec.to, string);
            jsonElement2 = jsonObject2.get(jsonTransformSpec.to);
        } else if (jsonTransformSpec.dynamic != null) {
            JsonObject jsonObject3;
            if (jsonTransformSpec.to == null) {
                throw new IllegalArgumentException("Invalid JSON transform, to property is required");
            }
            String string = null;
            if (jsonTransformSpec.dynamic.toUpperCase().startsWith("DATE:")) {
                jsonObject3 = Util.getColumns(jsonTransformSpec.dynamic, ':');
                if (((String[])jsonObject3).length != 2) {
                    throw new IllegalArgumentException("Invalid JSON transform, missing date format for dynamic date transform");
                }
                Date date = (Date)map.get(VARIBALE_DATE);
                string = Util.dateToStr(date, jsonObject3[1]);
            } else if (jsonTransformSpec.dynamic.toUpperCase().startsWith("STRING:")) {
                if (jsonTransformSpec.dynamic.indexOf(":") < 0) {
                    throw new IllegalArgumentException("Invalid JSON transform, missing label for dynamic string transform");
                }
                if (jsonTransformSpec.dynamic.indexOf(":") == jsonTransformSpec.dynamic.length() - 1) {
                    throw new IllegalArgumentException("Invalid JSON transform, missing label for dynamic string transform");
                }
                string = jsonTransformSpec.dynamic.substring(jsonTransformSpec.dynamic.indexOf(":") + 1);
            } else if (map.containsKey(jsonTransformSpec.dynamic)) {
                string = map.get(jsonTransformSpec.dynamic).toString();
            } else {
                throw new IllegalArgumentException("Invalid JSON transform, unsupported dynamic variable [" + jsonTransformSpec.dynamic + "]");
            }
            jsonObject3 = new JsonObject();
            jsonObject3.addProperty(jsonTransformSpec.to, string);
            jsonElement2 = jsonObject3.get(jsonTransformSpec.to);
        } else {
            throw new IllegalArgumentException("Invalid JSON transform, either from or forEach properties are required");
        }
        return jsonElement2;
    }

    private void buildOutputObject(JsonObject jsonObject, String string, JsonElement jsonElement, JsonObject jsonObject2, Map<String, Object> map) {
        if (jsonElement.isJsonPrimitive()) {
            jsonObject2.add(string, jsonElement);
        } else if (jsonElement.isJsonObject()) {
            JsonObject jsonObject3 = new JsonObject();
            jsonObject2.add(string, (JsonElement)jsonObject3);
            this.buildTransformedObject(jsonObject, jsonElement.getAsJsonObject(), jsonObject3, map);
        }
    }

    private void buildOutputArray(JsonObject jsonObject, String string, JsonElement jsonElement, JsonArray jsonArray, Map<String, Object> map) {
        if (jsonElement.isJsonPrimitive()) {
            jsonArray.add(jsonElement);
        } else if (jsonElement.isJsonObject()) {
            JsonObject jsonObject2 = new JsonObject();
            jsonArray.add((JsonElement)jsonObject2);
            this.buildTransformedObject(jsonObject, jsonElement.getAsJsonObject(), jsonObject2, map);
        }
    }

    private void buildTransformedObject(JsonObject jsonObject, JsonObject jsonObject2, JsonObject jsonObject3, Map<String, Object> map) {
        for (Map.Entry entry : jsonObject2.entrySet()) {
            JsonTransformSpec jsonTransformSpec;
            String string = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (this.isInternalIndexingAttribute(string)) continue;
            if (jsonElement.isJsonPrimitive()) {
                Util_Logger.debug(logger, "Now processing attribute " + string);
            } else if (jsonElement.isJsonObject()) {
                Util_Logger.debug(logger, "Now processing element " + String.valueOf(jsonElement.getAsJsonObject().get(JSON_ELEMENT_ID)));
            }
            if (string.toUpperCase().startsWith(JSON_TRANSFORM)) {
                jsonTransformSpec = JsonUtilities.fromJson(jsonElement, JsonTransformSpec.class);
                JsonElement jsonElement2 = this.buildDerivedObject((JsonElement)jsonObject, jsonTransformSpec, jsonObject3, map);
                if (jsonTransformSpec.to == null) continue;
                jsonObject3.add(jsonTransformSpec.to, jsonElement2);
                continue;
            }
            if (jsonElement.isJsonArray()) {
                jsonTransformSpec = new JsonArray();
                jsonObject3.add(string, (JsonElement)jsonTransformSpec);
                jsonElement.getAsJsonArray().forEach(arg_0 -> this.lambda$buildTransformedObject$0(jsonObject, string, (JsonArray)jsonTransformSpec, map, arg_0));
                continue;
            }
            this.buildOutputObject(jsonObject, string, jsonElement, jsonObject3, map);
        }
    }

    public void walkJsonDocumentTree(JsonElement jsonElement, String string, JsonObject jsonObject, boolean bl) {
        block6: {
            String string2;
            block7: {
                string2 = jsonObject.get(JSON_ELEMENT_ID).getAsString();
                if (jsonElement == null) break block6;
                if (!jsonElement.isJsonObject()) break block7;
                for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
                    JsonElement jsonElement2 = (JsonElement)entry.getValue();
                    if (jsonElement2.isJsonObject()) {
                        String string3 = string2 + "." + (String)entry.getKey();
                        JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
                        jsonObject2.addProperty(JSON_PARENT_ELEMENT_ID, string2);
                        jsonObject2.addProperty(JSON_ELEMENT_ID, string3);
                        if (bl) {
                            this.itsTree.addNode(jsonObject2, (String)entry.getKey(), jsonObject);
                        }
                        this.walkJsonDocumentTree((JsonElement)jsonObject2, null, jsonObject2, bl);
                        continue;
                    }
                    if (!jsonElement2.isJsonArray()) continue;
                    this.walkJsonDocumentTree(jsonElement2, (String)entry.getKey(), jsonObject, bl);
                }
                break block6;
            }
            if (!jsonElement.isJsonArray()) break block6;
            int n = 0;
            for (JsonElement jsonElement3 : jsonElement.getAsJsonArray()) {
                if (jsonElement3.isJsonObject()) {
                    String string4 = string2 + "." + string + "[" + n + "]";
                    JsonObject jsonObject3 = jsonElement3.getAsJsonObject();
                    jsonObject3.addProperty(JSON_PARENT_ELEMENT_ID, string2);
                    jsonObject3.addProperty(JSON_ELEMENT_ID, string4);
                    if (bl) {
                        this.itsTree.addNode(jsonObject3, string + "[" + n + "]", jsonObject);
                    }
                    this.walkJsonDocumentTree((JsonElement)jsonObject3, null, jsonObject3, bl);
                }
                ++n;
            }
        }
    }

    public JsonObject transformJson(JsonObject jsonObject, JsonObject jsonObject2, Map<String, Object> map) throws Exception {
        JsonObject jsonObject3 = null;
        if (jsonObject2 == null) {
            return jsonObject;
        }
        try {
            JsonObject jsonObject4 = jsonObject.deepCopy();
            jsonObject4.addProperty(JSON_ELEMENT_ID, "$");
            this.walkJsonDocumentTree((JsonElement)jsonObject4, null, jsonObject4, true);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(VARIBALE_DATE, new Date());
            if (map != null) {
                hashMap.putAll(map);
            }
            jsonObject3 = new JsonObject();
            this.buildTransformedObject(jsonObject4, jsonObject2, jsonObject3, hashMap);
        }
        catch (Exception exception) {
            throw new Exception("Error transforming JSON: " + exception.getMessage(), exception);
        }
        return jsonObject3;
    }

    private /* synthetic */ void lambda$buildTransformedObject$0(JsonObject jsonObject, String string, JsonArray jsonArray, Map map, JsonElement jsonElement) {
        JsonObject jsonObject2 = jsonElement.getAsJsonObject();
        this.buildOutputArray(jsonObject, string, (JsonElement)jsonObject2, jsonArray, map);
    }
}

