/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Jobs;

import au.com.aemo.Common.Jobs.JobTaskInt;
import au.com.aemo.Common.Jobs.LockEngineInt;
import au.com.aemo.Common.Jobs.LockManagerConfig;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockEngineInternal
implements LockEngineInt {
    private static Logger logger = LoggerFactory.getLogger(LockEngineInternal.class);
    private volatile Map<String, JobTaskInt> itsTaskObjects = new HashMap<String, JobTaskInt>();
    private volatile Map<String, Thread> itsLockEntities = new HashMap<String, Thread>();
    private boolean PriorityBumpEnabled;

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="this method only called at initialisation")
    public void initialise(LockManagerConfig lockManagerConfig) {
        this.PriorityBumpEnabled = lockManagerConfig.PriorityBumpEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="Performance gains of EntrySet iterator are not material")
    public synchronized boolean addTask(String string, JobTaskInt jobTaskInt) {
        Util_Logger.debug(logger, "Lock Manager request for exclusive lock on " + string);
        boolean bl = false;
        Map<String, JobTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                if (this.itsLockEntities.get(string) == null) {
                    if (jobTaskInt == null) {
                        this.itsLockEntities.put(string, Thread.currentThread());
                        bl = true;
                    } else {
                        bl = true;
                        for (JobTaskInt object : this.itsTaskObjects.values()) {
                            if (object.getPriority() >= jobTaskInt.getPriority()) continue;
                            Util_Logger.debug(logger, "Lock Manager does not allow a priority " + jobTaskInt.getPriority() + " task (" + jobTaskInt.getFilename() + ") to start if a priority " + object.getPriority() + " (" + object.getFilename() + ") task is being processed");
                            bl = false;
                        }
                        if (bl) {
                            this.itsLockEntities.put(string, Thread.currentThread());
                            this.itsTaskObjects.put(string, jobTaskInt);
                            if (this.PriorityBumpEnabled) {
                                for (String string2 : this.itsTaskObjects.keySet()) {
                                    JobTaskInt jobTaskInt2;
                                    if (string2.equalsIgnoreCase(string) || (jobTaskInt2 = this.itsTaskObjects.get(string2)).getPriority() <= jobTaskInt.getPriority()) continue;
                                    Util_Logger.debug(logger, "Lock Manager sending bump signal to low priority task " + jobTaskInt2.getFilename());
                                    jobTaskInt2.setIsPriorityBumping(true);
                                }
                            }
                            jobTaskInt.setIsAllocated(true);
                            jobTaskInt.setIsPriorityBumped(false);
                            jobTaskInt.setIsPriorityBumping(false);
                            jobTaskInt.setPKViolationDetected(false);
                        }
                    }
                }
            }
        }
        if (bl) {
            Util_Logger.debug(logger, "Lock Manager accepted request for exclusive lock on " + string);
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLockEntities.size() + " entries");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteTask(String string) {
        Util_Logger.debug(logger, "Lock Manager release exclusive lock on " + string);
        Map<String, JobTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                JobTaskInt jobTaskInt = this.itsTaskObjects.get(string);
                if (jobTaskInt != null) {
                    jobTaskInt.setIsAllocated(false);
                }
                this.itsTaskObjects.remove(string);
                this.itsLockEntities.remove(string);
            }
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLockEntities.size() + " entries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="Performance gains of EntrySet iterator are not material")
    public void cleanQueue(Thread thread) {
        Map<String, JobTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                for (String string : this.itsLockEntities.keySet()) {
                    Thread thread2 = this.itsLockEntities.get(string);
                    if (!thread2.getName().equalsIgnoreCase(thread.getName())) continue;
                    this.deleteTask(string);
                    Util_Logger.warning(logger, "Removing file " + string + " from lock manager due to dead thread " + thread.getName(), null);
                }
            }
        }
    }
}

