/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidatorTypeFactory;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebParameterHelper {
    private static Logger logger = LoggerFactory.getLogger(WebParameterHelper.class);

    public static <T> T getParam(Map<String, String> map, WebParamValidationConfig webParamValidationConfig, Class<T> clazz) throws WebParamException {
        webParamValidationConfig.setType(clazz);
        String string = map.get(webParamValidationConfig.getName());
        if (Util.isBlank(string)) {
            string = !Util.isBlank(webParamValidationConfig.getDefaultValue()) ? webParamValidationConfig.getDefaultValue() : null;
        }
        return (T)WebParameterHelper.validateParam(string, webParamValidationConfig);
    }

    public static Object validateParam(String string, WebParamValidationConfig webParamValidationConfig) throws WebParamException {
        Object object = null;
        Util_Logger.debug(logger, "Validating parameter [" + webParamValidationConfig.getName() + "] with source [" + webParamValidationConfig.getSource() + "], type [" + webParamValidationConfig.getType().getName() + "], validator [" + webParamValidationConfig.getValidator().name() + "], mandatory [" + webParamValidationConfig.isMandatory() + "] with value [" + string + "]");
        if (string == null) {
            if (webParamValidationConfig.isMandatory()) {
                throw new WebParamException("Missing mandatory parameter [" + webParamValidationConfig.getSource() + "], aborting request");
            }
        } else {
            WebParamValidatorTypeFactory webParamValidatorTypeFactory = WebParamValidatorTypeFactory.getInstance();
            WebParamValidatorTypeInt webParamValidatorTypeInt = null;
            try {
                webParamValidatorTypeInt = webParamValidatorTypeFactory.getValidator(webParamValidationConfig.getType().getName());
            }
            catch (Exception exception) {
                throw new WebParamException("Unable to extract parameter validator [" + webParamValidationConfig.getName() + "], aborting request");
            }
            if (webParamValidatorTypeInt == null) {
                throw new WebParamException("Parameter validator for type [" + webParamValidationConfig.getType().getName() + "] is not supported, aborting request");
            }
            object = webParamValidatorTypeInt.validate(string, webParamValidationConfig);
        }
        return object;
    }
}

