/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebServer;
import au.com.aemo.Common.Web.WebServerCacheObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerCache {
    private static Logger logger = LoggerFactory.getLogger(WebServerCache.class);
    private Map<String, WebServerCacheObject> content = new ConcurrentHashMap<String, WebServerCacheObject>();

    private WebServerCache() {
    }

    public static WebServerCache getInstance() {
        return SingletonHolder.instance;
    }

    private String readHTMLwithSSI(File file) throws ApplicationException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            List<String> list = Files.readAllLines(file.toPath());
            int n = 0;
            for (String string : list) {
                String string2;
                String string3;
                ++n;
                boolean bl = true;
                String string4 = string.trim();
                if (string4.startsWith("<!--") && string4.endsWith("-->") && (string3 = (string2 = string4.substring(4, string4.length() - 3).trim()).toLowerCase()).startsWith("#include")) {
                    String[] stringArray;
                    string2 = string2.substring(8).trim();
                    if ((string3 = string3.substring(8).trim()).startsWith("pathtype") && (stringArray = string2.split("=")) != null) {
                        if (stringArray.length == 2) {
                            File file2 = new File(file.getParentFile(), stringArray[1].trim());
                            if (file2.isFile()) {
                                bl = false;
                                Util_Logger.info(logger, "Including content from " + file2.getPath());
                                stringBuilder.append(this.readHTMLwithSSI(file2));
                            } else {
                                Util_Logger.error(logger, "Error detected in SSI directive in HTML file " + file.getName() + " on line " + n + ", file " + stringArray[1].trim() + " not found");
                            }
                        } else {
                            Util_Logger.error(logger, "Error detected in SSI directive in HTML file " + file.getName() + " on line " + n);
                        }
                    }
                }
                if (!bl) continue;
                stringBuilder.append(string);
                stringBuilder.append("\r\n");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading HTML file with SSI: " + exception.getMessage(), exception);
        }
        return stringBuilder.toString();
    }

    private byte[] readFile(File file) throws IOException {
        byte[] byArray = null;
        if (file.getName().toLowerCase().endsWith(".html") && WebServer.getInstance().getConfig().WebDocumentEnableSSI.booleanValue()) {
            try {
                String string = this.readHTMLwithSSI(file);
                if (!Util.isBlank(string)) {
                    byArray = string.getBytes();
                }
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error parsing HTML file: " + exception.getMessage() + ", treating as plain HTML");
            }
        }
        if (byArray == null) {
            byArray = Files.readAllBytes(file.toPath());
        }
        return byArray;
    }

    public byte[] getContent(File file) throws IOException {
        byte[] byArray = null;
        WebServerCacheObject webServerCacheObject = this.content.get(file.getPath());
        if (webServerCacheObject != null && webServerCacheObject.Timestamp >= file.lastModified()) {
            byArray = webServerCacheObject.Data;
        }
        if (byArray == null) {
            byArray = this.readFile(file);
            if (WebServer.getInstance().getConfig().WebDocumentEnableCache.booleanValue()) {
                webServerCacheObject = new WebServerCacheObject();
                webServerCacheObject.Filename = file.getPath();
                webServerCacheObject.Data = byArray;
                webServerCacheObject.Timestamp = file.lastModified();
                this.content.put(file.getPath(), webServerCacheObject);
                Util_Logger.debug(logger, "Cached web content from [" + webServerCacheObject.Filename + "]");
            }
        }
        return byArray;
    }

    private static class SingletonHolder {
        private static WebServerCache instance = new WebServerCache();

        private SingletonHolder() {
        }
    }
}

