/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database;

import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.InstallPack;
import au.com.aemo.Pdr.Database.Config.Parameter;
import au.com.aemo.Pdr.Database.Engine.DatabasePackage;
import au.com.aemo.Pdr.Database.Engine.EngineProcessing;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import au.com.aemo.Pdr.Database.Providers.DbProviderManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrDataModelManager {
    private static Logger logger = LoggerFactory.getLogger(AppPdrDataModelManager.class);
    public static final String APP_NAME = "AppPdrDataModelManager";
    public static final String VERSION = "v1.2.0";

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Options options = new Options();
        options.addOption("u", "user", true, "The database username");
        options.addOption("p", "password", true, "The database password");
        options.addRequiredOption("d", "database", true, "Oracle|SQLServer|mySQL|postgreSQL");
        options.addRequiredOption("u", "url", true, "The JDBC database URL");
        options.addRequiredOption("k", "package", true, "The database update package to apply");
        options.addOption("a", "apply", false, "Set this option to apply the changes to the database");
        options.addOption("o", "options", true, "The set of options to apply. Specified as a comma delimited list");
        options.addOption("su", "system_user", true, "The database system account username");
        options.addOption("sp", "system_password", true, "The database system account password");
        options.addOption("t", "tablespace_dir", true, "The directory to create Oracle tablespaces in");
        options.addOption("w", "working_dir", true, "The working directory to extract scripts to");
        options.addOption("sm", "schema_management", true, "The database schema containing the pdrLoader PDR_* management tables");
        options.addOption("sdm", "schema_data_model", true, "The database schema for the data model installation");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            object3 = new HelpFormatter();
            object3.printHelp(APP_NAME, options);
            System.exit(1);
        }
        String string = commandLine.getOptionValue("user", null);
        object3 = commandLine.getOptionValue("password", null);
        DatabaseType databaseType = null;
        String string2 = commandLine.getOptionValue("database").toUpperCase().trim();
        try {
            databaseType = DatabaseType.valueOf(string2);
        }
        catch (Exception exception) {
            System.err.println("Invalid database option: " + string2);
            object2 = new HelpFormatter();
            object2.printHelp(APP_NAME, options);
            System.exit(1);
        }
        String string3 = commandLine.getOptionValue("url");
        object2 = commandLine.getOptionValue("package");
        boolean bl = commandLine.hasOption("apply");
        String string4 = commandLine.getOptionValue("system_user", null);
        String string5 = commandLine.getOptionValue("system_password", null);
        String string6 = commandLine.getOptionValue("tablespace_dir", null);
        String string7 = commandLine.getOptionValue("working_dir", null);
        String string8 = commandLine.getOptionValue("schema_management", null);
        String string9 = commandLine.getOptionValue("schema_data_model", null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!Util.isBlank(string)) {
            hashMap.put("DATABASE_USER", string);
        }
        if (!Util.isBlank((String)object3)) {
            hashMap.put("DATABASE_PASSWORD", (String)object3);
        }
        if (!Util.isBlank(string6)) {
            hashMap.put("TABLESPACE_DIR", string6);
            object = string6.contains("/") ? "/" : "\\";
            hashMap.put("PATH_SEP", (String)object);
        }
        try {
            boolean bl2;
            InstallPack installPack2;
            object = ConfigManager.getInstance();
            ((ConfigManager)object).loadConfig((String)object2, string7);
            DatabaseSchemaConfig databaseSchemaConfig = ((ConfigManager)object).getConfig();
            if (!Util.isBlank(string8)) {
                databaseSchemaConfig.SchemaManagementTables = string8;
            }
            if (!Util.isBlank(string9)) {
                databaseSchemaConfig.SchemaDataModelTables = string9;
            }
            EngineProcessing engineProcessing = new EngineProcessing();
            engineProcessing.addDefaultParameters(databaseSchemaConfig, hashMap);
            DatabaseConfig databaseConfig = null;
            if (!Util.isBlank(string) && !Util.isBlank((String)object3)) {
                databaseConfig = new DatabaseConfig();
                databaseConfig.User = string;
                databaseConfig.Password = object3;
                databaseConfig.PasswordEncrypted = false;
                databaseConfig.URL = string3;
                databaseConfig.DefaultSchema = string9;
            }
            DatabaseConfig databaseConfig2 = null;
            if (!Util.isBlank(string4) && !Util.isBlank(string5)) {
                databaseConfig2 = new DatabaseConfig();
                databaseConfig2.User = string4;
                databaseConfig2.Password = string5;
                databaseConfig2.PasswordEncrypted = false;
                databaseConfig2.URL = string3;
            }
            DbProviderManager dbProviderManager = DbProviderManager.getInstance();
            dbProviderManager.setConfig(APP_NAME, VERSION, databaseConfig, databaseConfig2);
            DbProviderInt dbProviderInt = DbProviderManager.getInstance().getProvider(databaseType);
            DbManager.setDbHandler(dbProviderInt.getHandler(dbProviderInt.getHandlerPrimaryIsSystem()));
            List<Object> list2 = new ArrayList();
            List<InstallPack> list3 = engineProcessing.identifyInstallPackOptions(databaseSchemaConfig, dbProviderInt);
            if (commandLine.hasOption("options")) {
                list2 = Arrays.asList(Util.getColumns(commandLine.getOptionValue("options"), ','));
            } else {
                Util_Logger.info(logger, "Install options not specified, applying all packs within database package as a default");
                for (InstallPack object5 : list3) {
                    list2.add(object5.Name);
                }
            }
            boolean bl22 = true;
            for (String string10 : list2) {
                boolean loggerContext = false;
                for (InstallPack installPack2 : list3) {
                    if (!installPack2.Name.equalsIgnoreCase(string10)) continue;
                    loggerContext = true;
                }
                if (loggerContext) continue;
                Util_Logger.warning(logger, "Detected invalid install option [" + string10 + "]");
                bl22 = false;
            }
            if (!bl22) {
                Util_Logger.errorNoRaise(logger, "Detected invalid install options, aborting database package operation");
                System.exit(-1);
            }
            if (engineProcessing.identifyIfUserOptionSelected(databaseSchemaConfig, list2) && databaseConfig == null) {
                Util_Logger.errorNoRaise(logger, "Missing parameters [user,password] required for install option requiring user privileges");
                System.exit(1);
            }
            if (engineProcessing.identifyIfAdministratorOptionSelected(databaseSchemaConfig, list2) && databaseConfig2 == null) {
                Util_Logger.errorNoRaise(logger, "Missing parameters [system_user,system_password] required for install option requiring administrator privileges");
                System.exit(1);
            }
            Util_Logger.info(logger, "Validating database target");
            if (!engineProcessing.validateTarget(databaseSchemaConfig, dbProviderInt, hashMap, list2)) {
                Util_Logger.error(logger, "Detected invalid database target, aborting database package operation");
                System.exit(-1);
            }
            boolean bl3 = true;
            List<Parameter> list = engineProcessing.identifyParameters(databaseSchemaConfig, dbProviderInt, hashMap);
            if (list != null) {
                for (Parameter parameter : list) {
                    if (hashMap.get(parameter.Name) != null) continue;
                    if (parameter.HasDefault) {
                        Util_Logger.info(logger, "Using default value for parameter [" + parameter.Name + "]");
                        continue;
                    }
                    Util_Logger.errorNoRaise(logger, "Detected missing parameter [" + parameter.Name + "]");
                    bl2 = false;
                }
            }
            if (!bl2) {
                Util_Logger.error(logger, "Detected missing parameters, aborting database package operation");
                System.exit(-1);
            }
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration configuration = loggerContext.getConfiguration();
            installPack2 = PatternLayout.newBuilder();
            installPack2.withPattern("[%-5level] %d{yyyy-MM-dd HH:mm:ss.SSS} [%t] %c{1} - %msg%n");
            FileAppender fileAppender = ((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("file")).withFileName(databaseSchemaConfig.getOutputFolder() + File.separatorChar + "dataModelManager.log").setLayout((Layout)installPack2.build())).build();
            fileAppender.start();
            LoggerConfig loggerConfig = configuration.getLoggerConfig("");
            loggerConfig.addAppender((Appender)fileAppender, Level.ALL, null);
            DatabasePackage databasePackage = engineProcessing.processChanges(databaseSchemaConfig, dbProviderInt, hashMap, list2);
            if (bl) {
                engineProcessing.applyChanges(databaseSchemaConfig, dbProviderInt, databasePackage);
            } else if (databasePackage.getGeneratedSQL().size() > 0) {
                Util_Logger.info(logger, "Please apply scripts manually");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected error: " + exception.getMessage(), exception);
            System.exit(-1);
        }
    }
}

