/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Engine;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbScriptRunner;
import au.com.aemo.Common.Java.ObjectUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Pdr.Database.Config.Artefact;
import au.com.aemo.Pdr.Database.Config.Change;
import au.com.aemo.Pdr.Database.Config.Check;
import au.com.aemo.Pdr.Database.Config.CheckAction;
import au.com.aemo.Pdr.Database.Config.CheckType;
import au.com.aemo.Pdr.Database.Config.DBSQL;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.InstallPack;
import au.com.aemo.Pdr.Database.Config.LoaderConfig;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportAuditSummary;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportRecordMapping;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportRecords;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportTypeConfig;
import au.com.aemo.Pdr.Database.Config.Parameter;
import au.com.aemo.Pdr.Database.Config.Script;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Config.Variable;
import au.com.aemo.Pdr.Database.Engine.DatabasePackage;
import au.com.aemo.Pdr.Database.Engine.EngineBase;
import au.com.aemo.Pdr.Database.Engine.EngineGeneratedSQLScript;
import au.com.aemo.Pdr.Database.Engine.LoaderConfigManager;
import au.com.aemo.Pdr.Database.Engine.ScriptManager;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineProcessing
extends EngineBase {
    private final Pattern REGEX_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+\\\"?(?<table>\\w+)", 2);
    private static Logger logger = LoggerFactory.getLogger(EngineProcessing.class);

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Is populated via XML serialisation")
    private boolean performCheck(DbProviderInt dbProviderInt, Map<String, String> map, List<String> list, Check check, boolean bl, String string, String string2, ScriptManager scriptManager) throws Exception {
        boolean bl2 = false;
        DbHandler dbHandler = dbProviderInt.getHandler(bl);
        if (check.DBSQL != null) {
            if (this.checkSchemaExists(dbProviderInt, bl)) {
                try (Connection connection = dbHandler.getConnection();){
                    for (DBSQL dBSQL : check.DBSQL) {
                        if (!dBSQL.isRelevant(dbProviderInt)) continue;
                        Util_Logger.info(logger, "Performing " + String.valueOf((Object)check.Type) + " check with SQL statement");
                        String string3 = dbProviderInt.processSQLParameters(dBSQL.SQL, map, dBSQL.SQL);
                        Util_Logger.debug(logger, "Executing SQL: " + string3);
                        Statement statement = connection.createStatement();
                        try {
                            ResultSet resultSet = statement.executeQuery(string3);
                            try {
                                if (resultSet.next()) {
                                    bl2 = check.Type == CheckType.EXISTS;
                                    continue;
                                }
                                bl2 = check.Type == CheckType.DOES_NOT_EXIST;
                            }
                            finally {
                                if (resultSet == null) continue;
                                resultSet.close();
                            }
                        }
                        finally {
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                }
            }
            Util_Logger.debug(logger, "Skipping SQL check as schema does not exist");
            bl2 = true;
        } else if (!Util.isBlank(check.Mapping)) {
            if (this.checkSchemaExists(dbProviderInt, bl)) {
                try (Connection connection = dbHandler.getConnection();){
                    Util_Logger.info(logger, "Performing " + String.valueOf((Object)check.Type) + " check for pdrLoader mapping");
                    String string4 = dbHandler.getTableReference(string, "PDR_REPORT_RECORDS");
                    if (dbHandler.checkTableExists(connection, string, "PDR_REPORT_RECORDS")) {
                        String string5 = "Select 1 from " + string4 + " where DESTINATION_TABLE = '" + check.Mapping.toUpperCase() + "'";
                        Util_Logger.debug(logger, "Executing SQL: " + string5);
                        try (Statement statement = connection.createStatement();
                             ResultSet resultSet = statement.executeQuery(string5);){
                            if (resultSet.next()) {
                                bl2 = check.Type == CheckType.EXISTS;
                            }
                            bl2 = check.Type == CheckType.DOES_NOT_EXIST;
                        }
                    }
                    scriptManager.addWarning("Please apply " + check.Description);
                    Util_Logger.warning(logger, "Skipping mapping check as table [" + string4 + "] does not exist");
                    bl2 = true;
                }
            } else {
                Util_Logger.debug(logger, "Skipping mapping check as schema does not exist");
                bl2 = true;
            }
        } else if (!Util.isBlank(check.Column)) {
            Util_Logger.info(logger, "Performing " + String.valueOf((Object)check.Type) + " check for " + check.Table + "." + check.Column + (String)(check.Length != null ? " length " + check.Length : ""));
            if (this.checkSchemaExists(dbProviderInt, bl)) {
                try (Connection connection = dbHandler.getConnection();){
                    boolean bl3 = false;
                    Map<String, DbHandlerField> map2 = dbHandler.getColumnList(connection, string2, check.Table);
                    if (map2.containsKey(check.Column)) {
                        bl3 = check.Length != null ? check.Length.intValue() == map2.get(check.Column).getDataLength() : true;
                    }
                    boolean bl4 = bl3 = bl3 || list.contains(check.Table);
                    if (bl3) {
                        bl2 = check.Type == CheckType.EXISTS;
                    }
                    bl2 = check.Type == CheckType.DOES_NOT_EXIST;
                }
            } else {
                bl2 = list.contains(check.Table) == (check.Type == CheckType.EXISTS);
            }
        } else if (!Util.isBlank(check.Table)) {
            Util_Logger.info(logger, "Performing " + String.valueOf((Object)check.Type) + " check for " + check.Table + (check.PrimaryKey != null ? " PK definition" : ""));
            if (this.checkSchemaExists(dbProviderInt, bl)) {
                try (Connection connection = dbHandler.getConnection();){
                    boolean bl5 = false;
                    if (dbHandler.checkTableExists(connection, string2, check.Table)) {
                        if (!Util.isBlank(check.PrimaryKey)) {
                            List<String> list2 = dbHandler.getPkList(connection, string2, check.Table);
                            List<String> list3 = Util.getList(check.PrimaryKey, ',');
                            if (list2 != null) {
                                if (list3 != null && list2.size() == list3.size()) {
                                    bl5 = true;
                                    for (int i = 0; i < list2.size(); ++i) {
                                        String string6 = list2.get(i).trim();
                                        String string7 = list3.get(i).trim();
                                        bl5 = bl5 && string6.equalsIgnoreCase(string7);
                                    }
                                }
                            } else if (list3 == null) {
                                bl5 = true;
                            } else if (list3.size() == 0) {
                                bl5 = true;
                            }
                        } else {
                            bl5 = true;
                        }
                    }
                    boolean bl6 = bl5 = bl5 || list.contains(check.Table);
                    if (bl5) {
                        bl2 = check.Type == CheckType.EXISTS;
                    }
                    bl2 = check.Type == CheckType.DOES_NOT_EXIST;
                }
            } else {
                bl2 = list.contains(check.Table) == (check.Type == CheckType.EXISTS);
            }
        }
        Util_Logger.info(logger, "Status of check [" + check.Description + "] is " + (bl2 ? "PASS" : "FAILED"));
        if (!bl2 && scriptManager != null && check.Action == CheckAction.ERROR) {
            scriptManager.addFailedCheck(check.Description + " " + String.valueOf((Object)check.Type));
        }
        return bl2;
    }

    private boolean runScript(final DbProviderInt dbProviderInt, Connection connection, Reader reader, DbHandler dbHandler, Boolean bl, boolean bl2, boolean bl3) throws Exception {
        boolean bl4 = false;
        try {
            DbScriptRunner dbScriptRunner = new DbScriptRunner(connection, false, true){

                @Override
                public void executeCommandLog(String string) {
                    Util_Logger.info(logger, string);
                }

                @Override
                public void executeResponseLog(String string, int n) {
                    String string2 = dbProviderInt.getDatabaseResponse(string, n);
                    if (!Util.isBlank(string2)) {
                        Util_Logger.info(logger, string2);
                    }
                }
            };
            String string = dbHandler.getScriptDelimiter();
            if (!Util.isBlank(string)) {
                dbScriptRunner.setFullLineDelimiter(string);
            }
            dbScriptRunner.setCodeBlock(dbHandler.getCodeBlockDeclare(), dbHandler.getCodeBlockBegin(), dbHandler.getCodeBlockEnd());
            dbScriptRunner.setIgnorePKViolations(bl2);
            dbScriptRunner.setDebug(bl3);
            if (bl != null) {
                dbScriptRunner.setAutoCommit(bl);
            }
            dbScriptRunner.runScript(reader);
            bl4 = true;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error executing script: " + exception.getMessage(), exception);
        }
        return bl4;
    }

    private boolean runScript(DbProviderInt dbProviderInt, Connection connection, DbHandler dbHandler, String string, boolean bl) throws Exception {
        if (bl) {
            try (FileReader fileReader = new FileReader(string);){
                this.runScript(dbProviderInt, connection, fileReader, dbHandler, false, true, true);
            }
        }
        try (StringReader stringReader = new StringReader(string);){
            this.runScript(dbProviderInt, connection, stringReader, dbHandler, false, true, true);
        }
        return true;
    }

    private void analyseSQLForNewTables(String string, List<String> list) {
        Matcher matcher = this.REGEX_CREATE_TABLE.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group("table").toUpperCase().trim();
            if (list.contains(string2)) continue;
            list.add(string2);
        }
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    private void applyArtefact(Connection connection, DbHandler dbHandler, DbProviderInt dbProviderInt, String string, Artefact artefact, Map<String, String> map, PrintWriter printWriter, List<String> list) throws Exception {
        Object object;
        if (artefact.Scripts != null) {
            for (Script object2 : artefact.Scripts) {
                if (!object2.isRelevant(dbProviderInt)) continue;
                object = new ArrayList();
                if (object2.Variables != null) {
                    for (Variable variable : object2.Variables.values()) {
                        if (map.containsKey(variable.Script)) continue;
                        object.add(variable);
                    }
                }
                HashMap hashMap = new HashMap();
                hashMap.putAll(map);
                if (object.size() > 0) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Variable variable = (Variable)iterator.next();
                        Util_Logger.debug(logger, "Deriving value of " + variable.Script + " with SQL : " + variable.DefaultSQL);
                        Statement statement = connection.createStatement();
                        try (ResultSet resultSet = statement.executeQuery(variable.DefaultSQL);){
                            while (resultSet.next()) {
                                Util_Logger.debug(logger, "Derived parameter " + variable.Script + " is " + resultSet.getString(1));
                                hashMap.put(variable.Script, resultSet.getString(1));
                            }
                        }
                        finally {
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                }
                String string2 = dbProviderInt.processScript(string, object2, hashMap, printWriter);
                this.analyseSQLForNewTables(string2, list);
            }
        }
        if (artefact.Schema != null) {
            for (Table table : artefact.Schema.Tables) {
                Util_Logger.info(logger, "Preparing schema changes to table " + table.Name + " to database");
                object = dbProviderInt.generateSQL(table, connection, dbHandler);
                printWriter.printf("/* Changes for table %s */\n", table.Name);
                printWriter.println();
                printWriter.println((String)object);
                printWriter.println();
                this.analyseSQLForNewTables((String)object, list);
            }
        }
    }

    public boolean validateTarget(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, Map<String, String> map, List<String> list) throws Exception {
        Object object;
        Object object2;
        Object object3;
        DbHandler dbHandler;
        DbHandler dbHandler2;
        Object object4;
        boolean bl = false;
        DbHandler dbHandler3 = dbProviderInt.getHandler(true);
        if (dbHandler3 != null) {
            try {
                object4 = dbHandler3.getConnection();
                try {
                    Util_Logger.info(logger, "Successfully validated database credentials for system");
                }
                finally {
                    if (object4 != null) {
                        object4.close();
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("Invalid database credentials for system: " + exception.getMessage());
            }
        }
        object4 = null;
        if (!list.contains("Create Schema/apply grants") && (dbHandler2 = dbProviderInt.getHandler(false)) != null) {
            dbHandler = ObjectUtilities.deepClone(dbHandler2);
            dbHandler.setDefaultSchema(null);
            try {
                object3 = dbHandler.getConnection();
                try {
                    Util_Logger.info(logger, "Successfully validated database credentials for Data Model schema");
                    try (Statement statement = object3.createStatement();){
                        object2 = "select " + dbHandler.getCurrentSchema() + " " + dbHandler.getNoTable();
                        object = statement.executeQuery((String)object2);
                        try {
                            while (object.next()) {
                                object4 = object.getString(1);
                            }
                        }
                        finally {
                            if (object != null) {
                                object.close();
                            }
                        }
                    }
                }
                finally {
                    if (object3 != null) {
                        object3.close();
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("Invalid database credentials for Data Model schema: " + exception.getMessage());
            }
        }
        boolean bl2 = dbProviderInt.getHandlerPrimaryIsSystem();
        dbHandler = dbProviderInt.getHandler(bl2);
        object3 = ObjectUtilities.deepClone(dbHandler);
        ((DbHandler)object3).setDefaultSchema(null);
        boolean bl3 = false;
        object2 = ((DbHandler)object3).getConnection();
        try {
            String string;
            object = databaseSchemaConfig.SchemaDataModelTables;
            if (!Util.isBlank((String)object)) {
                Util_Logger.info(logger, "Checking access to schema [" + (String)object + "] for data model tables");
                try {
                    if (!((DbHandler)object3).checkSchemaExists((Connection)object2, (String)object)) {
                        throw new Exception("Invalid schema for Data Model tables [" + (String)object + "] or insufficient permissions");
                    }
                    Util_Logger.info(logger, "Successfully validated schema for Data Model tables [" + (String)object + "]");
                }
                catch (Exception exception) {
                    throw new Exception("Invalid schema for Data Model tables [" + (String)object + "] or insufficient permissions");
                }
                if (Util.isBlank(databaseSchemaConfig.SchemaManagementTables)) {
                    databaseSchemaConfig.SchemaManagementTables = Util.isBlank((String)object4) ? dbProviderInt.getUser(true) : object4;
                    bl3 = true;
                    Util_Logger.info(logger, "Setting schema for management tables to [" + databaseSchemaConfig.SchemaManagementTables + "]");
                }
            }
            if (!Util.isBlank(string = databaseSchemaConfig.SchemaManagementTables) && !bl3) {
                Util_Logger.info(logger, "Checking access to " + string + ".PDR_REPORT_RECORDS");
                try (Statement statement = object2.createStatement();){
                    String string2 = "update " + string + ".PDR_REPORT_RECORDS set IS_ACTIVE = IS_ACTIVE";
                    statement.executeUpdate(string2);
                    object2.rollback();
                    Util_Logger.info(logger, "Successfully validated access to " + string + ".PDR_REPORT_RECORDS");
                }
                catch (Exception exception) {
                    throw new Exception("Invalid schema for PDR_* management tables [" + string + "] or insufficient permissions");
                }
            }
            if (databaseSchemaConfig.Package.Prerequisites != null) {
                int n = 0;
                bl = true;
                Util_Logger.info(logger, "Checking preconditions for Package " + databaseSchemaConfig.Package.Description);
                Util_Logger.debug(logger, "Schema for Data Model tables is " + databaseSchemaConfig.SchemaDataModelTables);
                for (Check check : databaseSchemaConfig.Package.Prerequisites) {
                    Util_Logger.info(logger, "Prerequisite check " + ++n + " of " + databaseSchemaConfig.Package.Prerequisites.size());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    boolean bl4 = this.performCheck(dbProviderInt, map, arrayList, check, bl2, databaseSchemaConfig.SchemaManagementTables, databaseSchemaConfig.SchemaDataModelTables, null);
                    if (check.Action != CheckAction.ERROR) continue;
                    bl = bl && bl4;
                }
            } else {
                bl = true;
                Util_Logger.info(logger, "Detected no prerequisite checks for Package " + databaseSchemaConfig.Package.Description);
            }
        }
        finally {
            if (object2 != null) {
                object2.close();
            }
        }
        if (!bl) {
            throw new Exception("Failed prerequisite checks for Package " + databaseSchemaConfig.Package.Description + ", package is not relevant to this database instance");
        }
        return bl;
    }

    private String getAuditTable(DatabaseSchemaConfig databaseSchemaConfig) {
        if (databaseSchemaConfig.Package.Data_Model.equalsIgnoreCase("MMSDM")) {
            return "MMS_DATA_MODEL_AUDIT";
        }
        if (databaseSchemaConfig.Package.Data_Model.equalsIgnoreCase("GASDM")) {
            return "GAS_DATA_MODEL_AUDIT";
        }
        return null;
    }

    private String getChangeNoticeColumn(DatabaseSchemaConfig databaseSchemaConfig) {
        if (databaseSchemaConfig.Package.Data_Model.equalsIgnoreCase("MMSDM")) {
            return "NEM_CHANGE_NOTICE";
        }
        if (databaseSchemaConfig.Package.Data_Model.equalsIgnoreCase("GASDM")) {
            return "GAS_CHANGE_NOTICE";
        }
        return null;
    }

    private boolean preChangeOperation(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, Change change, List<String> list, PrintWriter printWriter) throws Exception {
        boolean bl = false;
        String string = this.getAuditTable(databaseSchemaConfig);
        String string2 = this.getChangeNoticeColumn(databaseSchemaConfig);
        if (string != null) {
            DbHandler dbHandler = dbProviderInt.getHandler(false);
            try {
                Object object;
                boolean bl2 = false;
                boolean bl3 = false;
                for (String string3 : list) {
                    if (!string3.equalsIgnoreCase(string)) continue;
                    bl3 = true;
                }
                if (!bl3 && this.checkSchemaExists(dbProviderInt, false)) {
                    object = dbHandler.getConnection();
                    try {
                        bl2 = dbHandler.checkTableExists((Connection)object, databaseSchemaConfig.SchemaDataModelTables, string);
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                if (!bl2 && !bl3) {
                    Util_Logger.warning(logger, "Skipping pre-change script generation as " + string + " is missing");
                } else {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("INSERT INTO ");
                    ((StringBuilder)object).append(dbHandler.getTableReference(databaseSchemaConfig.SchemaDataModelTables, string));
                    ((StringBuilder)object).append(" (INSTALLATION_DATE,");
                    ((StringBuilder)object).append(databaseSchemaConfig.Package.Data_Model);
                    ((StringBuilder)object).append("_VERSION,INSTALL_TYPE,SCRIPT_VERSION,");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(",PROJECT_TITLE,USERNAME,STATUS) values (");
                    ((StringBuilder)object).append(dbHandler.getSqlDate(this.InstallationDate));
                    ((StringBuilder)object).append(",'");
                    ((StringBuilder)object).append(change.Id);
                    ((StringBuilder)object).append("','");
                    ((StringBuilder)object).append(databaseSchemaConfig.Package.Type);
                    ((StringBuilder)object).append("','");
                    ((StringBuilder)object).append(change.ScriptVersion);
                    ((StringBuilder)object).append("','");
                    ((StringBuilder)object).append(change.ChangeNotice);
                    ((StringBuilder)object).append("','");
                    ((StringBuilder)object).append(change.Description);
                    ((StringBuilder)object).append("',");
                    ((StringBuilder)object).append(dbHandler.getCurrentUser());
                    ((StringBuilder)object).append(",'STARTED');");
                    printWriter.print("/* Change ");
                    printWriter.print(change.Id);
                    printWriter.println(" pre-change operation */");
                    printWriter.println(((StringBuilder)object).toString());
                    printWriter.println();
                    bl = true;
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error generating pre-alter SQL: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    private boolean postChangeOperation(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, Change change, List<String> list, boolean bl, PrintWriter printWriter) throws Exception {
        boolean bl2 = false;
        String string = this.getAuditTable(databaseSchemaConfig);
        String string2 = this.getChangeNoticeColumn(databaseSchemaConfig);
        if (string != null) {
            DbHandler dbHandler = dbProviderInt.getHandler(false);
            try {
                Object object;
                boolean bl3 = false;
                boolean bl4 = false;
                for (String string3 : list) {
                    if (!string3.equalsIgnoreCase(string)) continue;
                    bl4 = true;
                }
                if (!bl4 && this.checkSchemaExists(dbProviderInt, false)) {
                    object = dbHandler.getConnection();
                    try {
                        bl3 = dbHandler.checkTableExists((Connection)object, databaseSchemaConfig.SchemaDataModelTables, string);
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                if (!bl3 && !bl4) {
                    Util_Logger.warning(logger, "Skipping post-change script generation as " + string + " is missing");
                } else {
                    object = new StringBuilder();
                    if (bl) {
                        ((StringBuilder)object).append("UPDATE ");
                        ((StringBuilder)object).append(dbHandler.getTableReference(databaseSchemaConfig.SchemaDataModelTables, string));
                        ((StringBuilder)object).append(" set STATUS = 'SUCCESS'");
                        ((StringBuilder)object).append(" where INSTALLATION_DATE = ");
                        ((StringBuilder)object).append(dbHandler.getSqlDate(this.InstallationDate));
                        ((StringBuilder)object).append(" and ");
                        ((StringBuilder)object).append(databaseSchemaConfig.Package.Data_Model);
                        ((StringBuilder)object).append("_VERSION = '");
                        ((StringBuilder)object).append(change.Id);
                        ((StringBuilder)object).append("' and INSTALL_TYPE = '");
                        ((StringBuilder)object).append(databaseSchemaConfig.Package.Type);
                        ((StringBuilder)object).append("';");
                    } else {
                        ((StringBuilder)object).append("INSERT INTO ");
                        ((StringBuilder)object).append(dbHandler.getTableReference(databaseSchemaConfig.SchemaDataModelTables, string));
                        ((StringBuilder)object).append(" (INSTALLATION_DATE,");
                        ((StringBuilder)object).append(databaseSchemaConfig.Package.Data_Model);
                        ((StringBuilder)object).append("_VERSION");
                        ((StringBuilder)object).append(",INSTALL_TYPE,SCRIPT_VERSION,");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(",PROJECT_TITLE,USERNAME,STATUS) ");
                        ((StringBuilder)object).append(" values (");
                        ((StringBuilder)object).append(dbHandler.getSqlDate(this.InstallationDate));
                        ((StringBuilder)object).append(",'");
                        ((StringBuilder)object).append(change.Id);
                        ((StringBuilder)object).append("','");
                        ((StringBuilder)object).append(databaseSchemaConfig.Package.Type);
                        ((StringBuilder)object).append("','");
                        ((StringBuilder)object).append(change.ScriptVersion);
                        ((StringBuilder)object).append("','");
                        ((StringBuilder)object).append(change.ChangeNotice);
                        ((StringBuilder)object).append("','");
                        ((StringBuilder)object).append(change.Description);
                        ((StringBuilder)object).append("',");
                        ((StringBuilder)object).append(dbHandler.getCurrentUser());
                        ((StringBuilder)object).append(",'SUCCESS');");
                    }
                    printWriter.print("/* Change ");
                    printWriter.print(change.Id);
                    printWriter.println(" post-change operation */");
                    printWriter.println(((StringBuilder)object).toString());
                    printWriter.println();
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error generating post-change SQL: " + exception.getMessage(), exception);
            }
        }
        return bl2;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    private void writeArtefactHeader(Artefact artefact, int n, PrintWriter printWriter) {
        printWriter.println("/*==============================================================================*/");
        printWriter.printf("/* Artefact:                 %-50s */\n", n);
        printWriter.printf("/* Artefact Type:            %-50s */\n", artefact.Type.toString());
        printWriter.printf("/* Artefact Desc:            %-50s */\n", artefact.Description);
        printWriter.println("/*==============================================================================*/");
        printWriter.println();
    }

    private Map<String, String> processParameters(Map<String, String> map, Change change) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (change.Variables != null) {
                for (Variable variable : change.Variables) {
                    if (variable.Param != null) {
                        if (!variable.Param.equalsIgnoreCase(entry.getKey())) continue;
                        Util_Logger.debug(logger, "Aliasing user parameter [" + entry.getKey() + "] to script parameter [" + variable.Script + "]");
                        hashMap.put(variable.Script, entry.getValue());
                        continue;
                    }
                    if (variable.Default == null) continue;
                    Util_Logger.debug(logger, "Applying default parameter [" + variable.Script + "] to [" + variable.Default + "]");
                    hashMap.put(variable.Script, variable.Default);
                }
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private boolean checkSchemaExists(DbProviderInt dbProviderInt, boolean bl) {
        boolean bl2 = false;
        DbHandler dbHandler = dbProviderInt.getHandler(bl);
        try (Connection connection = dbHandler.getConnection();){
            bl2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    private void logDatabaseDetails(DbProviderInt dbProviderInt) {
        Util_Logger.info(logger, "Database URL: " + dbProviderInt.getURL());
        if (dbProviderInt.getHandler(false) != null) {
            Util_Logger.info(logger, "Database User: " + dbProviderInt.getUser(false));
        }
    }

    private String sqlStr(String string) {
        return Util.isBlank(string) ? "NULL" : "'" + string + "'";
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "VA_FORMAT_STRING_USES_NEWLINE"})
    public DatabasePackage processChanges(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, Map<String, String> map, List<String> list) throws ApplicationException {
        Util_Logger.info(logger, "Processing Data Model update package: " + databaseSchemaConfig.getSourcePackageFile());
        Util_Logger.info(logger, "Preparing Data Model changes");
        this.logDatabaseDetails(dbProviderInt);
        DatabasePackage databasePackage = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object2 : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(object2);
            }
            Util_Logger.info(logger, "Applying the following install options [" + stringBuilder.toString() + "]");
            String string2 = databaseSchemaConfig.getOutputFolder();
            File file = new File(string2);
            if (!file.exists() && file.mkdirs()) {
                Util_Logger.info(logger, "Created output folder: " + file.getName());
            }
            ScriptManager scriptManager = new ScriptManager(databaseSchemaConfig, dbProviderInt, string2);
            Util_Logger.info(logger, "Preparing updates for " + databaseSchemaConfig.Package.Description);
            if (databaseSchemaConfig.Changes != null) {
                Iterator<String> n = new ArrayList();
                Object var11_14 = null;
                for (Change change : databaseSchemaConfig.Changes) {
                    Stream<String> stream;
                    Object object;
                    Object object2;
                    Util_Logger.info(logger, "Checking change " + change.Id + " release " + change.ChangeNotice + " on " + Util.dateToStr(change.ReleaseDate, "dd/MM/yyyy") + " : " + change.Description);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Map<String, String> map2 = this.processParameters(map, change);
                    if (change.Artefacts != null) {
                        int n2 = 0;
                        for (Artefact artefact : change.Artefacts) {
                            Util_Logger.info(logger, "Checking artefact " + ++n2 + " of " + change.Artefacts.size() + " : " + artefact.Description);
                            object2 = dbProviderInt.getHandler(artefact.Administrator);
                            boolean bl4 = false;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            int n3 = 0;
                            if (list.contains(artefact.UserPack)) {
                                bl5 = true;
                                Util_Logger.debug(logger, "Artefact " + n2 + " parameters:");
                                for (Map.Entry<String, String> entry : map2.entrySet()) {
                                    Util_Logger.debug(logger, "     [" + entry.getKey() + "] = [" + entry.getValue() + "]");
                                }
                                bl7 = this.checkSchemaExists(dbProviderInt, artefact.Administrator);
                                if (artefact.Prerequisites != null) {
                                    bl6 = true;
                                    if (bl7) {
                                        for (Check check : artefact.Prerequisites) {
                                            Util_Logger.info(logger, "Artefact " + n2 + " : prerequisite check " + ++n3 + " of " + artefact.Prerequisites.size());
                                            boolean bl8 = this.performCheck(dbProviderInt, map2, (List<String>)((Object)n), check, artefact.Administrator, databaseSchemaConfig.SchemaManagementTables, databaseSchemaConfig.SchemaDataModelTables, scriptManager);
                                            bl6 = bl6 && bl8;
                                        }
                                    } else {
                                        Util_Logger.info(logger, "Artefact " + n2 + " schema precondition does not exist, skipping checks and applying artefact");
                                    }
                                } else {
                                    bl6 = true;
                                    Util_Logger.info(logger, "Detected no prerequisite checks for artefact " + n2);
                                }
                                if (bl6) {
                                    bl4 = true;
                                }
                            }
                            if (bl4) {
                                if (object2 != null) {
                                    block105: {
                                        Util_Logger.info(logger, "Processing artefact " + n2 + " of " + change.Artefacts.size() + " : " + artefact.Description + " with credentials [" + (artefact.Administrator ? "Administrator" : "Schema") + "]");
                                        Util_Logger.info(logger, "Passed " + n3 + " prerequisite checks for artefact " + n2);
                                        object = scriptManager.getCurrentScript(change, artefact.Administrator);
                                        try (FileWriter fileWriter = new FileWriter(((EngineGeneratedSQLScript)object).File, true);
                                             PrintWriter printWriter = new PrintWriter(fileWriter);){
                                            this.writeArtefactHeader(artefact, n2, printWriter);
                                            if (!bl && !artefact.Administrator) {
                                                bl = this.preChangeOperation(databaseSchemaConfig, dbProviderInt, change, (List<String>)((Object)n), printWriter);
                                            }
                                            if (bl7) {
                                                try (Connection connection = ((DbHandler)object2).getConnection();){
                                                    this.applyArtefact(connection, (DbHandler)object2, dbProviderInt, databaseSchemaConfig.getConfigFolder(), artefact, map2, printWriter, arrayList);
                                                    break block105;
                                                }
                                            }
                                            this.applyArtefact(null, (DbHandler)object2, dbProviderInt, databaseSchemaConfig.getConfigFolder(), artefact, map2, printWriter, arrayList);
                                        }
                                    }
                                    bl2 = bl2 || !artefact.Administrator;
                                    ((EngineGeneratedSQLScript)object).HasActiveArtefact = true;
                                    continue;
                                }
                                Util_Logger.error(logger, "Detected missing database credentials for artefact " + artefact.Description);
                                continue;
                            }
                            if (!bl5) {
                                Util_Logger.info(logger, "Skipping application for artefact " + n2 + ", install option [" + artefact.UserPack + "] not selected");
                            } else if (!bl6) {
                                Util_Logger.info(logger, "Failed prerequisite checks for artefact " + n2 + ", skipping application");
                            }
                            if (object2 == null) continue;
                            object = scriptManager.getCurrentScript(change, artefact.Administrator);
                            try (FileWriter fileWriter = new FileWriter(((EngineGeneratedSQLScript)object).File, true);
                                 PrintWriter printWriter = new PrintWriter(fileWriter);){
                                if (!bl5) {
                                    this.writeArtefactHeader(artefact, n2, printWriter);
                                    printWriter.printf("/* Artefact %s is not required based on install options */\n", n2);
                                    printWriter.println();
                                    continue;
                                }
                                if (bl6) continue;
                                this.writeArtefactHeader(artefact, n2, printWriter);
                                printWriter.printf("/* Artefact %s is not required based on prerequisite checks */\n", n2);
                                printWriter.println();
                            }
                        }
                        n.addAll(arrayList);
                        if (bl2) {
                            EngineGeneratedSQLScript engineGeneratedSQLScript = scriptManager.getCurrentScript(change, false);
                            try (FileWriter fileWriter = new FileWriter(engineGeneratedSQLScript.File, true);){
                                object2 = new PrintWriter(fileWriter);
                                try {
                                    this.postChangeOperation(databaseSchemaConfig, dbProviderInt, change, (List<String>)((Object)n), bl, (PrintWriter)object2);
                                }
                                finally {
                                    ((PrintWriter)object2).close();
                                }
                            }
                        }
                    }
                    for (String string3 : arrayList) {
                        Util_Logger.debug(logger, "Detected new table [" + string3 + "]");
                    }
                    if (arrayList.size() > 0) {
                        Util_Logger.info(logger, "Detected " + arrayList.size() + " new tables");
                    }
                    if (bl2 && !Util.isBlank(change.Installation_Instructions)) {
                        scriptManager.addInstallationInstructions("Change " + change.Id + " installation instructions:");
                        stream = change.Installation_Instructions.trim().lines();
                        stream.forEach(string -> scriptManager.addInstallationInstructions("    " + string));
                    }
                    if (bl2) {
                        bl3 = true;
                        stream = scriptManager.getCurrentScript(change, false);
                        if (this.checkSchemaExists(dbProviderInt, ((EngineGeneratedSQLScript)((Object)stream)).Administrator)) {
                            DbHandler dbHandler = dbProviderInt.getHandler(((EngineGeneratedSQLScript)((Object)stream)).Administrator);
                            try (Connection connection = dbHandler.getConnection();){
                                object2 = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, "PDR_REPORT_TYPE_CONFIG");
                                String string4 = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, "PDR_REPORT_RECORDS");
                                String string5 = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, "PDR_REPORT_RECORD_MAPPING");
                                String string6 = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, "PDR_REPORT_AUDIT_SUMMARY");
                                if (dbHandler.checkTableExists(connection, databaseSchemaConfig.SchemaManagementTables, "PDR_REPORT_RECORDS")) {
                                    void var11_17;
                                    void var11_15;
                                    LoaderConfigManager loaderConfigManager = new LoaderConfigManager();
                                    if (var11_15 == null) {
                                        LoaderConfig loaderConfig = loaderConfigManager.loadFromDatabase(connection, databaseSchemaConfig, dbHandler);
                                    }
                                    LoaderConfig loaderConfig = new LoaderConfig();
                                    if (!Util.isBlank(change.LoaderMappingConfig)) {
                                        loaderConfig = loaderConfigManager.loadFromFile(databaseSchemaConfig.getConfigFolder() + "/" + change.LoaderMappingConfig);
                                    }
                                    object = loaderConfigManager.assessDifferences((LoaderConfig)var11_17, loaderConfig);
                                    LoaderConfig loaderConfig2 = loaderConfigManager.appendDeltaUpdates((LoaderConfig)var11_17, (LoaderConfig)object);
                                    try (FileWriter fileWriter = new FileWriter(((EngineGeneratedSQLScript)((Object)stream)).File, true);
                                         PrintWriter printWriter = new PrintWriter(fileWriter);){
                                        printWriter.println("/*==============================================================================*/");
                                        printWriter.println("/* Data Model Tables configuration updates                                      */");
                                        printWriter.println("/*==============================================================================*/");
                                        printWriter.println();
                                        for (LoaderConfigReportAuditSummary loaderConfigReportAuditSummary : ((LoaderConfig)object).itsReportAuditSummary) {
                                            printWriter.printf("delete from %s where REPORT_NAME = %s and REPORT_SUB_TYPE = %s and VERSION = %d and DESTINATION_TABLE = %s;\n", string6, this.sqlStr(loaderConfigReportAuditSummary.ReportName), this.sqlStr(loaderConfigReportAuditSummary.ReportSubType), loaderConfigReportAuditSummary.Version, this.sqlStr("<NEW>"));
                                        }
                                        for (LoaderConfigReportRecords loaderConfigReportRecords : ((LoaderConfig)object).itsReportRecords) {
                                            printWriter.printf("delete from %s where REPORT_NAME = %s and REPORT_SUB_TYPE = %s and VERSION = %d and DESTINATION_TABLE = %s;\n", string4, this.sqlStr(loaderConfigReportRecords.ReportName), this.sqlStr(loaderConfigReportRecords.ReportSubType), loaderConfigReportRecords.Version, this.sqlStr("<NEW>"));
                                        }
                                        for (LoaderConfigReportTypeConfig loaderConfigReportTypeConfig : ((LoaderConfig)object).itsReportTypes) {
                                            printWriter.printf("insert into %s (REPORT_TYPE,TRANSACTION_TYPE_OVERRIDE,IS_ACTIVE,IS_NEW,SEQUENTIAL_PROCESS) values (%s,%s,%d,%d,%d);\n", object2, this.sqlStr(loaderConfigReportTypeConfig.ReportType), this.sqlStr(loaderConfigReportTypeConfig.TransactionTypeOverride), loaderConfigReportTypeConfig.IsActive, loaderConfigReportTypeConfig.IsNew, loaderConfigReportTypeConfig.SequentialProcess);
                                        }
                                        for (LoaderConfigReportRecords loaderConfigReportRecords : ((LoaderConfig)object).itsReportRecords) {
                                            printWriter.printf("insert into %s (REPORT_NAME,REPORT_SUB_TYPE,VERSION,DESTINATION_TABLE,TRANSACTION_TYPE,ROW_FILTER_TYPE,IS_ACTIVE,IS_NEW) values (%s,%s,%d,%s,%s,%s,%d,%d);\n", string4, this.sqlStr(loaderConfigReportRecords.ReportName), this.sqlStr(loaderConfigReportRecords.ReportSubType), loaderConfigReportRecords.Version, this.sqlStr(loaderConfigReportRecords.DestinationTable), this.sqlStr(loaderConfigReportRecords.TransactionType), this.sqlStr(loaderConfigReportRecords.RowFilterType), loaderConfigReportRecords.IsActive, loaderConfigReportRecords.IsNew);
                                        }
                                        for (LoaderConfigReportRecordMapping loaderConfigReportRecordMapping : ((LoaderConfig)object).itsReportRecordMapping) {
                                            printWriter.printf("insert into %s (REPORT_NAME,REPORT_SUB_TYPE,VERSION,DESTINATION_TABLE,SOURCE_COLUMN,DESTINATION_COLUMN,TRANSFORM_TYPE) values (%s,%s,%d,%s,%s,%s,%s);\n", string5, this.sqlStr(loaderConfigReportRecordMapping.ReportName), this.sqlStr(loaderConfigReportRecordMapping.ReportSubType), loaderConfigReportRecordMapping.Version, this.sqlStr(loaderConfigReportRecordMapping.DestinationTable), this.sqlStr(loaderConfigReportRecordMapping.SourceColumn), this.sqlStr(loaderConfigReportRecordMapping.DestinationColumn), this.sqlStr(loaderConfigReportRecordMapping.TransformType));
                                        }
                                        for (LoaderConfigReportAuditSummary loaderConfigReportAuditSummary : ((LoaderConfig)object).itsReportAuditSummary) {
                                            printWriter.printf("insert into %s (REPORT_TYPE,REPORT_NAME,REPORT_SUB_TYPE,VERSION,DESTINATION_TABLE) values (%s,%s,%s,%d,%s);\n", string6, this.sqlStr(loaderConfigReportAuditSummary.ReportType), this.sqlStr(loaderConfigReportAuditSummary.ReportName), this.sqlStr(loaderConfigReportAuditSummary.ReportSubType), loaderConfigReportAuditSummary.Version, this.sqlStr(loaderConfigReportAuditSummary.DestinationTable));
                                        }
                                        bl3 = false;
                                        if (arrayList.size() > 0) {
                                            int n4 = 0;
                                            for (String string7 : arrayList) {
                                                if (string7.equalsIgnoreCase(this.getAuditTable(databaseSchemaConfig))) continue;
                                                printWriter.printf("update %s set IS_ACTIVE = 1 where DESTINATION_TABLE = '%s';\n", string4, string7);
                                                if (loaderConfig2.containsTable(string7)) continue;
                                                ++n4;
                                                Util_Logger.debug(logger, "Detected missing configuration in " + string4 + " for DESTINATION_TABLE " + string7);
                                            }
                                            if (n4 > 0) {
                                                Util_Logger.errorNoRaise(logger, "Detected " + n4 + " missing configurations in " + string4);
                                                scriptManager.addWarning("Detected " + n4 + " missing configurations in " + string4 + " for Change " + change.Id);
                                            }
                                            printWriter.println();
                                        }
                                        printWriter.println("/* Detected no new data model tables in this database change package */");
                                    }
                                }
                                Util_Logger.warning(logger, "Skipping loader configuration mapping as table [" + string4 + "] does not exist");
                            }
                        } else {
                            Util_Logger.debug(logger, "Skipping loader configuration mapping as schema does not exist");
                        }
                    }
                    if (!bl3) continue;
                    scriptManager.addWarning("Please apply pdrLoader mapping for " + databaseSchemaConfig.Package.Data_Model + " " + change.Id + " manually");
                }
            }
            if (scriptManager.getFailedChecks().size() > 0) {
                Util_Logger.errorNoRaise(logger, "Failed the following prerequisite checks:");
                int n = 0;
                for (String string8 : scriptManager.getFailedChecks()) {
                    Util_Logger.errorNoRaise(logger, ++n + ". " + string8);
                }
                Util_Logger.error(logger, "Aborting script generation process due to failed prerequisite checks");
            }
            if ((databasePackage = scriptManager.getDatabasePackage()).getGeneratedSQL().size() > 0) {
                Util_Logger.info(logger, "SQL updates written to folder " + (String)string2);
                for (EngineGeneratedSQLScript engineGeneratedSQLScript : databasePackage.getGeneratedSQL()) {
                    Util_Logger.info(logger, "    " + engineGeneratedSQLScript.File.getName() + "   [ run as " + (engineGeneratedSQLScript.Administrator ? "admin" : "schema owner") + " ]");
                }
                if (databasePackage.getWarningMessages() != null) {
                    for (String string9 : databasePackage.getWarningMessages()) {
                        Util_Logger.warning(logger, string9);
                    }
                }
                if (databasePackage.getImplementationInstructions() != null) {
                    for (String string10 : databasePackage.getImplementationInstructions()) {
                        Util_Logger.info(logger, string10);
                    }
                }
            } else {
                Util_Logger.info(logger, "No updates generated, database is up to date");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "error preparing database changes: " + exception.getMessage(), exception);
        }
        return databasePackage;
    }

    public boolean applyChanges(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, DatabasePackage databasePackage) throws ApplicationException {
        boolean bl = false;
        try {
            Iterator<String> iterator;
            Util_Logger.info(logger, "Applying Data Model changes");
            this.logDatabaseDetails(dbProviderInt);
            if (!Util.isBlank(databaseSchemaConfig.TablespaceDir) && !((File)((Object)(iterator = new File(databaseSchemaConfig.TablespaceDir)))).exists()) {
                Util_Logger.info(logger, "Creating tablespace folder: " + databaseSchemaConfig.TablespaceDir);
                if (((File)((Object)iterator)).mkdirs()) {
                    Util_Logger.info(logger, "Created tablespace folder: " + ((File)((Object)iterator)).getName());
                }
            }
            if (databasePackage.getGeneratedSQL().size() > 0) {
                Util_Logger.info(logger, "Applying updates from " + databaseSchemaConfig.getOutputFolder() + " to " + databaseSchemaConfig.Package.Description);
                for (EngineGeneratedSQLScript object : databasePackage.getGeneratedSQL()) {
                    DbHandler dbHandler = dbProviderInt.getHandler(object.Administrator);
                    Util_Logger.info(logger, "Connecting as " + dbProviderInt.getUser(object.Administrator) + (String)(Util.isBlank(dbHandler.getDefaultSchema()) ? "" : ", default schema " + dbHandler.getDefaultSchema()));
                    Connection connection = dbHandler.getConnection();
                    try {
                        this.runScript(dbProviderInt, connection, dbHandler, object.File.getPath(), true);
                        connection.commit();
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                Util_Logger.info(logger, "Successfully applied updates to database");
                if (databasePackage.getWarningMessages() != null) {
                    for (String string : databasePackage.getWarningMessages()) {
                        Util_Logger.warning(logger, string);
                    }
                }
                if (databasePackage.getImplementationInstructions() != null) {
                    for (String string : databasePackage.getImplementationInstructions()) {
                        Util_Logger.info(logger, string);
                    }
                }
            } else {
                Util_Logger.error(logger, "No scripts available to apply to database");
            }
            bl = true;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error applying scripts to database: " + exception.getMessage(), exception);
        }
        return bl;
    }

    public void addDefaultParameters(DatabaseSchemaConfig databaseSchemaConfig, Map<String, String> map) throws Exception {
        for (Change change : databaseSchemaConfig.Changes) {
            if (change.Variables == null) continue;
            for (Variable variable : change.Variables) {
                if (variable.Default == null) continue;
                map.put(variable.Script, variable.Default);
                Util_Logger.debug(logger, "Added default script variable [" + variable.Script + "] with value of [" + variable.Default + "]");
            }
        }
    }

    public List<Parameter> identifyParameters(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, Map<String, String> map) throws Exception {
        HashMap<String, Parameter> hashMap = new HashMap<String, Parameter>();
        databaseSchemaConfig.TablespaceDir = map.get("TABLESPACE_DIR");
        Util_Logger.info(logger, "Scanning database package for parameters");
        for (Change change : databaseSchemaConfig.Changes) {
            if (change.Artefacts == null) continue;
            for (Artefact artefact : change.Artefacts) {
                if (artefact.Scripts == null) continue;
                for (Script script : artefact.Scripts) {
                    Parameter parameter;
                    List<String> list;
                    if (!script.isRelevant(dbProviderInt) || (list = dbProviderInt.scanScriptForParameters(databaseSchemaConfig.getConfigFolder(), script)) == null) continue;
                    script.Params = list;
                    script.Variables = new HashMap<String, Variable>();
                    for (String string : list) {
                        Object object;
                        parameter = new Parameter();
                        parameter.Name = string;
                        parameter.HasDefault = false;
                        if (change.Variables != null) {
                            object = change.Variables.iterator();
                            while (object.hasNext()) {
                                Variable variable = (Variable)object.next();
                                if (variable.Script != null && string.equalsIgnoreCase(variable.Script)) {
                                    Variable variable2 = new Variable(variable);
                                    if (variable.Param != null) {
                                        for (Variable variable3 : change.Variables) {
                                            if (variable3.Script != null || !variable3.Param.equalsIgnoreCase(variable.Param)) continue;
                                            Util_Logger.debug(logger, "Transferring variable defaults from [" + variable.Param + "] to script variable [" + variable3.Script + "] in " + script.Name);
                                            variable2.mergeDefaults(variable3);
                                        }
                                    }
                                    script.Variables.put(variable2.Script, variable2);
                                    if (variable.Param != null) {
                                        parameter.Name = variable.Param;
                                        Util_Logger.debug(logger, "Mapping script variable [" + string + "] to parameter [" + parameter.Name + "] in " + script.Name);
                                    }
                                }
                                parameter.HasDefault = variable.hasDefault();
                            }
                        }
                        if ((object = hashMap.put(parameter.Name, parameter)) == null) continue;
                        parameter.HasDefault = parameter.HasDefault || ((Parameter)object).HasDefault;
                    }
                    if (change.Variables == null) continue;
                    for (Variable variable : change.Variables) {
                        if (!hashMap.containsKey(variable.Script) || (parameter = (Parameter)hashMap.get(variable.Script)) == null) continue;
                        parameter.HasDefault = parameter.HasDefault || variable.hasDefault();
                    }
                }
            }
        }
        return new ArrayList<Parameter>(hashMap.values());
    }

    public List<InstallPack> identifyInstallPackOptions(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt) throws Exception {
        ArrayList<InstallPack> arrayList = new ArrayList<InstallPack>();
        Util_Logger.info(logger, "Scanning database package for install options");
        for (Change change : databaseSchemaConfig.Changes) {
            if (change.Artefacts == null) continue;
            for (Artefact artefact : change.Artefacts) {
                if (artefact.UserPack == null) continue;
                boolean bl = false;
                if (artefact.Schema != null && artefact.Schema.Tables != null) {
                    bl = true;
                }
                if (artefact.Scripts != null) {
                    for (Script script : artefact.Scripts) {
                        if (!script.isRelevant(dbProviderInt)) continue;
                        bl = true;
                    }
                }
                if (!bl) continue;
                InstallPack installPack = new InstallPack();
                installPack.Name = artefact.UserPack;
                installPack.Description = artefact.UserPackDescription;
                boolean bl2 = true;
                for (InstallPack installPack2 : arrayList) {
                    if (!installPack2.Name.equalsIgnoreCase(installPack.Name)) continue;
                    bl2 = false;
                    if (Util.isBlank(installPack.Description)) continue;
                    installPack2.Description = installPack.Description;
                }
                if (!bl2) continue;
                installPack.Description = artefact.UserPack;
                arrayList.add(installPack);
            }
        }
        return arrayList;
    }

    public boolean identifyIfAdministratorOptionSelected(DatabaseSchemaConfig databaseSchemaConfig, List<String> list) throws Exception {
        boolean bl = false;
        Util_Logger.info(logger, "Scanning database package to see if Administrator credentials required for selected UserPack options");
        for (Change change : databaseSchemaConfig.Changes) {
            if (change.Artefacts == null) continue;
            for (Artefact artefact : change.Artefacts) {
                if (artefact.UserPack != null) {
                    for (String string : list) {
                        if (!artefact.UserPack.equalsIgnoreCase(string) || !artefact.Administrator) continue;
                        bl = true;
                    }
                    continue;
                }
                if (!artefact.Administrator) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean identifyIfUserOptionSelected(DatabaseSchemaConfig databaseSchemaConfig, List<String> list) throws Exception {
        boolean bl = false;
        Util_Logger.info(logger, "Scanning database package to see if user credentials required for selected UserPack options");
        for (Change change : databaseSchemaConfig.Changes) {
            if (change.Artefacts == null) continue;
            for (Artefact artefact : change.Artefacts) {
                if (artefact.UserPack != null) {
                    for (String string : list) {
                        if (!artefact.UserPack.equalsIgnoreCase(string) || !artefact.User) continue;
                        bl = true;
                    }
                    continue;
                }
                if (!artefact.User) continue;
                bl = true;
            }
        }
        return bl;
    }
}

