/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Providers;

import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Providers.DbProviderBase;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import au.com.aemo.Pdr.Database.Providers.DbProviderMySQL;
import au.com.aemo.Pdr.Database.Providers.DbProviderOracle;
import au.com.aemo.Pdr.Database.Providers.DbProviderPostgreSQL;
import au.com.aemo.Pdr.Database.Providers.DbProviderSnowflake;
import au.com.aemo.Pdr.Database.Providers.DbProviderSqlServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;

public class DbProviderManager {
    private Map<DatabaseType, DbProviderInt> Providers = new HashMap<DatabaseType, DbProviderInt>();
    private String AppName;
    private String AppVersion;
    private DatabaseConfig ConfigSchema;
    private DatabaseConfig ConfigSystem;

    private DbProviderManager() {
        this.registerProvider(new DbProviderOracle());
        this.registerProvider(new DbProviderSqlServer());
        this.registerProvider(new DbProviderMySQL());
        this.registerProvider(new DbProviderPostgreSQL());
        this.registerProvider(new DbProviderSnowflake());
    }

    public static DbProviderManager getInstance() {
        return SingletonHolder.instance;
    }

    private void registerProvider(DbProviderInt dbProviderInt) {
        this.Providers.put(dbProviderInt.getId(), dbProviderInt);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is called by trusted code")
    public void setConfig(String string, String string2, DatabaseConfig databaseConfig, DatabaseConfig databaseConfig2) {
        this.AppName = string;
        this.AppVersion = string2;
        this.ConfigSchema = databaseConfig;
        this.ConfigSystem = databaseConfig2;
    }

    public DbProviderInt getProvider(String string) throws Exception {
        return this.getProvider(DatabaseType.valueOf(string.toUpperCase().trim()));
    }

    public DbProviderInt getProvider(DatabaseType databaseType) throws Exception {
        DbProviderInt dbProviderInt = this.Providers.get((Object)databaseType);
        if (dbProviderInt == null) {
            throw new Exception("Unsupported database provider " + String.valueOf((Object)databaseType));
        }
        if (this.ConfigSchema != null) {
            this.ConfigSchema.Driver = dbProviderInt.getDriverClassName();
            this.ConfigSchema.DbHandler = dbProviderInt.getHandlerClassName();
            this.ConfigSchema.DbDateFormat = dbProviderInt.getDbDateFormat();
        }
        if (this.ConfigSystem != null) {
            this.ConfigSystem.Driver = dbProviderInt.getDriverClassName();
            this.ConfigSystem.DbHandler = dbProviderInt.getHandlerClassName();
            this.ConfigSystem.DbDateFormat = dbProviderInt.getDbDateFormat();
        }
        ((DbProviderBase)((Object)dbProviderInt)).setConfig(this.AppName, this.AppVersion, this.ConfigSchema, this.ConfigSystem);
        return dbProviderInt;
    }

    private static class SingletonHolder {
        private static DbProviderManager instance = new DbProviderManager();

        private SingletonHolder() {
        }
    }
}

