/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Providers;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.Database.Config.Column;
import au.com.aemo.Pdr.Database.Config.ColumnType;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Providers.DbProviderBase;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import java.sql.Connection;

public class DbProviderPostgreSQL
extends DbProviderBase
implements DbProviderInt {
    private static final String DELIMITER = ";";

    @Override
    public DatabaseType getId() {
        return DatabaseType.POSTGRESQL;
    }

    @Override
    public String getHandlerClassName() {
        return "au.com.aemo.Common.Database.DbHandlerPostgreSQL";
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getDbDateFormat() {
        return "YYYY/MM/DD HH24:MI:SS.US";
    }

    private String getColumnType(Column column) throws Exception {
        if (column.Type == ColumnType.CHAR) {
            return "CHAR(" + column.Length + ")";
        }
        if (column.Type == ColumnType.DATE) {
            return "TIMESTAMP(0)";
        }
        if (column.Type == ColumnType.NUMBER) {
            return "NUMERIC(" + column.Length + "," + column.Scale + ")";
        }
        if (column.Type == ColumnType.TIMESTAMP) {
            return "TIMESTAMP(3)";
        }
        if (column.Type == ColumnType.VARCHAR2) {
            return "VARCHAR(" + column.Length + ")";
        }
        throw new Exception("Unsupported type " + String.valueOf((Object)column.Type) + " for column " + column.Name);
    }

    @Override
    public String generateSQL(Table table, Connection connection, DbHandler dbHandler) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (connection != null) {
            bl = dbHandler.checkTableExists(connection, null, table.Name);
        }
        if (bl) {
            for (Column column : table.Columns) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\r\n");
                }
                if (dbHandler.checkColumnExists(connection, null, table.Name, column.Name)) {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" ALTER COLUMN ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" TYPE ");
                    stringBuilder.append(this.getColumnType(column));
                } else {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" ADD COLUMN ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getColumnType(column));
                }
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        } else {
            stringBuilder.append("CREATE TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" ( ");
            Object object = "";
            boolean bl2 = false;
            for (Column column : table.Columns) {
                stringBuilder.append("\r\n");
                stringBuilder.append("    ");
                stringBuilder.append((String)object);
                stringBuilder.append(column.Name);
                stringBuilder.append(" ");
                stringBuilder.append(this.getColumnType(column));
                if (column.PK) {
                    stringBuilder.append(" NOT NULL");
                    bl2 = true;
                }
                object = ",";
            }
            stringBuilder.append("\r\n");
            stringBuilder.append(")");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
            if (bl2) {
                stringBuilder.append("ALTER TABLE ");
                stringBuilder.append(table.Name);
                stringBuilder.append(" add constraint ");
                stringBuilder.append(this.getPKConstraintName(table));
                stringBuilder.append(" primary key (");
                object = "";
                for (Column column : table.Columns) {
                    if (!column.PK) continue;
                    stringBuilder.append((String)object);
                    stringBuilder.append(column.Name);
                    object = ",";
                }
                stringBuilder.append(")");
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        }
        if (!Util.isBlank(table.Comment)) {
            stringBuilder.append("\r\n");
            stringBuilder.append("COMMENT ON TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" IS '");
            stringBuilder.append(table.Comment);
            stringBuilder.append("'");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
        }
        for (Column column : table.Columns) {
            if (Util.isBlank(column.Comment)) continue;
            stringBuilder.append("COMMENT ON COLUMN ");
            stringBuilder.append(table.Name);
            stringBuilder.append(".");
            stringBuilder.append(column.Name);
            stringBuilder.append(" IS '");
            stringBuilder.append(column.Comment);
            stringBuilder.append("'");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }
}

