/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Pdr.Database.Config.ConfigManager;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabasePackageSummaryAction
implements PanelAction {
    private static final Logger logger = Logger.getLogger(DatabasePackageSummaryAction.class.getName());
    private String configHeading;
    private String configSummary;

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Initialization failed.");
        } else {
            this.configHeading = panelActionConfiguration.getProperty("configHeading", null);
            logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Initialization variable configHeading=" + this.configHeading);
            this.configSummary = panelActionConfiguration.getProperty("configSummary", null);
            logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Initialization variable configSummary=" + this.configSummary);
        }
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Starting");
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            installData.setVariable(this.configHeading, configManager.createHeading());
            installData.setVariable(this.configSummary, configManager.createSummary());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "DatabasePackageSummaryAction: " + exception.getMessage(), exception);
            abstractUIHandler.emitError("Error loading database package", exception.getMessage());
        }
        logger.log(Level.CONFIG, "DatabasePackageSummaryAction: Completed");
    }
}

