/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.InstallPack;
import au.com.aemo.Pdr.Database.Engine.EngineProcessing;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import au.com.aemo.izpack.install.ManagerConfig;
import au.com.aemo.izpack.install.installPreferencesManager;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabasePackageValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(DatabasePackageValidator.class.getName());

    private void addPack(Pack pack, List<Pack> list) {
        boolean bl = true;
        for (Pack pack2 : list) {
            if (!pack2.getName().equalsIgnoreCase(pack.getName())) continue;
            bl = false;
        }
        if (bl) {
            list.add(1, pack);
        }
    }

    private void clearPack(List<Pack> list) {
        if (list != null) {
            while (list.size() > 2) {
                list.remove(1);
            }
        }
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        boolean bl = false;
        try {
            Object object;
            String string = installData.getVariable("user_database_package");
            String string2 = installData.getVariable("user_working_folder");
            logger.log(Level.INFO, "DatabaseTargetValidator: validating package " + string);
            ConfigManager configManager = ConfigManager.getInstance();
            configManager.loadConfig(string, string2);
            installData.setVariable("INSTALL_PATH", configManager.getConfig().getConfigFolder() + File.separatorChar + "output");
            installData.setVariable("database_description", configManager.getConfig().Package.Description);
            ManagerConfig managerConfig = new ManagerConfig();
            DbProviderInt dbProviderInt = managerConfig.provider;
            EngineProcessing engineProcessing = new EngineProcessing();
            List<InstallPack> list = engineProcessing.identifyInstallPackOptions(configManager.getConfig(), dbProviderInt);
            if (list != null) {
                Collections.reverse(list);
                object = installData.getAllPacks();
                List<Pack> list2 = installData.getAvailablePacks();
                this.clearPack((List<Pack>)object);
                this.clearPack(list2);
                for (InstallPack installPack : list) {
                    boolean bl2 = false;
                    boolean bl3 = true;
                    if (list.size() == 1) {
                        bl2 = true;
                    }
                    Pack pack = new Pack(installPack.Name, null, installPack.Description, null, null, bl2, bl3, true, null, false, 0L);
                    this.addPack(pack, (List<Pack>)object);
                    this.addPack(pack, list2);
                }
            }
            object = installPreferencesManager.getInstance();
            ((installPreferencesManager)object).setPreference("user_database_package", string);
            ((installPreferencesManager)object).setPreference("user_working_folder", string2);
            ((installPreferencesManager)object).savePreferences();
            bl = true;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "DatabaseTargetValidator: " + exception.getMessage(), exception);
        }
        return bl ? DataValidator.Status.OK : DataValidator.Status.ERROR;
    }

    @Override
    public String getErrorMessageId() {
        return "DatabasePackageValidator.Error.Id";
    }

    @Override
    public String getWarningMessageId() {
        return "DatabasePackageValidator.Warning.Id";
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

