/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Engine.DatabasePackage;
import au.com.aemo.Pdr.Database.Engine.EngineProcessing;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import au.com.aemo.izpack.install.ManagerConfig;
import au.com.aemo.izpack.install.UIProcessHandlerWithLogging;
import au.com.aemo.izpack.install.automatedInstallDataManager;
import au.com.aemo.izpack.install.izPackLogAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePrepareChanges {
    private static final Logger logger = Logger.getLogger(DatabasePrepareChanges.class.getName());
    private String itsOutputFolder;

    private String prepareChanges(AbstractUIProcessHandler abstractUIProcessHandler) throws Exception {
        ConfigManager configManager = ConfigManager.getInstance();
        DatabaseSchemaConfig databaseSchemaConfig = configManager.getConfig();
        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setLevel("INFO");
        thresholdFilter.start();
        izPackLogAppender izPackLogAppender2 = new izPackLogAppender(abstractUIProcessHandler);
        izPackLogAppender2.setName("gui");
        izPackLogAppender2.addFilter(thresholdFilter);
        izPackLogAppender2.start();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern("%-12date{YYYY-MM-dd HH:mm:ss.SSS} %-5level - %msg%n");
        patternLayoutEncoder.setContext(loggerContext);
        patternLayoutEncoder.start();
        FileAppender<ILoggingEvent> fileAppender = new FileAppender<ILoggingEvent>();
        fileAppender.setFile(databaseSchemaConfig.getOutputFolder() + File.separatorChar + "dataModelManager.log");
        fileAppender.setEncoder(patternLayoutEncoder);
        fileAppender.setContext(loggerContext);
        fileAppender.setName("file");
        fileAppender.start();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        logger.detachAppender(izPackLogAppender2.getName());
        logger.addAppender(izPackLogAppender2);
        logger.detachAppender(fileAppender.getName());
        logger.addAppender((Appender<ILoggingEvent>)fileAppender);
        ManagerConfig managerConfig = new ManagerConfig();
        DbProviderInt dbProviderInt = managerConfig.provider;
        Map<String, String> map = configManager.getScriptParams();
        List<String> list = configManager.getInstallPackOptions();
        EngineProcessing engineProcessing = new EngineProcessing();
        DatabasePackage databasePackage = engineProcessing.processChanges(databaseSchemaConfig, dbProviderInt, map, list);
        configManager.setDatabasePackage(databasePackage);
        logger.detachAppender(izPackLogAppender2);
        izPackLogAppender2.stop();
        thresholdFilter.stop();
        logger.detachAppender((Appender<ILoggingEvent>)fileAppender);
        fileAppender.stop();
        return databasePackage.getSummaryFile();
    }

    public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, String[] stringArray) {
        UIProcessHandlerWithLogging uIProcessHandlerWithLogging = new UIProcessHandlerWithLogging(abstractUIProcessHandler, logger);
        boolean bl = false;
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = this.prepareChanges(abstractUIProcessHandler);
            automatedInstallDataManager automatedInstallDataManager2 = automatedInstallDataManager.getInstance();
            InstallData installData = automatedInstallDataManager2.getData();
            installData.setVariable(string, string3);
            installData.setVariable(string2, this.itsOutputFolder);
            bl = true;
        }
        catch (Exception exception) {
            uIProcessHandlerWithLogging.logOutput("Error preparing database update package: " + exception.getMessage(), exception);
        }
        if (!bl) {
            uIProcessHandlerWithLogging.emitError("Database error", "Error preparing database update package, please check script contents");
        }
        return bl;
    }
}

