/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Engine.EngineProcessing;
import au.com.aemo.izpack.install.automatedInstallDataManager;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabasePrepareOptionsAction
implements PanelAction {
    private static final Logger logger = Logger.getLogger(DatabasePrepareOptionsAction.class.getName());
    private String adminLoginRequiredVariable;
    private String userLoginRequiredVariable;

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "DatabasePrepareOptionsAction: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "DatabasePrepareOptionsAction: Initialization failed.");
        } else {
            this.adminLoginRequiredVariable = panelActionConfiguration.getProperty("adminLoginRequired", null);
            logger.log(Level.CONFIG, "DatabasePrepareOptionsAction: Initialization variable adminLoginRequired=" + this.adminLoginRequiredVariable);
            this.userLoginRequiredVariable = panelActionConfiguration.getProperty("userLoginRequired", null);
            logger.log(Level.CONFIG, "DatabasePrepareOptionsAction: Initialization variable userLoginRequired=" + this.userLoginRequiredVariable);
        }
    }

    private void prepareOptions() throws Exception {
        automatedInstallDataManager automatedInstallDataManager2 = automatedInstallDataManager.getInstance();
        InstallData installData = automatedInstallDataManager2.getData();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Pack object2 : installData.getSelectedPacks()) {
            logger.log(Level.INFO, "Pack [" + object2.getName() + "] is selected");
            arrayList.add(object2.getName());
        }
        ConfigManager configManager = ConfigManager.getInstance();
        configManager.setInstallPackOptions(arrayList);
        DatabaseSchemaConfig databaseSchemaConfig = configManager.getConfig();
        EngineProcessing engineProcessing = new EngineProcessing();
        boolean bl = engineProcessing.identifyIfAdministratorOptionSelected(databaseSchemaConfig, arrayList);
        installData.setVariable(this.adminLoginRequiredVariable, String.valueOf(bl));
        boolean bl2 = engineProcessing.identifyIfUserOptionSelected(databaseSchemaConfig, arrayList);
        installData.setVariable(this.userLoginRequiredVariable, String.valueOf(bl2));
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        try {
            this.prepareOptions();
            logger.log(Level.INFO, "Successfully prepared database options from update package");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "DatabasePrepareOptionsAction: " + exception.getMessage(), exception);
            abstractUIHandler.emitError("Error preparing database update options", exception.getMessage());
        }
    }
}

