/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class installPreferencesManager {
    private static Logger logger = LoggerFactory.getLogger(installPreferencesManager.class);
    private Properties preferences;
    private String InstallerName;

    private installPreferencesManager() {
    }

    public static installPreferencesManager getInstance() {
        return SingletonHolder.instance;
    }

    public void setInstallerName(String string) {
        this.InstallerName = string;
    }

    private File getPreferencesFile() throws Exception {
        URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File file = Paths.get(uRL.toURI()).toFile();
        String string = file.getParent();
        return new File(string + File.separatorChar + Util.isBlank(this.InstallerName, "preferences") + ".properties");
    }

    private void loadPreferences() {
        block7: {
            try {
                File file = this.getPreferencesFile();
                if (!file.exists()) break block7;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    this.preferences = properties;
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to load installer preferences: " + exception.getMessage(), exception);
            }
        }
    }

    public void savePreferences() {
        if (this.preferences != null) {
            try {
                File file = this.getPreferencesFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    Util_Logger.info(logger, "Saving installer preferences to " + file.getPath());
                    this.preferences.store(fileOutputStream, "Installer preferences");
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error saving installer preferences: " + exception.getMessage(), exception);
            }
        }
    }

    public synchronized String getPreference(String string) {
        String string2 = null;
        try {
            if (this.preferences == null) {
                this.loadPreferences();
            }
            if (this.preferences != null) {
                string2 = this.preferences.getProperty(string, null);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable extarcting preference [" + string + "] : " + exception.getMessage(), exception);
        }
        return string2;
    }

    public synchronized void setPreference(String string, String string2) {
        if (this.preferences == null) {
            this.preferences = new Properties();
        }
        this.preferences.put(string, Util.noNull(string2));
    }

    private static class SingletonHolder {
        private static installPreferencesManager instance = new installPreferencesManager();

        private SingletonHolder() {
        }
    }
}

