/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.Platform;
import java.util.ArrayList;
import java.util.Collections;

public class InstallPathHelper {
    public static final String TARGET_PANEL_DIR = "TargetPanel.dir";
    private static final String PREFIX = "TargetPanel.dir.";

    public static String getPath(InstallData installData) {
        String path;
        String currentPath = installData.getInstallPath();
        if (currentPath != null) {
            return currentPath;
        }
        String defaultPath = installData.getDefaultInstallPath();
        if (defaultPath == null) {
            defaultPath = System.getProperty("user.dir");
        }
        if ((path = InstallPathHelper.getTargetPanelDir(installData)) != null) {
            path = installData.getVariables().replace(path);
        }
        if (path == null && defaultPath != null) {
            path = installData.getVariables().replace(defaultPath);
        }
        return path;
    }

    private static String getTargetPanelDir(InstallData installData) {
        Platform platform = installData.getPlatform();
        String path = null;
        if (platform.getSymbolicName() != null) {
            path = installData.getVariable(PREFIX + platform.getSymbolicName().toLowerCase());
        }
        if (path == null) {
            path = InstallPathHelper.getTargetPanelDir(installData, platform.getName());
        }
        if (path == null) {
            path = installData.getVariable(TARGET_PANEL_DIR);
        }
        return path;
    }

    private static String getTargetPanelDir(InstallData installData, Platform.Name name) {
        String path = null;
        ArrayList<Platform.Name> queue = new ArrayList<Platform.Name>();
        queue.add(name);
        while (!queue.isEmpty()) {
            name = (Platform.Name)((Object)queue.remove(0));
            path = installData.getVariable(PREFIX + name.toString().toLowerCase());
            if (path != null) break;
            Collections.addAll(queue, name.getParents());
        }
        return path;
    }
}

