/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.panels.userinput.field.AbstractFieldView;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.util.Console;

public abstract class ConsoleField
extends AbstractFieldView {
    private final Console console;
    private final Prompt prompt;

    public ConsoleField(Field field, Console console, Prompt prompt) {
        super(field);
        this.console = console;
        this.prompt = prompt;
    }

    public abstract boolean display();

    protected void printDescription() {
        String description = this.getField().getDescription(true);
        if (description != null) {
            this.println(description);
        }
    }

    protected void printLabel() {
        String label = this.getField().getLabel();
        if (label != null) {
            this.println(label);
        }
    }

    protected void println(String message) {
        this.console.println(message);
    }

    protected void print(String message) {
        this.console.print(message);
    }

    protected void error(String message) {
        this.prompt.error(this.getMessage("UserInputPanel.error.caption"), message);
    }

    protected Console getConsole() {
        return this.console;
    }

    protected String getMessage(String id) {
        InstallData installData = this.getField().getInstallData();
        Messages messages = installData.getMessages();
        return messages.get(id, new Object[0]);
    }
}

