/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.Util;

import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationUtil;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorFactory;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util_Logger;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerDownloadFile {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerDownloadFile.class);
    private String itsHoldingDir;
    private boolean itsCheckFileIntegrity;

    public pdrBatcherHandlerDownloadFile(String string, boolean bl) {
        this.itsHoldingDir = string;
        this.itsCheckFileIntegrity = bl;
    }

    public FtpFileInfo getSourceFile(pdrConnectionInt pdrConnectionInt2, String string, FtpFileInfo ftpFileInfo, List<pdrFileTranslationInt> list, int n2) throws ApplicationException {
        Cloneable cloneable;
        FtpFileInfo ftpFileInfo2 = null;
        if (pdrConnectionInt2.logOperations()) {
            Util_Logger.info(logger, "Now getting " + ftpFileInfo.getFilename() + " from " + string + " in thread " + n2);
        }
        try {
            File file;
            cloneable = pdrConnectionInt2.getFile(string, this.itsHoldingDir, ftpFileInfo.getFilename(), ftpFileInfo.getModifiedDate());
            if (ftpFileInfo.getModifiedDate() == null && cloneable != null) {
                ftpFileInfo.setModifiedDate((Date)cloneable, true);
            }
            if (ftpFileInfo.getSize() == null && (file = new File(this.itsHoldingDir, ftpFileInfo.getFilename())).exists()) {
                ftpFileInfo.setSize(file.length());
            }
            ftpFileInfo2 = (FtpFileInfo)ftpFileInfo.clone();
            ftpFileInfo2.setDirectory(this.itsHoldingDir);
        }
        catch (FtpException ftpException) {
            if (ftpException.getReplyCode() == 550) {
                Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + n2);
            } else {
                Util_Logger.error(logger, "Detected FTP error: " + ftpException.getMessage() + " in thread " + n2, ftpException);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected FTP error: " + exception.getMessage() + " in thread " + n2, exception);
        }
        cloneable = null;
        if (ftpFileInfo2 != null) {
            if (!this.itsCheckFileIntegrity) {
                cloneable = ftpFileInfo2;
            } else if (this.checkFileIntegrity(ftpFileInfo2, n2)) {
                cloneable = ftpFileInfo2;
            }
        }
        return cloneable;
    }

    public List<FtpFileInfo> transformSourceFile(FtpFileInfo ftpFileInfo, List<pdrFileTranslationInt> list, int n2) throws ApplicationException {
        return pdrFileTranslationUtil.transformSourceFile(ftpFileInfo, list, this.itsHoldingDir, n2);
    }

    private boolean checkFileIntegrity(FtpFileInfo ftpFileInfo, int n2) {
        boolean bl = true;
        pdrFileValidatorFactory pdrFileValidatorFactory2 = pdrFileValidatorFactory.getInstance();
        try {
            File file;
            pdrFileValidatorInt pdrFileValidatorInt2 = pdrFileValidatorFactory2.getValidator(ftpFileInfo.getExtension());
            if (pdrFileValidatorInt2 != null && !(bl = pdrFileValidatorInt2.checkFileIntegrity(file = new File(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename()), n2))) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error validating file " + ftpFileInfo.getFilename() + ", assuming correct: " + exception.getMessage(), exception);
        }
        return bl;
    }
}

