/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParser;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.ArrayList;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatcherDOMParserGrammerPool {
    private XMLGrammarPoolImpl grammarPool;
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static Logger logger = LoggerFactory.getLogger(BatcherDOMParser.class);

    public BatcherDOMParserGrammerPool(String string) throws Exception {
        String string2;
        int n2 = Integer.parseInt(Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string + "_schema_count", "0"));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 1; i2 <= n2; ++i2) {
            string2 = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string + "_schema_" + i2, null);
            if (Util.isBlank(string2)) continue;
            arrayList.add(string2);
        }
        SymbolTable symbolTable = new SymbolTable();
        string2 = new XMLGrammarPreparser(symbolTable);
        this.grammarPool = new XMLGrammarPoolImpl();
        string2.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        string2.setProperty(GRAMMAR_POOL, (Object)this.grammarPool);
        string2.setFeature(NAMESPACES_FEATURE_ID, true);
        string2.setFeature(VALIDATION_FEATURE_ID, true);
        string2.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        string2.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        try {
            for (String string3 : arrayList) {
                Grammar grammar = string2.preparseGrammar("http://www.w3.org/2001/XMLSchema", BatcherDOMParserGrammerPool.stringToXIS(string3));
                Util_Logger.info(logger, "Load schema " + string3);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Can not initialize BatcherDOMParser", exception);
        }
    }

    public XMLGrammarPoolImpl getGrammerPool() {
        return this.grammarPool;
    }

    private static XMLInputSource stringToXIS(String string) {
        return new XMLInputSource(null, string, null);
    }
}

