/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParser;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.ZipFileInfo;
import au.com.nemmco.Util.Util_Logger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZipFileParser {
    private static Logger logger = LoggerFactory.getLogger(ZipFileParser.class);
    private String itsDataSource;

    public ZipFileParser(String string) {
        this.itsDataSource = string;
    }

    public void parser(String string, ZipFileInfo zipFileInfo) {
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        BatcherDOMParser batcherDOMParser = batcherDOMParserFactory.getParser(this.itsDataSource);
        Document document = null;
        try {
            document = batcherDOMParser.createDocument(string, batcherDOMParserFactory.getValidateSchema(this.itsDataSource));
            if (batcherDOMParser.getErrorMessage().trim().length() > 0) {
                zipFileInfo.setIsValid(false);
                zipFileInfo.setErrorMessage(batcherDOMParser.getErrorMessage());
            } else {
                zipFileInfo.setIsValid(true);
            }
        }
        catch (Exception exception) {
            zipFileInfo.setIsValid(false);
            zipFileInfo.setErrorMessage(exception.getMessage());
            Util_Logger.warning(logger, "Exception occured when parsing " + string, exception);
        }
        if (document != null) {
            String string2 = this.getAttribute(document, "ase:aseXML", "xmlns:ase");
            String[] stringArray = string2.split(":");
            String string3 = stringArray[2];
            String string4 = this.getElement(document, "From");
            String string5 = this.getAttribute(document, "From", "description");
            String string6 = this.getElement(document, "To");
            String string7 = this.getAttribute(document, "To", "description");
            String string8 = this.getElement(document, "MessageID");
            String string9 = this.getElement(document, "TransactionGroup");
            String string10 = this.getElement(document, "Priority");
            String string11 = this.getElement(document, "SecurityContext");
            zipFileInfo.setSchemaVersion(string3);
            zipFileInfo.setPriority(string10);
            zipFileInfo.setSecurityContext(string11);
            zipFileInfo.setTransGroup(string9);
            zipFileInfo.setInitMsgId(string8);
            zipFileInfo.setFromName(string4);
            zipFileInfo.setFromDesc(string5);
            zipFileInfo.setToName(string6);
            zipFileInfo.setToDesc(string7);
        }
    }

    private String getElement(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (node == null || node.getFirstChild() == null) continue;
            stringBuffer.append(node.getFirstChild().getNodeValue());
        }
        return stringBuffer.toString();
    }

    private String getAttribute(Document document, String string, String string2) {
        String string3 = "";
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return string3;
        }
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element = (Element)nodeList.item(i2);
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getNamedItem(string2) == null) continue;
            int n3 = namedNodeMap.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Attr attr = (Attr)namedNodeMap.item(i3);
                if (!attr.getNodeName().equals(string2)) continue;
                string3 = attr.getNodeValue();
            }
        }
        return string3;
    }
}

