/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessBase;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessReceiveAck;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessReceiveZip;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessSend;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessSending;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessSent;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.ProcessWatermark;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Common.pdrLockManager;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerAseXMLHandler {
    public static final String STATE_TMP = "TMP";
    public static final String STATE_ZIP = "ZIP";
    public static final String STATE_SENDING = "SENDING";
    public static final String STATE_SENT = "SENT";
    public static final String STATE_DONE = "DONE";
    public static final String STATE_NACK = "nack";
    public static final String STATE_RESEND = "RESEND";
    public static final String STATE_ACK = "ack";
    public static final String POSITIVE_ACK = "Positive";
    public static final String NEGATIVE_ACK = "Negative";
    public static final String RESEND_ACK = "Resend";
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLHandler.class);
    private int itsId;
    private String itsDataSource;
    private String itsAemoDirInbox;
    private String itsAemoDirOutbox;
    private Map<String, FtpFileInfo> itsAemoDirInboxListing;
    private Map<String, FtpFileInfo> itsAemoDirOutboxListing;
    private Map<String, Date> itsAemoStopbox;
    private Map<String, Map<String, FtpFileInfo>> itsLocalDirInboxListing;
    private Map<String, Map<String, FtpFileInfo>> itsLocalDirOutboxListing;

    public pdrBatcherHandlerAseXMLHandler(int n2, List<pdrFileTranslationInt> list, String string, String string2, Map<String, FtpFileInfo> map, String string3, Map<String, FtpFileInfo> map2, Map<String, FtpFileInfo> map3, Map<String, Map<String, FtpFileInfo>> map4, Map<String, Map<String, FtpFileInfo>> map5) {
        Object object;
        this.itsId = n2;
        this.itsDataSource = string;
        this.itsAemoDirInbox = string2;
        this.itsAemoDirInboxListing = this.updateKeys(map);
        this.itsAemoDirOutbox = string3;
        this.itsAemoDirOutboxListing = this.updateKeys(map2);
        this.itsAemoStopbox = new HashMap<String, Date>();
        for (FtpFileInfo object2 : map3.values()) {
            object = object2.getName().split("_");
            if (object == null || ((String[])object).length <= 0) continue;
            this.itsAemoStopbox.put(object[0], object2.getModifiedDate());
        }
        this.itsLocalDirInboxListing = new HashMap<String, Map<String, FtpFileInfo>>();
        for (String string4 : map4.keySet()) {
            object = map4.get(string4);
            this.itsLocalDirInboxListing.put(string4, this.updateKeys((Map<String, FtpFileInfo>)object));
        }
        this.itsLocalDirOutboxListing = new HashMap<String, Map<String, FtpFileInfo>>();
        for (String string5 : map5.keySet()) {
            object = map5.get(string5);
            this.itsLocalDirOutboxListing.put(string5, this.updateKeys((Map<String, FtpFileInfo>)object));
        }
    }

    private Map<String, FtpFileInfo> updateKeys(Map<String, FtpFileInfo> map) {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        for (String string : map.keySet()) {
            hashMap.put(string.toUpperCase(), map.get(string));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSend(pdrConnectionInt pdrConnectionInt2, pdrConnectionInt pdrConnectionInt3, List<pdrFileTranslationInt> list) throws Exception {
        pdrLockManager pdrLockManager2 = pdrLockManager.getInstance();
        int n2 = 0;
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(this.itsDataSource);
        if (processWatermark != null) {
            if (this.itsAemoDirInboxListing.size() < processWatermark.getInboxLowMark()) {
                n2 = processWatermark.getInboxHighMark() - this.itsAemoDirInboxListing.size();
            }
        } else {
            n2 = 1000000;
        }
        int n3 = 0;
        for (String string : this.itsLocalDirInboxListing.keySet()) {
            Map<String, FtpFileInfo> map = this.itsLocalDirInboxListing.get(string);
            for (String string2 : map.keySet()) {
                FtpFileInfo ftpFileInfo = map.get(string2);
                if (ftpFileInfo.isDirectory() || !pdrLockManager2.addTask(ftpFileInfo.getName())) continue;
                try {
                    pdrBatcherHandlerAseXMLProcessBase pdrBatcherHandlerAseXMLProcessBase2;
                    if (ftpFileInfo.getExtension().equalsIgnoreCase(STATE_SENDING)) {
                        pdrBatcherHandlerAseXMLProcessBase2 = new pdrBatcherHandlerAseXMLProcessSending(this.itsId);
                        pdrBatcherHandlerAseXMLProcessBase2.process(pdrConnectionInt2, pdrConnectionInt3, ftpFileInfo, list);
                        continue;
                    }
                    if (ftpFileInfo.getExtension().equalsIgnoreCase(STATE_ZIP)) {
                        if (n3 >= n2) continue;
                        pdrBatcherHandlerAseXMLProcessBase2 = new pdrBatcherHandlerAseXMLProcessSend(this.itsDataSource, this.itsAemoDirInbox, this.itsAemoStopbox, this.itsId);
                        pdrBatcherHandlerAseXMLProcessBase2.process(pdrConnectionInt2, pdrConnectionInt3, ftpFileInfo, list);
                        ++n3;
                        continue;
                    }
                    if (!ftpFileInfo.getExtension().equalsIgnoreCase(STATE_SENT)) continue;
                    pdrBatcherHandlerAseXMLProcessBase2 = new pdrBatcherHandlerAseXMLProcessSent(this.itsDataSource, this.itsAemoDirInbox, this.itsAemoDirOutbox, this.itsAemoDirOutboxListing, this.itsId);
                    pdrBatcherHandlerAseXMLProcessBase2.process(pdrConnectionInt2, pdrConnectionInt3, ftpFileInfo, list);
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error processing file: " + ftpFileInfo.getFilename() + ": " + exception.getMessage(), exception);
                }
                finally {
                    pdrLockManager2.deleteTask(ftpFileInfo.getName());
                }
            }
        }
    }

    private boolean isZip(FtpFileInfo ftpFileInfo) {
        boolean bl = false;
        if (!ftpFileInfo.isDirectory()) {
            bl = Util.noNull(ftpFileInfo.getExtension()).equalsIgnoreCase(STATE_ZIP);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReceive(pdrConnectionInt pdrConnectionInt2, pdrConnectionInt pdrConnectionInt3, List<pdrFileTranslationInt> list) throws Exception {
        pdrBatcherHandlerAseXMLProcessBase pdrBatcherHandlerAseXMLProcessBase2;
        pdrLockManager pdrLockManager2 = pdrLockManager.getInstance();
        for (FtpFileInfo ftpFileInfo : this.itsAemoDirOutboxListing.values()) {
            if (!this.isZip(ftpFileInfo) || !pdrLockManager2.addTask(ftpFileInfo.getName())) continue;
            try {
                pdrBatcherHandlerAseXMLProcessBase2 = new pdrBatcherHandlerAseXMLProcessReceiveZip(this.itsDataSource, this.itsAemoDirInbox, this.itsAemoDirOutbox, this.itsLocalDirOutboxListing, this.itsId);
                pdrBatcherHandlerAseXMLProcessBase2.process(pdrConnectionInt2, pdrConnectionInt3, ftpFileInfo, list);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error processing file: " + ftpFileInfo.getFilename() + ": " + exception.getMessage(), exception);
            }
            finally {
                pdrLockManager2.deleteTask(ftpFileInfo.getName());
            }
        }
        for (FtpFileInfo ftpFileInfo : this.itsAemoDirInboxListing.values()) {
            if (ftpFileInfo.isDirectory() || !pdrLockManager2.addTask(ftpFileInfo.getName())) continue;
            try {
                pdrBatcherHandlerAseXMLProcessBase2 = new pdrBatcherHandlerAseXMLProcessReceiveAck(this.itsAemoDirOutboxListing, this.itsId);
                pdrBatcherHandlerAseXMLProcessBase2.process(pdrConnectionInt2, pdrConnectionInt3, ftpFileInfo, list);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error processing file: " + ftpFileInfo.getFilename() + ": " + exception.getMessage(), exception);
            }
            finally {
                pdrLockManager2.deleteTask(ftpFileInfo.getName());
            }
        }
    }
}

