/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.pdrBatcherHandlerAseXMLHandler;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util_Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerAseXML
extends pdrBatcherHandlerBase {
    public static final String INBOX = "INBOX";
    public static final String OUTBOX = "OUTBOX";
    public static final String STOPBOX = "STOPBOX";
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXML.class);
    private String itsAemoDirInbox;
    private String itsAemoDirOutbox;
    private Map<String, FtpFileInfo> itsAemoDirInboxListing = new HashMap<String, FtpFileInfo>();
    private Map<String, FtpFileInfo> itsAemoDirOutboxListing = new HashMap<String, FtpFileInfo>();
    private Map<String, FtpFileInfo> itsAemoDirStopboxListing = new HashMap<String, FtpFileInfo>();
    private Map<String, Map<String, FtpFileInfo>> itsLocalDirInboxListing = new HashMap<String, Map<String, FtpFileInfo>>();
    private Map<String, Map<String, FtpFileInfo>> itsLocalDirOutboxListing = new HashMap<String, Map<String, FtpFileInfo>>();

    public pdrBatcherHandlerAseXML(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        if (!batcherDOMParserFactory.getAllOK()) {
            Util_Logger.error(logger, "Error initialising BatcherDOMParserFactory");
        }
    }

    @Override
    protected void configOverride(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) {
        pdrBatcherHandlerConfig2.SubDirList = Arrays.asList(INBOX, OUTBOX);
        pdrBatcherHandlerConfig2.SubDirListDest = false;
        pdrBatcherHandlerConfig2.DirectoryRecurse = false;
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    @Override
    protected boolean processFileCheck(FtpFileInfo ftpFileInfo, Map<String, FtpFileInfo> map) {
        return true;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return false;
    }

    @Override
    protected void startPollCycle(String string) {
        this.clearDirectoryLists();
    }

    private void clearDirectoryLists() {
        this.itsAemoDirInboxListing.clear();
        this.itsAemoDirOutboxListing.clear();
        this.itsAemoDirStopboxListing.clear();
        this.itsLocalDirInboxListing.clear();
        this.itsLocalDirOutboxListing.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completePollCycle(String string) {
        pdrConnectionInt pdrConnectionInt2 = null;
        pdrConnectionInt pdrConnectionInt3 = null;
        try {
            pdrConnectionInt2 = this.getSourceConnection();
            pdrConnectionInt3 = this.getDestinationConnection();
            this.itsAemoDirStopboxListing = pdrConnectionInt2.listFiles(this.getSourceDir(string, STOPBOX), null);
            List<String> list = this.getDestinationDir(INBOX);
            for (String object2 : list) {
                this.itsLocalDirInboxListing.put(object2, pdrConnectionInt3.listFiles(object2, null));
            }
            List<String> list2 = this.getDestinationDir(OUTBOX);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.itsLocalDirOutboxListing.put(string2, pdrConnectionInt3.listFiles(string2, null));
            }
            pdrBatcherHandlerAseXMLHandler pdrBatcherHandlerAseXMLHandler2 = new pdrBatcherHandlerAseXMLHandler(this.getId(), this.getFileTranslator(), this.getConfig().DataSource, this.itsAemoDirInbox, this.itsAemoDirInboxListing, this.itsAemoDirOutbox, this.itsAemoDirOutboxListing, this.itsAemoDirStopboxListing, this.itsLocalDirInboxListing, this.itsLocalDirOutboxListing);
            pdrBatcherHandlerAseXMLHandler2.processSend(pdrConnectionInt2, pdrConnectionInt3, this.getFileTranslator());
            pdrBatcherHandlerAseXMLHandler2.processReceive(pdrConnectionInt2, pdrConnectionInt3, this.getFileTranslator());
        }
        catch (Exception exception) {
            try {
                pdrConnectionInt2.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                pdrConnectionInt3.disconnect();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            Util_Logger.errorNoRaise(logger, "Detected exception processing aseXML files: " + exception.getMessage(), exception);
        }
        finally {
            this.freeSourceConnection(pdrConnectionInt2);
            this.freeDestinationConnection(pdrConnectionInt3);
        }
        this.clearDirectoryLists();
    }

    @Override
    protected void startPollCycleDirectory(String string) {
        if (string.toUpperCase().endsWith(INBOX)) {
            this.itsAemoDirInbox = string;
        }
        if (string.toUpperCase().endsWith(OUTBOX)) {
            this.itsAemoDirOutbox = string;
        }
    }

    @Override
    protected boolean processSingleFileAction(FtpFileInfo ftpFileInfo, pdrConnectionInt pdrConnectionInt2, String string, Map<String, FtpFileInfo> map, boolean bl) {
        if (ftpFileInfo.getDirectory().toUpperCase().endsWith(INBOX)) {
            this.itsAemoDirInboxListing.put(ftpFileInfo.getFilename(), ftpFileInfo);
        }
        if (ftpFileInfo.getDirectory().toUpperCase().endsWith(OUTBOX)) {
            this.itsAemoDirOutboxListing.put(ftpFileInfo.getFilename(), ftpFileInfo);
        }
        return false;
    }
}

