/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerPurge
extends pdrBatcherHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerPurge.class);
    private int itsRetentionTimeMins;
    private int itsRemovedFileCount;
    private Date itsPurgeBeforeDate;

    public pdrBatcherHandlerPurge(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        this.itsRetentionTimeMins = pdrBatcherHandlerConfig2.RetentionTimeMins;
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return true;
    }

    @Override
    protected boolean downloadSourceFile() {
        return false;
    }

    @Override
    protected void startPollCycle(String string) {
        this.itsRemovedFileCount = 0;
        if (this.itsRetentionTimeMins > 0) {
            this.itsPurgeBeforeDate = Util.dateOffset(new Date(), -this.itsRetentionTimeMins, 12);
        } else {
            Util_Logger.warning(logger, "Retention time is not defined for purging thread " + this.getId());
        }
    }

    @Override
    protected void completePollCycle(String string) {
        if (this.itsRemovedFileCount > 0) {
            Util_Logger.info(logger, "Purged " + this.itsRemovedFileCount + " files from directory " + string + " with last modified date < " + Util.dateToStr(this.itsPurgeBeforeDate, "dd-MM-yyyy HH:mm:ss"));
            this.itsRemovedFileCount = 0;
        }
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected boolean processFileCheck(FtpFileInfo ftpFileInfo, Map<String, FtpFileInfo> map) {
        boolean bl = false;
        if (this.itsPurgeBeforeDate != null && ftpFileInfo != null && ftpFileInfo.getModifiedDate().before(this.itsPurgeBeforeDate)) {
            bl = true;
            ++this.itsRemovedFileCount;
        }
        return bl;
    }

    @Override
    protected boolean processSingleFileAction(FtpFileInfo ftpFileInfo, pdrConnectionInt pdrConnectionInt2, String string, Map<String, FtpFileInfo> map, boolean bl) {
        return true;
    }
}

