/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util_Logger;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerSynchronise
extends pdrBatcherHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerSynchronise.class);

    public pdrBatcherHandlerSynchronise(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return true;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected void startPollCycle(String string) {
    }

    @Override
    protected void completePollCycle(String string) {
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected boolean processFileCheck(FtpFileInfo ftpFileInfo, Map<String, FtpFileInfo> map) {
        boolean bl = false;
        FtpFileInfo ftpFileInfo2 = map.get(ftpFileInfo.getFilename());
        if (ftpFileInfo2 == null) {
            bl = true;
        } else if (ftpFileInfo2.getModifiedDate().before(ftpFileInfo.getModifiedDate())) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean processSingleFileAction(FtpFileInfo ftpFileInfo, pdrConnectionInt pdrConnectionInt2, String string, Map<String, FtpFileInfo> map, boolean bl) {
        boolean bl2 = false;
        FtpFileInfo ftpFileInfo2 = map.get(ftpFileInfo.getFilename());
        if (pdrConnectionInt2.logOperations()) {
            Util_Logger.info(logger, "Now putting " + ftpFileInfo.getFilename() + " to " + string + " in thread " + this.getId());
        }
        try {
            if (ftpFileInfo2 != null) {
                Util_Logger.info(logger, "Deleting destination file" + string + ":" + ftpFileInfo.getFilename());
                pdrConnectionInt2.deleteFile(string, ftpFileInfo.getFilename());
            }
            pdrConnectionInt2.putFile(this.getHoldingDir(), ftpFileInfo.getFilename(), string, ftpFileInfo.getModifiedDate(), false);
            bl2 = true;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected FTP error: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return bl2;
    }
}

