/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationFactory;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Csv;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationUtil {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationUtil.class);

    public static List<pdrFileTranslationInt> resolveConfig(String string) throws ApplicationException {
        ArrayList<pdrFileTranslationInt> arrayList = new ArrayList<pdrFileTranslationInt>();
        if (!Util.isBlank(string)) {
            Util_Logger.debug(logger, "Detected translator configuration: " + string);
            Csv csv = new Csv(' ');
            Csv csv2 = new Csv('=');
            String[] stringArray = string.split("\\|");
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (Util.isBlank(string2)) continue;
                    try {
                        string2 = string2.trim();
                        Util_Logger.debug(logger, "Detected translation action: " + string2);
                        String string3 = string2;
                        String string4 = null;
                        int n2 = string2.indexOf(" ");
                        if (n2 > 0) {
                            string3 = string2.substring(0, n2);
                            string4 = string2.substring(n2 + 1);
                        }
                        Util_Logger.debug(logger, "Detected translator ID: " + string3);
                        pdrFileTranslationInt pdrFileTranslationInt2 = pdrFileTranslationFactory.getInstance().getTranslator(string3);
                        if (!Util.isBlank(string4)) {
                            pdrFileTranslationInt2.parseParams(Util.getColumns(string4, ' '));
                        }
                        arrayList.add(pdrFileTranslationInt2);
                    }
                    catch (Exception exception) {
                        Util_Logger.error(logger, "Error instantiating file translator handler class: " + exception.getMessage(), exception);
                    }
                }
            }
        }
        return arrayList;
    }

    public static List<FtpFileInfo> transformSourceFile(FtpFileInfo ftpFileInfo, List<pdrFileTranslationInt> list, String string, int n2) throws ApplicationException {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        arrayList.add(ftpFileInfo);
        try {
            if (list != null) {
                for (pdrFileTranslationInt pdrFileTranslationInt2 : list) {
                    ArrayList<FtpFileInfo> arrayList2 = new ArrayList<FtpFileInfo>();
                    for (FtpFileInfo ftpFileInfo2 : arrayList) {
                        if (pdrFileTranslationInt2.acceptFile(ftpFileInfo2)) {
                            arrayList2.addAll(pdrFileTranslationInt2.translateFile(ftpFileInfo2, string, n2));
                            continue;
                        }
                        pdrFileTranslationInt pdrFileTranslationInt3 = pdrFileTranslationFactory.getInstance().getTranslatorDefault();
                        arrayList2.addAll(pdrFileTranslationInt3.translateFile(ftpFileInfo2, string, n2));
                    }
                    arrayList = arrayList2;
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected file transform error: " + exception.getMessage() + " in thread " + n2, exception);
        }
        return arrayList;
    }
}

