/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.ZipUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class pdrFileTranslationZip
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static final String PARAM_COMPRESSION_TYPE = "type";

    public pdrFileTranslationZip() {
        super("ZIP");
        super.registerParam("t", PARAM_COMPRESSION_TYPE, false, "The compression type. Valid values are zip (default), 7z and tgz");
    }

    @Override
    public boolean acceptFile(FtpFileInfo ftpFileInfo) {
        return !ftpFileInfo.getFilename().toUpperCase().endsWith(".ZIP") && !ftpFileInfo.getFilename().toUpperCase().endsWith(".7Z") && !ftpFileInfo.getFilename().toUpperCase().endsWith(".GZ") && !ftpFileInfo.getFilename().toUpperCase().endsWith(".TGZ");
    }

    @Override
    public List<FtpFileInfo> translateFile(FtpFileInfo ftpFileInfo, String string, int n2) throws Exception {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        String string2 = Util.isBlank(this.getParam(PARAM_COMPRESSION_TYPE), "zip");
        String string3 = string + "/" + ftpFileInfo.getFilename();
        String string4 = ftpFileInfo.getName() + "." + string2;
        if (string2.equalsIgnoreCase("GZ")) {
            string4 = ftpFileInfo.getFilename() + "." + string2;
        }
        String string5 = string + "/" + string4;
        ZipUtilities.zip(string5, string3, true);
        FtpFileInfo ftpFileInfo2 = (FtpFileInfo)ftpFileInfo.clone();
        ftpFileInfo2.setDirectory(string);
        ftpFileInfo2.setFilename(string4);
        ftpFileInfo2.setSize(new File(string5).length());
        arrayList.add(ftpFileInfo2);
        return arrayList;
    }
}

