/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Processor.Util.pdrBatcherTokenResolver;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockNone;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrConnectionAPI
implements pdrConnectionInt {
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionAPI.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private String itsCurrentDir;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;

    public pdrConnectionAPI(String string, String string2, Proxy proxy, int n2, int n3) {
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = 1024;
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return false;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("JSON connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.itsBaseURL + "/" + string;
    }

    private HttpURLConnection getHttpURLConnection(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        try {
            void var10_15;
            String string3 = this.getURL(string);
            String[] stringArray = Util.getColumns(string, '?');
            String string4 = stringArray[0];
            String[] stringArray2 = Util.getColumns(string4, '/');
            String string5 = stringArray2[stringArray2.length - 1];
            String string6 = "";
            for (String string7 : stringArray2) {
                String string8;
                if (Util.isBlank(string7) || !string7.toLowerCase().startsWith("v") || string7.length() <= 1 || !Util.isInteger(string8 = string7.substring(1))) continue;
                string6 = string8;
            }
            Object var10_12 = null;
            if (Util.isBlank(string2)) {
                String string9 = "PUBLIC_" + string5 + "_v" + string6 + "_" + Util.dateToStr(new Date(), "yyyyMMddHHmmssSSS") + ".json";
            } else {
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("report_type", string5);
                hashMap2.put("api_version", string6);
                String string10 = pdrBatcherTokenResolver.process(string2, hashMap2);
            }
            Util_Logger.debug(logger, "Polling directory: " + string3);
            FtpFileInfo ftpFileInfo = new FtpFileInfo();
            ftpFileInfo.setFilename((String)var10_15);
            ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
            ftpFileInfo.setSize(null);
            ftpFileInfo.setModifiedDate(null, false);
            hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error listing directory " + string + " from json API: " + exception.getMessage());
        }
        return hashMap;
    }

    private String getURL(String string) throws Exception {
        Object object = null;
        if (string.toUpperCase().startsWith("HTTP://")) {
            object = string;
        } else if (string.toUpperCase().startsWith("HTTPS://")) {
            object = string;
        } else {
            String[] stringArray = Util.getColumns(string, '?');
            String string2 = stringArray[0];
            String string3 = stringArray.length > 1 ? stringArray[1] : "";
            String string4 = pdrBatcherTokenResolver.process(string3);
            String string5 = string2 + "?" + URLEncoder.encode(string4, "UTF-8");
            object = this.itsBaseURL + "/" + string5;
        }
        return object;
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        File file = null;
        HttpURLConnection httpURLConnection = null;
        try {
            int n2;
            httpURLConnection = this.getHttpURLConnection(this.getURL(string));
            file = new File(string2 + "/" + string3);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n3 = 0;
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[this.itsTransferBufferSize];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                n3 += n2;
            }
            inputStream.close();
            outputStream.flush();
            outputStream.close();
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception4) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring file " + string3 + " from web: " + exception.getMessage());
        }
        return date;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        throw new Exception("JSON connection does not support a file put operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsTransferBufferSize = n2;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("JSON connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return false;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        return new pdrFileLockNone();
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
    }
}

