/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.AzureBlob;
import au.com.nemmco.Pdr.Batcher.Transport.AzureBlobProperties;
import au.com.nemmco.Pdr.Batcher.Transport.AzureDirectoryWrapper;
import au.com.nemmco.Pdr.Batcher.Transport.AzureRequestParameters;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionLocal;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockNone;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebClient;
import au.com.nemmco.Util.XmlUtilities;
import au.com.nemmco.Util.xStreamDateConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class pdrConnectionAzure
implements pdrConnectionInt {
    private static String VERSION = "2018-03-28";
    private static String AZURE_DATE_FOMAT = "EEE, dd MMM yyyy HH:mm:ss";
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionAzure.class);
    private String itsDataSourceId;
    private String itsAccount;
    private String itsBaseURL;
    private String itsAPIKey;
    private String itsAPISASToken;
    private String itsCurrentDir;
    private boolean itsGetFileModifiedTime;
    private SimpleDateFormat DateFormatter;
    private pdrConnectionLocal itsLocal;
    private WebClient itsWebClient;

    public pdrConnectionAzure(String string, String string2, String string3, Proxy proxy, String string4, String string5, int n2, int n3, boolean bl) {
        this.itsDataSourceId = string;
        this.itsAccount = string2;
        this.itsBaseURL = string3;
        this.itsAPIKey = string4;
        this.itsAPISASToken = string5;
        this.itsGetFileModifiedTime = bl;
        this.DateFormatter = new SimpleDateFormat(AZURE_DATE_FOMAT);
        this.DateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.itsLocal = new pdrConnectionLocal(string);
        this.itsWebClient = new WebClient(proxy, n2, n3);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Azure connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = string;
    }

    private HttpsURLConnection getHttpURLConnection(String string, AzureRequestParameters azureRequestParameters) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)this.itsWebClient.getHttpURLConnection(azureRequestParameters.method, uRL);
            String string2 = this.DateFormatter.format(Calendar.getInstance().getTime()) + " GMT";
            if (!Util.isBlank(azureRequestParameters.content_type)) {
                httpURLConnection.setRequestProperty("Content-Type", azureRequestParameters.content_type);
            }
            if (!Util.isBlank(azureRequestParameters.content_length)) {
                httpURLConnection.setRequestProperty("Content-Length", azureRequestParameters.content_length);
            }
            httpURLConnection.setRequestProperty("x-ms-date", string2);
            httpURLConnection.setRequestProperty("x-ms-version", VERSION);
            for (Map.Entry<String, String> object3 : azureRequestParameters.headers.entrySet()) {
                httpURLConnection.setRequestProperty(object3.getKey(), object3.getValue());
            }
            Object object = null;
            if (!Util.isBlank(this.itsAPIKey)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Util.noNull(azureRequestParameters.method) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append(Util.noNull(azureRequestParameters.content_length) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append(Util.noNull(azureRequestParameters.content_type) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                for (Map.Entry<String, String> entry : azureRequestParameters.headers.entrySet()) {
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(URLDecoder.decode(entry.getValue(), "UTF-8"));
                    stringBuilder.append("\n");
                }
                stringBuilder.append("x-ms-date:" + string2 + "\n");
                stringBuilder.append("x-ms-version:" + VERSION + "\n");
                stringBuilder.append(azureRequestParameters.resource);
                for (Map.Entry<String, String> entry : azureRequestParameters.parameters.entrySet()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(URLDecoder.decode(entry.getValue(), "UTF-8"));
                }
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(Base64.getDecoder().decode(this.itsAPIKey), "HmacSHA256"));
                byte[] byArray = stringBuilder.toString().getBytes("UTF-8");
                String string3 = Base64.getEncoder().encodeToString(mac.doFinal(byArray));
                object = "SharedKey " + this.itsAccount + ":" + string3;
            }
            if (!Util.isBlank(object)) {
                httpURLConnection.setRequestProperty("Authorization", (String)object);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private Date getFileModifiedDate(String string, String string2) throws Exception {
        throw new Exception("Azure connection does not support a get modified date operation");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            CharSequence charSequence;
            String[] stringArray = Util.getColumns(string, '/');
            String string3 = stringArray[0];
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "GET";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string3;
            azureRequestParameters.parameters.put("restype", "container");
            azureRequestParameters.parameters.put("comp", "list");
            azureRequestParameters.parameters.put("delimiter", "/");
            if (stringArray.length > 1) {
                charSequence = new StringBuilder();
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    ((StringBuilder)charSequence).append(stringArray[i2]);
                    ((StringBuilder)charSequence).append("/");
                }
                azureRequestParameters.parameters.put("prefix", ((StringBuilder)charSequence).toString());
            }
            charSequence = this.getURL(string3, null, azureRequestParameters);
            Util_Logger.debug(logger, "Polling directory: " + (String)charSequence);
            httpURLConnection = this.getHttpURLConnection((String)charSequence, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                if (!httpURLConnection.getContentType().toLowerCase().startsWith("application/xml")) throw new Exception("Invalid response type " + httpURLConnection.getContentType() + " detected in listFiles");
                AzureDirectoryWrapper azureDirectoryWrapper = new AzureDirectoryWrapper();
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
                XStream xStream = XmlUtilities.getConverter();
                xStream.alias("EnumerationResults", AzureDirectoryWrapper.class);
                xStream.alias("BlobPrefix", AzureBlob.class);
                xStream.processAnnotations(AzureDirectoryWrapper.class);
                xStream.processAnnotations(AzureBlob.class);
                xStream.processAnnotations(AzureBlobProperties.class);
                xStream.registerConverter((Converter)new xStreamDateConverter(AZURE_DATE_FOMAT));
                xStream.unmarshal((HierarchicalStreamReader)new DomReader(document), (Object)azureDirectoryWrapper);
                if (azureDirectoryWrapper.Blobs != null) {
                    for (AzureBlob azureBlob : azureDirectoryWrapper.Blobs) {
                        FtpFileInfo ftpFileInfo;
                        String string4;
                        if (azureBlob.Name.endsWith("/")) {
                            string4 = azureBlob.Name.substring(0, azureBlob.Name.length() - 1);
                            if (string4.lastIndexOf("/") > 0) {
                                string4 = string4.substring(string4.lastIndexOf("/") + 1);
                            }
                            ftpFileInfo = new FtpFileInfo();
                            ftpFileInfo.setFilename(string4);
                            ftpFileInfo.setDirectory(string);
                            ftpFileInfo.setFileType(FtpFileTypeEnum.DIRECTORY);
                            hashMap.put(string4, ftpFileInfo);
                            continue;
                        }
                        string4 = azureBlob.Name;
                        if (azureBlob.Name.lastIndexOf("/") > 0) {
                            string4 = azureBlob.Name.substring(azureBlob.Name.lastIndexOf("/") + 1);
                        }
                        ftpFileInfo = new FtpFileInfo();
                        ftpFileInfo.setFilename(string4);
                        ftpFileInfo.setDirectory(string);
                        ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                        ftpFileInfo.setModifiedDate(azureBlob.Properties.LastModified, true);
                        ftpFileInfo.setSize(azureBlob.Properties.ContentLength);
                        hashMap.put(string4, ftpFileInfo);
                    }
                }
            } else {
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure List Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
            return hashMap;
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from Azure: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getURL(String string, String string2, AzureRequestParameters azureRequestParameters) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(this.itsBaseURL + "/" + string);
        if (!Util.isBlank(string2) && !string.endsWith(string2)) {
            stringBuilder.append("/" + string2);
        }
        String string3 = "?";
        if (!Util.isBlank(this.itsAPISASToken)) {
            stringBuilder.append(string3);
            stringBuilder.append(this.itsAPISASToken);
            string3 = "&";
        }
        if (azureRequestParameters != null) {
            for (Map.Entry<String, String> entry : azureRequestParameters.parameters.entrySet()) {
                stringBuilder.append(string3);
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                string3 = "&";
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        block13: {
            HttpURLConnection httpURLConnection = null;
            File file = null;
            try {
                AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
                azureRequestParameters.method = "GET";
                azureRequestParameters.resource = "/" + this.itsAccount + "/" + string + "/" + string3;
                String string4 = this.getURL(string, string3, null);
                Util_Logger.debug(logger, "Downloading blob: " + string4);
                httpURLConnection = this.getHttpURLConnection(string4, azureRequestParameters);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        file = new File(string2 + "/" + string3);
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        file.setLastModified(date.getTime());
                        break block13;
                    }
                }
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Get Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    FileUtilities.deleteFile(file);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Error transferring file " + string3 + " from Azure blob: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        block6: {
            HttpURLConnection httpURLConnection = null;
            try {
                byte[] byArray = Files.readAllBytes(Paths.get(string, string2));
                AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
                azureRequestParameters.method = "PUT";
                azureRequestParameters.content_length = Integer.toString(byArray.length);
                azureRequestParameters.resource = "/" + this.itsAccount + "/" + string3 + "/" + string2;
                azureRequestParameters.headers.put("x-ms-blob-type", "BlockBlob");
                String string4 = this.getURL(string3, string2, azureRequestParameters);
                Util_Logger.debug(logger, "Putting blob: " + string4);
                httpURLConnection = this.getHttpURLConnection(string4, azureRequestParameters);
                httpURLConnection.getOutputStream().write(byArray);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 201) {
                    if (bl) {
                        this.itsLocal.deleteFile(string, string2);
                    }
                    break block6;
                }
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Put Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Error putting file " + string2 + " to Azure blob: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "DELETE";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string + "/" + string2;
            String string3 = this.getURL(string, string2, null);
            Util_Logger.debug(logger, "Deleting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 202) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Delete Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error deleting file " + string2 + " from Azure blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Azure connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        return new pdrFileLockNone();
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
    }
}

