/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFtp;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpConnectionPool;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrConnectionFactoryFtp
implements pdrConnectionFactoryInt {
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionFactoryFtp.class);
    private static Properties itsConfiguration;
    private Map<String, FtpConnectionPool> itsPools;
    private boolean isReady = false;

    private pdrConnectionFactoryFtp() {
        try {
            this.createFtpConnectionPool();
            this.isReady = true;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error establishing FTP pool: " + exception.getMessage(), exception);
        }
    }

    public static pdrConnectionFactoryFtp getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public String getName() {
        return "FTP";
    }

    @Override
    public boolean getIsReady() {
        return this.isReady;
    }

    public static void setConfiguration(Properties properties) {
        itsConfiguration = properties;
    }

    private void createFtpConnectionPool() throws ApplicationException {
        this.itsPools = new HashMap<String, FtpConnectionPool>();
        String string = Util.getProperty(itsConfiguration, "batcher_data_sources", "remote,local");
        if (!Util.isBlank(string)) {
            String[] stringArray;
            for (String string2 : stringArray = Util.getColumns(string, ',')) {
                String string3 = Util.getProperty(itsConfiguration, "batcher_" + string2 + "_mode", "local");
                if (!string3.equalsIgnoreCase("FTP")) continue;
                FtpConnectionPool ftpConnectionPool = new FtpConnectionPool(string2, itsConfiguration, "pdrBatcher v7.5.0");
                this.itsPools.put(ftpConnectionPool.getId(), ftpConnectionPool);
                Util_Logger.info(logger, "Created FTP connection pool ID : " + ftpConnectionPool.getId());
            }
        }
    }

    @Override
    public pdrConnectionInt getConnection(String string) {
        FtpConnectionPool ftpConnectionPool = this.itsPools.get(Util.noNull(string));
        if (ftpConnectionPool == null) {
            throw new RuntimeException("Unable to borrow FTP connection from pool ID: " + string);
        }
        return new pdrConnectionFtp(ftpConnectionPool.getConnection(), string);
    }

    @Override
    public void freeConnection(pdrConnectionInt pdrConnectionInt2) {
        FtpConnectionPool ftpConnectionPool;
        if (pdrConnectionInt2 != null && (ftpConnectionPool = this.itsPools.get(pdrConnectionInt2.getDataSourceId())) != null) {
            pdrConnectionFtp pdrConnectionFtp2 = (pdrConnectionFtp)pdrConnectionInt2;
            ftpConnectionPool.returnConnection(pdrConnectionFtp2.getConnection());
        }
    }

    @Override
    public void resetPool(String string) {
        FtpConnectionPool ftpConnectionPool = this.itsPools.get(string);
        if (ftpConnectionPool != null) {
            ftpConnectionPool.clearCache();
        }
    }

    @Override
    public void resetPool() {
        for (FtpConnectionPool ftpConnectionPool : this.itsPools.values()) {
            ftpConnectionPool.clearCache();
        }
    }

    @Override
    public void clearDataState() {
    }

    public List<String> getPoolList() {
        if (this.itsPools == null) {
            return null;
        }
        return new ArrayList<String>(this.itsPools.keySet());
    }

    private static class SingletonHolder {
        private static pdrConnectionFactoryFtp instance = new pdrConnectionFactoryFtp();

        private SingletonHolder() {
        }
    }
}

