/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.GoogleAuthResponse;
import au.com.nemmco.Pdr.Batcher.Transport.GoogleBlob;
import au.com.nemmco.Pdr.Batcher.Transport.GoogleDirectoryWrapper;
import au.com.nemmco.Pdr.Batcher.Transport.GoogleOauthToken;
import au.com.nemmco.Pdr.Batcher.Transport.GoogleRequestParameters;
import au.com.nemmco.Pdr.Batcher.Transport.GoogleServiceAccountKeyParameters;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionLocal;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockNone;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.JsonUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrConnectionGoogle
implements pdrConnectionInt {
    private static int OAUTH_TOKEN_MINIMUM_LIFE_MINS = 10;
    private static int OAUTH_TOKEN_RENEW_BEFORE_EXPIRY_MINS = 5;
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionGoogle.class);
    private String itsDataSourceId;
    private String itsServiceAccountKeyFile;
    private String itsServiceAccountKeyContents;
    private String itsBaseURL;
    private String itsCurrentDir;
    private boolean itsGetFileModifiedTime;
    private int itsOAuthTokenExpiryMins;
    private pdrConnectionLocal itsLocal;
    private GoogleOauthToken itsOAuthToken;
    private int itsErrorsBeforeTokenRefresh;
    private WebClient itsWebClient;

    public pdrConnectionGoogle(String string, String string2, String string3, String string4, Proxy proxy, int n2, int n3, boolean bl, int n4, int n5) {
        this.itsDataSourceId = string;
        this.itsServiceAccountKeyFile = string2;
        this.itsServiceAccountKeyContents = string3;
        this.itsBaseURL = string4;
        this.itsGetFileModifiedTime = bl;
        this.itsOAuthTokenExpiryMins = Math.min(n4, OAUTH_TOKEN_MINIMUM_LIFE_MINS);
        this.itsErrorsBeforeTokenRefresh = n5;
        this.itsLocal = new pdrConnectionLocal(string);
        this.itsWebClient = new WebClient(proxy, n2, n3);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Google connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = string;
    }

    private void validateOAuthToken() throws ApplicationException {
        block12: {
            String string = "https://www.googleapis.com/oauth2/v4/token";
            String string2 = "https://www.googleapis.com/auth/cloud-platform";
            HttpURLConnection httpURLConnection = null;
            try {
                String string3;
                boolean bl = false;
                bl = this.itsOAuthToken == null ? true : (this.itsOAuthToken.error_count > 0L ? true : Util.dateOffset(new Date(), OAUTH_TOKEN_RENEW_BEFORE_EXPIRY_MINS, 12).after(this.itsOAuthToken.expiryDate));
                if (!bl) break block12;
                this.itsOAuthToken = null;
                String string4 = this.itsServiceAccountKeyContents;
                if (Util.isBlank(string4)) {
                    if (Util.isBlank(this.itsServiceAccountKeyFile)) {
                        throw new Exception("Missing Google service account key file parameter for access to Google Storage");
                    }
                    if (!Files.exists(Paths.get(this.itsServiceAccountKeyFile, new String[0]), new LinkOption[0])) {
                        throw new Exception("Unable to find Google service account key file " + this.itsServiceAccountKeyFile);
                    }
                    string4 = new String(Files.readAllBytes(Paths.get(this.itsServiceAccountKeyFile, new String[0])));
                }
                if (Util.isBlank(string4)) {
                    throw new Exception("Unable to find Google service account key contents");
                }
                GoogleServiceAccountKeyParameters googleServiceAccountKeyParameters = JsonUtilities.fromJson(string4, GoogleServiceAccountKeyParameters.class);
                GoogleOauthToken googleOauthToken = new GoogleOauthToken();
                Date date = new Date();
                googleOauthToken.expiryDate = Util.dateOffset(date, this.itsOAuthTokenExpiryMins, 12);
                StringBuilder stringBuilder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(googleServiceAccountKeyParameters.private_key));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.startsWith("-")) continue;
                    stringBuilder.append(string3);
                }
                byte[] byArray = Base64.getDecoder().decode(stringBuilder.toString());
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                JwtClaims jwtClaims = new JwtClaims();
                jwtClaims.setSubject(googleServiceAccountKeyParameters.client_email);
                jwtClaims.setIssuer(googleServiceAccountKeyParameters.client_email);
                jwtClaims.setIssuedAt(NumericDate.fromMilliseconds((long)date.getTime()));
                jwtClaims.setExpirationTime(NumericDate.fromMilliseconds((long)googleOauthToken.expiryDate.getTime()));
                jwtClaims.setClaim("scope", (Object)string2);
                jwtClaims.setAudience(string);
                JsonWebSignature jsonWebSignature = new JsonWebSignature();
                jsonWebSignature.setPayload(jwtClaims.toJson());
                jsonWebSignature.setKey((Key)privateKey);
                jsonWebSignature.setAlgorithmHeaderValue("RS256");
                jsonWebSignature.setHeader("typ", "JWT");
                jsonWebSignature.setHeader("kid", googleServiceAccountKeyParameters.private_key_id);
                jsonWebSignature.sign();
                String string5 = jsonWebSignature.getCompactSerialization();
                String string6 = "grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + string5;
                byte[] byArray2 = string6.getBytes();
                GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
                googleRequestParameters.method = "POST";
                googleRequestParameters.content_type = "application/x-www-form-urlencoded";
                googleRequestParameters.content_length = Integer.toString(byArray2.length);
                httpURLConnection = this.getHttpURLConnection(string, googleRequestParameters, false);
                httpURLConnection.getOutputStream().write(byArray2);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    if (httpURLConnection.getContentType().toLowerCase().startsWith("application/json")) {
                        try {
                            String string7 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())).lines().collect(Collectors.joining("\n"));
                            GoogleAuthResponse googleAuthResponse = JsonUtilities.fromJson(string7, GoogleAuthResponse.class);
                            googleOauthToken.access_token = googleAuthResponse.access_token;
                            googleOauthToken.token_type = googleAuthResponse.token_type;
                            this.itsOAuthToken = googleOauthToken;
                            break block12;
                        }
                        catch (Exception exception) {
                            throw new Exception("Error parsing Google oAuth token request response: " + exception.getMessage());
                        }
                    }
                    throw new Exception("Unexpected content type " + httpURLConnection.getContentType() + " from Google oAuth token request");
                }
                String string8 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google oAuth token request, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string8);
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                httpURLConnection = null;
                Util_Logger.error(logger, "Error generating oAuth token: " + exception.getMessage(), exception);
            }
        }
    }

    private HttpsURLConnection getHttpURLConnection(String string, GoogleRequestParameters googleRequestParameters, boolean bl) {
        HttpURLConnection httpURLConnection = null;
        try {
            if (bl) {
                this.validateOAuthToken();
            }
            if (bl && this.itsOAuthToken == null) {
                throw new Exception("Unable to generate request due to missing OAuth token");
            }
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)this.itsWebClient.getHttpURLConnection(googleRequestParameters.method, uRL);
            if (!Util.isBlank(googleRequestParameters.content_type)) {
                httpURLConnection.setRequestProperty("Content-Type", googleRequestParameters.content_type);
            }
            if (!Util.isBlank(googleRequestParameters.content_length)) {
                httpURLConnection.setRequestProperty("Content-Length", googleRequestParameters.content_length);
            }
            if (bl) {
                httpURLConnection.setRequestProperty("Authorization", this.itsOAuthToken.token_type + " " + this.itsOAuthToken.access_token);
            }
            for (Map.Entry<String, String> entry : googleRequestParameters.headers.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private HttpsURLConnection getHttpURLConnection(String string, GoogleRequestParameters googleRequestParameters) {
        return this.getHttpURLConnection(string, googleRequestParameters, true);
    }

    private Date getFileModifiedDate(String string, String string2) throws Exception {
        throw new Exception("Google connection does not support a get modified date operation");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "GET";
            googleRequestParameters.parameters.put("projection", "noacl");
            googleRequestParameters.parameters.put("delimiter", "/");
            String string3 = this.getURL(string, null, googleRequestParameters);
            Util_Logger.debug(logger, "Polling directory: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, googleRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                Object object;
                if (!httpURLConnection.getContentType().toLowerCase().startsWith("application/json")) throw new Exception("Invalid response type " + httpURLConnection.getContentType() + " detected in listFiles");
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())).lines().collect(Collectors.joining("\n"));
                GoogleDirectoryWrapper googleDirectoryWrapper = JsonUtilities.fromJson(string4, GoogleDirectoryWrapper.class);
                if (googleDirectoryWrapper.items != null) {
                    for (GoogleBlob googleBlob : googleDirectoryWrapper.items) {
                        if (googleBlob.name.endsWith("/")) continue;
                        object = googleBlob.name;
                        if (googleBlob.name.lastIndexOf("/") > 0) {
                            object = googleBlob.name.substring(googleBlob.name.lastIndexOf("/") + 1);
                        }
                        FtpFileInfo ftpFileInfo = new FtpFileInfo();
                        ftpFileInfo.setFilename((String)object);
                        ftpFileInfo.setDirectory(string);
                        ftpFileInfo.setModifiedDate(googleBlob.updated, true);
                        ftpFileInfo.setSize(googleBlob.size);
                        ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                        hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
                    }
                }
                if (googleDirectoryWrapper.prefixes != null) {
                    for (String string5 : googleDirectoryWrapper.prefixes) {
                        void var10_19;
                        void var10_17;
                        object = new FtpFileInfo();
                        if (string5.endsWith("/")) {
                            String string6 = string5.substring(0, string5.length() - 1);
                        }
                        if (var10_17.lastIndexOf("/") > 0) {
                            String string7 = var10_17.substring(var10_17.lastIndexOf("/") + 1);
                        }
                        ((FtpFileInfo)object).setFilename((String)var10_19);
                        ((FtpFileInfo)object).setDirectory(string);
                        ((FtpFileInfo)object).setFileType(FtpFileTypeEnum.DIRECTORY);
                        hashMap.put(((FtpFileInfo)object).getFilename(), (FtpFileInfo)object);
                    }
                }
            } else {
                String string8 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google List Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string8);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
            return hashMap;
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from web: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getObjectName(String string, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = Util.getColumns(string, '/');
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray.length > 1) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                if (i2 > 1) {
                    stringBuilder2.append("/");
                }
                stringBuilder2.append(stringArray[i2]);
            }
            stringBuilder2.append("/");
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String getURL(String string, String string2, GoogleRequestParameters googleRequestParameters) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(this.itsBaseURL);
        if (!this.itsBaseURL.endsWith("/")) {
            stringBuilder.append("/");
        }
        if (googleRequestParameters.method.equalsIgnoreCase("POST")) {
            stringBuilder.append("upload/");
        }
        stringBuilder.append("storage/v1/b/");
        String[] stringArray = Util.getColumns(string, '/');
        stringBuilder.append(stringArray[0]);
        stringBuilder.append("/o");
        String string3 = "?";
        if (!Util.isBlank(string2)) {
            stringBuilder.append("/");
            stringBuilder.append(URLEncoder.encode(this.getObjectName(string, string2), "UTF-8"));
        } else if (stringArray.length > 1) {
            stringBuilder.append(string3);
            stringBuilder.append("prefix");
            stringBuilder.append("=");
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuilder.append(stringArray[i2]);
                stringBuilder.append("/");
            }
            string3 = "&";
        }
        if (googleRequestParameters != null) {
            for (Map.Entry<String, String> entry : googleRequestParameters.parameters.entrySet()) {
                stringBuilder.append(string3);
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                string3 = "&";
            }
        }
        Util_Logger.debug(logger, "Constructed Google URL: " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        block14: {
            HttpURLConnection httpURLConnection = null;
            File file = null;
            try {
                GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
                googleRequestParameters.method = "GET";
                googleRequestParameters.parameters.put("alt", "media");
                String string4 = this.getURL(string, string3, googleRequestParameters);
                Util_Logger.debug(logger, "Downloading blob: " + string4);
                httpURLConnection = this.getHttpURLConnection(string4, googleRequestParameters);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        file = new File(string2 + "/" + string3);
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        file.setLastModified(date.getTime());
                        break block14;
                    }
                }
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Get Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    FileUtilities.deleteFile(file);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                if (this.itsOAuthToken != null) {
                    ++this.itsOAuthToken.error_count;
                }
                Util_Logger.error(logger, "Error transferring file " + string3 + " from Google blob: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        block7: {
            HttpURLConnection httpURLConnection = null;
            try {
                byte[] byArray = Files.readAllBytes(Paths.get(string, string2));
                String string4 = Util.getColumns(string3, '/')[0];
                GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
                googleRequestParameters.method = "POST";
                googleRequestParameters.content_length = Integer.toString(byArray.length);
                googleRequestParameters.parameters.put("name", this.getObjectName(string3, string2));
                googleRequestParameters.parameters.put("uploadType", "media");
                String string5 = this.getURL(string4, null, googleRequestParameters);
                Util_Logger.debug(logger, "Putting blob: " + string5);
                httpURLConnection = this.getHttpURLConnection(string5, googleRequestParameters);
                httpURLConnection.getOutputStream().write(byArray);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    if (bl) {
                        this.itsLocal.deleteFile(string, string2);
                    }
                    break block7;
                }
                String string6 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Put Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string6);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                    this.itsOAuthToken = null;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.itsOAuthToken != null) {
                    ++this.itsOAuthToken.error_count;
                }
                Util_Logger.error(logger, "Error putting file " + string2 + " to Google blob: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "DELETE";
            String string3 = this.getURL(string, string2, googleRequestParameters);
            Util_Logger.debug(logger, "Deleting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, googleRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 204) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Delete Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error deleting file " + string2 + " from Google blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Google connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        return new pdrFileLockNone();
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
    }
}

