/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockNone;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrConnectionWeb
implements pdrConnectionInt {
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionWeb.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private String itsCurrentDir;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;
    private boolean itsGetFileModifiedTime;

    public pdrConnectionWeb(String string, String string2, Proxy proxy, int n2, int n3, boolean bl) {
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = 1024;
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
        this.itsGetFileModifiedTime = bl;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Web connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.itsBaseURL + "/" + string;
    }

    private HttpURLConnection getHttpURLConnection(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private void processHttpLine(String string, String string2, Map<String, FtpFileInfo> map) {
        int n2 = 0;
        while (string.indexOf(string2.toUpperCase(), n2) > 0) {
            n2 = string.indexOf(string2.toUpperCase(), n2);
            int n3 = string.indexOf("\"", n2 + 1);
            if (n3 > 0) {
                String string3 = string.substring(n2, n3);
                FtpFileInfo ftpFileInfo = new FtpFileInfo();
                ftpFileInfo.setDirectory(string2);
                ftpFileInfo.setFilename(string3.substring(string2.length() + 1));
                ftpFileInfo.setSize(null);
                if (this.itsGetFileModifiedTime) {
                    ftpFileInfo.setModifiedDate(this.getFileModifiedDate(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename()), true);
                } else {
                    ftpFileInfo.setModifiedDate(null, false);
                }
                ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                map.put(ftpFileInfo.getFilename(), ftpFileInfo);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getFileModifiedDate(String string, String string2) {
        Date date = null;
        HttpURLConnection httpURLConnection = null;
        try {
            String string3 = this.itsBaseURL + "/" + string + "/" + string2;
            httpURLConnection = this.getHttpURLConnection(string3);
            if (httpURLConnection.getResponseCode() == 200) {
                date = new Date(httpURLConnection.getLastModified());
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            date = null;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return date;
    }

    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            String string3 = this.getURL(string, null);
            Util_Logger.debug(logger, "Polling directory: " + string3);
            httpURLConnection = this.getHttpURLConnection(this.getURL(string, null));
            if (!Util.isBlank(httpURLConnection.getContentType())) {
                Util_Logger.debug(logger, "Detected content type: " + httpURLConnection.getContentType());
                if (httpURLConnection.getContentType().toLowerCase().startsWith("text/html")) {
                    String string4;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    while ((string4 = bufferedReader.readLine()) != null) {
                        string4 = string4.toUpperCase();
                        this.processHttpLine(string4, string, hashMap);
                    }
                    bufferedReader.close();
                } else {
                    FtpFileInfo ftpFileInfo = new FtpFileInfo();
                    ftpFileInfo.setDirectory(string.substring(0, string.lastIndexOf("/")));
                    ftpFileInfo.setFilename(string.substring(string.lastIndexOf("/") + 1));
                    ftpFileInfo.setSize(Long.valueOf(httpURLConnection.getContentLength()));
                    ftpFileInfo.setModifiedDate(new Date(httpURLConnection.getLastModified()), true);
                    ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                    hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
                }
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from web: " + exception.getMessage());
        }
        return hashMap;
    }

    private String getURL(String string, String string2) {
        Object object = null;
        object = string.toUpperCase().startsWith("HTTP://") ? string : (string.toUpperCase().startsWith("HTTPS://") ? string : this.itsBaseURL + "/" + string);
        if (!Util.isBlank(string2) && !string.endsWith(string2)) {
            object = (String)object + "/" + string2;
        }
        return object;
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        File file = null;
        HttpURLConnection httpURLConnection = null;
        try {
            long l2;
            int n2;
            httpURLConnection = this.getHttpURLConnection(this.getURL(string, string3));
            file = new File(string2 + "/" + string3);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n3 = 0;
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[this.itsTransferBufferSize];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                n3 += n2;
            }
            inputStream.close();
            outputStream.flush();
            outputStream.close();
            if (!this.itsGetFileModifiedTime && (l2 = httpURLConnection.getLastModified()) > 0L) {
                file.setLastModified(l2);
                date = new Date(l2);
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception4) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring file " + string3 + " from web: " + exception.getMessage());
        }
        return date;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        throw new Exception("Web connection does not support a file put operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        throw new Exception("Web connection does not support a file delete operation");
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsTransferBufferSize = n2;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Web connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        return new pdrFileLockNone();
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
    }
}

